/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Thu Mar  3 12:51:49 2022

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_59 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 31972, "epsg", 31972,
        "SIRGAS 2000 / UTM zone 18N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 18N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "674\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4674\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-75],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"31972\"]]");
    p = add_epsg_def_ex (filter, first, last, 31973, "epsg", 31973,
        "SIRGAS 2000 / UTM zone 19N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 19N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "674\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4674\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-69],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"31973\"]]");
    p = add_epsg_def_ex (filter, first, last, 31974, "epsg", 31974,
        "SIRGAS 2000 / UTM zone 20N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 20N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "674\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4674\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-63],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"31974\"]]");
    p = add_epsg_def_ex (filter, first, last, 31975, "epsg", 31975,
        "SIRGAS 2000 / UTM zone 21N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 21N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "674\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4674\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-57],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"31975\"]]");
    p = add_epsg_def_ex (filter, first, last, 31976, "epsg", 31976,
        "SIRGAS 2000 / UTM zone 22N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 22N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "674\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4674\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-51],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"31976\"]]");
    p = add_epsg_def_ex (filter, first, last, 31977, "epsg", 31977,
        "SIRGAS 2000 / UTM zone 17S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 17S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "674\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4674\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-81],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"31977\"]]");
    p = add_epsg_def_ex (filter, first, last, 31978, "epsg", 31978,
        "SIRGAS 2000 / UTM zone 18S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 18S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "674\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4674\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-75],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"31978\"]]");
    p = add_epsg_def_ex (filter, first, last, 31979, "epsg", 31979,
        "SIRGAS 2000 / UTM zone 19S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 19S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "674\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4674\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-69],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"31979\"]]");
    p = add_epsg_def_ex (filter, first, last, 31980, "epsg", 31980,
        "SIRGAS 2000 / UTM zone 20S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 20S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "674\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4674\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-63],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"31980\"]]");
    p = add_epsg_def_ex (filter, first, last, 31981, "epsg", 31981,
        "SIRGAS 2000 / UTM zone 21S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 21S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "674\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4674\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-57],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"31981\"]]");
    p = add_epsg_def_ex (filter, first, last, 31982, "epsg", 31982,
        "SIRGAS 2000 / UTM zone 22S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 22S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "674\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4674\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-51],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"31982\"]]");
    p = add_epsg_def_ex (filter, first, last, 31983, "epsg", 31983,
        "SIRGAS 2000 / UTM zone 23S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 23S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "674\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4674\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-45],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"31983\"]]");
    p = add_epsg_def_ex (filter, first, last, 31984, "epsg", 31984,
        "SIRGAS 2000 / UTM zone 24S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 24S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "674\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4674\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-39],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"31984\"]]");
    p = add_epsg_def_ex (filter, first, last, 31985, "epsg", 31985,
        "SIRGAS 2000 / UTM zone 25S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 25S\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "674\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4674\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-33],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"31985\"]]");
    p = add_epsg_def_ex (filter, first, last, 31986, "epsg", 31986,
        "SIRGAS 1995 / UTM zone 17N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 17N\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6170\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4170\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",0],PARAMETER[\"central_meridian\",-81],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"31986\"]]");
    p = add_epsg_def_ex (filter, first, last, 31987, "epsg", 31987,
        "SIRGAS 1995 / UTM zone 18N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 18N\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6170\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4170\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",0],PARAMETER[\"central_meridian\",-75],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"31987\"]]");
    p = add_epsg_def_ex (filter, first, last, 31988, "epsg", 31988,
        "SIRGAS 1995 / UTM zone 19N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 19N\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6170\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4170\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",0],PARAMETER[\"central_meridian\",-69],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"31988\"]]");
    p = add_epsg_def_ex (filter, first, last, 31989, "epsg", 31989,
        "SIRGAS 1995 / UTM zone 20N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 20N\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6170\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4170\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",0],PARAMETER[\"central_meridian\",-63],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"31989\"]]");
    p = add_epsg_def_ex (filter, first, last, 31990, "epsg", 31990,
        "SIRGAS 1995 / UTM zone 21N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 21N\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6170\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4170\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",0],PARAMETER[\"central_meridian\",-57],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"31990\"]]");
    p = add_epsg_def_ex (filter, first, last, 31991, "epsg", 31991,
        "SIRGAS 1995 / UTM zone 22N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 22N\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6170\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4170\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",0],PARAMETER[\"central_meridian\",-51],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"31991\"]]");
    p = add_epsg_def_ex (filter, first, last, 31992, "epsg", 31992,
        "SIRGAS 1995 / UTM zone 17S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 17S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6170\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4170\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",0],PARAMETER[\"central_meridian\",-81],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"31992\"]]");
    p = add_epsg_def_ex (filter, first, last, 31993, "epsg", 31993,
        "SIRGAS 1995 / UTM zone 18S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 18S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6170\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4170\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",0],PARAMETER[\"central_meridian\",-75],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"31993\"]]");
    p = add_epsg_def_ex (filter, first, last, 31994, "epsg", 31994,
        "SIRGAS 1995 / UTM zone 19S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 19S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6170\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4170\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",0],PARAMETER[\"central_meridian\",-69],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"31994\"]]");
    p = add_epsg_def_ex (filter, first, last, 31995, "epsg", 31995,
        "SIRGAS 1995 / UTM zone 20S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 20S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6170\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4170\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",0],PARAMETER[\"central_meridian\",-63],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"31995\"]]");
    p = add_epsg_def_ex (filter, first, last, 31996, "epsg", 31996,
        "SIRGAS 1995 / UTM zone 21S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 21S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6170\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4170\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",0],PARAMETER[\"central_meridian\",-57],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"31996\"]]");
    p = add_epsg_def_ex (filter, first, last, 31997, "epsg", 31997,
        "SIRGAS 1995 / UTM zone 22S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 22S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6170\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4170\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",0],PARAMETER[\"central_meridian\",-51],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"31997\"]]");
    p = add_epsg_def_ex (filter, first, last, 31998, "epsg", 31998,
        "SIRGAS 1995 / UTM zone 23S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 23S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6170\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4170\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",0],PARAMETER[\"central_meridian\",-45],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"31998\"]]");
    p = add_epsg_def_ex (filter, first, last, 31999, "epsg", 31999,
        "SIRGAS 1995 / UTM zone 24S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 24S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6170\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4170\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",0],PARAMETER[\"central_meridian\",-39],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"31999\"]]");
    p = add_epsg_def_ex (filter, first, last, 32000, "epsg", 32000,
        "SIRGAS 1995 / UTM zone 25S", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 25S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6170\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4170\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",0],PARAMETER[\"central_meridian\",-33],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32000\"]]");
    p = add_epsg_def_ex (filter, first, last, 32001, "epsg", 32001,
        "NAD27 / Montana North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.71666666666667 +lat_2=47.85 +lat_0=4");
    add_proj4text (p, 1,
        "7 +lon_0=-109.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD");
    add_proj4text (p, 2,
        "27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Montana North\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"latitude_of_origin\",47],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",-109.5],PARAMETER[\"standard_parallel_1\",48.71");
    add_srs_wkt (p, 9,
        "66666666667],PARAMETER[\"standard_parallel_2\",47.85],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",2000000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0],UNIT[\"US survey foot\",0.304800609601219,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"32001\"]]");
    p = add_epsg_def_ex (filter, first, last, 32002, "epsg", 32002,
        "NAD27 / Montana Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.88333333333333 +lat_2=46.45 +lat_0=4");
    add_proj4text (p, 1,
        "5.83333333333334 +lon_0=-109.5 +x_0=609601.2192024384 +y");
    add_proj4text (p, 2,
        "_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Montana Central\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",45.8333333333333],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-109.5],PARAMETER[\"standard_p");
    add_srs_wkt (p, 9,
        "arallel_1\",47.8833333333333],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 10,
        "lel_2\",46.45],PARAMETER[\"false_easting\",2000000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 12,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "32002\"]]");
    p = add_epsg_def_ex (filter, first, last, 32003, "epsg", 32003,
        "NAD27 / Montana South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.4 +lat_2=44.86666666666667 +lat_0=44");
    add_proj4text (p, 1,
        " +lon_0=-109.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD2");
    add_proj4text (p, 2,
        "7 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Montana South\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"latitude_of_origin\",44],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",-109.5],PARAMETER[\"standard_parallel_1\",46.4]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_2\",44.8666666666667],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",2000000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"32003\"]]");
    p = add_epsg_def_ex (filter, first, last, 32005, "epsg", 32005,
        "NAD27 / Nebraska North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.85 +lat_2=42.81666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "1.33333333333334 +lon_0=-100 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nebraska North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",41.3333333333333],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-100],PARAMETER[\"standard_para");
    add_srs_wkt (p, 9,
        "llel_1\",41.85],PARAMETER[\"standard_parallel_2\",42.816");
    add_srs_wkt (p, 10,
        "6666666667],PARAMETER[\"false_easting\",2000000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"US survey foot\",0.30480");
    add_srs_wkt (p, 12,
        "0609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"320");
    add_srs_wkt (p, 14,
        "05\"]]");
    p = add_epsg_def_ex (filter, first, last, 32006, "epsg", 32006,
        "NAD27 / Nebraska South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.28333333333333 +lat_2=41.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=39.66666666666666 +lon_0=-99.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nebraska South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",39.6666666666667],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-99.5],PARAMETER[\"standard_par");
    add_srs_wkt (p, 9,
        "allel_1\",40.2833333333333],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 10,
        "l_2\",41.7166666666667],PARAMETER[\"false_easting\",2000");
    add_srs_wkt (p, 11,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"US survey fo");
    add_srs_wkt (p, 12,
        "ot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"32006\"]]");
    p = add_epsg_def_ex (filter, first, last, 32007, "epsg", 32007,
        "NAD27 / Nevada East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nevada East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",34.75],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-115.583333333333],PARAMETER[\"scale_factor\",0.9999]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",0],UNIT[\"US survey foot\",0.304800609601219,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32007\"]]");
    p = add_epsg_def_ex (filter, first, last, 32008, "epsg", 32008,
        "NAD27 / Nevada Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nevada Central\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",34.75],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-116.666666666667],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "99],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 11,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32008\"]]");
    p = add_epsg_def_ex (filter, first, last, 32009, "epsg", 32009,
        "NAD27 / Nevada West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nevada West\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",34.75],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-118.583333333333],PARAMETER[\"scale_factor\",0.9999]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",0],UNIT[\"US survey foot\",0.304800609601219,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32009\"]]");
    p = add_epsg_def_ex (filter, first, last, 32010, "epsg", 32010,
        "NAD27 / New Hampshire", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Hampshire\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",42.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-71.6666666666667],PARAMETER[\"scale_factor\",0.9999666");
    add_srs_wkt (p, 9,
        "67],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 11,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32010\"]]");
    p = add_epsg_def_ex (filter, first, last, 32011, "epsg", 32011,
        "NAD27 / New Jersey", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.66666666");
    add_proj4text (p, 1,
        "666667 +k=0.9999749999999999 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Jersey\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "67\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",38.8333333333333],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-74.6666666666667],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.999975],PARAMETER[\"false_easting\",2000000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 11,
        "00609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "2011\"]]");
    p = add_epsg_def_ex (filter, first, last, 32012, "epsg", 32012,
        "NAD27 / New Mexico East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999");
    add_proj4text (p, 1,
        "909091 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Mexico East\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",31],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 8,
        "n\",-104.333333333333],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "09091],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"US survey foot\",0.30480060960");
    add_srs_wkt (p, 11,
        "1219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32012\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 32013, "epsg", 32013,
        "NAD27 / New Mexico Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=1524");
    add_proj4text (p, 1,
        "00.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Mexico Central\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",31],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-106.25],PARAMETER[\"scale_factor\",0.9999],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"US survey foot\",0.304800609601219,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"32013\"]]");
    p = add_epsg_def_ex (filter, first, last, 32014, "epsg", 32014,
        "NAD27 / New Mexico West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999");
    add_proj4text (p, 1,
        "916667 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Mexico West\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",31],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 8,
        "n\",-107.833333333333],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "16667],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"US survey foot\",0.30480060960");
    add_srs_wkt (p, 11,
        "1219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32014\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 32015, "epsg", 32015,
        "NAD27 / New York East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-74.33333333333333 +k=0.999");
    add_proj4text (p, 1,
        "966667 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New York East\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",40],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-74.3333333333333],PARAMETER[\"scale_factor\",0.99996666");
    add_srs_wkt (p, 9,
        "7],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32015\"]]");
    p = add_epsg_def_ex (filter, first, last, 32016, "epsg", 32016,
        "NAD27 / New York Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.999");
    add_proj4text (p, 1,
        "9375 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New York Central\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",40],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 8,
        "n\",-76.5833333333333],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "375],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 11,
        "19,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32016\"]]");
    p = add_epsg_def_ex (filter, first, last, 32017, "epsg", 32017,
        "NAD27 / New York West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.999");
    add_proj4text (p, 1,
        "9375 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New York West\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",40],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-78.5833333333333],PARAMETER[\"scale_factor\",0.9999375]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",0],UNIT[\"US survey foot\",0.304800609601219,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32017\"]]");
    p = add_epsg_def_ex (filter, first, last, 32018, "epsg", 32018,
        "NAD27 / New York Long Island (deprecated)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=40.5 +lon_0=-74 +x_0=304800.6096012192 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New York Long Island (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD27\",DATUM[\"North_American_Datum_1927\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"Clarke 1866\",6378206.4,294.978698213898,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",40.5]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-74],PARAMETER[\"standar");
    add_srs_wkt (p, 9,
        "d_parallel_1\",41.0333333333333],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 10,
        "rallel_2\",40.6666666666667],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",1000000],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 12,
        "ey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 14,
        "ITY[\"EPSG\",\"32018\"]]");
    p = add_epsg_def_ex (filter, first, last, 32019, "epsg", 32019,
        "NAD27 / North Carolina", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.33333333333334 +lat_2=36.16666666666");
    add_proj4text (p, 1,
        "666 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / North Carolina\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",33.75],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-79],PARAMETER[\"standard_parallel_1\",34.");
    add_srs_wkt (p, 9,
        "3333333333333],PARAMETER[\"standard_parallel_2\",36.1666");
    add_srs_wkt (p, 10,
        "666666667],PARAMETER[\"false_easting\",2000000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"320");
    add_srs_wkt (p, 14,
        "19\"]]");
    p = add_epsg_def_ex (filter, first, last, 32020, "epsg", 32020,
        "NAD27 / North Dakota North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.43333333333333 +lat_2=48.73333333333");
    add_proj4text (p, 1,
        "333 +lat_0=47 +lon_0=-100.5 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / North Dakota North\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",47],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-100.5],PARAMETER[\"standard_parallel_1\",");
    add_srs_wkt (p, 9,
        "47.4333333333333],PARAMETER[\"standard_parallel_2\",48.7");
    add_srs_wkt (p, 10,
        "333333333333],PARAMETER[\"false_easting\",2000000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 12,
        "800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 13,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "32020\"]]");
    p = add_epsg_def_ex (filter, first, last, 32021, "epsg", 32021,
        "NAD27 / North Dakota South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.18333333333333 +lat_2=47.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / North Dakota South\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",45.6666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-100.5],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_1\",46.1833333333333],PARAMETER[\"standard_par");
    add_srs_wkt (p, 10,
        "allel_2\",47.4833333333333],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "2000000],PARAMETER[\"false_northing\",0],UNIT[\"US surve");
    add_srs_wkt (p, 12,
        "y foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"32021\"]]");
    p = add_epsg_def_ex (filter, first, last, 32022, "epsg", 32022,
        "NAD27 / Ohio North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.43333333333333 +lat_2=41.7 +lat_0=39");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-82.5 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Ohio North\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "67\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",39.6666666666667],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-82.5],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 9,
        "l_1\",40.4333333333333],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 10,
        ",41.7],PARAMETER[\"false_easting\",2000000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 12,
        "01219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32022\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32023, "epsg", 32023,
        "NAD27 / Ohio South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.73333333333333 +lat_2=40.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=38 +lon_0=-82.5 +x_0=609601.2192024384 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Ohio South\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "67\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",38],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-82.5],PARAMETER[\"standard_parallel_1\",38.73333");
    add_srs_wkt (p, 9,
        "33333333],PARAMETER[\"standard_parallel_2\",40.033333333");
    add_srs_wkt (p, 10,
        "3333],PARAMETER[\"false_easting\",2000000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",0],UNIT[\"US survey foot\",0.30480060960");
    add_srs_wkt (p, 12,
        "1219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32023\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 32024, "epsg", 32024,
        "NAD27 / Oklahoma North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.56666666666667 +lat_2=36.76666666666");
    add_proj4text (p, 1,
        "667 +lat_0=35 +lon_0=-98 +x_0=609601.2192024384 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Oklahoma North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",35],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-98],PARAMETER[\"standard_parallel_1\",35.566");
    add_srs_wkt (p, 9,
        "6666666667],PARAMETER[\"standard_parallel_2\",36.7666666");
    add_srs_wkt (p, 10,
        "666667],PARAMETER[\"false_easting\",2000000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 12,
        "01219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32024\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32025, "epsg", 32025,
        "NAD27 / Oklahoma South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.93333333333333 +lat_2=35.23333333333");
    add_proj4text (p, 1,
        "333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Oklahoma South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",33.3333333333333],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-98],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_1\",33.9333333333333],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 10,
        "2\",35.2333333333333],PARAMETER[\"false_easting\",200000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot");
    add_srs_wkt (p, 12,
        "\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"32025\"]]");
    p = add_epsg_def_ex (filter, first, last, 32026, "epsg", 32026,
        "NAD27 / Oregon North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.33333333333334 +lat_2=46 +lat_0=43.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Oregon North\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",43.6666666666667],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-120.5],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_1\",44.3333333333333],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 10,
        "2\",46],PARAMETER[\"false_easting\",2000000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 12,
        "01219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32026\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32027, "epsg", 32027,
        "NAD27 / Oregon South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.33333333333334 +lat_2=44 +lat_0=41.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Oregon South\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",41.6666666666667],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-120.5],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_1\",42.3333333333333],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 10,
        "2\",44],PARAMETER[\"false_easting\",2000000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 12,
        "01219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32027\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 32028, "epsg", 32028,
        "NAD27 / Pennsylvania North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.88333333333333 +lat_2=41.95 +lat_0=4");
    add_proj4text (p, 1,
        "0.16666666666666 +lon_0=-77.75 +x_0=609601.2192024384 +y");
    add_proj4text (p, 2,
        "_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Pennsylvania North\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",40.1666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-77.75],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_1\",40.8833333333333],PARAMETER[\"standard_par");
    add_srs_wkt (p, 10,
        "allel_2\",41.95],PARAMETER[\"false_easting\",2000000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 12,
        "304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Eas");
    add_srs_wkt (p, 13,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"32028\"]]");
    p = add_epsg_def_ex (filter, first, last, 32029, "epsg", 32029,
        "NAD27 / Pennsylvania South (deprecated)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.93333333333333 +lat_2=40.8 +lat_0=39");
    add_proj4text (p, 1,
        ".33333333333334 +lon_0=-77.75 +x_0=609601.2192024384 +y_");
    add_proj4text (p, 2,
        "0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Pennsylvania South (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Clarke 1866\",6378206.4,294.978698213898,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",39.33333");
    add_srs_wkt (p, 8,
        "33333333],PARAMETER[\"central_meridian\",-77.75],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_1\",39.9333333333333],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",40.8],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "2000000],PARAMETER[\"false_northing\",0],UNIT[\"US surve");
    add_srs_wkt (p, 12,
        "y foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"32029\"]]");
    p = add_epsg_def_ex (filter, first, last, 32030, "epsg", 32030,
        "NAD27 / Rhode Island", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.9");
    add_proj4text (p, 1,
        "999938 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Rhode Island\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",41.0833333333333],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-71.5],PARAMETER[\"scale_factor\",0.999993");
    add_srs_wkt (p, 9,
        "8],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32030\"]]");
    p = add_epsg_def_ex (filter, first, last, 32031, "epsg", 32031,
        "NAD27 / South Carolina North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.76666666666667 +lat_2=34.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=33 +lon_0=-81 +x_0=609601.2192024384 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / South Carolina North\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",33],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",-81],PARAMETER[\"standard_parallel_1\",3");
    add_srs_wkt (p, 9,
        "3.7666666666667],PARAMETER[\"standard_parallel_2\",34.96");
    add_srs_wkt (p, 10,
        "66666666667],PARAMETER[\"false_easting\",2000000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 12,
        "00609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 14,
        "2031\"]]");
    p = add_epsg_def_ex (filter, first, last, 32033, "epsg", 32033,
        "NAD27 / South Carolina South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.33333333333334 +lat_2=33.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=31.83333333333333 +lon_0=-81 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / South Carolina South\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",31.8333333333333],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-81],PARAMETER[\"standard_");
    add_srs_wkt (p, 9,
        "parallel_1\",32.3333333333333],PARAMETER[\"standard_para");
    add_srs_wkt (p, 10,
        "llel_2\",33.6666666666667],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 11,
        "000000],PARAMETER[\"false_northing\",0],UNIT[\"US survey");
    add_srs_wkt (p, 12,
        " foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 14,
        "Y[\"EPSG\",\"32033\"]]");
    p = add_epsg_def_ex (filter, first, last, 32034, "epsg", 32034,
        "NAD27 / South Dakota North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.41666666666666 +lat_2=45.68333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43.83333333333334 +lon_0=-100 +x_0=609601.219");
    add_proj4text (p, 2,
        "2024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / South Dakota North\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",43.8333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-100],PARAMETER[\"standard_p");
    add_srs_wkt (p, 9,
        "arallel_1\",44.4166666666667],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 10,
        "lel_2\",45.6833333333333],PARAMETER[\"false_easting\",20");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"US survey ");
    add_srs_wkt (p, 12,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"32034\"]]");
    p = add_epsg_def_ex (filter, first, last, 32035, "epsg", 32035,
        "NAD27 / South Dakota South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.83333333333334 +lat_2=44.4 +lat_0=42");
    add_proj4text (p, 1,
        ".33333333333334 +lon_0=-100.3333333333333 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / South Dakota South\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",42.3333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-100.333333333333],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_1\",42.8333333333333],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "tandard_parallel_2\",44.4],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 11,
        "000000],PARAMETER[\"false_northing\",0],UNIT[\"US survey");
    add_srs_wkt (p, 12,
        " foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 14,
        "Y[\"EPSG\",\"32035\"]]");
    p = add_epsg_def_ex (filter, first, last, 32036, "epsg", 32036,
        "NAD27 / Tennessee (deprecated)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.25 +lat_2=36.41666666666666 +lat_0=3");
    add_proj4text (p, 1,
        "4.66666666666666 +lon_0=-86 +x_0=30480.06096012192 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Tennessee (deprecated)\",GEOGCS[\"NAD27");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 2,
        " 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 7,
        "SP\"],PARAMETER[\"latitude_of_origin\",34.6666666666667]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-86],PARAMETER[\"standar");
    add_srs_wkt (p, 9,
        "d_parallel_1\",35.25],PARAMETER[\"standard_parallel_2\",");
    add_srs_wkt (p, 10,
        "36.4166666666667],PARAMETER[\"false_easting\",100000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 12,
        "304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Eas");
    add_srs_wkt (p, 13,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"32036\"]]");
    p = add_epsg_def_ex (filter, first, last, 32037, "epsg", 32037,
        "NAD27 / Texas North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.65 +lat_2=36.18333333333333 +lat_0=3");
    add_proj4text (p, 1,
        "4 +lon_0=-101.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD");
    add_proj4text (p, 2,
        "27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Texas North\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",34],PARAMETER[\"central_mer");
    add_srs_wkt (p, 8,
        "idian\",-101.5],PARAMETER[\"standard_parallel_1\",34.65]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_2\",36.1833333333333],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",2000000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"32037\"]]");
    p = add_epsg_def_ex (filter, first, last, 32038, "epsg", 32038,
        "NAD27 / Texas North Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.13333333333333 +lat_2=33.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=31.66666666666667 +lon_0=-97.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Texas North Central\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",31.6666666666667],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-97.5],PARAMETER[\"standar");
    add_srs_wkt (p, 9,
        "d_parallel_1\",32.1333333333333],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 10,
        "rallel_2\",33.9666666666667],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 12,
        "ey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 14,
        "ITY[\"EPSG\",\"32038\"]]");
    p = add_epsg_def_ex (filter, first, last, 32039, "epsg", 32039,
        "NAD27 / Texas Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.11666666666667 +lat_2=31.88333333333");
    add_proj4text (p, 1,
        "333 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +");
    add_proj4text (p, 2,
        "x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Texas Central\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"latitude_of_origin\",29.6666666666667],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",-100.333333333333],PARAMETER[\"st");
    add_srs_wkt (p, 9,
        "andard_parallel_1\",30.1166666666667],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_2\",31.8833333333333],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US");
    add_srs_wkt (p, 12,
        " survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "03\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"32039\"]]");
    p = add_epsg_def_ex (filter, first, last, 32040, "epsg", 32040,
        "NAD27 / Texas South Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=28.38333333333333 +lat_2=30.28333333333");
    add_proj4text (p, 1,
        "333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Texas South Central\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",27.8333333333333],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-99],PARAMETER[\"standard_");
    add_srs_wkt (p, 9,
        "parallel_1\",28.3833333333333],PARAMETER[\"standard_para");
    add_srs_wkt (p, 10,
        "llel_2\",30.2833333333333],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 11,
        "000000],PARAMETER[\"false_northing\",0],UNIT[\"US survey");
    add_srs_wkt (p, 12,
        " foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 14,
        "Y[\"EPSG\",\"32040\"]]");
    p = add_epsg_def_ex (filter, first, last, 32041, "epsg", 32041,
        "NAD27 / Texas South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26.16666666666667 +lat_2=27.83333333333");
    add_proj4text (p, 1,
        "333 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Texas South\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",25.6666666666667],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-98.5],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 9,
        "el_1\",26.1666666666667],PARAMETER[\"standard_parallel_2");
    add_srs_wkt (p, 10,
        "\",27.8333333333333],PARAMETER[\"false_easting\",2000000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"32041\"]]");
    p = add_epsg_def_ex (filter, first, last, 32042, "epsg", 32042,
        "NAD27 / Utah North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.71666666666667 +lat_2=41.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Utah North\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "67\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",40.3333333333333],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-111.5],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 9,
        "el_1\",40.7166666666667],PARAMETER[\"standard_parallel_2");
    add_srs_wkt (p, 10,
        "\",41.7833333333333],PARAMETER[\"false_easting\",2000000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"32042\"]]");
    p = add_epsg_def_ex (filter, first, last, 32043, "epsg", 32043,
        "NAD27 / Utah Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.01666666666667 +lat_2=40.65 +lat_0=3");
    add_proj4text (p, 1,
        "8.33333333333334 +lon_0=-111.5 +x_0=609601.2192024384 +y");
    add_proj4text (p, 2,
        "_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Utah Central\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",38.3333333333333],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-111.5],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_1\",39.0166666666667],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 10,
        "2\",40.65],PARAMETER[\"false_easting\",2000000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"320");
    add_srs_wkt (p, 14,
        "43\"]]");
    p = add_epsg_def_ex (filter, first, last, 32044, "epsg", 32044,
        "NAD27 / Utah South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.21666666666667 +lat_2=38.35 +lat_0=3");
    add_proj4text (p, 1,
        "6.66666666666666 +lon_0=-111.5 +x_0=609601.2192024384 +y");
    add_proj4text (p, 2,
        "_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Utah South\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "67\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",36.6666666666667],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-111.5],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 9,
        "el_1\",37.2166666666667],PARAMETER[\"standard_parallel_2");
    add_srs_wkt (p, 10,
        "\",38.35],PARAMETER[\"false_easting\",2000000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"US survey foot\",0.3048006");
    add_srs_wkt (p, 12,
        "09601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3204");
    add_srs_wkt (p, 14,
        "4\"]]");
    p = add_epsg_def_ex (filter, first, last, 32045, "epsg", 32045,
        "NAD27 / Vermont", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0");
    add_proj4text (p, 1,
        "=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Vermont\",GEOGCS[\"NAD27\",DATUM[\"Nort");
    add_srs_wkt (p, 1,
        "h_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378206");
    add_srs_wkt (p, 2,
        ".4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4267\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",42.5],PARAMETER[\"central_meridian\",-72");
    add_srs_wkt (p, 8,
        ".5],PARAMETER[\"scale_factor\",0.999964286],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"32045\"]]");
    p = add_epsg_def_ex (filter, first, last, 32046, "epsg", 32046,
        "NAD27 / Virginia North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.03333333333333 +lat_2=39.2 +lat_0=37");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-78.5 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Virginia North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",37.6666666666667],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-78.5],PARAMETER[\"standard_par");
    add_srs_wkt (p, 9,
        "allel_1\",38.0333333333333],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 10,
        "l_2\",39.2],PARAMETER[\"false_easting\",2000000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"US survey foot\",0.30480");
    add_srs_wkt (p, 12,
        "0609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"320");
    add_srs_wkt (p, 14,
        "46\"]]");
    p = add_epsg_def_ex (filter, first, last, 32047, "epsg", 32047,
        "NAD27 / Virginia South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.76666666666667 +lat_2=37.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Virginia South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",36.3333333333333],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-78.5],PARAMETER[\"standard_par");
    add_srs_wkt (p, 9,
        "allel_1\",36.7666666666667],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 10,
        "l_2\",37.9666666666667],PARAMETER[\"false_easting\",2000");
    add_srs_wkt (p, 11,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"US survey fo");
    add_srs_wkt (p, 12,
        "ot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"32047\"]]");
    p = add_epsg_def_ex (filter, first, last, 32048, "epsg", 32048,
        "NAD27 / Washington North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.5 +lat_2=48.73333333333333 +lat_0=47");
    add_proj4text (p, 1,
        " +lon_0=-120.8333333333333 +x_0=609601.2192024384 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Washington North\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",47],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-120.833333333333],PARAMETER[\"standard_para");
    add_srs_wkt (p, 9,
        "llel_1\",47.5],PARAMETER[\"standard_parallel_2\",48.7333");
    add_srs_wkt (p, 10,
        "333333333],PARAMETER[\"false_easting\",2000000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"320");
    add_srs_wkt (p, 14,
        "48\"]]");
    p = add_epsg_def_ex (filter, first, last, 32049, "epsg", 32049,
        "NAD27 / Washington South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.83333333333334 +lat_2=47.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Washington South\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",45.3333333333333],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-120.5],PARAMETER[\"standard_p");
    add_srs_wkt (p, 9,
        "arallel_1\",45.8333333333333],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 10,
        "lel_2\",47.3333333333333],PARAMETER[\"false_easting\",20");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"US survey ");
    add_srs_wkt (p, 12,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"32049\"]]");
    p = add_epsg_def_ex (filter, first, last, 32050, "epsg", 32050,
        "NAD27 / West Virginia North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39 +lat_2=40.25 +lat_0=38.5 +lon_0=-79.");
    add_proj4text (p, 1,
        "5 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-f");
    add_proj4text (p, 2,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / West Virginia North\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",38.5],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-79.5],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 9,
        "\",39],PARAMETER[\"standard_parallel_2\",40.25],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",2000000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"32050\"]]");
    p = add_epsg_def_ex (filter, first, last, 32051, "epsg", 32051,
        "NAD27 / West Virginia South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.48333333333333 +lat_2=38.88333333333");
    add_proj4text (p, 1,
        "333 +lat_0=37 +lon_0=-81 +x_0=609601.2192024384 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / West Virginia South\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",37],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",-81],PARAMETER[\"standard_parallel_1\",3");
    add_srs_wkt (p, 9,
        "7.4833333333333],PARAMETER[\"standard_parallel_2\",38.88");
    add_srs_wkt (p, 10,
        "33333333333],PARAMETER[\"false_easting\",2000000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 12,
        "00609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 14,
        "2051\"]]");
    p = add_epsg_def_ex (filter, first, last, 32052, "epsg", 32052,
        "NAD27 / Wisconsin North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.56666666666667 +lat_2=46.76666666666");
    add_proj4text (p, 1,
        "667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wisconsin North\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",45.1666666666667],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-90],PARAMETER[\"standard_para");
    add_srs_wkt (p, 9,
        "llel_1\",45.5666666666667],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 10,
        "_2\",46.7666666666667],PARAMETER[\"false_easting\",20000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"US survey foo");
    add_srs_wkt (p, 12,
        "t\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 13,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"32052\"]]");
    p = add_epsg_def_ex (filter, first, last, 32053, "epsg", 32053,
        "NAD27 / Wisconsin Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.25 +lat_2=45.5 +lat_0=43.83333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-90 +x_0=609601.2192024384 +y_0=0 +datum=NAD2");
    add_proj4text (p, 2,
        "7 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wisconsin Central\",GEOGCS[\"NAD27\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866");
    add_srs_wkt (p, 2,
        "\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",43.8333333333333],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-90],PARAMETER[\"standard_para");
    add_srs_wkt (p, 9,
        "llel_1\",44.25],PARAMETER[\"standard_parallel_2\",45.5],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",2000000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"US survey foot\",0.304800609601219,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32053\"]]");
    p = add_epsg_def_ex (filter, first, last, 32054, "epsg", 32054,
        "NAD27 / Wisconsin South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.73333333333333 +lat_2=44.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=42 +lon_0=-90 +x_0=609601.2192024384 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wisconsin South\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",42],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-90],PARAMETER[\"standard_parallel_1\",42.73");
    add_srs_wkt (p, 9,
        "33333333333],PARAMETER[\"standard_parallel_2\",44.066666");
    add_srs_wkt (p, 10,
        "6666667],PARAMETER[\"false_easting\",2000000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 12,
        "9601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32054");
    add_srs_wkt (p, 14,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 32055, "epsg", 32055,
        "NAD27 / Wyoming East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.66666666666666 +lon_0=-105.1666666");
    add_proj4text (p, 1,
        "666667 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +dat");
    add_proj4text (p, 2,
        "um=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wyoming East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",40.6666666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-105.166666666667],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.999941177],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 11,
        "04800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"32055\"]]");
    p = add_epsg_def_ex (filter, first, last, 32056, "epsg", 32056,
        "NAD27 / Wyoming East Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.66666666666666 +lon_0=-107.3333333");
    add_proj4text (p, 1,
        "333333 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +dat");
    add_proj4text (p, 2,
        "um=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wyoming East Central\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",40.6666666666667],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-107.333333333333],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",0.999941177],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"US survey fo");
    add_srs_wkt (p, 11,
        "ot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"32056\"]]");
    p = add_epsg_def_ex (filter, first, last, 32057, "epsg", 32057,
        "NAD27 / Wyoming West Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.66666666666666 +lon_0=-108.75 +k=0");
    add_proj4text (p, 1,
        ".999941177 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +u");
    add_proj4text (p, 2,
        "nits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wyoming West Central\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",40.6666666666667],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-108.75],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.999941177],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 11,
        "00609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "2057\"]]");
    p = add_epsg_def_ex (filter, first, last, 32058, "epsg", 32058,
        "NAD27 / Wyoming West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.66666666666666 +lon_0=-110.0833333");
    add_proj4text (p, 1,
        "333333 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +dat");
    add_proj4text (p, 2,
        "um=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wyoming West\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",40.6666666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-110.083333333333],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.999941177],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 11,
        "04800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"32058\"]]");
    p = add_epsg_def_ex (filter, first, last, 32061, "epsg", 32061,
        "NAD27 / Guatemala Norte (deprecated)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=16.81666666666667 +lat_0=16.81666666666");
    add_proj4text (p, 1,
        "667 +lon_0=-90.33333333333333 +k_0=0.99992226 +x_0=50000");
    add_proj4text (p, 2,
        "0 +y_0=292209.579 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Guatemala Norte (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"C");
    add_srs_wkt (p, 2,
        "larke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 7,
        "onic_1SP\"],PARAMETER[\"latitude_of_origin\",16.81666666");
    add_srs_wkt (p, 8,
        "66667],PARAMETER[\"central_meridian\",-90.3333333333333]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.99992226],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",500000],PARAMETER[\"false_northing\",292209.");
    add_srs_wkt (p, 11,
        "579],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"32061\"]]");
    p = add_epsg_def_ex (filter, first, last, 32062, "epsg", 32062,
        "NAD27 / Guatemala Sur (deprecated)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=14.9 +lat_0=14.9 +lon_0=-90.33333333333");
    add_proj4text (p, 1,
        "333 +k_0=0.99989906 +x_0=500000 +y_0=325992.681 +datum=N");
    add_proj4text (p, 2,
        "AD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Guatemala Sur (deprecated)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD27\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Cl");
    add_srs_wkt (p, 2,
        "arke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_1SP\"],PARAMETER[\"latitude_of_origin\",14.9],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",-90.3333333333333],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.99989906],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",325992.681],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32062");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 32064, "epsg", 32064,
        "NAD27 / BLM 14N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-99 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 14N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-99],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",1640416.67],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 10,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"32064\"]]");
    p = add_epsg_def_ex (filter, first, last, 32065, "epsg", 32065,
        "NAD27 / BLM 15N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-93 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 15N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-93],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",1640416.67],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 10,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"32065\"]]");
    p = add_epsg_def_ex (filter, first, last, 32066, "epsg", 32066,
        "NAD27 / BLM 16N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-87 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 16N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-87],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",1640416.67],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 10,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"32066\"]]");
    p = add_epsg_def_ex (filter, first, last, 32067, "epsg", 32067,
        "NAD27 / BLM 17N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-81 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 17N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",1640416.67],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 10,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"32067\"]]");
    p = add_epsg_def_ex (filter, first, last, 32074, "epsg", 32074,
        "NAD27 / BLM 14N (feet) (deprecated)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-99 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 14N (feet) (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"C");
    add_srs_wkt (p, 2,
        "larke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4267\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-99],PARAMETER[\"scale_factor\",0.9996],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",1640416.67],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32074\"]]");
    p = add_epsg_def_ex (filter, first, last, 32075, "epsg", 32075,
        "NAD27 / BLM 15N (feet) (deprecated)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-93 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 15N (feet) (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"C");
    add_srs_wkt (p, 2,
        "larke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4267\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-93],PARAMETER[\"scale_factor\",0.9996],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",1640416.67],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32075\"]]");
    p = add_epsg_def_ex (filter, first, last, 32076, "epsg", 32076,
        "NAD27 / BLM 16N (feet) (deprecated)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-87 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 16N (feet) (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"C");
    add_srs_wkt (p, 2,
        "larke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4267\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-87],PARAMETER[\"scale_factor\",0.9996],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",1640416.67],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32076\"]]");
    p = add_epsg_def_ex (filter, first, last, 32077, "epsg", 32077,
        "NAD27 / BLM 17N (feet) (deprecated)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-81 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 17N (feet) (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"C");
    add_srs_wkt (p, 2,
        "larke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4267\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-81],PARAMETER[\"scale_factor\",0.9996],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",1640416.67],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"32077\"]]");
    p = add_epsg_def_ex (filter, first, last, 32081, "epsg", 32081,
        "NAD27 / MTM zone 1", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-53 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / MTM zone 1\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "67\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-5");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",304800],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"320");
    add_srs_wkt (p, 12,
        "81\"]]");
    p = add_epsg_def_ex (filter, first, last, 32082, "epsg", 32082,
        "NAD27 / MTM zone 2", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-56 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / MTM zone 2\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "67\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-5");
    add_srs_wkt (p, 8,
        "6],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",304800],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"320");
    add_srs_wkt (p, 12,
        "82\"]]");
    p = add_epsg_def_ex (filter, first, last, 32083, "epsg", 32083,
        "NAD27 / MTM zone 3", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-58.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / MTM zone 3\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "67\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-5");
    add_srs_wkt (p, 8,
        "8.5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",304800],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32083\"]]");
    p = add_epsg_def_ex (filter, first, last, 32084, "epsg", 32084,
        "NAD27 / MTM zone 4", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / MTM zone 4\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "67\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-6");
    add_srs_wkt (p, 8,
        "1.5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",304800],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32084\"]]");
    p = add_epsg_def_ex (filter, first, last, 32085, "epsg", 32085,
        "NAD27 / MTM zone 5", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / MTM zone 5\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "67\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-6");
    add_srs_wkt (p, 8,
        "4.5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",304800],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32085\"]]");
    p = add_epsg_def_ex (filter, first, last, 32086, "epsg", 32086,
        "NAD27 / MTM zone 6", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-67.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / MTM zone 6\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "67\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",-6");
    add_srs_wkt (p, 8,
        "7.5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",304800],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32086\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

