//                                               -*- C++ -*-
/**
 *  @file  OTOrthogonalBasis.hxx
 *  @brief The external header file of Open TURNS for subdir OrthogonalBasis
 *
 *  Copyright (C) 2005-2013 EDF-EADS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  @author dutka
 *  @date   2009-02-11 16:49:59 +0100 (Wed, 11 Feb 2009)
 */

#ifndef OPENTURNS_OTORTHOGONALBASIS_HXX
#define OPENTURNS_OTORTHOGONALBASIS_HXX

#include "ChebychevAlgorithm.hxx"
#include "EnumerateFunction.hxx"
#include "EnumerateFunctionImplementation.hxx"
#include "LinearEnumerateFunction.hxx"
#include "HyperbolicAnisotropicEnumerateFunction.hxx"
#include "GramSchmidtAlgorithm.hxx"
#include "OrthogonalUniVariatePolynomial.hxx"
#include "CharlierFactory.hxx"
#include "HermiteFactory.hxx"
#include "JacobiFactory.hxx"
#include "KrawtchoukFactory.hxx"
#include "LaguerreFactory.hxx"
#include "LegendreFactory.hxx"
#include "MeixnerFactory.hxx"
#include "OrthogonalBasis.hxx"
#include "OrthogonalFunctionFactory.hxx"
#include "OrthogonalProductPolynomialFactory.hxx"
#include "OrthogonalUniVariatePolynomialFactory.hxx"
#include "OrthogonalUniVariatePolynomialFamily.hxx"
#include "OrthonormalizationAlgorithm.hxx"
#include "OrthonormalizationAlgorithmImplementation.hxx"
#include "StandardDistributionPolynomialFactory.hxx"

#endif /* OPENTURNS_OTORTHOGONALBASIS_HXX */
