/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;

public final class IvyContext {
    private static ThreadLocal current = new ThreadLocal();
    private Ivy defaultIvy;
    private WeakReference ivy = new WeakReference<Object>(null);
    private Map contextMap = new HashMap();
    private Thread operatingThread;
    private ResolveData resolveData;
    private DependencyDescriptor dd;

    public IvyContext() {
    }

    private IvyContext(IvyContext ivyContext) {
        this.defaultIvy = ivyContext.defaultIvy;
        this.ivy = ivyContext.ivy;
        this.contextMap = new HashMap(ivyContext.contextMap);
        this.operatingThread = ivyContext.operatingThread;
        this.resolveData = ivyContext.resolveData;
        this.dd = ivyContext.dd;
    }

    public static IvyContext getContext() {
        Stack stack = IvyContext.getCurrentStack();
        if (stack.isEmpty()) {
            stack.push(new IvyContext());
        }
        return (IvyContext)stack.peek();
    }

    private static Stack getCurrentStack() {
        Stack stack = (Stack)current.get();
        if (stack == null) {
            stack = new Stack();
            current.set(stack);
        }
        return stack;
    }

    public static IvyContext pushNewContext() {
        return IvyContext.pushContext(new IvyContext());
    }

    public static IvyContext pushNewCopyContext() {
        return IvyContext.pushContext(new IvyContext(IvyContext.getContext()));
    }

    public static IvyContext pushContext(IvyContext ivyContext) {
        IvyContext.getCurrentStack().push(ivyContext);
        return ivyContext;
    }

    public static IvyContext popContext() {
        return (IvyContext)IvyContext.getCurrentStack().pop();
    }

    public final Ivy getIvy() {
        Ivy ivy = this.peekIvy();
        if (ivy == null) {
            return this.getDefaultIvy();
        }
        return ivy;
    }

    public final Ivy peekIvy() {
        return (Ivy)this.ivy.get();
    }

    private Ivy getDefaultIvy() {
        if (this.defaultIvy == null) {
            this.defaultIvy = Ivy.newInstance();
            try {
                this.defaultIvy.configureDefault();
            }
            catch (Exception exception) {}
        }
        return this.defaultIvy;
    }

    public final void setIvy(Ivy ivy) {
        this.ivy = new WeakReference<Ivy>(ivy);
        this.operatingThread = Thread.currentThread();
    }

    public final IvySettings getSettings() {
        return this.getIvy().getSettings();
    }

    public final CircularDependencyStrategy getCircularDependencyStrategy() {
        return this.getIvy().getSettings().getCircularDependencyStrategy();
    }

    public final Object get(String string) {
        WeakReference weakReference = (WeakReference)this.contextMap.get(string);
        if (weakReference == null) {
            return null;
        }
        return weakReference.get();
    }

    public final void set(String string, Object object) {
        this.contextMap.put(string, new WeakReference<Object>(object));
    }

    public final MessageLogger getMessageLogger() {
        Ivy ivy = this.peekIvy();
        if (ivy == null) {
            if (this.defaultIvy == null) {
                return Message.getDefaultLogger();
            }
            return this.defaultIvy.getLoggerEngine();
        }
        return ivy.getLoggerEngine();
    }

    public final EventManager getEventManager() {
        return this.getIvy().getEventManager();
    }

    public final void checkInterrupted() {
        this.getIvy().checkInterrupted();
    }

    public final void setResolveData(ResolveData resolveData) {
        this.resolveData = resolveData;
    }

    public final ResolveData getResolveData() {
        return this.resolveData;
    }

    public final void setDependencyDescriptor(DependencyDescriptor dependencyDescriptor) {
        this.dd = dependencyDescriptor;
    }

    public final DependencyDescriptor getDependencyDescriptor() {
        return this.dd;
    }
}

