if (typeof T === 'undefined') require('../setup');

T('times', function () {

  var t = function (multiplicand, multiplier, expected) {
    T.assertEqual(expected, new Decimal(multiplicand).times(multiplier).valueOf());
  }

  Decimal.config({
    precision: 300,
    rounding: 4,
    toExpNeg: -7,
    toExpPos: 21,
    minE: -9e15,
    maxE: 9e15
  });

  t(1, NaN, 'NaN');
  t(-1, NaN, 'NaN');
  t(1, Infinity, 'Infinity');
  t(1, -Infinity, '-Infinity');
  t(-1, Infinity, '-Infinity');
  t(-1, -Infinity, 'Infinity');
  t(0, 'NaN', 'NaN');
  t(-0, 'NaN', 'NaN');
  t(0, 'Infinity', 'NaN');
  t(0, '-Infinity', 'NaN');
  t(-0, 'Infinity', 'NaN');
  t(-0, '-Infinity', 'NaN');
  t('NaN', 1, 'NaN');
  t('NaN', -1, 'NaN');
  t('NaN', 0, 'NaN');
  t('NaN', -0, 'NaN');
  t('NaN', NaN, 'NaN');
  t('NaN', Infinity, 'NaN');
  t('NaN', -Infinity, 'NaN');
  t('Infinity', 1, 'Infinity');
  t('Infinity', -1, '-Infinity');
  t('-Infinity', 1, '-Infinity');
  t('-Infinity', -1, 'Infinity');
  t('Infinity', 0, 'NaN');
  t('Infinity', -0, 'NaN');
  t('-Infinity', 0, 'NaN');
  t('-Infinity', -0, 'NaN');
  t('Infinity', NaN, 'NaN');
  t('-Infinity', NaN, 'NaN');
  t('Infinity', Infinity, 'Infinity');
  t('Infinity', -Infinity, '-Infinity');
  t('-Infinity', Infinity, '-Infinity');
  t('-Infinity', -Infinity, 'Infinity');

  t(1, 0, '0');
  t(1, -0, '-0');
  t(-1, 0, '-0');
  t(-1, -0, '0');
  t(0, 1, '0');
  t(0, -1, '-0');
  t(-0, 1, '-0');
  t(-0, -1, '0');
  t(0, 0, '0');
  t(0, -0, '-0');
  t(-0, 0, '-0');
  t(-0, -0, '0');

  t(1, '1','1');
  t(1, '-45', '-45');
  t(1, '22', '22');
  t(1, 0144, '100');
  t(1, '0144', '144');
  t(1, '6.1915', '6.1915');
  t(1, '-1.02', '-1.02');
  t(1, '0.09', '0.09');
  t(1, '-0.0001', '-0.0001');
  t(1, '8e5', '800000');
  t(1, '9E12', '9000000000000');
  t(1, '1e-14', '1e-14');
  t(1, '3.345E-9', '3.345e-9');
  t(1, '-345.43e+4', '-3454300');
  t(1, '-94.12E+0', '-94.12');
  t(1, Number.POSITIVE_INFINITY, 'Infinity');
  t(1, Number.NEGATIVE_INFINITY, '-Infinity');
  t('0', 0, '0');
  t('0', '0', '0');
  t(3, -0, '-0');
  t(9.654, 0, '0');
  t(0, '0.001', '0');
  t(0, '111.1111111110000', '0');
  t('NaN', '0', 'NaN');
  t(-1, 1, '-1');
  t(-0.01, 0.01, '-0.0001');
  t(54, -54, '-2916');
  t(9.99, '-9.99', '-99.8001');
  t('0.0000023432495704937', '-0.0000023432495704937', '-5.49081854961890952566173969e-12');
  t(NaN, NaN, 'NaN');
  t(NaN, 'NaN', 'NaN');
  t('NaN', NaN, 'NaN');
  t('NaN', 4, 'NaN');
  t('NaN', '4534534.45435435', 'NaN');
  t('NaN', 99999.999, 'NaN');
  t(Infinity, '354.345341', 'Infinity');
  t(3, '-Infinity', '-Infinity');
  t(-Infinity, '-Infinity', 'Infinity');
  t('-Infinity', -Infinity, 'Infinity');
  t('Infinity', '-999e999', '-Infinity');
  t(1.21123e43, '-Infinity', '-Infinity');
  t('-999.0', 'Infinity', '-Infinity');
  t('657.342e-45', '-Infinity', '-Infinity');
  t('Infinity', 123, 'Infinity');
  t(-0, 'Infinity', 'NaN');
  t(100, 100, '10000');
  t(-999.99, '0.01', '-9.9999');
  t('10', 4, '40');
  t('03.333', -4, '-13.332');
  t(-1, -0.1, '0.1');
  t(43534.5435, '0.054645', '2378.9451295575');
  t('99999', '1', '99999');

  t('-19.851', '69.11', '-1371.90261');
  t('-0.0251', '-1.09821', '0.027565071');
  t('-2.11', '-21', '44.31');
  t('-1', '7161', '-7161');
  t('-4.61', '1', '-4.61');
  t('11', '-0.0000271', '-0.0002981');
  t('-1', '0.0000224801', '-0.0000224801');
  t('-3.6', '-3336', '12009.6');
  t('0.000000219', '-110.42', '-0.00002418198');
  t('312', '22.87694', '7137.60528');
  t('0.29976', '-5', '-1.4988');
  t('0.00000000000000000010018', '-74.6', '-7.473428e-18');
  t('138.583905', '9.73380', '1348.948014489');
  t('5360260.6', '-12.12', '-64966358.472');
  t('-7.01', '-0.0000000988077', '6.92641977e-7');
  t('0.0000202', '-56583117802', '-1142978.9796004');
  t('116727.96', '0.0000000000000019308', '2.25378345168e-10');
  t('-136636.46', '6.5636554051', '-896834.639212729946');
  t('12.1712598149', '53.270389', '648.3677449597909961');
  t('76', '76019.61784', '5777490.95584');
  t('0.0000714939', '1425786', '101.9350017054');
  t('-3221.71685', '-230', '740994.8755');
  t('0.00000000237457904', '-892315', '-0.0021188724960776');
  t('6511.4', '0.0000000000000186', '1.2111204e-10');
  t('0.000000011188562', '0', '0');
  t('-25379.8', '3', '-76139.4');
  t('41.9279', '23.4198661', '981.94580385419');
  t('0.0000010', '58236.222', '0.058236222');
  t('0', '-16.39257632', '-0');
  t('0.000000004846959', '1', '4.846959e-9');
  t('0', '-30878.5', '-0');
  t('-8065.5', '-0.00000000058314173', '0.000004703329623315');
  t('-443850607', '-1', '443850607');
  t('-0.070884', '0.0000000000000000002106611401', '-1.49325042548484e-20');
  t('15510739.6998', '4.13', '64059354.960174');
  t('-1182.8', '0.00000000000006116702878', '-7.2348361640984e-11');
  t('0.000000000000000024429766', '1.492', '3.6449210872e-17');
  t('-521641.171', '0.000000044916564267', '-0.023430329181534636657');
  t('-1.4', '-50.3861389', '70.54059446');
  t('-906235823', '169450901242', '-153562476945135592166');
  t('818.5', '-0.0000000000000002572', '-2.105182e-13');
  t('0', '2', '0');
  t('0.00000000000000000723208622905', '7281.27407', '5.26588019315858457335e-14');
  t('-8.30486506', '-1110043.7', '9218763.139203122');
  t('1.8', '0', '0');
  t('-0.000000000000339156493611', '-0.000000000000000000167265', '5.6729010903843915e-32');
  t('0.00000000000000283', '4.074', '1.152942e-14');
  t('39.85', '33086328', '1318490170.8');
  t('4.1183805089', '-5.126069', '-21.1111026568765141');
  t('-464.2025675', '0.00000000000000000106831881858', '-4.9591633849340270415e-16');
  t('0', '-0.0000000000073', '-0');
  t('-0.0000002358363833', '-37968.0', '0.0089542358011344');
  t('3.4', '-32545254.52', '-110653865.368');
  t('0.000000247', '12.88', '0.00000318136');
  t('-446908', '0.000000490399599', '-0.219163503989892');
  t('-0.0000000015', '91', '-1.365e-7');
  t('794881.3', '45.2898548', '36000058.66023524');
  t('5', '3046563.8', '15232819');
  t('-95094833817', '3.101', '-294889079666.517');
  t('-12786.5', '-0.0000000684878615', '0.00087572004106975');
  t('66754192.630', '7', '467279348.41');
  t('414951476.81', '-12.875', '-5342500263.92875');
  t('-2.486307', '0.00000000000131610556936', '-3.27224248983875352e-12');
  t('-0.000000000000000477405019421', '-1.1', '5.251455213631e-16');
  t('-367046.223', '-0.0000129', '4.7348962767');
  t('0', '0.000000000000093338247', '0');
  t('0.3341376', '-8', '-2.6731008');
  t('422580779', '-10829.0', '-4576127255791');
  t('-11.6639', '-56.51836497', '659.224557173583');
  t('-1', '-36577.4', '36577.4');
  t('61.5', '-68269.0', '-4198543.5');
  t('-18.10728', '0', '-0');
  t('531751766', '41.50116', '22068315121.04856');
  t('-7.63315110', '3', '-22.8994533');
  t('1249.58475875', '38582.13', '48211641.6081111375');
  t('-2', '0.000000000000001022', '-2.044e-15');
  t('10.750', '0.000000000014145865', '1.5206804875e-10');
  t('14', '0.044276206', '0.619866884');
  t('12175855.915', '52.1893', '635449397.1047095');
  t('-1', '-0.00000000000029721', '2.9721e-13');
  t('311354.171224', '194857.1428', '60669584203.5706187872');
  t('0.0000008188', '6375.414052', '0.0052201890257776');
  t('0.00000055577528074', '3', '0.00000166732584222');
  t('526170.543', '6065.11546', '3191285094.94589478');
  t('0', '-27078031462', '-0');
  t('0.0003450371', '4044.753', '1.3955898453363');
  t('0', '-5.681398758', '-0');
  t('-2830933', '-1', '2830933');
  t('2.8', '14.36338836', '40.217487408');
  t('725.6556', '-0.000058977271', '-0.0427971869738676');
  t('0', '0', '0');
  t('591.1', '-182368.115408', '-107797793.0176688');
  t('1', '-8.44', '-8.44');
  t('-48988695', '3.99', '-195464893.05');
  t('-54145231.29', '-164.1', '8885232454.689');
  t('1.9615', '370.5', '726.73575');
  t('-2317170.34468', '-0.0000117290196265', '27.17813645069548986202');
  t('-3865301765', '9.90928729', '-38302385651.92906685');
  t('8.9648', '-3', '-26.8944');
  t('-10645.1', '-4208', '44794580.8');
  t('-390304.9', '-9.540', '3723508.746');
  t('0.00000000043946', '-0.0000000000135', '-5.93271e-21');
  t('11.167962', '907.089236', '10130.338118257032');
  t('328719912.6', '1.13', '371453501.238');
  t('8.0902', '3', '24.2706');
  t('-0.0000000000000000000103885880', '54949757', '-5.70850386173116e-13');
  t('-60096046', '147.9066', '-8888601837.3036');
  t('-1.1', '-4', '4.4');
  t('-2.3781033', '1.488', '-3.5386177104');
  t('18.64', '-13492494', '-251500088.16');
  t('0.0000000000000000078080114', '1362291', '1.06367836581174e-11');
  t('0.0000006699', '-0.0000000000000059', '-3.95241e-21');
  t('-279.40', '-4199.537182', '1173350.6886508');
  t('-346081282.623', '5715.5169', '-1978033419605.4328287');
  t('26098.51437', '-0.00004277160560', '-1.116275363379572472');
  t('-0.000000000038243914682', '6258350.6', '-0.0002393438263964435092');
  t('-0.23215784', '1.7', '-0.394668328');
  t('270.08569', '73.4', '19824.289646');
  t('0.000000000000000253826', '-1', '-2.53826e-16');
  t('1773.911', '167', '296243.137');
  t('-609057.1664', '-2', '1218114.3328');
  t('178326076.8', '-299396.226', '-53390154391306.1568');
  t('-99153591.8357', '-67230.718614', '6666167232273.3544197198');
  t('0.0000000000001596', '-0.00349909609', '-5.58455735964e-16');
  t('1.84', '0.00000000003464', '6.37376e-11');
  t('73.5', '0', '0');
  t('0.000000000000000049', '-198604', '-9.731596e-12');
  t('1052854077', '2.8', '2947991415.6');
  t('28.3', '5964', '168781.2');
  t('2085.7', '-338.192', '-705367.0544');
  t('59.12705', '-0.0000000000016294', '-9.634161527e-11');
  t('-0.0000000000000629', '-0.0000133901915', '8.4224304535e-19');
  t('0.000000000000000000010713336246', '12.8722', '1.379042068257612e-19');
  t('0.000620507896', '3.9', '0.0024199807944');
  t('3', '9.6', '28.8');
  t('-1', '7', '-7');
  t('4.07', '4', '16.28');
  t('-2473.25538', '12.3', '-30421.041174');
  t('-1310633', '-9', '11795697');
  t('-3.90', '3031.9', '-11824.41');
  t('150.0276', '0.00897', '1.345747572');
  t('2', '-8.8', '-17.6');
  t('-3030148.8', '229674', '-695946395491.2');
  t('2', '775.7549', '1551.5098');
  t('-613183.18515', '-3', '1839549.55545');
  t('-0.000000000001224', '367.376621', '-4.49668984104e-10');
  t('-0.00000000000000000737581', '1.3490', '-9.94996769e-18');
  t('0', '-1.15490644', '-0');
  t('8.437', '-12103106905', '-102113912957.485');
  t('155.8091088', '3.465', '539.878561992');
  t('179142.3', '0.0060', '1074.8538');
  t('-301.3766', '9.6052', '-2894.78251832');
  t('48.15', '518165.306', '24949659.4839');
  t('4387518.42726', '-8069', '-35402886189.56094');
  t('-28.3', '-77.67', '2198.061');
  t('9', '0.00000000000001022', '9.198e-14');
  t('-1071.62294', '0.0000010', '-0.00107162294');
  t('-4.15', '-3', '12.45');
  t('-661.167', '453', '-299508.651');
  t('-104436', '-1098478.95443', '114720748084.85148');
  t('0', '3.630588', '0');
  t('0', '-13181687.0', '-0');
  t('-1.111', '-3.78770', '4.2081347');
  t('0.000000042325027395', '2.89323850', '1.224563987727687075e-7');
  t('-21.7', '-0.00001926174637', '0.000417979896229');
  t('28151356.2', '0.00000000003236052', '0.000910992525337224');
  t('0.0120', '-862436.56', '-10349.23872');
  t('3649.71055', '-692509.6', '-2527459593.09628');
  t('-3', '-1', '3');
  t('-1135.91888551', '12.37808265', '-14060.4978485386674015');
  t('1', '2172752.822', '2172752.822');
  t('-0.00000000000001091997', '-117.1', '1.278728487e-12');
  t('-605.91910660', '2036476909', '-1233940269312.8094994');
  t('-85793626', '-403556966', '34622615410698716');
  t('387.034155496', '1.51', '584.42157479896');
  t('-212937', '7812.350', '-1663538371.95');
  t('838667.59', '-297101', '-249168979656.59');
  t('0.00382632083', '0.000316896', '0.00000121254576574368');
  t('0.000000000000002582', '-295757466.2', '-7.636457777284e-7');
  t('-0.000000000000798713', '21.52', '-1.718830376e-11');
  t('0.00000974', '-2.9', '-0.000028246');
  t('0.0000000000281', '38.82', '1.090842e-9');
  t('-3.237', '16967081.13', '-54922441.61781');
  t('9.8', '-0.0000000001333', '-1.30634e-9');
  t('5614.9', '-76.1668', '-427668.96532');
  t('-1.8', '3545.0927', '-6381.16686');
  t('0.00000249806256', '-1131.1175', '-0.0028256022777108');
  t('-0.20706', '11338.58322', '-2347.7670415332');
  t('1908.3417145', '-138.575', '-264448.4530868375');
  t('0', '0.0000669436', '0');
  t('325.22245849', '-14504.56', '-4717208.6625157144');
  t('-13.8825', '0', '-0');
  t('0.0000000000869261985', '1.1243', '9.773112497355e-11');
  t('2588680', '-2.639437', '-6832657.77316');
  t('847973030.3', '1300.4', '1102704128602.12');
  t('-669.7', '-1150.41', '770429.577');
  t('-1', '-6.761867', '6.761867');
  t('-4', '-128.68', '514.72');
  t('-0.0000000000000000148', '-389336', '5.7621728e-12');
  t('5.1', '8.1', '41.31');
  t('959895377.84', '976.5', '937337836460.76');
  t('152', '-1325188.6822', '-201428679.6944');
  t('-1013851164640', '-116895', '118514131890592800');
  t('-0.555030', '0.0025719815451', '-0.001427526916976853');
  t('-8.61456', '-0.000000000050', '4.30728e-10');
  t('-0.10822', '-42439', '4592.74858');
  t('5', '248', '1240');
  t('1.00560719', '-0.00000000000000538', '-5.4101666822e-15');
  t('-0.0000000000000000880', '20.26149480', '-1.7830115424e-15');
  t('-215.544104755', '-4060438.71', '875203626.65949706605');
  t('0', '13031.6', '0');
  t('-0.0000000000000047877659854', '-208.19', '9.96765000500426e-13');
  t('-4', '-3160383', '12641532');
  t('-0.00104402960', '-6', '0.0062641776');
  t('-6', '-221362529.2', '1328175175.2');
  t('-5658.7', '-0.000009428149284', '0.0533510683533708');
  t('-3', '-0.0000000000000000171257563600', '5.137726908e-17');
  t('1577941089.0', '-0.0000000000000054178560', '-0.000008549057596685184');
  t('-3', '-19154.88287', '57464.64861');
  t('-5.3', '-0.000000000000000094150109', '4.989955777e-16');
  t('-275.9', '-618029.6', '170514366.64');
  t('-0.00277412', '-2.0', '0.00554824');
  t('20896.13', '-2', '-41792.26');
  t('0', '144.50', '0');
  t('0', '37399', '0');
  t('0.0000000103050173', '-6.752', '-6.95794768096e-8');
  t('-1679844', '0.00008795', '-147.7422798');
  t('1731362.632', '-0.0000000010867236', '-0.0018815126323525152');
  t('-116536', '8818.8637874', '-1027715110.3284464');
  t('112359.12', '-6.3736', '-716132.087232');
  t('0.02767509', '4.002781363', '0.11077733447134767');
  t('-942581.9', '7.504907', '-7073989.4993833');
  t('6603793', '1.604', '10592483.972');
  t('91689.093', '5', '458445.465');
  t('4351694708.6', '0.0003242690', '1411119.6914630134');
  t('-2.38', '-39', '92.82');
  t('-759.5', '0.000000324', '-0.000246078');
  t('-6.1623', '-10.1485', '62.53810155');
  t('1819.975133', '-1918.4931', '-3491609.7348320823');
  t('-544', '-2373759.39656', '1291325111.72864');
  t('-2143.2', '-0.000000000000000000162130', '3.47477016e-16');
  t('0.621559060', '53.8', '33.439877428');
  t('-4624.6', '0.0000000000000190537313036', '-8.811588578662856e-11');
  t('-6', '-50.943', '305.658');
  t('-3021.479', '3', '-9064.437');
  t('-965', '-0.000415509858', '0.40096701297');
  t('0', '6465897.6979', '0');
  t('74528068.573', '-119403349', '-8898900982117850.977');
  t('64.56', '0.000000017086', '0.00000110307216');
  t('-9626.07', '-1051902.812582', '10125690107.11121274');
  t('1.4514', '-1', '-1.4514');
  t('0.00120840179209', '-492240', '-594.8236981383816');
  t('-1.163', '-3.5', '4.0705');
  t('-390918.9935', '-3.9645296', '1549809.9209329576');
  t('1130.013737', '3', '3390.041211');
  t('-5', '-6733821263', '33669106315');
  t('27774.358123', '-0.0000000000000128441670', '-3.56738494049618541e-10');
  t('0.363631323', '-3819136980.1', '-1388757832.7919876723');
  t('-0.0000000065598472', '53857.08', '-0.000353294215438176');
  t('-240695', '2', '-481390');
  t('0.000059', '0.00000000000017987993', '1.061291587e-17');
  t('37.17', '-61.7668', '-2295.871956');
  t('1.475572354', '266461086.2', '393182612.2135309148');
  t('-0.000000000003907', '-31.5', '1.230705e-10');
  t('-0.0000000000000000000894018', '0.00000000000000001599913222', '-1.430351218905996e-36');
  t('0', '-0.00005850856211', '-0');
  t('32.75', '-2.57293', '-84.2634575');
  t('0.00000131', '43', '0.00005633');
  t('-129602.62', '-0.000000000000000123490', '1.60046275438e-11');
  t('-2941.6442', '2.013048311', '-5921.6718883729462');
  t('1.01983639584', '10710047', '10922495.73175700448');
  t('0.4077750076', '-3', '-1.2233250228');
  t('0.359', '207160.173586', '74370.502317374');
  t('-26222.646879', '9.8', '-256981.9394142');
  t('-2', '-1.1360', '2.272');
  t('6717280984', '564735824499', '3.793489214890694027016e+21');
  t('-7', '0.000000000000000000179598', '-1.257186e-18');
  t('-0.000212', '754.3', '-0.1599116');
  t('-8.6', '-44061.183', '378926.1738');
  t('0.000000000000000000013', '956', '1.2428e-17');
  t('-3', '3.8968771877', '-11.6906315631');
  t('-4485.1947117', '444609963508', '-1994162257095211.5806436');
  t('0', '-3353199.6579', '-0');
  t('0.0000000000000000000293', '-4', '-1.172e-19');
  t('-225', '5.09648', '-1146.708');
  t('0.00000036757', '0', '0');
  t('-78694.836', '-43.8', '3446833.8168');
  t('0.000000000000018028989162', '495', '8.92434963519e-12');
  t('-4036233', '-0.0000000000000000000134620360255', '5.43359140533119415e-14');
  t('-2.19', '-481624.5154', '1054757.688726');
  t('-6', '-33692.483', '202154.898');
  t('-0.00000000387466078726', '137145711.9', '-0.531393112039787150394');
  t('-52.6685', '-107972.8', '5686765.4168');
  t('-7.137137210', '3.06', '-21.8396398626');
  t('-174.1619', '-2084784202', '363089977710.3038');
  t('11', '-0.15', '-1.65');
  t('177.3211', '-85578219.525', '-15174824022.2144775');
  t('2', '-1', '-2');
  t('-681.685707574', '222753546489', '-151847908952971.868407686');
  t('2225288.04', '-2945.03251212', '-6553545626.6317910448');
  t('-829419822664', '0.000750870', '-622786462.24371768');
  t('-3.887', '-0.0000000000215299', '8.36867213e-11');
  t('14780708.1', '-2000820.86', '-29573549092050.966');
  t('-65280872367', '2756.0', '-179914084243452');
  t('-1.1', '-16652196529', '18317416181.9');
  t('6153.32891899', '3.07', '18890.7197812993');
  t('1.6664', '10.5', '17.4972');
  t('-335.16960', '25.16', '-8432.867136');
  t('20.7', '834', '17263.8');
  t('8029.51', '-1', '-8029.51');
  t('3544067.44', '0.00000000000000000108040', '3.829010462176e-12');
  t('-0.00000000000000861840983', '3', '-2.585522949e-14');
  t('-1', '-5.4071', '5.4071');
  t('-0.000000000000014799305202', '-77.4875919308', '1.1467625223519416640216e-12');
  t('0', '-31045268779', '-0');
  t('-437', '640.03', '-279693.11');
  t('60', '0.000000000000000371281463', '2.227688778e-14');
  t('-1', '-0.019533338878', '0.019533338878');
  t('-1117.048', '8.967', '-10016.569416');
  t('-0.0000000000001992331', '17762516', '-0.0000035388811264796');
  t('-1.209', '-3960.47030', '4788.2085927');
  t('-994748.5', '-10809803.2', '10753035518495.2');
  t('-3.0521', '0', '-0');
  t('4553015.460', '-6', '-27318092.76');
  t('0.00000000403775332', '0', '0');
  t('10628.68130', '-1.196558', '-12717.8336389654');
  t('-0.00000000003389', '-113275.58', '0.0000038389094062');
  t('0.0000000000000000000810', '-0.000000002954', '-2.39274e-28');
  t('0', '0.00000002678', '0');
  t('12309', '25980042.9', '319788348056.1');
  t('-7.6', '0', '-0');
  t('-61.22', '-349.3', '21384.146');
  t('-1.845209', '0.000000052784913420', '-9.739919730680478e-8');
  t('395.326251', '-371872028', '-147010774681.007028');
  t('332.72', '3715', '1236054.8');
  t('-1681921.54', '76348.91498', '-128412884660.4906692');
  t('517583042', '-13.9', '-7194404283.8');
  t('-21.723616577', '-0.000013157028', '0.000285818231564853156');
  t('-116.13334149', '0.0000000006536', '-7.5904751997864e-8');
  t('-4.1', '-294.0876', '1205.75916');
  t('-22.05', '-6.7', '147.735');
  t('-22.9', '-0.00000217178', '0.000049733762');
  t('-50.5', '0.012432393', '-0.6278358465');
  t('-2', '-0.00000000000119764950', '2.395299e-12');
  t('19381.0141', '65.916071785', '1277520.3166816971685');
  t('-4.90', '-22.5701', '110.59349');
  t('0.00000000000192902409442', '289522860.5', '0.00055849657378990048841');
  t('-27006298.37', '-8164.7', '220498324301.539');
  t('-8776869', '-143972778', '1263630212072082');
  t('-79325483.3', '248065.2', '-19677891879911.16');
  t('-26.2', '28441.8', '-745175.16');
  t('18.71', '97792.4647', '1829697.014537');
  t('-150.68501', '-1.3460', '202.82202346');
  t('-43.0091494663', '-5.6724', '243.96509943264012');
  t('12.359', '-1.261', '-15.584699');
  t('0.0000000048694525', '-13', '-6.33028825e-8');
  t('-26799', '-3.0401', '81471.6399');
  t('0.000000000003271187802', '0', '0');
  t('1', '0.0000000000250081008', '2.50081008e-11');
  t('23.590033588', '0.000000000000000880594309', '2.0773249326711650692e-14');
  t('2.34', '-35556883', '-83203106.22');
  t('127410324', '48.0', '6115695552');
  t('2.4', '2.0', '4.8');
  t('17', '-0.00000000000000000467960391085', '-7.955326648445e-17');
  t('-5827035', '63.01', '-367161475.35');
  t('-452352446648', '13167459.5', '-5956332520963450756');
  t('0', '27.51619908', '0');
  t('-6.8253', '-203490405', '1388883061.2465');
  t('-663513.1', '235798', '-156455061953.8');
  t('45846991454.7', '0.000000000000011371170', '0.000521333933819940999');
  t('-6940453.30', '-0.0000000000000000000429869089', '2.9834863373180437e-13');
  t('-299.7692790', '-2.0', '599.538558');
  t('-0.000000000000781997707', '-0.00000000002498', '1.953430272086e-23');
  t('-211968.876', '-11448', '2426619692.448');
  t('-2', '224979.5', '-449959');
  t('0.0000000000007372', '3', '2.2116e-12');
  t('2.14', '-96.5220369', '-206.557158966');
  t('246.3484', '-119174406049', '-29358424251121.4716');
  t('2301100.91737', '-431951.5', '-993963992909.347555');
  t('-13819448.15', '0', '-0');
  t('0.0000000155919108142', '8.51', '1.32687161028842e-7');
  t('124616457', '513907736', '64041361285211352');
  t('-5298.3584942', '-4.1932', '22217.07683787944');
  t('158463114', '0.0000000000000000001405398', '2.22703743489372e-11');
  t('-65667302.5', '7', '-459671117.5');
  t('-1693481.437', '-27743783', '46983581502656.171');
  t('-0.0000000000000003099934391', '125', '-3.87491798875e-14');
  t('-0.000000000000004272052', '0.0000005661', '-2.4184086372e-21');
  t('12.95933', '209420271.72', '2713946409.9091476');
  t('3.1', '-1.31573054798', '-4.078764698738');
  t('0.000086866', '-103057641552', '-8952205.091056032');
  t('11.1', '660.353292988', '7329.9215521668');
  t('-92.940180', '-1', '92.94018');
  t('97808795959', '-97', '-9487453208023');
  t('0.000000000000000388699', '-399', '-1.55090901e-13');
  t('227578760.552', '-40082.64751', '-9121959239968.50902552');
  t('-4.31547', '-29.771127352', '128.47640695373544');
  t('27.8', '60.0346682', '1668.96377596');
  t('12.7', '60805396.70', '772228538.09');
  t('6.808549', '434235.18', '2956511.50055382');
  t('-0.000000000000000000764', '798867', '-6.10334388e-13');
  t('0.000000000166682635066', '21.7', '3.6170131809322e-9');
  t('-17.0856584365', '-73.70395', '1259.280515120874175');
  t('-0.000032761108', '137.87702888', '-0.00451700423385679904');
  t('6.7467', '0.000000000000000000017375144', '1.172248840248e-19');
  t('1.0', '4', '4');
  t('2791.3', '372.0576', '1038524.37888');
  t('0', '-1.1', '-0');
  t('-67196.498357', '36318.97052', '-2440507642.87511143564');
  t('0.00000000484838500152', '-0.00004296', '-2.082866196652992e-13');
  t('-1488.65084', '-2472469.6620', '3680644039.21081608');
  t('-0.000000000020', '-9.9', '1.98e-10');

  t('59429490631462462063898399891833', '85.00891132032463441584595955', '5.05203629890205609747397099201262363916734883085091009335515e+33');
  t('-0.000000000000000042109349317791897577655162141761006017167', '-13008827246961207056988713615056579178448396076639.2633976291', '5.477932507570985534957063193452340625430871365299670940723162464475095465880668702087454656216987597e+32');
  t('8591855.554373470161526044552421978378391766637549711729320', '-4.18144454943', '-35926367.5773248178055078206847122253956635626957707604812328535202876');
  t('-2283433141014849078.33114178969776355920', '-453.97', '1.036610143026511036089988438269093722970024e+21');
  t('-834090482593334176100123.7933568971710257756', '-2311068.681', '1.9276403914416302737519348190500409072951706328939836e+30');
  t('189532.2', '2968613550973672055370920.6', '5.6264785726585220673297239734332e+29');
  t('5.5765', '206791541', '1153173028.3865');
  t('223004397.925983046564773982957421494273449', '-0.00000765764399', '-1707.68828752147254136863163630226113151989615142151');
  t('-9', '-861605.04321559065136010082968313802', '7754445.38894031586224090746714824218');
  t('0.000000000000000000028090298007095127212699390661641605', '-6917964065283873879.11378929124954598', '-0.1943276721961993069547944346297165198267413742521737520171142577284979');
  t('-12902.95204428144349964281942884855605291385221512', '936511255610118037649.1', '-1.2083759820067154006199526430520916600744894425420426553143497592274392e+25');
  t('0.000000054421393267623019090', '0.0693540337668146867938144', '3.774343146319828330922834963772562065116896e-9');
  t('-0.00000000007483922', '11963887185334360.01202905021298539073645325022668', '-895367.9851184189424994447352806605141113868134295543896');
  t('-136818356017962729836947190424992612288254', '0.000001250702751', '-1.71119094258963391622539632506259119343595682786754e+35');
  t('89886141515.402264741', '165920325588054483132342147189817', '1.4913937866089484761163201125053970911515450613342397e+43');
  t('-4910559.69867254476135299557110880352698481', '-0.000000000000001251373615473295746877725841601861845423548', '6.14494484412532005943449278569391549262463086794696425713068030612078654982181230588e-9');
  t('188388334026044880874021952902236669508901633565820006', '-1428610610603915751990.6', '-2.691335729036024155624090667679961618627273975496253699574106150646158039436e+74');
  t('2569238997875.3944611244282198384307876980880850', '-45354701.13646736794503189060', '-116527066896795434703.141029468202286044275680813636330729593599972883501');
  t('-20273871998054251005', '-0.00001018031347', '206394372190847.50529696253735');
  t('0.000000000127882266384995374972957752031634640610096', '56084430050054721499878916115459816143192971582.9', '7.1722040237117373866688717282573432808847848059761445842371981626319357370527308468409584e+36');
  t('954627502168195877866647607616261900931', '9.96209474259629834949998607', '9.51008962048762055845159388440432218351076192328571371885622003117e+39');
  t('27452502565473996463690067929.18801932606917287121704780', '-15999511778834005759916561695256821.291408', '-4.392266381547719678372690910805800180664096055687896418712826017984317410615883824886612653024e+62');
  t('24739272583405.47186561318831947000688841802596024659835438', '0', '0');
  t('-14628477765152447836551575115758391.03361640644696947989', '1896549844807094292937664785889813670098706728.8', '-2.7743637235263904499250092914009953677085505785952534916815852412079339245487773243303684333379283832e+79');
  t('-0.0000000065376926', '400694118953983940534743481756583594', '-2.6196149763489805485528325035782515637752044e+27');
  t('6159556.6345747363', '12428.3903194610108', '76553374049.32049544464848654145204');
  t('1', '-214152.677228898078143751453160882566438516677', '-214152.677228898078143751453160882566438516677');
  t('1234245458508975352.84372029387871714', '711.09788699', '877669337572736089357.1591886677375895858960086');
  t('-12435092008252.828827', '-0.000000000000000130972832307119388', '0.001628659220320498210781727802616997876');
  t('1222155005674.47827107178853812873657', '-1.9217613579329307675966802225522', '-2348690263309.514070047950271986297573047714307144600821921806873954');
  t('-9610326782.75790', '-1925856563138573766.221666413429', '1.85081109084807161320054127390660041302158391e+28');
  t('1897933.1084909834795612591951194123752666123', '-19444.86721593176768385769', '-36905057279.327795521442821058258453663270782572671411150172721603587');
  t('0.000584193054195683632690208', '-15427224.032385517626932779704097', '-9012.477125240345688831570386428613444841606254309382176');
  t('-9193123344.97483292546402603464388933977', '3', '-27579370034.92449877639207810393166801931');
  t('-208355', '18.5077', '-3856171.8335');
  t('0', '-7.9', '-0');
  t('-146.9974821', '27.85613660690160', '-4094.78194224817268246136');
  t('0.0000002221395758167297538432', '-11018022952341415341382543191308.248305367013916352', '-2.4475389449721144325377299337884145675514764946137036517351977553240064e+24');
  t('-62634425863308865890231971109828114770592016347.2857222333045', '-0.0000000000044191162667', '2.7678881018796339994185288016784587422371771822944265151385376844431015e+35');
  t('0.014785725196930589141008331862', '1405730020396633.72', '20784737782660.25819955773732132563645741958664');
  t('3060880958477929473167827.136432332645114184906595927797020', '-134990224.755007177950183445', '-4.131890085332574931410011369432785413898866996911658019131150911202211096837243339e+32');
  t('-251157.56', '-35553.75153', '8929593483.1210668');
  t('10660825.6584256928', '-54.80641419272238648411', '-584281626.672080870616452029619482941408');
  t('0.00000000000000000018196806510154644625549186906147312734531', '290466772346954491087868523893813560578350699536244189', '5.285567654026668587345538632825206167793448119823731989523008725260266169443990119026948390359e+34');
  t('801946936195133455122.3263199289', '3353455956475898285353850471499087737905097359235396953.528', '2.6892937299611674351748616442698675657013699635861635172559630870783247800626545335641592e+75');
  t('88876291341359997.22', '-242985336224765018278774996045975', '-2.15956355339905308693512776069018053139845369921895e+49');
  t('-677.8706245402', '-40041.8855', '27143217.9316521785471');
  t('3.1852520702012', '0.00000998870874036575237809441602188548308619567919990770190850', '0.0000318165551938868335179942506676244968068581347935045219680140052189902');
  t('-2897031868709978067512290.19826378134251899155435029', '-0.0000000000000313426136', '90800550447.862773034512424935249089493462002949664538517944');
  t('-286245211287.816038991926811942762853058522756387871', '-905725.51698541', '259259591978255100.08416583456412844730858064475954566698860796211');
  t('-301283745846510635986864779646783.59226306843', '164455867753899', '-4.954787986333307027587976990843711993792791415951383630857e+46');
  t('16627939773', '-24446.50', '-406494929660644.5');
  t('2835613541302657637165162939561661439198237', '-34702274210562114517526690656890036690211485', '-9.8402238665467925464317665495284869217720281504532926830801758242091305082784369151945e+85');
  t('0.000000000000167329000479220734904842317239446253923254', '-335462.843', '-5.6132662217107750155727738207852552086794690651122e-8');
  t('1606900543967463817538016297544283302866330961.38117', '-12172415089417043266077235.5931339752547820885496331722', '-1.9559860428582011548778770036179464667831089769951903599695351323242935536918541220406695361968160447474e+70');
  t('25175391597018424433550189069315474558138086224811394.9498', '2697842514071148.65', '6.791924175882585620347727294751149080055684613881481427569426305249508777e+67');
  t('33605644614556574.500804536703659893409117374', '-32.543409918351171133101366277860678601667282494', '-1093642268261945046.079483918411013199812861395190797870188216612955697572700923777661450756');
  t('-16194637333856709349021519708.8552324881761540256020238975', '-468.317375400951782165492196622874246631857734334382', '7.584230051762041449005379580598839525796458346850505580761259136785876093027076066542485326077054219893845e+30');
  t('45938105933592236851533187176.70670204189811056', '-23728.6', '-1.090046940455836751355290385241202650071383506234016e+33');
  t('0.0000019359500318287540988972385182980431073131086249', '-1.433', '-0.0000027742163956106046237197427967210957727796846594817');
  t('3.383292222691', '-0.00000000000000000008416407858503881', '-2.8475167250671594974339763771e-19');
  t('-1781216226076936151337005862078252102700230837', '-139003643961.53840777847576996', '2.4759554610811353724544585499901643072996118138112041996180785490331025652e+56');
  t('-4942215729757062263164723577.197780606517', '-15241705.579', '7.5327797060859772211128133542568249856768162658343e+34');
  t('20212448898283508798.6625218057881201405', '0.000000000000000000473337907308896740021174588136160473489005777205', '9.5673182631015315198993602152061224371243489547543953762429365302559862133611162973025');
  t('0.0000000000000000000336083585075308914988259705527435231286920', '-1042029834722073772731648833.0978', '-35020912.2608826168412442748054117197175486895048242174316983271784220776');
  t('2376653285350901814422.788590453876', '-7116898082702.215', '-1.691439920976175340680854757410757210391140053534e+34');
  t('-0.0000067077602282', '10325935005362413727223741709915.3224340753', '-6.926389614794815252662513824455946141306951378398346e+25');
  t('118620396179863704912953340.8484888231431511', '0.00002664482432944840555300828814', '3.160619618102041148915830017998160333002812044061355761312703976357954e+21');
  t('-0.0000000000152038475299141990408716170165065', '0.000000000000005856774815228245375399878344009978104812414293866282', '-8.9045511307771647940461821641351376995341987855772716940834996589432243659697783833e-26');
  t('-552929555032574543198346', '0.00000000031628803556881', '-174885002769189.22345730619750676118826');
  t('0.000000000000000045838', '3539579713.731326460', '1.6224725491801654227348e-7');
  t('1392529024903490704995506782982906.381429', '-696.803141131', '-9.70318598668840847367530799623705904459432004456199e+35');
  t('0.00000017046264046382452', '77820777096586290650583567570533323989282', '1.326553514683081867495692236827890756347852656781320879464e+34');
  t('173.2', '400230281235477723305446756183676238679630391', '6.93198847099847416765033781710127245393119837212e+46');
  t('441.339801980', '3859926956832539877913158087979570115173.37608', '1.7035393987857371577386465661853388929161435925152686384e+42');
  t('146444036588433930865962234014095372651938826216413', '-52287041949860150983876138.09252718579', '-7.65712548440629977355786783708824277254343945936126868688503521615280343003456839837127e+75');
  t('-152996991626635397079841283901340.65158799', '139164451.4055465586500905725256511816907743', '-2.1291742406419715449781823729219758981469966625530964344454535418866326578427680657e+40');
  t('-2392095943969007513831013778238', '283213.66941826693939894680290224', '-6.7747426989201568951320097088428601075588412800688116615345312e+35');
  t('-15192560288102281367737239879605.47240096086', '-81553445736510122', '1.23900564105440798918085016560369292282227123306201591582492e+48');
  t('1.7067661013360140299015089144175628', '-8518082392971818901480808577069938345874733', '-1.45383742767114563412540521449653172561766842289564535605710831784007839607324e+43');
  t('111116813960956208515375359292296052638950332201721672', '-6723639335232846900768096240894018745358463215413', '-7.47109381153635523540473499319528741906993971058857734750058361188185043050515216086975306279606530536e+101');
  t('-19017520.49675261317806237143645102654220495050', '4439261178196804.5636234243239638305', '-8.442374044679588557398641259522603028251217372386419857709859483039768004289025e+22');
  t('17312453768.05379', '1726.44336801935101862147113581125657128654142147602', '29888970991998.0896280136870221704774967797321308901016337045551158');
  t('-2', '-8.63876', '17.27752');
  t('734608.2', '0', '0');
  t('4.1351657034625927353146715451605855050687982255845069770', '29034498780299324669067501513285520', '1.2006246357352024765485891656111571028229380504313388083084112136514462841267544463307304e+35');
  t('8113870024531627718699652079910.7068190690295904975254176585', '16923534495569343509614671152502455712381.505727413', '1.373153592527270771522358333649474524182371877317191394431842566433920202044363434189424789373922626777224605e+71');
  t('-10.01', '-4864429445729841.069760518121786', '48692938751755709.10830278639907786');
  t('-2257142436339514797101935880.78', '361.115', '-8.150879908987438859554655755878697e+29');
  t('2334599.31164827194227', '-29960204503173960913.6', '-6.9945072809951386426110474550748535657872e+25');
  t('0.0000000000000042471515826788460724024393725389035009593598059706180678', '828398091382.612675070213', '0.0035183322649037987809384707757042363075619742175811901626183872501809043713944414');
  t('-0.0000000000000000000284493127383335026590175755701910596367998889566726', '-0.00000000000000000013237', '3.765835527173205746974156478226190564123201301194752062e-39');
  t('-0.025286262', '-0.10797436581647216600797099911020807463243214320798554', '0.00273026810331915910538504877190248824967123287037864285665148');
  t('-2.16564935772054852403', '123868749404533277771925133166764554.44147780538237283827', '-2.682562775895750704487504519843216927715513029094342900139628307846103986281e+35');
  t('488112856156098659519479388744402.61', '-3114334168535743226695852106494538175980162249914143.70', '-1.520146546028510353469309736526975923164123845906295275264771051373672808879616446195057e+84');
  t('13062458273.90637045335784972', '-422551949801626.741267985176602715381458097174737967000518', '-5.51956721284152853764296726669744927261362132472755924039708895768532345915860615496e+24');
  t('-1774897196938188058987.040101468413944266333770483137507', '-546064776871.3594927107191784', '9.692088418156530694143698199431520418181775404052225935078568528036161040292642488e+32');
  t('17667764535653225248288857836.95612603671740964890', '-0.0000000000000000319890032591629766', '-565174177313.13507635499469894977748029671843469133582435048491574');
  t('-281835819.9184911063', '-7175814054420814885484554.4', '2.02240143761032232334599327109026978241853272e+33');
  t('0.000000000000000001503903188910', '2473558551492927739005724.481043938460207033289961875', '3719992.59354581446800290523978683389613115250358419250482280625');
  t('224371010310.537303586', '-8046248744083810452149728.077812213', '-1.805344959919976464767416627850984855572049419079495818e+36');
  t('21241841371778633003043.69805019497112440', '3019928870075002318121482.417', '6.41488500121878843990786691028203447626143414100289387726373196748e+46');
  t('-0.000000000000000017364919937061080720023417741392471545683503908', '-0.0000000000000001101', '1.9118776850704249872745782933273111171797537802708e-33');
  t('439522909103802363083392888521183473696.816065', '-2.2', '-9.66950400028365198783464354746603642132995343e+38');
  t('0.0000000000000081177461857815960900264491259569062173810350', '0.0610415335877925918303617472579311', '4.955196764565624988836180976890473307042478930774835424434663605140744766885e-16');
  t('-186798563956757871041672400714377.094855823', '-1262567588714917541983982710.193577', '2.35845812470293091731202495176066945197325419055745256762489749711235648871e+59');
  t('202739871381.909125537', '20323942031180.7301604586345358572504650', '4.120473393374958139010105109821762644139100410749336624705e+24');
  t('-0.0000000000871057582376852096451379468926610553156501430073631916', '-0.00000000000000000204556363069958967723715901466977445824097114499093', '1.78180371075520049530019591335531323553330829840490421849868550913658281328132369671225257713629597852188e-28');
  t('43650.3286859870996376890566772833', '0.00000000000000000001310330289622533562857521522228834136757813518300419196026', '5.71963478292282611553143218521780871633322080859969244917523136988043505512171959238361658e-16');
  t('-1092205601185294', '2', '-2184411202370588');
  t('5860768904954696696.24176142662833543847', '0.0000000000000048972255', '28701.506930951217005600908223400663331828964985');
  t('-85896656824567.02163635501735158916726224558523587655', '32321.39', '-2776299344922992287.4470686942774805948582718361870079644045');
  t('0.00026', '95786603846831218908589843126114668233645', '2.49045170001761169162333592127898137407477e+37');
  t('4045878451917596479346482', '-2.2547', '-9.1222421455386047819825129654e+24');
  t('-0.00007402891873793970469482766866928008041088343139', '580', '-0.0429367728680050287230000478281824466383123902062');
  t('-294517422548703614947348777318332.649869292704089396942', '-0.000000000000018464905130542546160683866082', '5438236266653724351.349152153311431266266033202633265447500622081254643984468321244');
  t('-83.506', '-8171012757524040761112.5', '6.82328591329802547797460425e+23');
  t('0', '-0.000000000000000052054568154502662326801153388437977', '-0');
  t('-848457792560875.315304639536969249869368391843456', '2786837672040308423168750746536175069.979124227', '-2.364514139444808677729215519365182902026897625419714103499744958027008402375235640420961008512e+51');
  t('3114192', '0.00000000000000007442771895146280027117559688227552768887141498150', '2.31782206936893840902092874406007390124461849564067448e-10');
  t('0.00000000000000000004917302646400565894337036110048', '-422918872', '-2.079620088498342188194690499484768025856e-11');
  t('-497313848.92', '72015813415347226684601.47954307807272704460158688818499730', '-3.5814461352690899900766892687894799291942231391683303086680262807916e+31');
  t('4026.7272674898467547880850473160814529617052037657449361', '-21157682685', '-85196217784587.2940970833078499068622793775121577888984306494014285');
  t('161789945200634672.93574932528', '-8005803048483811151653134568908048072385822541265', '-1.2952584365012698158369216496463941318557463003471359935387477829065387076792e+66');
  t('-0.00000000000021548823070578223953868560097628121116323968225230682924', '-49653567182460198793826479862157.077878', '10699759340379041130.65114538401855139934323670216223964167385329900350710562551938222192755272');
  t('-5565648526946998.206396582068274786458395468246488801913', '0.0022945055453979742566004395333553200630524525428518539025', '-12770411408815.9541406930749916678604063671114068656466120089976699763004963995450912686342679576306781385154825');
  t('3.271826', '-23890.6474306628013', '-78166.0414204757505261738');
  t('-0.0000000008805699092114903173390188646922', '9284821552.25745813417849639083469216233186', '-8.175934471316238510307959904561765618357930068136953080998844682973153492');
  t('361333176.6552043788873570', '425816532338214481.0652246362221874080822', '1.538616403020706012031174663425818903103785031033415757451967454e+26');
  t('2805.024', '3138666568668923617772609.35105', '8.8040350531139788020189957723196752e+27');
  t('15516261613526.6610074517562', '-0.00000000000000000236624580694534592762621412652683109621677385955', '-0.00003671528898247448920639683215816512848818717755547603887938060370189964171');
  t('-0.000000003258489294057571', '-0.0000000000000000001263694100620034334234551033555508871', '4.117733697834092773082498224393477748428351275212341e-28');
  t('-21061048707054855665564434392186020553808698597863.879494', '181831629693595281071297779845', '-3.82956480945997219565546562178683388176250894166635033461551679226752688144082199843e+78');
  t('-0.0000000000000004150087739116129831368627055614', '-1518028660414097725821098740744462450073.304250189994494', '6.299952131211430047024557585815135401837971947761937657558761468690680184406091789316e+23');
  t('-329353403844205335310.931518048486742714840512646142', '0.000000000004737902605006197777999824176859382087', '-1560444350.041118731605073747643365481135986445785795088564232590700292190358983404458354');
  t('-36414599958286461846528123709871289767333710768520', '-11982666807671338.82516899790506494507', '4.363440182347893057208595495864483712233866372669435753275016489496855915098212851964e+65');
  t('119742066861.890807047', '22054829383.984629241', '2.640890854724681514607753859168565061327e+21');
  t('-484485733573777836334476960525005005848019789', '-14406177805616860655.8627771810687838', '6.9795876221485617831711438674257823866674330443283469578093046623068838325626182e+63');
  t('5988848948477.078723617', '-6.5', '-38927518165101.0117035105');
  t('-1.0', '-63379703.864490098873312332', '63379703.864490098873312332');
  t('-0.506613427677516177791327725446313117452', '-0.000000000000025064675288473359447414244747114622651598944039', '1.2698101061517425226884571964189454600296022874042153446180321519393920461477382268628e-14');
  t('-23042537.21970212804132180', '10390764065108.50823342162627716811120', '-239429567711406187063.05734442567122738046800108051885738416');
  t('9812550833139441428690193893295885866528739.860970333644852', '-6934084675959416258239634601815942.0149731256600469716450344', '-6.80410583641450037528576307977037672169914839765125030421279633360096772675136555394720496053502446210349236989229088e+76');
  t('0.0000347689', '0.000000000085057549281766287602723911010', '2.957357425222803877030347389515589e-15');
  t('17309197932605.95272164347202723030822567422328', '10372291249693770815173154703247665392420536', '1.7953604225558623153970783373103876250250653717733283278048673842023984171292886092127808e+56');
  t('-10.68586744857482180099209534824648355512284245440', '674588.26676653525901087', '-7208560.801031027382439380269948592059745431252505648164243884987079328');
  t('-158425376406388668464703992996848728.8980383980010724', '516624932849644105480296.4740763529887132394681136194056', '-8.184649944763013743333361097416811851476935800617569830052596874617614630479435342869900779234127425056544e+58');
  t('43701371988184830897740842', '7444696727806908941269732116534493096172849746185.16', '3.2534346104111212105848066810541857916878449567515264310528659180255182630472e+74');
  t('18985671206766137596695783', '-4918195942924959263752039745340080571253768938', '-9.3375251102824433332331539143355814981375199246602425748207454160988454e+70');
  t('-8164454926564686613685695436631269148628112649072225137', '3017566861500503598.7', '-2.46367886286161259704778334978048504960179943566519245177920238542851005219e+73');
  t('-167.140200050688164319586013710074703990054053511303270', '-124707.791051624249704808849761672566349962496678', '20843685.14424789642526902036712772659312890967899817539551993752122248668554302671208072486282553706');
  t('0.00013717932814418', '-236889624553106847157555062629.1419261258', '-3.2496359540522243673339058837639891572432570371217844e+25');
  t('0', '-7377966474', '-0');
  t('-1165159893843574357027338982426', '-7258741844369034621359206819796872729971572863114', '8.457594876822935516127237999861301735400382433503942145536493041682252149634564e+78');
  t('127327741', '-0.000000000000001314349415125924728376790639', '-1.67353141912655226200255348893816499e-7');
  t('-19', '674693830910632347225468600360472778098653805584.98', '-1.281918278730201459728390340684898278387442230611462e+49');
  t('1115499473064514172110108362485045185533368299248344166641563', '26727699066738.5277545215239', '2.98147342251737349166633853134205297966348378257402631237265170730493167637686598378557e+73');
  t('9531022923010697243825538443.3659', '-10497868918011538716', '-1.000554293003294813441624977396834705527412812041844e+47');
  t('36948.619152016593259861704969912416', '-109424973578674628984651491823525807602358729239', '-4.043101674477927092300739573396847025094408695070482727807518216276085630888331424e+51');
  t('-0.000224994118800115645797961334226721592496197539765940949883662', '231860.641001', '-52.167280606449958627644387092820869098935873225250256147940687697225662');
  t('-81737025015671727638688.506795636777200442300', '5419138.800783060', '-4.42944283723002262118621171335050352165263579845818347438e+29');
  t('-1466856541.9549101', '-24128674849693158122765920.4', '3.539330455197531614891444994295155372575604e+34');
  t('3719432135548', '54707696881', '2.03481565841010488825788e+23');
  t('0.0000000000000000347350240379700980370747179429442891350492370249744117', '0.0005534400198558475169798243101266211771697229801', '1.922375239326751185420171365530525629522813111237423841789162415238003577693927327244648617996830717e-20');
  t('2248441073845808666637746763786280194954645599162114623.5', '-6334923145497633015473724024497.97', '-1.4243701399993365995217919270799399913979461349413953499228708640778427689308423183064295e+85');
  t('-2833.50779749', '0.000000000000000000027787099520949762309607915049358999802', '-7.873496316224179511483613883698024416527436609698e-17');
  t('0.000000000004441882942767312311877169439858885409', '-0.9432493370398481379786084999178021934162', '-4.1898031409738770478382967231410155261701150266906290976528356507851700442258e-12');
  t('-2107306488.021444213082463895093082025238625832167567', '-0.000000016561760020640192077800', '34.9007043445492445900173806825761285679208256730753889935834487955007126');
  t('-129070822817.42205', '336811489052744821.06', '-4.3472536026398913255504341077748373e+28');
  t('0.0055725231631263368659868273181674133608110946135789308', '-152412560828753089910310350.5653132', '-8.4932252556962839520515736693985586025569561774936573592091065011026694067884882312656e+23');
  t('68902.0767970349411722981874624462811895157551795177137623704', '0.00000000000298788286086686468161985148648212755894442142', '2.05871334339993176415426311877635990320333360195205545566288301397039058040718828895421507390094595733968e-7');
  t('88153860095637039945277243438872776.064214155', '106.735', '9.409102257307819458559166578448085753213897833925e+36');
  t('3.7075516820964288985011546648796', '23633186593.70572408884166096265287527701858061993092', '87621260708.792430109916115951342109977008394099657174865349158237730095429102117232');
  t('-35505760506401161908713691885731701346896104.7570686644891', '-5457648514664450630675291184021238402035211', '1.937779610897920137400487822865364585421914753043232864073023463191678738063333894770237751635257001e+86');
  t('-120.55403235772170', '6237.155894', '-751914.2934654306175666998');
  t('-50246944566472610231911381270921126440112308695', '425722751177060307857193841626947340', '-2.13912674790799614679030549405709134417922674778586880217918152980768287325891213e+82');
  t('8119749715097219059818517125264159.064450132566482', '560418609424712067.0940695322762258473926083185', '4.550458844211485491057203230529751310726950775388516102150563306194801442473073934282587480517e+51');
  t('0.00014717424858', '-7244528491321.3877', '-1066208037.026626286030354466');
  t('-42181198581127024501.50753334291048422600', '-0.008682426489650895544', '366235155926002047.202675730675546783334970920687585688944');
  t('-57.3', '-96900776925224476370583151961084756', '5.5524145178153624960344146073701565188e+36');
  t('1083976078583942678025084625.271006', '-0.0000000000000000534905554182086699326584150063088902383604755', '-57982482503.506901999157564033733434733806444040999020955818569250676306523353');
  t('1058587.736740719', '2.2', '2328893.0208295818');
  t('-337676088587247469427246609', '2694990217595978128', '-9.10033755458704844211026116003411819226167952e+44');
  t('-180266997707357275243150935948776784257767.114595713620465125', '0.00000000000000012929550822108208448723385741716775647229370346', '-2.33077130840613978574569769854573934386258812596377482210267408630672963476159438278046789605387340218325e+25');
  t('667863393175854.7645678', '16647944315358092755156.00', '1.11185525798577381655823461635163932295615768e+37');
  t('-2607482796153.37663635999672298', '67905.1', '-177061380021074655.829689213473629198');
  t('0.02649777513989417670980608', '-3.7', '-0.098041768017608453826282496');
  t('41727029296529241379347405093482273986363238008823.7495', '-0.002796170808176706621979157103112461500671267733114714664', '-1.16675901230889282855531874612261889002345278810932959186816789276573413038428661947418401753559128959112668e+47');
  t('-11232695034932926234846674550549966790.9183', '-535612384919640506677833697180021817295233383415483', '6.0163705767354292540256743939915265501958563028272108803751138896375435530577152378000080389e+87');
  t('3.481826810306751', '0.01981896398982153971994255430994006244', '0.06900620017226469113521762438686245737379444049353244');
  t('-500336401148192185730936', '-0.0000000015351207243732', '768076778560892.7643589222652324493152');
  t('0.000000000000000010152819846152021274527085743667507483', '2034271405274844529575.93770552252121', '20653.59109593400315620700194269765880413700716562682807038424236270121443');
  t('-8', '14804.920611063196753', '-118439.364888505574024');
  t('-7644880', '32.933', '-251768833.04');
  t('0.0000000000000400490024778789822215877572796299412810612705023875', '0.00000000000023561893047293924977558189853184387736389392033215150171', '9.436303130345939646688036612188083884147595770701765354726302304762424603125782629215278913888534265332625e-27');
  t('-669622098209324787.5786201166', '-442008.19657257', '2.95978456014644004507422179531566173761662e+23');
  t('3750095561598843110.3554570', '-0.000000000921072821137', '-3454111098.455188785930556597852894609');
  t('509.01003417', '-0.0000000000695541947', '-3.5403783020913832899e-8');
  t('0.0000000000000000635110973210625767420869099697944141102671291', '-302.6', '-1.921845804935353572215549895685978970976683326566e-14');
  t('-10277403.8756777588787330367830', '3.73924958', '-38429778.12561843210264377872295730114');
  t('-566623967.574094904804042946014964033941069', '-0.00000000000001662953909014460365351667', '0.00000942269541818623958668998623752446360099484415277625603154138912023');
  t('0.0000000000000000060428627571787342505274', '18.65854757486578220960', '1.1275104224320402610478848029208041233734304e-16');
  t('6026260424.00', '18673139236042341642133200165212521277908.5537452', '1.125291999700035578262744750920904785263182229257757399648e+50');
  t('1351407130504734.056748656589882', '-16213.40426049972577134801362523633', '-21910910127395164076.55243444398575049081525274237838315413681306');
  t('-1749812757762436212668429.46101826944561361814636104616270309', '-259646', '4.5433188330198551287450703583554958847579349723006019196120650614e+29');
  t('70245313181709005413989461536786.3825442617', '-509184726219286329641748', '-3.57678405606165250356068075267063781878365698344246156333141574516e+55');
  t('-16.20', '-83495.2179048376073493099472538', '1352622.53005836923905882114551156');
  t('17522790821382422258618581410703033443568', '5481690529703238.18676804112985115150792', '9.605451649954285042649291504450317447918361312248424196122189225108309342505856e+55');
  t('3', '-0.0000000000000000000298256458973606523936524717292889013', '-8.94769376920819571809574151878667039e-20');
  t('-57135112812568.466051', '2713703246.301287433494800761485396936819', '-1.55047741117257327421574162146466373193666197915868993431769e+23');
  t('0.000000000000000018433', '224.613695971469169', '4.140304257842091192177e-15');
  t('351655210258904818533038059328', '-317039471793459879795242832647363526701869253095475', '-1.114885821139012575684668438594527497497409491712701452561241865985548506983408e+80');
  t('-1317999447639091934290806166798244489675877673.24510838', '51973652129741187036804.3069426597647651181729', '-6.8501244798785198639385417890806274968448700953804306642353363730416792643087698202422857568078902e+67');

  t('-838472500998941781878534497598346150189438395681961909493802795126225423951505690327678802846577883568622319410118', '-2884829948773734005744162960155700874127.0681001892763437635520740604769472972181496111013', '2.4188505821049618555759179210300843443018778137981932674088381260022683344838428233063800820435344194302980110031387348601685636929132993133036482870813353080292469079495502993056630049417824321203429534e+153');
  t('796691.919974655750', '-344177691021', '-274203585471964324.87434102075');
  t('-0.000000000000000000037241136189493487515236242635317406', '-236633306915237035867656873537286323242534.531', '8.812493209800553514615822924219854143174591731693607256359134469397049100346586e+21');
  t('-36918999197803067902650019640975752121441727061986591604616945161242737830954924822209930.0610216157567', '-630816248640.220238311747288806', '2.32891045775094316018876017621573827476363455570577127733350185252461212627985116895575049148402627634872854943933909453127151295002e+100');
  t('-356285686518395271578252895087932787716516776378851836556183.490949109645090654856023328687155015449097603555460351788748359722414863145', '536192552176752561042209607723742909268910764247931780563.2', '-1.91037731558344763167084704445859558938320679866577929319697485737868113003820206731226346686676150919266490086231386325706954806002421869189844369048659180671649946432503759091893660299023264e+116');
  t('-10868240043.323', '-0.0000006987483137538548533133640114148563911523216092560534998', '7594.1644037440686677326890935142678911031312404730399664663577718354');
  t('-0.00000000000011591017649385438295796980510866337031921451760232710693439920068628049494341909991139678975519329366780780539554769715433124600', '26133984739171981586185319', '-3029194783605.121387520277919164440375428744596566999709645269433197968011145816158998774967743687046263521357854521385482216635698201872145379668177474');
  t('-1711273540905209744011506141193.37033113722759550410761924564724', '0.0000000001293732763469758906747311439702612890496046217356893762894231050676460791112722303394750148856', '-221393064712797651093.576041646381279748254325855686348423517448454794870494445248164160406818767744894597164595179089851596941716698075867505673842006555744');
  t('-63062954745.8598353024049107700099585768452939988302739544094597635', '-0.0000000000000000007066107653369429290153271704760473112899492658449746935736601687393998875372553088763481649809909245944916440347928986666226', '4.45609627173810154902373805273164378070520471666107189671611539018934456392187448488034184668558120645401564953529878995106460890572197110823797727327567501341707822274253599872751551397551e-8');
  t('-0.05396306543212365254900360568584', '0.000000135925517648212', '-7.33495760274574245053942000380666682810971808e-9');
  t('-51311181621759783527978578699650628367670018837603370537970304306.5', '-0.0000000000000171073617238152543', '8.7779894447982604608252727389859997980275463423154981803549625152925376395768264295e+50');
  t('780360810680597937530828803485426316757997822572046380524663475663587783713055764905934635773988266249773631591980851269802869685048538490187809566', '0.0000000000021114006241457087', '1.6476543027298657092509209956166007749872751971298560901265194443520620935869459922698982198083609063920515096925628739206594316734184930365483909751507976717094242e+135');
  t('-0.0000000000000001558591643933212408712480642149933587830724439341932663613727360989832586450936995132509861377299507330923270242750447693180038078839868789871', '-899234589140276920.9563731186', '140.15395165697510406375504229464266777072446771644043491265354600675571562268623460258428521212930915552512830838365872392420849552201444571287189837930690619037363617006');
  t('-192128620208427347208760897481755790502927310252099946847941391701541372730741701901004842683652084499599551669587901.095113423628696460069833', '-150027.013347965686304316841127', '2.8824483068535959518771144524961420793873335181555629802553828843970441540984506755823649963472492988719283593979140183046911245632653583841810467259116227616668386421791e+121');
  t('-0.00000000000088119558575179620805745334627526', '-2342970366196339369130467230746566743437618438527.293007742982263818470063380858096529305084867946540343494845177603781376', '2.06461514423948373213684382167619940227586580537675167441830145669955691286212463457073538034124876268856699464885544965251476720909351479389090095755776e+36');
  t('-6635456782135376051461227670659894416124826680462504047183309508524677837974389566804395212269550349799505694436932101464692080338', '-36033.774951979165187136955049120300', '2.391005563910499861359276356470099138701070047532575485529233046218042255556441673237652214828582412128576389116490428262479007258867518065861096006448051838266614e+134');
  t('1.0795693', '-0.000000000000000006209261744497244037804821960982585015091967690457481640260325487223225820327780029749670765451353356', '-6.7033283550236685978221251810425966169333249952098001341386914040137368425931872572708312434887817265895708e-18');
  t('0.0000000003205206100151839365357713821428922286825107015046701389076172910755564034571464044704259976070021361285911146439621197151315883353504731', '181280954003418224438635307210393590651533286700798186230089972712042801144671899167602413575288941132381001', '5.81042819613101098829202896183160808144566548341644020145672547798396356491584355574818346795299101366223635188614907521125965341055497357077467758341149862217405975928504053356664898994511933823140023871980627595465353142713441016064148015731e+97');
  t('60.273280', '-1948051519028114.87884169', '-117415454660806895.9645912570432');
  t('-83193336723730904831044', '-8597513002342', '7.15255794190492657393641372686305048e+35');
  t('-20357731434704594485933.435192883517106779904094737872189392050585959795325610691798979690389882855327158774541534046886050', '57101254487124.26556892385946827693467498483828207557125700861375680904187175758285473565759248405589101', '-1.1624520034335964384881547289755586531335208559562766632031511288008463494925147406785220580646246607391536758053170339436847553410796246157934498139151632371860559137134623242512914876401966834601783673486087092780486894105e+36');
  t('0.000000000000196393242447331955075189676455271786947264076645295021258862881929479958110333580', '194877.520544633956108976283205922142563827316236038257841914758325718909245819798140', '3.82726281398572106089641076236903647054748740721743415697957940132522454065934785001420361718935697399839562856732355534966588993484025198806123215220764836635412e-8');
  t('-8071576425880681257819461150', '-1591541556785189268475083517665125202173160434133152.98399538151538621882421945398094', '1.2846249310556773308688003659431424152963795381736069812397375172279784904016650744805487687134414853173170481e+79');
  t('6215707454580399344821610342', '145319540897984402903779835609411326583090144758472486922947576644983828825850438698150473186142966520100265693', '9.03263753655802873031730925036374079283112281131923966584171630907427735951790460941752213245331152538824074995769485027917034562316597006e+137');
  t('-129348079468144673220614626836759706', '-88248178940421789818564716716211678654401184759743634646878788943183256531349288163631708018145656009375447214258101552585320093130', '1.141473246250472885515118898707262713605663944616163164881785239559268827685334536245384449464192711247404249908389352393586709492073897298343118518559610042335141978e+166');
  t('-5780259200186462371596484655187034250137478170873403737601291296553629304246338.1', '20317804349924669254706871559', '-1.174421755212405947511968636545739798982946944457429152629522410545955272538056812944623926565594717327880979e+107');
  t('-774.0', '31209403299230592237921875076234864775333333322171087161573695825372946329.47956111641', '-2.415607815360447839215153130900578533610799999136042146305804056883866045901718030410134e+76');
  t('-35300012822981309972161307966314653.5746532880996436', '0.000000000000000000330318102723213448', '-11660233261792292.2796305229097940998500752778977839907195278155271328');
  t('-372377963884127526301703864441812802765174863559283045963633022003526893443086066813180.3717468998054326701855782319548515', '0.93426382293185456943254764459757361885785459231935724261799663689196168735639052920121741580138452492', '-3.4789926011396505505944781064660804224349193623867972766690000964018527357693140898258100416659583488178405935796093105315794205956790824509036660608118406568210299647359494344226952122917410385314738577518950473221664938e+86');
  t('24266165641723085835767787003697599948414575.4598063181549354935463146230534386950113305', '-114046436224578769506685348541641847469702436631296179876858707928490406027412029206934467.22255852787626', '-2.76746971227383645895497368320257172653365323571255355106207704032170926692669369847993108061766552826817226048614230592101594822309797349385303976310250855456022415694582167365528080196393e+132');
  t('3296856412996342216590213367517526056709903701721644610.791416', '-17873043539632614693589701036988.4471469786937536273599351623416309394', '-5.89248582134006296943775735259576640781981176325731275908604121314963017378308625998703430431944837580972601701118670108255361904e+85');
  t('-579102350347312720630005129054780607559620407558223441199264163920137899902249163147321939579047776302298780448678174736222915', '-219492399337234160290652558813948662413370806048542871624923.1888570368753037439767245955297245131205931820059590', '1.27108564339563247096015910701131062607103942871909341223369812880561545119021551254208157534581993545107836369462180155951136922383213991699434467561508645543330227906067804094605876984754845169252387320636979899325902200224418682350485e+185');

  // Exponentials
  t('1.153024e+0', '5.28973573008e+2', '609.919225043976192');
  t('-3.699875785122930862283231104748329088664056423999601e+15', '1.1e+0', '-4069863363635223.9485115542152231619975304620663995611');
  t('-1.2682525953252723e+14', '1.788378029508237622037088155833989378609386207655e+18', '-2.2681150773465187729527785601467557683746716925715084680772194565e+32');
  t('-3.87722166e+2', '-1.74278705869601992403691e+8', '67571717327.438998052674620914706');
  t('-3e+0', '-3.64329808384254180872888049513111969646643282968e+25', '1.092989425152762542618664148539335908939929848904e+26');
  t('6.953012278719261355e+11', '-4e+0', '-2781204911487.704542');
  t('-7.04663671550547513365402564941508037562051247993316079593e+15', '5.535517336770122093358205271769744142052184795629511766877e-18', '-0.03900677970460142822373864049115522460524845334243105937826127540936694775384656847162726619838459694385924193041061');
  t('5.08438408986e-9', '-2.606367e+4', '-0.0001325177090713613862');
  t('-1.2967e+0', '5.94990983e+8', '-771524807.6561');
  t('1.3117e+3', '-1.959557842524477358350764324331855847355274e+37', '-2.5703520220393569509486975642260953149759129058e+40');
  t('-5.3548e-11', '1.742694574037778940228462366629620551e+11', '-9.3317809050574986691353702808282921264948');
  t('4.34526424962996265825639250671e+21', '-3.754914933534859756171859142125715053796299171e+1', '-1.631609762109069348677868227008975151085048810070540943592037216417378493741e+23');
  t('4.7426914347369245430071315112274335473949505818891357635e+55', '2.099290936966289806252483785990857067e+13', '9.9562891457708756252380705318075217577762765683497811755225761339325645531279572292864156545e+68');
  t('1.2197662968047362383e+19', '-7.9257e+3', '-9.66750173858529800389431e+22');
  t('-2.18492048239986982664891448764e+26', '5.0217571e+0', '-1.0972139945426971341049955535599032244e+27');
  t('2.8477441033458111e-12', '-2.6015762266879431727233849707015975771758956198e+40', '-7.40862335895523532800693698581126602552353137494951139716821978e+28');
  t('1.17305251157767339030842411702548e-7', '3.1679877726710109082864387936446078459964397e+14', '37162160.13379088759968293791782997863641886182709969796604371507532234183556');
  t('5.516400791447843686549580838221025644959140288781e+40', '-4.534755696021348164010120097087738141133999137556364474656e+25', '-2.5015529910554782273339735168586403296046609840907360623635477256369630649686086353650780443350045195634336e+66');
  t('-1.086178703865e+6', '-5.412964e+6', '5879446221587.90586');
  t('2.193003362433320722921995078848109409779629e-11', '-1.87156484301625964803880921322257778262063404562091823011824e+56', '-4.10434799374664745958524117450745644772403340614160247100180995137281346990234693655901738534901333296e+45');
  t('5.690242268084896613323736558476149127814487192716110263e+4', '5.85123113232510962819522680703136616268672961423348513284699e+54', '3.329492270949058963099905818513145552769091859265632399465562585831994642969765945460416258196265143264172794765837e+59');
  t('-2.2964852129902920477142981e+11', '-1.01192386417445983894690800351420572044711646857422992584148e+47', '2.323868190748643763813766975749316051539457362388056941019107244885259571701270065188e+58');
  t('1.64014114524e-9', '2.33457695670849217356126573862065622e+13', '38290.357234267802543783512378452575905911293928');
  t('4.52030709268304468292307103018250587082757e-13', '2.4202633390406694150089337e+3', '1.0940333537626286438097741446790925743401036958119194290469762262109e-9');
  t('-2.531530179588420531938806173298571611356854e+42', '-3.7916295786409190517918e-6', '9.5986247081496130774858068268051041666243771242517966898979109972e+36');
  t('-1.1137e-20', '3.15532351096658148747044e+19', '-0.3514083794163481802595829028');
  t('1.26704207115899080748696654617058814620502905910804474e+17', '-1.1036640030158560360573681189153991777396167698e+36', '-1.398388724244832908797767208849960696897136903372124358147141607664782163824521550287804299792680852e+53');
  t('-1.92043925491801737087120450765880605794833102824745131e+40', '1.48390768547e+10', '-2.8497545698511264714107436784310097859137225929760606638486194657e+50');
  t('3.8135622104716384192078983238750322e+13', '-2.39302666425671400328234877933630532203640643176e-15', '-0.09125956055460405574747767900047040915488905349535492182534023415362543138557102672');
  t('-3.234931242339998871854389747974137006095446e+30', '-5.92883411067302421812958123642550690642906114730631103678724e+9', '1.917937069526724859889065751200796792104177866908520783368616010428214659504892064497475599582063490904e+40');
  t('3e+0', '1.99273095508512817553537488885e+0', '5.97819286525538452660612466655');
  t('-1.953336949e-2', '7.78542087974602115e+8', '-15207550.26792398884803047135');

  t('-7.3082509513985065717321588249117283909294426665053038123171823802E45', '8.1139587436599483304895082011722489767478591E-41', '-592988.4670796104848902291110510024833882877779324139587779775769322761921828542989063538752670078960459222982');
  t('4.1580690407774531635854811718695276837491313289E8', '4.51151976050001428945887983E-3', '1875921.0642990819646935715021378546121515533349338737465486653798953306087');
  t('-5.94098742155317032555791061122172112467693488807700534435506921715E-24', '4.61016941217052394016E20', '-0.0027388958488934255950077406845338327546662445400484871083292926528860519832777944645744');
  t('3.7504E-12', '-7.88007879736459852E17', '-2955344.7521636190289408');
  t('-2.1186022052008407937878760699384240447915477894859451125820040738844629725E-19', '-7.216767917254229694821186934734207628E33', '1528946042391748.997410886033946108685159225196274137373381385049759221715038347354480872320019684962009305423');
  t('-5E-13', '-2.75399279758638331766833072E26', '137699639879319.165883416536');
  t('6E-5', '2.417496760754967572844203198215987E23', '14504980564529805437.065219189295922');
  t('-4.945015198370467209539041539486792258261028978257673527352148835976343131637595762491692863E23', '3.21738997057546245991016675193089492784008451753637062802134E-9', '-1591004230358037.215453223084728812766073228229224818741711464362077222232342773738670279322956619570773005741693064394880256558629265661028200068969642');
  t('8.944326872147001036632309667E-41', '1.34989853214019743744001484188796117541380712420727841534671603347856989127834147166127622e+48', '120739337.1569336009465330585026690676314127638673504378646869299090176172459431821906069831664699038568059542346321874');
  t('-1.06387569312217787644613114942E-25', '-3.49651047707433733724368394353972842316097364325909366154237667988339210449181953609691895611E35', '37198525073.064174722364904333744771229085129180022174384101305415837978911883846550330098510374779170577866567699408319562');

  t = function (multiplicand, multiplier, expected, sd, rm) {
    Decimal.precision = sd;
    Decimal.rounding = rm;
    T.assertEqual(expected, new Decimal(multiplicand).times(multiplier).valueOf());
  }

  Decimal.toExpNeg = Decimal.toExpPos = 0;

  t('8.7640115353288983769636573243142380477', '98132771361613972783640738.8', '8.6003674020697822292e+26', 21, 1);
  t('9883.35324545076423007', '11534864.85576058804', '1.140031440080173692239106128721010503628e+11', 96, 5);
  t('783715483584289803764074.0162744727280534', '587170409.865560908036543', '4.60174541714173715664e+32', 21, 3);
  t('31262.9696080945278832538654512053499', '1521666893653481239743.043288560492693823973095115099368', '4.75718258499323920319594724294097666996623614819732348e+25', 54, 2);
  t('166409773943488.683641092651970053074130172697160981650', '29383374581263422.64023860404731207688485848306803', '4.8896807217648976193745354023928027035617334126548609476076571e+30', 62, 5);
  t('99801119833708.031510783672287782392', '87030725026830312515179448.179673604958603757057054897072499933901', '8.6e+39', 2, 3);
  t('69731726468060380.008754386406977183117439', '6507714968375561.33257030119935', '4.537942001068668490255113904663360975e+32', 37, 0);
  t('826.39677733802082780060', '868237729898283157855076252483.31358937218256594842233795879804', '7.175088619512201756727486736e+32', 28, 0);
  t('97217122196114863.76307918894', '364113335834514329508664304298161.52242179479054037', '3.5398050663058988634098095121967083071e+49', 38, 1);
  t('694287.0306858418134468623', '447593578620913867261109598650200200326.4456503480625181364964224', '3.107584166547641764350683201983126563462027750463328256303247683293325772050963164554356e+44', 88, 0);
  t('93531032436395964.711423', '6448227682408.97162274053113046870693355787761', '6.031093925206599020774031e+29', 25, 2);
  t('59420641950920240756465.98423943966502979950309', '463601148613543697810692411885405.567307456576230992948033603539274944', '2.75474778598007436599867793211769930534477108061706131687471730901078e+55', 70, 0);
  t('2277315731915149177050340.03547342356244316415202385200697752', '6094500.77365339', '1.3879e+31', 5, 3);
  t('42499210185.324283508514337889872833', '6164109749819966303123685.0308732625627133229964813958076024', '2.61969795863005432962609968421706697692808308727433211318709180244255952739662715e+35', 81, 6);
  t('50420118559072004.14730128780580482018515', '291795344982121444321307800114867269.98968', '1.471235588898387943301857933580557e+52', 34, 4);
  t('539939290941744314049.4828453820231463558332989927861649996', '56.0', '3.0236600292737681586771e+22', 24, 5);
  t('974009303998280915261274173.014298757403849048', '477646393839119546.9057', '4.652320316205296032282599543500856192917503854138162003909582907736e+44', 88, 4);
  t('425036.71458946184', '828502.099774406', '3.5214381051858403971876e+11', 23, 1);
  t('3.0394775192110017953283324', '179399012406133.674', '5.45279265177098e+14', 15, 3);
  t('59591887481255758486.04419478394445992184038150', '4703540070912994338607753391.51553618', '2.8029283066942488985468816630836697194164252863314946121251268601762735534825267e+47', 80, 3);
  t('95721039331714561128531.5388333857551', '55776353283228975465181218023408074000.0635473992531779', '5.338970506403567357128883289406493806727217099380238503907444806e+60', 64, 2);
  t('526585509414392639783563978.124078638369185164439406399142823206590', '87507182704426188499191996302912.695351138484022', '4.608001438182859346468676488909777512497686963711987878e+58', 55, 4);
  t('1329389548866606584.0219028742633681448', '82512404176983746737881954764.075223596979', '1.096911277647395278024698413191e+47', 31, 2);
  t('9700740614644246975635351274850205744655.57062922663780504', '2272806307120089287441.2888975497068890265', '2.20479044526994561155551002188480195431e+61', 39, 2);
  t('29511272033245325473630.9914233118168', '3652962711970478409731.7096578440', '1.078035763202623786222162267776426022008745922576294592360500109792e+44', 85, 2);
  t('14296983312767601794907267485.024743090402168607', '9785251609055993162691824779826.478', '1.39899578965905859019321727491823760297927041482177805249500602271527916358976146e+59', 90, 1);
  t('86375361639533439579498381796.1294234762451026', '906739120390293252717325255078545106.1444764334577910073347022', '7.83199194364240290638163189680542533845422404219e+64', 48, 2);
  t('740414973164848.916954686179490899', '134168713446.24554435393694302876451603', '9.934052436586419877500774282012701064743967970168529777534242152461097e+25', 92, 0);
  t('23606.18678792636558', '92428538816127859383.480160037586533528917526119290144', '2.1818853518286167136498581177678567e+24', 36, 2);
  t('535842268080888.29369988', '5.264688269022545313985', '2.8210425028118864751215030126668946919568218e+15', 76, 2);
  t('14658164987181989.82049386326834040499563407226202', '865918141679263984332567963156509.5151684', '1.2692770986128681e+49', 17, 6);
  t('32538525661800629274238615.58854', '4221257960257328197334.99687127737124932626496743934439', '1.3735351046e+47', 11, 4);
  t('9016577257202221469913.973970893892587089845961069', '717041984762.1704', '6.4652644522657274667472322240270365e+33', 35, 4);
  t('636458802810705.0625167255453931606640198', '1025500890675450.780096456096656042394836946', '6.5268906916060913799615494531479109e+29', 35, 2);
  t('79110380.399139564488282', '253618226821001.00507451769506062628335690320494776', '2.006383e+22', 7, 4);
  t('376873444696269355299365.4531356', '291637790197265810665.5250538930136484438850490707423377654', '1.0991053859525146161055022709845243436052743435939690299036572244868802096241063972718824e+44', 91, 1);
  t('736596301647821915390749553538601616524.5755259726118', '795142.3465487', '5.8569891175134317430817399167404057094937405736308106950045e+44', 59, 4);
  t('1834131571267152475321650.70965445617470881921005618405', '968157051313385666904.75179596420634009857645265066', '1.775727413758793219327376503051947507155974684643899649e+45', 55, 4);
  t('11467445190748986299.92690201609446082017', '523498237.024622524327463960286539476473502743517', '6.00318734053358048573196294397431136916711567368667712641480116428920771869736097033789e+27', 94, 2);
  t('1740.0', '674329600699095.9235720144834769329772751', '1.173333505216426e+18', 16, 3);
  t('2073608914815968480642598159487130353638.403507', '8202785661188.8837288359362245881395096', '1.70093694733658676908209396165038634317062656908141094441774e+52', 60, 0);
  t('9408583565372039515608744.3684350485521856091581100947114429124279', '86796159427820718186657687754456418494.479528815877464198372228379', '8.16628919130005414007709894042072728383299297277052582630118037721442350956148223604782621526e+62', 93, 1);
  t('9724576927702863.00514157261352484328', '4521791471398152.5408432324329596777062957089914679067692', '4.3972509014642054571320962124e+31', 29, 6);
  t('150097.98671404890780338257994', '6793507639662.344499876512736846104161284', '1.01969181943982833972447444409226797605134869153468537641830978304296e+18', 88, 0);
  t('65118175343527.476611386886747972', '1.60950590', '1.048080874126420004181e+14', 22, 6);
  t('76805406.79668422897749934', '59816821233324078222364364762.2859557060466229096389', '4.59425528810999466160015772436770505992265745907144432659598870867010439e+36', 72, 2);
  t('1469386976133686530916720194473533.439610543942924779731287', '9728007344019623222764920709573063.7390426', '1.429420729503528940651228166512782815270522737997255826171601930012314473272257e+67', 79, 2);
  t('1884577993841445785992941888727.692681772714424110428791067182984298928', '71.215134629008945058285774463766', '1.3421047555028615218949107869049097752568550421115097800823629315e+32', 65, 0);
  t('61128482.374', '60842716563.57307948576466459526793664258319', '3.7192229270426548398064662836238579088e+18', 38, 3);
  t('135566228123986394372179852820663.73785657', '50104554646753293.82010', '6.792485485292499562041458065250227993920664022431740601183057e+48', 72, 6);
  t('90.2842162098226193', '2945079612003223.425352321291', '2.658942044452395346683129106885849346127775163e+17', 64, 4);
  t('724.3046165965260324', '9336761295608.4424681600303811056430668100247918', '6.76265931046895657939393076121022270844330653566993116239809005432e+15', 82, 6);
  t('833948566289742156240.447936107644380531030033433244', '52191656593247958792015529.15', '4.35251571882257036361170975172568356720234605201463e+46', 51, 0);
  t('1416602871768308518575661680760149688.0812273123382771087180501509778144371482', '8988960023614.936525007233865813885234186518687317', '1.2733786583663441439087447509752725556340548704454166581566848096781678967647462456892205237e+49', 93, 0);
  t('9569593587222898608259132413.90668285543794', '657072004.304598929942955875345494864161946378604', '6.2879120387369867498747065845987464742501e+36', 41, 6);
  t('804334215574564.25044091930742448256033235093982', '55688438273971108617042699218.90358138209948168910', '4.4792116315667092377278387277247989195238061393700184267551514519131272798066909360107266e+43', 90, 1);
  t('9822620772475417727940129541187011947.820413104363741726', '6136578440346805045758.683005231', '6.02772828600753283057e+58', 21, 5);
  t('44262415003768171285.79666967441127542455960075662622', '914422146623526378080312597381.446639551542695668166751149', '4.047453254248707258604102371217281613039726579222140035456583290394e+49', 67, 0);

  t('6.5E-29531627805496', '-7.57040630422451705434881571160179759007104791141306E+4365358659', '-4.9207640977459360853267302125411684335461811424185e-29527262446836', 50, 6);
  t('5.3E+21786', '-9.76622618786797236903307526753201665260894875109978140359393E+9182165', '-5.17609988e+9203952', 10, 5);
  t('5.5297665250143884700019985961183449464816737E+936', '3.3796232965687616E+296384166834', '1.868852777252471286480617523122074247881936133470334630428992e+296384167771', 76, 4);
  t('-7.215109376109932339E+2652105', '7.24526971652521943869742892785010739038924616963926462555E+8683476633', '-5.227541346414646235922676100980921283032916687496302068942616930332667066145e+8686128739', 79, 4);
  t('-9.216143958548530311990439475093217294778682871E+582983187', '7.249053792737130562632580435185577983561593615E+942549691138547', '-6.68083233171276158556289735538540890585083e+942550274121735', 42, 3);
  t('1.60E+202', '-6.407128785144E-1033137', '-1.02514060562304e-1032934', 77, 3);
  t('2.205199208254798821474950998902191375631503824848921578E-31040239', '-3.3880545460122022299262396676563823061715925772E+85847945', '-7.471335202390180221185936884296420222859699405817191352101605427e+54807706', 64, 1);
  t('1.6311190345265678763766E-58492573080', '6.121758534229122431000830E-83814471595', '9.985316869956583505381162042624971114851992578e-142307044675', 67, 5);
  t('-2.84605178661532285450011432239310046E+54783459678', '4.6E+23843514', '-1.3091838218430485130700525883008262116e+54807303193', 70, 6);
  t('8.5973457945E+50399024742915', '0.92286611262186515446807927209452702698', '8e+50399024742915', 1, 2);
  t('-9.37175614356322301483264262858817450955115571074774280431816E+820', '-5.8990551313492234E+5043468', '5.52845061684402398929718264606605040162316531044852111077181139889284e+5044289', 69, 3);
  t('4.9309172981597834254716114236938809737852E+622197935770', '-90388850037180804810300832311714283089697161065337.1762604', '-4.456999442091054136760545232185631743357676415045555277342448095504338e+622197935820', 70, 5);
  t('-4.5318175283930901279E+257711762470', '-9.526792268847312998999055E-689170', '4.31736841933220293960040853567839111019291345e+257711073301', 46, 4);
  t('-5.8485208434582231935912884487991260791234986391206618078774E+704265708232', '-3.97E+84344039281604', '2.32186277485291e+85048304989837', 15, 5);
  t('8.948010032343111803060117863693331060830530240250993E+9216', '-4.295014E-23086885468', '-3.8431828361054117997708449066212948612901979009e-23086876251', 47, 4);
  t('3.185756757125125107816323513488886171902174516738662E+42054157', '8.06908950729962831216038361716544465020833388684669454928E-96447250096', '2.57061564217272374136338781469713519e-96405195938', 36, 0);
  t('5.2525916740929835502942298722584732448E+345', '4.71657145142231465197216614165779608834340065610E+79402', '2.4774224e+79748', 9, 2);
  t('-3.89225344424E+408', '6.89051755046380019455784229458968806687E+300417053593', '-2.6819640668388894316706943776e+300417054002', 29, 0);
  t('-2.62899171772083482619619847446355938432108410955548082905E+1194534854298247', '5.4889047121379790783170218428373272345901598058E+62770973956', '-1.44302850275696100321962196928350139526413e+1194597625272204', 42, 2);
  t('5.147388379257214801014394E+145685', '-871451.36315899031142129000758349639107634751903849', '-4.4856986198124456473522012534585768386213060847482824297e+145691', 56, 3);
  t('5.38114319975281081541720E+25890582551835', '-5.3746836395492276642812193294683520289555634332372353098E-8388', '-2.8921942317783013844648076943183991700501029553856777114332710316463890058e+25890582543448', 74, 5);
  t('280871964076135618401817180457296.105266734468', '-7.887061633E+4000357553507', '-2.2152e+4000357553540', 5, 1);
  t('-8.88835887E+968', '-4.342636646908781652776E+7024535543', '3.8598912959e+7024536512', 11, 3);
  t('-8.049E-677401925027', '6.1906233944265068994375629680216267831565782872875620E-914837747587860', '-4.9828327701738954e-915515149512886', 17, 4);
  t('8.8474201258056282592641810954E-3218', '6.734889818647060851595E+350385282', '5.95863997265814241e+350382065', 18, 2);
  t('69.4226', '9.3E+8893414103', '6.4563018e+8893414105', 21, 2);
  t('5.4496200747276662620115235573674567E+73497054', '6.1324122147419595938364630799329435142211E+9270', '3.34193167119629312060831661097219240448232664069e+73506325', 48, 6);
  t('-6.40155938120572162197123643404406239443989352196681E-16271723479128', '-6.5302607079733794046998E+622547', '4.1803851696846104251167518538e-16271722856580', 29, 6);
  t('-6.885314662857499063218876897969991960E+325601', '5.612724023214075E+86455290745927', '-3.86453710156084e+86455291071529', 16, 5);
  t('3.0116477E+34906110890763', '-3.2736027840035761593873554881121013808939467419E+967771967043', '-9.85893829515796693219376256485518746593607864916562863e+35873882857806', 57, 6);
  t('2.17214889901473709634572E+85', '-9.67073449015503646158535438556730E-6375241745195', '-2.1006275275454107335252775478289115070676115032739126956e-6375241745109', 69, 1);
  t('3.05540807398194033E-3214459', '-261138589.704559597740507442041713439449886297801317961162239', '-7.978849554115685928e-3214451', 20, 4);
  t('-8.73781828060529448236834604892444E+1948580683', '9.478856719915468792231243799601849139374345738197715542E+816680159268', '-8.2824527526515722939252636246780210601567507e+818628739952', 44, 3);
  t('7.7347070256738760192372923810083E+84912757', '-4.2406171585544227861811736221460633E+9292884376073', '-3.27999313294640829790116089024e+9292969288831', 30, 1);
  t('-3.0733080745642545872718080859554759E+853', '5.68364318456656220657503596215363350177814066E-2744', '-1.746758649207050956e-1890', 20, 0);
  t('2.03705113002970753490764690580603012081557995076025852E+2111662', '7.47470103253575010872293625E-75867326361147', '1.522634818496117146621996031155706488957762e-75867324249484', 43, 3);
  t('6.25088801982750097072E+47381290', '6.260997127481331024451319844070682924210806197112221662E+20202191389', '3.91367919363474489475816842734494993064509e+20249572680', 43, 3);
  t('1.8386551234237034678148677060345720766015066E+99289792', '-3.87113785421249924946369380501607446425E+41011861525864', '-7.1176874491272534089e+41011960815656', 20, 4);
  t('1.38458076206162843942007838321318483E+79178', '7.004377933941450094882084405E-469164', '9.69812693754430751693405317027143365258271565595283814892557615e-389986', 64, 5);
  t('-7.119393156946169853E-72', '1.265962432255999E-4035270019', '-9.01288427715428840897403e-4035270091', 24, 6);
  t('-3.437088094735134294557167180255176212E+310798354', '-6.435557845E+3482', '2.2119579252028797e+310801837', 17, 0);
  t('-3.63207504408171609E+49', '5.4E+791', '-1.961320523804126689e+841', 19, 5);
  t('-2.9337943909355522329992160E+5647', '-6.5698889458878729147799E+9345147230723', '1.927470333851532940029648358486997805615152e+9345147236371', 43, 0);
  t('-9.825189421836013013446677052993363359583686659522658576464E+214238', '3.1167194089935487908886238094518859573877028160573683E-1674069356', '-3.062235856807440582266669090472515057931733248188221626404165573423007123931154e-1673855117', 79, 6);
  t('6.701E+105916', '-2.9124960E+549610078769', '-1.9516635696e+549610184686', 42, 3);
  t('-7.40176744979E+1287276', '-6.6621168863945191094436595132729850692936897900365488E+46321370603', '4.9311439916411254856540217581243655352446700713738186362268884752e+46322657880', 65, 4);
  t('-8.918808885384742806671174747057876288E+1763712', '-8.4003738391593512440070605769E+519969', '7.4921328837247966213851255141437e+2283682', 32, 5);
  t('-3.7686243415791453304045387688224491933692808778079206E+44709492667151', '-1.2034E-5043203242', '4.5351625326563434906088219544009353593e+44704449463909', 38, 6);
  t('-3.73617288560281657918403493772051287946683185728289195426E+40547204', '9.09299795858826904406959462172327565978E+5650677840859', '-3.397301242172e+5650718388064', 14, 0);
  t('6.6139595744581450285013546686588487999358280258473489135157E-487794055832976', '-7E+4', '-4.6297717021207015199509482680611941599550796181e-487794055832971', 48, 3);
  t('7.122494472899604291456470028972764307537690E+86322342278', '-3E+1760346883093', '-2.1367e+1846669225372', 5, 4);
  t('9.20244792087162415396453576827457005169120E+5505945075536000', '-3.0467106491328930959906654469939666873099077467288E-2478440', '-2.8037196078610428466706859e+5505945073057561', 26, 4);
  t('-4.2210567526544976259E+4894', '3.438532765228373515E-336', '-1.45142419478909683e+4559', 18, 1);
  t('-6.080608056763958537E-31157141012336', '4.334297565996549', '-3e-31157141012335', 1, 6);
  t('7.883004787674E+8779715347958007', '-921.70034886657814134977171', '-7.26576826291603e+8779715347958010', 15, 4);
  t('5.91772672038197692527032654433656382886965570170756E-89763905502', '-9.0334397331315328187687100039496402783511598435173E-202357244', '-5.34574276858e-89966262745', 12, 0);
  t('8.900645799548909690567378674595525119476386279449E+255774', '-8.0444476449172836295159734562448874581293287939393E+66042757854', '-7.161e+66043013629', 4, 0);
  t('-8.6571251689720182468117989629379E+9159', '7.611106265318014710E+780290', '-6.5890299613205204838047936743611716e+789450', 35, 4);
  t('-1.7984545186344306693549101522157541837E-917606295901073', '-7232.0662832789693446638147979317054765022674381', '1.3006542286226774925213890694854050997935879322232583835511086817132288e-917606295901069', 71, 0);
  t('3.93376256147804658481293736906817781406191858E-65', '-6.656937808682576075290362554936275884361331520701419389E-8', '-2.6186812725883224882764369964078206661107579995874900802848345679822097e-72', 71, 6);
  t('-2.149465816E+138929948944', '-5.3564207E+5348703457899', '1.15134431907647912e+5487633406844', 28, 3);
  t('-3.907039034448406782015263428840879901203E+9290', '1E+663831925636', '-3.90703903444840678202e+663831934926', 21, 6);
  t('-7.82223549399761698791698178E-919496', '5.53809624E+91915361', '-4.3320293e+90995866', 8, 6);
  t('-4.19099109E+4089647656', '-1.43145673878838054505158894395674407848872E+7076667342352', '5.9992224379825602598405528544652237783564861855048e+7080756990008', 66, 1);
  t('-5.802857724249977226294028100855E+871547605739', '5.20449511615117743E+5690760994601587', '-3.020094468557914235476625626549626251681504e+5691632542207327', 43, 0);
  t('4E-8936', '-3.22895995617131E+34234648485434', '-1.291583982468524e+34234648476499', 40, 6);
  t('-7.953379574720339939529752388993716753357E-5897640545407698', '-2.1435069248172166445581105664823131091862E+11821042971984', '1.704812419411285819296573417363126788538469760437851287104393447367e-5885819502435713', 67, 4);
  t('5.67782008866580006E+2921497710982648', '9.688225096E+734', '5.500799907358494929821030576e+2921497710983383', 32, 2);
  t('-1.728733127756E-79731512', '-7.889132849919685715481982705286213652596121410E+4699', '1e-79726812', 1, 5);
  t('-4.9836647991068250676308837296998E+922121312998', '-7.60834026532646E+7355690366', '3.7917417559934560408683814949787143004844796708e+929477003365', 58, 2);
  t('2.4982203873996828522277329301572638926631985424012E-3815', '-2.5580928311960989136422623079192392842789047480248298863087E+685426605', '-6.390679663755069739965425483586e+685422790', 31, 2);
  t('-9.7843293258078674946E+9239504969564', '8.5890260078605815715619211042880714715553E-7488929054', '-8.4037859048836763704212458654338820758118494765563615e+9232016040511', 53, 4);
  t('-7.829133199E+5762753132198', '8.027889595535365452740321008248481E+359616502666', '-6.285141695031261184e+6122369634865', 19, 2);
  t('6.27289905593802746267813935E+570495764671', '-2.42029231362653838655130568984805190880E+4260', '-1.51822493692419769258094154e+570495768932', 27, 6);
  t('5.363251073667271291029867925788675949578386538E+986', '-3.8752025558244767725520E+6211388097', '-2.0783684268203778862480333396069739245562284880933e+6211389084', 50, 6);
  t('-5.0921572620E-179495053', '-2.17281705489243865721978013228374867125793627E-18123325', '1.1064326145067984137251232130652011441e-197618377', 38, 5);
  t('2.640239980359011041435877846577641E-38944729', '9.1525829297073555250734671538673311020732775E+9014', '2.41650153745647680867953360872951849287048542676198601043244628359929750883775e-38935714', 80, 0);
  t('-1.93663758006380022987687898502055761E-7', '1.2996882897952E+45032', '-2.517025184386235235273221471499519318855176701472e+45025', 79, 2);
  t('-7.79624787528536087470E+522844', '7.86052E-36308048613', '-6.1282562348638084862796844e-36307525768', 48, 0);
  t('-8.6916130130673447148591023E-35071865871144', '-9.9238734332603261512468E+827', '8.625446747255875821946163029823367918470147374764e-35071865870316', 78, 2);
  t('4.00947946956450859933153631898545750457438090160657404600478E-80256665343425', '-5.432347705196059882178310037458406326102535813834E-896670', '-2.178088659551947371143060643834448e-80256666240094', 34, 2);
  t('8.5237189533806E+1584254', '5.559104516659139407296405310312455019209323151352988851E+4168669121525932', '4.73842445324712059856820248906971310602994071998002270539e+4168669123110187', 57, 2);
  t('-9.5567131066523154803423960119663705401544923465878340E+923201', '7.231731765301542236921134645986541738098510067263E+891', '-6.9111585745251135317786803544757506203200056995334205874878457e+924093', 62, 0);
  t('-1.168262681298989991628574470330473680056939158E+2839315483445591', '-8.3276E+15', '9.728824305e+2839315483445606', 10, 6);
  t('-6.0781541404E+3894398400574661', '-3.5551844886168367843114091243483844694E-468799752342', '2.160895931937228316971341313211647151473466710376e+3893929600822320', 70, 5);
  t('-9.930650769E-29', '6.8663587981084446829E-201686', '-6.81874112786655419357e-201714', 21, 0);
  t('-7.335392379743827850E-8', '-2.7319376535378854572592620827E-2770314405323726', '2.0039834645697038682119651541820671550861263195e-2770314405323733', 79, 3);
  t('6.526581741082787243991555642172262538786965980061353690513E+139613898', '7.27127468783930012341873509649266453712072899934263E-36', '4.7456568612049419e+139613863', 17, 3);
  t('-4.22121443693737169738781063964E+56886231777', '6.46514882556814689849853E+284324335', '-2.72907795594369551182e+57170556113', 21, 4);
  t('-4.2756487463198090289095525688E+2144035393917', '-553.0796', '2.36477409835506144978568377093087648e+2144035393920', 65, 4);
  t('7.6896692111943855791178991668625756180248214081981494E-71512989309591', '9.182346838994448110268897241888100554017096E+9110', '7.060920977432369764143121866773047198394810733518419151011992e-71512989300480', 61, 6);
  t('2.180820361230329375484504788788352570472611566909E+490568502', '-8.7402170748877831954755703095889597E+1636791723110', '-1.906084335848826812330467513562092591013488107727e+1637282291613', 49, 6);
  t('7.029746564122600884257343821598015E+1986035361995620', '5.97888721757E-11321809790574', '4.20300618749892448e+1974713552205047', 18, 4);
  t('8.9082309066978726571172660992155288568183961846110E+92966609287793', '-6.372745936836552863893242035962375E+720', '-5.676989231506066923271e+92966609288514', 23, 5);
  t('7.89339268979572378738067183817058284E-34354', '9.40407207779209729787E-5641331923', '7.423003379315622392352526e-5641366276', 25, 3);
  t('-8.67452009658410368432993084472027446790739575E+52640', '-1.9127802223015687601128496484168401815516501946271396043E+68866409', '1.6592450478703567557084487969287833435458577809040885135e+68919050', 56, 1);
  t('3.78899780037211610061450014794833157E-25', '-1.781198215051115462248321974621842099810242322885821E-178', '-6.74895611886e-203', 12, 5);
  t('-2.155154073630209625200311251540E+1729442981108', '8.57370176906083278450588440893E+43217803528', '-1.847764829368198853875886103937513376099415878e+1772660784637', 46, 4);
  t('-7.573356931092417337447861170640744225137419531155902692733E+650708627', '-6.153212613277891964490791934374476575722515426852119022E+839147072', '4.6600475393253e+1489855700', 14, 5);
  t('9.9485070330656474601543085707824827201303972914296E+50365383', '-8.339564668921734296294E+51651946540', '-8.296621776147366141255e+51702311924', 22, 5);
  t('-9341189.1143291483367810197661330685131503844231817233', '-5.2902655709146386768479917571509005451E+361', '4.94173711629380999452122697321630573180513697514816e+368', 51, 3);
  t('-3.94205311338658631286509556625817971E+16157', '-9.211465098548013710604889811533128813247447560316297E+50484508', '3.6312084670583075556389877785380186469268808582939e+50500666', 50, 3);
  t('3.80682239719999E+9108569', '1.2570378527E+23171863693', '4.785319851787e+23180972262', 13, 0);
  t('-9.4785667878741097620937182099167353179206477903295E+319318083141787', '2.18914651047879948228632460987022499797894573E-77622588673349', '-2.0749971408014850575894868085e+241695494468439', 29, 2);
  t('8.9667725561135595682395580714154E-986', '1.1512563831473418E+8027419170', '1.032305414145614153439488817400778841194507358372e+8027418185', 60, 5);
  t('9.3824406374705879422603687090411415559E+28598052', '-3.50433070520586E-7746996567809884', '-3.287917481565942409009547240550780296503505331019e-7746996539211831', 49, 2);
  t('5.99E+13791044512809', '1.96046646889916754612071635552249438783E+248238115', '1.1743194e+13791292750925', 8, 6);
  t('3.064300584181522300878161202335034438E+404457', '6.0535215816314153102435315312283077826829E+77415331', '1.8549809718948598773839134903222460170305454724434488707237125796507991534e+77819789', 74, 6);
  t('5.81262639194966973950354535185905205219806501541037262161E+671621', '1.9031000617961150495272884354716297026994E-903289894955222', '1.106200964571714573808968647523e-903289894283600', 31, 4);
  t('9.5476838756708013471774773695351827963819089787235895E-8', '-8.408E+5139037', '-8.02769260266400977270682297230518169519790906931079e+5139030', 51, 5);
  t('-6.6E-7463867943633', '-1.4807684717021055514852E+387367', '9.77307191323389663980232e-7463867556266', 48, 1);
  t('-8.55084718716151381E+822668', '-9.9175121266567279254154973093072804774E+8063', '8.4803130671862884864960981662863480992266774404443492894e+830732', 62, 2);
  t('5.3373715876357243785148742308551E-56952990', '-6.5179989919672330632712640299738175964123E-41295149', '-3.478898262796420184523996e-98248138', 25, 4);
  t('6.971459479802497597082438607792354091586831018306743480E-761', '-6.033E+216403', '-4e+215643', 1, 5);
  t('1.777384386455398193216E+2597299297574', '-6.084886935E+523988312', '-1.08151830316154434261226e+2597823285887', 24, 1);
  t('-4.6521500157722287061856841778E+9887292058', '-2.83437170876054177504354221116689924238706435361497611914E-55276141643', '1.31859223896147132476824015424548234299417761151369391782106971716610693e-45388849584', 72, 6);
  t('7.5265257980887835089498587251138470751028760392372286407E-2808031', '-9.1E+5942', '-6.84913847626079299314437e-2802088', 24, 4);
  t('6.124447659875137256913380088076116744534502046E-3221', '-445.129416206308926513928576593405597136836057165908670', '-2.7261718114263147022892763710281790800347767629059444299404749637586549e-3218', 72, 3);
  t('-2.343998818E+1337502807076880', '9.28276989128108540103161939E+41', '-2.1758801652928852685775171e+1337502807076922', 26, 1);
  t('6.30E-742321395', '3010721501699960.4', '1.896754546070975052e-742321379', 32, 5);
  t('-8.19473472459505835840696858E+57148564414539', '-3.072155949788976057941148086E+91051363', '2.517550304110703465066659165e+57148655465903', 28, 1);
  t('8.30776117642162743211570060628744719866432894004311519342327E-33426', '-7.32744736817205E+483785', '-6.08746827675725878961361300787124655166036655e+450360', 46, 5);
  t('2.7724010038502924E+11725', '-4.7556689139834608E+928358674281', '-1.318462127110737658180757284393792e+928358686007', 40, 4);
  t('5.9091700317147668794795218E+666897567', '8.3938478805437150E+1881334366773516', '4.9600674346481433119807194038219992195487e+1881335033671084', 45, 3);
  t('-4.3691580894245294496446636805158600484074460956643847E-89474019484498', '-4.480405454599623134150719643985041E-85297159512', '2e-89559316644009', 2, 0);
  t('3.9841406473800271259191727447172370183389231944900E+7162819378682783', '-1.1756652068301468200152428806523472381832E+26219282019', '-4.684015538242e+7162845597964802', 13, 4);
  t('-108.838392673073428475338591374657485576815', '4.7679792205854258775825803754367415273006845283282054E-2392128538985014', '-5.189391946671311e-2392128538985012', 16, 1);
  t('-8.204662794316848196358517032121883095398020430371494E+4174', '-9.24067E+76425280674697', '7.581658134355986962264425758321772146315162545032095346098e+76425280678872', 77, 6);
  t('-1765008726556704110068716.971202764152', '-6.181972151135587E-438453547492', '1.0911234794084831168999690852448e-438453547467', 32, 4);
  t('4.2855951384E+6786330', '-8.467571964460057801596728600265E+803863', '-3.62e+7590194', 3, 2);
  t('5.931102910248257260028749055698492591626238811283040E+2994979930', '4.74554276498454773524121438E+4419395108969865', '2.81463025041074126217073937975121544226291777930659827735640858625099754981152e+4419398103949796', 79, 5);
  t('-3.252331914843376239065836709279067E+94440233387625', '-2.3623795146812686712069E+77052063', '7.6832422905700963877126387159924969901297229583598e+94440310439688', 51, 5);
  t('3.0492122248920255558204E+853564085', '-8.08984113814203797323E+830247744', '-2.46676e+1683811830', 6, 5);
  t('5.3E+3001536064', '-5.1284719857135251986348941516094288300538120647569E+8250887721405', '-2.7180901524281683552764939003e+8253889257470', 29, 1);
  t('-7.232364520576269255230605598E+13647', '-5.0920968774E+8733763326721', '3.68279007914449687231013903824867596852e+8733763340369', 43, 4);
  t('-4.570347590158040638E+2740239393431', '2.07889215232397404562727100828808310398753938E+677467169443', '-9.50125973857233712074162213187e+3417706562874', 30, 6);
  t('4.5448270760346241610118429522193090232405670818152E+841009', '-2.422423171496393324796293931481383527700912094875E-7804254834', '-1.10094944194304741888085692195231316338573093706e-7803413824', 48, 5);
  t('4.22383351811211262345546887870844027467352195456471978E+2536981668011', '9.68288662066799336541944E-58', '4.0898901060456795748e+2536981667954', 20, 3);
  t('-7.98E-5131801232', '-6.46961274175379599674705810329589944472E+51197530481496', '5.162750967919529205404152e+51192398680265', 25, 1);
  t('5.406750087593579807470489668413180550069465120969E+49446063043777', '-14357.71569753219', '-7.762858060527588408725771461418996736206026436467e+49446063043781', 49, 4);
  t('8.767284916129139715662943977492089255922416046307300E+93918407846859', '7.70727619934705517543277570E+843', '6.7571886366976561345510962397291254226922e+93918407847703', 43, 3);
  t('1.7215714164903441106850793864502663758372E+73233827435817', '3.40448860214041361777E+24287921', '5.861070265212103438724011835488590426212729427605887764547044e+73233851723738', 78, 3);
  t('-4.5628487502792802885938754300464085807968592197376E+6353199536', '99369621.8217038874', '-4.53408554744886282e+6353199544', 18, 1);
  t('-7.278632E+684731572310999', '-1.70098296173502667080983368271858703080836592E-67129927', '1.23808290167393406470099213577133545572e+684731505181073', 39, 3);
  t('3.62481321880718463782470515258531161626837808157570536E+135011330', '3.70907770474907003605508735070520261968241E-9929696201', '1.3444713893757440983671783972567382e-9794684870', 35, 6);
  t('-0.000814586801311722298757051', '-4.6011129412495143332669917195124045818036E-4163600013', '3.74800587328641232642672141632691e-4163600016', 34, 4);
});
