# Disallow `require()`s which import extraneous modules (no-extraneous-require)

If a `require()`'s target is extraneous (it's not written in `package.json`), the program works in local, but will not work after dependencies are re-installed. It will cause troubles to your team/contributors.
This rule disallows `require()` of extraneous modules.

## Rule Details

This rule warns `require()` of extraneous modules.

## Options

```json
{
    "rules": {
        "node/no-extraneous-require": ["error", {
            "allowModules": []
        }]
    }
}
```

### allowModules

Some platforms have additional embedded modules.
For example, Electron has `electron` module.

We can specify additional embedded modules with this option.
This option is an array of strings as module names.

```json
{
    "rules": {
        "node/no-extraneous-require": ["error", {
            "allowModules": ["electron"]
        }]
    }
}
```

## Shared Settings

The following options can be set by [shared settings](http://eslint.org/docs/user-guide/configuring.html#adding-shared-settings).
Several rules have the same option, but we can set this option at once.

- `allowModules`

For Example:

```json
{
    "settings": {
        "node": {
            "allowModules": ["electron"]
        }
    },
    "rules": {
        "node/no-extraneous-require": "error"
    }
}
```
