# CH4 API Auto-Generation

This page will discuss the ch4 API scripting interface.

With
[PR 4836](https://github.com/pmodels/mpich/pull/4836),
the ch4 netmod/shm API is declared in `src/mpid/ch4/ch4_api.txt`, and it is
generated by running `maint/gen_ch4_api.py` in `autogen.sh`. Following files
will be generated:
- `src/mpid/ch4/netmod/include/netmod.h`
- `src/mpid/ch4/netmod/include/netmod_impl.h`
- `src/mpid/ch4/netmod/ofi/func_table.c`
- `src/mpid/ch4/netmod/ofi/ofi_noinline.h.c`
- `src/mpid/ch4/netmod/ucx/func_table.c`
- `src/mpid/ch4/netmod/ucx/ofi_noinline.h.c`
- `src/mpid/ch4/netmod/stubnm/func_table.c`
- `src/mpid/ch4/netmod/stubnm/ofi_noinline.h.c`
- `src/mpid/ch4/shm/include/shm.h`

The layout of `ch4_api.txt` is as following:

```
Non Native API:
    mpi_init_hook: int
        NM: rank, size, appnum, tag_bits, init_comm
        SHM: rank, size, tag_bits
    ...

Native API:
    mpi_isend: int
        ...
    ...

PARAM:
    addr: MPIDI_av_entry_t *
    ...
```

Section headings, i.e. `Non Native API`, `Native API`, and `PARAM`, need start
at the beginning of the line immediately followed by `:`. All other
specifications are required to start with some spaces.

The API is specified as follows:

```
<Name>:<Return Type>
```

Flexible spaces are allowed.

Immediately following the API name line should be specifications for parameters
for the netmod API (NM) and shm API. Both may be present or either could be
missing, indicating a NM/SHM specific API. Some API also provide `MPIDIG`
entry, which is used to generate default fallback code in `stubnm` and
`stubshm`.

`*` immediately after NM/SHM indicate whether the API function should be
inlined. All inlined functions are required to be explicitly marked by `*`.

The parameters are supplied with name only. Their type is looked up from the
`PARAM` section below. In the case of same parameter name being used with a
different type, use the `-#` prefix, e.g. `buf-2`. The number suffix is needed
for type look up. They will not be generated as part of parameter name.
