/*

	ksuser.c - Kernel Streaming GUIDs

	Written by Filip Navara <xnavara@volny.cz>

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

*/

#if defined(__LCC__) || defined(__GNUC__)
#define INITGUID 1
#include <windows.h>
#else
#include <basetyps.h>
#endif 

DEFINE_GUID(BUSID_SoftwareDeviceEnumerator,0x4747b320,0x62ce,0x11cf,0xa5,0xd6,0x28,0xdb,0x4,0xc1,0,0);
DEFINE_GUID(CLSID_KsIBasicAudioInterfaceHandler,0xb9f8ac3e,0x0f71,0x11d2,0xb7,0x2c,0x00,0xc0,0x4f,0xb6,0xbd,0x3d);
DEFINE_GUID(CLSID_Proxy,0x17cca71b,0xecd7,0x11d0,0xb9,0x08,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(EVENTSETID_CROSSBAR,0x6a2e0641,0x28e4,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(EVENTSETID_TUNER,0x6a2e0606,0x28e4,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(EVENTSETID_VIDEODECODER,0x6a2e0621,0x28e4,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(GUID_BUS_INTERFACE_MEDIUMS,0x4ec35c3e,0x201b,0x11d2,0x87,0x45,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(IID_IKoInitializeParentDeviceObject,0x21b36996,0x8de3,0x11d1,0x8a,0xe0,0,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(IID_IKsAggregateControl,0x7f40eac0,0x3947,0x11d2,0x87,0x4e,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(IID_IKsAllocator,0x8da64899,0xc0d9,0x11d0,0x84,0x13,0x00,0x00,0xf8,0x22,0xfe,0x8a);
DEFINE_GUID(IID_IKsAllocatorEx,0x091bb63a,0x603f,0x11d1,0xb0,0x67,0x00,0xa0,0xc9,0x06,0x28,0x02);
DEFINE_GUID(IID_IKsClockPropertySet,0x5c5cbd84,0xe755,0x11d0,0xac,0x18,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(IID_IKsControl,0x28f54685,0x06fd,0x11d2,0xb2,0x7a,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(IID_IKsDataTypeCompletion,0x827d1a0e,0x0f73,0x11d2,0xb2,0x7a,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(IID_IKsDataTypeHandler,0x5ffbaa02,0x49a3,0x11d0,0x9f,0x36,0x00,0xaa,0x00,0xa2,0x16,0xa1);
DEFINE_GUID(IID_IKsInterfaceHandler,0xd3abc7e0,0x9a61,0x11d0,0xa4,0x0d,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(IID_IKsObject,0x423c13a2,0x2070,0x11d0,0x9e,0xf7,0x00,0xaa,0x00,0xa2,0x16,0xa1);
DEFINE_GUID(IID_IKsPin,0xb61178d1,0xa2d9,0x11cf,0x9e,0x53,0x00,0xaa,0x00,0xa2,0x16,0xa1);
DEFINE_GUID(IID_IKsPinEx,0x7bb38260,0xd19c,0x11d2,0xb3,0x8a,0x00,0xa0,0xc9,0x5e,0xc2,0x2e);
DEFINE_GUID(IID_IKsPinPipe,0xe539cd90,0xa8b4,0x11d1,0x81,0x89,0x00,0xa0,0xc9,0x06,0x28,0x02);
DEFINE_GUID(IID_IKsPropertySet,0x31efac30,0x515c,0x11d0,0xa9,0xaa,0x00,0xaa,0x00,0x61,0xbe,0x93);
DEFINE_GUID(IID_IKsTopology,0x28f54683,0x06fd,0x11d2,0xb2,0x7a,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KoCreateObject,0x72cf721c,0x525a,0x11d1,0x9a,0xa1,0,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSALGORITHMINSTANCE_SYSTEM_ACOUSTIC_ECHO_CANCEL,0x1c22c56d,0x9879,0x4f5b,0xa3,0x89,0x27,0x99,0x6d,0xdc,0x28,0x10);
DEFINE_GUID(KSALGORITHMINSTANCE_SYSTEM_AGC,0x950e55b9,0x877c,0x4c67,0xbe,0x8,0xe4,0x7b,0x56,0x11,0x13,0xa);
DEFINE_GUID(KSALGORITHMINSTANCE_SYSTEM_MICROPHONE_ARRAY_PROCESSOR,0xb6f5a0a0,0x9e61,0x4f8c,0x91,0xe3,0x76,0xcf,0xf,0x3c,0x47,0x1f);
DEFINE_GUID(KSALGORITHMINSTANCE_SYSTEM_NOISE_SUPPRESS,0x5ab0882e,0x7274,0x4516,0x87,0x7d,0x4e,0xee,0x99,0xba,0x4f,0xd0);
DEFINE_GUID(KSAUDFNAME_3D_CENTER,0x9f0670b4,0x991f,0x11d2,0xac,0x4d,0,0xc0,0x4f,0x8e,0xfb,0x68);
DEFINE_GUID(KSAUDFNAME_3D_DEPTH,0x63ff5747,0x991f,0x11d2,0xac,0x4d,0,0xc0,0x4f,0x8e,0xfb,0x68);
DEFINE_GUID(KSAUDFNAME_3D_STEREO,0x185fede2,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_ALTERNATE_MICROPHONE,0x2bc31d6b,0x96e3,0x11d2,0xac,0x4c,0,0xc0,0x4f,0x8e,0xfb,0x68);
DEFINE_GUID(KSAUDFNAME_AUX,0x185fedfe,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_AUX_MUTE,0x185fedfd,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_AUX_VOLUME,0x185fedfc,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_BASS,0x185fede0,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_CD_AUDIO,0x185fedfb,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_CD_IN_VOLUME,0x185fedf3,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_CD_MUTE,0x185fedea,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_CD_VOLUME,0x185fede9,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_LINE_IN,0x185fedf9,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_LINE_IN_VOLUME,0x185fedf4,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_LINE_MUTE,0x185fedec,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_LINE_VOLUME,0x185fedeb,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_MASTER_MUTE,0x185fede4,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_MASTER_VOLUME,0x185fede3,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_MIC_IN_VOLUME,0x185fedf5,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_MIC_MUTE,0x185fedee,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_MIC_VOLUME,0x185feded,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_MICROPHONE_BOOST,0x2bc31d6a,0x96e3,0x11d2,0xac,0x4c,0,0xc0,0x4f,0x8e,0xfb,0x68);
DEFINE_GUID(KSAUDFNAME_MIDI,0x185fedf8,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_MIDI_IN_VOLUME,0x185fedf2,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_MIDI_MUTE,0x185fede8,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_MIDI_VOLUME,0x185fede7,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_MONO_MIX,0xdff078,0x96e3,0x11d2,0xac,0x4c,0,0xc0,0x4f,0x8e,0xfb,0x68);
DEFINE_GUID(KSAUDFNAME_MONO_MIX_MUTE,0x2bc31d69,0x96e3,0x11d2,0xac,0x4c,0,0xc0,0x4f,0x8e,0xfb,0x68);
DEFINE_GUID(KSAUDFNAME_MONO_MIX_VOLUME,0x22b0eafe,0x96e3,0x11d2,0xac,0x4c,0,0xc0,0x4f,0x8e,0xfb,0x68);
DEFINE_GUID(KSAUDFNAME_MONO_OUT,0xf9b41dc3,0x96e2,0x11d2,0xac,0x4c,0,0xc0,0x4f,0x8e,0xfb,0x68);
DEFINE_GUID(KSAUDFNAME_MONO_OUT_MUTE,0x1ad247ec,0x96e3,0x11d2,0xac,0x4c,0,0xc0,0x4f,0x8e,0xfb,0x68);
DEFINE_GUID(KSAUDFNAME_MONO_OUT_VOLUME,0x1ad247eb,0x96e3,0x11d2,0xac,0x4c,0,0xc0,0x4f,0x8e,0xfb,0x68);
DEFINE_GUID(KSAUDFNAME_PC_SPEAKER,0x185fedff,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_PC_SPEAKER_MUTE,0x185fedf1,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_PC_SPEAKER_VOLUME,0x185fedf0,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_PEAKMETER,0x57e24340,0xfc5b,0x4612,0xa5,0x62,0x72,0xb1,0x1a,0x29,0xdf,0xae);
DEFINE_GUID(KSAUDFNAME_RECORDING_CONTROL,0x185fedfa,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_RECORDING_SOURCE,0x185fedef,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_STEREO_MIX,0xdff077,0x96e3,0x11d2,0xac,0x4c,0,0xc0,0x4f,0x8e,0xfb,0x68);
DEFINE_GUID(KSAUDFNAME_STEREO_MIX_MUTE,0x22b0eafd,0x96e3,0x11d2,0xac,0x4c,0,0xc0,0x4f,0x8e,0xfb,0x68);
DEFINE_GUID(KSAUDFNAME_STEREO_MIX_VOLUME,0x1ad247ed,0x96e3,0x11d2,0xac,0x4c,0,0xc0,0x4f,0x8e,0xfb,0x68);
DEFINE_GUID(KSAUDFNAME_TREBLE,0x185fede1,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_VIDEO,0x915daec4,0xa434,0x11d2,0xac,0x52,0,0xc0,0x4f,0x8e,0xfb,0x68);
DEFINE_GUID(KSAUDFNAME_VIDEO_MUTE,0x9b46e709,0x992a,0x11d2,0xac,0x4d,0,0xc0,0x4f,0x8e,0xfb,0x68);
DEFINE_GUID(KSAUDFNAME_VIDEO_VOLUME,0x9b46e708,0x992a,0x11d2,0xac,0x4d,0,0xc0,0x4f,0x8e,0xfb,0x68);
DEFINE_GUID(KSAUDFNAME_VOLUME_CONTROL,0x185fedf7,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_WAVE_IN_VOLUME,0x185fedf6,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_WAVE_MUTE,0x185fede6,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_WAVE_OUT_MIX,0x185fee00,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSAUDFNAME_WAVE_VOLUME,0x185fede5,0x9905,0x11d1,0x95,0xa9,0,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSCATEGORY_ACOUSTIC_ECHO_CANCEL,0xbf963d80,0xc559,0x11d0,0x8a,0x2b,0,0xa0,0xc9,0x25,0x5a,0xc1);
DEFINE_GUID(KSCATEGORY_AUDIO,0x6994ad04,0x93ef,0x11d0,0xa3,0xcc,0,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSCATEGORY_AUDIO_DEVICE,0xfbf6f530,0x7b9,0x11d2,0xa7,0x1e,0,0,0xf8,0,0x47,0x88);
DEFINE_GUID(KSCATEGORY_AUDIO_GFX,0x9baf9572,0x340c,0x11d3,0xab,0xdc,0,0xa0,0xc9,0xa,0xb1,0x6f);
DEFINE_GUID(KSCATEGORY_AUDIO_SPLITTER,0x9ea331fa,0xb91b,0x45f8,0x92,0x85,0xbd,0x2b,0xc7,0x7a,0xfc,0xde);
DEFINE_GUID(KSCATEGORY_BRIDGE,0x85aff00,0x62ce,0x11cf,0xa5,0xd6,0x28,0xdb,0x4,0xc1,0,0);
DEFINE_GUID(KSCATEGORY_CAPTURE,0x65e8773d,0x8f56,0x11d0,0xa3,0xb9,0,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSCATEGORY_CLOCK,0x53172480,0x4791,0x11d0,0xa5,0xd6,0x28,0xdb,0x4,0xc1,0,0);
DEFINE_GUID(KSCATEGORY_COMMUNICATIONSTRANSFORM,0xcf1dda2c,0x9743,0x11d0,0xa3,0xee,0,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSCATEGORY_CROSSBAR,0xa799a801,0xa46d,0x11d0,0xa1,0x8c,0,0xa0,0x24,0x1,0xdc,0xd4);
DEFINE_GUID(KSCATEGORY_DATACOMPRESSOR,0x1e84c900,0x7e70,0x11d0,0xa5,0xd6,0x28,0xdb,0x4,0xc1,0,0);
DEFINE_GUID(KSCATEGORY_DATADECOMPRESSOR,0x2721ae20,0x7e70,0x11d0,0xa5,0xd6,0x28,0xdb,0x4,0xc1,0,0);
DEFINE_GUID(KSCATEGORY_DATATRANSFORM,0x2eb07ea0,0x7e70,0x11d0,0xa5,0xd6,0x28,0xdb,0x4,0xc1,0,0);
DEFINE_GUID(KSCATEGORY_ENCODER,0x19689bf6,0xc384,0x48fd,0xad,0x51,0x90,0xe5,0x8c,0x79,0xf7,0xb);
DEFINE_GUID(KSCATEGORY_ESCALANTE_PLATFORM_DRIVER,0x74f3aea8,0x9768,0x11d1,0x8e,0x7,0,0xa0,0xc9,0x5e,0xc2,0x2e);
DEFINE_GUID(KSCATEGORY_FILESYSTEM,0x760fed5e,0x9357,0x11d0,0xa3,0xcc,0,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSCATEGORY_INTERFACETRANSFORM,0xcf1dda2d,0x9743,0x11d0,0xa3,0xee,0,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSCATEGORY_MEDIUMTRANSFORM,0xcf1dda2e,0x9743,0x11d0,0xa3,0xee,0,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSCATEGORY_MICROPHONE_ARRAY_PROCESSOR,0x830a44f2,0xa32d,0x476b,0xbe,0x97,0x42,0x84,0x56,0x73,0xb3,0x5a);
DEFINE_GUID(KSCATEGORY_MIXER,0xad809c00,0x7b88,0x11d0,0xa5,0xd6,0x28,0xdb,0x4,0xc1,0,0);
DEFINE_GUID(KSCATEGORY_NETWORK,0x67c9cc3c,0x69c4,0x11d2,0x87,0x59,0,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSCATEGORY_PREFERRED_MIDIOUT_DEVICE,0xd6c50674,0x72c1,0x11d2,0x97,0x55,0,0,0xf8,0,0x47,0x88);
DEFINE_GUID(KSCATEGORY_PREFERRED_WAVEIN_DEVICE,0xd6c50671,0x72c1,0x11d2,0x97,0x55,0,0,0xf8,0,0x47,0x88);
DEFINE_GUID(KSCATEGORY_PREFERRED_WAVEOUT_DEVICE,0xd6c5066e,0x72c1,0x11d2,0x97,0x55,0,0,0xf8,0,0x47,0x88);
DEFINE_GUID(KSCATEGORY_PROXY,0x97ebaaca,0x95bd,0x11d0,0xa3,0xea,0,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSCATEGORY_QUALITY,0x97ebaacb,0x95bd,0x11d0,0xa3,0xea,0,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSCATEGORY_RENDER,0x65e8773e,0x8f56,0x11d0,0xa3,0xb9,0,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSCATEGORY_SPLITTER,0xa4252a0,0x7e70,0x11d0,0xa5,0xd6,0x28,0xdb,0x4,0xc1,0,0);
DEFINE_GUID(KSCATEGORY_SYSAUDIO,0xa7c7a5b1,0x5af3,0x11d1,0x9c,0xed,0,0xa0,0x24,0xbf,0x4,0x7);
DEFINE_GUID(KSCATEGORY_TEXT,0x6994ad06,0x93ef,0x11d0,0xa3,0xcc,0,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSCATEGORY_TOPOLOGY,0xdda54a40,0x1e4c,0x11d1,0xa0,0x50,0x40,0x57,0x5,0xc1,0,0);
DEFINE_GUID(KSCATEGORY_TVAUDIO,0xa799a802,0xa46d,0x11d0,0xa1,0x8c,0,0xa0,0x24,0x1,0xdc,0xd4);
DEFINE_GUID(KSCATEGORY_TVTUNER,0xa799a800,0xa46d,0x11d0,0xa1,0x8c,0,0xa0,0x24,0x1,0xdc,0xd4);
DEFINE_GUID(KSCATEGORY_VBICODEC,0x7dad660,0x22f1,0x11d1,0xa9,0xf4,0,0xc0,0x4f,0xbb,0xde,0x8f);
DEFINE_GUID(KSCATEGORY_VIDEO,0x6994ad05,0x93ef,0x11d0,0xa3,0xcc,0,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSCATEGORY_VIRTUAL,0x3503eac4,0x1f26,0x11d1,0x8a,0xb0,0,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSCATEGORY_VPMUX,0xa799a803,0xa46d,0x11d0,0xa1,0x8c,0,0xa0,0x24,0x1,0xdc,0xd4);
DEFINE_GUID(KSCATEGORY_WDMAUD,0x3e227e76,0x690d,0x11d2,0x81,0x61,0,0,0xf8,0x77,0x5b,0xf1);
DEFINE_GUID(KSCATEGORY_WDMAUD_USE_PIN_NAME,0x47a4fa20,0xa251,0x11d1,0xa0,0x50,0,0,0xf8,0,0x47,0x88);
DEFINE_GUID(KSCOMPONENTID_USBAUDIO,0x8f1275f0,0x26e9,0x4264,0xba,0x4d,0x39,0xff,0xf0,0x1d,0x94,0xaa);
DEFINE_GUID(KSDATAFORMAT_SPECIFIER_AC3_AUDIO,0xe06d80e4,0xdb46,0x11cf,0xb4,0xd1,0,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(KSDATAFORMAT_SPECIFIER_ANALOGVIDEO,0x482dde0,0x7817,0x11cf,0x8a,0x3,0,0xaa,0,0x6e,0xcb,0x65);
DEFINE_GUID(KSDATAFORMAT_SPECIFIER_DIALECT_AC3_AUDIO,0x36523b35,0x8ee5,0x11d1,0x8c,0xa3,0,0x60,0xb0,0x57,0x66,0x4a);
DEFINE_GUID(KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_AUDIO,0x36523b32,0x8ee5,0x11d1,0x8c,0xa3,0,0x60,0xb0,0x57,0x66,0x4a);
DEFINE_GUID(KSDATAFORMAT_SPECIFIER_DIALECT_MPEG1_VIDEO,0x36523b31,0x8ee5,0x11d1,0x8c,0xa3,0,0x60,0xb0,0x57,0x66,0x4a);
DEFINE_GUID(KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_AUDIO,0x36523b34,0x8ee5,0x11d1,0x8c,0xa3,0,0x60,0xb0,0x57,0x66,0x4a);
DEFINE_GUID(KSDATAFORMAT_SPECIFIER_DIALECT_MPEG2_VIDEO,0x36523b33,0x8ee5,0x11d1,0x8c,0xa3,0,0x60,0xb0,0x57,0x66,0x4a);
DEFINE_GUID(KSDATAFORMAT_SPECIFIER_DSOUND,0x518590a2,0xa184,0x11d0,0x85,0x22,0,0xc0,0x4f,0xd9,0xba,0xf3);
DEFINE_GUID(KSDATAFORMAT_SPECIFIER_FILEHANDLE,0x65e8773c,0x8f56,0x11d0,0xa3,0xb9,0,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSDATAFORMAT_SPECIFIER_FILENAME,0xaa797b40,0xe974,0x11cf,0xa5,0xd6,0x28,0xdb,0x4,0xc1,0,0);
DEFINE_GUID(KSDATAFORMAT_SPECIFIER_LPCM_AUDIO,0xe06d80e6,0xdb46,0x11cf,0xb4,0xd1,0,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(KSDATAFORMAT_SPECIFIER_MPEG1_VIDEO,0x5589f82,0xc356,0x11ce,0xbf,0x1,0,0xaa,0,0x55,0x59,0x5a);
DEFINE_GUID(KSDATAFORMAT_SPECIFIER_MPEG2_AUDIO,0xe06d80e5,0xdb46,0x11cf,0xb4,0xd1,0,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(KSDATAFORMAT_SPECIFIER_MPEG2_VIDEO,0xe06d80e3,0xdb46,0x11cf,0xb4,0xd1,0,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(KSDATAFORMAT_SPECIFIER_NONE,0xf6417d6,0xc318,0x11d0,0xa4,0x3f,0,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSDATAFORMAT_SPECIFIER_VBI,0xf72a76e0,0xeb0a,0x11d0,0xac,0xe4,0,0,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(KSDATAFORMAT_SPECIFIER_VC_ID,0xad98d184,0xaac3,0x11d0,0xa4,0x1c,0,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSDATAFORMAT_SPECIFIER_VIDEOINFO,0x5589f80,0xc356,0x11ce,0xbf,0x1,0,0xaa,0,0x55,0x59,0x5a);
DEFINE_GUID(KSDATAFORMAT_SPECIFIER_VIDEOINFO2,0xf72a76a0,0xeb0a,0x11d0,0xac,0xe4,0,0,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(KSDATAFORMAT_SPECIFIER_WAVEFORMATEX,0x5589f81,0xc356,0x11ce,0xbf,0x1,0,0xaa,0,0x55,0x59,0x5a);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_AC3_AUDIO,0xe06d802c,0xdb46,0x11cf,0xb4,0xd1,0,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_ADPCM,0x2,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_ALAW,0x6,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_ANALOG,0x6dba3190,0x67bd,0x11cf,0xa0,0xf7,0,0x20,0xaf,0xd1,0x56,0xe4);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_CC,0x33214cc1,0x11f,0x11d2,0xb4,0xb1,0,0xa0,0xd1,0x2,0xcf,0xbe);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_DRM,0x9,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_DSS_AUDIO,0xa0af4f82,0xe163,0x11d0,0xba,0xd9,0,0x60,0x97,0x44,0x11,0x1a);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_DSS_VIDEO,0xa0af4f81,0xe163,0x11d0,0xba,0xd9,0,0x60,0x97,0x44,0x11,0x1a);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_DTS_AUDIO,0xe06d8033,0xdb46,0x11cf,0xb4,0xd1,0,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_IEEE_FLOAT,0x3,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_Line21_BytePair,0x6e8d4a22,0x310c,0x11d0,0xb7,0x9a,0,0xaa,0,0x37,0x67,0xa7);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_Line21_GOPPacket,0x6e8d4a23,0x310c,0x11d0,0xb7,0x9a,0,0xaa,0,0x37,0x67,0xa7);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_LPCM_AUDIO,0xe06d8032,0xdb46,0x11cf,0xb4,0xd1,0,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_MIDI,0x1d262760,0xe957,0x11cf,0xa5,0xd6,0x28,0xdb,0x4,0xc1,0,0);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_MIDI_BUS,0x2ca15fa0,0x6cfe,0x11cf,0xa5,0xd6,0x28,0xdb,0x4,0xc1,0,0);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_MPEG,0x50,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_MPEG1Packet,0xe436eb80,0x524f,0x11ce,0x9f,0x53,0,0x20,0xaf,0xb,0xa7,0x70);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_MPEG1Payload,0xe436eb81,0x524f,0x11ce,0x9f,0x53,0,0x20,0xaf,0xb,0xa7,0x70);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_MPEG1Video,0xe436eb86,0x524f,0x11ce,0x9f,0x53,0,0x20,0xaf,0xb,0xa7,0x70);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_MPEG2_AUDIO,0xe06d802b,0xdb46,0x11cf,0xb4,0xd1,0,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_MPEG2_VIDEO,0xe06d8026,0xdb46,0x11cf,0xb4,0xd1,0,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_MULAW,0x7,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_NABTS,0xf72a76e2,0xeb0a,0x11d0,0xac,0xe4,0,0,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_NABTS_FEC,0xe757bca1,0x39ac,0x11d1,0xa9,0xf5,0,0xc0,0x4f,0xbb,0xde,0x8f);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_NONE,0xe436eb8e,0x524f,0x11ce,0x9f,0x53,0,0x20,0xaf,0xb,0xa7,0x70);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_OVERLAY,0xe436eb7f,0x524f,0x11ce,0x9f,0x53,0,0x20,0xaf,0xb,0xa7,0x70);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_PCM,0x1,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_RAW8,0xca20d9a0,0x3e3e,0x11d1,0x9b,0xf9,0,0xc0,0x4f,0xbb,0xde,0xbf);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_RIFF,0x4995daee,0x9ee6,0x11d0,0xa4,0xe,0,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_RIFFMIDI,0x4995daf0,0x9ee6,0x11d0,0xa4,0xe,0,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_RIFFWAVE,0xe436eb8b,0x524f,0x11ce,0x9f,0x53,0,0x20,0xaf,0xb,0xa7,0x70);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_SDDS_AUDIO,0xe06d8034,0xdb46,0x11cf,0xb4,0xd1,0,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_STANDARD_AC3_AUDIO,0x36523b25,0x8ee5,0x11d1,0x8c,0xa3,0,0x60,0xb0,0x57,0x66,0x4a);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_AUDIO,0x36523b22,0x8ee5,0x11d1,0x8c,0xa3,0,0x60,0xb0,0x57,0x66,0x4a);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_STANDARD_MPEG1_VIDEO,0x36523b21,0x8ee5,0x11d1,0x8c,0xa3,0,0x60,0xb0,0x57,0x66,0x4a);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_AUDIO,0x36523b24,0x8ee5,0x11d1,0x8c,0xa3,0,0x60,0xb0,0x57,0x66,0x4a);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_STANDARD_MPEG2_VIDEO,0x36523b23,0x8ee5,0x11d1,0x8c,0xa3,0,0x60,0xb0,0x57,0x66,0x4a);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_SUBPICTURE,0xe06d802d,0xdb46,0x11cf,0xb4,0xd1,0,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_TELETEXT,0xf72a76e3,0xeb0a,0x11d0,0xac,0xe4,0,0,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_VPVBI,0x5a9b6a41,0x1a22,0x11d1,0xba,0xd9,0,0x60,0x97,0x44,0x11,0x1a);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_VPVideo,0x5a9b6a40,0x1a22,0x11d1,0xba,0xd9,0,0x60,0x97,0x44,0x11,0x1a);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_WAVEFORMATEX,0,0,0x10,0x80,0,0,0xaa,0,0x38,0x9b,0x71);
DEFINE_GUID(KSDATAFORMAT_TYPE_ANALOGVIDEO,0x0482dde1,0x7817,0x11cf,0x8a,0x03,0x00,0xaa,0x00,0x6e,0xcb,0x65);
DEFINE_GUID(KSDATAFORMAT_TYPE_AUDIO,0x73647561,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(KSDATAFORMAT_TYPE_AUXLine21Data,0x670aea80,0x3a82,0x11d0,0xb7,0x9b,0x00,0xaa,0x00,0x37,0x67,0xa7);
DEFINE_GUID(KSDATAFORMAT_TYPE_DVD_ENCRYPTED_PACK,0xed0b916a,0x044d,0x11d1,0xaa,0x78,0x00,0xc0,0x4f,0xc3,0x1d,0x60);
DEFINE_GUID(KSDATAFORMAT_TYPE_MIDI,0x7364696d,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(KSDATAFORMAT_TYPE_MPEG2_PES,0xe06d8020,0xdb46,0x11cf,0xb4,0xd1,0x00,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(KSDATAFORMAT_TYPE_MPEG2_PROGRAM,0xe06d8022,0xdb46,0x11cf,0xb4,0xd1,0x00,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(KSDATAFORMAT_TYPE_MPEG2_TRANSPORT,0xe06d8023,0xdb46,0x11cf,0xb4,0xd1,0x00,0x80,0x5f,0x6c,0xbb,0xea);
DEFINE_GUID(KSDATAFORMAT_TYPE_MUSIC,0xe725d360,0x62cc,0x11cf,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(KSDATAFORMAT_TYPE_NABTS,0xe757bca0,0x39ac,0x11d1,0xa9,0xf5,0x00,0xc0,0x4f,0xbb,0xde,0x8f);
DEFINE_GUID(KSDATAFORMAT_TYPE_STANDARD_ELEMENTARY_STREAM,0x36523b11,0x8ee5,0x11d1,0x8c,0xa3,0x00,0x60,0xb0,0x57,0x66,0x4a);
DEFINE_GUID(KSDATAFORMAT_TYPE_STANDARD_PACK_HEADER,0x36523b13,0x8ee5,0x11d1,0x8c,0xa3,0x00,0x60,0xb0,0x57,0x66,0x4a);
DEFINE_GUID(KSDATAFORMAT_TYPE_STANDARD_PES_PACKET,0x36523b12,0x8ee5,0x11d1,0x8c,0xa3,0x00,0x60,0xb0,0x57,0x66,0x4a);
DEFINE_GUID(KSDATAFORMAT_TYPE_STREAM,0xe436eb83,0x524f,0x11ce,0x9f,0x53,0x00,0x20,0xaf,0x0b,0xa7,0x70);
DEFINE_GUID(KSDATAFORMAT_TYPE_TEXT,0x73747874,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(KSDATAFORMAT_TYPE_VBI,0xf72a76e1,0xeb0a,0x11d0,0xac,0xe4,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(KSDATAFORMAT_TYPE_VIDEO,0x73646976,0x0000,0x0010,0x80,0x00,0x00,0xaa,0x00,0x38,0x9b,0x71);
DEFINE_GUID(KSDEGRADESETID_Standard,0x9f564180,0x704c,0x11d0,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(KSEVENTSETID_AudioControlChange,0xe85e9698,0xfa2f,0x11d1,0x95,0xbd,0x00,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSEVENTSETID_Clock,0x364d8e20,0x62c7,0x11cf,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(KSEVENTSETID_Connection,0x7f4bcbe0,0x9ea5,0x11cf,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(KSEVENTSETID_Cyclic,0x142c1ac0,0x072a,0x11d0,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(KSEVENTSETID_LoopedStreaming,0x4682b940,0xc6ef,0x11d0,0x96,0xd8,0x00,0xaa,0x00,0x51,0xe5,0x1d);
DEFINE_GUID(KSEVENTSETID_StreamAllocator,0x75d95571,0x073c,0x11d0,0xa1,0x61,0x00,0x20,0xaf,0xd1,0x56,0xe4);
DEFINE_GUID(KSEVENTSETID_Sysaudio,0x04800320,0x4491,0x11d1,0xa0,0x50,0x40,0x57,0x05,0xc1,0x00,0x00);
DEFINE_GUID(KSEVENTSETID_VIDCAP_TVAUDIO,0x6a2e0651,0x28e4,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(KSEVENTSETID_VIDCAPTOSTI,0xdb47de20,0xf628,0x11d1,0xba,0x41,0x00,0xa0,0xc9,0x0d,0x2b,0x05);
DEFINE_GUID(KSEVENTSETID_VPNotify,0x20c5598e,0xd3c8,0x11d0,0x8d,0xfc,0x00,0xc0,0x4f,0xd7,0xc0,0x8b);
DEFINE_GUID(KSEVENTSETID_VPVBINotify,0xec529b01,0x1a1f,0x11d1,0xba,0xd9,0x00,0x60,0x97,0x44,0x11,0x1a);
DEFINE_GUID(KSINTERFACESETID_FileIo,0x8c6f932c,0xe771,0x11d0,0xb8,0xff,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSINTERFACESETID_Media,0x3a13eb40,0x30a7,0x11d0,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(KSINTERFACESETID_Standard,0x1a8766a0,0x62ce,0x11cf,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(KSMEDIUMSETID_MidiBus,0x05908040,0x3246,0x11d0,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(KSMEDIUMSETID_Standard,0x4747b320,0x62ce,0x11cf,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(KSMEDIUMSETID_VPBus,0xa18c15ec,0xce43,0x11d0,0xab,0xe7,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSMEMORY_TYPE_DEVICE_UNKNOWN,0x091bb639,0x603f,0x11d1,0xb0,0x67,0x00,0xa0,0xc9,0x06,0x28,0x02);
DEFINE_GUID(KSMEMORY_TYPE_KERNEL_NONPAGED,0x4a6d5fc4,0x7895,0x11d1,0xb0,0x69,0x00,0xa0,0xc9,0x06,0x28,0x02);
DEFINE_GUID(KSMEMORY_TYPE_KERNEL_PAGED,0xd833f8f8,0x7894,0x11d1,0xb0,0x69,0x00,0xa0,0xc9,0x06,0x28,0x02);
DEFINE_GUID(KSMEMORY_TYPE_SYSTEM,0x091bb638,0x603f,0x11d1,0xb0,0x67,0x00,0xa0,0xc9,0x06,0x28,0x02);
DEFINE_GUID(KSMEMORY_TYPE_USER,0x8cb0fc28,0x7893,0x11d1,0xb0,0x69,0x00,0xa0,0xc9,0x06,0x28,0x02);
DEFINE_GUID(KSMETHODSETID_StreamAllocator,0xcf6e4341,0xec87,0x11cf,0xa1,0x30,0x00,0x20,0xaf,0xd1,0x56,0xe4);
DEFINE_GUID(KSMETHODSETID_StreamIo,0x65d003ca,0x1523,0x11d2,0xb2,0x7a,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSMETHODSETID_Wave_Queued,0x7432c160,0x8827,0x11cf,0xa1,0x02,0x00,0x20,0xaf,0xd1,0x56,0xe4);
DEFINE_GUID(KSMETHODSETID_Wavetable,0xdcef31eb,0xd907,0x11d0,0x95,0x83,0x00,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSMUSIC_TECHNOLOGY_FMSYNTH,0x252c5c80,0x62e9,0x11cf,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(KSMUSIC_TECHNOLOGY_PORT,0x86c92e60,0x62e8,0x11cf,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(KSMUSIC_TECHNOLOGY_SQSYNTH,0x0ecf4380,0x62e9,0x11cf,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(KSMUSIC_TECHNOLOGY_SWSYNTH,0x37407736,0x3620,0x11d1,0x85,0xd3,0x00,0x00,0xf8,0x75,0x43,0x80);
DEFINE_GUID(KSMUSIC_TECHNOLOGY_WAVETABLE,0x394ec7c0,0x62e9,0x11cf,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(KSNAME_Allocator,0x642f5d00,0x4791,0x11d0,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(KSNAME_Clock,0x53172480,0x4791,0x11d0,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(KSNAME_Filter,0x9b365890,0x165f,0x11d0,0xa1,0x95,0x00,0x20,0xaf,0xd1,0x56,0xe4);
DEFINE_GUID(KSNAME_Pin,0x146f1a80,0x4791,0x11d0,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(KSNAME_Server,0x3c0d501a,0x140b,0x11d1,0xb4,0xf,0,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNAME_TopologyNode,0x0621061a,0xee75,0x11d0,0xb9,0x15,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_1394_DA_STREAM,0xdff21fe6,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_1394_DV_STREAM_SOUNDTRACK,0xdff21fe7,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_3D_EFFECTS,0x55515860,0xc559,0x11d0,0x8a,0x2b,0x00,0xa0,0xc9,0x25,0x5a,0xc1);
DEFINE_GUID(KSNODETYPE_ADC,0x4d837fe0,0xc555,0x11d0,0x8a,0x2b,0x00,0xa0,0xc9,0x25,0x5a,0xc1);
DEFINE_GUID(KSNODETYPE_AGC,0xe88c9ba0,0xc557,0x11d0,0x8a,0x2b,0x00,0xa0,0xc9,0x25,0x5a,0xc1);
DEFINE_GUID(KSNODETYPE_ANALOG_CONNECTOR,0xdff21fe1,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_ANALOG_TAPE,0xdff220e7,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_CABLE_TUNER_AUDIO,0xdff220ee,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_CD_PLAYER,0xdff220e3,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_COMMUNICATION_SPEAKER,0xdff21ce6,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_DAC,0x507ae360,0xc554,0x11d0,0x8a,0x2b,0x00,0xa0,0xc9,0x25,0x5a,0xc1);
DEFINE_GUID(KSNODETYPE_DAT_IO_DIGITAL_AUDIO_TAPE,0xdff220e4,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_DCC_IO_DIGITAL_COMPACT_CASSETTE,0xdff220e5,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_DELAY,0x144981e0,0xc558,0x11d0,0x8a,0x2b,0x00,0xa0,0xc9,0x25,0x5a,0xc1);
DEFINE_GUID(KSNODETYPE_DEMUX,0xc0eb67d4,0xe807,0x11d0,0x95,0x8a,0x00,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSNODETYPE_DESKTOP_MICROPHONE,0xdff21be2,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_DESKTOP_SPEAKER,0xdff21ce4,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_DEV_SPECIFIC,0x941c7ac0,0xc559,0x11d0,0x8a,0x2b,0x00,0xa0,0xc9,0x25,0x5a,0xc1);
DEFINE_GUID(KSNODETYPE_DIGITAL_AUDIO_INTERFACE,0xdff21fe2,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_DOWN_LINE_PHONE,0xdff21ee3,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_DRM_DESCRAMBLE,0xffbb6e3f,0xccfe,0x4d84,0x90,0xd9,0x42,0x14,0x18,0xb0,0x3a,0x8e);
DEFINE_GUID(KSNODETYPE_DSS_AUDIO,0xdff220ef,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_DVD_AUDIO,0xdff220eb,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_ECHO_CANCELING_SPEAKERPHONE,0xdff21de5,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_ECHO_SUPPRESSING_SPEAKERPHONE,0xdff21de3,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_EQUALIZATION_NOISE,0xdff220e2,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_EQUALIZER,0x9d41b4a0,0xc557,0x11d0,0x8a,0x2b,0x00,0xa0,0xc9,0x25,0x5a,0xc1);
DEFINE_GUID(KSNODETYPE_HANDSET,0xdff21de1,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_HEAD_MOUNTED_DISPLAY_AUDIO,0xdff21ce3,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_HEADPHONES,0xdff21ce2,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_HEADSET,0xdff21de2,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_CHORUS,0x20173f20,0xc559,0x11d0,0x8a,0x2b,0x00,0xa0,0xc9,0x25,0x5a,0xc1);
DEFINE_GUID(KSNODETYPE_LEGACY_AUDIO_CONNECTOR,0xdff21fe4,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_LEVEL_CALIBRATION_NOISE_SOURCE,0xdff220e1,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_LINE_CONNECTOR,0xdff21fe3,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_LOUDNESS,0x41887440,0xc558,0x11d0,0x8a,0x2b,0x00,0xa0,0xc9,0x25,0x5a,0xc1);
DEFINE_GUID(KSNODETYPE_LOW_FREQUENCY_EFFECTS_SPEAKER,0xdff21ce7,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_MICROPHONE,0xdff21be1,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_MICROPHONE_ARRAY,0xdff21be5,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_MINIDISK,0xdff220e6,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_MULTITRACK_RECORDER,0xdff220f2,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_MUTE,0x02b223c0,0xc557,0x11d0,0x8a,0x2b,0x00,0xa0,0xc9,0x25,0x5a,0xc1);
DEFINE_GUID(KSNODETYPE_MUX,0x2ceaf780,0xc556,0x11d0,0x8a,0x2b,0x00,0xa0,0xc9,0x25,0x5a,0xc1);
DEFINE_GUID(KSNODETYPE_NOISE_SUPPRESS,0xe07f903f,0x62fd,0x4e60,0x8c,0xdd,0xde,0xa7,0x23,0x66,0x65,0xb5);
DEFINE_GUID(KSNODETYPE_OMNI_DIRECTIONAL_MICROPHONE,0xdff21be4,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_PEAKMETER,0xa085651e,0x5f0d,0x4b36,0xa8,0x69,0xd1,0x95,0xd6,0xab,0x4b,0x9e);
DEFINE_GUID(KSNODETYPE_PERSONAL_MICROPHONE,0xdff21be3,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_PHONE_LINE,0xdff21ee1,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_PHONOGRAPH,0xdff220e8,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_PROCESSING_MICROPHONE_ARRAY,0xdff21be6,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_PROLOGIC_DECODER,0x831c2c80,0xc558,0x11d0,0x8a,0x2b,0x00,0xa0,0xc9,0x25,0x5a,0xc1);
DEFINE_GUID(KSNODETYPE_RADIO_RECEIVER,0xdff220f0,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_RADIO_TRANSMITTER,0xdff220f1,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_REVERB,0xef0328e0,0xc558,0x11d0,0x8a,0x2b,0x00,0xa0,0xc9,0x25,0x5a,0xc1);
DEFINE_GUID(KSNODETYPE_ROOM_SPEAKER,0xdff21ce5,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_SATELLITE_RECEIVER_AUDIO,0xdff220ed,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_SPDIF_INTERFACE,0xdff21fe5,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_SPEAKER,0xdff21ce1,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_SPEAKERPHONE_NO_ECHO_REDUCTION,0xdff21de3,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_SRC,0x9db7b9e0,0xc555,0x11d0,0x8a,0x2b,0x00,0xa0,0xc9,0x25,0x5a,0xc1);
DEFINE_GUID(KSNODETYPE_STEREO_ENHANCE,0xaf6878ac,0xe83f,0x11d0,0x95,0x8a,0x00,0xc0,0x4f,0xb9,0x25,0xd3);
DEFINE_GUID(KSNODETYPE_STEREO_WIDE,0xa9e69800,0xc558,0x11d0,0x8a,0x2b,0x00,0xa0,0xc9,0x25,0x5a,0xc1);
DEFINE_GUID(KSNODETYPE_SUM,0xda441a60,0xc556,0x11d0,0x8a,0x2b,0x00,0xa0,0xc9,0x25,0x5a,0xc1);
DEFINE_GUID(KSNODETYPE_SUPERMIX,0xe573adc0,0xc555,0x11d0,0x8a,0x2b,0x00,0xa0,0xc9,0x25,0x5a,0xc1);
DEFINE_GUID(KSNODETYPE_SURROUND_ENCODER,0x8074c5b2,0x3c66,0x11d2,0xb4,0x5a,0x30,0x78,0x30,0x2c,0x20,0x30);
DEFINE_GUID(KSNODETYPE_SWMIDI,0xcb9befa0,0xa251,0x11d1,0xa0,0x50,0x00,0x00,0xf8,0x00,0x47,0x88);
DEFINE_GUID(KSNODETYPE_SWSYNTH,0x423274a0,0x8b81,0x11d1,0xa0,0x50,0x00,0x00,0xf8,0x00,0x47,0x88);
DEFINE_GUID(KSNODETYPE_SYNTHESIZER,0xdff220f3,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_TELEPHONE,0xdff21ee2,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_TONE,0x7607e580,0xc557,0x11d0,0x8a,0x2b,0x00,0xa0,0xc9,0x25,0x5a,0xc1);
DEFINE_GUID(KSNODETYPE_TV_TUNER_AUDIO,0xdff220ec,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_VCR_AUDIO,0xdff220e9,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_VIDEO_DISC_AUDIO,0xdff220ea,0xf70f,0x11d0,0xb9,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSNODETYPE_VOLUME,0x3a5acc00,0xc557,0x11d0,0x8a,0x2b,0x00,0xa0,0xc9,0x25,0x5a,0xc1);
DEFINE_GUID(KSPROPSETID_AC3,0xbfabe720,0x6e1f,0x11d0,0xbc,0xf2,0x44,0x45,0x53,0x54,0x00,0x00);
DEFINE_GUID(KSPROPSETID_Acoustic_Echo_Cancel,0xd7a4af8b,0x3dc1,0x4902,0x91,0xea,0x8a,0x15,0xc9,0xe,0x5,0xb2);
DEFINE_GUID(KSPROPSETID_Audio,0x45ffaaa0,0x6e1b,0x11d0,0xbc,0xf2,0x44,0x45,0x53,0x54,0x00,0x00);
DEFINE_GUID(KSPROPSETID_AudioDecoderOut,0x6ca6e020,0x43bd,0x11d0,0xbd,0x6a,0x00,0x35,0x05,0xc1,0x03,0xa9);
DEFINE_GUID(KSPROPSETID_AudioGfx,0x79a9312e,0x59ae,0x43b0,0xa3,0x50,0x8b,0x5,0x28,0x4c,0xab,0x24);
DEFINE_GUID(KSPROPSETID_Bibliographic,0x07ba150e,0xe2b1,0x11d0,0xac,0x17,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSPROPSETID_Clock,0xdf12a4c0,0xac17,0x11cf,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(KSPROPSETID_Connection,0x1d58c920,0xac9b,0x11cf,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(KSPROPSETID_CopyProt,0x0e8a0a40,0x6aef,0x11d0,0x9e,0xd0,0x00,0xa0,0x24,0xca,0x19,0xb3);
DEFINE_GUID(KSPROPSETID_Cyclic,0x3ffeaea0,0x2bee,0x11cf,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(KSPROPSETID_DirectSound3DBuffer,0x437b3411,0xd060,0x11d0,0x85,0x83,0x00,0xc0,0x4f,0xd9,0xba,0xf3);
DEFINE_GUID(KSPROPSETID_DirectSound3DListener,0x437b3414,0xd060,0x11d0,0x85,0x83,0x00,0xc0,0x4f,0xd9,0xba,0xf3);
DEFINE_GUID(KSPROPSETID_DrmAudioStream,0x2f2c8ddd,0x4198,0x4fac,0xba,0x29,0x61,0xbb,0x05,0xb7,0xde,0x06);
DEFINE_GUID(KSPROPSETID_DvdSubPic,0xac390460,0x43af,0x11d0,0xbd,0x6a,0x00,0x35,0x05,0xc1,0x03,0xa9);
DEFINE_GUID(KSPROPSETID_General,0x1464eda5,0x6a8f,0x11d1,0x9a,0xa7,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSPROPSETID_GM,0xaf627536,0xe719,0x11d2,0x8a,0x1d,0x00,0x60,0x97,0xd2,0xdf,0x5d);
DEFINE_GUID(KSPROPSETID_Hrtf3d,0xb66decb0,0xa083,0x11d0,0x85,0x1e,0x00,0xc0,0x4f,0xd9,0xba,0xf3);
DEFINE_GUID(KSPROPSETID_Itd3d,0x6429f090,0x9fd9,0x11d0,0xa7,0x5b,0x00,0xa0,0xc9,0x03,0x65,0xe3);
DEFINE_GUID(KSPROPSETID_Linear,0x5a2ffe80,0x16b9,0x11d0,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(KSPROPSETID_MediaSeeking,0xee904f0c,0xd09b,0x11d0,0xab,0xe9,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSPROPSETID_MemoryTransport,0xa3d1c5d,0x5243,0x4819,0x9e,0xd0,0xae,0xe8,0x4,0x4c,0xee,0x2b);
DEFINE_GUID(KSPROPSETID_Mpeg2Vid,0xc8e11b60,0x0cc9,0x11d0,0xbd,0x69,0x00,0x35,0x05,0xc1,0x03,0xa9);
DEFINE_GUID(KSPROPSETID_OverlayUpdate,0x490ea5cf,0x7681,0x11d1,0xa2,0x1c,0x00,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSPROPSETID_Pin,0x8c134960,0x51ad,0x11cf,0x87,0x8a,0x94,0xf8,0x01,0xc1,0x00,0x00);
DEFINE_GUID(KSPROPSETID_Quality,0xd16ad380,0xac1a,0x11cf,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(KSPROPSETID_RtAudio,0xa855a48c,0x2f78,0x4729,0x90,0x51,0x19,0x68,0x74,0x6b,0x9e,0xef);
DEFINE_GUID(KSPROPSETID_Service,0x3c0d501b,0x140b,0x11d1,0xb4,0xf,0,0xa0,0xc9,0x22,0x31,0x96);
DEFINE_GUID(KSPROPSETID_Stream,0x65aaba60,0x98ae,0x11cf,0xa1,0x0d,0x00,0x20,0xaf,0xd1,0x56,0xe4);
DEFINE_GUID(KSPROPSETID_StreamAllocator,0xcf6e4342,0xec87,0x11cf,0xa1,0x30,0x00,0x20,0xaf,0xd1,0x56,0xe4);
DEFINE_GUID(KSPROPSETID_StreamInterface,0x1fdd8ee1,0x9cd3,0x11d0,0x82,0xaa,0x00,0x00,0xf8,0x22,0xfe,0x8a);
DEFINE_GUID(KSPROPSETID_Sysaudio,0xcbe3faa0,0xcc75,0x11d0,0xb4,0x65,0x00,0x00,0x1a,0x18,0x18,0xe6);
DEFINE_GUID(KSPROPSETID_Sysaudio_Pin,0xa3a53220,0xc6e4,0x11d0,0xb4,0x65,0x00,0x00,0x1a,0x18,0x18,0xe6);
DEFINE_GUID(KSPROPSETID_Topology,0x45ffaaa1,0x6e1b,0x11d0,0xbc,0xf2,0x44,0x45,0x53,0x54,0x00,0x00);
DEFINE_GUID(KSPROPSETID_TopologyNode,0x45ffaaa1,0x6e1b,0x11d0,0xbc,0xf2,0x44,0x45,0x53,0x54,0x00,0x00);
DEFINE_GUID(KSPROPSETID_TSRateChange,0xa503c5c0,0x1d1d,0x11d1,0xad,0x80,0x44,0x45,0x53,0x54,0x00,0x00);
DEFINE_GUID(KSPROPSETID_VBICAP_PROPERTIES,0xf162c607,0x7b35,0x496f,0xad,0x7f,0x2d,0xca,0x3b,0x46,0xb7,0x18);
DEFINE_GUID(KSPROPSETID_VBICodecFiltering,0xcafeb0ca,0x8715,0x11d0,0xbd,0x6a,0x00,0x35,0xc0,0xed,0xba,0xbe);
DEFINE_GUID(KSPROPSETID_VPConfig,0xbc29a660,0x30e3,0x11d0,0x9e,0x69,0x00,0xc0,0x4f,0xd7,0xc1,0x5b);
DEFINE_GUID(KSPROPSETID_VPVBIConfig,0xec529b00,0x1a1f,0x11d1,0xba,0xd9,0x00,0x60,0x97,0x44,0x11,0x1a);
DEFINE_GUID(KSPROPSETID_VramCapture,0xe73face3L,0x2880,0x4902,0xb7,0x99,0x88,0xd0,0xcd,0x63,0x4e,0xf);
DEFINE_GUID(KSPROPSETID_Wave,0x924e54b0,0x630f,0x11cf,0xad,0xa7,0x08,0x00,0x3e,0x30,0x49,0x4a);
DEFINE_GUID(KSPROPSETID_Wave_Queued,0x16a15b10,0x16f0,0x11d0,0xa1,0x95,0x00,0x20,0xaf,0xd1,0x56,0xe4);
DEFINE_GUID(KSPROPSETID_WaveTable,0x8539e660,0x62e9,0x11cf,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(KSPROPTYPESETID_General,0x97e99ba0,0xbdea,0x11cf,0xa5,0xd6,0x28,0xdb,0x04,0xc1,0x00,0x00);
DEFINE_GUID(KSTIME_FORMAT_BYTE,0x7b785571,0x8c82,0x11cf,0xbc,0x0c,0x00,0xaa,0x00,0xac,0x74,0xf6);
DEFINE_GUID(KSTIME_FORMAT_FIELD,0x7b785573,0x8c82,0x11cf,0xbc,0x0c,0x00,0xaa,0x00,0xac,0x74,0xf6);
DEFINE_GUID(KSTIME_FORMAT_FRAME,0x7b785570,0x8c82,0x11cf,0xbc,0x0c,0x00,0xaa,0x00,0xac,0x74,0xf6);
DEFINE_GUID(KSTIME_FORMAT_MEDIA_TIME,0x7b785574,0x8c82,0x11cf,0xbc,0x0c,0x00,0xaa,0x00,0xac,0x74,0xf6);
DEFINE_GUID(KSTIME_FORMAT_SAMPLE,0x7b785572,0x8c82,0x11cf,0xbc,0x0c,0x00,0xaa,0x00,0xac,0x74,0xf6);
DEFINE_GUID(PINNAME_VIDEO_ANALOGVIDEOIN,0xfb6c4283,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(PINNAME_VIDEO_CAPTURE,0xfb6c4281,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(PINNAME_VIDEO_CC,0xfb6c4289,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(PINNAME_VIDEO_CC_CAPTURE,0x1aad8061,0x012d,0x11d2,0xb4,0xb1,0x00,0xa0,0xd1,0x02,0xcf,0xbe);
DEFINE_GUID(PINNAME_VIDEO_EDS,0xfb6c4287,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(PINNAME_VIDEO_NABTS,0xfb6c4286,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(PINNAME_VIDEO_NABTS_CAPTURE,0x29703660,0x498a,0x11d2,0xb4,0xb1,0x00,0xa0,0xd1,0x02,0xcf,0xbe);
DEFINE_GUID(PINNAME_VIDEO_PREVIEW,0xfb6c4282,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(PINNAME_VIDEO_STILL,0xfb6c428a,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(PINNAME_VIDEO_TELETEXT,0xfb6c4288,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(PINNAME_VIDEO_TIMECODE,0xfb6c428b,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(PINNAME_VIDEO_VBI,0xfb6c4284,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(PINNAME_VIDEO_VIDEOPORT,0xfb6c4285,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(PINNAME_VIDEO_VIDEOPORT_VBI,0xfb6c428c,0x0353,0x11d1,0x90,0x5f,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(PROPSETID_ALLOCATOR_CONTROL,0x53171960,0x148e,0x11d2,0x99,0x79,0x00,0x00,0xc0,0xcc,0x16,0xba);
DEFINE_GUID(PROPSETID_TUNER,0x6a2e0605,0x28e4,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(PROPSETID_VIDCAP_CAMERACONTROL,0xc6e13370,0x30ac,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(PROPSETID_VIDCAP_CROSSBAR,0x6a2e0640,0x28e4,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(PROPSETID_VIDCAP_DROPPEDFRAMES,0xc6e13344,0x30ac,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(PROPSETID_VIDCAP_TVAUDIO,0x6a2e0650,0x28e4,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(PROPSETID_VIDCAP_VIDEOCOMPRESSION,0xc6e13343,0x30ac,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(PROPSETID_VIDCAP_VIDEOCONTROL,0x6a2e0670,0x28e4,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(PROPSETID_VIDCAP_VIDEODECODER,0xc6e13350,0x30ac,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(PROPSETID_VIDCAP_VIDEOENCODER,0x6a2e0610,0x28e4,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(PROPSETID_VIDCAP_VIDEOPROCAMP,0xc6e13360,0x30ac,0x11d0,0xa1,0x8c,0x00,0xa0,0xc9,0x11,0x89,0x56);
DEFINE_GUID(KSPROPSETID_BdaTopology, 0xa14ee835, 0x0a23, 0x11d3, 0x9c, 0xc7, 0x0, 0xc0, 0x4f, 0x79, 0x71, 0xe0);
DEFINE_GUID(KSMETHODSETID_BdaDeviceConfiguration, 0x71985f45, 0x1ca1, 0x11d3, 0x9c, 0xc8, 0x0, 0xc0, 0x4f, 0x79, 0x71, 0xe0);
DEFINE_GUID(KSPROPSETID_BdaPinControl, 0xded49d5, 0xa8b7, 0x4d5d, 0x97, 0xa1, 0x12, 0xb0, 0xc1, 0x95, 0x87, 0x4d);
DEFINE_GUID(KSMETHODSETID_BdaChangeSync, 0xfd0a5af3, 0xb41d, 0x11d2, 0x9c, 0x95, 0x0, 0xc0, 0x4f, 0x79, 0x71, 0xe0);
DEFINE_GUID(KSPROPSETID_BdaFrequencyFilter, 0x71985f47, 0x1ca1, 0x11d3, 0x9c, 0xc8, 0x0, 0xc0, 0x4f, 0x79, 0x71, 0xe0);
DEFINE_GUID(KSPROPSETID_BdaDigitalDemodulator, 0xef30f379, 0x985b, 0x4d10, 0xb6, 0x40, 0xa7, 0x9d, 0x5e, 0x4, 0xe1, 0xe0);
DEFINE_GUID(KSPROPSETID_BdaLNBInfo, 0x992cf102, 0x49f9, 0x4719, 0xa6, 0x64, 0xc4, 0xf2, 0x3e, 0x24, 0x8, 0xf4);
DEFINE_GUID(KSPROPSETID_BdaSignalStats, 0x1347d106, 0xcf3a, 0x428a, 0xa5, 0xcb, 0xac, 0xd, 0x9a, 0x2a, 0x43, 0x38);
DEFINE_GUID(KSDATAFORMAT_TYPE_BDA_ANTENNA, 0x71985f41, 0x1ca1, 0x11d3, 0x9c, 0xc8, 0x0, 0xc0, 0x4f, 0x79, 0x71, 0xe0);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_BDA_MPEG2_TRANSPORT, 0xf4aeb342, 0x0329, 0x4fdd, 0xa8, 0xfd, 0x4a, 0xff, 0x49, 0x26, 0xc9, 0x78);
DEFINE_GUID(KSDATAFORMAT_SPECIFIER_BDA_TRANSPORT, 0x8deda6fd, 0xac5f, 0x4334, 0x8e, 0xcf, 0xa4, 0xba, 0x8f, 0xa7, 0xd0, 0xf0);
DEFINE_GUID(KSDATAFORMAT_TYPE_BDA_IF_SIGNAL, 0x61be0b47, 0xa5eb, 0x499b, 0x9a, 0x85, 0x5b, 0x16, 0xc0, 0x7f, 0x12, 0x58);
DEFINE_GUID(KSDATAFORMAT_TYPE_MPEG2_SECTIONS, 0x455f176c, 0x4b06, 0x47ce, 0x9a, 0xef, 0x8c, 0xae, 0xf7, 0x3d, 0xf7, 0xb5);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_ATSC_SI, 0xb3c7397c, 0xd303, 0x414d, 0xb3, 0x3c, 0x4e, 0xd2, 0xc9, 0xd2, 0x97, 0x33);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_DVB_SI, 0xe9dd31a3, 0x221d, 0x4adb, 0x85, 0x32, 0x9a, 0xf3, 0x9, 0xc1, 0xa4, 0x8);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_BDA_OPENCABLE_PSIP, 0x762e3f66, 0x336f, 0x48d1, 0xbf, 0x83, 0x2b, 0x0, 0x35, 0x2c, 0x11, 0xf0);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_BDA_OPENCABLE_OOB_PSIP, 0x951727db, 0xd2ce, 0x4528, 0x96, 0xf6, 0x33, 0x1, 0xfa, 0xbb, 0x2d, 0xe0);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_ISDB_SI, 0x4a2eeb99, 0x6458, 0x4538, 0xb1, 0x87, 0x04, 0x01, 0x7c, 0x41, 0x41, 0x3f);
DEFINE_GUID(KSDATAFORMAT_SUBTYPE_PBDA_TRANSPORT_RAW, 0x0d7aed42, 0xcb9a, 0x11db, 0x97, 0x05, 0x00, 0x50, 0x56, 0xc0, 0x00, 0x08);
