# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::BR;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20211206222442;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            1(?:
              1[25-8]|
              2[357-9]|
              3[02-68]|
              4[12568]|
              5|
              6[0-8]|
              8[015]|
              9[0-47-9]
            )|
            321|
            610
          ',
                  'pattern' => '(\\d{3,6})'
                },
                {
                  'format' => '$1-$2',
                  'leading_digits' => '
            4(?:
              02|
              37
            )0|
            [34]00
          ',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            [2357]|
            4(?:
              [0-24-9]|
              3(?:
                [0-689]|
                7[1-9]
              )
            )
          ',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            (?:
              [358]|
              90
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2,3})(\\d{4})'
                },
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '9',
                  'pattern' => '(\\d{5})(\\d{4})'
                },
                {
                  'format' => '$1 $2-$3',
                  'leading_digits' => '
            (?:
              [14689][1-9]|
              2[12478]|
              3[1-578]|
              5[13-5]|
              7[13-579]
            )[2-57]
          ',
                  'national_rule' => '($1)',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2-$3',
                  'leading_digits' => '
            [16][1-9]|
            [2-57-9]
          ',
                  'national_rule' => '($1)',
                  'pattern' => '(\\d{2})(\\d{5})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            [14689][1-9]|
            2[12478]|
            3[1-578]|
            5[13-5]|
            7[13-579]
          )[2-5]\\d{7}
        ',
                'geographic' => '
          (?:
            [14689][1-9]|
            2[12478]|
            3[1-578]|
            5[13-5]|
            7[13-579]
          )[2-5]\\d{7}
        ',
                'mobile' => '
          (?:
            [14689][1-9]|
            2[12478]|
            3[1-578]|
            5[13-5]|
            7[13-579]
          )(?:
            7|
            9\\d
          )\\d{7}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          300\\d{7}|
          [34]00\\d{5}|
          4(?:
            02|
            37
          )0\\d{4}
        )|(
          300\\d{6}|
          [59]00\\d{6,7}
        )',
                'toll_free' => '800\\d{6,7}',
                'voip' => ''
              };
my %areanames = ();
$areanames{pt} = {"5561", "Distrito\ Federal",};
$areanames{en} = {"55873201", "Petrolina\ \-\ PE",
"55433524", "Cornélio\ Procópio\ \-\ PR",
"55863259", "Lagoa\ do\ Piauí\ \-\ PI",
"55273321", "Vitória\ \-\ ES",
"55943315", "PA\ 275\ \-\ PA",
"55423904", "Telêmaco\ Borba\ \-\ PR",
"55443536", "Brasiliana\ \-\ PR",
"55773402", "Vitória\ da\ Conquista\ \-\ BA",
"55143285", "Cabrália\ Paulista\ \-\ SP",
"5571349", "Salvador\ \-\ BA",
"55623483", "Sítio\ D\'Abadia\ \-\ GO",
"55443340", "Alto\ Alegre\ \-\ PR",
"55193056", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55163246", "Taiúva\ \-\ SP",
"55443062", "Paranavaí\ \-\ PR",
"55662103", "Rondonópolis\ \-\ MT",
"55743551", "Filadélfia\ \-\ BA",
"55823027", "Maceió\ \-\ AL",
"55213743", "Nilópolis\ \-\ RJ",
"55673471", "Iguatemi\ \-\ MS",
"55643942", "Itumbiara\ \-\ GO",
"55613026", "Brasília\ \-\ DF",
"55513471", "Cachoeirinha\ \-\ RS",
"55113403", "Bragança\ Paulista\ \-\ SP",
"55222542", "Nova\ Friburgo\ \-\ RJ",
"55613628", "Novo\ Gama\ \-\ GO",
"55333416", "Virginópolis\ \-\ MG",
"55813708", "Bezerros\ \-\ PE",
"55213432", "Rio\ de\ Janeiro\ \-\ RJ",
"55463544", "Enéas\ Marques\ \-\ PR",
"55112610", "Mogi\ das\ Cruzes\ \-\ SP",
"55513243", "Rio\ Grande\ do\ Sul",
"55212016", "Rio\ de\ Janeiro\ \-\ RJ",
"55673243", "Dois\ Irmãos\ do\ Buriti\ \-\ MS",
"55493667", "São\ Miguel\ da\ Boa\ Vista\ \-\ SC",
"55513425", "Canoas\ \-\ RS",
"55213621", "Rio\ de\ Janeiro\ \-\ RJ",
"55913346", "Ananindeua\ \-\ PA",
"55893464", "Caridade\ do\ Piauí\ \-\ PI",
"55823279", "Boca\ da\ Mata\ \-\ AL",
"55213849", "Rio\ de\ Janeiro\ \-\ RJ",
"55553227", "Itaara\ \-\ RS",
"55443667", "Santa\ Eliza\ \-\ PR",
"55862106", "Teresina\ \-\ PI",
"55543435", "Boa\ Vista\ do\ Sul\ \-\ RS",
"55312564", "Contagem\ \-\ MG",
"55823622", "São\ José\ da\ Tapera\ \-\ AL",
"55153562", "Itaberá\ \-\ SP",
"55553358", "Salvador\ das\ Missões\ \-\ RS",
"55443619", "Cianorte\ \-\ PR",
"55733311", "Teixeira\ de\ Freitas\ \-\ BA",
"55793346", "Canindé\ de\ São\ Francisco\ \-\ SE",
"55313414", "Minas\ Gerais",
"55613487", "Sobradinho\ \-\ DF",
"55793530", "Estância\ \-\ SE",
"55112597", "São\ Paulo\ \-\ SP",
"55963324", "Itaubal\ \-\ AP",
"55213833", "Rio\ de\ Janeiro\ \-\ RJ",
"5571348", "Salvador\ \-\ BA",
"55483664", "Florianópolis\ \-\ SC",
"55143295", "Boracéia\ \-\ SP",
"55543338", "Victor\ Graeff\ \-\ RS",
"55322104", "Juiz\ de\ Fora\ \-\ MG",
"55173818", "Bady\ Bassitt\ \-\ SP",
"55153372", "Itapetininga\ \-\ SP",
"55883419", "Arneiroz\ \-\ CE",
"55673239", "Água\ Clara\ \-\ MS",
"55333233", "Tarumirim\ \-\ MG",
"55513239", "Rio\ Grande\ do\ Sul",
"55493536", "Salto\ Veloso\ \-\ SC",
"55193512", "Campinas\ \-\ SP",
"55453306", "Cascavel\ \-\ PR",
"55884102", "Crato\ \-\ CE",
"55112661", "São\ Paulo\ \-\ SP",
"55653225", "Porto\ Esperidião\ \-\ MT",
"55793314", "Itabi\ \-\ SE",
"55473373", "Guaramirim\ \-\ SC",
"55753526", "Maragogipe\ \-\ BA",
"5548322", "Florianópolis\ \-\ SC",
"55313858", "Dionísio\ \-\ MG",
"55193842", "Serra\ Negra\ \-\ SP",
"55143732", "Avaré\ \-\ SP",
"55443575", "Roncador\ \-\ PR",
"55693459", "Ji\-Paraná\ \-\ RO",
"55273072", "Vila\ Velha\ \-\ ES",
"55953591", "Uiramutã\ \-\ RR",
"55813093", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55313446", "Belo\ Horizonte\ \-\ MG",
"55143457", "Oscar\ Bressane\ \-\ SP",
"55193439", "Saltinho\ \-\ SP",
"55414114", "Curitiba\ \-\ PR",
"55493242", "São\ José\ do\ Cerrito\ \-\ SC",
"55173548", "Marapoama\ \-\ SP",
"55313267", "Belo\ Horizonte\ \-\ MG",
"55883532", "Barbalha\ \-\ CE",
"55123608", "Taubaté\ \-\ SP",
"55113429", "São\ Paulo\ \-\ SP",
"55843269", "Riachuelo\ \-\ RN",
"55513485", "Viamão\ \-\ RS",
"55633477", "Itaguatins\ \-\ TO",
"55343318", "Uberaba\ \-\ MG",
"55413116", "São\ José\ dos\ Pinhais\ \-\ PR",
"55433535", "Jaguariaíva\ \-\ PR",
"55663016", "Primavera\ do\ Leste\ \-\ MT",
"55993556", "Mirador\ \-\ MA",
"5511366", "São\ Paulo\ \-\ SP",
"55213103", "Nova\ Iguaçu\ \-\ RJ",
"55443521", "Goioerê\ \-\ PR",
"55943012", "Marabá\ \-\ PA",
"55753364", "Iraquara\ \-\ BA",
"55273381", "Vitória\ \-\ ES",
"55124004", "São\ José\ dos\ Campos\ \-\ SP",
"55513434", "Viamão\ \-\ RS",
"55663302", "Rondonópolis\ \-\ MT",
"55673434", "Sanga\ Puitã\ \-\ MS",
"55413673", "Piraquara\ \-\ PR",
"55883668", "Senador\ Sá\ \-\ CE",
"55473563", "Salete\ \-\ SC",
"55753202", "Retirolândia\ \-\ BA",
"55794002", "Aracaju\ \-\ SE",
"55834009", "João\ Pessoa\ \-\ PB",
"55343415", "Iturama\ \-\ MG",
"55733554", "Aurelino\ Leal\ \-\ BA",
"55212005", "Rio\ de\ Janeiro\ \-\ RJ",
"55323263", "Maripá\ de\ Minas\ \-\ MG",
"55493365", "Modelo\ \-\ SC",
"55543476", "União\ da\ Serra\ \-\ RS",
"55163214", "Araraquara\ \-\ SP",
"55754101", "Feira\ de\ Santana\ \-\ BA",
"55983268", "São\ Luís\ \-\ MA",
"55773641", "Mansidão\ \-\ BA",
"55552101", "Santa\ Maria\ \-\ RS",
"55413586", "São\ José\ dos\ Pinhais\ \-\ PR",
"55493521", "Joaçaba\ \-\ SC",
"55623572", "Goiânia\ \-\ GO",
"55153459", "Iperó\ \-\ SP",
"55163668", "Santo\ Antônio\ da\ Alegria\ \-\ SP",
"55433623", "Porecatu\ \-\ PR",
"55833461", "Santa\ Luzia\ \-\ PB",
"55193457", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55353465", "Monte\ Sião\ \-\ MG",
"55423677", "Pinhão\ \-\ PR",
"55443242", "Floraí\ \-\ PR",
"55733262", "Eunápolis\ \-\ BA",
"55114772", "Jandira\ \-\ SP",
"55663552", "Guarantã\ do\ Norte\ \-\ MT",
"5521262", "Niterói\ \-\ RJ",
"55623362", "Porangatu\ \-\ GO",
"55943341", "Bom\ Jesus\ do\ Tocantins\ \-\ PA",
"55273755", "Ecoporanga\ \-\ ES",
"55823426", "Estrela\ de\ Alagoas\ \-\ AL",
"55213691", "Japeri\ \-\ RJ",
"55623142", "Goiânia\ \-\ GO",
"55143842", "São\ Manuel\ \-\ SP",
"55713669", "Palmares\ \-\ BA",
"55513495", "Sertão\ Santana\ \-\ RS",
"55673495", "Caracol\ \-\ MS",
"55133296", "Santos\ \-\ SP",
"55313434", "Belo\ Horizonte\ \-\ MG",
"55493657", "Santa\ Terezinha\ do\ Progresso\ \-\ SC",
"55753603", "Feira\ de\ Santana\ \-\ BA",
"55443639", "Umuarama\ \-\ PR",
"55893454", "Fronteiras\ \-\ PI",
"55613045", "Brasília\ \-\ DF",
"55433356", "Londrina\ \-\ PR",
"55114142", "Itapevi\ \-\ SP",
"55713394", "Aratu\ \-\ BA",
"55814003", "Recife\ \-\ PE",
"55313388", "Belo\ Horizonte\ \-\ MG",
"55114204", "Araçariguama\ \-\ SP",
"55213644", "Teresópolis\ \-\ RJ",
"55473238", "Blumenau\ \-\ SC",
"55983397", "Turiaçu\ \-\ MA",
"55673446", "Angélica\ \-\ MS",
"55833099", "Campina\ Grande\ \-\ PB",
"55513446", "Viamão\ \-\ RS",
"55243353", "Porto\ Real\ \-\ RJ",
"55493643", "São\ José\ do\ Cedro\ \-\ SC",
"55283555", "Mimoso\ do\ Sul\ \-\ ES",
"55883439", "Ibaretama\ \-\ CE",
"55333213", "Governador\ Valadares\ \-\ MG",
"55353297", "Alfenas\ \-\ MG",
"55192127", "Campinas\ \-\ SP",
"55663437", "Campinápolis\ \-\ MT",
"55273344", "Viana\ \-\ ES",
"55273555", "Mimoso\ do\ Sul\ \-\ ES",
"55913082", "Belém\ \-\ PA",
"55153302", "Sorocaba\ \-\ SP",
"55433541", "Uraí\ \-\ PR",
"55453324", "Cascavel\ \-\ PR",
"55753181", "Alagoinhas\ \-\ BA",
"55173838", "Pedranópolis\ \-\ SP",
"55863269", "Beneditinos\ \-\ PI",
"55823293", "Paripueira\ \-\ AL",
"55213813", "Rio\ de\ Janeiro\ \-\ RJ",
"55513267", "Rio\ Grande\ do\ Sul",
"55683267", "Vila\ Campinas\ \(Pad\ Peixoto\)\ \-\ AC",
"55812101", "Recife\ \-\ PE",
"55453376", "Nova\ Concórdia\ \-\ PR",
"55153264", "Águia\ da\ Castelo\ \-\ SP",
"55873842", "Ibimirim\ \-\ PE",
"55624051", "Anápolis\ \-\ GO",
"55412118", "Curitiba\ \-\ PR",
"55222102", "Nova\ Friburgo\ \-\ RJ",
"55183217", "Presidente\ Prudente\ \-\ SP",
"55463242", "Chopinzinho\ \-\ PR",
"55112651", "São\ Paulo\ \-\ SP",
"5531331", "Minas\ Gerais",
"55773684", "Roda\ Velha\ \-\ BA",
"55753699", "Saubara\ \-\ BA",
"55212638", "Maricá\ \-\ RJ",
"55613004", "Brasília\ \-\ DF",
"55242487", "Avelar\ \-\ RJ",
"55183748", "Ilha\ Solteira\ \-\ SP",
"55773472", "Maetinga\ \-\ BA",
"55983387", "Palmeirândia\ \-\ MA",
"55173269", "Ipiguá\ \-\ SP",
"55143532", "Lins\ \-\ SP",
"55183269", "Pirapozinho\ \-\ SP",
"55443643", "Francisco\ Alves\ \-\ PR",
"55823283", "Viçosa\ \-\ AL",
"55513401", "Guaíba\ \-\ RS",
"55323538", "Presidente\ Bernardes\ \-\ MG",
"55473654", "Monte\ Castelo\ \-\ SC",
"55943335", "Itinga\ do\ Maranhão\ \-\ PA",
"55483654", "Santa\ Rosa\ de\ Lima\ \-\ SC",
"55923524", "Urucurituba\ \-\ AM",
"55143214", "Bauru\ \-\ SP",
"55153552", "Apiaí\ \-\ SP",
"55843013", "Natal\ \-\ RN",
"55383255", "Botumirim\ \-\ MG",
"55413629", "Tijucas\ do\ Sul\ \-\ PR",
"55883443", "Quixeré\ \-\ CE",
"55313398", "Minas\ Gerais",
"55143668", "Itaju\ \-\ SP",
"55343424", "Itapagipe\ \-\ MG",
"55333436", "Rio\ Vermelho\ \-\ MG",
"55133822", "Registro\ \-\ SP",
"55472102", "Blumenau\ \-\ SC",
"55693302", "Porto\ Velho\ \-\ RO",
"55352101", "Poços\ de\ Caldas\ \-\ MG",
"55482102", "Criciúma\ \-\ SC",
"55533249", "Hulha\ Negra\ \-\ RS",
"55313243", "Minas\ Gerais",
"55212752", "São\ João\ de\ Meriti\ \-\ RJ",
"55114493", "Várzea\ Paulista\ \-\ SP",
"55913120", "Belém\ \-\ PA",
"55473399", "Timbó\ \-\ SC",
"55443355", "Maringá\ \-\ PR",
"55443544", "Tupãssi\ \-\ PR",
"55883658", "Poranga\ \-\ CE",
"55753629", "Conceição\ do\ Almeida\ \-\ BA",
"55623502", "Bela\ Vista\ de\ Goiás\ \-\ GO",
"55753545", "Milagres\ \-\ BA",
"55163234", "Ribeirão\ Preto\ \-\ SP",
"5582", "Alagoas",
"55114882", "Carapicuíba\ \-\ SP",
"55843259", "Barcelona\ \-\ RN",
"55633015", "Palmas\ \-\ TO",
"55463536", "Dois\ Vizinhos\ \-\ PR",
"55163512", "Ribeirão\ Preto\ \-\ SP",
"55114702", "Cotia\ \-\ SP",
"55463581", "Dois\ Vizinhos\ \-\ PR",
"55473547", "Braço\ do\ Trombudo\ \-\ SC",
"55642103", "Itumbiara\ \-\ GO",
"55413699", "Almirante\ Tamandaré\ \-\ PR",
"55713637", "Vera\ Cruz\ \-\ BA",
"55313868", "Conceição\ do\ Mato\ Dentro\ \-\ MG",
"55134010", "Santos\ \-\ SP",
"55313328", "Minas\ Gerais",
"55883512", "Juazeiro\ do\ Norte\ \-\ CE",
"55643469", "Anhanguera\ \-\ GO",
"55133211", "Santos\ \-\ SP",
"55943324", "Marabá\ \-\ PA",
"55343338", "Uberaba\ \-\ MG",
"55213543", "Rio\ de\ Janeiro\ \-\ RJ",
"55743627", "Miguel\ Calmon\ \-\ BA",
"55114409", "Jacaré\ \-\ SP",
"55833277", "Pirpirituba\ \-\ PB",
"55483303", "Florianópolis\ \-\ SC",
"55273765", "Pinheiros\ \-\ ES",
"55543273", "Nova\ Bassano\ \-\ RS",
"55143201", "Bauru\ \-\ SP",
"55113112", "São\ Paulo\ \-\ SP",
"55673047", "Campo\ Grande\ \-\ MS",
"55323466", "Além\ Paraíba\ \-\ MG",
"55114892", "Bragança\ Paulista\ \-\ SP",
"55513047", "Gravataí\ \-\ RS",
"55643417", "Morrinhos\ \-\ GO",
"55843237", "Parnamirim\ \-\ RN",
"55663562", "Santa\ Carmem\ \-\ MT",
"55242255", "Três\ Rios\ \-\ RJ",
"55913751", "Abaetetuba\ \-\ PA",
"55833451", "Itaporanga\ \-\ PB",
"55493458", "Itá\ \-\ SC",
"55353455", "São\ João\ da\ Mata\ \-\ MG",
"55993637", "Joselândia\ \-\ MA",
"55123678", "Natividade\ da\ Serra\ \-\ SP",
"55333421", "Guanhães\ \-\ MG",
"55313239", "Belo\ Horizonte\ \-\ MG",
"55773624", "Riachão\ das\ Neves\ \-\ BA",
"55112923", "Jundiaí\ \-\ SP",
"5512364", "Pindamonhangaba\ \-\ SP",
"55513053", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55112807", "Embu\ das\ Artes\ \-\ SP",
"55793022", "Aracaju\ \-\ SE",
"55112787", "São\ Paulo\ \-\ SP",
"55114483", "Mairiporã\ \-\ SP",
"55694001", "Porto\ Velho\ \-\ RO",
"55133493", "Praia\ Grande\ \-\ SP",
"55413603", "Itaperuçu\ \-\ PR",
"55673414", "Vila\ Vargas\ \-\ MS",
"55923584", "Manaus\ \-\ AM",
"55323253", "Tabuleiro\ \-\ MG",
"55543441", "Veranópolis\ \-\ RS",
"55853328", "Mulungu\ \-\ CE",
"55493355", "Lajeado\ Grande\ \-\ SC",
"55493544", "Campos\ Novos\ \-\ SC",
"5582337", "Maceió\ \-\ AL",
"55823223", "Maceió\ \-\ AL",
"55753272", "Tucano\ \-\ BA",
"55513045", "Viamão\ \-\ RS",
"55242471", "Vassouras\ \-\ RJ",
"55983371", "Governador\ Nunes\ Freire\ \-\ MA",
"55213830", "Rio\ de\ Janeiro\ \-\ RJ",
"55323423", "Cataguases\ \-\ MG",
"55273767", "São\ Mateus\ \-\ ES",
"55533312", "Bagé\ \-\ RS",
"55833275", "Serraria\ \-\ PB",
"55353732", "Ipuiúna\ \-\ MG",
"55973428", "Maraã\ \-\ AM",
"55543618", "Nonoai\ \-\ RS",
"55373434", "Medeiros\ \-\ MG",
"55193578", "Campinas\ \-\ SP",
"55353271", "Lambari\ \-\ MG",
"55863241", "Boa\ Hora\ \-\ PI",
"55483272", "Antônio\ Carlos\ \-\ SC",
"55353457", "Heliodora\ \-\ MG",
"55993635", "Lago\ Verde\ \-\ MA",
"55743549", "Rômulo\ Campos\ \-\ BA",
"55433569", "Pinhalão\ \-\ PR",
"55493343", "Formosa\ do\ Sul\ \-\ SC",
"55843235", "Natal\ \-\ RN",
"55183872", "Ouro\ Verde\ \-\ SP",
"55242257", "Areal\ \-\ RJ",
"55114538", "Itatiba\ \-\ SP",
"55353225", "Carmo\ da\ Cachoeira\ \-\ MG",
"55333251", "Santana\ do\ Paraíso\ \-\ MG",
"55183522", "Adamantina\ \-\ SP",
"55493228", "Bocaina\ do\ Sul\ \-\ SC",
"55173522", "Catanduva\ \-\ SP",
"55112785", "São\ Paulo\ \-\ SP",
"55213555", "Rio\ de\ Janeiro\ \-\ RJ",
"55423644", "Santa\ Maria\ do\ Oeste\ \-\ PR",
"55983325", "Maranhãozinho\ \-\ MA",
"55313152", "Sete\ Lagoas\ \-\ MG",
"55112805", "Diadema\ \-\ SP",
"55542621", "Bento\ Gonçalves\ \-\ RS",
"55843284", "Serrinha\ \-\ RN",
"55893429", "São\ João\ da\ Canabrava\ \-\ PI",
"55172137", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55643602", "Rio\ Verde\ \-\ GO",
"55213851", "Nova\ Iguaçu\ \-\ RJ",
"55193828", "Sumaré\ \-\ SP",
"55823266", "Satuba\ \-\ AL",
"55114662", "Embu\-Guaçu\ \-\ SP",
"55872101", "Petrolina\ \-\ PE",
"55943779", "Goianésia\ do\ Pará\ \-\ PA",
"55633612", "Gurupi\ \-\ TO",
"55973561", "Coari\ \-\ AM",
"55353443", "Jacutinga\ \-\ MG",
"55112501", "São\ Paulo\ \-\ SP",
"55713472", "Salvador\ \-\ BA",
"55423412", "Mato\ Branco\ de\ Baixo\ \-\ PR",
"55843294", "São\ José\ do\ Campestre\ \-\ RN",
"55512139", "Porto\ Alegre\ \-\ RS",
"55493339", "Águas\ de\ Chapecó\ \-\ SC",
"55543552", "Cacique\ Doble\ \-\ RS",
"55743533", "Campo\ Alegre\ de\ Lourdes\ \-\ BA",
"55813271", "Recife\ \-\ PE",
"55223841", "Natividade\ \-\ RJ",
"55673240", "Aquidauana\ \-\ MS",
"5511562", "São\ Paulo\ \-\ SP",
"55813732", "Fazenda\ Nova\ \-\ PE",
"55323362", "Barbacena\ \-\ MG",
"55633444", "Axixá\ do\ Tocantins\ \-\ TO",
"55623456", "Divinópolis\ de\ Goiás\ \-\ GO",
"55613401", "Taguatinga\ \-\ DF",
"55813457", "Paulista\ \-\ PE",
"55853031", "Fortaleza\ \-\ CE",
"55343459", "Frutal\ \-\ MG",
"55115044", "São\ Paulo\ \-\ SP",
"55843429", "Jucurutu\ \-\ RN",
"55162101", "Ribeirão\ Preto\ \-\ SP",
"55733573", "Prado\ \-\ BA",
"55473545", "Pouso\ Redondo\ \-\ SC",
"55473354", "Guabiruba\ \-\ SC",
"55483354", "Garopaba\ \-\ SC",
"55773438", "Cândido\ Sales\ \-\ BA",
"55163287", "Vista\ Alegre\ do\ Alto\ \-\ SP",
"55833542", "Santa\ Helena\ \-\ PB",
"5511472", "Mogi\ das\ Cruzes\ \-\ SP",
"55114067", "Diadema\ \-\ SP",
"55793549", "Poço\ Verde\ \-\ SE",
"55443343", "Maringá\ \-\ PR",
"55663476", "Araguainha\ \-\ MT",
"55333084", "Governador\ Valadares\ \-\ MG",
"55643998", "Itumbiara\ \-\ GO",
"55213974", "Rio\ de\ Janeiro\ \-\ RJ",
"55713635", "Mata\ de\ São\ João\ \-\ BA",
"55164003", "Ribeirão\ Preto\ \-\ SP",
"55323572", "Silveirânia\ \-\ MG",
"551137", "São\ Paulo\ \-\ SP",
"55353842", "Nazareno\ \-\ MG",
"55114019", "Itu\ \-\ SP",
"55313096", "Ipatinga\ \-\ MG",
"55663424", "Rondonópolis\ \-\ MT",
"55473629", "Bela\ Vista\ do\ Toldo\ \-\ SC",
"55983385", "Bequimão\ \-\ MA",
"55733674", "Barra\ de\ Caravelas\ \-\ BA",
"55843224", "Natal\ \-\ RN",
"55973385", "Manicoré\ \-\ AM",
"55313628", "Ribeirão\ das\ Neves\ \-\ MG",
"55813658", "Glória\ do\ Goitá\ \-\ PE",
"55693441", "Cacoal\ \-\ RO",
"55242485", "Paty\ do\ Alferes\ \-\ RJ",
"55893489", "Conceição\ do\ Canindé\ \-\ PI",
"55813080", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55732011", "Teixeira\ de\ Freitas\ \-\ BA",
"55413399", "Campo\ Largo\ \-\ PR",
"55373243", "Itaúna\ \-\ MG",
"55183582", "Parapuã\ \-\ SP",
"55833281", "Itabaiana\ \-\ PB",
"55752102", "Feira\ de\ Santana\ \-\ BA",
"55613642", "Formosa\ \-\ GO",
"55433452", "Borrazópolis\ \-\ PR",
"55843276", "Monte\ Alegre\ \-\ RN",
"55733626", "Núcleo\ Colonial\ de\ Una\ \-\ BA",
"55943337", "Brejo\ Grande\ do\ Araguaia\ \-\ PA",
"55193708", "Campinas\ \-\ SP",
"55114247", "Barueri\ \-\ SP",
"55373425", "Luz\ \-\ MG",
"55743634", "Caldeirão\ Grande\ \-\ BA",
"55544001", "Caxias\ do\ Sul\ \-\ RS",
"55553419", "Barra\ do\ Quaraí\ \-\ RS",
"55283539", "Itaoca\ \-\ ES",
"55163508", "Araraquara\ \-\ SP",
"55193888", "Paulínia\ \-\ SP",
"55114718", "Mairinque\ \-\ SP",
"55993078", "Caxias\ \-\ MA",
"55983488", "Santana\ do\ Maranhão\ \-\ MA",
"5511479", "Mogi\ das\ Cruzes\ \-\ SP",
"55743685", "Mundo\ Novo\ \-\ BA",
"55623518", "Aparecida\ de\ Goiânia\ \-\ GO",
"55112771", "São\ Paulo\ \-\ SP",
"55413547", "Lapa\ \-\ PR",
"55683342", "Rodrigues\ Alves\ \-\ AC",
"55533015", "Pelotas\ \-\ RS",
"55653023", "Cuiabá\ \-\ MT",
"55753654", "Brejões\ \-\ BA",
"55313074", "Belo\ Horizonte\ \-\ MG",
"55443655", "Cafezal\ do\ Sul\ \-\ PR",
"55973334", "Canutama\ \-\ AM",
"55533261", "Jaguarão\ \-\ RS",
"55542103", "Passo\ Fundo\ \-\ RS",
"55313026", "Sete\ Lagoas\ \-\ MG",
"55663494", "São\ José\ do\ Povo\ \-\ MT",
"55923323", "Pitinga\ \-\ AM",
"55213002", "Rio\ de\ Janeiro\ \-\ RJ",
"55213765", "Mesquita\ \-\ RJ",
"55493655", "Campo\ Erê\ \-\ SC",
"55283543", "Ibatiba\ \-\ ES",
"55813512", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55713113", "Salvador\ \-\ BA",
"55383239", "Mirabela\ \-\ MG",
"55633233", "Palmas\ \-\ TO",
"55753238", "Terra\ Nova\ \-\ BA",
"55163358", "Araraquara\ \-\ SP",
"55833291", "Rio\ Tinto\ \-\ PB",
"55353295", "Machado\ \-\ MG",
"5511568", "São\ Paulo\ \-\ SP",
"55663435", "Tesouro\ \-\ MT",
"55553201", "Santo\ Ângelo\ \-\ RS",
"55153273", "Itapetininga\ \-\ SP",
"55283557", "Apiacá\ \-\ ES",
"55863582", "São\ Raimundo\ Nonato\ \-\ PI",
"55513011", "Lajeado\ \-\ RS",
"55893499", "Bela\ Vista\ do\ Piauí\ \-\ PI",
"55743258", "Baixa\ Grande\ \-\ BA",
"55713624", "Camaçari\ \-\ BA",
"55143888", "Pereiras\ \-\ SP",
"55123421", "Taubaté\ \-\ SP",
"55983395", "Godofredo\ Viana\ \-\ MA",
"55613053", "Brasília\ \-\ DF",
"55193898", "Lindóia\ \-\ SP",
"55123632", "Taubaté\ \-\ SP",
"55423543", "Paulo\ Frontin\ \-\ PR",
"55643441", "Catalão\ \-\ GO",
"55333332", "Manhuaçu\ \-\ MG",
"55443288", "Sarandi\ \-\ PR",
"55193023", "Rio\ Claro\ \-\ SP",
"55713676", "Mata\ de\ São\ João\ \-\ BA",
"55714119", "Candeias\ \-\ BA",
"55813201", "Recife\ \-\ PE",
"55493367", "Sul\ Brasil\ \-\ SC",
"55823256", "Flexeiras\ \-\ AL",
"55114652", "Arujá\ \-\ SP",
"55313342", "Belo\ Horizonte\ \-\ MG",
"55313162", "Betim\ \-\ MG",
"55553234", "Vila\ Nova\ do\ Sul\ \-\ RS",
"55683026", "Rio\ Branco\ \-\ AC",
"55273743", "Colatina\ \-\ ES",
"55613471", "Ceilândia\ \-\ DF",
"5511458", "Jundiaí\ \-\ SP",
"55813712", "Caruaru\ \-\ PE",
"55743646", "Cafarnaum\ \-\ BA",
"55323274", "Rio\ Novo\ \-\ MG",
"55333261", "Conselheiro\ Pena\ \-\ MG",
"55493319", "Chapecó\ \-\ SC",
"55433559", "Joaquim\ Távora\ \-\ PR",
"55192114", "Limeira\ \-\ SP",
"55553512", "Santa\ Rosa\ \-\ RS",
"55423675", "Copel\ \-\ PR",
"55273129", "Guarapari\ \-\ ES",
"55193455", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55114039", "Campo\ Limpo\ Paulista\ \-\ SP",
"55513628", "Maquiné\ \-\ RS",
"55663406", "Torixoréu\ \-\ MT",
"5571325", "Salvador\ \-\ BA",
"55443640", "Esperança\ Nova\ \-\ PR",
"55863276", "Piripiri\ \-\ PI",
"55823280", "Pindoba\ \-\ AL",
"55693435", "Novo\ Horizonte\ do\ Oeste\ \-\ RO",
"55893582", "São\ Raimundo\ Nonato\ \-\ PI",
"55354102", "Pouso\ Alegre\ \-\ MG",
"55983346", "Bacabeira\ \-\ MA",
"55513497", "Gravataí\ \-\ RS",
"55973346", "Uarini\ \-\ AM",
"55173489", "Brasitânia\ \-\ SP",
"55273757", "Ponto\ Belo\ \-\ ES",
"55153494", "Ibiúna\ \-\ SP",
"55163708", "Franca\ \-\ SP",
"55114518", "Mauá\ \-\ SP",
"55543372", "Marcelino\ Ramos\ \-\ RS",
"55242401", "Barra\ do\ Piraí\ \-\ RJ",
"55483202", "Florianópolis\ \-\ SC",
"55193508", "Araras\ \-\ SP",
"55853342", "Caucaia\ \-\ CE",
"55353712", "Poços\ de\ Caldas\ \-\ MG",
"55433537", "Barra\ do\ Jacaré\ \-\ PR",
"55633475", "Esperantina\ \-\ TO",
"55513487", "Glorinha\ \-\ RS",
"55673487", "Vila\ Marques\ \-\ MS",
"55313265", "Minas\ Gerais",
"55183276", "Piquerobi\ \-\ SP",
"55173802", "Paulo\ de\ Faria\ \-\ SP",
"55473364", "Dona\ Emma\ \-\ SC",
"55843061", "Mossoró\ \-\ RN",
"55173276", "Engenheiro\ Balduíno\ \-\ SP",
"55413664", "Doutor\ Ulysses\ \-\ PR",
"55543036", "Gramado\ \-\ RS",
"55623466", "Vila\ Boa\ \-\ GO",
"55143227", "Bauru\ \-\ SP",
"55114043", "Diadema\ \-\ SP",
"55814102", "Recife\ \-\ PE",
"5575322", "Feira\ de\ Santana\ \-\ BA",
"55483526", "Balneário\ Arroio\ do\ Silva\ \-\ SC",
"55115021", "São\ Paulo\ \-\ SP",
"55633378", "Ponte\ Alta\ do\ Tocantins\ \-\ TO",
"55643672", "Mineiros\ \-\ GO",
"55813419", "Recife\ \-\ PE",
"55633421", "Araguaína\ \-\ TO",
"55733645", "Medeiros\ Neto\ \-\ BA",
"5511314", "São\ Paulo\ \-\ SP",
"55913733", "Murucupi\ \-\ PA",
"55933557", "Faro\ \-\ PA",
"55513688", "Rio\ Grande\ do\ Sul",
"55112891", "Suzano\ \-\ SP",
"55863284", "Barro\ Duro\ \-\ PI",
"55753218", "Salgadália\ \-\ BA",
"55833433", "Coremas\ \-\ PB",
"55443665", "Icaraíma\ \-\ PR",
"55873828", "Tuparetama\ \-\ PE",
"5516396", "Ribeirão\ Preto\ \-\ SP",
"55533251", "São\ Lourenço\ do\ Sul\ \-\ RS",
"55153289", "Ibiúna\ \-\ SP",
"55192101", "Campinas\ \-\ SP",
"55613485", "Sobradinho\ \-\ DF",
"55753664", "Taperoá\ \-\ BA",
"55323250", "Juiz\ de\ Fora\ \-\ MG",
"55893522", "Floriano\ \-\ PI",
"55843473", "Cruzeta\ \-\ RN",
"55473300", "Rio\ do\ Sul\ \-\ SC",
"55793268", "General\ Maynard\ \-\ SE",
"55323286", "Santo\ Antônio\ do\ Aventureiro\ \-\ MG",
"55553271", "Júlio\ de\ Castilhos\ \-\ RS",
"55194003", "Campinas\ \-\ SP",
"55613434", "Recanto\ das\ Emas\ \-\ DF",
"55993641", "Coroatá\ \-\ MA",
"55213540", "Nova\ Iguaçu\ \-\ RJ",
"55333312", "Mutum\ \-\ MG",
"55423636", "Cantagalo\ \-\ PR",
"55143297", "Bairro\ de\ Santa\ Izabel\ \-\ SP",
"55693424", "Ji\-Paraná\ \-\ RO",
"55933543", "Rurópolis\ \-\ PA",
"55313045", "Belo\ Horizonte\ \-\ MG",
"55853004", "Fortaleza\ \-\ CE",
"55843241", "Canguaretama\ \-\ RN",
"55673902", "Dourados\ \-\ MS",
"55513031", "Canoas\ \-\ RS",
"55513902", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55114456", "Salto\ \-\ SP",
"55883578", "Umari\ \-\ CE",
"55613388", "Planaltina\ \-\ DF",
"55913442", "Santa\ Maria\ do\ Pará\ \-\ PA",
"55993317", "Timon\ \-\ MA",
"55633491", "Luzinópolis\ \-\ TO",
"55663415", "Ribeirãozinho\ \-\ MT",
"5511452", "Jundiaí\ \-\ SP",
"55343264", "Gurinhatã\ \-\ MG",
"55113178", "São\ Paulo\ \-\ SP",
"5577342", "Vitória\ da\ Conquista\ \-\ BA",
"55713641", "Catu\ \-\ BA",
"55733604", "Batinga\ \-\ BA",
"55353066", "Poços\ de\ Caldas\ \-\ MG",
"55114738", "Mogi\ das\ Cruzes\ \-\ SP",
"55143287", "Avaí\ \-\ SP",
"55822123", "Maceió\ \-\ AL",
"55713369", "Lauro\ de\ Freitas\ \-\ BA",
"5512390", "São\ José\ dos\ Campos\ \-\ SP",
"55133848", "Iguape\ \-\ SP",
"55513255", "Rio\ Grande\ do\ Sul",
"55673255", "Bonito\ \-\ MS",
"55323296", "Arantina\ \-\ MG",
"55473531", "Rio\ do\ Sul\ \-\ SC",
"55823025", "Maceió\ \-\ AL",
"55353532", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"55483531", "Morro\ Grande\ \-\ SC",
"55433717", "Londrina\ \-\ PR",
"55833449", "Riacho\ dos\ Cavalos\ \-\ PB",
"55193778", "Campinas\ \-\ SP",
"55793442", "Malhador\ \-\ SE",
"55984002", "São\ Luís\ \-\ MA",
"55943369", "Parauapebas\ \-\ PA",
"55112836", "São\ Paulo\ \-\ SP",
"55173284", "Ribeiro\ dos\ Santos\ \-\ SP",
"55183284", "Rosana\ \-\ SP",
"5561331", "Brasília\ \-\ DF",
"55353214", "Varginha\ \-\ MG",
"55313240", "Perpétuo\ Socorro\ \-\ MG",
"55513698", "Capela\ de\ Santana\ \-\ RS",
"55773617", "Baianópolis\ \-\ BA",
"55843522", "Pendências\ \-\ RN",
"55893473", "Massapê\ do\ Piauí\ \-\ PI",
"55654003", "Cuiabá\ \-\ MT",
"55423519", "União\ da\ Vitória\ \-\ PR",
"55533035", "Rio\ Grande\ \-\ RS",
"55192146", "Capivari\ \-\ SP",
"55543459", "Bento\ Gonçalves\ \-\ RS",
"55223835", "Carabuçu\ \-\ RJ",
"55623538", "Goiânia\ \-\ GO",
"55513427", "Canoas\ \-\ RS",
"55493665", "Iraceminha\ \-\ SC",
"55183722", "Andradina\ \-\ SP",
"55793455", "São\ Domingos\ \-\ SE",
"55313775", "Sete\ Lagoas\ \-\ MG",
"55114599", "Jundiaí\ \-\ SP",
"55223021", "Araruama\ \-\ RJ",
"55353334", "Carmo\ de\ Minas\ \-\ MG",
"55473459", "São\ Francisco\ do\ Sul\ \-\ SC",
"55923223", "Manaus\ \-\ AM",
"55383228", "Coração\ de\ Jesus\ \-\ MG",
"55373228", "Nova\ Serrana\ \-\ MG",
"55753494", "Canudos\ \-\ BA",
"55773489", "Cocos\ \-\ BA",
"55222543", "Nova\ Friburgo\ \-\ RJ",
"55673242", "Miranda\ \-\ MS",
"55553551", "Tenente\ Portela\ \-\ RS",
"55683242", "Rio\ Branco\ \-\ AC",
"55424009", "Ponta\ Grossa\ \-\ PR",
"55653513", "Lucas\ do\ Rio\ Verde\ \-\ MT",
"55213433", "Rio\ de\ Janeiro\ \-\ RJ",
"55543531", "Paim\ Filho\ \-\ RS",
"55493434", "Vargeão\ \-\ SC",
"55843376", "Viçosa\ \-\ RN",
"55733043", "Itabuna\ \-\ BA",
"55113402", "Atibaia\ \-\ SP",
"55343841", "Coromandel\ \-\ MG",
"55883695", "Sobral\ \-\ CE",
"55212303", "Rio\ de\ Janeiro\ \-\ RJ",
"55813751", "Frei\ Miguelinho\ \-\ PE",
"55213742", "Nova\ Iguaçu\ \-\ RJ",
"55313721", "Conselheiro\ Lafaiete\ \-\ MG",
"55623626", "Goiânia\ \-\ GO",
"55793227", "Aracaju\ \-\ SE",
"55833381", "Montadas\ \-\ PB",
"55212670", "Japeri\ \-\ RJ",
"55143646", "Mineiros\ do\ Tietê\ \-\ SP",
"55373343", "Camacho\ \-\ MG",
"55823535", "Olho\ d\'Água\ Grande\ \-\ AL",
"55353022", "Pouso\ Alegre\ \-\ MG",
"55623482", "Nova\ Roma\ \-\ GO",
"55473021", "Balneário\ Camboriú\ \-\ SC",
"55343354", "Santa\ Juliana\ \-\ MG",
"55193601", "Americana\ \-\ SP",
"55433158", "Ibiporã\ \-\ PR",
"55883685", "Ipueiras\ \-\ CE",
"55333232", "Sobrália\ \-\ MG",
"55433474", "Grandes\ Rios\ \-\ PR",
"55193646", "São\ Sebastião\ da\ Grama\ \-\ SP",
"55643563", "Jandaia\ \-\ GO",
"55323311", "Juiz\ de\ Fora\ \-\ MG",
"55115105", "São\ Paulo\ \-\ SP",
"55753435", "Cipó\ \-\ BA",
"55813915", "Aripibu\ \-\ PE",
"55193513", "Limeira\ \-\ SP",
"55283528", "Vargem\ Alta\ \-\ ES",
"55143601", "Jaú\ \-\ SP",
"55843637", "Bento\ Fernandes\ \-\ RN",
"55673521", "Três\ Lagoas\ \-\ MS",
"55533310", "Pelotas\ \-\ RS",
"55833391", "Boqueirão\ \-\ PB",
"55553301", "Santa\ Maria\ \-\ RS",
"55153373", "Itapetininga\ \-\ SP",
"55473270", "Jaraguá\ do\ Sul\ \-\ SC",
"55133347", "Guarujá\ \-\ SP",
"5515322", "Sorocaba\ \-\ SP",
"55863315", "Parnaíba\ \-\ PI",
"55183995", "Indiana\ \-\ SP",
"55893566", "Redenção\ do\ Gurguéia\ \-\ PI",
"55163258", "Fernando\ Prestes\ \-\ SP",
"55153563", "Guapiara\ \-\ SP",
"5592", "Amazonas",
"55753338", "Mucugê\ \-\ BA",
"55513468", "Rio\ Grande\ do\ Sul",
"55333725", "Salto\ da\ Divisa\ \-\ MG",
"55193937", "Jaguariúna\ \-\ SP",
"55673468", "Vicentina\ \-\ MS",
"55983182", "São\ Luís\ \-\ MA",
"55333514", "Malacacheta\ \-\ MG",
"55883634", "Ubajara\ \-\ CE",
"55983658", "Alto\ Alegre\ do\ Pindaré\ \-\ MA",
"5545357", "Foz\ do\ Iguaçu\ \-\ PR",
"55483437", "Criciúma\ \-\ SC",
"55513575", "São\ Leopoldo\ \-\ RS",
"55513716", "Arroio\ do\ Meio\ \-\ RS",
"55823623", "Olho\ d\'Água\ das\ Flores\ \-\ AL",
"55773499", "Sussuarana\ \-\ BA",
"55543526", "Três\ Arroios\ \-\ RS",
"55123159", "Lorena\ \-\ SP",
"55413672", "Quatro\ Barras\ \-\ PR",
"55813687", "Bonito\ \-\ PE",
"55843438", "Tenente\ Laurentino\ Cruz\ \-\ RN",
"55133879", "Barra\ do\ Braço\ \-\ SP",
"55833565", "João\ Pessoa\ \-\ PB",
"55212763", "Nova\ Iguaçu\ \-\ RJ",
"55493257", "Frei\ Rogério\ \-\ SC",
"55613367", "Brasília\ \-\ DF",
"55313736", "Desterro\ de\ Entre\ Rios\ \-\ MG",
"55353561", "Carmo\ do\ Rio\ Claro\ \-\ MG",
"55473562", "Taió\ \-\ SC",
"55243065", "Petrópolis\ \-\ RJ",
"55753203", "Jeremoabo\ \-\ BA",
"55623631", "Jataí\ \-\ GO",
"55794003", "Aracaju\ \-\ SE",
"55943013", "Parauapebas\ \-\ PA",
"55483081", "Criciúma\ \-\ SC",
"55193749", "Campinas\ \-\ SP",
"55843384", "Pilões\ \-\ RN",
"55473081", "Balneário\ Camboriú\ \-\ SC",
"55173012", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55353865", "Cana\ Verde\ \-\ MG",
"55534062", "Pelotas\ \-\ RS",
"55333351", "Raul\ Soares\ \-\ MG",
"55643664", "Doverlândia\ \-\ GO",
"55353325", "Andrelândia\ \-\ MG",
"55493328", "Chapecó\ \-\ SC",
"55833321", "Campina\ Grande\ \-\ PB",
"55114604", "Mairiporã\ \-\ SP",
"55813510", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55513591", "São\ Leopoldo\ \-\ RS",
"55853355", "São\ Luís\ do\ Curu\ \-\ CE",
"55193857", "Engenheiro\ Coelho\ \-\ SP",
"55673591", "Santa\ Rita\ do\ Pardo\ \-\ MS",
"55323345", "Alto\ Rio\ Doce\ \-\ MG",
"55323554", "Ervália\ \-\ MG",
"55753289", "Pedro\ Alexandre\ \-\ BA",
"55373288", "Araújos\ \-\ MG",
"55493243", "Correia\ Pinto\ \-\ SC",
"55113133", "São\ Paulo\ \-\ SP",
"55843335", "Ipanguaçu\ \-\ RN",
"55823524", "Feira\ Grande\ \-\ AL",
"55543364", "Ronda\ Alta\ \-\ RS",
"55223081", "Macaé\ \-\ RJ",
"55193123", "Campinas\ \-\ SP",
"55883533", "Campos\ Sales\ \-\ CE",
"55513619", "Rio\ Grande\ do\ Sul",
"55513744", "Ibarama\ \-\ RS",
"55353697", "Poços\ de\ Caldas\ \-\ MG",
"55193843", "Itapira\ \-\ SP",
"55833375", "Pedra\ Lavrada\ \-\ PB",
"55163397", "Araraquara\ \-\ SP",
"55242228", "Secretário\ \-\ RJ",
"55473372", "Jaraguá\ do\ Sul\ \-\ SC",
"55453259", "São\ José\ das\ Palmeiras\ \-\ PR",
"55483372", "São\ José\ \-\ SC",
"55353371", "Passa\ Quatro\ \-\ MG",
"55115704", "Itupeva\ \-\ SP",
"55613577", "Brasília\ \-\ DF",
"55623088", "Goiânia\ \-\ GO",
"55513111", "Cachoeirinha\ \-\ RS",
"55143733", "Avaré\ \-\ SP",
"55493425", "Concórdia\ \-\ SC",
"55983271", "São\ Luís\ \-\ MA",
"55513667", "Três\ Cachoeiras\ \-\ RS",
"55883671", "Tianguá\ \-\ CE",
"55114529", "Jacaré\ \-\ SP",
"55453237", "Lindoeste\ \-\ PR",
"55813561", "Ipojuca\ \-\ PE",
"55222644", "Cabo\ Frio\ \-\ RJ",
"55443425", "Loanda\ \-\ PR",
"55963217", "Macapá\ \-\ AP",
"55443243", "São\ Jorge\ do\ Ivaí\ \-\ PR",
"55753424", "Muritiba\ \-\ BA",
"55343511", "Patrocínio\ \-\ MG",
"55623098", "Anápolis\ \-\ GO",
"55114645", "Itaquaquecetuba\ \-\ SP",
"55313544", "Betim\ \-\ MG",
"55633527", "Santa\ Tereza\ do\ Tocantins\ \-\ TO",
"55623363", "Porangatu\ \-\ GO",
"55663399", "Campo\ Verde\ \-\ MT",
"55222767", "Cambuci\ \-\ RJ",
"55483254", "Garopaba\ \-\ SC",
"55733263", "Teixeira\ de\ Freitas\ \-\ BA",
"55183341", "Cândido\ Mota\ \-\ SP",
"55114773", "Itapevi\ \-\ SP",
"55663553", "Juruena\ \-\ MT",
"55163387", "Nova\ Europa\ \-\ SP",
"55173341", "Colina\ \-\ SP",
"55653268", "Vale\ de\ São\ Domingos\ \-\ MT",
"55623573", "Goiânia\ \-\ GO",
"55173556", "Irapuã\ \-\ SP",
"55183556", "Inúbia\ Paulista\ \-\ SP",
"55433622", "Jaboti\ \-\ PR",
"55513705", "Marques\ de\ Souza\ \-\ RS",
"55883625", "Chaval\ \-\ CE",
"55914003", "Belém\ \-\ PA",
"55193839", "Amparo\ \-\ SP",
"55883549", "Tarrafas\ \-\ CE",
"55553314", "Santo\ Ângelo\ \-\ RS",
"55333734", "Itaobim\ \-\ MG",
"55663547", "Tapurah\ \-\ MT",
"55313846", "Coronel\ Fabriciano\ \-\ MG",
"55513581", "Novo\ Hamburgo\ \-\ RS",
"55693218", "Porto\ Velho\ \-\ RO",
"55793297", "Siriri\ \-\ SE",
"55323262", "Rochedo\ de\ Minas\ \-\ MG",
"55893438", "São\ Julião\ \-\ PI",
"55913287", "Ananindeua\ \-\ PA",
"55513536", "Conceição\ \-\ RS",
"55843394", "Frutuoso\ Gomes\ \-\ RN",
"55443257", "Flórida\ \-\ PR",
"55143268", "Macatuba\ \-\ SP",
"55483091", "Florianópolis\ \-\ SC",
"55533613", "Pedras\ Altas\ \-\ RS",
"55653625", "Cuiabá\ \-\ MT",
"55343824", "Lagoa\ Formosa\ \-\ MG",
"55114573", "Cotia\ \-\ SP",
"55873843", "Tacaratu\ \-\ PE",
"55193387", "Campinas\ \-\ SP",
"55823292", "Porto\ Calvo\ \-\ AL",
"55114696", "Salesópolis\ \-\ SP",
"55213236", "Nilópolis\ \-\ RJ",
"55222519", "Nova\ Friburgo\ \-\ RJ",
"55493642", "Guarujá\ do\ Sul\ \-\ SC",
"55323331", "Barbacena\ \-\ MG",
"55313667", "Coronel\ Fabriciano\ \-\ MG",
"55813761", "Garanhuns\ \-\ PE",
"55473044", "Brusque\ \-\ SC",
"5524223", "Petrópolis\ \-\ RJ",
"55243352", "Itatiaia\ \-\ RJ",
"55313111", "São\ Joaquim\ de\ Bicas\ \-\ MG",
"55653549", "Lucas\ do\ Rio\ Verde\ \-\ MT",
"55813314", "Recife\ \-\ PE",
"55333212", "Governador\ Valadares\ \-\ MG",
"55923682", "Manaus\ \-\ AM",
"55314115", "Lagoa\ Santa\ \-\ MG",
"55513736", "Estrêla\ \-\ RS",
"55623529", "Brazabrantes\ \-\ GO",
"55114143", "Itapevi\ \-\ SP",
"55313895", "Teixeiras\ \-\ MG",
"55873857", "Flores\ \-\ PE",
"55513781", "Rio\ Grande\ do\ Sul",
"55333534", "Padre\ Paraíso\ \-\ MG",
"55883614", "Sobral\ \-\ CE",
"55933528", "Novo\ Progresso\ \-\ PA",
"55653397", "Diamantino\ \-\ MT",
"55312128", "Belo\ Horizonte\ \-\ MG",
"55114098", "Salto\ \-\ SP",
"55193917", "Ribeirão\ Preto\ \-\ SP",
"5543", "Paraná",
"55793465", "São\ Miguel\ do\ Aleixo\ \-\ SE",
"55483469", "Treviso\ \-\ SC",
"55753602", "Feira\ de\ Santana\ \-\ BA",
"55623645", "Goiânia\ \-\ GO",
"55163839", "Ituverava\ \-\ SP",
"55883442", "Madalena\ \-\ CE",
"55163749", "Ribeirão\ Corrente\ \-\ SP",
"55733538", "Itiruçu\ \-\ BA",
"55112312", "Mogi\ das\ Cruzes\ \-\ SP",
"55193549", "Mogi\ Mirim\ \-\ SP",
"55123527", "Pindamonhangaba\ \-\ SP",
"55313885", "Viçosa\ \-\ MG",
"55472103", "Itajaí\ \-\ SC",
"55195657", "São\ Paulo\ \-\ SP",
"55643547", "Indiara\ \-\ GO",
"55853111", "Fortaleza\ \-\ CE",
"55513458", "Esteio\ \-\ RS",
"55313536", "Florestal\ \-\ MG",
"55193625", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55853667", "Itarema\ \-\ CE",
"55983214", "São\ Luís\ \-\ MA",
"55873839", "Alagoinha\ \-\ PE",
"55433223", "Cambé\ \-\ PR",
"5543337", "Londrina\ \-\ PR",
"55653387", "Campos\ de\ Júlio\ \-\ MT",
"55273277", "Timbuí\ \-\ ES",
"55313581", "Nova\ Lima\ \-\ MG",
"55153553", "Ribeirão\ Branco\ \-\ SP",
"55423277", "Ortigueira\ \-\ PR",
"55114686", "São\ Lourenço\ da\ Serra\ \-\ SP",
"55823282", "Paulo\ Jacinto\ \-\ AL",
"55613298", "Brasília\ \-\ DF",
"55443642", "Guaíra\ \-\ PR",
"55833316", "Riachão\ do\ Bacamarte\ \-\ PB",
"55484001", "Florianópolis\ \-\ SC",
"55893580", "Dom\ Inocêncio\ \-\ PI",
"55474001", "Joinville\ \-\ SC",
"55143533", "Lins\ \-\ SP",
"55733662", "Jucuruçu\ \-\ BA",
"55173335", "Colômbia\ \-\ SP",
"55153547", "Guapiara\ \-\ SP",
"55463243", "Mangueirinha\ \-\ PR",
"55513544", "Taquara\ \-\ RS",
"55222103", "Nova\ Friburgo\ \-\ RJ",
"55773473", "Macaúbas\ \-\ BA",
"55543511", "Vacaria\ \-\ RS",
"55193671", "Casa\ Branca\ \-\ SP",
"55323754", "São\ Francisco\ do\ Glória\ \-\ MG",
"55313834", "Itabira\ \-\ MG",
"55143387", "Sarutaiá\ \-\ SP",
"55333746", "Rubim\ \-\ MG",
"55513721", "Triunfo\ \-\ RS",
"55144103", "Jaú\ \-\ SP",
"55642102", "Jataí\ \-\ GO",
"55853468", "Fortaleza\ \-\ CE",
"55513657", "Vendinha\ \-\ RS",
"55632112", "Araguaína\ \-\ TO",
"55823541", "Junqueiro\ \-\ AL",
"55623589", "Goiânia\ \-\ GO",
"55212664", "Japeri\ \-\ RJ",
"55353346", "Cruzília\ \-\ MG",
"55453269", "Vila\ Nova\ \-\ PR",
"55193695", "Mococa\ \-\ SP",
"55543354", "Esmeralda\ \-\ RS",
"55273728", "Vila\ Valério\ \-\ ES",
"55193713", "Limeira\ \-\ SP",
"55343835", "Cruzeiro\ da\ Fortaleza\ \-\ MG",
"55114703", "Cotia\ \-\ SP",
"55212747", "Tanguá\ \-\ RJ",
"55173637", "Guzolândia\ \-\ SP",
"55163513", "Sertãozinho\ \-\ SP",
"55183637", "Araçatuba\ \-\ SP",
"55353855", "Coqueiral\ \-\ MG",
"55643654", "Cachoeira\ Alta\ \-\ GO",
"55152102", "Sorocaba\ \-\ SP",
"55534052", "Pelotas\ \-\ RS",
"55323374", "Rio\ das\ Mortes\ \-\ MG",
"55853365", "Canindé\ \-\ CE",
"55443401", "Cianorte\ \-\ PR",
"55272144", "Vila\ Velha\ \-\ ES",
"55193867", "Jaguariúna\ \-\ SP",
"55623503", "Abadia\ de\ Goiás\ \-\ GO",
"55553334", "Augusto\ Pestana\ \-\ RS",
"55123117", "São\ José\ do\ Barreiro\ \-\ SP",
"55513775", "Pouso\ Novo\ \-\ RS",
"55493446", "Lindóia\ do\ Sul\ \-\ SC",
"55693238", "Buritis\ \-\ RO",
"55213221", "Rio\ de\ Janeiro\ \-\ RJ",
"55114492", "Jundiaí\ \-\ SP",
"55353551", "Guaxupé\ \-\ MG",
"55113583", "São\ Paulo\ \-\ SP",
"55613357", "Samambaia\ Sul\ \-\ DF",
"55333525", "Poté\ \-\ MG",
"55212753", "São\ João\ de\ Meriti\ \-\ RJ",
"55193819", "Hortolândia\ \-\ SP",
"55313242", "Minas\ Gerais",
"55114789", "Jandira\ \-\ SP",
"55553751", "Dois\ Irmãos\ das\ MissõEs\ \-\ RS",
"55653695", "Várzea\ Grande\ \-\ MT",
"55613339", "Brasília\ \-\ DF",
"55733247", "Almadina\ \-\ BA",
"55623347", "Campinorte\ \-\ GO",
"55323252", "Santos\ Dumont\ \-\ MG",
"55313871", "Rio\ Casca\ \-\ MG",
"55693654", "São\ Domingos\ \-\ RO",
"55313716", "Inhaúma\ \-\ MG",
"55623611", "Aparecida\ de\ Goiânia\ \-\ GO",
"55443219", "Maringá\ \-\ PR",
"55513052", "Canoas\ \-\ RS",
"55173566", "Embaúba\ \-\ SP",
"55313575", "Moeda\ \-\ MG",
"55114482", "Mairiporã\ \-\ SP",
"55113359", "São\ Paulo\ \-\ SP",
"55443446", "Paranavaí\ \-\ PR",
"55183376", "Cruzália\ \-\ SP",
"55473264", "Balneário\ Camboriú\ \-\ SC",
"55483264", "Canelinha\ \-\ SC",
"55222757", "Macaé\ \-\ RJ",
"55623353", "Goianésia\ \-\ GO",
"55222621", "São\ Pedro\ da\ Aldeia\ \-\ RJ",
"55663563", "Paranaíta\ \-\ MT",
"55143713", "Paranapanema\ \-\ SP",
"55434007", "Londrina\ \-\ PR",
"55933598", "Jamanchizinho\ \-\ PA",
"55163601", "Ribeirão\ Preto\ \-\ SP",
"55183659", "Bilac\ \-\ SP",
"55353301", "Poços\ de\ Caldas\ \-\ MG",
"55813551", "Ipojuca\ \-\ PE",
"55183324", "Assis\ \-\ SP",
"55123979", "Monteiro\ Lobato\ \-\ SP",
"55273138", "Serra\ \-\ ES",
"55883513", "Crato\ \-\ CE",
"55513639", "São\ Vendelino\ \-\ RS",
"55553730", "Vista\ Alegre\ \-\ RS",
"55313521", "Ibirité\ \-\ MG",
"55653327", "Progresso\ \-\ MT",
"55114028", "Salto\ \-\ SP",
"55114893", "Campo\ Limpo\ Paulista\ \-\ SP",
"55753441", "Aporá\ \-\ BA",
"55883646", "Cariré\ \-\ CE",
"55223016", "Nova\ Friburgo\ \-\ RJ",
"55543272", "Guabiju\ \-\ RS",
"55113113", "São\ Paulo\ \-\ SP",
"55853104", "Fortaleza\ \-\ CE",
"55114663", "Embu\-Guaçu\ \-\ SP",
"55623554", "Varjão\ \-\ GO",
"55513288", "Rio\ Grande\ do\ Sul",
"55733245", "Ubatã\ \-\ BA",
"55643603", "Iporá\ \-\ GO",
"55923071", "Manaus\ \-\ AM",
"55933064", "Santarém\ \-\ PA",
"55242104", "Petrópolis\ \-\ RJ",
"55614501", "Brasília\ \-\ DF",
"55183694", "Zacarias\ \-\ SP",
"55483441", "Urussanga\ \-\ SC",
"55173694", "Dirce\ Reis\ \-\ SP",
"55353442", "Bueno\ Brandão\ \-\ MG",
"55833539", "Triunfo\ \-\ PB",
"55383744", "Jequitaí\ \-\ MG",
"55212704", "Niterói\ \-\ RJ",
"55173523", "Catanduva\ \-\ SP",
"55753264", "Riachão\ do\ Jacuípe\ \-\ BA",
"55313577", "Minas\ Gerais",
"55653371", "Nova\ Mutum\ \-\ MT",
"55443011", "Maringá\ \-\ PR",
"55613964", "Brasília\ \-\ DF",
"55143325", "Ourinhos\ \-\ SP",
"55543389", "Fontoura\ Xavier\ \-\ RS",
"55115817", "São\ Paulo\ \-\ SP",
"55823620", "Dois\ Riachos\ \-\ AL",
"55873761", "Garanhuns\ \-\ PE",
"55313153", "Sete\ Lagoas\ \-\ MG",
"55623448", "Flores\ de\ Goiás\ \-\ GO",
"55643560", "São\ João\ da\ Paraúna\ \-\ GO",
"55423236", "Ponta\ Grossa\ \-\ PR",
"55343859", "Patos\ de\ Minas\ \-\ MG",
"55133386", "Guarujá\ \-\ SP",
"55843641", "Natal\ \-\ RN",
"55643689", "Diorama\ \-\ GO",
"55663526", "Porto\ dos\ Gaúchos\ \-\ MT",
"55493342", "Galvão\ \-\ SC",
"55313827", "Minas\ Gerais",
"55123836", "Ubatuba\ \-\ SP",
"55323422", "Cataguases\ \-\ MG",
"55922123", "Manaus\ \-\ AM",
"55185841", "Junqueirópolis\ \-\ SP",
"55343664", "Araxá\ \-\ MG",
"5547332", "Blumenau\ \-\ SC",
"55633351", "Gurupi\ \-\ TO",
"55483273", "Major\ Gercino\ \-\ SC",
"55793214", "Aracaju\ \-\ SE",
"55653325", "Tangará\ da\ Serra\ \-\ MT",
"55833307", "Caraúbas\ \-\ PB",
"55613505", "Luziânia\ \-\ GO",
"55353733", "Ibitiúra\ de\ Minas\ \-\ MG",
"55663574", "Nova\ Guarita\ \-\ MT",
"55733204", "Itaju\ do\ Colônia\ \-\ BA",
"55353843", "Ijaci\ \-\ MG",
"55323573", "Piraúba\ \-\ MG",
"55113438", "Santo\ André\ \-\ SP",
"55643699", "Buriti\ de\ Goiás\ \-\ GO",
"55193371", "Piracicaba\ \-\ SP",
"55163984", "São\ Simão\ \-\ SP",
"55412103", "Curitiba\ \-\ PR",
"55553533", "São\ Martinho\ \-\ RS",
"55513655", "General\ Câmara\ \-\ RS",
"55323696", "Muriaé\ \-\ MG",
"55133500", "Santos\ \-\ SP",
"55553387", "Ajuricaba\ \-\ RS",
"55212673", "Duque\ de\ Caxias\ \-\ RJ",
"55833543", "Aparecida\ \-\ PB",
"55173635", "Aparecida\ D\'Oeste\ \-\ SP",
"55843606", "Natal\ \-\ RN",
"55113384", "São\ Paulo\ \-\ SP",
"55153511", "Itapetininga\ \-\ SP",
"55983465", "Nina\ Rodrigues\ \-\ MA",
"55743668", "João\ Dourado\ \-\ BA",
"55123891", "São\ Sebastião\ \-\ SP",
"55613458", "Samambaia\ Sul\ \-\ DF",
"55323729", "Muriaé\ \-\ MG",
"55443342", "Paranapoema\ \-\ PR",
"55843133", "Natal\ \-\ RN",
"55513777", "Putinga\ \-\ RS",
"55173472", "Nhandeara\ \-\ SP",
"55123115", "Arapeí\ \-\ SP",
"55433046", "Arapongas\ \-\ PR",
"55114916", "São\ Paulo\ \-\ SP",
"55993522", "Tuntum\ \-\ MA",
"55193865", "Hortolândia\ \-\ SP",
"55193325", "Campinas\ \-\ SP",
"55414001", "Curitiba\ \-\ PR",
"55353857", "Campo\ do\ Meio\ \-\ MG",
"55383834", "Nova\ Porteirinha\ \-\ MG",
"55222540", "Nova\ Friburgo\ \-\ RJ",
"55473406", "Balneário\ Camboriú\ \-\ SC",
"55713473", "Salvador\ \-\ BA",
"55163761", "Batatais\ \-\ SP",
"55983368", "Primeira\ Cruz\ \-\ MA",
"55623921", "Goiânia\ \-\ GO",
"55323363", "Lagoa\ Dourada\ \-\ MG",
"55112612", "São\ Paulo\ \-\ SP",
"55853319", "Chorozinho\ \-\ CE",
"55813733", "Taquaritinga\ do\ Norte\ \-\ PE",
"55613355", "Taguatinga\ \-\ DF",
"55333527", "Ouro\ Verde\ de\ Minas\ \-\ MG",
"55743532", "Pilar\ \-\ BA",
"55193561", "Pirassununga\ \-\ SP",
"55624012", "Goiânia\ \-\ GO",
"55423221", "Telêmaco\ Borba\ \-\ PR",
"55643629", "Montividiu\ \-\ GO",
"55663586", "Cocalinho\ \-\ MT",
"55313887", "Acaiaca\ \-\ MG",
"55123141", "Cruzeiro\ \-\ SP",
"55542102", "Bento\ Gonçalves\ \-\ RS",
"55793712", "Aracaju\ \-\ SE",
"55193498", "Nova\ Odessa\ \-\ SP",
"55663531", "Sinop\ \-\ MT",
"55833644", "Tenório\ \-\ PB",
"55143488", "Quintana\ \-\ SP",
"55273275", "Aracruz\ \-\ ES",
"55113637", "São\ Paulo\ \-\ SP",
"55433266", "Nova\ Santa\ Bárbara\ \-\ PR",
"55683343", "Mâncio\ Lima\ \-\ AC",
"55913467", "Ourém\ \-\ PA",
"55643545", "Itumbiara\ \-\ GO",
"55993592", "Açailândia\ \-\ MA",
"55773464", "Mortugaba\ \-\ BA",
"55433453", "Kaloré\ \-\ PR",
"55163346", "Boa\ Esperança\ do\ Sul\ \-\ SP",
"55854117", "Maracanaú\ \-\ CE",
"55634052", "Palmas\ \-\ TO",
"55423275", "Tibagi\ \-\ PR",
"55143385", "Tejupá\ \-\ SP",
"55543329", "Carazinho\ \-\ RS",
"5519341", "Piracicaba\ \-\ SP",
"55213099", "Teresópolis\ \-\ RJ",
"55453241", "Cafelândia\ \-\ PR",
"55373242", "Itaúna\ \-\ MG",
"55183583", "Rinópolis\ \-\ SP",
"55143022", "Avaré\ \-\ SP",
"55413552", "Araucária\ \-\ PR",
"55473318", "Gaspar\ \-\ SC",
"55453206", "Agro\ Cafeeira\ \-\ PR",
"55193385", "Campinas\ \-\ SP",
"55423542", "Mallet\ \-\ PR",
"55374141", "Divinópolis\ \-\ MG",
"55123633", "Taubaté\ \-\ SP",
"55384141", "Montes\ Claros\ \-\ MG",
"55193022", "Mogi\ Mirim\ \-\ SP",
"55883530", "Araripe\ \-\ CE",
"55333333", "Realeza\ \-\ MG",
"55173624", "Jales\ \-\ SP",
"55753469", "Cícero\ Dantas\ \-\ BA",
"55222565", "Bom\ Jardim\ \-\ RJ",
"55993582", "Imperatriz\ \-\ MA",
"55183624", "Araçatuba\ \-\ SP",
"55163301", "Araraquara\ \-\ SP",
"55623981", "Aparecida\ de\ Goiânia\ \-\ GO",
"55173359", "Colômbia\ \-\ SP",
"55543238", "Caxias\ do\ Sul\ \-\ RS",
"55153272", "Itapetininga\ \-\ SP",
"55643504", "Americano\ do\ Brasil\ \-\ GO",
"55213089", "Rio\ de\ Janeiro\ \-\ RJ",
"55313665", "Pedro\ Leopoldo\ \-\ MG",
"55113659", "Osasco\ \-\ SP",
"55193488", "Mombuca\ \-\ SP",
"55114374", "Carapicuíba\ \-\ SP",
"55633232", "Palmas\ \-\ TO",
"55212760", "Rio\ das\ Ostras\ \-\ RJ",
"55873855", "Buíque\ \-\ PE",
"55553258", "Nova\ Esperança\ do\ Sul\ \-\ RS",
"55663596", "Paranorte\ \-\ MT",
"55313897", "São\ Miguel\ do\ Anta\ \-\ MG",
"55733211", "Itabuna\ \-\ BA",
"55913712", "Castanhal\ \-\ PA",
"55463902", "Pato\ Branco\ \-\ PR",
"55383825", "Montezuma\ \-\ MG",
"55113376", "São\ Paulo\ \-\ SP",
"55813646", "Tracunhaém\ \-\ PE",
"55124242", "Cotia\ \-\ SP",
"55113151", "São\ Paulo\ \-\ SP",
"55123106", "Silveiras\ \-\ SP",
"55213138", "Rio\ de\ Janeiro\ \-\ RJ",
"55613639", "Planaltina\ \-\ GO",
"55383521", "Itamarandiba\ \-\ MG",
"55553327", "Salto\ do\ Jacuí\ \-\ RS",
"55373521", "Bom\ Despacho\ \-\ MG",
"55443045", "Paranavaí\ \-\ PR",
"55163976", "Ribeirão\ Preto\ \-\ SP",
"55283542", "Castelo\ \-\ ES",
"55124104", "Taubaté\ \-\ SP",
"55443427", "Porto\ Rico\ \-\ PR",
"55623374", "Itapirapuã\ \-\ GO",
"55193301", "Piracicaba\ \-\ SP",
"55633361", "Paraíso\ do\ Tocantins\ \-\ TO",
"55833636", "Frei\ Martinho\ \-\ PB",
"55343654", "Santa\ Rosa\ da\ Serra\ \-\ MG",
"55354103", "Passos\ \-\ MG",
"55673929", "Três\ Lagoas\ \-\ MS",
"55733274", "Vera\ Cruz\ \-\ BA",
"55143346", "Bernardino\ de\ Campos\ \-\ SP",
"55453235", "Três\ Barras\ do\ Paraná\ \-\ PR",
"55123184", "Cruzeiro\ \-\ SP",
"55153531", "Itararé\ \-\ SP",
"55343817", "Coromandel\ \-\ MG",
"55553513", "Santa\ Rosa\ \-\ RS",
"55623326", "Jaraguá\ \-\ GO",
"55163385", "Tabatinga\ \-\ SP",
"55213207", "Rio\ de\ Janeiro\ \-\ RJ",
"55222765", "Macaé\ \-\ RJ",
"55313357", "Contagem\ \-\ MG",
"55113418", "Taboão\ da\ Serra\ \-\ SP",
"55843359", "Água\ Nova\ \-\ RN",
"55773470", "Rio\ do\ Antônio\ \-\ BA",
"55342102", "Uberlândia\ \-\ MG",
"55883627", "Martinópole\ \-\ CE",
"55383721", "Curvelo\ \-\ MG",
"55853339", "Palmácia\ \-\ CE",
"5511349", "São\ Paulo\ \-\ SP",
"55513707", "Lajeado\ \-\ RS",
"55212136", "Rio\ de\ Janeiro\ \-\ RJ",
"55183402", "Assis\ \-\ SP",
"55273742", "São\ Domingos\ do\ Norte\ \-\ ES",
"55473424", "Pirabeiraba\ \-\ SC",
"55643586", "Itumbiara\ \-\ GO",
"55653346", "Nortelândia\ \-\ MT",
"55383814", "Mamonas\ \-\ MG",
"55753254", "Ipirá\ \-\ BA",
"55643531", "Itumbiara\ \-\ GO",
"55443255", "Maringá\ \-\ PR",
"55112378", "Mogi\ das\ Cruzes\ \-\ SP",
"55163488", "São\ Simão\ \-\ SP",
"55483476", "Nova\ Veneza\ \-\ SC",
"55114653", "Arujá\ \-\ SP",
"55212689", "Porto\ Belo\ \-\ RJ",
"55633571", "Palmas\ \-\ TO",
"55663545", "Sorriso\ \-\ MT",
"55453284", "Marechal\ Cândido\ Rondon\ \-\ PR",
"55193924", "Águas\ de\ Lindóia\ \-\ SP",
"55213528", "Rio\ de\ Janeiro\ \-\ RJ",
"55453030", "Foz\ do\ Iguaçu\ \-\ PR",
"55323353", "Dores\ de\ Campos\ \-\ MG",
"55173889", "Altair\ \-\ SP",
"55613365", "Brasília\ \-\ DF",
"55833567", "Cabedelo\ \-\ PB",
"55193551", "Araras\ \-\ SP",
"55242458", "Rio\ das\ Flores\ \-\ RJ",
"5511348", "São\ Paulo\ \-\ SP",
"55813685", "Quipapá\ \-\ PE",
"55983358", "Penalva\ \-\ MA",
"55163751", "Buritizal\ \-\ SP",
"55443902", "Paranavaí\ \-\ PR",
"55193855", "Socorro\ \-\ SP",
"55313507", "Belo\ Horizonte\ \-\ MG",
"55653301", "Chapada\ dos\ Guimarães\ \-\ MT",
"551129", "São\ Paulo\ \-\ SP",
"55853357", "General\ Sampaio\ \-\ CE",
"55353327", "Carrancas\ \-\ MG",
"55613521", "Brasília\ \-\ DF",
"55753638", "Governador\ Mangabeira\ \-\ BA",
"55212774", "São\ João\ de\ Meriti\ \-\ RJ",
"55353867", "Ribeirão\ Vermelho\ \-\ MG",
"55114820", "Rio\ Grande\ da\ Serra\ \-\ SP",
"55353695", "São\ Lourenço\ \-\ MG",
"55613468", "Brasília\ \-\ DF",
"55353713", "Poços\ de\ Caldas\ \-\ MG",
"55313339", "Belo\ Horizonte\ \-\ MG",
"55273064", "Serra\ \-\ ES",
"55614141", "Brasília\ \-\ DF",
"55843337", "Caraúbas\ \-\ RN",
"55873840", "Inajá\ \-\ PE",
"55323347", "Ibertioga\ \-\ MG",
"55743658", "Canarana\ \-\ BA",
"55983455", "Matões\ do\ Norte\ \-\ MA",
"5554322", "Caxias\ do\ Sul\ \-\ RS",
"55513665", "Capão\ da\ Canoa\ \-\ RS",
"55543373", "São\ Valentim\ \-\ RS",
"55673665", "Água\ Clara\ \-\ MS",
"55663504", "União\ do\ Norte\ \(Antiga\ Lenislândia\)\ \-\ MT",
"55443688", "Xambrê\ \-\ PR",
"55713276", "Salvador\ \-\ BA",
"55813634", "Surubim\ \-\ PE",
"55913658", "Santa\ Cruz\ do\ Arari\ \-\ PA",
"55853343", "Canindé\ \-\ CE",
"55163395", "Rincão\ \-\ SP",
"55483203", "Florianópolis\ \-\ SC",
"55913182", "Belém\ \-\ PA",
"55833377", "Dona\ Inês\ \-\ PB",
"55913443", "Irituia\ \-\ PA",
"55863369", "Cajueiro\ da\ Praia\ \-\ PI",
"55413562", "Colombo\ \-\ PR",
"55212796", "Mesquita\ \-\ RJ",
"55753437", "Nova\ Soure\ \-\ BA",
"55453276", "Santa\ Helena\ \-\ PR",
"55153364", "Boituva\ \-\ SP",
"55633534", "Mateiros\ \-\ TO",
"55713051", "Lauro\ de\ Freitas\ \-\ BA",
"5513347", "Praia\ Grande\ \-\ SP",
"55643526", "Itumbiara\ \-\ GO",
"55383505", "Unaí\ \-\ MG",
"55883510", "Iguatu\ \-\ CE",
"55613591", "Sobradinho\ \-\ DF",
"55333313", "Inhapim\ \-\ MG",
"55194002", "Campinas\ \-\ SP",
"55153202", "Sorocaba\ \-\ SP",
"55413036", "Almirante\ Tamandaré\ \-\ PR",
"55193984", "Paulínia\ \-\ SP",
"55843635", "Santa\ Maria\ \-\ RN",
"55183606", "Guararapes\ \-\ SP",
"55773454", "Caetité\ \-\ BA",
"55933542", "Jacareacanga\ \-\ PA",
"55433463", "Godoy\ Moreira\ \-\ PR",
"55413081", "São\ José\ dos\ Pinhais\ \-\ PR",
"55333727", "Santa\ Maria\ do\ Salto\ \-\ MG",
"55213118", "Rio\ de\ Janeiro\ \-\ RJ",
"55193935", "Indaiatuba\ \-\ SP",
"55813533", "Gravatá\ \-\ PE",
"55613619", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55312572", "Betim\ \-\ MG",
"55663603", "Aripuanã\ \-\ MT",
"55193761", "Campinas\ \-\ SP",
"55353625", "Marmelópolis\ \-\ MG",
"55893523", "Floriano\ \-\ PI",
"55433256", "Rolândia\ \-\ PR",
"55843472", "Jardim\ do\ Seridó\ \-\ RN",
"55953086", "Boa\ Vista\ \-\ RR",
"55123351", "Jacareí\ \-\ SP",
"55183997", "Taciba\ \-\ SP",
"55153526", "Itapeva\ \-\ SP",
"55133448", "Mongaguá\ \-\ SP",
"55623331", "Pirenópolis\ \-\ GO",
"55913732", "Acará\ \-\ PA",
"55733231", "Ilhéus\ \-\ BA",
"55623386", "Faina\ \-\ GO",
"55133856", "Pariquera\-Açu\ \-\ SP",
"55483435", "Siderópolis\ \-\ SC",
"55733286", "Itapebi\ \-\ BA",
"55843694", "Monte\ das\ Gameleiras\ \-\ RN",
"55863133", "Teresina\ \-\ PI",
"55163941", "Ribeirão\ Preto\ \-\ SP",
"55114448", "Cajamar\ \-\ SP",
"55883561", "Icó\ \-\ CE",
"55753021", "Feira\ de\ Santana\ \-\ BA",
"55183723", "Andradina\ \-\ SP",
"55553614", "Vitória\ das\ Missões\ \-\ RS",
"55793457", "Macambira\ \-\ SE",
"55813671", "Ribeirão\ \-\ PE",
"55873865", "Dormentes\ \-\ PE",
"55553268", "Dona\ Francisca\ \-\ RS",
"55173579", "Botelho\ \-\ SP",
"55793271", "Divina\ Pastora\ \-\ SE",
"55733296", "Medeiros\ Neto\ \-\ BA",
"55443628", "Jussara\ \-\ PR",
"55373544", "Cedro\ do\ Abaeté\ \-\ MG",
"55623396", "Itaguari\ \-\ GO",
"55373355", "Doresópolis\ \-\ MG",
"55663511", "Sinop\ \-\ MT",
"55143761", "Itaí\ \-\ SP",
"55843523", "Alto\ do\ Rodrigues\ \-\ RN",
"55893472", "Francinópolis\ \-\ PI",
"55183641", "Birigui\ \-\ SP",
"55793443", "Campo\ do\ Brito\ \-\ SE",
"55813625", "Goiana\ \-\ PE",
"55173641", "Santa\ Fé\ do\ Sul\ \-\ SP",
"55353533", "Pratápolis\ \-\ MG",
"55173829", "Talhado\ \-\ SP",
"5519343", "Piracicaba\ \-\ SP",
"55113556", "São\ Paulo\ \-\ SP",
"55883428", "Iracema\ \-\ CE",
"55613536", "Brasília\ \-\ DF",
"55823537", "Campo\ Grande\ \-\ AL",
"55222555", "Cantagalo\ \-\ RJ",
"55322152", "Juiz\ de\ Fora\ \-\ MG",
"55123966", "São\ José\ dos\ Campos\ \-\ SP",
"55114165", "Itapecerica\ da\ Serra\ \-\ SP",
"55613581", "Ceilândia\ \-\ DF",
"55693526", "Jaru\ \-\ RO",
"5531321", "Belo\ Horizonte\ \-\ MG",
"55653314", "Cuiabá\ \-\ MT",
"55313729", "Minas\ Gerais",
"55813759", "Santa\ Cruz\ do\ Capibaribe\ \-\ PE",
"55853650", "Carnaubal\ \-\ CE",
"55343849", "Monte\ Carmelo\ \-\ MG",
"55222673", "Araruama\ \-\ RJ",
"55643607", "Itumbiara\ \-\ GO",
"55753275", "Monte\ Santo\ \-\ BA",
"55663904", "Barra\ do\ Garças\ \-\ MT",
"55613262", "Brasília\ \-\ DF",
"55114667", "Itapecerica\ da\ Serra\ \-\ SP",
"55143366", "Bauru\ \-\ SP",
"55383663", "Buritis\ \-\ MG",
"55443274", "Sarandi\ \-\ PR",
"55813127", "Recife\ \-\ PE",
"55483029", "São\ José\ \-\ SC",
"55313573", "Rio\ Manso\ \-\ MG",
"55693316", "Vilhena\ \-\ RO",
"55833389", "Olivedos\ \-\ PB",
"55113595", "São\ Paulo\ \-\ SP",
"55413291", "Campo\ Largo\ \-\ PR",
"55613304", "Guará\ \-\ DF",
"55114619", "Jandira\ \-\ SP",
"55483430", "Criciúma\ \-\ SC",
"55272103", "Linhares\ \-\ ES",
"55873811", "Jirau\ \-\ PE",
"55623355", "Itapuranga\ \-\ GO",
"55163134", "Jeriquara\ \-\ SP",
"55242252", "Três\ Rios\ \-\ RJ",
"55733255", "Camamu\ \-\ BA",
"55663565", "Aripuanã\ \-\ MT",
"55353452", "Careaçu\ \-\ MG",
"55513604", "Rio\ Grande\ do\ Sul",
"55383754", "Três\ Marias\ \-\ MG",
"55114591", "Itupeva\ \-\ SP",
"5511257", "São\ Paulo\ \-\ SP",
"55653366", "Nova\ Mutum\ \-\ MT",
"55353737", "São\ Pedro\ de\ Caldas\ \-\ MG",
"55433512", "Arapoti\ \-\ PR",
"55424001", "Ponta\ Grossa\ \-\ PR",
"55663321", "Rondonópolis\ \-\ MT",
"55773436", "Barra\ do\ Choça\ \-\ BA",
"55483277", "São\ Pedro\ de\ Alcântara\ \-\ SC",
"55883515", "Pedra\ Branca\ \-\ CE",
"55553559", "Braga\ \-\ RS",
"55413054", "Campo\ Largo\ \-\ PR",
"55114895", "Nazaré\ Paulista\ \-\ SP",
"55113115", "São\ Paulo\ \-\ SP",
"55643996", "Itumbiara\ \-\ GO",
"55773481", "Bom\ Jesus\ da\ Lapa\ \-\ BA",
"55273762", "Conceição\ da\ Barra\ \-\ ES",
"55193683", "Santa\ Cruz\ das\ Palmeiras\ \-\ SP",
"55922127", "Manaus\ \-\ AM",
"55663478", "Canarana\ \-\ MT",
"55163724", "Franca\ \-\ SP",
"55373331", "Oliveira\ \-\ MG",
"55433056", "Arapongas\ \-\ PR",
"55212391", "Rio\ de\ Janeiro\ \-\ RJ",
"55453332", "Nova\ Santa\ Rosa\ \-\ PR",
"55553537", "Horizontina\ \-\ RS",
"55412107", "Curitiba\ \-\ PR",
"55163811", "São\ Joaquim\ da\ Barra\ \-\ SP",
"55323577", "Rodeiro\ \-\ MG",
"55983474", "Duque\ Bacelar\ \-\ MA",
"5542362", "Guarapuava\ \-\ PR",
"55963312", "Macapá\ \-\ AP",
"55733086", "Ilhéus\ \-\ BA",
"55773491", "São\ Félix\ do\ Coribe\ \-\ BA",
"55733031", "Itamaraju\ \-\ BA",
"55343833", "Serra\ do\ Salitre\ \-\ MG",
"55193576", "Ipeúna\ \-\ SP",
"55133591", "Praia\ Grande\ \-\ SP",
"55613554", "Brasília\ \-\ DF",
"55114705", "Santana\ de\ Parnaíba\ \-\ SP",
"55463211", "Francisco\ Beltrão\ \-\ PR",
"55643931", "Itumbiara\ \-\ GO",
"55973426", "Japurá\ \-\ AM",
"55163515", "Ribeirão\ Preto\ \-\ SP",
"5521386", "Rio\ de\ Janeiro\ \-\ RJ",
"55833547", "Vieirópolis\ \-\ PB",
"55114062", "São\ Paulo\ \-\ SP",
"55193826", "Vinhedo\ \-\ SP",
"55353853", "Campos\ Gerais\ \-\ MG",
"55823268", "Santa\ Luzia\ do\ Norte\ \-\ AL",
"55193366", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55853363", "Paraipaba\ \-\ CE",
"55222531", "Sumidouro\ \-\ RJ",
"55623505", "Trindade\ \-\ GO",
"55513645", "São\ Pedro\ da\ Serra\ \-\ RS",
"55513773", "Poço\ das\ Antas\ \-\ RS",
"55813452", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55733688", "Piraí\ do\ Norte\ \-\ BA",
"55833553", "Carrapateira\ \-\ PB",
"55193874", "Paulínia\ \-\ SP",
"55333523", "Teófilo\ Otoni\ \-\ MG",
"55513529", "Sapiranga\ \-\ RS",
"55212755", "São\ João\ de\ Meriti\ \-\ RJ",
"55113585", "São\ Paulo\ \-\ SP",
"55833399", "Massaranduba\ \-\ PB",
"55813737", "Bonito\ \-\ PE",
"55323367", "Alfredo\ Vasconcelos\ \-\ MG",
"55313686", "Confins\ \-\ MG",
"55443352", "Santo\ Inácio\ \-\ PR",
"55273044", "Colatina\ \-\ ES",
"55683611", "Manoel\ Urbano\ \-\ AC",
"55513611", "Chuvisca\ \-\ RS",
"55873784", "São\ João\ \-\ PE",
"55753236", "Santa\ Bárbara\ \-\ BA",
"55613981", "Formosa\ \-\ GO",
"55313883", "Rio\ Doce\ \-\ MG",
"55273264", "Linhares\ \-\ ES",
"5511508", "São\ Paulo\ \-\ SP",
"55193594", "Descalvado\ \-\ SP",
"55753281", "Paulo\ Afonso\ \-\ BA",
"55143584", "Pirajuí\ \-\ SP",
"55163171", "Pedregulho\ \-\ SP",
"55483003", "Florianópolis\ \-\ SC",
"55443250", "Presidente\ Castelo\ Branco\ \-\ PR",
"55612328", "Brasília\ \-\ DF",
"55353656", "Consolação\ \-\ MG",
"55193623", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55663540", "União\ do\ Sul\ \-\ MT",
"55273302", "Aracruz\ \-\ ES",
"55383252", "Engenheiro\ Dolabela\ \-\ MG",
"55453251", "Ouro\ Verde\ do\ Oeste\ \-\ PR",
"5554302", "Caxias\ do\ Sul\ \-\ RS",
"55153344", "Piedade\ \-\ SP",
"55153555", "Ribeira\ \-\ SP",
"55113633", "São\ Paulo\ \-\ SP",
"55623639", "Goiânia\ \-\ GO",
"55443231", "Itambé\ \-\ PR",
"55414122", "Curitiba",
"55414020", "Curitiba\ \-\ PR",
"55114104", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55143535", "Pompéia\ \-\ SP",
"55193896", "Santo\ Antônio\ de\ Posse\ \-\ SP",
"55313809", "Santa\ Bárbara\ \-\ MG",
"55123864", "São\ Sebastião\ \-\ SP",
"55133871", "Eldorado\ \-\ SP",
"55423302", "Ponta\ Grossa\ \-\ PR",
"55213602", "Niterói\ \-\ RJ",
"55423618", "Virmond\ \-\ PR",
"55333624", "Carlos\ Chagas\ \-\ MG",
"55823646", "Canapi\ \-\ AL",
"55943332", "São\ Domingos\ do\ Araguaia\ \-\ PA",
"55123151", "Canas\ \-\ SP",
"55453230", "Diamante\ do\ Sul\ \-\ PR",
"55793322", "Propriá\ \-\ SE",
"55222760", "Rio\ das\ Ostras\ \-\ RJ",
"55513599", "Sapiranga\ \-\ RS",
"55463245", "Honório\ Serpa\ \-\ PR",
"55633520", "Nova\ Rosalândia\ \-\ TO",
"55222105", "Macaé\ \-\ RJ",
"55173587", "Palmares\ Paulista\ \-\ SP",
"55773475", "Rio\ de\ Contas\ \-\ BA",
"55143886", "Pardinho\ \-\ SP",
"55483089", "São\ José\ \-\ SC",
"55643555", "Avelinópolis\ \-\ GO",
"55413070", "Fazenda\ Rio\ Grande\ \-\ PR",
"55313482", "Minas\ Gerais",
"55193831", "Mogi\-Guaçu\ \-\ SP",
"55193706", "Campinas\ \-\ SP",
"55353690", "Varginha\ \-\ MG",
"55733628", "Santa\ Luzia\ \-\ BA",
"55843278", "São\ Gonçalo\ do\ Amarante\ \-\ RN",
"55343691", "Araxá\ \-\ MG",
"55114716", "São\ João\ Novo\ \-\ SP",
"55873845", "Calumbi\ \-\ PE",
"55193886", "Vinhedo\ \-\ SP",
"55123637", "Moreira\ César\ \-\ SP",
"55113361", "São\ Paulo\ \-\ SP",
"55693344", "Pimenteiras\ do\ Oeste\ \-\ RO",
"55243401", "Barra\ Mansa\ \-\ RJ",
"55793256", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55163506", "Matão\ \-\ SP",
"55383564", "Ruralminas\ I\ \-\ MG",
"55433122", "Apucarana\ \-\ PR",
"55913322", "Barcarena\ \-\ PA",
"55433020", "Rolândia\ \-\ PR",
"55813656", "Orobó\ \-\ PE",
"55753413", "Esplanada\ \-\ BA",
"55114871", "São\ Paulo\ \-\ SP",
"55313626", "Ribeirão\ das\ Neves\ \-\ MG",
"55513660", "Rio\ Grande\ do\ Sul",
"55153305", "Tatuí\ \-\ SP",
"55643408", "Joviânia\ \-\ GO",
"55513589", "São\ Leopoldo\ \-\ RS",
"55333583", "Pescador\ \-\ MG",
"55443055", "Umuarama\ \-\ PR",
"55813379", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55114468", "Santo\ André\ \-\ SP",
"55463572", "Cruzeiro\ do\ Iguaçu\ \-\ PR",
"55283552", "Alegre\ \-\ ES",
"55883541", "Várzea\ Alegre\ \-\ CE",
"55314113", "Sete\ Lagoas\ \-\ MG",
"55193584", "Santa\ Rita\ do\ Passa\ Quatro\ \-\ SP",
"55114145", "Itapevi\ \-\ SP",
"55983622", "Bacabal\ \-\ MA",
"55115616", "São\ Paulo\ \-\ SP",
"55423552", "General\ Carneiro\ \-\ PR",
"55313893", "Porto\ Firme\ \-\ MG",
"55453035", "Cascavel\ \-\ PR",
"55543412", "Farroupilha\ \-\ RS",
"55112818", "Mauá\ \-\ SP",
"55963261", "Macapá\ \-\ AP",
"55873794", "Ibirajuba\ \-\ PE",
"55173349", "Turvínia\ \-\ SP",
"55113571", "São\ Paulo\ \-\ SP",
"55673503", "Paranaíba\ \-\ MS",
"55183349", "Frutal\ do\ Campo\ \-\ SP",
"55623516", "Goianira\ \-\ GO",
"55813517", "São\ Lourenço\ da\ Mata\ \-\ PE",
"55173661", "Rubinéia\ \-\ SP",
"55183117", "Araçatuba\ \-\ SP",
"55973431", "São\ Paulo\ de\ Olivença\ \-\ AM",
"5532323", "Juiz\ de\ Fora\ \-\ MG",
"55623643", "Goiânia\ \-\ GO",
"55343813", "Vazante\ \-\ MG",
"55733011", "Teixeira\ de\ Freitas\ \-\ BA",
"55513492", "Viamão\ \-\ RS",
"55143845", "Conchas\ \-\ SP",
"55793046", "Aracaju\ \-\ SE",
"55383647", "Formoso\ \-\ MG",
"55273752", "Nova\ Venécia\ \-\ ES",
"55513789", "Boqueirão\ do\ Leão\ \-\ RS",
"55963332", "Macapá\ \-\ AP",
"55653356", "Rosário\ Oeste\ \-\ MT",
"55753244", "Conceição\ da\ Feira\ \-\ BA",
"55423270", "Guaragi\ \-\ PR",
"55173278", "União\ Paulista\ \-\ SP",
"55183278", "Caiuá\ \-\ SP",
"55493572", "Matos\ Costa\ \-\ SC",
"55443423", "Paranavaí\ \-\ PR",
"55893587", "Dirceu\ Arcoverde\ \-\ PI",
"55153336", "Sorocaba\ \-\ SP",
"55443245", "Mandaguaçu\ \-\ PR",
"55163831", "Guará\ \-\ SP",
"55353462", "Estiva\ \-\ MG",
"55483461", "Criciúma\ \-\ SC",
"55163706", "Franca\ \-\ SP",
"55143541", "Promissão\ \-\ SP",
"55113514", "São\ Paulo\ \-\ SP",
"55623365", "Crixás\ \-\ GO",
"55114775", "Itapecerica\ da\ Serra\ \-\ SP",
"55663555", "Cotriguaçu\ \-\ MT",
"55733265", "Itororó\ \-\ BA",
"55813863", "Petrolina\ \-\ PE",
"55483878", "Florianópolis\ \-\ SC",
"55313599", "Ibirité\ \-\ MG",
"55383311", "Paracatu\ \-\ MG",
"55623575", "Goiânia\ \-\ GO",
"55993015", "Imperatriz\ \-\ MA",
"55823634", "Senador\ Rui\ Palmeira\ \-\ AL",
"55633376", "Barrolândia\ \-\ TO",
"55513883", "Montenegro\ \-\ RS",
"55143356", "Manduri\ \-\ SP",
"55513703", "Rio\ Grande\ do\ Sul",
"55633659", "Ponte\ Alta\ do\ Bom\ Jesus\ \-\ TO",
"55313611", "Viçosa\ \-\ MG",
"55883623", "Barroquinha\ \-\ CE",
"55243388", "Resende\ \-\ RJ",
"55914005", "Belém\ \-\ PA",
"5598", "Maranhão",
"55843661", "Natal\ \-\ RN",
"5597", "Amazonas",
"55624141", "Goiânia\ \-\ GO",
"55553379", "Condor\ \-\ RS",
"55273270", "Barra\ do\ Riacho\ \-\ ES",
"55193804", "Mogi\ Mirim\ \-\ SP",
"55493362", "Novo\ Horizonte\ \-\ SC",
"55114657", "Santa\ Isabel\ \-\ SP",
"55653541", "Colíder\ \-\ MT",
"55793648", "Pedrinhas\ \-\ SE",
"55543038", "Garibaldi\ \-\ RS",
"55323339", "Barbacena\ \-\ MG",
"55673028", "Campo\ Grande\ \-\ MS",
"55114639", "Poá\ \-\ SP",
"55683028", "Rio\ Branco\ \-\ AC",
"55624106", "Trindade\ \-\ GO",
"55343412", "Campina\ Verde\ \-\ MG",
"55814107", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55484009", "Florianópolis\ \-\ SC",
"55115833", "São\ Paulo\ \-\ SP",
"55212765", "Nova\ Iguaçu\ \-\ RJ",
"55873850", "Brejinho\ \-\ PE",
"55323357", "Coronel\ Xavier\ Chaves\ \-\ MG",
"55743648", "Ibipeba\ \-\ BA",
"55643677", "Amorinópolis\ \-\ GO",
"55273021", "Guarapari\ \-\ ES",
"55423459", "Fernandes\ Pinheiro\ \-\ PR",
"55113184", "Osasco\ \-\ SP",
"55114131", "Pirapora\ do\ Bom\ Jesus\ \-\ SP",
"55733162", "Porto\ Seguro\ \-\ BA",
"55143222", "Bauru\ \-\ SP",
"55543519", "Erechim\ \-\ RS",
"55193794", "Campinas\ \-\ SP",
"55823258", "Passo\ de\ Camaragibe\ \-\ AL",
"55353863", "Santo\ Antônio\ do\ Amparo\ \-\ MG",
"55883584", "Orós\ \-\ CE",
"55353323", "São\ Vicente\ de\ Minas\ \-\ MG",
"55853353", "Uruburetama\ \-\ CE",
"55323228", "Juiz\ de\ Fora\ \-\ MG",
"55713261", "Salvador\ \-\ BA",
"55173807", "Ubarana\ \-\ SP",
"55323343", "Senhora\ dos\ Remédios\ \-\ MG",
"55493245", "Curitibanos\ \-\ SC",
"55843333", "Apodi\ \-\ RN",
"55193541", "Araras\ \-\ SP",
"55113135", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55114052", "São\ Paulo\ \-\ SP",
"55433532", "Cambará\ \-\ PR",
"55673674", "Bela\ Vista\ \-\ MS",
"55513674", "Tavares\ \-\ RS",
"55513482", "Barra\ do\ Ribeiro\ \-\ RS",
"55773416", "Contendas\ do\ Sincorá\ \-\ BA",
"55883535", "Assaré\ \-\ CE",
"55923512", "Borba\ \-\ AM",
"55313589", "Nova\ Lima\ \-\ MG",
"55193845", "Hortolândia\ \-\ SP",
"55483207", "Florianópolis\ \-\ SC",
"55873886", "Verdejante\ \-\ PE",
"55833373", "Araruna\ \-\ PB",
"5583322", "João\ Pessoa\ \-\ PB",
"55853347", "Baturité\ \-\ CE",
"55224009", "Campos\ dos\ Goitacazes\ \-\ RJ",
"55653222", "Cáceres\ \-\ MT",
"55623954", "Goiânia\ \-\ GO",
"55513626", "Torres\ \-\ RS",
"55663408", "São\ José\ do\ Couto\ \-\ MT",
"55873831", "Serra\ Talhada\ \-\ PE",
"55313660", "Pedro\ Leopoldo\ \-\ MG",
"55163114", "Araraquara\ \-\ SP",
"55433066", "Londrina\ \-\ PR",
"55543377", "Santo\ Antônio\ do\ Planalto\ \-\ RS",
"55443572", "Piquirivaí\ \-\ PR",
"55463055", "Francisco\ Beltrão\ \-\ PR",
"55163693", "Jardinópolis\ \-\ SP",
"55123669", "Campos\ do\ Jordão\ \-\ SP",
"55243328", "Barra\ Mansa\ \-\ RJ",
"55883683", "Ipu\ \-\ CE",
"55643565", "Itumbiara\ \-\ GO",
"55673907", "Corumbá\ \-\ MS",
"55633438", "Recursolândia\ \-\ TO",
"55753433", "Subaúma\ \-\ BA",
"55115103", "São\ Paulo\ \-\ SP",
"55513363", "Rio\ Grande\ do\ Sul",
"55423254", "Colônia\ Witmarsum\ \-\ PR",
"55913447", "Cachoeira\ do\ Piriá\ \-\ PA",
"55923020", "Manaus\ \-\ AM",
"55143292", "Pederneiras\ \-\ SP",
"55114736", "Mogi\ das\ Cruzes\ \-\ SP",
"55353068", "Varginha\ \-\ MG",
"55433467", "Rio\ Branco\ do\ Ivaí\ \-\ PR",
"55833664", "Santa\ Rita\ \-\ PB",
"55273091", "Cariacica\ \-\ ES",
"55114781", "Embu\ das\ Artes\ \-\ SP",
"55193811", "Mogi\-Guaçu\ \-\ SP",
"55613500", "Brasília\ \-\ DF",
"55353559", "Guaxupé\ \-\ MG",
"55133846", "Pedro\ Barros\ \-\ SP",
"55163524", "Sertãozinho\ \-\ SP",
"55124448", "Cajamar\ \-\ SP",
"55333317", "Conceição\ de\ Ipanema\ \-\ MG",
"55553737", "Vicente\ Dutra\ \-\ RS",
"55643478", "Ouvidor\ \-\ GO",
"55963084", "Macapá\ \-\ AP",
"55213229", "Rio\ de\ Janeiro\ \-\ RJ",
"55633384", "Araguaçu\ \-\ TO",
"55733240", "Gongogi\ \-\ BA",
"55183993", "Cuiabá\ Paulista\ \-\ SP",
"55373262", "Lagoa\ da\ Prata\ \-\ MG",
"55463226", "Mariópolis\ \-\ PR",
"55623581", "Goiânia\ \-\ GO",
"5532321", "Juiz\ de\ Fora\ \-\ MG",
"55623340", "São\ Patrício\ \-\ GO",
"55153565", "Itaporanga\ \-\ SP",
"55713041", "Camaçari\ \-\ BA",
"55623536", "Goiânia\ \-\ GO",
"55163146", "Itirapuã\ \-\ SP",
"55813537", "Chã\ Grande\ \-\ PE",
"55513729", "Lajeado\ \-\ RS",
"55333723", "Jacinto\ \-\ MG",
"55153321", "Sorocaba\ \-\ SP",
"55273254", "Cariacica\ \-\ ES",
"55913014", "Ananindeua\ \-\ PA",
"55113501", "São\ Paulo\ \-\ SP",
"55112838", "São\ Paulo\ \-\ SP",
"55314133", "Belo\ Horizonte\ \-\ MG",
"55823625", "Maravilha\ \-\ AL",
"55773444", "Livramento\ de\ Nossa\ Senhora\ \-\ BA",
"55513157", "Três\ Coroas\ \-\ RS",
"55453015", "Cascavel\ \-\ PR",
"55933552", "Placas\ \-\ PA",
"55153478", "Pilar\ do\ Sul\ \-\ SP",
"55213077", "Rio\ de\ Janeiro\ \-\ RJ",
"55513696", "Barão\ \-\ RS",
"55183651", "Avanhandava\ \-\ SP",
"55793453", "Moita\ Bonita\ \-\ SE",
"55173651", "Palmeira\ D\'Oeste\ \-\ SP",
"55513422", "Barro\ Vermelho\ \-\ RS",
"55313645", "Vespasiano\ \-\ MG",
"55873874", "Ouricuri\ \-\ PE",
"55623591", "Goiânia\ \-\ GO",
"55423036", "Guarapuava\ \-\ PR",
"55773612", "Barreiras\ \-\ BA",
"55513686", "Magistério\ \-\ RS",
"55673686", "Bonito\ \-\ MS",
"55793014", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55753449", "Conde\ \-\ BA",
"55163101", "Ribeirão\ Preto\ \-\ SP",
"55963251", "Macapá\ \-\ AP",
"55313529", "Betim\ \-\ MG",
"55513631", "Escadinhas\ \-\ RS",
"55423562", "Paula\ Freitas\ \-\ PR",
"55222796", "Macaé\ \-\ RJ",
"55123971", "São\ Bento\ do\ Sapucaí\ \-\ SP",
"55115691", "São\ Paulo\ \-\ SP",
"55813559", "Ipojuca\ \-\ PE",
"55273372", "Linhares\ \-\ ES",
"55313879", "Belo\ Horizonte\ \-\ MG",
"55114174", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55163951", "Cravinhos\ \-\ SP",
"55693321", "Vilhena\ \-\ RO",
"55613386", "Núcleo\ Bandeirante\ \-\ DF",
"55883576", "Jaguaretama\ \-\ CE",
"55283562", "Bom\ Jesus\ do\ Norte\ \-\ ES",
"55213484", "Rio\ de\ Janeiro\ \-\ RJ",
"55643945", "Itumbiara\ \-\ GO",
"55613331", "Recanto\ das\ Emas\ \-\ DF",
"55353537", "Fortaleza\ de\ Minas\ \-\ MG",
"55143811", "Botucatu\ \-\ SP",
"55513650", "Barão\ do\ Triunfo\ \-\ RS",
"55793447", "Frei\ Paulo\ \-\ SE",
"55513088", "Lajeado\ \-\ RS",
"55883524", "Aiuaba\ \-\ CE",
"55633394", "Sandolândia\ \-\ TO",
"55423638", "Candói\ \-\ PR",
"55943312", "Marabá\ \-\ PA",
"55283036", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55133505", "Mongaguá\ \-\ SP",
"55323288", "Olaria\ \-\ MG",
"55793266", "Santo\ Amaro\ das\ Brotas\ \-\ SE",
"55273081", "Vitória\ \-\ ES",
"55823533", "Jaramataia\ \-\ AL",
"55143282", "Duartina\ \-\ SP",
"55793348", "Japoatã\ \-\ SE",
"55643681", "Firminópolis\ \-\ GO",
"55553356", "Bossoroca\ \-\ RS",
"55513770", "Sério\ \-\ RS",
"55343851", "Carmo\ do\ Paranaíba\ \-\ MG",
"55193187", "Santa\ Maria\ da\ Serra\ \-\ SP",
"55813741", "Toritama\ \-\ PE",
"55553794", "Planalto\ \-\ RS",
"55643636", "Jataí\ \-\ GO",
"55223832", "Rosal\ \-\ RJ",
"55843361", "Patu\ \-\ RN",
"55143656", "Torrinha\ \-\ SP",
"55373353", "Iguatama\ \-\ MG",
"55633359", "São\ Valério\ da\ Natividade\ \-\ TO",
"55823334", "Maceió\ \-\ AL",
"55115904", "São\ Paulo\ \-\ SP",
"55313764", "Conselheiro\ Lafaiete\ \-\ MG",
"55843525", "Guamaré\ \-\ RN",
"55143379", "Ribeirão\ do\ Sul\ \-\ SP",
"55813114", "Vitória\ de\ Santo\ Antão\ \-\ PE",
"55793445", "Carira\ \-\ SE",
"55833531", "Cajazeiras\ \-\ PB",
"55493538", "Ibicaré\ \-\ SC",
"55323052", "Barbacena\ \-\ MG",
"55613703", "Brasília\ \-\ DF",
"55353535", "São\ Tomás\ de\ Aquino\ \-\ MG",
"55733047", "Jequié\ \-\ BA",
"55473449", "São\ Francisco\ do\ Sul\ \-\ SC",
"55963421", "Amapá\ \-\ AP",
"5574", "Bahia",
"55483216", "Florianópolis\ \-\ SC",
"55353831", "Campo\ Belo\ \-\ MG",
"55222553", "Cantagalo\ \-\ RJ",
"55543381", "Soledade\ \-\ RS",
"55553541", "Santo\ Cristo\ \-\ RS",
"55513252", "Rio\ Grande\ do\ Sul",
"55114163", "Barueri\ \-\ SP",
"55443019", "Cianorte\ \-\ PR",
"55133507", "Mongaguá\ \-\ SP",
"55173816", "Orindiúva\ \-\ SP",
"5591", "Pará",
"55793223", "Aracaju\ \-\ SE",
"55543336", "Ipiranga\ do\ Sul\ \-\ RS",
"55913445", "Santa\ Luzia\ do\ Pará\ \-\ PA",
"55553506", "São\ Francisco\ de\ Assis\ \-\ RS",
"55414009", "Curitiba\ \-\ PR",
"55313820", "Minas\ Gerais",
"55493019", "Lages\ \-\ SC",
"55643567", "Itumbiara\ \-\ GO",
"55663412", "Juscimeira\ \-\ MT",
"55353741", "Botelhos\ \-\ MG",
"55443538", "Engenheiro\ Beltrão\ \-\ PR",
"55133343", "Guarujá\ \-\ SP",
"55333315", "Inhapim\ \-\ MG",
"55773261", "Itapetinga\ \-\ BA",
"55633509", "Dianópolis\ \-\ TO",
"55273299", "Vila\ Velha\ \-\ ES",
"55863194", "Teresina\ \-\ PI",
"55543391", "Gaurama\ \-\ RS",
"55643519", "Itumbiara\ \-\ GO",
"5579", "Sergipe",
"55433465", "Rosário\ do\ Ivaí\ \-\ PR",
"55193933", "Paulínia\ \-\ SP",
"55813535", "Moreno\ \-\ PE",
"55553784", "Chiapetta\ \-\ RS",
"55112592", "São\ Paulo\ \-\ SP",
"55353623", "Itajubá\ \-\ MG",
"55193656", "Mococa\ \-\ SP",
"55613799", "Brasília\ \-\ DF",
"55124611", "Cotia\ \-\ SP",
"55643691", "Vicentinópolis\ \-\ GO",
"55463263", "Palmas\ \-\ PR",
"55212173", "Rio\ de\ Janeiro\ \-\ RJ",
"55513564", "Dois\ Irmãos\ \-\ RS",
"55453017", "Foz\ do\ Iguaçu\ \-\ PR",
"55643377", "Mossâmedes\ \-\ GO",
"55813831", "Serra\ Talhada\ \-\ PE",
"55323721", "Muriaé\ \-\ MG",
"55613626", "Santo\ Antônio\ do\ Descoberto\ \-\ GO",
"55153519", "Sorocaba\ \-\ SP",
"55163323", "Ribeirão\ Preto\ \-\ SP",
"55483433", "Criciúma\ \-\ SC",
"55443662", "Maria\ Helena\ \-\ PR",
"55313570", "Minas\ Gerais",
"55323355", "Tiradentes\ \-\ MG",
"55643675", "Palminópolis\ \-\ GO",
"55313890", "Minas\ Gerais",
"55613363", "Guará\ \-\ DF",
"55513396", "Rio\ Grande\ do\ Sul",
"55223205", "Saquarema\ \-\ RJ",
"55413588", "São\ José\ dos\ Pinhais\ \-\ PR",
"55212767", "Nova\ Iguaçu\ \-\ RJ",
"55493253", "São\ Cristovão\ do\ Sul\ \-\ SC",
"55454053", "Foz\ do\ Iguaçu\ \-\ PR",
"55843534", "Pedro\ Avelino\ \-\ RN",
"55813683", "Maraial\ \-\ PE",
"55163666", "Santa\ Cruz\ da\ Esperança\ \-\ SP",
"55513754", "Imigrante\ \-\ RS",
"55353826", "Lavras\ \-\ MG",
"55193853", "Pedreira\ \-\ SP",
"55623999", "Goiânia\ \-\ GO",
"55273229", "Vila\ Velha\ \-\ ES",
"55353366", "Alagoa\ \-\ MG",
"55543478", "Vista\ Alegre\ do\ Prata\ \-\ RS",
"55453249", "Anahy\ \-\ PR",
"55922101", "Manaus\ \-\ AM",
"55543321", "Erechim\ \-\ RS",
"55883537", "Salitre\ \-\ CE",
"55353693", "Pouso\ Alegre\ \-\ MG",
"5585347", "Fortaleza\ \-\ CE",
"55663539", "Novo\ Mundo\ \-\ MT",
"55633472", "Araguacema\ \-\ TO",
"55353715", "Poços\ de\ Caldas\ \-\ MG",
"55133298", "Santos\ \-\ SP",
"55913411", "Capanema\ \-\ PA",
"55143452", "Pompéia\ \-\ SP",
"55833364", "Remígio\ \-\ PB",
"55192532", "Piracicaba\ \-\ SP",
"55493247", "Lebon\ Régis\ \-\ SC",
"55643621", "Rio\ Verde\ \-\ GO",
"55973453", "Boca\ do\ Acre\ \-\ AM",
"55313262", "Belo\ Horizonte\ \-\ MG",
"55983453", "Arari\ \-\ MA",
"55463057", "Francisco\ Beltrão\ \-\ PR",
"55513663", "Osório\ \-\ RS",
"55643432", "Itumbiara\ \-\ GO",
"55543375", "Erval\ Grande\ \-\ RS",
"55813101", "Caruaru\ \-\ PE",
"55143737", "Garça\ \-\ SP",
"55713444", "Salvador\ \-\ BA",
"55613573", "Brasília\ \-\ DF",
"55333341", "Manhumirim\ \-\ MG",
"55983014", "São\ Luís\ \-\ MA",
"55754009", "Feira\ de\ Santana\ \-\ BA",
"55353524", "São\ João\ Batista\ do\ Glória\ \-\ MG",
"55163393", "Américo\ Brasiliense\ \-\ SP",
"55853345", "Pacatuba\ \-\ CE",
"55473205", "Joinville\ \-\ SC",
"55483205", "Florianópolis\ \-\ SC",
"55193847", "Jaguariúna\ \-\ SP",
"55483952", "Florianópolis\ \-\ SC",
"55173546", "Itajobi\ \-\ SP",
"55893585", "Coronel\ José\ Dias\ \-\ PI",
"55693432", "Rolim\ de\ Moura\ \-\ RO",
"55834101", "Campina\ Grande\ \-\ PB",
"55793411", "Nossa\ Senhora\ da\ Glória\ \-\ SE",
"55453233", "Campo\ Bonito\ \-\ PR",
"55173330", "Guaíra\ \-\ SP",
"55143847", "Itatinga\ \-\ SP",
"5564400", "Itumbiara\ \-\ GO",
"55113651", "Osasco\ \-\ SP",
"55112473", "Bragança\ Paulista\ \-\ SP",
"55883559", "Penaforte\ \-\ CE",
"55553282", "Lavras\ do\ Sul\ \-\ RS",
"55114777", "Cotia\ \-\ SP",
"55663557", "Tabaporã\ \-\ MT",
"55163383", "Matão\ \-\ SP",
"55313856", "São\ Domingos\ do\ Prata\ \-\ MG",
"55733267", "Itororó\ \-\ BA",
"55623367", "Porangatu\ \-\ GO",
"55613631", "Formosa\ \-\ GO",
"55313448", "Minas\ Gerais",
"55954400", "Caracaraí\ \-\ RR",
"55193452", "Limeira\ \-\ SP",
"55413073", "Belo\ Horizonte\ \-\ MG",
"55113159", "São\ Paulo\ \-\ SP",
"55713612", "Salvador\ \-\ BA",
"55693621", "São\ Francisco\ do\ Guaporé\ \-\ RO",
"55443247", "Santa\ Fé\ \-\ PR",
"55433440", "Pirapó\ \-\ PR",
"5531347", "Belo\ Horizonte\ \-\ MG",
"55813693", "Xexéu\ \-\ PE",
"55313165", "Santa\ Luzia\ \-\ MG",
"55173844", "Pontes\ Gestal\ \-\ SP",
"55222654", "Sampaio\ Correia\ \-\ RJ",
"55993017", "Imperatriz\ \-\ MA",
"55813576", "Sirinhaém\ \-\ PE",
"55423435", "Pinho\ de\ Baixo\ \-\ PR",
"55313880", "Minas\ Gerais",
"55443253", "Maringá\ \-\ PR",
"55993558", "Passagem\ Franca\ \-\ MA",
"55114655", "Arujá\ \-\ SP",
"55313554", "Lavras\ Novas\ \-\ MG",
"55853304", "Fortaleza\ \-\ CE",
"55483244", "Florianópolis\ \-\ SC",
"55183351", "Palmital\ \-\ SP",
"55123133", "Guaratinguetá\ \-\ SP",
"55813524", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55843613", "Natal\ \-\ RN",
"55643539", "Itumbiara\ \-\ GO",
"55843330", "Itajá\ \-\ RN",
"55683262", "Vila\ do\ V\ \-\ AC",
"55873847", "Tabira\ \-\ PE",
"55123635", "Taubaté\ \-\ SP",
"55114577", "Mauá\ \-\ SP",
"55443518", "Campo\ Mourão\ \-\ PR",
"55223054", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55333335", "São\ José\ do\ Mantimento\ \-\ MG",
"55853331", "Barreira\ \-\ CE",
"55383729", "Curvelo\ \-\ MG",
"55323536", "Senador\ Firmino\ \-\ MG",
"55863212", "Timon\ \-\ MA",
"55112429", "Itu\ \-\ SP",
"55663432", "Poxoréo\ \-\ MT",
"55192122", "Campinas\ \-\ SP",
"55353292", "Alfenas\ \-\ MG",
"55212681", "Seropédica\ \-\ RJ",
"55153307", "Itapetininga\ \-\ SP",
"55833370", "Caiçara\ \-\ PB",
"55913087", "Belém\ \-\ PA",
"55553524", "Crissiumal\ \-\ RS",
"55983392", "Bacuri\ \-\ MA",
"55183746", "Pereira\ Barreto\ \-\ SP",
"55193537", "Ipeúna\ \-\ SP",
"55313663", "Pedro\ Leopoldo\ \-\ MG",
"55115851", "São\ Paulo\ \-\ SP",
"55313754", "Lamim\ \-\ MG",
"55483413", "Criciúma\ \-\ SC",
"55953263", "Alto\ Alegre\ \-\ RR",
"55873853", "Itapetim\ \-\ PE",
"55913692", "Gurupá\ \-\ PA",
"55453037", "Cascavel\ \-\ PR",
"55383823", "Riacho\ dos\ Machados\ \-\ MG",
"55114147", "Itapecerica\ da\ Serra\ \-\ SP",
"55212103", "Rio\ de\ Janeiro\ \-\ RJ",
"55143666", "Bocaina\ \-\ SP",
"55633369", "Novo\ Acordo\ \-\ TO",
"55313396", "Minas\ Gerais",
"55493652", "Palma\ Sola\ \-\ SC",
"55213762", "Nilópolis\ \-\ RJ",
"55843351", "Pau\ dos\ Ferros\ \-\ RN",
"55473054", "Jaraguá\ do\ Sul\ \-\ SC",
"55743692", "América\ Dourada\ \-\ BA",
"55193913", "Itapira\ \-\ SP",
"55443043", "Paiçandu\ \-\ PR",
"55553366", "Itacurubi\ \-\ RS",
"55652122", "Cáceres\ \-\ MT",
"55313386", "Minas\ Gerais",
"55823314", "Maceió\ \-\ AL",
"55613879", "Brasília\ \-\ DF",
"55443652", "Iporã\ \-\ PR",
"55472107", "Jaraguá\ do\ Sul\ \-\ SC",
"55482107", "Florianópolis\ \-\ SC",
"55313331", "Minas\ Gerais",
"55943491", "Redenção\ \-\ PA",
"55513700", "Rio\ Grande\ do\ Sul",
"55273273", "Sooretama\ \-\ ES",
"55653383", "Sapezal\ \-\ MT",
"55153557", "Itaóca\ \-\ SP",
"55513554", "São\ Leopoldo\ \-\ RS",
"55513345", "Rio\ Grande\ do\ Sul",
"55623288", "Aparecida\ de\ Goiânia\ \-\ GO",
"5564309", "Itumbiara\ \-\ GO",
"55493198", "Maravilha\ \-\ SC",
"55643543", "Cezarina\ \-\ GO",
"55163759", "Franca\ \-\ SP",
"55142122", "Avaré\ \-\ SP",
"55183701", "Mirandópolis\ \-\ SP",
"55443039", "Cianorte\ \-\ PR",
"55112284", "Osasco\ \-\ SP",
"55173836", "Cosmorama\ \-\ SP",
"55453421", "Toledo\ \-\ PR",
"55643018", "Itumbiara\ \-\ GO",
"55453378", "Toledo\ \-\ PR",
"55163847", "Nuporanga\ \-\ SP",
"55423273", "Telêmaco\ Borba\ \-\ PR",
"55693539", "Rio\ Crespo\ \-\ RO",
"55513448", "Rio\ Grande\ do\ Sul",
"55483236", "Florianópolis\ \-\ SC",
"55773477", "Lagoa\ Real\ \-\ BA",
"55983382", "Santa\ Helena\ \-\ MA",
"55673448", "Deodápolis\ \-\ MS",
"55473236", "Blumenau\ \-\ SC",
"55824002", "Maceió\ \-\ AL",
"55893546", "Bertolínia\ \-\ PI",
"55313916", "Belo\ Horizonte\ \-\ MG",
"55212691", "Nilópolis\ \-\ RJ",
"55383631", "São\ Francisco\ \-\ MG",
"55833511", "Patos\ \-\ PB",
"55353282", "Carvalhópolis\ \-\ MG",
"55153543", "Capão\ Bonito\ \-\ SP",
"55643644", "Aporé\ \-\ GO",
"55323575", "Guarani\ \-\ MG",
"55713632", "Pólo\ Petroquímico\ Camaçari\ \-\ BA",
"55193769", "Campinas\ \-\ SP",
"55513653", "Taquari\ \-\ RS",
"55553535", "Três\ de\ Maio\ \-\ RS",
"55123676", "Redenção\ da\ Serra\ \-\ SP",
"55943421", "Conceição\ do\ Araguaia\ \-\ PA",
"55493456", "Campina\ da\ Alegria\ \-\ SC",
"55833629", "São\ Miguel\ de\ Taipu\ \-\ PB",
"55324141", "Juiz\ de\ Fora\ \-\ MG",
"55212675", "Duque\ de\ Caxias\ \-\ RJ",
"55793431", "Itabaiana\ \-\ SE",
"55173633", "Santa\ Albertina\ \-\ SP",
"55343336", "Uberaba\ \-\ MG",
"55833354", "Serra\ Branca\ \-\ PB",
"55833545", "São\ Francisco\ \-\ PB",
"55353541", "Cássia\ \-\ MG",
"55713378", "Lauro\ de\ Freitas\ \-\ BA",
"55973463", "Amaturá\ \-\ AM",
"55114707", "Jandira\ \-\ SP",
"55212743", "Teresópolis\ \-\ RJ",
"55333324", "Vargem\ Alegre\ \-\ MG",
"55983463", "Itapecuru\ Mirim\ \-\ MA",
"55823346", "Maceió\ \-\ AL",
"55473542", "Agronômica\ \-\ SC",
"55193717", "Limeira\ \-\ SP",
"55114887", "Jarinu\ \-\ SP",
"55733239", "Uruçuca\ \-\ BA",
"55693412", "Alvorada\ do\ Oeste\ \-\ RO",
"55823530", "Arapiraca\ \-\ AL",
"55413003", "Curitiba\ \-\ PR",
"551932", "Campinas\ \-\ SP",
"5531340", "Minas\ Gerais",
"55773678", "Botuporã\ \-\ BA",
"55513647", "Vendinha\ \-\ RS",
"55184104", "Birigui\ \-\ SP",
"55193863", "Itapira\ \-\ SP",
"55823551", "Penedo\ \-\ AL",
"55484020", "Florianópolis\ \-\ SC",
"55853326", "Capistrano\ \-\ CE",
"55543344", "Tapejara\ \-\ RS",
"55513764", "Cruzeiro\ do\ Sul\ \-\ RS",
"55163379", "Fazenda\ Babilônia\ \-\ SP",
"55323365", "Santa\ Bárbara\ do\ Tugúrio\ \-\ MG",
"55454063", "Cascavel\ \-\ PR",
"55813735", "São\ Bento\ do\ Una\ \-\ PE",
"55613353", "Taguatinga\ \-\ DF",
"55683311", "Cruzeiro\ do\ Sul\ \-\ AC",
"55114665", "Embu\-Guaçu\ \-\ SP",
"55222747", "Farol\ de\ São\ Tomé\ \-\ RJ",
"55623343", "Abadiânia\ \-\ GO",
"55953198", "Boa\ Vista\ \-\ RR",
"55432101", "Londrina\ \-\ PR",
"55183361", "Paraguaçu\ Paulista\ \-\ SP",
"55733243", "Floresta\ Azul\ \-\ BA",
"55173361", "Monte\ Azul\ Paulista\ \-\ SP",
"55183821", "Dracena\ \-\ SP",
"55753277", "Antas\ \-\ BA",
"55383674", "Cabeceira\ Grande\ \-\ MG",
"55383799", "Curvelo\ \-\ MG",
"55183649", "Birigui\ \-\ SP",
"5513323", "Santos\ \-\ SP",
"55213552", "Duque\ de\ Caxias\ \-\ RJ",
"55173525", "Catanduva\ \-\ SP",
"55813541", "Abreu\ e\ Lima\ \-\ PE",
"55222664", "Araruama\ \-\ RJ",
"55353222", "Varginha\ \-\ MG",
"55473221", "Blumenau\ \-\ SC",
"55383626", "Ibiracatu\ \-\ MG",
"55753451", "Araças\ \-\ BA",
"55883656", "Graça\ \-\ CE",
"55983322", "Boa\ Vista\ do\ Gurupi\ \-\ MA",
"55413099", "Curitiba\ \-\ PR",
"55813679", "Gameleira\ \-\ PE",
"55633402", "Araguaína\ \-\ TO",
"55982109", "São\ Luís\ \-\ MA",
"55163690", "Jardinópolis\ \-\ SP",
"55993632", "Lago\ dos\ Rodrigues\ \-\ MA",
"55643412", "Itumbiara\ \-\ GO",
"55313326", "Belo\ Horizonte\ \-\ MG",
"5561303", "Brasília\ \-\ DF",
"55173875", "São\ João\ de\ Iracema\ \-\ SP",
"55883569", "Deputado\ Irapuan\ Pinheiro\ \-\ CE",
"55313866", "Dom\ Joaquim\ \-\ MG",
"55733257", "Nilo\ Peçanha\ \-\ BA",
"55843232", "Natal\ \-\ RN",
"55183875", "Santa\ Mercedes\ \-\ SP",
"55623357", "Uruaçu\ \-\ GO",
"55115931", "São\ Paulo\ \-\ SP",
"55753430", "Itapicuru\ \-\ BA",
"55163949", "Cruz\ das\ Posses\ \-\ SP",
"55922125", "Manaus\ \-\ AM",
"55113117", "São\ Paulo\ \-\ SP",
"55463538", "Salto\ do\ Lontra\ \-\ PR",
"55513140", "Novo\ Hamburgo\ \-\ RS",
"55114897", "Itu\ \-\ SP",
"55513042", "Gravataí\ \-\ RS",
"55483275", "Rancho\ Queimado\ \-\ SC",
"55993421", "Caxias\ \-\ MA",
"55883517", "Jucás\ \-\ CE",
"55143769", "Holambra\ II\ \-\ SP",
"55473275", "Jaraguá\ do\ Sul\ \-\ SC",
"55313374", "Minas\ Gerais",
"55173571", "Santa\ Adélia\ \-\ SP",
"55793279", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55743622", "Jacobina\ \-\ BA",
"55353735", "Caldas\ \-\ MG",
"55613503", "Planaltina\ \-\ GO",
"55183571", "Flórida\ Paulista\ \-\ SP",
"55833302", "Camalaú\ \-\ PB",
"55923533", "Parintins\ \-\ AM",
"55333241", "Mantena\ \-\ MG",
"55843608", "Natal\ \-\ RN",
"55273763", "São\ Mateus\ \-\ ES",
"55423654", "Catuporanga\ \-\ PR",
"55193682", "São\ José\ do\ Rio\ Pardo\ \-\ SP",
"55983524", "Imperatriz\ \-\ MA",
"55543275", "Nova\ Araçá\ \-\ RS",
"55613456", "Taguatinga\ \-\ DF",
"5511499", "Santo\ André\ \-\ SP",
"55133398", "Guarujá\ \-\ SP",
"55823271", "São\ Miguel\ dos\ Campos\ \-\ AL",
"55282102", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55113436", "Guarulhos\ \-\ SP",
"55493347", "Coronel\ Freitas\ \-\ SC",
"55272102", "Colatina\ \-\ ES",
"55663410", "Rondonópolis\ \-\ MT",
"55213629", "Niterói\ \-\ RJ",
"55353453", "São\ Sebastião\ da\ Bela\ Vista\ \-\ MG",
"55513055", "Guaíba\ \-\ RS",
"5521346", "Rio\ de\ Janeiro\ \-\ RJ",
"55213175", "Nilópolis\ \-\ RJ",
"55115812", "São\ Paulo\ \-\ SP",
"55383662", "Buritis\ \-\ MG",
"55533284", "Pelotas\ \-\ RS",
"55422102", "Ponta\ Grossa\ \-\ PR",
"55353266", "Três\ Pontas\ \-\ MG",
"55114485", "Mairiporã\ \-\ SP",
"55122124", "Lorena\ \-\ SP",
"55313572", "Itatiaiuçu\ \-\ MG",
"55863251", "São\ João\ da\ Serra\ \-\ PI",
"5513331", "Bertioga\ \-\ SP",
"55513479", "Nova\ Santa\ Rita\ \-\ RS",
"55133495", "Praia\ Grande\ \-\ SP",
"55863477", "Inhuma\ \-\ PI",
"55673479", "Sete\ Quedas\ \-\ MS",
"55413605", "Colombo\ \-\ PR",
"55163411", "São\ Carlos\ \-\ SP",
"55653692", "Várzea\ Grande\ \-\ MT",
"55743559", "Pindobaçu\ \-\ BA",
"55214125", "Belford\ Roxo\ \-\ RJ",
"55323255", "Ewbank\ da\ Câmara\ \-\ MG",
"55493353", "Xaxim\ \-\ SC",
"55613263", "Brasília\ \-\ DF",
"55473344", "Itajaí\ \-\ SC",
"55313245", "Belo\ Horizonte\ \-\ MG",
"55483344", "Palhoça\ \-\ SC",
"55333522", "Teófilo\ Otoni\ \-\ MG",
"55213504", "Rio\ de\ Janeiro\ \-\ RJ",
"55643089", "Itumbiara\ \-\ GO",
"55833552", "São\ José\ de\ Piranhas\ \-\ PB",
"55183251", "Presidente\ Epitácio\ \-\ SP",
"55743537", "Sento\ Sé\ \-\ BA",
"55114495", "Itatiba\ \-\ SP",
"55323031", "Juiz\ de\ Fora\ \-\ MG",
"55624017", "Aparecida\ de\ Goiânia\ \-\ GO",
"55163209", "Jaboticabal\ \-\ SP",
"55173251", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55663461", "Jaciara\ \-\ MT",
"55443599", "Campo\ Mourão\ \-\ PR",
"55153003", "Sorocaba\ \-\ SP",
"55853362", "Aquiraz\ \-\ CE",
"55152105", "Sorocaba\ \-\ SP",
"55673286", "Camapuã\ \-\ MS",
"55813453", "Recife\ \-\ PE",
"55753616", "Feira\ de\ Santana\ \-\ BA",
"55112341", "São\ Paulo\ \-\ SP",
"55513772", "Arvorezinha\ \-\ RS",
"55683231", "Bujari\ \-\ AC",
"55673231", "Corumbá\ \-\ MS",
"55912122", "Ananindeua\ \-\ PA",
"55883411", "Russas\ \-\ CE",
"55553025", "Santa\ Maria\ \-\ RS",
"55213806", "Rio\ de\ Janeiro\ \-\ RJ",
"55223851", "Santo\ Antônio\ de\ Pádua\ \-\ RJ",
"55673250", "Corguinho\ \-\ MS",
"55213731", "Maricá\ \-\ RJ",
"55343832", "Patrocínio\ \-\ MG",
"55923671", "Manaus\ \-\ AM",
"55453333", "Cascavel\ \-\ PR",
"55633454", "Aguiarnópolis\ \-\ TO",
"55423238", "Ponta\ Grossa\ \-\ PR",
"55623446", "Alto\ Paraíso\ de\ Goiás\ \-\ GO",
"55813447", "Recife\ \-\ PE",
"55663528", "Luciára\ \-\ MT",
"55983683", "Satubinha\ \-\ MA",
"55143474", "Lupércio\ \-\ SP",
"55533224", "Morro\ Redondo\ \-\ RS",
"55373247", "Igaratinga\ \-\ MG",
"5511334", "São\ Paulo\ \-\ SP",
"55443529", "Campo\ Mourão\ \-\ PR",
"55543281", "Nova\ Petrópolis\ \-\ RS",
"55753644", "Queimadas\ \-\ BA",
"55423303", "Guarapuava\ \-\ PR",
"55443645", "Terra\ Roxa\ \-\ PR",
"55823285", "São\ José\ da\ Laje\ \-\ AL",
"55733665", "Teixeira\ de\ Freitas\ \-\ BA",
"55173332", "Guaíra\ \-\ SP",
"55813046", "Caruaru\ \-\ PE",
"5511316", "São\ Paulo\ \-\ SP",
"55114243", "Cotia\ \-\ SP",
"55943333", "Itupiranga\ \-\ PA",
"55123108", "Aparecida\ \-\ SP",
"55823234", "Maceió\ \-\ AL",
"55193622", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55143279", "Tibiriçá\ \-\ SP",
"55653027", "Cuiabá\ \-\ MT",
"55343244", "Uberlândia\ \-\ MG",
"55813648", "João\ Alfredo\ \-\ PE",
"55693451", "Pimenta\ Bueno\ \-\ RO",
"55313211", "Minas\ Gerais",
"55143496", "Tupã\ \-\ SP",
"55413543", "Rio\ Negro\ \-\ PR",
"55913462", "Capanema\ \-\ PA",
"55383253", "Engenheiro\ Navarro\ \-\ MG",
"55433442", "Bom\ Sucesso\ \-\ PR",
"55933563", "Curuá\ \-\ PA",
"55914107", "Ananindeua\ \-\ PA",
"55843261", "Maxaranguape\ \-\ RN",
"55193486", "Charqueada\ \-\ SP",
"55113421", "Mauá\ \-\ SP",
"55542107", "Erechim\ \-\ RS",
"55853260", "Eusébio\ \-\ CE",
"55113378", "Jundiaí\ \-\ SP",
"55993661", "Codó\ \-\ MA",
"55193431", "Tanquinho\ \-\ SP",
"55313882", "Minas\ Gerais",
"55553256", "Manoel\ Viana\ \-\ RS",
"55993117", "Timon\ \-\ MA",
"5516337", "São\ Carlos\ \-\ SP",
"55553322", "Cruz\ Alta\ \-\ RS",
"55442031", "Umuarama\ \-\ PR",
"55543054", "Caxias\ do\ Sul\ \-\ RS",
"55433268", "Ibiporã\ \-\ PR",
"55143486", "Herculândia\ \-\ SP",
"55283547", "Conceição\ do\ Castelo\ \-\ ES",
"55513502", "Capão\ da\ Canoa\ \-\ RS",
"5588", "Ceará",
"55623642", "Goiânia\ \-\ GO",
"5587", "Pernambuco",
"55213726", "Teresópolis\ \-\ RJ",
"55833469", "Várzea\ \-\ PB",
"55613043", "Brasília\ \-\ DF",
"55313892", "Viçosa\ \-\ MG",
"55663588", "Ipiranga\ do\ Norte\ \-\ MT",
"55423553", "Bituruna\ \-\ PR",
"551139", "São\ Paulo\ \-\ SP",
"55313409", "Belo\ Horizonte\ \-\ MG",
"55193496", "Rafard\ \-\ SP",
"55213699", "Queimados\ \-\ RJ",
"55213774", "Duque\ de\ Caxias\ \-\ RJ",
"55273177", "Colatina\ \-\ ES",
"55543291", "São\ Marcos\ \-\ RS",
"55643430", "Itumbiara\ \-\ GO",
"55243355", "Resende\ \-\ RJ",
"55323026", "Juiz\ de\ Fora\ \-\ MG",
"55913323", "Belém\ \-\ PA",
"55493645", "Guaraciaba\ \-\ SC",
"55283553", "Guaçuí\ \-\ ES",
"55153277", "Tapiraí\ \-\ SP",
"55333582", "São\ José\ do\ Divino\ \-\ MG",
"55273553", "Guaçuí\ \-\ ES",
"55333215", "Governador\ Valadares\ \-\ MG",
"55673274", "Figueirão\ \-\ MS",
"55553290", "Santa\ Maria\ \-\ RS",
"559132", "Belém\ \-\ PA",
"55513274", "Rio\ Grande\ do\ Sul",
"55863332", "Caxingó\ \-\ PI",
"55413539", "Campo\ Largo\ \-\ PR",
"55883404", "Russas\ \-\ CE",
"55153451", "Tatuí\ \-\ SP",
"55993587", "São\ Francisco\ do\ Brejão\ \-\ MA",
"55633470", "Santa\ Fé\ do\ Araguaia\ \-\ TO",
"55823295", "São\ Miguel\ dos\ Milagres\ \-\ AL",
"55163348", "Motuca\ \-\ SP",
"55313260", "Minas\ Gerais",
"55673226", "Ladário\ \-\ MS",
"55323265", "Descoberto\ \-\ MG",
"55753636", "Nazaré\ \-\ BA",
"55433549", "Bandeirantes\ \-\ PR",
"5511433", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55493363", "Bom\ Jesus\ do\ Oeste\ \-\ SC",
"55493907", "Lages\ \-\ SC",
"55683211", "Rio\ Branco\ \-\ AC",
"55883431", "Itapiúna\ \-\ CE",
"55753681", "Cabaceiras\ do\ Paraguaçu\ \-\ BA",
"55543244", "São\ Francisco\ de\ Paula\ \-\ RS",
"5571324", "Salvador\ \-\ BA",
"55212728", "São\ Gonçalo\ \-\ RJ",
"5521345", "Rio\ de\ Janeiro\ \-\ RJ",
"55513065", "Novo\ Hamburgo\ \-\ RS",
"55973356", "Anamã\ \-\ AM",
"55513702", "Rio\ Grande\ do\ Sul",
"55433625", "Cafeara\ \-\ PR",
"5565", "Mato\ Grosso",
"55613718", "Formosa\ \-\ GO",
"55343281", "Tupaciguara\ \-\ MG",
"55713797", "Salvador\ \-\ BA",
"55353463", "Bueno\ Brandão\ \-\ MG",
"55443631", "Cianorte\ \-\ PR",
"55824102", "Centro\ \-\ AL",
"55343236", "Uberlândia\ \-\ MG",
"55833254", "Cruz\ do\ Espírito\ Santo\ \-\ PB",
"55242263", "Paraíba\ do\ Sul\ \-\ RJ",
"55913656", "Santa\ Bárbara\ do\ Pará\ \-\ PA",
"55243111", "Petrópolis\ \-\ RJ",
"55443686", "Palotina\ \-\ PR",
"55213202", "Rio\ de\ Janeiro\ \-\ RJ",
"55423664", "Faxinal\ do\ Céu\ \-\ PR",
"55273753", "Vila\ Pavão\ \-\ ES",
"55513493", "Viamão\ \-\ RS",
"55343812", "Lagamar\ \-\ MG",
"55743656", "Canarana\ \-\ BA",
"55493573", "Calmon\ \-\ SC",
"55443422", "Paranavaí\ \-\ PR",
"55143404", "Tupã\ \-\ SP",
"55382104", "Montes\ Claros\ \-\ MG",
"55213824", "Rio\ de\ Janeiro\ \-\ RJ",
"55653223", "Cáceres\ \-\ MT",
"55413432", "Antonina\ \-\ PR",
"55473375", "Corupá\ \-\ SC",
"55833372", "Cuité\ \-\ PB",
"55633464", "Guaraí\ \-\ TO",
"55193404", "Limeira\ \-\ SP",
"55443573", "Iretama\ \-\ PR",
"55813095", "Caruaru\ \-\ PE",
"55113416", "Taboão\ da\ Serra\ \-\ SP",
"55223321", "Rio\ das\ Ostras\ \-\ RJ",
"55513260", "Rio\ Grande\ do\ Sul",
"55473904", "Itapema\ \-\ SC",
"55673260", "Alcinópolis\ \-\ MS",
"55223861", "Itaocara\ \-\ RJ",
"55843332", "Areia\ Branca\ \-\ RN",
"55823201", "Maceió\ \-\ AL",
"55493631", "São\ Miguel\ do\ Oeste\ \-\ SC",
"55833638", "Nova\ Palmeira\ \-\ PB",
"55323342", "Santa\ Rita\ de\ Ibitipoca\ \-\ MG",
"55813256", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55673483", "Coronel\ Sapucaia\ \-\ MS",
"55513483", "Alvorada\ \-\ RS",
"55433533", "Panema\ \-\ PR",
"55413621", "Colombo\ \-\ PR",
"55943787", "Tucuruí\ \-\ PA",
"55143223", "Bauru\ \-\ SP",
"55213760", "Nilópolis\ \-\ RJ",
"55483478", "Criciúma\ \-\ SC",
"55623425", "São\ Domingos\ \-\ GO",
"55473154", "Rio\ dos\ Cedros\ \-\ SC",
"55622764", "Goiânia\ \-\ GO",
"55953626", "Boa\ Vista\ \-\ RR",
"55853352", "Pentecoste\ \-\ CE",
"55353322", "Seritinga\ \-\ MG",
"55483321", "Florianópolis\ \-\ SC",
"5512388", "Caraguatatuba\ \-\ SP",
"55963117", "Macapá\ \-\ AP",
"55643588", "Itumbiara\ \-\ GO",
"55413675", "Colombo\ \-\ PR",
"55663451", "Dom\ Aquino\ \-\ MT",
"55673409", "Naviraí\ \-\ MS",
"55513409", "Miraguaia\ \-\ RS",
"55112864", "São\ Paulo\ \-\ SP",
"55473565", "Mirim\ Doce\ \-\ SC",
"55514112", "Novo\ Hamburgo\ \-\ RS",
"55343413", "São\ Francisco\ de\ Sales\ \-\ MG",
"55183261", "Ribeirão\ dos\ Índios\ \-\ SP",
"55833562", "Poço\ Dantas\ \-\ PB",
"55173261", "Nova\ Granada\ \-\ SP",
"55114047", "Diadema\ \-\ SP",
"55623398", "Itaguaru\ \-\ GO",
"55833437", "Cajazeirinhas\ \-\ PB",
"55333284", "Frei\ Inocêncio\ \-\ MG",
"55733298", "Prado\ \-\ BA",
"55443626", "Umuarama\ \-\ PR",
"55553266", "Nova\ Palma\ \-\ RS",
"55543433", "Arco\ Verde\ \-\ RS",
"55343221", "Uberlândia\ \-\ MG",
"55313055", "Belo\ Horizonte\ \-\ MG",
"55843251", "São\ Paulo\ do\ Potengi\ \-\ RN",
"55443482", "Paranavaí\ \-\ PR",
"55843477", "Ouro\ Branco\ \-\ RN",
"55114446", "Cajamar\ \-\ SP",
"55443674", "Indianópolis\ \-\ PR",
"55183992", "Narandiba\ \-\ SP",
"55143411", "Jaú\ \-\ SP",
"55154009", "Sorocaba\ \-\ SP",
"55333722", "Mata\ Verde\ \-\ MG",
"55113444", "São\ Paulo\ \-\ SP",
"55693461", "Ouro\ Preto\ do\ Oeste\ \-\ RO",
"55313479", "Minas\ Gerais",
"55753621", "Cruz\ das\ Almas\ \-\ BA",
"55213835", "Rio\ de\ Janeiro\ \-\ RJ",
"55933547", "Óbidos\ \-\ PA",
"55143293", "Guaianás\ \-\ SP",
"55883426", "Banabuiú\ \-\ CE",
"55194007", "Campinas\ \-\ SP",
"55153207", "Gramadinho\ \-\ SP",
"55743620", "São\ Gabriel\ \-\ BA",
"55533241", "Bagé\ \-\ RS",
"55333235", "Tumiritinga\ \-\ MG",
"55843230", "Nísia\ Floresta\ \-\ RN",
"55513822", "Gravataí\ \-\ RS",
"55513362", "Rio\ Grande\ do\ Sul",
"5562331", "Anápolis\ \-\ GO",
"55753432", "Aramari\ \-\ BA",
"55115102", "São\ Paulo\ \-\ SP",
"55173312", "Barretos\ \-\ SP",
"55694009", "Porto\ Velho\ \-\ RO",
"55692181", "Porto\ Velho\ \-\ RO",
"55483381", "São\ José\ \-\ SC",
"55843084", "Natal\ \-\ RN",
"55143283", "Pederneiras\ \-\ SP",
"5519375", "Campinas\ \-\ SP",
"55183608", "Araçatuba\ \-\ SP",
"55473336", "Blumenau\ \-\ SC",
"55153461", "Porto\ Feliz\ \-\ SP",
"55453278", "Toledo\ \-\ PR",
"5542322", "Ponta\ Grossa\ \-\ PR",
"55543449", "Bento\ Gonçalves\ \-\ RS",
"55213745", "Nova\ Iguaçu\ \-\ RJ",
"55883692", "Crateús\ \-\ CE",
"55493482", "Concórdia\ \-\ SC",
"55713651", "São\ Francisco\ do\ Conde\ \-\ BA",
"55893477", "Inhuma\ \-\ PI",
"55493674", "Mondaí\ \-\ SC",
"55773613", "Barreiras\ \-\ BA",
"55133446", "Mongaguá\ \-\ SP",
"55653283", "Comodoro\ \-\ MT",
"55273373", "Linhares\ \-\ ES",
"55333294", "Nacip\ Raydan\ \-\ MG",
"5521271", "Niterói\ \-\ RJ",
"55112335", "São\ Paulo\ \-\ SP",
"55733288", "Porto\ Seguro\ \-\ BA",
"55643461", "Pires\ do\ Rio\ \-\ GO",
"55133219", "Santos\ \-\ SP",
"55673245", "Anastácio\ \-\ MS",
"55313231", "Minas\ Gerais",
"55513423", "Gravataí\ \-\ RS",
"55833459", "Nova\ Olinda\ \-\ PB",
"55213116", "Rio\ de\ Janeiro\ \-\ RJ",
"55123013", "Guaratinguetá\ \-\ SP",
"55493626", "Bandeirante\ \-\ SC",
"55174004", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55623434", "Goiânia\ \-\ GO",
"55113308", "Jundiaí\ \-\ SP",
"55413636", "Balsa\ Nova\ \-\ PR",
"55654007", "Cuiabá\ \-\ MT",
"55433258", "Ibiporã\ \-\ PR",
"55222552", "Santa\ Rita\ da\ Floresta\ \-\ RJ",
"55433428", "Marilândia\ do\ Sul\ \-\ PR",
"55813486", "Recife\ \-\ PE",
"55893421", "Picos\ \-\ PI",
"55213664", "Belford\ Roxo\ \-\ RJ",
"55163463", "Araraquara\ \-\ SP",
"55813431", "Olinda\ \-\ PE",
"5531358", "Minas\ Gerais",
"55793222", "Aracaju\ \-\ SE",
"55833229", "Santa\ Rita\ \-\ PB",
"55513253", "Rio\ Grande\ do\ Sul",
"55114162", "Barueri\ \-\ SP",
"5551379", "Rio\ Grande\ do\ Sul",
"55613702", "Brasília\ \-\ DF",
"55833494", "Diamante\ \-\ PB",
"55213747", "Rio\ de\ Janeiro\ \-\ RJ",
"55923301", "Manaus\ \-\ AM",
"55813622", "Carpina\ \-\ PE",
"55433156", "Rolândia\ \-\ PR",
"55283526", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55123224", "Caçapava\ \-\ SP",
"55733639", "Ilhéus\ \-\ BA",
"55433906", "Rolândia\ \-\ PR",
"5521329", "Rio\ de\ Janeiro\ \-\ RJ",
"55673247", "Costa\ Rica\ \-\ MS",
"55863249", "São\ Miguel\ do\ Tapuio\ \-\ PI",
"55373352", "Arcos\ \-\ MG",
"55423526", "Porto\ União\ \-\ SC",
"55983656", "Governador\ Newton\ Bello\ \-\ MA",
"55153244", "Piedade\ \-\ SP",
"55973379", "Novo\ Aripuanã\ \-\ AM",
"55833077", "Campina\ Grande\ \-\ PB",
"55883085", "Juazeiro\ do\ Norte\ \-\ CE",
"55893475", "Novo\ Oriente\ do\ Piauí\ \-\ PI",
"5555", "Rio\ Grande\ do\ Sul",
"55513718", "Vera\ Cruz\ \-\ RS",
"55313039", "Timóteo\ \-\ MG",
"55163256", "Santa\ Ernestina\ \-\ SP",
"55273364", "Guarapari\ \-\ ES",
"55753381", "Varzedo\ \-\ BA",
"55433561", "Conselheiro\ Mairinck\ \-\ PR",
"55893568", "Palmeira\ do\ Piauí\ \-\ PI",
"55673466", "Glória\ de\ Dourados\ \-\ MS",
"55273711", "Colatina\ \-\ ES",
"55853198", "Fortaleza\ \-\ CE",
"55743541", "Senhor\ do\ Bonfim\ \-\ BA",
"55513466", "Canoas\ \-\ RS",
"55223833", "Bom\ Jesus\ do\ Itabapoana\ \-\ RJ",
"55753336", "Wagner\ \-\ BA",
"55313057", "Belo\ Horizonte\ \-\ MG",
"55753677", "Valença\ \-\ BA",
"55114265", "Itapecerica\ da\ Serra\ \-\ SP",
"55315", "Minas\ Gerais",
"55793541", "Tobias\ Barreto\ \-\ SE",
"55173249", "Potirendaba\ \-\ SP",
"55833435", "Jericó\ \-\ PB",
"55163322", "Araraquara\ \-\ SP",
"55483432", "Içara\ \-\ SC",
"55353431", "Cambuí\ \-\ MG",
"55443663", "Douradina\ \-\ PR",
"55373274", "Papagaios\ \-\ MG",
"55413375", "São\ José\ dos\ Pinhais\ \-\ PR",
"55353622", "Itajubá\ \-\ MG",
"55473621", "Canoinhas\ \-\ SC",
"55613483", "Sobradinho\ \-\ DF",
"55114011", "Piracaia\ \-\ SP",
"55463262", "Palmas\ \-\ PR",
"55373226", "Nova\ Serrana\ \-\ MG",
"55843475", "Equador\ \-\ RN",
"55383226", "Coração\ de\ Jesus\ \-\ MG",
"55424101", "Guarapuava\ \-\ PR",
"55153205", "Tatuí\ \-\ SP",
"55112078", "Barueri\ \-\ SP",
"5531359", "Betim\ \-\ MG",
"55133342", "Guarujá\ \-\ SP",
"55512131", "Porto\ Alegre\ \-\ RS",
"55213837", "Rio\ de\ Janeiro\ \-\ RJ",
"55162109", "Araraquara\ \-\ SP",
"55843421", "Caicó\ \-\ RN",
"55913784", "Portel\ \-\ PA",
"55623628", "Novo\ Gama\ \-\ GO",
"55333237", "Fernandes\ Tourinho\ \-\ MG",
"55833484", "Juru\ \-\ PB",
"55653046", "Cuiabá\ \-\ MT",
"55843378", "São\ Francisco\ do\ Oeste\ \-\ RN",
"55623096", "Goiânia\ \-\ GO",
"55924002", "Manaus\ \-\ AM",
"55483199", "Tubarão\ \-\ SC",
"55543207", "São\ Brás\ \-\ RS",
"55513662", "Santo\ Antônio\ da\ Patrulha\ \-\ RS",
"55643433", "Itumbiara\ \-\ GO",
"55653266", "Pontes\ e\ Lacerda\ \-\ MT",
"55163392", "Américo\ Brasiliense\ \-\ SP",
"55993613", "Grajaú\ \-\ MA",
"55143014", "Bauru\ \-\ SP",
"55473377", "Luiz\ Alves\ \-\ SC",
"55943785", "Novo\ Repartimento\ \-\ PA",
"55633473", "Xambioá\ \-\ TO",
"55313480", "Minas\ Gerais",
"55112523", "São\ Paulo\ \-\ SP",
"55353692", "Itajubá\ \-\ MG",
"55313263", "Belo\ Horizonte\ \-\ MG",
"5518390", "Presidente\ Prudente\ \-\ SP",
"55713501", "Salvador\ \-\ BA",
"55753321", "Feira\ de\ Santana\ \-\ BA",
"55733544", "Planaltino\ \-\ BA",
"55192533", "Piracicaba\ \-\ SP",
"55312111", "Belo\ Horizonte\ \-\ MG",
"55143453", "Marília\ \-\ SP",
"55893436", "Alegrete\ do\ Piauí\ \-\ PI",
"55833289", "Juripiranga\ \-\ PB",
"55693216", "Porto\ Velho\ \-\ RO",
"55313848", "Minas\ Gerais",
"55413391", "Campo\ Largo\ \-\ PR",
"55193852", "Pedreira\ \-\ SP",
"55693449", "Rolim\ de\ Moura\ \-\ RO",
"55323401", "Leopoldina\ \-\ MG",
"55513538", "Canoas\ \-\ RS",
"55313456", "Minas\ Gerais",
"55613362", "Guará\ \-\ DF",
"55183558", "Sagres\ \-\ SP",
"55493252", "Timbó\ Grande\ \-\ SC",
"55454052", "Foz\ do\ Iguaçu\ \-\ PR",
"55544009", "Caxias\ do\ Sul\ \-\ RS",
"55553411", "Uruguaiana\ \-\ RS",
"55283531", "Itapemirim\ \-\ ES",
"55312591", "Betim\ \-\ MG",
"55313128", "Jaboticatubas\ \-\ MG",
"55813474", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55413677", "Campo\ Magro\ \-\ PR",
"55813682", "Joaquim\ Nabuco\ \-\ PE",
"55433334", "Londrina\ \-\ PR",
"55113608", "Osasco\ \-\ SP",
"55193447", "Piracicaba\ \-\ SP",
"55713176", "Salvador\ \-\ BA",
"55443252", "Nova\ Esperança\ \-\ PR",
"55512126", "Porto\ Alegre\ \-\ RS",
"55123132", "Guaratinguetá\ \-\ SP",
"55493905", "Chapecó\ \-\ SC",
"55663542", "Rondolândia\ \-\ MT",
"55493326", "Caxambu\ do\ Sul\ \-\ SC",
"55833299", "Pitimbu\ \-\ PB",
"55343003", "Uberlândia\ \-\ MG",
"55943351", "Palestina\ do\ Pará\ \-\ PA",
"55323267", "São\ João\ Nepomuceno\ \-\ MG",
"55913776", "Santa\ Bárbara\ do\ Pará\ \-\ PA",
"55273745", "Águia\ Branca\ \-\ ES",
"55843436", "São\ Vicente\ \-\ RN",
"55173405", "Votuporanga\ \-\ SP",
"55813692", "Lagoa\ dos\ Gatos\ \-\ PE",
"55433627", "Leópolis\ \-\ PR",
"55913811", "Ipixuna\ do\ Pará\ \-\ PA",
"55833424", "Salgadinho\ \-\ PB",
"55543528", "Itatiba\ do\ Sul\ \-\ RS",
"55513067", "Novo\ Hamburgo\ \-\ RS",
"55323446", "Palma\ \-\ MG",
"55313738", "São\ Brás\ do\ Suaçuí\ \-\ MG",
"55913724", "Benevides\ \-\ PA",
"5511518", "São\ Paulo\ \-\ SP",
"55543461", "Carlos\ Barbosa\ \-\ RS",
"55633522", "Lagoa\ do\ Tocantins\ \-\ TO",
"55112684", "São\ Paulo\ \-\ SP",
"55493564", "Rio\ das\ Antas\ \-\ SC",
"55222762", "Macaé\ \-\ RJ",
"55463311", "Pato\ Branco\ \-\ PR",
"55163382", "Matão\ \-\ SP",
"55963212", "Macapá\ \-\ AP",
"55353426", "Senador\ José\ Bento\ \-\ MG",
"55193453", "Limeira\ \-\ SP",
"55623086", "Goiânia\ \-\ GO",
"55163025", "Franca\ \-\ SP",
"55554007", "Santa\ Maria\ \-\ RS",
"55373286", "São\ Sebastião\ do\ Oeste\ \-\ MG",
"55483953", "Florianópolis\ \-\ SC",
"55373231", "Pará\ de\ Minas\ \-\ MG",
"55313490", "Minas\ Gerais",
"55383231", "Brasília\ de\ Minas\ \-\ MG",
"55453232", "Guaraniaçu\ \-\ PR",
"55114031", "Bragança\ Paulista\ \-\ SP",
"55673456", "Nova\ Alvorada\ do\ Sul\ \-\ MS",
"55313538", "Esmeraldas\ \-\ MG",
"55513456", "Canoas\ \-\ RS",
"55213763", "Mesquita\ \-\ RJ",
"55493653", "Anchieta\ \-\ SC",
"55283545", "Iúna\ \-\ ES",
"55163266", "Borborema\ \-\ SP",
"55273354", "Viana\ \-\ ES",
"5551352", "Rio\ Grande\ do\ Sul",
"55893558", "São\ Francisco\ do\ Piauí\ \-\ PI",
"55993534", "Davinópolis\ \-\ MA",
"55433551", "Ribeirão\ do\ Pinhal\ \-\ PR",
"55173481", "São\ João\ das\ Duas\ Pontes\ \-\ SP",
"55713115", "Salvador\ \-\ BA",
"55623004", "Goiânia\ \-\ GO",
"55953262", "Normandia\ \-\ RR",
"55733536", "Santa\ Inês\ \-\ BA",
"55353411", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"55344009", "Uberlândia\ \-\ MG",
"55513128", "Gravataí\ \-\ RS",
"55843405", "Currais\ Novos\ \-\ RN",
"55484109", "Biguaçu\ \-\ SC",
"55814007", "Recife\ \-\ PE",
"55383822", "Janaúba\ \-\ MG",
"55463905", "Francisco\ Beltrão\ \-\ PR",
"55873852", "Betânia\ \-\ PE",
"55663433", "Primavera\ do\ Leste\ \-\ MT",
"55153275", "Itapetininga\ \-\ SP",
"55353293", "Areado\ \-\ MG",
"55714111", "Camaçari\ \-\ BA",
"55163014", "Araraquara\ \-\ SP",
"55493647", "Palmitos\ \-\ SC",
"55313662", "Pedro\ Leopoldo\ \-\ MG",
"55243357", "Resende\ \-\ RJ",
"55983393", "Luís\ Domingues\ \-\ MA",
"55893444", "Dom\ Expedito\ Lopes\ \-\ PI",
"55913366", "Belém\ \-\ PA",
"55613055", "Brasília\ \-\ DF",
"55463564", "Salgado\ Filho\ \-\ PR",
"55493311", "Chapecó\ \-\ SC",
"55513263", "Rio\ Grande\ do\ Sul",
"55823297", "Japaratinga\ \-\ AL",
"55114688", "Barueri\ \-\ SP",
"55993212", "Timon\ \-\ MA",
"555138", "Rio\ Grande\ do\ Sul",
"55673480", "Paranhos\ \-\ MS",
"55613479", "Brazlândia\ \-\ DF",
"55513480", "Guaíba\ \-\ RS",
"55553426", "Alegrete\ \-\ RS",
"55983383", "São\ Bento\ \-\ MA",
"55443311", "Jardim\ Olinda\ \-\ PR",
"55242483", "Miguel\ Pereira\ \-\ RJ",
"55143382", "Fartura\ \-\ SP",
"55153542", "Capão\ Bonito\ \-\ SP",
"55433301", "Londrina\ \-\ PR",
"55353283", "Poço\ Fundo\ \-\ MG",
"55143025", "Lins\ \-\ SP",
"55413555", "Campo\ Largo\ \-\ PR",
"55114427", "Santo\ André\ \-\ SP",
"55793366", "Brejo\ Grande\ \-\ SE",
"55633429", "Muricilândia\ \-\ TO",
"55513490", "Gravataí\ \-\ RS",
"55813411", "Belo\ Jardim\ \-\ PE",
"55373423", "Tapiraí\ \-\ MG",
"55733667", "Itamaraju\ \-\ BA",
"55423272", "Telêmaco\ Borba\ \-\ PR",
"55823287", "Capela\ \-\ AL",
"55443647", "Maripá\ \-\ PR",
"55115029", "São\ Paulo\ \-\ SP",
"55463252", "Clevelândia\ \-\ PR",
"55112641", "São\ Paulo\ \-\ SP",
"55273272", "Guarapari\ \-\ ES",
"55653382", "Campo\ Novo\ do\ Parecis\ \-\ MT",
"55114096", "São\ Paulo\ \-\ SP",
"5511461", "Cotia\ \-\ SP",
"55643542", "Itumbiara\ \-\ GO",
"55653025", "Cuiabá\ \-\ MT",
"55112829", "Santo\ André\ \-\ SP",
"55123522", "Pindamonhangaba\ \-\ SP",
"55714062", "Salvador\ \-\ BA",
"55443653", "Tuneiras\ do\ Oeste\ \-\ PR",
"55652123", "Cuiabá\ \-\ MT",
"55513738", "Venâncio\ Aires\ \-\ RS",
"55163852", "Sales\ Oliveira\ \-\ SP",
"55883447", "Limoeiro\ do\ Norte\ \-\ CE",
"55933526", "Alenquer\ \-\ PA",
"55542105", "Bento\ Gonçalves\ \-\ RS",
"55313067", "Itabira\ \-\ MG",
"55473644", "Rio\ Negrinho\ \-\ SC",
"55112317", "São\ Paulo\ \-\ SP",
"55114255", "Mogi\ das\ Cruzes\ \-\ SP",
"55483644", "Laguna\ \-\ SC",
"5535", "Minas\ Gerais",
"55843249", "Espírito\ Santo\ \-\ RN",
"55313718", "Baldim\ \-\ MG",
"55793114", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55624015", "Anápolis\ \-\ GO",
"55423560", "Fluviópolis\ \-\ PR",
"55443448", "Marilena\ \-\ PR",
"55114497", "Jundiaí\ \-\ SP",
"55743535", "Remanso\ \-\ BA",
"55993649", "Peritoró\ \-\ MA",
"55454062", "Cascavel\ \-\ PR",
"55553279", "Quevedos\ \-\ RS",
"55734141", "Itabuna\ \-\ BA",
"55613352", "Taguatinga\ \-\ DF",
"55473557", "Imbuia\ \-\ SC",
"55313247", "Belo\ Horizonte\ \-\ MG",
"55123112", "Potim\ \-\ SP",
"55473018", "Gaspar\ \-\ SC",
"55173475", "Meridiano\ \-\ SP",
"55483018", "Florianópolis\ \-\ SC",
"55313466", "Belo\ Horizonte\ \-\ MG",
"55513420", "Rio\ Grande\ do\ Sul",
"55152107", "Porto\ Feliz\ \-\ SP",
"55513039", "Sapiranga\ \-\ RS",
"55733575", "Arraial\ d\'Ajuda\ \-\ BA",
"55512104", "Porto\ Alegre\ \-\ RS",
"55193862", "Mogi\ Mirim\ \-\ SP",
"55493304", "Chapecó\ \-\ SC",
"55983462", "Cantanhede\ \-\ MA",
"55114026", "Itu\ \-\ SP",
"55153281", "Araçoiaba\ da\ Serra\ \-\ SP",
"55313253", "Belo\ Horizonte\ \-\ MG",
"55473543", "Rio\ do\ Oeste\ \-\ SC",
"55213303", "Duque\ de\ Caxias\ \-\ RJ",
"55273136", "Cariacica\ \-\ ES",
"55212742", "Teresópolis\ \-\ RJ",
"55173632", "Jales\ \-\ SP",
"55443554", "Assis\ Chateaubriand\ \-\ PR",
"55273181", "Vitória\ \-\ ES",
"55883648", "Uruoca\ \-\ CE",
"55693413", "Urupá\ \-\ RO",
"55553027", "Santa\ Maria\ \-\ RS",
"55713633", "Vera\ Cruz\ \-\ BA",
"55753344", "Palmeiras\ \-\ BA",
"55283560", "Alegre\ \-\ ES",
"5511364", "São\ Paulo\ \-\ SP",
"55813445", "Recife\ \-\ PE",
"55173421", "Votuporanga\ \-\ SP",
"55183421", "Assis\ \-\ SP",
"55933596", "São\ José\ \-\ PA",
"55993571", "Porto\ Franco\ \-\ MA",
"5531379", "Minas\ Gerais",
"55513652", "Butiá\ \-\ RS",
"55273726", "Pancas\ \-\ ES",
"55493700", "Chapecó\ \-\ SC",
"55513043", "Gravataí\ \-\ RS",
"55673043", "Campo\ Grande\ \-\ MS",
"55192513", "Campinas\ \-\ SP",
"5581", "Pernambuco",
"55323425", "Santana\ de\ Cataguases\ \-\ MG",
"55833273", "Alagoa\ Grande\ \-\ PB",
"55613502", "Luziânia\ \-\ GO",
"55473307", "Jaraguá\ do\ Sul\ \-\ SC",
"55643054", "Rio\ Verde\ \-\ GO",
"55153291", "Araçoiaba\ da\ Serra\ \-\ SP",
"55653322", "Cuiabá\ \-\ MT",
"55533237", "Povo\ Novo\ \-\ RS",
"55142109", "Bauru\ \-\ SP",
"5531378", "Minas\ Gerais",
"55993633", "Lagoa\ Grande\ do\ Maranhão\ \-\ MA",
"55193463", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55773661", "Candiba\ \-\ BA",
"55543451", "Bento\ Gonçalves\ \-\ RS",
"55493345", "Santiago\ do\ Sul\ \-\ SC",
"55493554", "Herval\ D\'Oeste\ \-\ SC",
"55933531", "Medicilândia\ \-\ PA",
"55423511", "Santo\ Antônio\ do\ Iratim\ \-\ PR",
"55643413", "Morrinhos\ \-\ GO",
"5531380", "Minas\ Gerais",
"55613274", "Brasília\ \-\ DF",
"55283511", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55553431", "São\ Borja\ \-\ RS",
"55353223", "Varginha\ \-\ MG",
"55114487", "Itatiba\ \-\ SP",
"55213553", "Rio\ de\ Janeiro\ \-\ RJ",
"55112783", "São\ Paulo\ \-\ SP",
"55983323", "Centro\ do\ Guilherme\ \-\ MA",
"55515", "Rio\ Grande\ do\ Sul",
"55112803", "Carapicuíba\ \-\ SP",
"55713649", "Camaçari\ \-\ BA",
"55443304", "Maringá\ \-\ PR",
"55513057", "Montenegro\ \-\ RS",
"55143322", "Ourinhos\ \-\ SP",
"55913741", "Soure\ \-\ PA",
"55733242", "Ibicaraí\ \-\ BA",
"55623342", "Ipiranga\ de\ Goiás\ \-\ GO",
"55323257", "Juiz\ de\ Fora\ \-\ MG",
"55693236", "Porto\ Velho\ \-\ RO",
"55413607", "Araucária\ \-\ PR",
"55833441", "Catolé\ do\ Rocha\ \-\ PB",
"55493448", "Arabutã\ \-\ SC",
"55483539", "São\ João\ do\ Sul\ \-\ SC",
"55353445", "Borda\ da\ Mata\ \-\ MG",
"55733012", "Porto\ Seguro\ \-\ BA",
"55463232", "Coronel\ Vivida\ \-\ PR",
"55513491", "Guaíba\ \-\ RS",
"55273751", "Mucurici\ \-\ ES",
"55212648", "Maricá\ \-\ RJ",
"55623522", "Goiânia\ \-\ GO",
"55814009", "Recife\ \-\ PE",
"55115486", "São\ Paulo\ \-\ SP",
"55484107", "Palhoça\ \-\ SC",
"55513758", "Capitão\ \-\ RS",
"55163832", "Ipuã\ \-\ SP",
"55443633", "São\ João\ \-\ PR",
"55353461", "Bom\ Repouso\ \-\ MG",
"55483462", "Criciúma\ \-\ SC",
"55753609", "Bravo\ \-\ BA",
"55343283", "Monte\ Alegre\ de\ Minas\ \-\ MG",
"55953212", "Boa\ Vista\ \-\ RR",
"55143542", "Promissão\ \-\ SP",
"55943345", "Jacundá\ \-\ PA",
"55843538", "Fernando\ Pedroza\ \-\ RN",
"55413584", "Curitiba\ \-\ PR",
"55913765", "Salvaterra\ \-\ PA",
"55643071", "Rio\ Verde\ \-\ GO",
"55823299", "Atalaia\ \-\ AL",
"55863263", "Cocal\ de\ Telha\ \-\ PI",
"55333267", "Aimorés\ \-\ MG",
"55493525", "Catanduvas\ \-\ SC",
"55413535", "Curitiba\ \-\ PR",
"55114284", "Mogi\ das\ Cruzes\ \-\ SP",
"55883433", "Aracati\ \-\ CE",
"55843662", "Natal\ \-\ RN",
"55673213", "Campo\ Grande\ \-\ MS",
"55683213", "Rio\ Branco\ \-\ AC",
"55273395", "Vitória\ \-\ ES",
"55493361", "Chapecó\ \-\ SC",
"55833368", "Areial\ \-\ PB",
"55773645", "Boquira\ \-\ BA",
"55823424", "Major\ Isidoro\ \-\ AL",
"55753683", "Humildes\ \-\ BA",
"55493649", "Barra\ Bonita\ \-\ SC",
"55543908", "Vacaria\ \-\ RS",
"55693025", "Porto\ Velho\ \-\ RO",
"55633427", "Pequizeiro\ \-\ TO",
"55443361", "Umuarama\ \-\ PR",
"55313444", "Belo\ Horizonte\ \-\ MG",
"55173263", "Mirassolândia\ \-\ SP",
"55793316", "Nossa\ Senhora\ de\ Lourdes\ \-\ SE",
"55183263", "Santo\ Anastácio\ \-\ SP",
"55343411", "Iturama\ \-\ MG",
"55443649", "Palotina\ \-\ PR",
"55823289", "Santana\ do\ Mundaú\ \-\ AL",
"55753693", "Pintadas\ \-\ BA",
"55733617", "Itabuna\ \-\ BA",
"55443525", "Campo\ Mourão\ \-\ PR",
"55273120", "Colatina\ \-\ ES",
"55423334", "Maceió\ \-\ AL",
"55114132", "Pirapora\ do\ Bom\ Jesus\ \-\ SP",
"55223717", "Macaé\ \-\ RJ",
"55143221", "Marília\ \-\ SP",
"55273385", "Serra\ \-\ ES",
"55653275", "Glória\ D\'Oeste\ \-\ MT",
"55414116", "Curitiba\ \-\ PR",
"55213634", "Rio\ Bonito\ \-\ RJ",
"55423915", "Carambeí\ \-\ PR",
"55493633", "Santa\ Helena\ \-\ SC",
"55823203", "Ibateguara\ \-\ AL",
"55223863", "Jaguarembé\ \-\ RJ",
"55483248", "Florianópolis\ \-\ SC",
"55513436", "Viamão\ \-\ RS",
"55193542", "Araras\ \-\ SP",
"55313558", "Mariana\ \-\ MG",
"55893538", "Colônia\ do\ Gurguéia\ \-\ PI",
"55483717", "Florianópolis\ \-\ SC",
"55433531", "Santa\ Mariana\ \-\ PR",
"55993554", "Paraibano\ \-\ MA",
"55413623", "Quitandinha\ \-\ PR",
"55112319", "São\ Paulo\ \-\ SP",
"55513481", "Eldorado\ do\ Sul\ \-\ RS",
"55122139", "São\ José\ dos\ Campos\ \-\ SP",
"55123004", "São\ José\ dos\ Campos\ \-\ SP",
"55673481", "Amambaí\ \-\ MS",
"55883449", "Senador\ Pompeu\ \-\ CE",
"55693912", "Espigão\ do\ Oeste\ \-\ RO",
"5598308", "São\ Luís\ \-\ MA",
"55733556", "Lajedo\ do\ Tabocal\ \-\ BA",
"55173848", "Gastão\ Vidigal\ \-\ SP",
"55153392", "Itapetininga\ \-\ SP",
"55653221", "Cáceres\ \-\ MT",
"55112827", "São\ Paulo\ \-\ SP",
"55143275", "Paulistânia\ \-\ SP",
"55443571", "Luiziana\ \-\ PR",
"55613084", "Luziânia\ \-\ GO",
"55623473", "Iaciara\ \-\ GO",
"55633497", "Tupirama\ \-\ TO",
"55993311", "Açailândia\ \-\ MA",
"55413146", "São\ José\ dos\ Pinhais\ \-\ PR",
"55313768", "Contagem\ \-\ MG",
"55115908", "São\ Paulo\ \-\ SP",
"55823338", "Maceió\ \-\ AL",
"55923545", "Boa\ Vista\ do\ Ramos\ \-\ AM",
"55513037", "São\ Leopoldo\ \-\ RS",
"55115097", "São\ Paulo\ \-\ SP",
"55434101", "Apucarana\ \-\ PR",
"55143291", "Domélia\ \-\ SP",
"55843247", "Pedro\ Velho\ \-\ RN",
"55653054", "Cuiabá\ \-\ MT",
"55553798", "Rodeio\ Bonito\ \-\ RS",
"55753623", "Feira\ de\ Santana\ \-\ BA",
"55313249", "Belo\ Horizonte\ \-\ MG",
"55193812", "Cosmópolis\ \-\ SP",
"55533243", "Dom\ Pedrito\ \-\ RS",
"55993647", "Igarapé\ Grande\ \-\ MA",
"55553277", "São\ Martinho\ da\ Serra\ \-\ RS",
"55473393", "Bombinhas\ \-\ SC",
"55793344", "Neópolis\ \-\ SE",
"55453262", "Matelândia\ \-\ PR",
"55143413", "Marília\ \-\ SP",
"55543622", "Passo\ Fundo\ \-\ RS",
"55373261", "Lagoa\ da\ Prata\ \-\ MG",
"55213917", "Maricá\ \-\ RJ",
"55973412", "Tabatinga\ \-\ AM",
"55623582", "Goiânia\ \-\ GO",
"55413576", "Curitiba\ \-\ PR",
"55833440", "Brejo\ dos\ Santos\ \-\ PB",
"55963326", "Ferreira\ Gomes\ \-\ AP",
"555139", "Rio\ Grande\ do\ Sul",
"55693463", "Mirante\ da\ Serra\ \-\ RO",
"55633026", "Palmas\ \-\ TO",
"55653291", "Cáceres\ \-\ MT",
"55553430", "São\ Borja\ \-\ RS",
"55453304", "Cascavel\ \-\ PR",
"55192107", "Indaiatuba\ \-\ SP",
"55113502", "São\ Paulo\ \-\ SP",
"55533257", "Piratini\ \-\ RS",
"55843253", "Bom\ Jesus\ \-\ RN",
"55173043", "Barretos\ \-\ SP",
"55493534", "Ibiam\ \-\ SC",
"55222732", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55112897", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55373015", "Divinópolis\ \-\ MG",
"55183652", "Penápolis\ \-\ SP",
"55123011", "Taubaté\ \-\ SP",
"55142107", "Bauru\ \-\ SP",
"55513421", "Gravataí\ \-\ RS",
"55313233", "Minas\ Gerais",
"55863198", "Teresina\ \-\ PI",
"55433526", "Santana\ do\ Itararé\ \-\ PR",
"55623592", "Goiânia\ \-\ GO",
"55423906", "Castro\ \-\ PR",
"55153256", "Campina\ do\ Monte\ Alegre\ \-\ SP",
"55443534", "Mariluz\ \-\ PR",
"55773611", "Barreiras\ \-\ BA",
"55112887", "Itaquaquecetuba\ \-\ SP",
"55543279", "Linha\ Oitenta\ \-\ RS",
"55613024", "Brasília\ \-\ DF",
"55513632", "Montenegro\ \-\ RS",
"55163244", "Monte\ Alto\ \-\ SP",
"55112707", "São\ Paulo\ \-\ SP",
"5534", "Minas\ Gerais",
"55473309", "Blumenau\ \-\ SC",
"55123972", "Santa\ Branca\ \-\ SP",
"55114403", "Itu\ \-\ SP",
"55273371", "Linhares\ \-\ ES",
"55182104", "Presidente\ Prudente\ \-\ SP",
"55163952", "Pitangueiras\ \-\ SP",
"55472122", "Balneário\ Camboriú\ \-\ SC",
"55463546", "Nova\ Esperança\ do\ Sudoeste\ \-\ PR",
"55693322", "Vilhena\ \-\ RO",
"55473537", "Chapadão\ do\ Lageado\ \-\ SC",
"55513475", "Canoas\ \-\ RS",
"55133499", "Praia\ Grande\ \-\ SP",
"55673475", "Japorã\ \-\ MS",
"55433711", "Cambé\ \-\ PR",
"55483537", "Meleiro\ \-\ SC",
"55143812", "São\ Manuel\ \-\ SP",
"55613332", "Recanto\ das\ Emas\ \-\ DF",
"55333414", "Divinolândia\ de\ Minas\ \-\ MG",
"55623010", "Senador\ Canedo\ \-\ GO",
"55633487", "São\ Bento\ do\ Tocantins\ \-\ TO",
"55473383", "Ascurra\ \-\ SC",
"55133224", "Santos\ \-\ SP",
"55692183", "Ji\-Paraná\ \-\ RO",
"55943311", "Parauapebas\ \-\ PA",
"55513568", "São\ Leopoldo\ \-\ RS",
"55114489", "Francisco\ Morato\ \-\ SP",
"55273325", "Vitória\ \-\ ES",
"55433202", "Apucarana\ \-\ PR",
"55453345", "Portão\ Ocoi\ \-\ PR",
"55513059", "Canoas\ \-\ RS",
"55273082", "Vitória\ \-\ ES",
"55713647", "Catu\ \-\ BA",
"55143281", "Bauru\ \-\ SP",
"55913344", "Belém\ \-\ PA",
"55853475", "Caucaia\ \-\ CE",
"55163413", "São\ Carlos\ \-\ SP",
"55323464", "Estrela\ Dalva\ \-\ MG",
"553139", "Minas\ Gerais",
"55193000", "Vinhedo\ \-\ SP",
"55113409", "Suzano\ \-\ SP",
"55112507", "São\ Paulo\ \-\ SP",
"55943326", "Rondon\ do\ Pará\ \-\ PA",
"55213857", "São\ Gonçalo\ \-\ RJ",
"55333328", "Alvarenga\ \-\ MG",
"55833358", "Barra\ de\ São\ Miguel\ \-\ PB",
"55413134", "São\ José\ dos\ Pinhais\ \-\ PR",
"55493351", "Entre\ Rios\ \-\ SC",
"55274002", "Vitória\ \-\ ES",
"55613261", "Brasília\ \-\ DF",
"55543445", "Fagundes\ Varela\ \-\ RS",
"55343431", "Prata\ \-\ MG",
"55863253", "Juazeiro\ do\ Piauí\ \-\ PI",
"55643648", "Itajá\ \-\ GO",
"55743677", "Ponto\ Novo\ \-\ BA",
"55413292", "Campo\ Largo\ \-\ PR",
"55212025", "Rio\ de\ Janeiro\ \-\ RJ",
"55913755", "Igarapé\-Miri\ \-\ PA",
"55242251", "Três\ Rios\ \-\ RJ",
"55823273", "Coruripe\ \-\ AL",
"5582332", "Maceió\ \-\ AL",
"55473452", "Araquari\ \-\ SC",
"55773626", "Wanderley\ \-\ BA",
"55513768", "Rio\ Grande\ do\ Sul",
"55333425", "Braúnas\ \-\ MG",
"55353451", "Silvianópolis\ \-\ MG",
"55833455", "Santana\ de\ Mangueira\ \-\ PB",
"55114592", "Itupeva\ \-\ SP",
"55543348", "Água\ Santa\ \-\ RS",
"55433511", "Jacarezinho\ \-\ PR",
"55493546", "Monte\ Carlo\ \-\ SC",
"55273314", "Vitória\ \-\ ES",
"55333243", "Central\ de\ Minas\ \-\ MG",
"55923531", "Barreirinha\ \-\ AM",
"55863247", "Castelo\ do\ Piauí\ \-\ PI",
"55123026", "Taubaté\ \-\ SP",
"55353798", "Areado\ \-\ MG",
"55493330", "Chapecó\ \-\ SC",
"55773674", "Ibipitanga\ \-\ BA",
"55513416", "Capão\ da\ Canoa\ \-\ RS",
"55983377", "Nova\ Olinda\ do\ Maranhão\ \-\ MA",
"55273761", "São\ Mateus\ \-\ ES",
"55673416", "Dourados\ \-\ MS",
"55443546", "Quarto\ Centenário\ \-\ PR",
"55373332", "São\ Francisco\ de\ Paula\ \-\ MG",
"55173466", "Cardoso\ \-\ SP",
"55983681", "Santa\ Inês\ \-\ MA",
"55222668", "Silva\ Jardim\ \-\ RJ",
"55993564", "Governador\ Eugênio\ Barros\ \-\ MA",
"55773492", "Presidente\ Jânio\ Quadros\ \-\ BA",
"5571340", "Salvador\ \-\ BA",
"55112228", "Santo\ André\ \-\ SP",
"55653102", "Nobres\ \-\ MT",
"55163236", "Ribeirão\ Preto\ \-\ SP",
"55383678", "Riachinho\ \-\ MG",
"55653244", "Jauru\ \-\ MT",
"5531334", "Minas\ Gerais",
"55923673", "Manaus\ \-\ AM",
"55133592", "Praia\ Grande\ \-\ SP",
"55643932", "Itumbiara\ \-\ GO",
"55213733", "Rio\ de\ Janeiro\ \-\ RJ",
"55953194", "Boa\ Vista\ \-\ RR",
"55223853", "Santo\ Antônio\ de\ Pádua\ \-\ RJ",
"55114061", "Diadema\ \-\ SP",
"55843198", "Natal\ \-\ RN",
"55313378", "Belo\ Horizonte\ \-\ MG",
"55433560", "Cornélio\ Procópio\ \-\ PR",
"55162107", "São\ Carlos\ \-\ SP",
"55883413", "Fortim\ \-\ CE",
"55683233", "Porto\ Acre\ \-\ AC",
"55463534", "São\ Jorge\ D\'Oeste\ \-\ PR",
"5554", "Rio\ Grande\ do\ Sul",
"55173253", "Mirassol\ \-\ SP",
"55413282", "São\ José\ dos\ Pinhais\ \-\ PR",
"55223847", "Raposo\ \-\ RJ",
"55143102", "Bauru\ \-\ SP",
"5521260", "São\ Gonçalo\ \-\ RJ",
"55993326", "Timon\ \-\ MA",
"55213839", "Rio\ de\ Janeiro\ \-\ RJ",
"55663463", "Primavera\ do\ Leste\ \-\ MT",
"55443351", "Cianorte\ \-\ PR",
"55773686", "Serra\ Dourada\ \-\ BA",
"55513612", "Doutor\ Ricardo\ \-\ RS",
"55683612", "Sena\ Madureira\ \-\ AC",
"55843263", "Touros\ \-\ RN",
"55113423", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55553528", "Campo\ Novo\ \-\ RS",
"55352105", "Varginha\ \-\ MG",
"55993663", "Presidente\ Dutra\ \-\ MA",
"55753282", "Paulo\ Afonso\ \-\ BA",
"55832101", "Campina\ Grande\ \-\ PB",
"55533267", "Herval\ \-\ RS",
"55163172", "Igarapava\ \-\ SP",
"55813099", "Olinda\ \-\ PE",
"55223058", "Cabo\ Frio\ \-\ RJ",
"55483656", "Sangão\ \-\ SC",
"55383251", "Bocaiúva\ \-\ MG",
"55114473", "Santo\ André\ \-\ SP",
"55453252", "Toledo\ \-\ PR",
"55473379", "Massaranduba\ \-\ SC",
"55873221", "Garanhuns\ \-\ PE",
"55883221", "Juazeiro\ do\ Norte\ \-\ CE",
"55443232", "Marialva\ \-\ PR",
"55943386", "Lindoeste\ \-\ PA",
"55414121", "Fazenda\ Rio\ Grande\ \-\ PR",
"55423301", "Ponta\ Grossa\ \-\ PR",
"55133872", "Sete\ Barras\ \-\ SP",
"55213601", "Niterói\ \-\ RJ",
"55114241", "Embu\ das\ Artes\ \-\ SP",
"55413679", "Campina\ Grande\ do\ Sul\ \-\ PR",
"55943331", "São\ Geraldo\ do\ Araguaia\ \-\ PA",
"55123152", "Lorena\ \-\ SP",
"55673405", "Vista\ Alegre\ \-\ MS",
"55313491", "Minas\ Gerais",
"55544007", "Caxias\ do\ Sul\ \-\ RS",
"55513405", "Rio\ Grande\ do\ Sul",
"55112655", "São\ Paulo\ \-\ SP",
"55343426", "Pirajuba\ \-\ MG",
"55833287", "Mari\ \-\ PB",
"55333434", "São\ Pedro\ do\ Suaçuí\ \-\ MG",
"55433272", "Jaguapitã\ \-\ PR",
"55543283", "Caxias\ do\ Sul\ \-\ RS",
"55813728", "Bezerros\ \-\ PE",
"55693447", "Parecis\ \-\ RO",
"55313758", "Minas\ Gerais",
"55623429", "Posse\ \-\ GO",
"55613608", "Novo\ Gama\ \-\ GO",
"55923364", "Caapiranga\ \-\ AM",
"55323748", "Pedra\ Dourada\ \-\ MG",
"55893456", "Simões\ \-\ PI",
"55713500", "Salvador\ \-\ BA",
"55313436", "Minas\ Gerais",
"55513558", "Rio\ Grande\ do\ Sul",
"55113362", "São\ Paulo\ \-\ SP",
"55643447", "Corumbaíba\ \-\ GO",
"55753320", "Itaeté\ \-\ BA",
"55114206", "Jandira\ \-\ SP",
"55383084", "Montes\ Claros\ \-\ MG",
"55493232", "Bom\ Jardim\ da\ Serra\ \-\ SC",
"55543293", "Antônio\ Prado\ \-\ RS",
"55433545", "Curiúva\ \-\ PR",
"55163275", "Taiaçu\ \-\ SP",
"55813138", "Caruaru\ \-\ PE",
"55213513", "Rio\ de\ Janeiro\ \-\ RJ",
"55433354", "Londrina\ \-\ PR",
"55853213", "Caucaia\ \-\ CE",
"55833297", "Mataraca\ \-\ PB",
"55713396", "Simões\ Filho\ \-\ BA",
"55283551", "Divino\ de\ São\ Lourenço\ \-\ ES",
"55883542", "Missão\ Velha\ \-\ CE",
"55492049", "Chapecó\ \-\ SC",
"55643453", "Caldas\ Novas\ \-\ GO",
"55983621", "Bacabal\ \-\ MA",
"55423551", "Santana\ \-\ PR",
"55453326", "Cascavel\ \-\ PR",
"55673444", "Taquarussu\ \-\ MS",
"55513444", "Viamão\ \-\ RS",
"55113572", "São\ Paulo\ \-\ SP",
"55442033", "Palotina\ \-\ PR",
"55463525", "Marmeleiro\ \-\ PR",
"55643014", "Jataí\ \-\ GO",
"55163221", "Matão\ \-\ SP",
"55153266", "Iperó\ \-\ SP",
"55143433", "Marília\ \-\ SP",
"55613041", "Brasília\ \-\ DF",
"55982016", "São\ Luís\ \-\ MA",
"55893480", "Socorro\ do\ Piauí\ \-\ PI",
"55173662", "Santa\ Salete\ \-\ SP",
"55673261", "Bandeirantes\ \-\ MS",
"55683261", "Humaitá\ \(Pad\ Humaitá\)\ \-\ AC",
"55493313", "Chapecó\ \-\ SC",
"5569", "Rondônia",
"55853332", "Redenção\ \-\ CE",
"55342109", "Araguari\ \-\ MG",
"5513335", "Guarujá\ \-\ SP",
"55714113", "Lauro\ de\ Freitas\ \-\ BA",
"55663431", "Guiratinga\ \-\ MT",
"55192121", "Campinas\ \-\ SP",
"55353291", "Alfenas\ \-\ MG",
"55273268", "Domingos\ Martins\ \-\ ES",
"55833295", "Jacaraú\ \-\ PB",
"55212682", "Seropédica\ \-\ RJ",
"55533342", "Pelotas\ \-\ RS",
"55433547", "Figueira\ \-\ PR",
"55983391", "Cururupu\ \-\ MA",
"55323061", "Juiz\ de\ Fora\ \-\ MG",
"55973391", "Tapauá\ \-\ AM",
"55663486", "Pedra\ Preta\ \-\ MT",
"55115852", "São\ Paulo\ \-\ SP",
"55242491", "Vassouras\ \-\ RJ",
"55873788", "Angelim\ \-\ PE",
"5511450", "São\ Paulo\ \-\ SP",
"55353413", "Passos\ \-\ MG",
"55713626", "Camaçari\ \-\ BA",
"55413452", "Matinhos\ \-\ PR",
"55173483", "Nova\ Luzitânia\ \-\ SP",
"55543046", "Passo\ Fundo\ \-\ RS",
"55813236", "Recife\ \-\ PE",
"55343322", "Uberaba\ \-\ MG",
"55213761", "Nilópolis\ \-\ RJ",
"55753690", "Capela\ do\ Alto\ Alegre\ \-\ BA",
"55333628", "Umburatiba\ \-\ MG",
"55114033", "Bragança\ Paulista\ \-\ SP",
"55813281", "Recife\ \-\ PE",
"55433553", "Nova\ América\ da\ Colina\ \-\ PR",
"55463527", "Francisco\ Beltrão\ \-\ PR",
"55993492", "Lagoa\ do\ Mato\ \-\ MA",
"55433399", "Tamarana\ \-\ PR",
"55222009", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55652121", "Cuiabá\ \-\ MT",
"55533265", "Chuí\ \-\ RS",
"55863260", "Demerval\ Lobão\ \-\ PI",
"55993626", "Pedreiras\ \-\ MA",
"55643404", "Itumbiara\ \-\ GO",
"55352107", "Poços\ de\ Caldas\ \-\ MG",
"55313332", "Minas\ Gerais",
"55733676", "Barrolândia\ \-\ BA",
"55343256", "Uberlândia\ \-\ MG",
"55913636", "Limoeiro\ do\ Ajuru\ \-\ PA",
"55112643", "São\ Paulo\ \-\ SP",
"5512392", "São\ José\ dos\ Campos\ \-\ SP",
"55793377", "Ilha\ das\ Flores\ \-\ SE",
"55223811", "Itaperuna\ \-\ RJ",
"55743681", "Ourolândia\ \-\ BA",
"55513210", "Rio\ Grande\ do\ Sul",
"55553244", "Santana\ do\ Livramento\ \-\ RS",
"55273733", "Brejetuba\ \-\ ES",
"55843274", "Ceará\-Mirim\ \-\ RN",
"55733624", "Jussari\ \-\ BA",
"55112516", "São\ Paulo\ \-\ SP",
"55753680", "Rafael\ Jambeiro\ \-\ BA",
"55533011", "Pelotas\ \-\ RS",
"55663027", "Rondonópolis\ \-\ MT",
"55743636", "Caém\ \-\ BA",
"55883451", "Dom\ Maurício\ \-\ CE",
"55513407", "Porto\ Alegre\ \-\ RS",
"55183702", "Andradina\ \-\ SP",
"5511435", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55613233", "Guará\ \-\ DF",
"55373421", "Luz\ \-\ MG",
"55813413", "Recife\ \-\ PE",
"55753656", "Glória\ \-\ BA",
"55114049", "Diadema\ \-\ SP",
"55873798", "Bom\ Conselho\ \-\ PE",
"55112814", "Itaquaquecetuba\ \-\ SP",
"55693445", "São\ Felipe\ do\ Oeste\ \-\ RO",
"55353236", "São\ Bento\ Abade\ \-\ MG",
"55663496", "Alto\ Taquari\ \-\ MT",
"55983381", "Pinheiro\ \-\ MA",
"55443313", "Santa\ Inês\ \-\ PR",
"55833285", "Gurinhém\ \-\ PB",
"55183211", "Birigui\ \-\ SP",
"55212692", "Nilópolis\ \-\ RJ",
"55383632", "Santa\ Fé\ de\ Minas\ \-\ MG",
"55433303", "Arapongas\ \-\ PR",
"55483282", "Florianópolis\ \-\ SC",
"55193588", "Porto\ Ferreira\ \-\ SP",
"55353281", "Cristina\ \-\ MG",
"5564", "Goiás",
"55112657", "Guarulhos\ \-\ SP",
"55613308", "Planaltina\ \-\ DF",
"55923664", "Manaus\ \-\ AM",
"55713631", "Itaparica\ \-\ BA",
"55513982", "Lajeado\ \-\ RS",
"55843479", "Carnaúba\ dos\ Dantas\ \-\ RN",
"55674004", "Campo\ Grande\ \-\ MS",
"55943422", "Piçarras\ \-\ PA",
"55114217", "Atibaia\ \-\ SP",
"55443278", "Ourizona\ \-\ PR",
"55613612", "Cristalina\ \-\ GO",
"55173423", "Votuporanga\ \-\ SP",
"55173245", "José\ Bonifácio\ \-\ SP",
"55793432", "Itabaiana\ \-\ SE",
"55833439", "Lagoa\ \-\ PB",
"55373213", "Divinópolis\ \-\ MG",
"55153283", "Laranjal\ Paulista\ \-\ SP",
"55313251", "Santana\ do\ Paraíso\ \-\ MG",
"5511567", "São\ Paulo\ \-\ SP",
"55413656", "Colombo\ \-\ PR",
"55633446", "Sítio\ Novo\ do\ Tocantins\ \-\ TO",
"55853084", "Fortaleza\ \-\ CE",
"55913739", "Paragominas\ \-\ PA",
"55693411", "Ji\-Paraná\ \-\ RO",
"55733694", "São\ José\ da\ Vitória\ \-\ BA",
"55313230", "Minas\ Gerais",
"55413058", "São\ José\ dos\ Pinhais\ \-\ PR",
"55473356", "Vidal\ Ramos\ \-\ SC",
"55823552", "Piaçabuçu\ \-\ AL",
"55162105", "Sertãozinho\ \-\ SP",
"55483356", "Imbituba\ \-\ SC",
"55863362", "Cocal\ \-\ PI",
"5519373", "Campinas\ \-\ SP",
"55313094", "Ipatinga\ \-\ MG",
"55383758", "Augusto\ de\ Lima\ \-\ MG",
"55933549", "Porto\ Trombetas\ \-\ PA",
"55513608", "Rio\ Grande\ do\ Sul",
"55533045", "Rio\ Grande\ \-\ RS",
"55213976", "Rio\ de\ Janeiro\ \-\ RJ",
"55194009", "Campinas\ \-\ SP",
"55623548", "Aparecida\ de\ Goiânia\ \-\ GO",
"55343071", "Uberaba\ \-\ MG",
"55413517", "São\ José\ dos\ Pinhais\ \-\ PR",
"55543447", "Vila\ Flores\ \-\ RS",
"55213855", "Rio\ de\ Janeiro\ \-\ RJ",
"55432102", "Apucarana\ \-\ PR",
"55183362", "Paraguaçu\ Paulista\ \-\ SP",
"55183822", "Dracena\ \-\ SP",
"55173362", "Marcondésia\ \-\ SP",
"55144009", "Bauru\ \-\ SP",
"55833443", "Brejo\ do\ Cruz\ \-\ PB",
"55213551", "Rio\ de\ Janeiro\ \-\ RJ",
"55112781", "São\ Paulo\ \-\ SP",
"55813542", "Abreu\ e\ Lima\ \-\ PE",
"55983478", "Araioses\ \-\ MA",
"55694007", "Porto\ Velho\ \-\ RO",
"55743675", "São\ José\ do\ Jacuípe\ \-\ BA",
"55353221", "Varginha\ \-\ MG",
"55473222", "Blumenau\ \-\ SC",
"55553433", "Itaqui\ \-\ RS",
"55543266", "Santa\ Lúcia\ do\ Piaí\ \-\ RS",
"55753452", "Itatim\ \-\ BA",
"55973321", "Barcelos\ \-\ AM",
"55313084", "Belo\ Horizonte\ \-\ MG",
"55163728", "São\ Joaquim\ da\ Barra\ \-\ SP",
"55273048", "Linhares\ \-\ ES",
"55773663", "Morpará\ \-\ BA",
"55423646", "Pitanga\ \-\ PR",
"55843286", "Passagem\ \-\ RN",
"55833457", "Princesa\ Isabel\ \-\ PB",
"5571301", "Salvador\ \-\ BA",
"55553742", "Palmeira\ das\ Missões\ \-\ RS",
"55333427", "Materlândia\ \-\ MG",
"55453028", "Foz\ do\ Iguaçu\ \-\ PR",
"55993631", "São\ Luís\ Gonzaga\ do\ Maranhão\ \-\ MA",
"55654009", "Cuiabá\ \-\ MT",
"55133269", "Santos\ \-\ SP",
"55643411", "Catalão\ \-\ GO",
"55843231", "Natal\ \-\ RN",
"55115932", "São\ Paulo\ \-\ SP",
"55913621", "Caiçava\ \-\ PA",
"55933533", "Monte\ Alegre\ \-\ PA",
"55823302", "Maceió\ \-\ AL",
"55193878", "Louveira\ \-\ SP",
"55323241", "Juiz\ de\ Fora\ \-\ MG",
"55733684", "Itamaraty\ \-\ BA",
"55192511", "Campinas\ \-\ SP",
"55673041", "Campo\ Grande\ \-\ MS",
"55513041", "Cachoeirinha\ \-\ RS",
"55153293", "Sorocaba\ \-\ SP",
"55993422", "Caxias\ \-\ MA",
"55863245", "Nossa\ Senhora\ dos\ Remédios\ \-\ PI",
"55473390", "Itajaí\ \-\ SC",
"55533240", "Bagé\ \-\ RS",
"55173572", "Pindorama\ \-\ SP",
"55493278", "Urubici\ \-\ SC",
"55823264", "Atalaia\ \-\ AL",
"55833271", "Guarabira\ \-\ PB",
"55743621", "Jacobina\ \-\ BA",
"55633388", "Santa\ Rosa\ do\ Tocantins\ \-\ TO",
"55414107", "Curitiba\ \-\ PR",
"55433563", "Tomazina\ \-\ PR",
"55112536", "São\ Paulo\ \-\ SP",
"55643474", "Orizona\ \-\ GO",
"55493349", "Irati\ \-\ SC",
"55533031", "Pelotas\ \-\ RS",
"55643682", "Turvânia\ \-\ GO",
"55323294", "Bocaina\ de\ Minas\ \-\ MG",
"55142105", "Marília\ \-\ SP",
"55813742", "Cachoeirinha\ \-\ PE",
"55883410", "Itaiçaba\ \-\ CE",
"55613491", "Brasília\ \-\ DF",
"55843362", "Campo\ Grande\ \-\ RN",
"55223831", "Bom\ Jesus\ do\ Itabapoana\ \-\ RJ",
"55673230", "Pedro\ Gomes\ \-\ MS",
"55353064", "Poços\ de\ Caldas\ \-\ MG",
"55373405", "Arcos\ \-\ MG",
"55313312", "Belo\ Horizonte\ \-\ MG",
"55993604", "São\ Pedro\ dos\ Crentes\ \-\ MA",
"55143003", "Bauru\ \-\ SP",
"55112705", "São\ Paulo\ \-\ SP",
"55633434", "Juarina\ \-\ TO",
"55614063", "Brasília\ \-\ DF",
"55115034", "São\ Paulo\ \-\ SP",
"55243324", "Barra\ Mansa\ \-\ RJ",
"55413462", "Morretes\ \-\ PR",
"55112885", "Guarulhos\ \-\ SP",
"55323429", "Cataguases\ \-\ MG",
"55833532", "Cajazeiras\ \-\ PB",
"55383612", "Montalvânia\ \-\ MG",
"55323051", "Barbacena\ \-\ MG",
"55353449", "Pouso\ Alegre\ \-\ MG",
"55483535", "Jacinto\ Machado\ \-\ SC",
"55773448", "Dom\ Basílio\ \-\ BA",
"55473535", "Atalanta\ \-\ SC",
"55513477", "Canoas\ \-\ RS",
"5521341", "Rio\ de\ Janeiro\ \-\ RJ",
"55112834", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55314004", "Belo\ Horizonte\ \-\ MG",
"5513336", "Cubatão\ \-\ SP",
"55963422", "Tartarugalzinho\ \-\ AP",
"55183286", "Anhumas\ \-\ SP",
"55273258", "João\ Neiva\ \-\ ES",
"55653003", "Cuiabá\ \-\ MT",
"55353832", "Campo\ Belo\ \-\ MG",
"55163461", "Araraquara\ \-\ SP",
"55713645", "Pojuca\ \-\ BA",
"55543382", "Alto\ Alegre\ \-\ RS",
"55673251", "Jardim\ \-\ MS",
"55553542", "Tucunduva\ \-\ RS",
"55223850", "Miracema\ \-\ RJ",
"55163878", "Ribeirão\ Preto\ \-\ SP",
"55613213", "Brasília\ \-\ DF",
"55273327", "Vitória\ \-\ ES",
"55813433", "Paulista\ \-\ PE",
"55834064", "Campina\ Grande\ \-\ PB",
"55823270", "Maribondo\ \-\ AL",
"55115095", "São\ Paulo\ \-\ SP",
"55343453", "Limeira\ do\ Oeste\ \-\ MG",
"55843423", "Jardim\ de\ Piranhas\ \-\ RN",
"55893572", "Parnaguá\ \-\ PI",
"55513035", "Novo\ Hamburgo\ \-\ RS",
"551138", "São\ Paulo\ \-\ SP",
"55353742", "Bandeira\ do\ Sul\ \-\ MG",
"5563331", "Gurupi\ \-\ TO",
"55773262", "Itapetinga\ \-\ BA",
"55993645", "Esperantinópolis\ \-\ MA",
"55643087", "Itumbiara\ \-\ GO",
"55873878", "Bodocó\ \-\ PE",
"55543392", "Lagoa\ dos\ Três\ Cantos\ \-\ RS",
"55843245", "Vila\ Flor\ \-\ RN",
"55493333", "Nova\ Erechim\ \-\ SC",
"5511436", "São\ Bernardo\ do\ Campo\ \-\ SP",
"554132", "Curitiba\ \-\ PR",
"5511482", "Ribeirão\ Pires\ \-\ SP",
"55112970", "Barueri\ \-\ SP",
"55112591", "São\ Paulo\ \-\ SP",
"55473623", "Três\ Barras\ \-\ SC",
"55483623", "Capivari\ de\ Baixo\ \-\ SC",
"55323284", "Belmiro\ Braga\ \-\ MG",
"55613436", "Brasília\ \-\ DF",
"55114013", "Itu\ \-\ SP",
"55423634", "Campina\ do\ Simão\ \-\ PR",
"55112895", "São\ Paulo\ \-\ SP",
"55713604", "Madre\ de\ Deus\ \-\ BA",
"55693474", "Castanheiras\ \-\ RO",
"55323722", "Muriaé\ \-\ MG",
"5519353", "Rio\ Claro\ \-\ SP",
"55343266", "Canápolis\ \-\ MG",
"55192105", "Piracicaba\ \-\ SP",
"55533255", "Pedro\ Osório\ \-\ RS",
"55114454", "Santo\ André\ \-\ SP",
"55353433", "Camanducaia\ \-\ MG",
"55863250", "Prata\ do\ Piauí\ \-\ PI",
"5511352", "São\ Paulo\ \-\ SP",
"55793543", "Indiaroba\ \-\ SE",
"55114178", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55643450", "Marzagão\ \-\ GO",
"55823036", "Maceió\ \-\ AL",
"55243335", "Rio\ Claro\ \-\ RJ",
"55113518", "São\ Paulo\ \-\ SP",
"55913605", "Anajás\ \-\ PA",
"55633425", "Pau\ D\'Arco\ \-\ TO",
"55273533", "Vila\ Velha\ \-\ ES",
"55553413", "Uruguaiana\ \-\ RS",
"55283533", "Rio\ Novo\ do\ Sul\ \-\ ES",
"55222778", "Casimiro\ de\ Abreu\ \-\ RJ",
"55153431", "Itararé\ \-\ SP",
"55183274", "Teçaindá\ \-\ SP",
"55473366", "Balneário\ Camboriú\ \-\ SC",
"55413393", "Campo\ Largo\ \-\ PR",
"55173274", "Tanabi\ \-\ SP",
"55753248", "Coração\ de\ Maria\ \-\ BA",
"55653277", "Caramujo\ \-\ MT",
"55373249", "Itaúna\ \-\ MG",
"55452031", "Marechal\ Cândido\ Rondon\ \-\ PR",
"55543322", "Quinze\ de\ Novembro\ \-\ RS",
"55893483", "São\ João\ do\ Piauí\ \-\ PI",
"55443527", "Nova\ Cantu\ \-\ PR",
"55413666", "Colombo\ \-\ PR",
"55112521", "São\ Paulo\ \-\ SP",
"55113198", "São\ Paulo\ \-\ SP",
"55793644", "Lagarto\ \-\ SE",
"55542109", "Farroupilha\ \-\ RS",
"55543034", "São\ Marcos\ \-\ RS",
"55623464", "Água\ Fria\ de\ Goiás\ \-\ GO",
"55633471", "Tocantinópolis\ \-\ TO",
"55533026", "Pelotas\ \-\ RS",
"55114818", "Terra\ Preta\ \-\ SP",
"55143451", "Marília\ \-\ SP",
"55913412", "Castanhal\ \-\ PA",
"55193808", "Amparo\ \-\ SP",
"55643622", "Rio\ Verde\ \-\ GO",
"55843065", "Mossoró\ \-\ RN",
"55313261", "Belo\ Horizonte\ \-\ MG",
"55643431", "Itumbiara\ \-\ GO",
"55543290", "Caxias\ do\ Sul\ \-\ RS",
"55813000", "Recife\ \-\ PE",
"55423533", "Antônio\ Olinto\ \-\ PR",
"55143277", "Bauru\ \-\ SP",
"55653029", "Várzea\ Grande\ \-\ MT",
"55473524", "Aurora\ \-\ SC",
"55183502", "Adamantina\ \-\ SP",
"55833201", "Campina\ Grande\ \-\ PB",
"55333342", "Durandé\ \-\ MG",
"55483524", "Araranguá\ \-\ SC",
"55323224", "Juiz\ de\ Fora\ \-\ MG",
"55474105", "Itajaí\ \-\ SC",
"55823254", "São\ Luís\ do\ Quitunde\ \-\ AL",
"55193798", "Campinas\ \-\ SP",
"55383233", "Francisco\ Sá\ \-\ MG",
"5551364", "Rio\ Grande\ do\ Sul",
"55373233", "Pará\ de\ Minas\ \-\ MG",
"55833419", "Santa\ Teresinha\ \-\ PB",
"55113188", "São\ Paulo\ \-\ SP",
"55113652", "Osasco\ \-\ SP",
"55743644", "Itaguaçu\ da\ Bahia\ \-\ BA",
"55553281", "Caçapava\ do\ Sul\ \-\ RS",
"55323276", "Mar\ de\ Espanha\ \-\ MG",
"55913767", "São\ Caetano\ de\ Odivelas\ \-\ PA",
"55463313", "Pato\ Branco\ \-\ PR",
"55943347", "Eldorado\ dos\ Carajás\ \-\ PA",
"55643496", "Aloândia\ \-\ GO",
"55613632", "Formosa\ \-\ GO",
"55553236", "Formigueiro\ \-\ RS",
"55713167", "Salvador\ \-\ BA",
"55193451", "Limeira\ \-\ SP",
"55833467", "São\ José\ do\ Sabugi\ \-\ PB",
"55543280", "Pedras\ Brancas\ \-\ RS",
"5566", "Mato\ Grosso",
"55753462", "Itapicuru\ \-\ BA",
"55613475", "Brasília\ \-\ DF",
"55193029", "Campinas\ \-\ SP",
"55843260", "São\ Bento\ do\ Norte\ \-\ RN",
"55773311", "Brumado\ \-\ BA",
"55493527", "Joaçaba\ \-\ SC",
"55333265", "Santa\ Rita\ do\ Itueto\ \-\ MG",
"55423625", "Entre\ Rios\ \-\ PR",
"55893493", "Acauã\ \-\ PI",
"55513678", "Cristal\ \-\ RS",
"55242444", "Barra\ do\ Piraí\ \-\ RJ",
"55773647", "Ibitiara\ \-\ BA",
"5561334", "Brasília\ \-\ DF",
"55313210", "Minas\ Gerais",
"55353244", "Cordislândia\ \-\ MG",
"55863274", "Brasileira\ \-\ PI",
"55943353", "Vila\ Cruzeiro\ do\ Sul\ \-\ PA",
"55224105", "Nova\ Friburgo\ \-\ RJ",
"55153279", "Sao\ Miguel\ Arcanjo\ \-\ SP",
"55613568", "Guará\ \-\ DF",
"55413383", "São\ José\ dos\ Pinhais\ \-\ PR",
"55433435", "Manoel\ Ribas\ \-\ PR",
"55183856", "Nova\ Guataporanga\ \-\ SP",
"55733548", "Irajuba\ \-\ BA",
"55863304", "Teresina\ \-\ PI",
"55112427", "Atibaia\ \-\ SP",
"55513585", "Campo\ Bom\ \-\ RS",
"55683212", "Rio\ Branco\ \-\ AC",
"55883432", "Icapuí\ \-\ CE",
"55843663", "Natal\ \-\ RN",
"55753682", "Gavião\ \-\ BA",
"55993263", "Imperatriz\ \-\ MA",
"55553931", "Santo\ Ângelo\ \-\ RS",
"55193539", "Ajapi\ \-\ SP",
"55443568", "Mamborê\ \-\ PR",
"55313546", "Minas\ Gerais",
"55873849", "Itaíba\ \-\ PE",
"55483256", "Anitápolis\ \-\ SC",
"55863262", "Altos\ \-\ PI",
"55313330", "Belo\ Horizonte\ \-\ MG",
"55383727", "Monjolos\ \-\ MG",
"55883621", "Camocim\ \-\ CE",
"55753426", "Rio\ Real\ \-\ BA",
"55513701", "Rio\ Grande\ do\ Sul",
"55143543", "Promissão\ \-\ SP",
"55343515", "Patrocínio\ \-\ MG",
"55443632", "Xambrê\ \-\ PR",
"55483463", "Forquilhinha\ \-\ SC",
"55813478", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55923318", "Nova\ Olinda\ do\ Norte\ \-\ AM",
"55964400", "Macapá\ \-\ AP",
"55532128", "Pelotas\ \-\ RS",
"55173345", "Bebedouro\ \-\ SP",
"55183345", "Presidente\ Prudente\ \-\ SP",
"55813861", "Petrolina\ \-\ PE",
"55213201", "Rio\ de\ Janeiro\ \-\ RJ",
"55674062", "Campo\ Grande\ \-\ MS",
"55313351", "Contagem\ \-\ MG",
"55114641", "Itaquaquecetuba\ \-\ SP",
"55153383", "Laranjal\ Paulista\ \-\ SP",
"55684062", "Rio\ Branco\ \-\ AC",
"55514062", "Porto\ Alegre\ \-\ RS",
"5599352", "Imperatriz\ \-\ MA",
"55463233", "Coronel\ Vivida\ \-\ PR",
"55843396", "Lucrécia\ \-\ RN",
"55114317", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55343811", "Presidente\ Olegário\ \-\ MG",
"55153537", "Itapetininga\ \-\ SP",
"55733013", "Teixeira\ de\ Freitas\ \-\ BA",
"55883675", "Independência\ \-\ CE",
"55633367", "Tocantínia\ \-\ TO",
"55193307", "Campinas\ \-\ SP",
"55333736", "Virgem\ da\ Lapa\ \-\ MG",
"55443421", "Paranavaí\ \-\ PR",
"55623523", "Goiânia\ \-\ GO",
"55313844", "Cava\ Grande\ \-\ MG",
"55452104", "Cascavel\ \-\ PR",
"55453039", "Cascavel\ \-\ PR",
"55353375", "Dom\ Viçoso\ \-\ MG",
"55863345", "São\ João\ da\ Fronteira\ \-\ PI",
"55112086", "Guarulhos\ \-\ SP",
"55124159", "Vargem\ Grande\ Paulista\ \-\ SP",
"55913728", "Concórdia\ do\ Pará\ \-\ PA",
"55313734", "Belo\ Vale\ \-\ MG",
"55693913", "Guajará\-Mirim\ \-\ RO",
"55833371", "Picuí\ \-\ PB",
"55212680", "Mangaratiba\ \-\ RJ",
"55543524", "Mariano\ Moro\ \-\ RS",
"55143307", "Ibirarema\ \-\ SP",
"55833428", "Mãe\ d\'Água\ \-\ PB",
"55513115", "Canoas\ \-\ RS",
"55343292", "Uberlândia\ \-\ MG",
"55873833", "Venturosa\ \-\ PE",
"55483034", "São\ José\ \-\ SC",
"55843331", "Açu\ \-\ RN",
"55223862", "Portela\ \-\ RJ",
"55643666", "Portelândia\ \-\ GO",
"55133829", "Registro\ \-\ SP",
"5524224", "Petrópolis\ \-\ RJ",
"55193543", "Araras\ \-\ SP",
"55613877", "Brasília\ \-\ DF",
"55823202", "Maceió\ \-\ AL",
"55114606", "Várzea\ Paulista\ \-\ SP",
"55493632", "Tunápolis\ \-\ SC",
"55323341", "Ressaquinha\ \-\ MG",
"55843386", "Tenente\ Ananias\ \-\ RN",
"55413622", "Lapa\ \-\ PR",
"55543366", "Campinas\ do\ Sul\ \-\ RS",
"55773479", "Piatã\ \-\ BA",
"55123655", "Caçapava\ \-\ SP",
"55612030", "Brasília\ \-\ DF",
"55114133", "Barueri\ \-\ SP",
"55753692", "Paulo\ Afonso\ \-\ BA",
"55483085", "Florianópolis\ \-\ SC",
"55643559", "Itumbiara\ \-\ GO",
"55513746", "Rio\ Grande\ do\ Sul",
"55323556", "São\ Geraldo\ \-\ MG",
"55853351", "Trairi\ \-\ CE",
"55513595", "Novo\ Hamburgo\ \-\ RS",
"55133579", "São\ Vicente\ \-\ SP",
"55483322", "Florianópolis\ \-\ SC",
"55333355", "Iapu\ \-\ MG",
"55163432", "Franca\ \-\ SP",
"55823526", "Coité\ do\ Nóia\ \-\ AL",
"55353861", "Nepomuceno\ \-\ MG",
"55663452", "Novo\ São\ Joaquim\ \-\ MT",
"55932101", "Santarém\ \-\ PA",
"55212656", "São\ João\ de\ Meriti\ \-\ RJ",
"55183262", "Presidente\ Bernardes\ \-\ SP",
"55193557", "Rio\ Claro\ \-\ SP",
"55112152", "Jundiaí\ \-\ SP",
"55833561", "Bernardino\ Batista\ \-\ PB",
"55112688", "Guarulhos\ \-\ SP",
"55173262", "Nova\ Granada\ \-\ SP",
"55513571", "São\ José\ do\ Hortêncio\ \-\ RS",
"55163519", "Ribeirão\ Preto\ \-\ SP",
"55913798", "Pacajá\ \-\ PA",
"55222733", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55733237", "Buerarema\ \-\ BA",
"55843252", "Sítio\ Novo\ \-\ RN",
"55493491", "Seara\ \-\ SC",
"55833498", "Serra\ Grande\ \-\ PB",
"55433476", "Cândido\ de\ Abreu\ \-\ PR",
"55313184", "Itaguara\ \-\ MG",
"55713198", "Salvador\ \-\ BA",
"55623583", "Goiânia\ \-\ GO",
"55163567", "Cajuru\ \-\ SP",
"55463558", "Pérola\ D\'Oeste\ \-\ PR",
"55183991", "Mirante\ do\ Paranapanema\ \-\ SP",
"55443436", "Itaúna\ do\ Sul\ \-\ PR",
"55333721", "Almenara\ \-\ MG",
"55833627", "Pilõezinhos\ \-\ PB",
"55713043", "Salvador\ \-\ BA",
"55213668", "São\ João\ de\ Meriti\ \-\ RJ",
"55753622", "Feira\ de\ Santana\ \-\ BA",
"55613597", "Taguatinga\ \-\ DF",
"55553305", "Ijuí\ \-\ RS",
"55312108", "Belo\ Horizonte\ \-\ MG",
"55833395", "Umbuzeiro\ \-\ PB",
"556432", "Itumbiara\ \-\ GO",
"55114783", "Embu\ das\ Artes\ \-\ SP",
"55193813", "Itapira\ \-\ SP",
"5545352", "Foz\ do\ Iguaçu\ \-\ PR",
"55533242", "Bagé\ \-\ RS",
"55513649", "Montenegro\ \-\ RS",
"55513714", "Lajeado\ \-\ RS",
"55153248", "Ibiúna\ \-\ SP",
"55333516", "Capelinha\ \-\ MG",
"55883636", "Amontada\ \-\ CE",
"55753431", "Inhambupe\ \-\ BA",
"55773274", "Macarani\ \-\ BA",
"55173311", "Catanduva\ \-\ SP",
"55413908", "Curitiba\ \-\ PR",
"55113599", "Osasco\ \-\ SP",
"55833385", "Cubati\ \-\ PB",
"55183311", "Presidente\ Prudente\ \-\ SP",
"55113353", "São\ Paulo\ \-\ SP",
"55473382", "Timbó\ \-\ SC",
"55483025", "Florianópolis\ \-\ SC",
"55823531", "Batalha\ \-\ AL",
"55753279", "Paripiranga\ \-\ BA",
"55534141", "Pelotas\ \-\ RS",
"55373278", "Pequi\ \-\ MG",
"55112628", "São\ Paulo\ \-\ SP",
"55514104", "Canoas\ \-\ RS",
"55472123", "Blumenau\ \-\ SC",
"55163953", "Pontal\ \-\ SP",
"55543535", "Caxias\ do\ Sul\ \-\ RS",
"55183647", "Glicério\ \-\ SP",
"55753496", "Adustina\ \-\ BA",
"55313725", "Caranaíba\ \-\ MG",
"55143813", "Botucatu\ \-\ SP",
"55883691", "Crateús\ \-\ CE",
"55813755", "Tacaimbó\ \-\ PE",
"55613333", "Recanto\ das\ Emas\ \-\ DF",
"55343845", "Iraí\ de\ Minas\ \-\ MG",
"55843374", "Riacho\ da\ Cruz\ \-\ RN",
"55313194", "Belo\ Horizonte\ \-\ MG",
"55114899", "Caieiras\ \-\ SP",
"55543584", "Passo\ Fundo\ \-\ RS",
"55713652", "São\ Francisco\ do\ Conde\ \-\ BA",
"55833488", "Santa\ Inês\ \-\ PB",
"55623624", "Goiânia\ \-\ GO",
"55222123", "Macaé\ \-\ RJ",
"55114402", "Atibaia\ \-\ SP",
"55493436", "Faxinal\ dos\ Guedes\ \-\ SC",
"55115693", "São\ Paulo\ \-\ SP",
"55793277", "Carmópolis\ \-\ SE",
"55143767", "Coronel\ Macedo\ \-\ SP",
"55663517", "Sinop\ \-\ MT",
"55643462", "Goiandira\ \-\ GO",
"55513633", "Pareci\ Novo\ \-\ RS",
"55883519", "Granjeiro\ \-\ CE",
"55513310", "Rio\ Grande\ do\ Sul",
"55313232", "Minas\ Gerais",
"55843326", "Tibau\ \-\ RN",
"55343356", "Nova\ Ponte\ \-\ MG",
"55413158", "Campina\ Grande\ do\ Sul\ \-\ PR",
"55183653", "Penápolis\ \-\ SP",
"55313771", "Sete\ Lagoas\ \-\ MG",
"55163947", "Sertãozinho\ \-\ SP",
"55183981", "Mirante\ do\ Paranapanema\ \-\ SP",
"55623359", "Jesúpolis\ \-\ GO",
"55733259", "Ibirapitanga\ \-\ BA",
"55143644", "Igaraçu\ do\ Tietê\ \-\ SP",
"55863360", "Joaquim\ Pires\ \-\ PI",
"55623593", "Goiânia\ \-\ GO",
"55663569", "Porto\ Alegre\ do\ Norte\ \-\ MT",
"55883567", "Ipaumirim\ \-\ CE",
"55114624", "Osasco\ \-\ SP",
"55313525", "Minas\ Gerais",
"55633357", "Formoso\ do\ Araguaia\ \-\ TO",
"55672108", "Dourados\ \-\ MS",
"55333242", "São\ João\ do\ Manteninha\ \-\ MG",
"55813344", "Recife\ \-\ PE",
"55483014", "São\ João\ Batista\ \-\ SC",
"55193681", "São\ José\ do\ Rio\ Pardo\ \-\ SP",
"55773483", "Santa\ Maria\ da\ Vitória\ \-\ BA",
"55753445", "Jandaíra\ \-\ BA",
"55143377", "São\ Pedro\ do\ Turvo\ \-\ SP",
"55213020", "Rio\ de\ Janeiro\ \-\ RJ",
"55173564", "Catiguá\ \-\ SP",
"55843647", "Parnamirim\ \-\ RN",
"55823272", "Barra\ de\ São\ Miguel\ \-\ AL",
"55213842", "Duque\ de\ Caxias\ \-\ RJ",
"55282101", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55272101", "Colatina\ \-\ ES",
"55893570", "Baixa\ Grande\ do\ Ribeiro\ \-\ PI",
"55443444", "São\ Pedro\ do\ Paraná\ \-\ PR",
"55114593", "Itupeva\ \-\ SP",
"55163605", "Ribeirão\ Preto\ \-\ SP",
"55313714", "Paraopeba\ \-\ MG",
"55313649", "Santa\ Luzia\ \-\ MG",
"55473453", "Joinville\ \-\ SC",
"55773409", "Iguatemi\ \-\ BA",
"55422101", "Ponta\ Grossa\ \-\ PR",
"55483266", "Florianópolis\ \-\ SC",
"55443017", "Campo\ Mourão\ \-\ PR",
"55273287", "Fundão\ \-\ ES",
"55313571", "Brumadinho\ \-\ MG",
"55863252", "Campo\ Maior\ \-\ PI",
"55473447", "Araquari\ \-\ SC",
"55483447", "Cocal\ do\ Sul\ \-\ SC",
"55883644", "Santana\ do\ Acaraú\ \-\ CE",
"55553755", "Liberato\ Salzano\ \-\ RS",
"55653691", "Várzea\ Grande\ \-\ MT",
"55163412", "São\ Carlos\ \-\ SP",
"55313875", "Santa\ Margarida\ \-\ MG",
"55183866", "Flora\ Rica\ \-\ SP",
"55274003", "Vitória\ \-\ ES",
"55843653", "Natal\ \-\ RN",
"55963198", "Macapá\ \-\ AP",
"55333521", "Teófilo\ Otoni\ \-\ MG",
"55212666", "Nova\ Iguaçu\ \-\ RJ",
"55353344", "Aiuruoca\ \-\ MG",
"55143103", "Bauru\ \-\ SP",
"55353555", "Guaranésia\ \-\ MG",
"5561324", "Brasília\ \-\ DF",
"55413283", "São\ José\ dos\ Pinhais\ \-\ PR",
"55493558", "Ipira\ \-\ SC",
"55323032", "Juiz\ de\ Fora\ \-\ MG",
"55193567", "Santa\ Cruz\ da\ Conceição\ \-\ SP",
"55313956", "Contagem\ \-\ MG",
"55153379", "São\ Miguel\ Arcanjo\ \-\ SP",
"55643517", "Itumbiara\ \-\ GO",
"55222533", "Nova\ Friburgo\ \-\ RJ",
"55813974", "Recife\ \-\ PE",
"55863326", "Timon\ \-\ MA",
"55414007", "Curitiba\ \-\ PR",
"55853361", "Aquiraz\ \-\ CE",
"55193519", "Campinas\ \-\ SP",
"55333825", "Belo\ Oriente\ \-\ MG",
"55643680", "Nazário\ \-\ GO",
"55353851", "Boa\ Esperança\ \-\ MG",
"55114509", "Santo\ André\ \-\ SP",
"55543356", "Barracão\ \-\ RS",
"55112342", "São\ Paulo\ \-\ SP",
"55513771", "Rio\ Grande\ do\ Sul",
"55683232", "Senador\ Guiomard\ \-\ AC",
"55673232", "Corumbá\ \-\ MS",
"55883412", "Quixadá\ \-\ CE",
"55553336", "Catuípe\ \-\ RS",
"55823629", "Ouro\ Branco\ \-\ AL",
"55773493", "Guanambi\ \-\ BA",
"55493444", "Concórdia\ \-\ SC",
"55543380", "Ibirapuitã\ \-\ RS",
"55543541", "Trindade\ do\ Sul\ \-\ RS",
"55553381", "São\ Miguel\ das\ Missões\ \-\ RS",
"55643656", "Caçu\ \-\ GO",
"55323376", "São\ Tiago\ \-\ MG",
"55223852", "Miracema\ \-\ RJ",
"55463213", "Pato\ Branco\ \-\ PR",
"55643933", "Itumbiara\ \-\ GO",
"55123897", "Caraguatatuba\ \-\ SP",
"55923672", "Manaus\ \-\ AM",
"55343831", "Patrocínio\ \-\ MG",
"55613797", "Brasília\ \-\ DF",
"5575", "Bahia",
"55373333", "Carmópolis\ de\ Minas\ \-\ MG",
"5511263", "São\ Paulo\ \-\ SP",
"55513725", "Cerro\ Branco\ \-\ RS",
"55913118", "Belém\ \-\ PA",
"55833346", "Barra\ de\ Santana\ \-\ PB",
"55334141", "Governador\ Valadares\ \-\ MG",
"55193377", "Piracicaba\ \-\ SP",
"55453247", "Penha\ \-\ PR",
"5543332", "Londrina\ \-\ PR",
"55433273", "Miraselva\ \-\ PR",
"55314062", "Belo\ Horizonte\ \-\ MG",
"55273227", "Vitória\ \-\ ES",
"55413978", "Antonina\ \-\ PR",
"55623997", "Goiânia\ \-\ GO",
"55193743", "Campinas\ \-\ SP",
"55743528", "Umburanas\ \-\ BA",
"55193675", "Tambaú\ \-\ SP",
"5541", "Paraná",
"55543282", "Canela\ \-\ RS",
"55893554", "São\ José\ do\ Peixe\ \-\ PI",
"55173386", "Pirangi\ \-\ SP",
"55993538", "Açailândia\ \-\ MA",
"55212769", "Nova\ Iguaçu\ \-\ RJ",
"55443233", "Mandaguari\ \-\ PR",
"55173331", "Guaíra\ \-\ SP",
"55913528", "Novo\ Progresso\ \-\ PA",
"55123153", "Lorena\ \-\ SP",
"55313534", "Igarapé\ \-\ MG",
"55193621", "Americana\ \-\ SP",
"55273079", "Serra\ \-\ ES",
"55353100", "Extrema\ \-\ MG",
"55163173", "Igarapava\ \-\ SP",
"55473001", "Joinville\ \-\ SC",
"55114684", "Juquitiba\ \-\ SP",
"55183916", "Presidente\ Prudente\ \-\ SP",
"55193849", "Valinhos\ \-\ SP",
"55833314", "São\ José\ da\ Mata\ \-\ PB",
"55913461", "Colares\ \-\ PA",
"55453253", "Nova\ Santa\ Rosa\ \-\ PR",
"55813607", "Orobó\ \-\ PE",
"55893448", "Bocaina\ \-\ PI",
"55433441", "Marumbi\ \-\ PR",
"55663537", "Nova\ Maringá\ \-\ MT",
"55193129", "Vinhedo\ \-\ SP",
"55843262", "João\ Câmara\ \-\ RN",
"55313836", "Itambé\ do\ Mato\ Dentro\ \-\ MG",
"55123147", "Queluz\ \-\ SP",
"55113422", "São\ Caetano\ do\ Sul\ \-\ SP",
"55513613", "Fazenda\ Vilanova\ \-\ RS",
"55333744", "Rio\ do\ Prado\ \-\ MG",
"55883539", "Baixio\ \-\ CE",
"55413404", "Curitiba\ \-\ PR",
"55493249", "Campo\ Belo\ do\ Sul\ \-\ SC",
"55993662", "Dom\ Pedro\ \-\ MA",
"55753283", "Paulo\ Afonso\ \-\ BA",
"55313881", "Ponte\ Nova\ \-\ MG",
"55513546", "Três\ Coroas\ \-\ RS",
"55683546", "Brasiléia\ \-\ AC",
"552122", "Rio\ de\ Janeiro\ \-\ RJ",
"55673546", "Brasilândia\ \-\ MS",
"55553321", "Cruz\ Alta\ \-\ RS",
"55383527", "Turmalina\ \-\ MG",
"55663559", "Novo\ Horizonte\ do\ Norte\ \-\ MT",
"55114779", "Itapecerica\ da\ Serra\ \-\ SP",
"55733269", "Ilhéus\ \-\ BA",
"55114694", "Biritiba\-Mirim\ \-\ SP",
"55883557", "Porteiras\ \-\ CE",
"55854062", "Fortaleza\ \-\ CE",
"55443249", "Lobato\ \-\ PR",
"55313746", "Piranga\ \-\ MG",
"55115845", "São\ Paulo\ \-\ SP",
"55173663", "Santa\ Clara\ D\'Oeste\ \-\ SP",
"55343826", "Patos\ de\ Minas\ \-\ MG",
"55793461", "Pinhão\ \-\ SE",
"55143432", "Marília\ \-\ SP",
"55813316", "Recife\ \-\ PE",
"55313891", "Viçosa\ \-\ MG",
"5541356", "Curitiba\ \-\ PR",
"55553565", "Porto\ Lucena\ \-\ RS",
"55643452", "Rio\ Quente\ \-\ GO",
"55314111", "Belo\ Horizonte\ \-\ MG",
"55143849", "Bairro\ de\ Santana\ \-\ SP",
"55473046", "Itajaí\ \-\ SC",
"55513785", "Rio\ Grande\ do\ Sul",
"55543292", "Flores\ da\ Cunha\ \-\ RS",
"55483648", "Termas\ do\ Gravatal\ \-\ SC",
"55333536", "Teófilo\ Otoni\ \-\ MG",
"55114873", "São\ Paulo\ \-\ SP",
"55493233", "São\ Joaquim\ \-\ SC",
"55323335", "Piedade\ do\ Rio\ Grande\ \-\ MG",
"554133", "Curitiba\ \-\ PR",
"5563321", "Palmas\ \-\ TO",
"55883543", "Aurora\ \-\ CE",
"55163307", "São\ Carlos\ \-\ SP",
"55333340", "Governador\ Valadares\ \-\ MG",
"55513734", "Pantano\ Grande\ \-\ RS",
"55333581", "Nova\ Módica\ \-\ MG",
"55553375", "Panambi\ \-\ RS",
"55213512", "Rio\ de\ Janeiro\ \-\ RJ",
"55193833", "Paulínia\ \-\ SP",
"55333062", "Governador\ Valadares\ \-\ MG",
"55623579", "Goiânia\ \-\ GO",
"55113907", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55643620", "Rio\ Verde\ \-\ GO",
"55114130", "São\ Roque\ \-\ SP",
"55114032", "Bragança\ Paulista\ \-\ SP",
"55843353", "São\ Miguel\ \-\ RN",
"55343323", "Veríssimo\ \-\ MG",
"55653391", "Cuiabá\ \-\ MT",
"55883555", "Jardim\ \-\ CE",
"55373525", "Moema\ \-\ MG",
"55433552", "Nova\ Fátima\ \-\ PR",
"55383525", "Senador\ Modestino\ Gonçalves\ \-\ MG",
"55212609", "Niterói\ \-\ RJ",
"55193911", "Mogi\-Guaçu\ \-\ SP",
"55753648", "Dom\ Macedo\ Costa\ \-\ BA",
"55513787", "Pinheiral\ \-\ RS",
"55173482", "Auriflama\ \-\ SP",
"55413453", "Matinhos\ \-\ PR",
"55483411", "Criciúma\ \-\ SC",
"55114566", "Mogi\ das\ Cruzes\ \-\ SP",
"55473411", "Rio\ do\ Sul\ \-\ SC",
"55553567", "Campina\ das\ Missões\ \-\ RS",
"55893589", "Caracol\ \-\ PI",
"55693541", "Guajará\-Mirim\ \-\ RO",
"55383821", "Janaúba\ \-\ MG",
"55373361", "Oliveira\ \-\ MG",
"55733215", "Itabuna\ \-\ BA",
"55873851", "Petrolândia\ \-\ PE",
"55553377", "Pejuçara\ \-\ RS",
"55663594", "Santa\ Cruz\ do\ Xingu\ \-\ MT",
"55212683", "Paracambi\ \-\ RJ",
"55113374", "Mogi\ das\ Cruzes\ \-\ SP",
"55163305", "Araraquara\ \-\ SP",
"55714112", "Salvador\ \-\ BA",
"55323337", "Mercês\ \-\ MG",
"55115853", "São\ Paulo\ \-\ SP",
"55313661", "Pedro\ Leopoldo\ \-\ MG",
"55873830", "Solidão\ \-\ PE",
"55493312", "Chapecó\ \-\ SC",
"55173893", "Palestina\ \-\ SP",
"55163974", "Ribeirão\ Preto\ \-\ SP",
"55843611", "Natal\ \-\ RN",
"55222561", "Santa\ Maria\ Madalena\ \-\ RJ",
"55214138", "Queimados\ \-\ RJ",
"55813644", "Cumaru\ \-\ PE",
"55813719", "Caruaru\ \-\ PE",
"55343248", "Cascalho\ Rico\ \-\ MG",
"55193336", "Rio\ Claro\ \-\ SP",
"55423122", "Ponta\ Grossa\ \-\ PR",
"55123104", "Aparecida\ \-\ SP",
"55443312", "Nossa\ Senhora\ das\ Graças\ \-\ PR",
"55163830", "Ituverava\ \-\ SP",
"55433618", "Ibaiti\ \-\ PR",
"55423457", "Rebouças\ \-\ PR",
"55133324", "Santos\ \-\ SP",
"55623995", "Goiânia\ \-\ GO",
"55483283", "Palhoça\ \-\ SC",
"55133864", "Jacupiranga\ \-\ SP",
"55433302", "Londrina\ \-\ PR",
"55273225", "Vitória\ \-\ ES",
"55212693", "Nilópolis\ \-\ RJ",
"55663584", "Sorriso\ \-\ MT",
"55383633", "Ubaí\ \-\ MG",
"55833513", "João\ Pessoa\ \-\ PB",
"55453245", "Braganey\ \-\ PR",
"55813412", "Recife\ \-\ PE",
"55183703", "Bairro\ Formosa\ \-\ SP",
"55643679", "Sanclerlândia\ \-\ GO",
"55423271", "Telêmaco\ Borba\ \-\ PR",
"55693222", "Porto\ Velho\ \-\ RO",
"55484007", "Florianópolis\ \-\ SC",
"55814109", "Paulista\ \-\ PE",
"55623520", "Goiânia\ \-\ GO",
"55474007", "Joinville\ \-\ SC",
"55273732", "Baixo\ Guandu\ \-\ ES",
"55793205", "Aracaju\ \-\ SE",
"55163344", "Ribeirão\ Bonito\ \-\ SP",
"55112642", "São\ Paulo\ \-\ SP",
"55713493", "Camaçari\ \-\ BA",
"55643541", "Itumbiara\ \-\ GO",
"55773466", "Jacaraci\ \-\ BA",
"55543379", "Coxilha\ \-\ RS",
"55653336", "Diamantino\ \-\ MT",
"55123521", "Pindamonhangaba\ \-\ SP",
"55673278", "Rio\ Negro\ \-\ MS",
"55173809", "Mendonça\ \-\ SP",
"55163851", "Morro\ Agudo\ \-\ SP",
"55833048", "João\ Pessoa\ \-\ PB",
"55663535", "Sinop\ \-\ MT",
"55433016", "Rolândia\ \-\ PR",
"5524336", "Angra\ dos\ Reis\ \-\ RJ",
"55123145", "Cruzeiro\ \-\ SP",
"55313333", "Minas\ Gerais",
"55353644", "Piranguinho\ \-\ MG",
"55643515", "Itumbiara\ \-\ GO",
"5547", "Santa\ Catarina",
"55323694", "Leopoldina\ \-\ MG",
"5548", "Santa\ Catarina",
"55163931", "Ribeirão\ Preto\ \-\ SP",
"55733206", "Mucuri\ \-\ BA",
"55213227", "Rio\ de\ Janeiro\ \-\ RJ",
"55553739", "Taquaruçu\ do\ Sul\ \-\ RS",
"55513630", "Rio\ Grande\ do\ Sul",
"55513313", "Nova\ Santa\ Rita\ \-\ RS",
"55193565", "Pirassununga\ \-\ SP",
"55833268", "João\ Pessoa\ \-\ PB",
"55613351", "Taguatinga\ \-\ DF",
"55163986", "Luís\ Antônio\ \-\ SP",
"55493015", "Lages\ \-\ SC",
"55383534", "Diamantina\ \-\ MG",
"55193478", "Americana\ \-\ SP",
"55123111", "Cunha\ \-\ SP",
"55823177", "Maceió\ \-\ AL",
"55433417", "Ribeirão\ Bonito\ \-\ PR",
"55863363", "Buriti\ dos\ Lopes\ \-\ PI",
"55913449", "São\ João\ de\ Pirabas\ \-\ PA",
"55843604", "Parnamirim\ \-\ RN",
"55193321", "Araras\ \-\ SP",
"55823553", "Porto\ Real\ do\ Colégio\ \-\ AL",
"55193861", "Mogi\-Guaçu\ \-\ SP",
"55153282", "Tietê\ \-\ SP",
"55123895", "Ilhabela\ \-\ SP",
"55983461", "Vargem\ Grande\ \-\ MA",
"55973461", "Santo\ Antônio\ do\ Içá\ \-\ AM",
"55353543", "Capetinga\ \-\ MG",
"55212741", "Teresópolis\ \-\ RJ",
"55193904", "Mogi\ Mirim\ \-\ SP",
"55173631", "Santa\ Fé\ do\ Sul\ \-\ SP",
"55373212", "Divinópolis\ \-\ MG",
"55453211", "Santa\ Maria\ \-\ PR",
"55183631", "Araçatuba\ \-\ SP",
"55273182", "Vitória\ \-\ ES",
"55273080", "Serra\ \-\ ES",
"5519344", "Limeira\ \-\ SP",
"55983878", "São\ Luís\ \-\ MA",
"55114914", "São\ Paulo\ \-\ SP",
"55513983", "Venâncio\ Aires\ \-\ RS",
"55193375", "Piracicaba\ \-\ SP",
"55853877", "Fortaleza\ \-\ CE",
"55122128", "Jacareí\ \-\ SP",
"55613613", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55173422", "Votuporanga\ \-\ SP",
"55513727", "Rio\ Grande\ do\ Sul",
"55473404", "Itajaí\ \-\ SC",
"55183422", "Assis\ \-\ SP",
"55993572", "Buriti\ Bravo\ \-\ MA",
"5522", "Rio\ de\ Janeiro",
"55513651", "São\ Jerônimo\ \-\ RS",
"55242106", "Barra\ Mansa\ \-\ RJ",
"55183696", "Turiúba\ \-\ SP",
"55753447", "Ouriçangas\ \-\ BA",
"55143375", "Espírito\ Santo\ do\ Turvo\ \-\ SP",
"55383746", "Ibiaí\ \-\ MG",
"55273090", "Cariacica\ \-\ ES",
"5521310", "Rio\ de\ Janeiro\ \-\ RJ",
"55613501", "Planaltina\ \-\ DF",
"55173573", "Roberto\ \-\ SP",
"55653321", "Cuiabá\ \-\ MT",
"55313527", "Minas\ Gerais",
"55153292", "Salto\ de\ Pirapora\ \-\ SP",
"55633355", "Miranorte\ \-\ TO",
"55212886", "Nova\ Iguaçu\ \-\ RJ",
"55163607", "Ribeirão\ Preto\ \-\ SP",
"55553743", "Jaboticaba\ \-\ RS",
"55773662", "Palmas\ de\ Monte\ Alto\ \-\ BA",
"55543452", "Bento\ Gonçalves\ \-\ RS",
"55513137", "Alvorada\ \-\ RS",
"55115933", "São\ Paulo\ \-\ SP",
"55222751", "São\ Fidélis\ \-\ RJ",
"55933532", "Uruará\ \-\ PA",
"55753266", "Araci\ \-\ BA",
"55213508", "Itaboraí\ \-\ RJ",
"55923021", "Manaus\ \-\ AM",
"55222627", "São\ Pedro\ da\ Aldeia\ \-\ RJ",
"55613966", "Brasília\ \-\ DF",
"55434001", "Londrina\ \-\ PR",
"55473348", "Itajaí\ \-\ SC",
"55133384", "Guarujá\ \-\ SP",
"55163996", "Ribeirão\ Preto\ \-\ SP",
"55443015", "Marialva\ \-\ PR",
"55143478", "Bastos\ \-\ SP",
"55813543", "Igarassu\ \-\ PE",
"55423234", "Colônia\ Castrolanda\ \-\ PR",
"5554320", "Caxias\ do\ Sul\ \-\ RS",
"55813616", "Goiana\ \-\ PE",
"55753453", "Itanagra\ \-\ BA",
"55413648", "Bateias\ \-\ PR",
"55143321", "Bauru\ \-\ SP",
"55653904", "Campo\ Novo\ do\ Parecis\ \-\ MT",
"55183823", "Dracena\ \-\ SP",
"55432103", "Londrina\ \-\ PR",
"55733241", "Coaraci\ \-\ BA",
"55453260", "Missal\ \-\ PR",
"55623341", "Goianápolis\ \-\ GO",
"55713204", "Salvador\ \-\ BA",
"55313877", "Jequeri\ \-\ MG",
"55123834", "Ubatuba\ \-\ SP",
"55984009", "São\ Luís\ \-\ MA",
"55713040", "Camaçari\ \-\ BA",
"55793449", "Ribeirópolis\ \-\ SE",
"55553757", "Novo\ Barreiro\ \-\ RS",
"55553621", "Santana\ do\ Livramento\ \-\ RS",
"55353539", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"55113754", "Arujá\ \-\ SP",
"55473445", "Garuva\ \-\ SC",
"55483027", "Florianópolis\ \-\ SC",
"55543383", "Espumoso\ \-\ RS",
"55222551", "Cordeiro\ \-\ RJ",
"55893422", "Picos\ \-\ PI",
"55193607", "Casa\ Branca\ \-\ SP",
"55113448", "Osasco\ \-\ SP",
"55313159", "Betim\ \-\ MG",
"55353833", "Candeias\ \-\ MG",
"55843696", "Caiçara\ do\ Norte\ \-\ RN",
"55173529", "Elisiário\ \-\ SP",
"55793221", "Aracaju\ \-\ SE",
"55713286", "Salvador\ \-\ BA",
"55613585", "Ceilândia\ \-\ DF",
"55613212", "Brasília\ \-\ DF",
"55183529", "Osvaldo\ Cruz\ \-\ SP",
"55114161", "Barueri\ \-\ SP",
"55833387", "São\ Sebastião\ de\ Lagoa\ de\ Roça\ \-\ PB",
"55553543", "Tuparendi\ \-\ RS",
"55343847", "Abadia\ dos\ Dourados\ \-\ MG",
"55613701", "Brasília\ \-\ DF",
"55313651", "Caeté\ \-\ MG",
"55813757", "Santa\ Maria\ do\ Cambucá\ \-\ PE",
"55383613", "Itacarambi\ \-\ MG",
"55833533", "João\ Pessoa\ \-\ PB",
"55313727", "Capela\ Nova\ \-\ MG",
"55813621", "Carpina\ \-\ PE",
"55143316", "Marília\ \-\ SP",
"55183645", "Coroados\ \-\ SP",
"55443332", "Itaguajé\ \-\ PR",
"55114669", "Itapecerica\ da\ Serra\ \-\ SP",
"55543537", "Caxias\ do\ Sul\ \-\ RS",
"55733294", "Itamaraju\ \-\ BA",
"55163810", "São\ Joaquim\ da\ Barra\ \-\ SP",
"55373546", "Biquinhas\ \-\ MG",
"55623394", "Santa\ Rita\ do\ Novo\ Destino\ \-\ GO",
"55383546", "São\ Gonçalo\ do\ Rio\ Preto\ \-\ MG",
"55643609", "Itumbiara\ \-\ GO",
"55963423", "Calçoene\ \-\ AP",
"55453352", "Rio\ do\ Salto\ \-\ PR",
"55483279", "Palhoça\ \-\ SC",
"55553557", "Coronel\ Bicaco\ \-\ RS",
"55614062", "Brasília\ \-\ DF",
"55143765", "Águas\ de\ Santa\ Bárbara\ \-\ SP",
"55663515", "Sinop\ \-\ MT",
"55373351", "Arcos\ \-\ MG",
"55923016", "Manaus\ \-\ AM",
"55113554", "São\ Paulo\ \-\ SP",
"55793275", "Maruim\ \-\ SE",
"55353739", "Andradas\ \-\ MG",
"55922129", "Manaus\ \-\ AM",
"55883565", "Acopiara\ \-\ CE",
"55693524", "Governador\ Jorge\ Teixeira\ \-\ RO",
"55163945", "Sertãozinho\ \-\ SP",
"55433562", "Sertaneja\ \-\ PR",
"55813675", "Barreiros\ \-\ PE",
"5511347", "São\ Paulo\ \-\ SP",
"55743542", "Senhor\ do\ Bonfim\ \-\ BA",
"55843363", "Rafael\ Godeiro\ \-\ RN",
"55813743", "Camocim\ de\ São\ Félix\ \-\ PE",
"55733051", "Alcobaça\ \-\ BA",
"55343853", "Tiros\ \-\ MG",
"55753025", "Feira\ de\ Santana\ \-\ BA",
"55323723", "Rosário\ da\ Limeira\ \-\ MG",
"55623335", "Vianópolis\ \-\ GO",
"55913275", "Ananindeua\ \-\ PA",
"55793542", "Cristinápolis\ \-\ SE",
"55483431", "Quarta\ Linha\ \-\ SC",
"55163321", "Tabatinga\ \-\ SP",
"55453274", "Toledo\ \-\ PR",
"55353432", "Córrego\ do\ Bom\ Jesus\ \-\ MG",
"55353621", "Itajubá\ \-\ MG",
"55193765", "Campinas\ \-\ SP",
"55483622", "Tubarão\ \-\ SC",
"55553539", "Independência\ \-\ RS",
"55183604", "Vicentinópolis\ \-\ SP",
"55473622", "Canoinhas\ \-\ SC",
"55773456", "Urandi\ \-\ BA",
"55643576", "Itumbiara\ \-\ GO",
"55833625", "Marcação\ \-\ PB",
"5513342", "Itanhaém\ \-\ SP",
"55114012", "Bom\ Jesus\ dos\ Perdões\ \-\ SP",
"55413034", "Piraquara\ \-\ PR",
"55873945", "Serra\ Talhada\ \-\ PE",
"55274102", "Serra\ \-\ ES",
"55433254", "Cambé\ \-\ PR",
"55953084", "Boa\ Vista\ \-\ RR",
"55214118", "Rio\ de\ Janeiro\ \-\ RJ",
"55113304", "São\ Paulo\ \-\ SP",
"55833397", "Natuba\ \-\ PB",
"55813739", "Altinho\ \-\ PE",
"55613595", "Sobradinho\ \-\ DF",
"55623438", "São\ João\ D\'Aliança\ \-\ GO",
"55553307", "Santa\ Maria\ \-\ RS",
"55423246", "Caetano\ Mendes\ \-\ PR",
"55153524", "Itapeva\ \-\ SP",
"55713296", "Simões\ Filho\ \-\ BA",
"55133341", "Guarujá\ \-\ SP",
"55823218", "Maceió\ \-\ AL",
"55493332", "Águas\ Frias\ \-\ SC",
"55843631", "Macaíba\ \-\ RN",
"55543393", "Mormaço\ \-\ RS",
"55773480", "Coribe\ \-\ BA",
"55623384", "Taquaral\ de\ Goiás\ \-\ GO",
"55163904", "Ribeirão\ Preto\ \-\ SP",
"55843422", "Mossoró\ \-\ RN",
"55133854", "Cajati\ \-\ SP",
"55893573", "Corrente\ \-\ PI",
"55733284", "Canavieiras\ \-\ BA",
"55333298", "Açucena\ \-\ MG",
"55353743", "Campestre\ \-\ MG",
"55493678", "Itapiranga\ \-\ SC",
"55212380", "Rio\ de\ Janeiro\ \-\ RJ",
"55743221", "Senhor\ do\ Bonfim\ \-\ BA",
"55643594", "Itumbiara\ \-\ GO",
"55933512", "Santarém\ \-\ PA",
"55453055", "Toledo\ \-\ PR",
"55143305", "Piraju\ \-\ SP",
"55423532", "São\ Mateus\ do\ Sul\ \-\ PR",
"55513661", "Tramandaí\ \-\ RS",
"55333343", "Alto\ Jequitibá\ \-\ MG",
"55863347", "Batalha\ \-\ PI",
"55223087", "Macaé\ \-\ RJ",
"55353691", "Três\ Corações\ \-\ MG",
"55983451", "Santa\ Rita\ \-\ MA",
"55113820", "Guarulhos\ \-\ SP",
"55643623", "Rio\ Verde\ \-\ GO",
"55543717", "Nova\ Prata\ \-\ RS",
"55973451", "Boca\ do\ Acre\ \-\ AM",
"55343690", "Araguari\ \-\ MG",
"55753322", "Feira\ de\ Santana\ \-\ BA",
"55312112", "Belo\ Horizonte\ \-\ MG",
"55623946", "Goiânia\ \-\ GO",
"55793281", "Laranjeiras\ \-\ SE",
"55613525", "Brasília\ \-\ DF",
"55333357", "Dom\ Cavati\ \-\ MG",
"55213828", "Rio\ de\ Janeiro\ \-\ RJ",
"55143408", "Marília\ \-\ SP",
"55513597", "Campo\ Bom\ \-\ RS",
"55413392", "Campo\ Largo\ \-\ PR",
"55193851", "Mogi\-Guaçu\ \-\ SP",
"55793236", "Aracaju\ \-\ SE",
"55543323", "Nova\ Alvorada\ \-\ RS",
"55893482", "Simplício\ Mendes\ \-\ PI",
"55473087", "Brusque\ \-\ SC",
"55693535", "Ariquemes\ \-\ RO",
"55133418", "Itariri\ \-\ SP",
"55663506", "Analândia\ do\ Norte\ \-\ MT",
"55193555", "Leme\ \-\ SP",
"55813636", "Paudalho\ \-\ PE",
"55613361", "Guará\ \-\ DF",
"55493251", "Lages\ \-\ SC",
"55833258", "João\ Pessoa\ \-\ PB",
"55623637", "Goiânia\ \-\ GO",
"55553412", "Uruguaiana\ \-\ RS",
"55283532", "Marataízes\ \-\ ES",
"55813681", "Xexéu\ \-\ PE",
"5553323", "Rio\ Grande\ \-\ RS",
"55143344", "Ipaussu\ \-\ SP",
"55413025", "Curitiba\ \-\ PR",
"55123186", "Cachoeira\ Paulista\ \-\ SP",
"55443251", "Sabáudia\ \-\ PR",
"55893492", "Campo\ Alegre\ do\ Fidalgo\ \-\ PI",
"55173353", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55623376", "Aruanã\ \-\ GO",
"55833634", "Casserengue\ \-\ PB",
"55123131", "São\ José\ dos\ Campos\ \-\ SP",
"55513587", "Novo\ Hamburgo\ \-\ RS",
"55813377", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55373514", "Abaeté\ \-\ MG",
"55663541", "Colíder\ \-\ MT",
"55413382", "São\ José\ dos\ Pinhais\ \-\ PR",
"55943352", "Parauapebas\ \-\ PA",
"55433437", "Novo\ Itacolomi\ \-\ PR",
"55153584", "Taquarivaí\ \-\ SP",
"55473908", "Itajaí\ \-\ SC",
"55733276", "Apuarema\ \-\ BA",
"55333339", "Manhuaçu\ \-\ MG",
"55513610", "Rio\ Grande\ do\ Sul",
"55813691", "Panelas\ \-\ PE",
"55913812", "Magalhães\ Barata\ \-\ PA",
"55383725", "Morro\ da\ Garça\ \-\ MG",
"55633468", "Couto\ de\ Magalhães\ \-\ TO",
"55193408", "Americana\ \-\ SP",
"55115068", "São\ Paulo\ \-\ SP",
"55843674", "Natal\ \-\ RN",
"55634141", "Palmas\ \-\ TO",
"55633521", "Brejinho\ de\ Nazaré\ \-\ TO",
"55543462", "Garibaldi\ \-\ RS",
"55613633", "Padre\ Bernardo\ \-\ GO",
"55653344", "Jangada\ \-\ MT",
"55813519", "São\ Lourenço\ da\ Mata\ \-\ PE",
"55753256", "Tucano\ \-\ BA",
"5592362", "Manaus\ \-\ AM",
"55173347", "Jaborandi\ \-\ SP",
"55433270", "Santa\ Cecília\ do\ Pavão\ \-\ PR",
"55693623", "Seringueiras\ \-\ RO",
"55473426", "Joinville\ \-\ SC",
"55773652", "Muquém\ de\ São\ Francisco\ \-\ BA",
"55853923", "Fortaleza\ \-\ CE",
"55453286", "Capitão\ Leônidas\ Marques\ \-\ PR",
"55193305", "Campinas\ \-\ SP",
"55633365", "Fátima\ \-\ TO",
"55153535", "Nova\ Campina\ \-\ SP",
"55113653", "Osasco\ \-\ SP",
"55473158", "Itajaí\ \-\ SC",
"55883677", "Sobral\ \-\ CE",
"55373232", "Pará\ de\ Minas\ \-\ MG",
"55383232", "Cristália\ \-\ MG",
"55833685", "Sertãozinho\ \-\ PB",
"55453231", "Santa\ Tereza\ do\ Oeste\ \-\ PR",
"55114649", "Itaquaquecetuba\ \-\ SP",
"55193884", "Paulínia\ \-\ SP",
"55813869", "Santa\ Maria\ da\ Boa\ Vista\ \-\ PE",
"55693346", "Chupinguaia\ \-\ RO",
"55793254", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55114821", "Rio\ Grande\ da\ Serra\ \-\ SP",
"55343327", "Conceição\ das\ Alagoas\ \-\ MG",
"55433172", "Arapongas\ \-\ PR",
"55843357", "Coronel\ João\ Pessoa\ \-\ RN",
"55193704", "Limeira\ \-\ SP",
"55112518", "São\ Paulo\ \-\ SP",
"55693530", "Monte\ Negro\ \-\ RO",
"55453902", "Cascavel\ \-\ PR",
"55453031", "Foz\ do\ Iguaçu\ \-\ PR",
"55134104", "São\ Vicente\ \-\ SP",
"55114141", "Itapevi\ \-\ SP",
"55443429", "Diamante\ do\ Norte\ \-\ PR",
"55553563", "São\ Paulo\ das\ Missões\ \-\ RS",
"55343819", "Monte\ Carmelo\ \-\ MG",
"55813654", "Salgadinho\ \-\ PE",
"55313624", "Ribeirão\ das\ Neves\ \-\ MG",
"55733678", "Monte\ Pascoal\ \-\ BA",
"55843228", "Ceará\-Mirim\ \-\ RN",
"55413457", "Pontal\ do\ Paraná\ \-\ PR",
"55513783", "Esteio\ \-\ RS",
"55663498", "Primavera\ do\ Leste\ \-\ MT",
"55493235", "Painel\ \-\ SC",
"55953224", "Boa\ Vista\ \-\ RR",
"55323333", "Barbacena\ \-\ MG",
"55873796", "Capoeiras\ \-\ PE",
"55883545", "Santana\ do\ Cariri\ \-\ CE",
"55193586", "Itirapina\ \-\ SP",
"55115614", "São\ Paulo\ \-\ SP",
"55242438", "Conservatória\ \-\ RJ",
"55373324", "Pimenta\ \-\ MG",
"55553373", "Saldanha\ Marinho\ \-\ RS",
"55212687", "Itaguaí\ \-\ RJ",
"55433542", "Bandeirantes\ \-\ PR",
"5555322", "Santa\ Maria\ \-\ RS",
"55753658", "Fátima\ \-\ BA",
"55114571", "São\ Paulo\ \-\ SP",
"55313078", "Belo\ Horizonte\ \-\ MG",
"55633653", "Arraias\ \-\ TO",
"55753182", "Alagoinhas\ \-\ BA",
"55413443", "Guaratuba\ \-\ PR",
"55513709", "Lajeado\ \-\ RS",
"55883629", "Novo\ Oriente\ \-\ CE",
"55533611", "Portão\ \-\ RS",
"55853337", "Aracoiaba\ \-\ CE",
"55193835", "Indaiatuba\ \-\ SP",
"55214007", "Rio\ de\ Janeiro\ \-\ RJ",
"55983672", "Bom\ Jardim\ \-\ MA",
"55812102", "Recife\ \-\ PE",
"55973484", "Itamarati\ \-\ AM",
"55113365", "São\ Paulo\ \-\ SP",
"55623514", "Inhumas\ \-\ GO",
"55983484", "Afonso\ Cunha\ \-\ MA",
"55543601", "Passo\ Fundo\ \-\ RS",
"55873841", "Sertânia\ \-\ PE",
"55624052", "Goiânia\ \-\ GO",
"55222101", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55212697", "Mesquita\ \-\ RJ",
"55273266", "Santa\ Leopoldina\ \-\ ES",
"55163354", "Guarapiranga\ \-\ SP",
"55433275", "Arapongas\ \-\ PR",
"55533503", "Bagé\ \-\ RS",
"55483287", "Florianópolis\ \-\ SC",
"55112652", "São\ Paulo\ \-\ SP",
"55873272", "Parnamirim\ \-\ RN",
"55983229", "Raposa\ \-\ MA",
"55873786", "Iati\ \-\ PE",
"55193673", "Tambaú\ \-\ SP",
"55753234", "Nova\ Fátima\ \-\ BA",
"55663488", "Santo\ Antonuio\ do\ Leste\ \-\ MT",
"55713026", "Lauro\ de\ Freitas\ \-\ BA",
"55773471", "Paramirim\ \-\ BA",
"55474003", "Blumenau\ \-\ SC",
"55484003", "Florianópolis\ \-\ SC",
"55115839", "São\ Paulo\ \-\ SP",
"55833058", "Campina\ Grande\ \-\ PB",
"55143586", "Guarantã\ \-\ SP",
"55513402", "Guaíba\ \-\ RS",
"5521375", "São\ João\ de\ Meriti\ \-\ RJ",
"5511258", "São\ Paulo\ \-\ SP",
"55353654", "Gonçalves\ \-\ MG",
"55333626", "Santa\ Helena\ de\ Minas\ \-\ MG",
"55823644", "Água\ Branca\ \-\ AL",
"55413020", "Curitiba\ \-\ PR",
"55853113", "Aquiraz\ \-\ CE",
"55413122", "Curitiba\ \-\ PR",
"55423447", "São\ João\ do\ Triunfo\ \-\ PR",
"55663022", "Rondonópolis\ \-\ MT",
"55833379", "Cacimba\ de\ Dentro\ \-\ PB",
"55153551", "Ribeirão\ Branco\ \-\ SP",
"55663385", "Nova\ Brasilândia\ \-\ MT",
"55493030", "Concórdia\ \-\ SC",
"55453255", "São\ Pedro\ do\ Iguaçu\ \-\ PR",
"55193894", "Indaiatuba\ \-\ SP",
"55313337", "Belo\ Horizonte\ \-\ MG",
"55653531", "Sinop\ \-\ MT",
"55513793", "Venâncio\ Aires\ \-\ RS",
"55713628", "Arembepe\ \-\ BA",
"55143884", "Anhembi\ \-\ SP",
"5517323", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55513615", "Caraá\ \-\ RS",
"55683615", "Santa\ Rosa\ do\ Purus\ \-\ AC",
"55753285", "Rodelas\ \-\ BA",
"55133821", "Registro\ \-\ SP",
"55352102", "Pouso\ Alegre\ \-\ MG",
"55482101", "Criciúma\ \-\ SC",
"55114534", "Itatiba\ \-\ SP",
"55113581", "Barueri\ \-\ SP",
"55353553", "Juruaia\ \-\ MG",
"55212751", "São\ João\ de\ Meriti\ \-\ RJ",
"55373384", "Itaguara\ \-\ MG",
"55983476", "Santa\ Quitéria\ do\ Maranhão\ \-\ MA",
"55663510", "Juara\ \-\ MT",
"55163726", "Orlândia\ \-\ SP",
"552133", "Rio\ de\ Janeiro\ \-\ RJ",
"55543268", "Farroupilha\ \-\ RS",
"55823557", "Piaçabuçu\ \-\ AL",
"55543614", "Rio\ dos\ Índios\ \-\ RS",
"55753439", "Ribeira\ do\ Amparo\ \-\ BA",
"55863367", "Luís\ Correia\ \-\ PI",
"55213445", "Rio\ de\ Janeiro\ \-\ RJ",
"55123663", "Campos\ do\ Jordão\ \-\ SP",
"55733084", "Ilhéus\ \-\ BA",
"55113705", "Santo\ André\ \-\ SP",
"5561342", "Brasília\ \-\ DF",
"55114881", "Francisco\ Morato\ \-\ SP",
"55773495", "Caetité\ \-\ BA",
"55613669", "Valparaíso\ de\ Goiás\ \-\ GO",
"55112490", "Bragança\ Paulista\ \-\ SP",
"55193824", "Águas\ de\ Lindóia\ \-\ SP",
"55163511", "Sertãozinho\ \-\ SP",
"55493802", "Lages\ \-\ SC",
"55114701", "Taboão\ da\ Serra\ \-\ SP",
"55613341", "Cruzeiro\ \-\ DF",
"55673579", "Selvíria\ \-\ MS",
"55513579", "São\ Leopoldo\ \-\ RS",
"55883603", "Cruz\ \-\ CE",
"55373335", "Passa\ Tempo\ \-\ MG",
"55313472", "Minas\ Gerais",
"55453026", "Foz\ do\ Iguaçu\ \-\ PR",
"55943427", "Água\ Azul\ do\ Norte\ \-\ PA",
"55313684", "Taquaraçu\ de\ Minas\ \-\ MG",
"55843288", "Passa\ e\ Fica\ \-\ RN",
"55513723", "Cachoeira\ do\ Sul\ \-\ RS",
"55212730", "Rio\ de\ Janeiro\ \-\ RJ",
"55613617", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55423648", "Marquinho\ \-\ PR",
"55183999", "Estrela\ do\ Norte\ \-\ SP",
"55193876", "Vinhedo\ \-\ SP",
"55953235", "São\ João\ da\ Baliza\ \-\ RR",
"55242566", "Bom\ Jardim\ \-\ RJ",
"55823543", "Teotônio\ Vilela\ \-\ AL",
"55883511", "Juazeiro\ do\ Norte\ \-\ CE",
"55133212", "Santos\ \-\ SP",
"55993427", "Barra\ do\ Corda\ \-\ MA",
"55313523", "Sítio\ Novo\ \-\ MG",
"55813553", "Amaraji\ \-\ PE",
"55193955", "Socorro\ \-\ SP",
"55143202", "Bauru\ \-\ SP",
"55773485", "Carinhanha\ \-\ BA",
"55753443", "Crisópolis\ \-\ BA",
"55543733", "Caxias\ do\ Sul\ \-\ RS",
"55114891", "Bom\ Jesus\ dos\ Perdões\ \-\ SP",
"55413658", "Bocaiúva\ do\ Sul\ \-\ PR",
"55633448", "Babaçulândia\ \-\ TO",
"55663561", "Itaúba\ \-\ MT",
"55222623", "Armação\ dos\ Búzios\ \-\ RJ",
"55913752", "Tailândia\ \-\ PA",
"55733251", "Itacaré\ \-\ BA",
"55143711", "Avaré\ \-\ SP",
"55513133", "Novo\ Hamburgo\ \-\ RS",
"55623351", "Campos\ Verdes\ \-\ GO",
"55343671", "São\ Gotardo\ \-\ MG",
"55613306", "Brasília\ \-\ DF",
"55313779", "Sete\ Lagoas\ \-\ MG",
"55793459", "Pedra\ Mole\ \-\ SE",
"55114595", "Várzea\ Paulista\ \-\ SP",
"55163603", "Ribeirão\ Preto\ \-\ SP",
"55313694", "Nova\ Lima\ \-\ MG",
"55553747", "Boa\ Vista\ das\ Missões\ \-\ RS",
"55843298", "São\ Bento\ do\ Trairí\ \-\ RN",
"55443276", "Maringá\ \-\ PR",
"55833452", "Piancó\ \-\ PB",
"55473455", "Joinville\ \-\ SC",
"55823539", "Arapiraca\ \-\ AL",
"55513606", "Rondinha\ Velha\ \-\ RS",
"55383756", "Buenópolis\ \-\ MG",
"55192138", "Campinas\ \-\ SP",
"5584321", "Natal\ \-\ RN",
"5521", "Rio\ de\ Janeiro",
"55613012", "Brasília\ \-\ DF",
"55733230", "Ubaitaba\ \-\ BA",
"55623546", "Goiânia\ \-\ GO",
"55213978", "Rio\ de\ Janeiro\ \-\ RJ",
"55633554", "Taquarussu\ do\ Porto\ \-\ TO",
"55413056", "Pinhais\ \-\ PR",
"55112848", "São\ Paulo\ \-\ SP",
"55553753", "São\ José\ das\ MissõEs\ \-\ RS",
"55653364", "Várzea\ Grande\ \-\ MT",
"55313873", "Matipó\ \-\ MG",
"55222741", "São\ João\ da\ Barra\ \-\ RJ",
"55183367", "Borá\ \-\ SP",
"55115646", "São\ Paulo\ \-\ SP",
"55173827", "Potirendaba\ \-\ SP",
"55773434", "Planalto\ \-\ BA",
"55753271", "Euclides\ da\ Cunha\ \-\ BA",
"5511507", "São\ Paulo\ \-\ SP",
"55473358", "Witmarsum\ \-\ SC",
"55873202", "Petrolina\ \-\ PE",
"55124110", "Pindamonhangaba\ \-\ SP",
"55833383", "Soledade\ \-\ PB",
"55873876", "Belém\ de\ São\ Francisco\ \-\ PE",
"55373341", "Itapecerica\ \-\ MG",
"55313579", "Aranha\ \-\ MG",
"55273322", "Vitória\ \-\ ES",
"55283322", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55773401", "Vitória\ da\ Conquista\ \-\ BA",
"55115819", "São\ Paulo\ \-\ SP",
"55443582", "Guaiporã\ \-\ PR",
"55543387", "Selbach\ \-\ RS",
"55483023", "Palhoça\ \-\ SC",
"55493592", "Tangará\ \-\ SC",
"55543533", "Caxias\ do\ Sul\ \-\ RS",
"55472125", "Balneário\ Camboriú\ \-\ SC",
"55863288", "Palmeirais\ \-\ PI",
"55513684", "Tramandaí\ \-\ RS",
"55743552", "Campo\ Formoso\ \-\ BA",
"55313723", "Casa\ Grande\ \-\ MG",
"55143815", "Botucatu\ \-\ SP",
"55212301", "Rio\ de\ Janeiro\ \-\ RJ",
"55613335", "São\ Sebastião\ \-\ DF",
"55813753", "São\ Joaquim\ do\ Monte\ \-\ PE",
"55643941", "Itumbiara\ \-\ GO",
"55733041", "Itabuna\ \-\ BA",
"55343843", "Estrela\ do\ Sul\ \-\ MG",
"55513472", "Canoas\ \-\ RS",
"55222541", "Nova\ Friburgo\ \-\ RJ",
"55343268", "Ituiutaba\ \-\ MG",
"55213431", "Rio\ de\ Janeiro\ \-\ RJ",
"55114176", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55115695", "São\ Paulo\ \-\ SP",
"55623920", "Goiânia\ \-\ GO",
"55883574", "Barbalha\ \-\ CE",
"55123975", "Santa\ Branca\ \-\ SP",
"55793302", "Aracaju\ \-\ SE",
"55513635", "São\ Sebastião\ do\ Caí\ \-\ RS",
"5511272", "São\ Paulo\ \-\ SP",
"55833309", "São\ José\ dos\ Cordeiros\ \-\ PB",
"5517321", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55923221", "Manaus\ \-\ AM",
"55313641", "Santa\ Luzia\ \-\ MG",
"55193181", "Floresta\ Escura\ \-\ SP",
"55813747", "Brejo\ da\ Madre\ de\ Deus\ \-\ PE",
"55843367", "Paraú\ \-\ RN",
"55162138", "Ribeirão\ Preto\ \-\ SP",
"55693428", "Nova\ Londrina\ \-\ RO",
"55183655", "Barbosa\ \-\ SP",
"55883526", "Saboeiro\ \-\ CE",
"55633396", "São\ Salvador\ do\ Tocantins\ \-\ TO",
"55623595", "Goiânia\ \-\ GO",
"55853133", "Fortaleza\ \-\ CE",
"55643687", "Córrego\ do\ Ouro\ \-\ GO",
"55343614", "Perdizes\ \-\ MG",
"55793264", "Itaporanga\ d\'Ajuda\ \-\ SE",
"55433244", "Prado\ Ferreira\ \-\ PR",
"55343839", "Patrocínio\ \-\ MG",
"55113505", "São\ Paulo\ \-\ SP",
"55613394", "Santa\ Maria\ \-\ DF",
"55213279", "Rio\ de\ Janeiro\ \-\ RJ",
"55423256", "Porto\ Amazonas\ \-\ PR",
"55153325", "Sorocaba\ \-\ SP",
"55222735", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55323727", "Barão\ de\ Monte\ Alto\ \-\ MG",
"55823621", "Santana\ do\ Ipanema\ \-\ AL",
"55243421", "Angra\ dos\ Reis\ \-\ RJ",
"55973415", "Benjamin\ Constant\ \-\ AM",
"55643697", "Davinópolis\ \-\ GO",
"55133844", "Juquiá\ \-\ SP",
"55733312", "Itamaraju\ \-\ BA",
"55543625", "Capão\ Bonito\ do\ Sul\ \-\ RS",
"55633386", "Palmeirópolis\ \-\ TO",
"55222222", "Nova\ Friburgo\ \-\ RJ",
"55543397", "Maximiliano\ de\ Almeida\ \-\ RS",
"5524334", "Volta\ Redonda\ \-\ RJ",
"55114805", "Jundiaí\ \-\ SP",
"55623534", "Goiânia\ \-\ GO",
"55353664", "Conceição\ das\ Pedras\ \-\ MG",
"55163202", "Jaboticabal\ \-\ SP",
"55113964", "Jundiaí\ \-\ SP",
"55553303", "Cruz\ Alta\ \-\ RS",
"55833559", "Bom\ Jesus\ \-\ PB",
"55463224", "Pato\ Branco\ \-\ PR",
"55833393", "Fagundes\ \-\ PB",
"55513523", "Parobé\ \-\ RS",
"55333529", "Teófilo\ Otoni\ \-\ MG",
"55114785", "Embu\ das\ Artes\ \-\ SP",
"55163711", "Franca\ \-\ SP",
"55923542", "Maués\ \-\ AM",
"55115634", "São\ Paulo\ \-\ SP",
"55423463", "Rio\ Azul\ \-\ PR",
"55773446", "Aracatu\ \-\ BA",
"55513779", "Rio\ Grande\ do\ Sul",
"55513694", "Minas\ do\ Leão\ \-\ RS",
"55863298", "Angical\ do\ Piauí\ \-\ PI",
"55273256", "Aracruz\ \-\ ES",
"55853369", "Maranguape\ \-\ CE",
"55893577", "Monte\ Alegre\ do\ Piauí\ \-\ PI",
"55183288", "Rosana\ \-\ SP",
"55323313", "Juiz\ de\ Fora\ \-\ MG",
"55112662", "São\ Paulo\ \-\ SP",
"55624104", "Goiânia\ \-\ GO",
"55643498", "Professor\ Jamil\ \-\ GO",
"55353373", "Virgínia\ \-\ MG",
"55913469", "Nova\ Timboteua\ \-\ PA",
"55863343", "Piracuruca\ \-\ PI",
"55323278", "Pequeri\ \-\ MG",
"55193841", "Mogi\-Guaçu\ \-\ SP",
"55983273", "São\ Luís\ \-\ MA",
"55143731", "Avaré\ \-\ SP",
"55273071", "Vitória\ \-\ ES",
"55953592", "Pacaraima\ \-\ RR",
"55193629", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55873835", "Pesqueira\ \-\ PE",
"55123647", "Lagoinha\ \-\ SP",
"55883586", "Crato\ \-\ CE",
"55193545", "Santa\ Gertrudes\ \-\ SP",
"55313889", "Belo\ Horizonte\ \-\ MG",
"55643627", "Riverlândia\ \-\ GO",
"55493241", "Curitibanos\ \-\ SC",
"55123311", "Aparecida\ \-\ SP",
"55833248", "Cabedelo\ \-\ PB",
"55423025", "Ponta\ Grossa\ \-\ PR",
"55333611", "Águas\ Formosas\ \-\ MG",
"55883531", "Brejo\ Santo\ \-\ CE",
"5515341", "Sorocaba\ \-\ SP",
"55193796", "Campinas\ \-\ SP",
"55123653", "Caçapava\ \-\ SP",
"55673676", "Nova\ Andradina\ \-\ MS",
"55513676", "Arambaré\ \-\ RS",
"55213097", "Teresópolis\ \-\ RJ",
"55114135", "Taboão\ da\ Serra\ \-\ SP",
"55773414", "Jussiape\ \-\ BA",
"55443522", "Goioerê\ \-\ PR",
"55543327", "Passo\ Fundo\ \-\ RS",
"55423912", "São\ Mateus\ do\ Sul\ \-\ PR",
"55513593", "Novo\ Hamburgo\ \-\ RS",
"55273382", "Vitória\ \-\ ES",
"55333353", "Pingo\-D\'Água\ \-\ MG",
"55123981", "Cedro\ \-\ SP",
"55663301", "Rondonópolis\ \-\ MT",
"55513624", "Santa\ Terezinha\ \-\ RS",
"55163116", "São\ Carlos\ \-\ SP",
"55433064", "Londrina\ \-\ PR",
"5519346", "Americana\ \-\ SP",
"55222134", "Iguaba\ Grande\ \-\ RJ",
"55753201", "Acupe\ \-\ BA",
"55873884", "São\ José\ do\ Belmonte\ \-\ PE",
"55353563", "Bom\ Jesus\ da\ Penha\ \-\ MG",
"55973441", "Santa\ Isabel\ do\ Rio\ Negro\ \-\ AM",
"55192118", "Hortolândia\ \-\ SP",
"55623956", "Goiânia\ \-\ GO",
"55464055", "Pato\ Branco\ \-\ PR",
"55414064", "Paranaguá\ \-\ PR",
"55433433", "Ariranha\ do\ Ivaí\ \-\ PR",
"5531325", "Minas\ Gerais",
"55753246", "São\ Gonçalo\ dos\ Campos\ \-\ BA",
"55513583", "Rio\ Grande\ do\ Sul",
"5581322", "Recife\ \-\ PE",
"55483093", "Palhoça\ \-\ SC",
"55773642", "Oliveira\ dos\ Brejinhos\ \-\ BA",
"55552102", "Uruguaiana\ \-\ RS",
"55493522", "Joaçaba\ \-\ SC",
"55153334", "Sorocaba\ \-\ SP",
"55473148", "Navegantes\ \-\ SC",
"55313615", "Belo\ Horizonte\ \-\ MG",
"55513337", "Rio\ Grande\ do\ Sul",
"55163704", "Franca\ \-\ SP",
"55123042", "São\ José\ dos\ Campos\ \-\ SP",
"55143354", "Botucatu\ \-\ SP",
"55833462", "São\ Mamede\ \-\ PB",
"55343513", "Araguari\ \-\ MG",
"55483465", "Urussanga\ \-\ SC",
"55153022", "Tatuí\ \-\ SP",
"55163835", "Miguelópolis\ \-\ SP",
"55473465", "Joinville\ \-\ SC",
"55513509", "São\ Leopoldo\ \-\ RS",
"55173343", "Bebedouro\ \-\ SP",
"5511279", "São\ Paulo\ \-\ SP",
"55733261", "Eunápolis\ \-\ BA",
"55673509", "Três\ Lagoas\ \-\ MS",
"55453240", "Medianeira\ \-\ PR",
"55663551", "Nova\ Canaã\ do\ Norte\ \-\ MT",
"55633374", "Figueirópolis\ \-\ TO",
"55623361", "Itapaci\ \-\ GO",
"55943342", "Abel\ Figueiredo\ \-\ PA",
"55613637", "Planaltina\ \-\ GO",
"55553329", "Entre\ Ijuís\ \-\ RS",
"55114816", "Jundiaí\ \-\ SP",
"55533028", "Pelotas\ \-\ RS",
"55313402", "Nova\ Lima\ \-\ MG",
"55143841", "São\ Manuel\ \-\ SP",
"55413668", "Pinhais\ \-\ PR",
"55883673", "Itapipoca\ \-\ CE",
"55223828", "Boaventura\ \-\ RJ",
"55143629", "Potunduva\ \-\ SP",
"55193806", "Mogi\ Mirim\ \-\ SP",
"55313899", "Viçosa\ \-\ MG",
"55193965", "Hortolândia\ \-\ SP",
"55813563", "Gravatá\ \-\ PE",
"55143553", "Guaimbê\ \-\ SP",
"55853012", "Caucaia\ \-\ CE",
"55123604", "Pindamonhangaba\ \-\ SP",
"55633696", "Novo\ Jardim\ \-\ TO",
"55173355", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55183355", "Presidente\ Prudente\ \-\ SP",
"55623877", "Goiânia\ \-\ GO",
"55443464", "São\ Pedro\ do\ Paraná\ \-\ PR",
"55114651", "Arujá\ \-\ SP",
"55313161", "Ribeirão\ das\ Neves\ \-\ MG",
"55383723", "Inimutaba\ \-\ MG",
"55112245", "Guarulhos\ \-\ SP",
"55813711", "Caruaru\ \-\ PE",
"55643533", "Itumbiara\ \-\ GO",
"55114159", "Vargem\ Grande\ Paulista\ \-\ SP",
"55333262", "Goiabeira\ \-\ MG",
"55313854", "Rio\ Piracicaba\ \-\ MG",
"55793318", "Monte\ Alegre\ de\ Sergipe\ \-\ SE",
"55173846", "Mira\ Estrela\ \-\ SP",
"55553511", "Santa\ Rosa\ \-\ RS",
"55473467", "Joinville\ \-\ SC",
"55483467", "Içara\ \-\ SC",
"55883664", "Marco\ \-\ CE",
"55143547", "Guaiçara\ \-\ SP",
"55313556", "Mariana\ \-\ MG",
"55673438", "Laguna\ Carapã\ \-\ MS",
"55834105", "Cabedelo\ \-\ PB",
"55853306", "Fortaleza\ \-\ CE",
"55873859", "Santa\ Terezinha\ \-\ PE",
"55513438", "Cachoeirinha\ \-\ RS",
"55483246", "São\ José\ \-\ SC",
"55623527", "Araçu\ \-\ GO",
"55813526", "Vitória\ de\ Santo\ Antão\ \-\ PE",
"55354101", "Varginha\ \-\ MG",
"55633363", "Porto\ Nacional\ \-\ TO",
"55733017", "Ilhéus\ \-\ BA",
"55153533", "Bom\ Sucesso\ de\ Itararé\ \-\ SP",
"55893536", "Flores\ do\ Piauí\ \-\ PI",
"5531342", "Minas\ Gerais",
"55873837", "Iguaraci\ \-\ PE",
"55112822", "Osasco\ \-\ SP",
"55323330", "Correia\ de\ Almeida\ \-\ MG",
"55983302", "São\ Luís\ \-\ MA",
"55543371", "Marau\ \-\ RS",
"55143303", "Marília\ \-\ SP",
"55163664", "Brodowski\ \-\ SP",
"55513756", "Anta\ Gorda\ \-\ RS",
"55853341", "Maranguape\ \-\ CE",
"55513394", "Rio\ Grande\ do\ Sul",
"55843536", "Pedra\ Preta\ \-\ RN",
"55333345", "Chalé\ \-\ MG",
"55983264", "São\ Luís\ \-\ MA",
"55812138", "Recife\ \-\ PE",
"55663442", "Vale\ dos\ Sonhos\ \-\ MT",
"55423027", "Ponta\ Grossa\ \-\ PR",
"55353824", "Ingaí\ \-\ MG",
"55163859", "Orlândia\ \-\ SP",
"55893591", "Jurema\ \-\ PI",
"55843062", "Mossoró\ \-\ RN",
"55173801", "Riolândia\ \-\ SP",
"55353364", "Pouso\ Alto\ \-\ MG",
"55212646", "São\ Gonçalo\ \-\ RJ",
"55193547", "Araras\ \-\ SP",
"55243076", "Volta\ Redonda\ \-\ RJ",
"55833366", "Lagoa\ Seca\ \-\ PB",
"55313590", "Minas\ Gerais",
"55713267", "Salvador\ \-\ BA",
"55143389", "Timburi\ \-\ SP",
"55543906", "Farroupilha\ \-\ RS",
"55543325", "São\ José\ do\ Herval\ \-\ RS",
"55733612", "Itabuna\ \-\ BA",
"55114137", "Taboão\ da\ Serra\ \-\ SP",
"55693533", "Porto\ Velho\ \-\ RO",
"55243332", "Rio\ Claro\ \-\ RJ",
"55353526", "Passos\ \-\ MG",
"55193399", "Sumaré\ \-\ SP",
"55223201", "Araruama\ \-\ RJ",
"55643671", "São\ Luís\ de\ Montes\ Belos\ \-\ GO",
"55323351", "Barroso\ \-\ MG",
"55513780", "Rio\ Grande\ do\ Sul",
"55633422", "Bernardo\ Sayão\ \-\ TO",
"55323725", "Antônio\ Prado\ de\ Minas\ \-\ MG",
"55513151", "Porto\ Alegre\ \-\ RS",
"55112892", "São\ Paulo\ \-\ SP",
"55153327", "Sorocaba\ \-\ SP",
"55183639", "Santo\ Antônio\ do\ Aracanguá\ \-\ SP",
"55453219", "Cascavel\ \-\ PR",
"5593", "Pará",
"55173639", "Populina\ \-\ SP",
"55623979", "Anápolis\ \-\ GO",
"55192102", "Campinas\ \-\ SP",
"55113507", "São\ Paulo\ \-\ SP",
"55533252", "Canguçu\ \-\ RS",
"55983469", "Urbano\ Santos\ \-\ MA",
"55513659", "Rio\ Grande\ do\ Sul",
"55663601", "Nova\ Fronteira\ \-\ MT",
"55833623", "Cuité\ de\ Mamanguape\ \-\ PB",
"5531348", "Belo\ Horizonte\ \-\ MG",
"55153258", "Guareí\ \-\ SP",
"55453267", "Vera\ Cruz\ do\ Oeste\ \-\ PR",
"55313870", "Minas\ Gerais",
"55623587", "Aparecida\ de\ Goiânia\ \-\ GO",
"55643695", "Adelândia\ \-\ GO",
"55973417", "Atalaia\ do\ Norte\ \-\ AM",
"55433528", "Wenceslau\ Braz\ \-\ PR",
"55893521", "Floriano\ \-\ PI",
"55193817", "Amparo\ \-\ SP",
"55114787", "Taboão\ da\ Serra\ \-\ SP",
"55613359", "Samambaia\ Sul\ \-\ DF",
"55853315", "São\ Gonçalo\ do\ Amarante\ \-\ CE",
"55553272", "Tupanciretã\ \-\ RS",
"55993642", "Pedreiras\ \-\ MA",
"55313520", "Minas\ Gerais",
"55513566", "São\ Leopoldo\ \-\ RS",
"55433878", "Londrina\ \-\ PR",
"55433461", "Faxinal\ \-\ PR",
"55713414", "Salvador\ \-\ BA",
"55893468", "Aroazes\ \-\ PI",
"55242723", "Campos\ dos\ Goitacazes\ \-\ RJ",
"55413083", "Curitiba\ \-\ PR",
"55843242", "Arês\ \-\ RN",
"55343301", "Uberlândia\ \-\ MG",
"55193654", "Santo\ Antônio\ do\ Jardim\ \-\ SP",
"55333764", "Minas\ Novas\ \-\ MG",
"55543395", "Viadutos\ \-\ RS",
"55673901", "Campo\ Grande\ \-\ MS",
"55193869", "Valinhos\ \-\ SP",
"55513032", "Canoas\ \-\ RS",
"55683901", "Rio\ Branco\ \-\ AC",
"55893575", "Avelino\ Lopes\ \-\ PI",
"55115092", "São\ Paulo\ \-\ SP",
"55463548", "Bom\ Jesus\ do\ Sul\ \-\ PR",
"55133278", "Santos\ \-\ SP",
"55913441", "Igarapé\-Açu\ \-\ PA",
"55123119", "Campos\ de\ Cunha\ \-\ SP",
"5585349", "Fortaleza\ \-\ CE",
"55613624", "Valparaíso\ de\ Goiás\ \-\ GO",
"55543385", "Tapera\ \-\ RS",
"55963243", "Macapá\ \-\ AP",
"55873939", "Flores\ \-\ PE",
"55114278", "Santa\ Isabel\ \-\ SP",
"55553796", "Alpestre\ \-\ RS",
"55713642", "Pólo\ Petroquímico\ Camaçari\ \-\ BA",
"55643634", "Chapadão\ do\ Céu\ \-\ GO",
"55353835", "Cristais\ \-\ MG",
"55113357", "São\ Paulo\ \-\ SP",
"55112493", "Atibaia\ \-\ SP",
"55553545", "Porto\ Mauá\ \-\ RS",
"55553354", "Porto\ Xavier\ \-\ RS",
"55623661", "Goiânia\ \-\ GO",
"55823336", "Maceió\ \-\ AL",
"55115906", "São\ Paulo\ \-\ SP",
"55353531", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"5585348", "Fortaleza\ \-\ CE",
"55313766", "Minas\ Gerais",
"55483532", "Praia\ Grande\ \-\ SC",
"55513720", "Estrêla\ \-\ RS",
"55553629", "Jacuizinho\ \-\ RS",
"55173643", "Santa\ Rita\ D\'Oeste\ \-\ SP",
"55833535", "São\ João\ do\ Rio\ do\ Peixe\ \-\ PB",
"55383615", "Manga\ \-\ MG",
"55183643", "Birigui\ \-\ SP",
"55163957", "Ibitiúva\ \-\ SP",
"55623349", "Hidrolina\ \-\ GO",
"55733249", "Barro\ Preto\ \-\ BA",
"55143654", "Brotas\ \-\ SP",
"55854042", "Fortaleza\ \-\ CE",
"55513637", "Feliz\ \-\ RS",
"55653329", "Tangará\ da\ Serra\ \-\ MT",
"55663513", "Sorriso\ \-\ MT",
"55483214", "São\ José\ \-\ SC",
"55413465", "Morretes\ \-\ PR",
"55843521", "Macau\ \-\ RN",
"55434009", "Londrina\ \-\ PR",
"55883563", "Icó\ \-\ CE",
"55623597", "Goiânia\ \-\ GO",
"55643685", "Ivolândia\ \-\ GO",
"55222759", "Macaé\ \-\ RJ",
"55173814", "Adolfo\ \-\ SP",
"55163943", "Barrinha\ \-\ SP",
"55543334", "Colorado\ \-\ RS",
"55863131", "Teresina\ \-\ PI",
"55483668", "Pinheiral\ \-\ SC",
"55373402", "Itaúna\ \-\ MG",
"55813673", "Catende\ \-\ PE",
"5531349", "Belo\ Horizonte\ \-\ MG",
"55183657", "Alto\ Alegre\ \-\ SP",
"55223066", "Nova\ Friburgo\ \-\ RJ",
"55843365", "Messias\ Targino\ \-\ RN",
"55633028", "Palmas\ \-\ TO",
"55813745", "Riacho\ das\ Almas\ \-\ PE",
"55343855", "Rio\ Paranaíba\ \-\ MG",
"55753023", "Feira\ de\ Santana\ \-\ BA",
"55183721", "Andradina\ \-\ SP",
"5581346", "Recife\ \-\ PE",
"55383676", "Unaí\ \-\ MG",
"55143373", "Santa\ Cruz\ do\ Rio\ Pardo\ \-\ SP",
"55983372", "Santo\ Antônio\ dos\ Lopes\ \-\ MA",
"55922121", "Manaus\ \-\ AM",
"55873869", "Santa\ Maria\ da\ Boa\ Vista\ \-\ PE",
"55833390", "Prata\ \-\ PB",
"55533311", "Bagé\ \-\ RS",
"55353731", "Andradas\ \-\ MG",
"55424007", "Ponta\ Grossa\ \-\ PR",
"55373359", "Arcos\ \-\ MG",
"55753358", "Coronel\ Octaviano\ Alves\ \-\ BA",
"55633353", "Alvorada\ \-\ TO",
"55863242", "Barras\ \-\ PI",
"55483271", "Florianópolis\ \-\ SC",
"55993425", "Jenipapo\ dos\ Vieiras\ \-\ MA",
"55473457", "Barra\ Velha\ \-\ SC",
"55383624", "São\ Romão\ \-\ MG",
"55244004", "Petrópolis\ \-\ RJ",
"55883654", "Mucambo\ \-\ CE",
"55114597", "Nazaré\ Paulista\ \-\ SP",
"55553745", "Iraí\ \-\ RS",
"55423460", "Teixeira\ Soares\ \-\ PR",
"55873817", "Alagoinha\ \-\ PE",
"55823305", "Maceió\ \-\ AL",
"55222666", "São\ Vicente\ de\ Paula\ \-\ RJ",
"55183871", "Panorama\ \-\ SP",
"55313130", "Matozinhos\ \-\ MG",
"55843643", "Parnamirim\ \-\ RN",
"55313324", "Belo\ Horizonte\ \-\ MG",
"55313864", "Carmésia\ \-\ MG",
"55333252", "Joanésia\ \-\ MG",
"55114169", "Carapicuíba\ \-\ SP",
"55183521", "Adamantina\ \-\ SP",
"55743672", "Morro\ do\ Chapéu\ \-\ BA",
"55813545", "Igarassu\ \-\ PE",
"55173521", "Catanduva\ \-\ SP",
"55313151", "Sete\ Lagoas\ \-\ MG",
"55873763", "Garanhuns\ \-\ PE",
"55733421", "Porto\ Seguro\ \-\ BA",
"55222559", "São\ Sebastião\ do\ Alto\ \-\ RJ",
"55913484", "Santarém\ Novo\ \-\ PA",
"55643601", "São\ Luís\ de\ Montes\ Belos\ \-\ GO",
"5511405", "Diadema\ \-\ SP",
"55733632", "Ilhéus\ \-\ BA",
"55313376", "Belo\ Horizonte\ \-\ MG",
"55432105", "Londrina\ \-\ PR",
"55213852", "Rio\ de\ Janeiro\ \-\ RJ",
"55274007", "Vitória\ \-\ ES",
"55114661", "Embu\-Guaçu\ \-\ SP",
"55114349", "São\ Paulo\ \-\ SP",
"55483443", "Criciúma\ \-\ SC",
"55473443", "Itapoá\ \-\ SC",
"55163763", "Jardinópolis\ \-\ SP",
"55643513", "Caldas\ Novas\ \-\ GO",
"55123674", "Tremembé\ \-\ SP",
"55493454", "Xavantina\ \-\ SC",
"55543551", "Machadinho\ \-\ RS",
"55193563", "Pirassununga\ \-\ SP",
"55223842", "Porciúncula\ \-\ RJ",
"55813272", "Recife\ \-\ PE",
"55813731", "Santa\ Cruz\ do\ Capibaribe\ \-\ PE",
"55313637", "Santa\ Luzia\ \-\ MG",
"55323361", "Carandaí\ \-\ MG",
"55623923", "Goiânia\ \-\ GO",
"55833356", "Cabaceiras\ \-\ PB",
"55414003", "Curitiba\ \-\ PR",
"55553884", "Dona\ Otília\ \-\ RS",
"55943328", "Núcleo\ Carajás\ \-\ PA",
"55333326", "Santa\ Bárbara\ do\ Leste\ \-\ MG",
"55162102", "Ribeirão\ Preto\ \-\ SP",
"55823555", "São\ Brás\ \-\ AL",
"55823344", "Maceió\ \-\ AL",
"55913494", "Muaná\ \-\ PA",
"55222537", "Carmo\ \-\ RJ",
"55123893", "São\ Sebastião\ \-\ SP",
"55483439", "Criciúma\ \-\ SC",
"55353545", "Ibiraci\ \-\ MG",
"5561325", "Brasília\ \-\ DF",
"55493548", "Vargem\ Bonita\ \-\ SC",
"55853324", "Caridade\ \-\ CE",
"55173242", "Mirassol\ \-\ SP",
"55212671", "Duque\ de\ Caxias\ \-\ RJ",
"55833380", "Puxinanã\ \-\ PB",
"55673418", "Itaum\ \-\ MS",
"55114979", "Santo\ André\ \-\ SP",
"55153646", "Buri\ \-\ SP",
"55193373", "Piracicaba\ \-\ SP",
"55323571", "Rio\ Pomba\ \-\ MG",
"55853376", "Guaiúba\ \-\ CE",
"55353841", "Bom\ Sucesso\ \-\ MG",
"55543346", "Ciríaco\ \-\ RS",
"55112352", "São\ Paulo\ \-\ SP",
"55513766", "Bom\ Retiro\ do\ Sul\ \-\ RS",
"55353629", "Itajubá\ \-\ MG",
"55313720", "Minas\ Gerais",
"55212397", "Duque\ de\ Caxias\ \-\ RJ",
"55773628", "Luis\ Eduardo\ Magalhães\ \-\ BA",
"55223234", "Campos\ dos\ Goitacazes\ \-\ RJ",
"55693442", "Rolim\ de\ Moura\ \-\ RO",
"55313384", "Belo\ Horizonte\ \-\ MG",
"55873967", "Ouricuri\ \-\ PE",
"55193859", "Valinhos\ \-\ SP",
"55212713", "São\ Gonçalo\ \-\ RJ",
"55483285", "Biguaçu\ \-\ SC",
"55273223", "Vitória\ \-\ ES",
"55383635", "Arinos\ \-\ MG",
"55183581", "Flórida\ Paulista\ \-\ SP",
"55883303", "Aracati\ \-\ CE",
"55833282", "Pilar\ \-\ PB",
"55752101", "Feira\ de\ Santana\ \-\ BA",
"55813136", "Caruaru\ \-\ PE",
"55453243", "Nova\ Aurora\ \-\ PR",
"5567342", "Dourados\ \-\ MS",
"55433451", "São\ Pedro\ do\ Ivaí\ \-\ PR",
"55813689", "Jaqueira\ \-\ PE",
"55323746", "Espera\ Feliz\ \-\ MG",
"55183705", "Guaraçaí\ \-\ SP",
"55123157", "Lorena\ \-\ SP",
"55333754", "Cachoeira\ de\ Pajeú\ \-\ MG",
"55913424", "Redenção\ \-\ PA",
"55443237", "Santa\ Zélia\ \-\ PR",
"55613369", "Paranoá\ \-\ DF",
"55533921", "Pelotas\ \-\ RS",
"55643614", "Santa\ Helena\ de\ Goiás\ \-\ GO",
"55513556", "Rio\ Grande\ do\ Sul",
"55133877", "Santos\ \-\ SP",
"55313438", "Minas\ Gerais",
"55453257", "Entre\ Rios\ do\ Oeste\ \-\ PR",
"55513580", "Novo\ Hamburgo\ \-\ RS",
"55153268", "Boituva\ \-\ SP",
"55112772", "São\ Paulo\ \-\ SP",
"55533304", "Santa\ Maria\ \-\ RS",
"55513669", "Nova\ Tramandaí\ \-\ RS",
"55673669", "Paranaíba\ \-\ MS",
"55483090", "São\ José\ \-\ SC",
"55173834", "Guarani\ D\'Oeste\ \-\ SP",
"55924009", "Manaus\ \-\ AM",
"55893544", "Uruçuí\ \-\ PI",
"55693733", "Porto\ Velho\ \-\ RO",
"55753287", "Abaré\ \-\ BA",
"55533262", "Arroio\ Grande\ \-\ RS",
"55223512", "Nova\ Friburgo\ \-\ RJ",
"55513617", "Rio\ Grande\ do\ Sul",
"55773698", "Ibotirama\ \-\ BA",
"55123143", "Cruzeiro\ \-\ SP",
"55663533", "Sinop\ \-\ MT",
"55313335", "Belo\ Horizonte\ \-\ MG",
"55473234", "Blumenau\ \-\ SC",
"55473080", "Blumenau\ \-\ SC",
"55923528", "Silves\ \-\ AM",
"55483658", "Braço\ do\ Norte\ \-\ SC",
"55113153", "São\ Paulo\ \-\ SP",
"55173667", "Turmalina\ \-\ SP",
"55223056", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55843355", "Venha\-Ver\ \-\ RN",
"55323534", "Brás\ Pires\ \-\ MG",
"55883553", "Milagres\ \-\ CE",
"55163389", "São\ Lourenço\ do\ Turvo\ \-\ SP",
"55853384", "Maracanaú\ \-\ CE",
"55373523", "Pompéu\ \-\ MG",
"55513590", "São\ Leopoldo\ \-\ RS",
"55383523", "Felício\ dos\ Santos\ \-\ MG",
"55453239", "Juvinópolis\ \-\ PR",
"55183744", "Nova\ Independência\ \-\ SP",
"55413455", "Pontal\ do\ Paraná\ \-\ PR",
"55212634", "Maricá\ \-\ RJ",
"5542", "Paraná",
"55773688", "Novo\ Paraná\ \-\ BA",
"55553526", "Sede\ Nova\ \-\ RS",
"55943434", "Ourilândia\ do\ Norte\ \-\ PA",
"55833292", "Mamanguape\ \-\ PB",
"55212685", "Mangaratiba\ \-\ RJ",
"55863340", "Matias\ Olímpio\ \-\ PI",
"55143664", "Itapuí\ \-\ SP",
"55343428", "Fronteira\ \-\ MG",
"55313394", "Belo\ Horizonte\ \-\ MG",
"55883547", "Caririaçu\ \-\ CE",
"55623983", "Aparecida\ de\ Goiânia\ \-\ GO",
"55163303", "Araraquara\ \-\ SP",
"55443259", "Maringá\ \-\ PR",
"5528", "Espirito\ Santo",
"55493237", "Capão\ Alto\ \-\ SC",
"5527", "Espirito\ Santo",
"55613606", "Santo\ Antônio\ do\ Descoberto\ \-\ GO",
"55115855", "São\ Paulo\ \-\ SP",
"55313756", "Minas\ Gerais",
"55813726", "Belo\ Jardim\ \-\ PE",
"55123631", "Taubaté\ \-\ SP",
"55133208", "Santos\ \-\ SP",
"55113367", "São\ Paulo\ \-\ SP",
"55413358", "São\ José\ dos\ Pinhais\ \-\ PR",
"55643442", "Catalão\ \-\ GO",
"55123686", "Taubaté\ \-\ SP",
"55193837", "Jaguariúna\ \-\ SP",
"55143218", "Bauru\ \-\ SP",
"55333331", "Manhuaçu\ \-\ MG",
"55813699", "Panelas\ \-\ PE",
"55473056", "Balneário\ Camboriú\ \-\ SC",
"55413442", "Guaratuba\ \-\ PR",
"55213724", "Rio\ de\ Janeiro\ \-\ RJ",
"55512117", "Porto\ Alegre\ \-\ RS",
"55133378", "Cubatão\ \-\ SP",
"55543056", "Farroupilha\ \-\ RS",
"55823291", "Barra\ de\ Santo\ Antônio\ \-\ AL",
"55143484", "Álvaro\ de\ Carvalho\ \-\ SP",
"55983673", "Brejo\ de\ Areia\ \-\ MA",
"55493641", "Princesa\ \-\ SC",
"55323332", "Barbacena\ \-\ MG",
"55433616", "Sengés\ \-\ PR",
"55813762", "Garanhuns\ \-\ PE",
"55243351", "Itatiaia\ \-\ RJ",
"55543295", "Gramado\ \-\ RS",
"55343201", "Araxá\ \-\ MG",
"55433543", "Itambaracá\ \-\ PR",
"55163273", "Itápolis\ \-\ SP",
"5547343", "Joinville\ \-\ SC",
"55553372", "Santa\ Bárbara\ do\ Sul\ \-\ RS",
"55923681", "Manaus\ \-\ AM",
"55714117", "Simões\ Filho\ \-\ BA",
"55643455", "Caldas\ Novas\ \-\ GO",
"55612141", "Brasília\ \-\ DF",
"55513782", "Santa\ Clara\ do\ Sul\ \-\ RS",
"55443133", "Mandaguari\ \-\ PR",
"55173487", "Magda\ \-\ SP",
"55273759", "Água\ Doce\ do\ Norte\ \-\ ES",
"55513499", "Eldorado\ do\ Sul\ \-\ RS",
"55673499", "Vila\ Nova\ Casa\ Verde\ \-\ MS",
"55463523", "Francisco\ Beltrão\ \-\ PR",
"55774141", "Vitória\ da\ Conquista\ \-\ BA",
"55433557", "Arapoti\ \-\ PR",
"55653338", "Gleba\ Ranchão\ \-\ MT",
"55114037", "Pedra\ Bela\ \-\ SP",
"55773468", "Mirante\ \-\ BA",
"55883441", "Quixeramobim\ \-\ CE",
"55673489", "Indápolis\ \-\ MS",
"55122131", "Guaratinguetá\ \-\ SP",
"55313061", "Conselheiro\ Lafaiete\ \-\ MG",
"55113425", "Diadema\ \-\ SP",
"55513489", "Gravataí\ \-\ RS",
"55843265", "Poço\ Branco\ \-\ RN",
"5511434", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55513792", "Costão\ \-\ RS",
"55753646", "Guaibim\ \-\ BA",
"55352103", "Pouso\ Alegre\ \-\ MG",
"55993665", "Capinzal\ do\ Norte\ \-\ MA",
"55543234", "São\ José\ dos\ Ausentes\ \-\ RS",
"55163406", "Franca\ \-\ SP",
"55663023", "Rondonópolis\ \-\ MT",
"5571323", "Salvador\ \-\ BA",
"55313215", "Minas\ Gerais",
"55843011", "Natal\ \-\ RN",
"55112647", "São\ Paulo\ \-\ SP",
"55823281", "União\ dos\ Palmares\ \-\ AL",
"55443641", "Terra\ Boa\ \-\ PR",
"55343246", "Araguari\ \-\ MG",
"55513403", "Guaíba\ \-\ RS",
"55733661", "Vereda\ \-\ BA",
"55413614", "Araucária\ \-\ PR",
"5587386", "Petrolina\ \-\ PE",
"55112653", "São\ Paulo\ \-\ SP",
"55114421", "Santo\ André\ \-\ SP",
"55624053", "Goiânia\ \-\ GO",
"55553254", "Cacequi\ \-\ RS",
"55813469", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55543285", "Picada\ Café\ \-\ RS",
"55193672", "Santa\ Cruz\ das\ Palmeiras\ \-\ SP",
"55193484", "Nova\ Odessa\ \-\ SP",
"55513722", "Cachoeira\ do\ Sul\ \-\ RS",
"55642101", "Rio\ Verde\ \-\ GO",
"55323084", "Juiz\ de\ Fora\ \-\ MG",
"55993577", "Parnarama\ \-\ MA",
"55413048", "Araucária\ \-\ PR",
"55812129", "Recife\ \-\ PE",
"55473346", "Itajaí\ \-\ SC",
"55632111", "Palmas\ \-\ TO",
"55823542", "São\ Sebastião\ \-\ AL",
"5516391", "Ribeirão\ Preto\ \-\ SP",
"55483346", "São\ José\ \-\ SC",
"55733527", "Jequié\ \-\ BA",
"55753268", "Teofilândia\ \-\ BA",
"55753614", "Feira\ de\ Santana\ \-\ BA",
"55543439", "Faria\ Lemos\ \-\ RS",
"55933559", "Trairão\ \-\ PA",
"55183698", "Lavínia\ \-\ SP",
"55923675", "Manaus\ \-\ AM",
"55153287", "Laranjal\ Paulista\ \-\ SP",
"5511331", "São\ Paulo\ \-\ SP",
"55623558", "Goiânia\ \-\ GO",
"55383217", "Montes\ Claros\ \-\ MG",
"55663578", "Itanhangá\ \-\ MT",
"55152101", "Sorocaba\ \-\ SP",
"55133481", "Praia\ Grande\ \-\ SP",
"55883415", "Palhano\ \-\ CE",
"55683235", "Acrelândia\ \-\ AC",
"55863086", "Teresina\ \-\ PI",
"55123662", "Campos\ do\ Jordão\ \-\ SP",
"55213222", "Rio\ de\ Janeiro\ \-\ RJ",
"55183255", "Rancharia\ \-\ SP",
"55143476", "Campos\ Novos\ Paulista\ \-\ SP",
"55353552", "Guaxupé\ \-\ MG",
"55313241", "Belo\ Horizonte\ \-\ MG",
"55633456", "Augustinópolis\ \-\ TO",
"551124", "Guarulhos\ \-\ SP",
"55423656", "Goioxim\ \-\ PR",
"55833447", "Belém\ do\ Brejo\ do\ Cruz\ \-\ PB",
"55163415", "São\ Carlos\ \-\ SP",
"55413601", "Pinhais\ \-\ PR",
"55553752", "Ametista\ do\ Sul\ \-\ RS",
"55913859", "Salinópolis\ \-\ PA",
"55613454", "Sobradinho\ \-\ DF",
"55193476", "Nova\ Odessa\ \-\ SP",
"55133491", "Praia\ Grande\ \-\ SP",
"55283569", "Ibitirama\ \-\ ES",
"55743664", "Xique\-xique\ \-\ BA",
"55823221", "Maceió\ \-\ AL",
"55323251", "Santos\ Dumont\ \-\ MG",
"55543443", "Guaporé\ \-\ RS",
"55313872", "Abre\ Campo\ \-\ MG",
"55613013", "Brasília\ \-\ DF",
"5543302", "Londrina\ \-\ PR",
"55213171", "Rio\ de\ Janeiro\ \-\ RJ",
"55623612", "Goiânia\ \-\ GO",
"55513051", "Canoas\ \-\ RS",
"55283517", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55833266", "Mogeiro\ \-\ PB",
"55114481", "Bragança\ Paulista\ \-\ SP",
"55113434", "São\ Paulo\ \-\ SP",
"55943319", "Santa\ Maria\ das\ Barreiras\ \-\ PA",
"55694003", "Porto\ Velho\ \-\ RO",
"55733208", "Nova\ Viçosa\ \-\ BA",
"55543457", "Monte\ Belo\ do\ Sul\ \-\ RS",
"55933537", "Mujuí\ dos\ Campos\ \-\ PA",
"55353264", "Elói\ Mendes\ \-\ MG",
"55122126", "Pindamonhangaba\ \-\ SP",
"55222622", "Arraial\ do\ Cabo\ \-\ RJ",
"55213845", "Duque\ de\ Caxias\ \-\ RJ",
"55823275", "Campo\ Alegre\ \-\ AL",
"55913753", "Barcarena\ \-\ PA",
"55115090", "São\ Paulo\ \-\ SP",
"55673429", "Vila\ Macaúba\ \-\ MS",
"55112304", "Guarulhos\ \-\ SP",
"55333423", "Sabinópolis\ \-\ MG",
"55513429", "Canoas\ \-\ RS",
"55833453", "Conceição\ \-\ PB",
"55123019", "São\ José\ dos\ Campos\ \-\ SP",
"55773667", "Pindaí\ \-\ BA",
"55692101", "Vilhena\ \-\ RO",
"55483301", "Tubarão\ \-\ SC",
"55813552", "Ipojuca\ \-\ PE",
"55553270", "São\ Miguel\ \-\ RS",
"55473301", "Indaial\ \-\ SC",
"55333245", "Divino\ das\ Laranjeiras\ \-\ MG",
"55133213", "Santos\ \-\ SP",
"55153297", "Araçoiaba\ da\ Serra\ \-\ SP",
"55313522", "Minas\ Gerais",
"55143203", "Bauru\ \-\ SP",
"55543271", "São\ Jorge\ \-\ RS",
"55843240", "Montanhas\ \-\ RN",
"55773619", "Catolândia\ \-\ BA",
"55413685", "Paiol\ de\ Baixo\ \-\ PR",
"55273717", "Colatina\ \-\ ES",
"55743547", "Antônio\ Gonçalves\ \-\ BA",
"55483334", "Florianópolis\ \-\ SC",
"55773458", "Brumado\ \-\ BA",
"55223022", "Itaperuna\ \-\ RJ",
"55473334", "Blumenau\ \-\ SC",
"55313235", "Belo\ Horizonte\ \-\ MG",
"55242259", "Petrópolis\ \-\ RJ",
"55753387", "Quijingue\ \-\ BA",
"55423323", "Ponta\ Grossa\ \-\ PR",
"55273248", "Aracê\ \-\ ES",
"55433567", "Sengés\ \-\ PR",
"5571321", "Salvador\ \-\ BA",
"55473488", "Blumenau\ \-\ SC",
"55273769", "Jaguaré\ \-\ ES",
"55713655", "São\ Sebastião\ do\ Passé\ \-\ BA",
"55633538", "Aparecida\ do\ Rio\ Negro\ \-\ TO",
"55673241", "Aquidauana\ \-\ MS",
"55553552", "Vista\ Gaúcha\ \-\ RS",
"55643465", "Urutaí\ \-\ GO",
"55533204", "Rio\ Grande\ \-\ RS",
"55112331", "São\ Paulo\ \-\ SP",
"55114405", "Piracaia\ \-\ SP",
"55543532", "São\ João\ da\ Urtiga\ \-\ RS",
"55123848", "Ubatuba\ \-\ SP",
"55662101", "Rondonópolis\ \-\ MT",
"55333296", "Sardoá\ \-\ MG",
"55343842", "Monte\ Carmelo\ \-\ MG",
"55112350", "Poá\ \-\ SP",
"55513473", "Esteio\ \-\ RS",
"55673473", "Eldorado\ \-\ MS",
"55743553", "Campo\ Formoso\ \-\ BA",
"55313722", "Queluzito\ \-\ MG",
"55473385", "Benedito\ Novo\ \-\ SC",
"55713298", "Simões\ Filho\ \-\ BA",
"55823216", "Maceió\ \-\ AL",
"55613217", "Brasília\ \-\ DF",
"55213896", "Duque\ de\ Caxias\ \-\ RJ",
"55833382", "Juazeirinho\ \-\ PB",
"55413634", "São\ José\ dos\ Pinhais\ \-\ PR",
"55893427", "Tanque\ do\ Piauí\ \-\ PI",
"55353021", "Passos\ \-\ MG",
"55933737", "Almeirim\ \-\ PA",
"55623481", "Posse\ \-\ GO",
"55193602", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55853051", "Fortaleza\ \-\ CE",
"55213114", "Rio\ de\ Janeiro\ \-\ RJ",
"55114308", "Diadema\ \-\ SP",
"55493624", "Romelândia\ \-\ SC",
"55143318", "Marília\ \-\ SP",
"55813459", "Aldeia\ \-\ PE",
"55333231", "Itanhomi\ \-\ MG",
"55323312", "Juiz\ de\ Fora\ \-\ MG",
"55112663", "São\ Paulo\ \-\ SP",
"55843427", "Timbaúba\ dos\ Batistas\ \-\ RN",
"55343457", "Carneirinho\ \-\ MG",
"55443624", "Umuarama\ \-\ PR",
"55143602", "Jaú\ \-\ SP",
"55313132", "Esmeraldas\ \-\ MG",
"55343271", "Ituiutaba\ \-\ MG",
"55493337", "Jardinópolis\ \-\ SC",
"55443593", "Jota\ Esse\ \-\ PR",
"55533245", "Candiota\ \-\ RS",
"55855672", "São\ Paulo\ \-\ SP",
"55673522", "Três\ Lagoas\ \-\ MS",
"55833392", "Queimadas\ \-\ PB",
"55513522", "Morro\ da\ Pedra\ \-\ RS",
"55114444", "Franco\ da\ Rocha\ \-\ SP",
"55553302", "Santa\ Maria\ \-\ RS",
"55863240", "Cabeceiras\ do\ Piauí\ \-\ PI",
"55443676", "Cruzeiro\ do\ Oeste\ \-\ PR",
"55473395", "Pomerode\ \-\ SC",
"55713288", "Lauro\ de\ Freitas\ \-\ BA",
"55163203", "Jaboticabal\ \-\ SP",
"55143415", "Marília\ \-\ SP",
"55213850", "Rio\ de\ Janeiro\ \-\ RJ",
"55114017", "Jarinu\ \-\ SP",
"55653318", "Cuiabá\ \-\ MT",
"5511415", "Santana\ de\ Parnaíba\ \-\ SP",
"55733313", "Ipiaú\ \-\ BA",
"55983689", "Zé\ Doca\ \-\ MA",
"55473627", "Canoinhas\ \-\ SC",
"55693465", "Teixeirópolis\ \-\ RO",
"55883424", "Tabuleiro\ do\ Norte\ \-\ CE",
"55983181", "São\ Luís\ \-\ MA",
"55793547", "Arauá\ \-\ SE",
"55114069", "Diadema\ \-\ SP",
"55923018", "Manaus\ \-\ AM",
"55353437", "Senador\ Amaral\ \-\ MG",
"55112754", "São\ Paulo\ \-\ SP",
"55213584", "Nova\ Iguaçu\ \-\ RJ",
"55843255", "Senador\ Elói\ de\ Souza\ \-\ RN",
"55112396", "Itu\ \-\ SP",
"55813021", "Paulista\ \-\ PE",
"55173045", "Catanduva\ \-\ SP",
"55313499", "Minas\ Gerais",
"55633466", "Pedro\ Afonso\ \-\ TO",
"55283537", "Iconha\ \-\ ES",
"55193406", "Americana\ \-\ SP",
"55663455", "Santa\ Elvira\ \-\ MT",
"55413671", "Quatro\ Barras\ \-\ PR",
"55113414", "Itu\ \-\ SP",
"55613108", "Brasília\ \-\ DF",
"55853403", "Fortaleza\ \-\ CE",
"55143441", "Tupã\ \-\ SP",
"55173265", "José\ Bonifácio\ \-\ SP",
"55313276", "Minas\ Gerais",
"55183265", "Rancharia\ \-\ SP",
"55353562", "Nova\ Resende\ \-\ MG",
"55115066", "São\ Paulo\ \-\ SP",
"55893487", "Paulistana\ \-\ PI",
"55443523", "Campo\ Mourão\ \-\ PR",
"55753695", "São\ Domingos\ \-\ BA",
"55623421", "Alvorada\ do\ Norte\ \-\ GO",
"55173011", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55123652", "Caçapava\ \-\ SP",
"55733278", "Wenceslau\ Guimarães\ \-\ BA",
"55333352", "São\ Pedro\ dos\ Ferros\ \-\ MG",
"55653273", "Curvelândia\ \-\ MT",
"55483906", "Tubarão\ \-\ SC",
"55833322", "Campina\ Grande\ \-\ PB",
"55513592", "São\ Leopoldo\ \-\ RS",
"55623378", "Itauçu\ \-\ GO",
"55953624", "Boa\ Vista\ \-\ RR",
"55453288", "Santa\ Lúcia\ \-\ PR",
"55543712", "Erechim\ \-\ RS",
"55643440", "Cumari\ \-\ GO",
"55223865", "São\ João\ do\ Paraíso\ \-\ RJ",
"55753327", "Lajedinho\ \-\ BA",
"55773639", "Luis\ Eduardo\ Magalhães\ \-\ BA",
"55413625", "Contenda\ \-\ PR",
"5544326", "Maringá\ \-\ PR",
"55473156", "Braço\ do\ Baú\ \-\ SC",
"55833290", "Conde\ \-\ PB",
"55473371", "Jaraguá\ do\ Sul\ \-\ SC",
"55753258", "Araci\ \-\ BA",
"55422122", "Castro\ \-\ PR",
"55373259", "Pitangui\ \-\ MG",
"55473428", "Dona\ Francisca\ SC\ 301\ \-\ SC",
"55163338", "Gavião\ Peixoto\ \-\ SP",
"55933517", "Creporizão\ \-\ PA",
"55143273", "Fernão\ \-\ SP",
"55953593", "Amajari\ \-\ RR",
"55983272", "São\ Luís\ \-\ MA",
"55883672", "Nova\ Russas\ \-\ CE",
"5511333", "São\ Paulo\ \-\ SP",
"55213693", "Paracambi\ \-\ RJ",
"55433675", "Centenário\ do\ Sul\ \-\ PR",
"55383237", "Claro\ dos\ Poções\ \-\ MG",
"55813562", "Primavera\ \-\ PE",
"55554001", "Santa\ Maria\ \-\ RS",
"55753634", "Amargosa\ \-\ BA",
"55742102", "Juazeiro\ \-\ BA",
"55443635", "Japurá\ \-\ PR",
"55833463", "Taperoá\ \-\ PB",
"55343512", "Araguari\ \-\ MG",
"55773657", "Tabocas\ do\ Brejo\ Velho\ \-\ BA",
"55114233", "São\ Caetano\ do\ Sul\ \-\ SP",
"55833280", "Salgado\ de\ São\ Félix\ \-\ PB",
"55173342", "Bebedouro\ \-\ SP",
"55863265", "União\ \-\ PI",
"55833256", "Alhandra\ \-\ PB",
"55493523", "Luzerna\ \-\ SC",
"55813638", "Bom\ Jardim\ \-\ PE",
"55552103", "Santa\ Maria\ \-\ RS",
"55443684", "Guaporema\ \-\ PR",
"55663508", "Santo\ Antônio\ Fontoura\ \-\ MT",
"55323015", "Juiz\ de\ Fora\ \-\ MG",
"55913817", "Nova\ Esperança\ do\ Piriá\ \-\ PA",
"55313489", "Minas\ Gerais",
"55743654", "Barra\ do\ Mendes\ \-\ BA",
"55883435", "Potiretama\ \-\ CE",
"55283559", "Dores\ do\ Rio\ Preto\ \-\ ES",
"55813372", "Paulista\ \-\ PE",
"55513215", "Rio\ Grande\ do\ Sul",
"55143406", "Garça\ \-\ SP",
"55653928", "Cuiabá\ \-\ MT",
"55513582", "Novo\ Hamburgo\ \-\ RS",
"55213826", "Rio\ de\ Janeiro\ \-\ RJ",
"55433432", "Jandaia\ do\ Sul\ \-\ PR",
"55323261", "São\ João\ Nepomuceno\ \-\ MG",
"55133416", "Ana\ Dias\ \-\ SP",
"55773643", "Matina\ \-\ BA",
"55893497", "Betânia\ do\ Piauí\ \-\ PI",
"55753685", "Ipecaetá\ \-\ BA",
"55633362", "Dois\ Irmãos\ do\ Tocantins\ \-\ TO",
"55193302", "Piracicaba\ \-\ SP",
"55114608", "Francisco\ Morato\ \-\ SP",
"55643668", "Serranópolis\ \-\ GO",
"55913774", "São\ Francisco\ do\ Pará\ \-\ PA",
"55833682", "São\ José\ dos\ Ramos\ \-\ PB",
"55383235", "Capitão\ Enéas\ \-\ MG",
"55373235", "Pará\ de\ Minas\ \-\ MG",
"55513400", "Rio\ Grande\ do\ Sul",
"55843388", "Major\ Sales\ \-\ RN",
"55114312", "Mogi\ das\ Cruzes\ \-\ SP",
"5565368", "Várzea\ Grande\ \-\ MT",
"55833474", "Maturéia\ \-\ PB",
"55153532", "Itararé\ \-\ SP",
"55913726", "Ulianópolis\ \-\ PA",
"55613241", "Olinda\ \-\ PE",
"55112088", "Guarulhos\ \-\ SP",
"55743699", "Lapão\ \-\ BA",
"55843434", "Santana\ do\ Matos\ \-\ RN",
"55833426", "Emas\ \-\ PB",
"55443637", "Cianorte\ \-\ PR",
"55323444", "Recreio\ \-\ MG",
"55383722", "Curvelo\ \-\ MG",
"55353424", "Congonhal\ \-\ MG",
"55323017", "Juiz\ de\ Fora\ \-\ MG",
"55183401", "Valparaíso\ \-\ SP",
"55493566", "Videira\ \-\ SC",
"55242224", "São\ José\ do\ Vale\ do\ Rio\ Preto\ \-\ RJ",
"55333263", "Resplendor\ \-\ MG",
"55643532", "Itumbiara\ \-\ GO",
"55863267", "Lagoa\ Alegre\ \-\ PI",
"55673269", "Guia\ Lopes\ da\ Laguna\ \-\ MS",
"55893495", "Queimada\ Nova\ \-\ PI",
"55513748", "Lajeado\ \-\ RS",
"55193016", "Indaiatuba\ \-\ SP",
"55163075", "Ribeirão\ Preto\ \-\ SP",
"55543368", "Jacutinga\ \-\ RS",
"55983399", "Mirinzal\ \-\ MA",
"55143552", "Getulina\ \-\ SP",
"55113240", "Salvador\ \-\ BA",
"55823528", "Lagoa\ da\ Canoa\ \-\ AL",
"55473634", "São\ Bento\ do\ Sul\ \-\ SC",
"55943355", "Marabá\ \-\ PA",
"55633572", "Palmas\ \-\ TO",
"55192129", "Campinas\ \-\ SP",
"55353299", "Alfenas\ \-\ MG",
"55413385", "São\ José\ dos\ Pinhais\ \-\ PR",
"55663439", "Rondonópolis\ \-\ MT",
"55863219", "Teresina\ \-\ PI",
"55883437", "Tauá\ \-\ CE",
"5531336", "Minas\ Gerais",
"55134004", "Santos\ \-\ SP",
"5531382", "Ipatinga\ \-\ MG",
"55433911", "Jacarezinho\ \-\ PR",
"55483258", "São\ José\ \-\ SC",
"55183267", "Santo\ Expedito\ \-\ SP",
"55193552", "Mogi\ Mirim\ \-\ SP",
"55243333", "Arrozal\ \-\ RJ",
"55473258", "Vitor\ Meireles\ \-\ SC",
"55173267", "Guapiaçu\ \-\ SP",
"55313548", "Minas\ Gerais",
"55993544", "Loreto\ \-\ MA",
"55623094", "Aparecida\ de\ Goiânia\ \-\ GO",
"55633423", "Darcinópolis\ \-\ TO",
"55753428", "Pedrão\ \-\ BA",
"55163752", "Aramina\ \-\ SP",
"55283535", "Presidente\ Kennedy\ \-\ ES",
"55443901", "Maringá\ \-\ PR",
"55613522", "Brasília\ \-\ DF",
"55733546", "Nova\ Itarana\ \-\ BA",
"55463520", "Francisco\ Beltrão\ \-\ PR",
"55824009", "Maceió\ \-\ AL",
"55443566", "Juranda\ \-\ PR",
"55973389", "Apuí\ \-\ AM",
"55693532", "Cacaulândia\ \-\ RO",
"5584331", "Mossoró\ \-\ RN",
"55893485", "Isaías\ Coelho\ \-\ PI",
"55753697", "Serra\ Preta\ \-\ BA",
"55733613", "Itabuna\ \-\ BA",
"55143264", "Lençóis\ Paulista\ \-\ SP",
"55843398", "Serrinha\ dos\ Pintos\ \-\ RN",
"55413627", "Fazenda\ Rio\ Grande\ \-\ PR",
"55753325", "Iaçu\ \-\ BA",
"55443659", "Altônia\ \-\ PR",
"55493637", "Cristo\ Rei\ \-\ SC",
"55333738", "Francisco\ Badaró\ \-\ MG",
"55553318", "Jóia\ \-\ RS",
"55813476", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55143302", "Ourinhos\ \-\ SP",
"55933515", "Altamira\ \-\ PA",
"55433336", "Londrina\ \-\ PR",
"55433540", "Rancho\ Alegre\ \-\ PR",
"55913181", "Belém\ \-\ PA",
"55532126", "Rio\ Grande\ \-\ RS",
"55343455", "Carneirinho\ \-\ MG",
"5514362", "Jaú\ \-\ SP",
"55843425", "São\ João\ do\ Sabugi\ \-\ RN",
"55673033", "Dourados\ \-\ MS",
"55373276", "Conceição\ do\ Pará\ \-\ MG",
"55513033", "Esteio\ \-\ RS",
"55833450", "Tavares\ \-\ PB",
"55964141", "Macapá\ \-\ AP",
"55713052", "Salvador\ \-\ BA",
"55633493", "Palmeirante\ \-\ TO",
"5551350", "Rio\ Grande\ do\ Sul",
"55473397", "Gaspar\ \-\ SC",
"55993643", "Barra\ do\ Corda\ \-\ MA",
"55413906", "Curitiba\ \-\ PR",
"55533247", "Bagé\ \-\ RS",
"55753627", "Sapeaçu\ \-\ BA",
"55843243", "Goianinha\ \-\ RN",
"55493335", "Planalto\ Alegre\ \-\ SC",
"55833622", "Capim\ \-\ PB",
"55473625", "Irineópolis\ \-\ SC",
"55843328", "Governador\ Dix\-Sept\ Rosado\ \-\ RN",
"55312571", "Betim\ \-\ MG",
"55693467", "Rondominas\ \-\ RO",
"55483625", "Treze\ de\ Maio\ \-\ SC",
"55843471", "Parelhas\ \-\ RN",
"55274105", "Vila\ Velha\ \-\ ES",
"55213913", "Itaboraí\ \-\ RJ",
"55143417", "Marília\ \-\ SP",
"55114015", "Tuiuti\ \-\ SP",
"55112893", "São\ Paulo\ \-\ SP",
"55623332", "Silvânia\ \-\ GO",
"55843257", "Lagoa\ Salgada\ \-\ RN",
"55913731", "Vigia\ \-\ PA",
"55613010", "Brasília\ \-\ DF",
"55963521", "Oiapoque\ \-\ AP",
"55713186", "Salvador\ \-\ BA",
"55192103", "Campinas\ \-\ SP",
"55353435", "Extrema\ \-\ MG",
"55833431", "Pombal\ \-\ PB",
"55493438", "Ipumirim\ \-\ SC",
"55513958", "Charqueadas\ \-\ RS",
"55793545", "Tomar\ do\ Geru\ \-\ SE",
"55793354", "Gararu\ \-\ SE",
"55433565", "São\ José\ da\ Boa\ Vista\ \-\ PR",
"55163942", "Sertãozinho\ \-\ SP",
"55463556", "Pérola\ D\'Oeste\ \-\ PR",
"55843239", "Nísia\ Floresta\ \-\ RN",
"55883562", "Mineirolândia\ \-\ CE",
"55654001", "Cuiabá\ \-\ MT",
"55133261", "Santos\ \-\ SP",
"55643419", "Cromínia\ \-\ GO",
"55753022", "Feira\ de\ Santana\ \-\ BA",
"55313237", "Belo\ Horizonte\ \-\ MG",
"55993639", "São\ Mateus\ do\ Maranhão\ \-\ MA",
"55443438", "São\ Carlos\ do\ Ivaí\ \-\ PR",
"55283524", "Vargem\ Grande\ do\ Soturno\ \-\ ES",
"55833279", "Cachoeira\ \-\ PB",
"55743629", "Barro\ Alto\ \-\ BA",
"55913796", "Mocajuba\ \-\ PA",
"55793272", "Japaratuba\ \-\ SE",
"55112703", "São\ Paulo\ \-\ SP",
"55663512", "Alta\ Floresta\ \-\ MT",
"55143762", "Taquarituba\ \-\ SP",
"55513049", "Campo\ Bom\ \-\ RS",
"55223533", "Vila\ Velha\ \-\ ES",
"55893471", "Várzea\ Grande\ \-\ PI",
"55433478", "Lunardelli\ \-\ PR",
"55933222", "Santarém\ \-\ PA",
"55433154", "Cambé\ \-\ PR",
"55813338", "Recife\ \-\ PE",
"55112883", "Mogi\ das\ Cruzes\ \-\ SP",
"55313470", "Minas\ Gerais",
"55183642", "Birigui\ \-\ SP",
"55633483", "Bom\ Jesus\ do\ Tocantins\ \-\ TO",
"55173642", "Vitória\ Brasil\ \-\ SP",
"55483533", "Sombrio\ \-\ SC",
"5531370", "Minas\ Gerais",
"55473533", "Ituporanga\ \-\ SC",
"55433904", "Cornélio\ Procópio\ \-\ PR",
"55423524", "União\ da\ Vitória\ \-\ PR",
"55883638", "Hidrolândia\ \-\ CE",
"55983654", "Santa\ Luzia\ \-\ MA",
"55413941", "Curitiba\ \-\ PR",
"55153246", "Cesário\ Lange\ \-\ SP",
"55112809", "Guarulhos\ \-\ SP",
"55513464", "Canoas\ \-\ RS",
"55683464", "Jordão\ \-\ AC",
"55753334", "Lençóis\ \-\ BA",
"55153467", "Capela\ do\ Alto\ \-\ SP",
"55893425", "Sussuapara\ \-\ PI",
"55933735", "Monte\ Dourado\ \-\ PA",
"55963242", "Macapá\ \-\ AP",
"55312106", "Sete\ Lagoas\ \-\ MG",
"55353229", "Varginha\ \-\ MG",
"55163254", "Guariroba\ \-\ SP",
"55473387", "Pomerode\ \-\ SC",
"55813435", "Paulista\ \-\ PE",
"55822121", "Maceió\ \-\ AL",
"55753301", "Feira\ de\ Santana\ \-\ BA",
"55943365", "Vila\ Taboca\ \-\ PA",
"55733633", "Ilhéus\ \-\ BA",
"55713521", "Salvador\ \-\ BA",
"55273724", "Marilândia\ \-\ ES",
"55112503", "São\ Paulo\ \-\ SP",
"55473442", "São\ Francisco\ do\ Sul\ \-\ SC",
"55483442", "Criciúma\ \-\ SC",
"55353441", "Ouro\ Fino\ \-\ MG",
"55833445", "Paulista\ \-\ PB",
"55543358", "Lagoa\ Vermelha\ \-\ RS",
"55743673", "Uauá\ \-\ BA",
"55493556", "Brunópolis\ \-\ SC",
"55333253", "Belo\ Oriente\ \-\ MG",
"55212668", "Nova\ Iguaçu\ \-\ RJ",
"55553435", "Maçambara\ \-\ RS",
"55283515", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55273776", "Barra\ de\ São\ Francisco\ \-\ ES",
"55853464", "Fortaleza\ \-\ CE",
"5516362", "Ribeirão\ Preto\ \-\ SP",
"55843642", "Natal\ \-\ RN",
"55823277", "Anadia\ \-\ AL",
"55213847", "Rio\ de\ Janeiro\ \-\ RJ",
"55123211", "Cruzeiro\ \-\ SP",
"55833348", "Alcantil\ \-\ PB",
"55493341", "Jupiá\ \-\ SC",
"55913116", "Belém\ \-\ PA",
"55433316", "Arapongas\ \-\ PR",
"5598322", "São\ Luís\ \-\ MA",
"55323421", "Cataguases\ \-\ MG",
"55973373", "Humaitá\ \-\ AM",
"55983373", "Maracaçumé\ \-\ MA",
"55143372", "Santa\ Cruz\ do\ Rio\ Pardo\ \-\ SP",
"55553338", "Nova\ Ramada\ \-\ RS",
"55623407", "São\ Miguel\ do\ Passa\ Quatro\ \-\ GO",
"55353273", "Jesuânia\ \-\ MG",
"55633352", "Crixás\ do\ Tocantins\ \-\ TO",
"55863243", "Porto\ \-\ PI",
"55333247", "Itabirinha\ \-\ MG",
"55643658", "São\ Simão\ \-\ GO",
"5531350", "Minas\ Gerais",
"55242522", "Nova\ Friburgo\ \-\ RJ",
"55733525", "Jequié\ \-\ BA",
"55623015", "Goiânia\ \-\ GO",
"55112599", "São\ Paulo\ \-\ SP",
"55993575", "Graça\ Aranha\ \-\ MA",
"55513470", "Rio\ Grande\ do\ Sul",
"55613489", "Planaltina\ \-\ DF",
"55173243", "Mirassol\ \-\ SP",
"55373215", "Divinópolis\ \-\ MG",
"55672106", "Campo\ Grande\ \-\ MS",
"55512106", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55682106", "Rio\ Branco\ \-\ AC",
"55153285", "Tietê\ \-\ SP",
"55123892", "São\ Sebastião\ \-\ SP",
"55313464", "Belo\ Horizonte\ \-\ MG",
"55443556", "Rancho\ Alegre\ D\'Oeste\ \-\ PR",
"55112347", "São\ Paulo\ \-\ SP",
"55663419", "Campo\ Verde\ \-\ MT",
"55513237", "Rio\ Grande\ do\ Sul",
"55683237", "Plácido\ de\ Castro\ \-\ AC",
"55213620", "Niterói\ \-\ RJ",
"55993521", "Caxias\ \-\ MA",
"55863239", "Santo\ Antônio\ dos\ Milagres\ \-\ PI",
"55114024", "Itu\ \-\ SP",
"55112119", "Atibaia\ \-\ SP",
"5583", "Paraiba",
"55313049", "Contagem\ \-\ MG",
"55663467", "Nova\ Nazaré\ \-\ MT",
"55643512", "Rio\ Quente\ \-\ GO",
"55653254", "Indiavaí\ \-\ MT",
"55623922", "Goiânia\ \-\ GO",
"5531335", "Minas\ Gerais",
"55193562", "Pirassununga\ \-\ SP",
"55743531", "Curaçá\ \-\ BA",
"55483268", "Leoberto\ Leal\ \-\ SC",
"55223843", "Varre\-Sai\ \-\ RJ",
"55813273", "Recife\ \-\ PE",
"55173257", "Baguaçu\ \-\ SP",
"5581332", "Recife\ \-\ PE",
"55624011", "Goiânia\ \-\ GO",
"55533263", "Santa\ Vitória\ do\ Palmar\ \-\ RS",
"55313269", "Belo\ Horizonte\ \-\ MG",
"55993667", "Governador\ Archer\ \-\ MA",
"55793364", "Telha\ \-\ SE",
"55633479", "Piraquê\ \-\ TO",
"55473048", "Itajaí\ \-\ SC",
"55542101", "Caxias\ do\ Sul\ \-\ RS",
"55793711", "Aracaju\ \-\ SE",
"55113427", "Mogi\ das\ Cruzes\ \-\ SP",
"55663532", "Sinop\ \-\ MT",
"55843267", "Ielmo\ Marinho\ \-\ RN",
"55823003", "Maceió\ \-\ AL",
"55112773", "São\ Paulo\ \-\ SP",
"55273735", "Afonso\ Cláudio\ \-\ ES",
"55833209", "João\ Pessoa\ \-\ PB",
"55114477", "Santo\ André\ \-\ SP",
"5531377", "Minas\ Gerais",
"55544003", "Caxias\ do\ Sul\ \-\ RS",
"5511361", "São\ Paulo\ \-\ SP",
"55114094", "Diadema\ \-\ SP",
"55793526", "Estância\ \-\ SE",
"55933524", "Santarém\ \-\ PA",
"55693443", "Cacoal\ \-\ RO",
"55543287", "Vila\ Cristina\ \-\ RS",
"55483646", "Laguna\ \-\ SC",
"55453242", "Corbélia\ \-\ PR",
"55373241", "Itaúna\ \-\ MG",
"55833283", "Sapé\ \-\ PB",
"55212712", "São\ Gonçalo\ \-\ RJ",
"55433305", "Londrina\ \-\ PR",
"55273222", "Vitória\ \-\ ES",
"55114230", "Itupeva\ \-\ SP",
"55114084", "São\ Paulo\ \-\ SP",
"55643443", "Catalão\ \-\ GO",
"55993536", "Governador\ Edison\ Lobão\ \-\ MA",
"55983218", "São\ Luís\ \-\ MA",
"55673454", "Maracaju\ \-\ MS",
"55513454", "Esteio\ \-\ RS",
"55153271", "Itapetininga\ \-\ SP",
"55983664", "Buriticupu\ \-\ MA",
"55833293", "Lucena\ \-\ PB",
"5551357", "Rio\ Grande\ do\ Sul",
"55543297", "Flores\ da\ Cunha\ \-\ RS",
"55273171", "Linhares\ \-\ ES",
"55733534", "Jaguaquara\ \-\ BA",
"55313838", "Santa\ Maria\ de\ Itabira\ \-\ MG",
"55713667", "Mata\ de\ São\ João\ \-\ BA",
"55623608", "Goiânia\ \-\ GO",
"55893446", "Itainópolis\ \-\ PI",
"55173485", "Valentim\ Gentil\ \-\ SP",
"55623312", "Itapuranga\ \-\ GO",
"55683548", "Assis\ Brasil\ \-\ AC",
"55513548", "Riozinho\ \-\ RS",
"55913711", "Castanhal\ \-\ PA",
"55733212", "Itabuna\ \-\ BA",
"55113152", "São\ Paulo\ \-\ SP",
"55273125", "Guarapari\ \-\ ES",
"55114035", "Bragança\ Paulista\ \-\ SP",
"55433555", "Japira\ \-\ PR",
"55433344", "Londrina\ \-\ PR",
"55373522", "Bom\ Despacho\ \-\ MG",
"55183918", "Presidente\ Prudente\ \-\ SP",
"55553289", "Vale\ Vêneto\ \-\ RS",
"55133251", "Santos\ \-\ SP",
"55883552", "Mauriti\ \-\ CE",
"55433033", "Apucarana\ \-\ PR",
"55114177", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55223211", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55353534", "Itamogi\ \-\ MG",
"55533325", "Pelotas\ \-\ RS",
"55553351", "Pirapó\ \-\ RS",
"55643686", "Moiporá\ \-\ GO",
"55112532", "São\ Paulo\ \-\ SP",
"55663529", "Querência\ \-\ MT",
"55653313", "Cuiabá\ \-\ MT",
"55633397", "Pugmil\ \-\ TO",
"55883527", "Pereiro\ \-\ CE",
"55423239", "Ponta\ Grossa\ \-\ PR",
"55643631", "Jataí\ \-\ GO",
"55843366", "Janduís\ \-\ RN",
"55813746", "Jataúba\ \-\ PE",
"5545", "Paraná",
"55343856", "Arapuá\ \-\ MG",
"55243372", "Paraty\ \-\ RJ",
"55543386", "Muliterno\ \-\ RS",
"55473702", "Blumenau\ \-\ SC",
"55353701", "Alfenas\ \-\ MG",
"55713460", "Salvador\ \-\ BA",
"55473065", "Balneário\ Camboriú\ \-\ SC",
"55553613", "Mato\ Queimado\ \-\ RS",
"55273239", "Vila\ Velha\ \-\ ES",
"55483065", "Florianópolis\ \-\ SC",
"55513945", "Gravataí\ \-\ RS",
"55713283", "Salvador\ \-\ BA",
"55843693", "Touros\ \-\ RN",
"55543331", "Carazinho\ \-\ RS",
"55173811", "Nova\ Aliança\ \-\ SP",
"55873877", "Floresta\ \-\ PE",
"55643088", "Itumbiara\ \-\ GO",
"55553546", "Alecrim\ \-\ RS",
"55983312", "São\ Luís\ \-\ MA",
"55313765", "Minas\ Gerais",
"55833536", "Santa\ Cruz\ \-\ PB",
"55383616", "Matias\ Cardoso\ \-\ MG",
"55143313", "Bauru\ \-\ SP",
"55473211", "Brusque\ \-\ SC",
"55863292", "Amarante\ \-\ PI",
"55483211", "Florianópolis\ \-\ SC",
"55353212", "Varginha\ \-\ MG",
"55373543", "Quartel\ Geral\ \-\ MG",
"55183282", "Teodoro\ Sampaio\ \-\ SP",
"55714007", "Salvador\ \-\ BA",
"55173282", "Icém\ \-\ SP",
"55383543", "Gouveia\ \-\ MG",
"55112668", "Mogi\ das\ Cruzes\ \-\ SP",
"55963426", "Lourenço\ \-\ AP",
"55323511", "Muriaé\ \-\ MG",
"55163877", "Ribeirão\ Preto\ \-\ SP",
"55513565", "Nova\ Hartz\ \-\ RS",
"55423243", "Ponta\ Grossa\ \-\ PR",
"55673565", "Aparecida\ do\ Taboado\ \-\ MS",
"55753662", "Laje\ \-\ BA",
"55813534", "Escada\ \-\ PE",
"55553785", "Inhacorá\ \-\ RS",
"55543396", "Santo\ Expedito\ do\ Sul\ \-\ RS",
"55443588", "Vidigal\ \-\ PR",
"55173292", "Paulo\ de\ Faria\ \-\ SP",
"55193909", "Hortolândia\ \-\ SP",
"55893576", "Cristalândia\ do\ Piauí\ \-\ PI",
"55913017", "Ananindeua\ \-\ PA",
"55814062", "Recife\ \-\ PE",
"55273257", "Ibiraçu\ \-\ ES",
"55153573", "Barão\ de\ Antonina\ \-\ SP",
"55123843", "Ubatuba\ \-\ SP",
"55863282", "Água\ Branca\ \-\ PI",
"5515301", "Sorocaba\ \-\ SP",
"55773447", "Cordeiros\ \-\ BA",
"55673478", "Tacuru\ \-\ MS",
"55513478", "Rio\ Grande\ do\ Sul",
"55613621", "Luziânia\ \-\ GO",
"55323726", "Patrocínio\ do\ Muriaé\ \-\ MG",
"55343262", "Ituiutaba\ \-\ MG",
"55954009", "Boa\ Vista\ \-\ RR",
"55913444", "Mãe\ do\ Rio\ \-\ PA",
"55153363", "Boituva\ \-\ SP",
"55343304", "Uberlândia\ \-\ MG",
"55193651", "Espírito\ Santo\ do\ Pinhal\ \-\ SP",
"55773453", "Brumado\ \-\ BA",
"55643573", "Itumbiara\ \-\ GO",
"55693422", "Ji\-Paraná\ \-\ RO",
"55162132", "Ribeirão\ Preto\ \-\ SP",
"55433464", "Mauá\ da\ Serra\ \-\ PR",
"55633387", "Jaú\ do\ Tocantins\ \-\ TO",
"55333314", "Ipanema\ \-\ MG",
"55643696", "Campo\ Alegre\ de\ Goiás\ \-\ GO",
"55613432", "Formosa\ \-\ GO",
"55513375", "Rio\ Grande\ do\ Sul",
"55813212", "Recife\ \-\ PE",
"5599", "Maranhão",
"55963622", "Vitória\ do\ Jari\ \-\ AP",
"55833365", "Alagoa\ Nova\ \-\ PB",
"55613567", "Guará\ \-\ DF",
"55554052", "Santa\ Maria\ \-\ RS",
"55353361", "Itanhandu\ \-\ MG",
"55353821", "Lavras\ \-\ MG",
"55473362", "Presidente\ Nereu\ \-\ SC",
"55543326", "Campos\ Borges\ \-\ RS",
"55444009", "Maringá\ \-\ PR",
"55453411", "Cascavel\ \-\ PR",
"55543905", "Gramado\ \-\ RS",
"557133", "Salvador\ \-\ BA",
"55633685", "Combinado\ \-\ TO",
"55343820", "Patos\ de\ Minas\ \-\ MG",
"55513677", "Dom\ Feliciano\ \-\ RS",
"55773648", "Novo\ Horizonte\ \-\ BA",
"55353714", "Poços\ de\ Caldas\ \-\ MG",
"55663503", "Brianorte\ \-\ MT",
"55823032", "Maceió\ \-\ AL",
"55163349", "Trabiju\ \-\ SP",
"55353525", "Delfinópolis\ \-\ MG",
"55983015", "São\ Luís\ \-\ MA",
"55853344", "Paracuru\ \-\ CE",
"55473204", "São\ Francisco\ do\ Sul\ \-\ SC",
"55183222", "Presidente\ Prudente\ \-\ SP",
"55813633", "Nazaré\ da\ Mata\ \-\ PE",
"55313305", "Belo\ Horizonte\ \-\ MG",
"55833521", "Sousa\ \-\ PB",
"55112712", "São\ Paulo\ \-\ SP",
"55163661", "Batatais\ \-\ SP",
"55543374", "Ibiaçá\ \-\ RS",
"55123646", "Roseira\ \-\ SP",
"55813106", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55513755", "Muçum\ \-\ RS",
"55643674", "Iporá\ \-\ GO",
"55323354", "Resende\ Costa\ \-\ MG",
"55943348", "Curionópolis\ \-\ PA",
"55843535", "Jardim\ de\ Angicos\ \-\ RN",
"55193797", "Campinas\ \-\ SP",
"55313408", "Belo\ Horizonte\ \-\ MG",
"55413662", "Cerro\ Azul\ \-\ PR",
"55212645", "Itaboraí\ \-\ RJ",
"55643626", "Santo\ Antônio\ da\ Barra\ \-\ GO",
"55353571", "Muzambinho\ \-\ MG",
"55883587", "Juazeiro\ do\ Norte\ \-\ CE",
"55643492", "Edéia\ \-\ GO",
"55813361", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55613636", "Cabeceiras\ \-\ GO",
"55454007", "Cascavel\ \-\ PR",
"55383813", "Mato\ Verde\ \-\ MG",
"55222655", "Saquarema\ \-\ RJ",
"55173845", "Meridiano\ \-\ SP",
"55813821", "Recife\ \-\ PE",
"55423434", "Guamirim\ \-\ PR",
"55323272", "Simão\ Pereira\ \-\ MG",
"55163979", "Ribeirão\ Preto\ \-\ SP",
"55313851", "João\ Monlevade\ \-\ MG",
"55813649", "Machados\ \-\ PE",
"55143278", "Lençóis\ Paulista\ \-\ SP",
"55952121", "Boa\ Vista\ \-\ RR",
"55313164", "Santa\ Luzia\ \-\ MG",
"55553232", "São\ Gabriel\ \-\ RS",
"55473423", "Joinville\ \-\ SC",
"55853305", "Fortaleza\ \-\ CE",
"55313555", "Minas\ Gerais",
"55114654", "Arujá\ \-\ SP",
"55553816", "Condor\ \-\ RS",
"55483245", "Santo\ Amaro\ da\ Imperatriz\ \-\ SC",
"55193807", "Amparo\ \-\ SP",
"55663599", "Guariba\ \-\ MT",
"55453283", "Margarida\ \-\ PR",
"55113379", "Jundiaí\ \-\ SP",
"55813525", "São\ Lourenço\ da\ Mata\ \-\ PE",
"55123601", "Taubaté\ \-\ SP",
"55513170", "Estância\ Velha\ \-\ RS",
"55213688", "Rio\ de\ Janeiro\ \-\ RJ",
"55893535", "Manoel\ Emídio\ \-\ PI",
"55114817", "Jundiaí\ \-\ SP",
"5571", "Bahia",
"55153492", "Salto\ de\ Pirapora\ \-\ SP",
"55633695", "Novo\ Alegre\ \-\ TO",
"55443528", "Assis\ Chateaubriand\ \-\ PR",
"55222777", "Rio\ das\ Ostras\ \-\ RJ",
"55354104", "Lavras\ \-\ MG",
"55623373", "Jussara\ \-\ GO",
"55183356", "Echaporã\ \-\ SP",
"55273388", "Vila\ Velha\ \-\ ES",
"55753247", "Irará\ \-\ BA",
"55733273", "Pau\ Brasil\ \-\ BA",
"55313830", "Minas\ Gerais",
"5594", "Pará",
"55883661", "Acaraú\ \-\ CE",
"55513540", "Rio\ Grande\ do\ Sul",
"55513381", "Rio\ Grande\ do\ Sul",
"55112419", "Bragança\ Paulista\ \-\ SP",
"55192112", "Rio\ Claro\ \-\ SP",
"55483296", "Biguaçu\ \-\ SC",
"55112658", "Poá\ \-\ SP",
"55373691", "Divinópolis\ \-\ MG",
"55313755", "Senhora\ de\ Oliveira\ \-\ MG",
"55613605", "Cidade\ Ocidental\ \-\ GO",
"55212631", "Magé\ \-\ RJ",
"5511422", "São\ Caetano\ do\ Sul\ \-\ SP",
"55273401", "Baixo\ Guandu\ \-\ ES",
"55183741", "Castilho\ \-\ SP",
"55114373", "São\ Paulo\ \-\ SP",
"55653349", "Campo\ Novo\ do\ Parecis\ \-\ MT",
"55853381", "Maracanaú\ \-\ CE",
"55193979", "Monte\ Mor\ \-\ SP",
"55323531", "Ubá\ \-\ MG",
"55513408", "Rio\ Grande\ do\ Sul",
"55143597", "Presidente\ Alves\ \-\ SP",
"55853336", "Horizonte\ \-\ CE",
"55713450", "Salvador\ \-\ BA",
"55473055", "Jaraguá\ do\ Sul\ \-\ SC",
"551132", "São\ Paulo\ \-\ SP",
"55333022", "Governador\ Valadares\ \-\ MG",
"55483055", "Içara\ \-\ SC",
"55813771", "Bom\ Conselho\ \-\ PE",
"55843356", "Doutor\ Severiano\ \-\ RN",
"55333334", "Manhuaçu\ \-\ MG",
"55553649", "Sanchuri\ \-\ RS",
"55513740", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55543360", "Nova\ Boa\ Vista\ \-\ RS",
"55183623", "Araçatuba\ \-\ SP",
"55553361", "Giruá\ \-\ RS",
"55383567", "Varjão\ de\ Minas\ \-\ MG",
"55823520", "Girau\ do\ Ponciano\ \-\ AL",
"55123634", "Taubaté\ \-\ SP",
"55713431", "Salvador\ \-\ BA",
"55413456", "Matinhos\ \-\ PR",
"55713622", "Camaçari\ \-\ BA",
"55813194", "Recife\ \-\ PE",
"55313391", "Contagem\ \-\ MG",
"55833639", "Riachão\ \-\ PB",
"55673926", "Ponta\ Porã\ \-\ MS",
"55543042", "Farroupilha\ \-\ RS",
"55212088", "São\ Gonçalo\ \-\ RJ",
"55943431", "Santana\ do\ Araguaia\ \-\ PA",
"55553525", "Humaitá\ \-\ RS",
"55123867", "Maresias\ \-\ SP",
"55643611", "Rio\ Verde\ \-\ GO",
"55423219", "Ponta\ Grossa\ \-\ PR",
"55222640", "Cabo\ Frio\ \-\ RJ",
"55333751", "Pedra\ Azul\ \-\ MG",
"55193661", "Espírito\ Santo\ do\ Pinhal\ \-\ SP",
"55743632", "Mairi\ \-\ BA",
"55423446", "Prudentópolis\ \-\ PR",
"55773463", "Licínio\ de\ Almeida\ \-\ BA",
"55333627", "Machacalis\ \-\ MG",
"55433454", "Cruzmaltina\ \-\ PR",
"5596", "Amapá",
"55993622", "Bacabal\ \-\ MA",
"55313540", "Minas\ Gerais",
"55313381", "Belo\ Horizonte\ \-\ MG",
"55153353", "Votorantim\ \-\ SP",
"55243302", "Petrópolis\ \-\ RJ",
"55753420", "Entre\ Rios\ \-\ BA",
"55343252", "Ipiaçu\ \-\ MG",
"55733672", "Santa\ Cruz\ Cabrália\ \-\ BA",
"55843222", "Natal\ \-\ RN",
"55313336", "Minas\ Gerais",
"55473231", "Blumenau\ \-\ SC",
"55163797", "Ribeirão\ Preto\ \-\ SP",
"55483231", "Florianópolis\ \-\ SC",
"55873787", "Paranatama\ \-\ PE",
"55483286", "Palhoça\ \-\ SC",
"55193597", "Rio\ Claro\ \-\ SP",
"55313911", "Contagem\ \-\ MG",
"55273267", "Fundão\ \-\ ES",
"55893541", "Marcos\ Parente\ \-\ PI",
"55433548", "Sapopema\ \-\ PR",
"55753652", "Cairu\ \-\ BA",
"55323745", "Caiana\ \-\ MG",
"55173831", "Nova\ Castilho\ \-\ SP",
"55183706", "Suzanápolis\ \-\ SP",
"55143587", "Presidente\ Alves\ \-\ SP",
"55983678", "Pindare\ Mirim\ \-\ MA",
"55513555", "Rio\ Grande\ do\ Sul",
"55823341", "Maceió\ \-\ AL",
"55115042", "São\ Paulo\ \-\ SP",
"55623389", "Goianésia\ \-\ GO",
"55323202", "Cataguases\ \-\ MG",
"55733289", "Itagimirim\ \-\ BA",
"55114837", "São\ Paulo\ \-\ SP",
"55493277", "Bom\ Retiro\ \-\ SC",
"55893515", "Floriano\ \-\ PI",
"55793436", "Itabaiana\ \-\ SE",
"55413652", "Rio\ Branco\ do\ Sul\ \-\ PR",
"55633442", "Ananás\ \-\ TO",
"55323364", "Paiva\ \-\ MG",
"55433259", "Jataizinho\ \-\ PR",
"55813734", "Vertentes\ \-\ PE",
"55913758", "Cachoeira\ do\ Arari\ \-\ PA",
"55193877", "Artur\ Nogueira\ \-\ SP",
"55853375", "Pindoretama\ \-\ CE",
"55543345", "Sertão\ \-\ RS",
"55963283", "Santana\ \-\ AP",
"55273047", "Linhares\ \-\ ES",
"55613616", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55513931", "Porto\ Alegre\ \-\ RS",
"55833458", "Manaíra\ \-\ PB",
"55323711", "Vermelho\ \-\ MG",
"55713682", "Bom\ Despacho\ \-\ BA",
"55493451", "Paial\ \-\ SC",
"55843292", "Tangará\ \-\ RN",
"55383833", "Jaíba\ \-\ MG",
"55123671", "São\ Luís\ do\ Paraitinga\ \-\ SP",
"55943426", "Xinguara\ \-\ PA",
"55453027", "Foz\ do\ Iguaçu\ \-\ PR",
"55333428", "Santo\ Antônio\ do\ Itambé\ \-\ MG",
"55423414", "Rio\ da\ Areia\ \-\ PR",
"55513765", "Lagoão\ \-\ RS",
"55553534", "Doutor\ Maurício\ Cardoso\ \-\ RS",
"55183609", "Araçatuba\ \-\ SP",
"55733203", "Ibicaraí\ \-\ BA",
"55353844", "Ibituruna\ \-\ MG",
"55643645", "Acreúna\ \-\ GO",
"55983477", "São\ Bernardo\ \-\ MA",
"55323574", "Tocantins\ \-\ MG",
"55163983", "Luís\ Antônio\ \-\ SP",
"55623303", "Montes\ Claros\ de\ Goiás\ \-\ GO",
"55173101", "Uchoa\ \-\ SP",
"55843320", "Baraúna\ \-\ RN",
"55333082", "Governador\ Valadares\ \-\ MG",
"55863366", "Luís\ Correia\ \-\ PI",
"55833544", "Marizópolis\ \-\ PB",
"55833355", "São\ João\ do\ Cariri\ \-\ PB",
"55853321", "Guaramiranga\ \-\ CE",
"55333325", "Imbé\ de\ Minas\ \-\ MG",
"55453279", "Quatro\ Pontes\ \-\ PR",
"55813501", "Ipojuca\ \-\ PE",
"55554062", "Santa\ Maria\ \-\ RS",
"55113383", "São\ Paulo\ \-\ SP",
"55473352", "Presidente\ Getúlio\ \-\ SC",
"55823556", "Feliz\ Deserto\ \-\ AL",
"55163993", "Ribeirão\ Preto\ \-\ SP",
"55173874", "Macaubal\ \-\ SP",
"55873983", "Petrolina\ \-\ PE",
"55383757", "Joaquim\ Felício\ \-\ MG",
"55513607", "Rio\ Grande\ do\ Sul",
"55383621", "Januária\ \-\ MG",
"55753456", "Cardeal\ da\ Silva\ \-\ BA",
"55813613", "Limoeiro\ \-\ PE",
"5513328", "Santos\ \-\ SP",
"55343663", "Perdizes\ \-\ MG",
"55483274", "Angelina\ \-\ SC",
"55793213", "Aracaju\ \-\ SE",
"55313375", "Belo\ Horizonte\ \-\ MG",
"55473274", "Jaraguá\ do\ Sul\ \-\ SC",
"55183366", "Quatá\ \-\ SP",
"55173826", "Uchoa\ \-\ SP",
"55113393", "São\ Paulo\ \-\ SP",
"55113559", "São\ Paulo\ \-\ SP",
"55212789", "Mangaratiba\ \-\ RJ",
"55663573", "Paranatinga\ \-\ MT",
"55353734", "Santa\ Rita\ de\ Caldas\ \-\ MG",
"55242103", "Petrópolis\ \-\ RJ",
"55383675", "Bonfinópolis\ de\ Minas\ \-\ MG",
"55183693", "Piacatu\ \-\ SP",
"55173693", "São\ Francisco\ \-\ SP",
"55383743", "Pirapora\ \-\ MG",
"55213162", "Nilópolis\ \-\ RJ",
"55114664", "Embu\-Guaçu\ \-\ SP",
"55623553", "Hidrolândia\ \-\ GO",
"55173576", "Ariranha\ \-\ SP",
"55733299", "Lajedão\ \-\ BA",
"55913481", "Primavera\ \-\ PA",
"55643604", "Mairipotaba\ \-\ GO",
"55933063", "Santarém\ \-\ PA",
"55843282", "Santo\ Antônio\ \-\ RN",
"55443277", "Corumbataí\ do\ Sul\ \-\ PR",
"55553746", "Seberi\ \-\ RS",
"55423642", "Turvo\ \-\ PR",
"55553595", "Tuparendi\ \-\ RS",
"55813351", "Recife\ \-\ PE",
"55212703", "Niterói\ \-\ RJ",
"55173524", "Catanduva\ \-\ SP",
"55613307", "Brasília\ \-\ DF",
"55753263", "Valente\ \-\ BA",
"55222665", "Araruama\ \-\ RJ",
"55313861", "Nova\ Era\ \-\ MG",
"55324101", "Barbacena\ \-\ MG",
"55313321", "Minas\ Gerais",
"55613963", "Brasília\ \-\ DF",
"55883630", "Miraíma\ \-\ CE",
"55633530", "Rio\ dos\ Bois\ \-\ TO",
"55383755", "Morada\ Nova\ de\ Minas\ \-\ MG",
"55513605", "Torres\ \-\ RS",
"55373755", "Morada\ Nova\ de\ Minas\ \-\ MG",
"55143361", "Botucatu\ \-\ SP",
"55473263", "Balneário\ Camboriú\ \-\ SC",
"55343799", "Araguari\ \-\ MG",
"55163135", "Rifaina\ \-\ SP",
"55483263", "Tijucas\ \-\ SC",
"55623354", "Niquelândia\ \-\ GO",
"55623545", "Goiânia\ \-\ GO",
"55343674", "Matutina\ \-\ MG",
"55663564", "Confresa\ \-\ MT",
"55693311", "Cacoal\ \-\ RO",
"55733254", "Gandu\ \-\ BA",
"55143649", "Barra\ Bonita\ \-\ SC",
"55143714", "Cerqueira\ César\ \-\ SP",
"55472111", "Blumenau\ \-\ SC",
"55114894", "Itatiba\ \-\ SP",
"55643570", "Claudinápolis\ \-\ GO",
"55843379", "Francisco\ Dantas\ \-\ RN",
"55773450", "Barra\ da\ Estiva\ \-\ BA",
"55613408", "Brasília\ \-\ DF",
"55183323", "Assis\ \-\ SP",
"55313377", "Belo\ Horizonte\ \-\ MG",
"55943322", "Marabá\ \-\ PA",
"55115645", "São\ Paulo\ \-\ SP",
"55883514", "Cariús\ \-\ CE",
"55162108", "Araraquara\ \-\ SP",
"55753274", "Cansanção\ \-\ BA",
"55773431", "Poções\ \-\ BA",
"55493542", "Erval\ Velho\ \-\ SC",
"55653361", "Barra\ do\ Bugres\ \-\ MT",
"55514109", "Gravataí\ \-\ RS",
"55173248", "Mendonça\ \-\ SP",
"55673412", "Douradina\ \-\ MS",
"55923215", "Manaus\ \-\ AM",
"55923582", "Manaus\ \-\ AM",
"55873771", "Bom\ Conselho\ \-\ PE",
"55383677", "Unaí\ \-\ MG",
"55433235", "Primeiro\ de\ Maio\ \-\ PR",
"55123022", "Taubaté\ \-\ SP",
"55113594", "São\ Paulo\ \-\ SP",
"5592365", "Manaus\ \-\ AM",
"55222667", "Araruama\ \-\ RJ",
"55313519", "Belo\ Horizonte\ \-\ MG",
"55873816", "Buíque\ \-\ PE",
"55443275", "Barbosa\ Ferraz\ \-\ PR",
"55114596", "Várzea\ Paulista\ \-\ SP",
"55773622", "Angical\ \-\ BA",
"55473456", "Barra\ Velha\ \-\ SC",
"55553333", "Ijuí\ \-\ RS",
"55513719", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55983378", "Pedro\ do\ Rosário\ \-\ MA",
"55773496", "Santa\ Maria\ da\ Vitória\ \-\ BA",
"55493275", "Otacílio\ Costa\ \-\ SC",
"55323373", "São\ João\ Del\ Rei\ \-\ MG",
"55643653", "Gouvelândia\ \-\ GO",
"55654104", "Várzea\ Grande\ \-\ MT",
"55543611", "André\ da\ Rocha\ \-\ RS",
"55193571", "Leme\ \-\ SP",
"55133596", "Praia\ Grande\ \-\ SP",
"55863248", "Buriti\ dos\ Montes\ \-\ PI",
"55173462", "Fernandópolis\ \-\ SP",
"55513767", "Tunas\ \-\ RS",
"55453025", "Foz\ do\ Iguaçu\ \-\ PR",
"55433051", "Rolândia\ \-\ PR",
"55543347", "Casca\ \-\ RS",
"55443542", "Campina\ da\ Lagoa\ \-\ PR",
"55893569", "Santa\ Filomena\ \-\ PI",
"55853377", "Itaitinga\ \-\ CE",
"55373381", "Cláudio\ \-\ MG",
"55953236", "Caroebe\ \-\ RR",
"55193875", "Indaiatuba\ \-\ SP",
"55833343", "Campina\ Grande\ \-\ PB",
"55114531", "Jundiaí\ \-\ SP",
"55113584", "São\ Paulo\ \-\ SP",
"55153311", "Sorocaba\ \-\ SP",
"55213267", "Rio\ de\ Janeiro\ \-\ RJ",
"55143106", "Bauru\ \-\ SP",
"55833228", "Cabedelo\ \-\ PB",
"55983475", "Mata\ Roma\ \-\ MA",
"55643647", "Maurilândia\ \-\ GO",
"55433132", "Cornélio\ Procópio\ \-\ PR",
"55163725", "Franca\ \-\ SP",
"55153653", "Capão\ Bonito\ \-\ SP",
"55313681", "Lagoa\ Santa\ \-\ MG",
"55144104", "Garça\ \-\ SP",
"55542628", "Farroupilha\ \-\ RS",
"55433429", "Califórnia\ \-\ PR",
"55213219", "Rio\ de\ Janeiro\ \-\ RJ",
"55863323", "Parnaíba\ \-\ PI",
"55333327", "Ipaba\ \-\ MG",
"55114704", "Embu\ das\ Artes\ \-\ SP",
"55833357", "São\ Domingos\ do\ Cariri\ \-\ PB",
"55163514", "Ribeirão\ Preto\ \-\ SP",
"55193361", "Mogi\-Guaçu\ \-\ SP",
"55633301", "Gurupi\ \-\ TO",
"55193821", "Elias\ Fausto\ \-\ SP",
"55543353", "Caseiros\ \-\ RS",
"55193649", "Águas\ da\ Prata\ \-\ SP",
"55483652", "Grão\ Pará\ \-\ SC",
"55333625", "Serra\ dos\ Aimorés\ \-\ MG",
"55353651", "Paraisópolis\ \-\ MG",
"55213938", "Rio\ de\ Janeiro\ \-\ RJ",
"55473652", "Itaiópolis\ \-\ SC",
"5513345", "Peruíbe\ \-\ SP",
"55163176", "Furnas\ Vila\ Residencial\ \-\ SP",
"55183913", "Montalvão\ \-\ SP",
"55733270", "Itabela\ \-\ BA",
"55973491", "Carauari\ \-\ AM",
"55623370", "Montes\ Claros\ de\ Goiás\ \-\ GO",
"55663386", "São\ José\ do\ Rio\ Claro\ \-\ MT",
"55343088", "Uberlândia\ \-\ MG",
"55453256", "Mercedes\ \-\ PR",
"55773474", "Feira\ da\ Mata\ \-\ BA",
"55323753", "Miradouro\ \-\ MG",
"55313833", "São\ Gonçalo\ do\ Rio\ Abaixo\ \-\ MG",
"55513616", "Rio\ Grande\ do\ Sul",
"55773682", "Iuiú\ \-\ BA",
"5584320", "Natal\ \-\ RN",
"55653212", "Lucas\ do\ Rio\ Verde\ \-\ MT",
"55463244", "Sulina\ \-\ PR",
"55753286", "Coronel\ João\ Sá\ \-\ BA",
"55513543", "Parobé\ \-\ RS",
"55163351", "São\ Carlos\ \-\ SP",
"55483039", "Florianópolis\ \-\ SC",
"55833298", "Conde\ \-\ PB",
"55433276", "Arapongas\ \-\ PR",
"55273265", "Rio\ Bananal\ \-\ ES",
"55472104", "Itajaí\ \-\ SC",
"55473039", "Blumenau\ \-\ SC",
"55873966", "Exu\ \-\ PE",
"55873785", "Lagoa\ do\ Ouro\ \-\ PE",
"55193746", "Campinas\ \-\ SP",
"55513018", "Porto\ Alegre\ \-\ RS",
"55713025", "Salvador\ \-\ BA",
"55143881", "Botucatu\ \-\ SP",
"55673557", "Três\ Lagoas\ \-\ MS",
"55193891", "Mogi\-Guaçu\ \-\ SP",
"55433224", "Santo\ Antônio\ do\ Paraíso\ \-\ PR",
"55883501", "Juazeiro\ do\ Norte\ \-\ CE",
"55654062", "Cuiabá\ \-\ MT",
"55133202", "Santos\ \-\ SP",
"55453280", "São\ Luiz\ D\'Oeste\ \-\ PR",
"55513557", "Rio\ Grande\ do\ Sul",
"55313739", "Minas\ Gerais",
"55943382", "Sapucaia\ \-\ PA",
"55863393", "Luzilândia\ \-\ PI",
"55443236", "Floresta\ \-\ PR",
"55153554", "Barra\ do\ Chapéu\ \-\ SP",
"55143212", "Bauru\ \-\ SP",
"55843737", "Parnamirim\ \-\ RN",
"55343631", "Ibiá\ \-\ MG",
"55143585", "Pirajuí\ \-\ SP",
"55953542", "Mucajaí\ \-\ RR",
"55123156", "Piquete\ \-\ SP",
"55823641", "Delmiro\ Gouveia\ \-\ AL",
"55323747", "Alto\ Caparaó\ \-\ MG",
"55983213", "São\ Luís\ \-\ MA",
"55313621", "Vespasiano\ \-\ MG",
"55513539", "Novo\ Hamburgo\ \-\ RS",
"55883613", "Sobral\ \-\ CE",
"55333533", "Novo\ Cruzeiro\ \-\ MG",
"55813651", "Passira\ \-\ PE",
"55693448", "Ministro\ Andreazza\ \-\ RO",
"55313757", "Itaverava\ \-\ MG",
"55613607", "Distrito\ de\ Campos\ Lindos\ \-\ GO",
"55493236", "Urupema\ \-\ SC",
"55213642", "Teresópolis\ \-\ RJ",
"55873795", "Jurema\ \-\ PE",
"55114202", "Carapicuíba\ \-\ SP",
"55883546", "Nova\ Olinda\ \-\ CE",
"55313849", "Timóteo\ \-\ MG",
"55114144", "Itapevi\ \-\ SP",
"55193585", "Porto\ Ferreira\ \-\ SP",
"55833288", "Mulungu\ \-\ PB",
"55893452", "Wall\ Ferraz\ \-\ PI",
"55193701", "Limeira\ \-\ SP",
"55193836", "Vinhedo\ \-\ SP",
"55123687", "Quiririm\ \-\ SP",
"55793251", "Aracaju\ \-\ SE",
"55863383", "Esperantina\ \-\ PI",
"55163501", "São\ Carlos\ \-\ SP",
"55943392", "Canaã\ dos\ Carajás\ \-\ PA",
"55963014", "Macapá\ \-\ AP",
"55313432", "Belo\ Horizonte\ \-\ MG",
"5511274", "São\ Paulo\ \-\ SP",
"55193881", "Valinhos\ \-\ SP",
"55983481", "Anapurus\ \-\ MA",
"55873844", "São\ José\ do\ Egito\ \-\ PE",
"55153262", "Porto\ Feliz\ \-\ SP",
"55973481", "Eirunepé\ \-\ AM",
"55623511", "Inhumas\ \-\ GO",
"55693345", "Cabixi\ \-\ RO",
"55113576", "São\ Paulo\ \-\ SP",
"55644012", "Itumbiara\ \-\ GO",
"55343823", "Patos\ de\ Minas\ \-\ MG",
"55132138", "Santos\ \-\ SP",
"55733021", "Prado\ \-\ BA",
"55383321", "Montes\ Claros\ \-\ MG",
"55453322", "Cascavel\ \-\ PR",
"55373321", "Formiga\ \-\ MG",
"55663500", "Primavera\ do\ Leste\ \-\ MT",
"55115611", "São\ Paulo\ \-\ SP",
"55753296", "Sítio\ do\ Quinto\ \-\ BA",
"55483043", "Tubarão\ \-\ SC",
"55112828", "Santo\ André\ \-\ SP",
"55143546", "Sabino\ \-\ SP",
"55114511", "Mauá\ \-\ SP",
"55483466", "Orleans\ \-\ SC",
"55193501", "Hortolândia\ \-\ SP",
"55873891", "Moreilândia\ \-\ PE",
"55993014", "Imperatriz\ \-\ MA",
"55173847", "Floreal\ \-\ SP",
"55893537", "Eliseu\ Martins\ \-\ PI",
"55114815", "Jundiaí\ \-\ SP",
"55843393", "João\ Dias\ \-\ RN",
"55333733", "Itinga\ \-\ MG",
"55553313", "Santo\ Ângelo\ \-\ RS",
"55513739", "Rio\ Grande\ do\ Sul",
"55623526", "Goiânia\ \-\ GO",
"55483247", "São\ José\ \-\ SC",
"55193805", "Mogi\ Mirim\ \-\ SP",
"55313557", "Mariana\ \-\ MG",
"55193966", "Conchal\ \-\ SP",
"55653351", "Nossa\ Senhora\ do\ Livramento\ \-\ MT",
"55813877", "Carnaubeira\ da\ Penha\ \-\ PE",
"55753245", "Santo\ Estêvão\ \-\ BA",
"55222643", "Cabo\ Frio\ \-\ RJ",
"551121", "São\ Paulo\ \-\ SP",
"55653613", "Cuiabá\ \-\ MT",
"55143844", "Pratânia\ \-\ SP",
"55773460", "Igaporã\ \-\ BA",
"55313543", "Raposos\ \-\ MG",
"55633371", "Paranã\ \-\ TO",
"55623364", "São\ Miguel\ do\ Araguaia\ \-\ GO",
"55483253", "Paulo\ Lopes\ \-\ SC",
"55113515", "São\ Paulo\ \-\ SP",
"55663554", "Vila\ Rica\ \-\ MT",
"55114774", "Itapevi\ \-\ SP",
"55114699", "Mogi\ das\ Cruzes\ \-\ SP",
"55923030", "Manaus\ \-\ AM",
"55883115", "Juazeiro\ do\ Norte\ \-\ CE",
"55443244", "Paiçandu\ \-\ PR",
"55753423", "Alagoinhas\ \-\ BA",
"55633428", "Araguanã\ \-\ TO",
"55143351", "Piraju\ \-\ SP",
"55673675", "Tacuru\ \-\ MS",
"55543363", "Constantina\ \-\ RS",
"55513675", "Cerro\ Grande\ do\ Sul\ \-\ RS",
"55193124", "Piracicaba\ \-\ SP",
"55114136", "Araçariguama\ \-\ SP",
"55513743", "Candelária\ \-\ RS",
"55323553", "Guiricema\ \-\ MG",
"55493244", "Santa\ Cecília\ \-\ SC",
"55193351", "Araras\ \-\ SP",
"55194126", "Itapira\ \-\ SP",
"55833367", "Bananeiras\ \-\ PB",
"55823523", "Limoeiro\ de\ Anadia\ \-\ AL",
"55613478", "Sobradinho\ \-\ DF",
"55193844", "Paulínia\ \-\ SP",
"55333268", "Aimorés\ \-\ MG",
"55212653", "Duque\ de\ Caxias\ \-\ RJ",
"55353527", "Bom\ Jesus\ dos\ Campos\ \-\ MG",
"55624101", "Goiânia\ \-\ GO",
"55893559", "Itaueira\ \-\ PI",
"55733552", "Córrego\ de\ Pedras\ \-\ BA",
"55753204", "Feira\ de\ Santana\ \-\ BA",
"55873881", "Ipubi\ \-\ PE",
"55513757", "Nova\ Bréscia\ \-\ RS",
"5561344", "Brasília\ \-\ DF",
"55513621", "Capão\ Novo\ \-\ RS",
"55873836", "Sanharó\ \-\ PE",
"55313539", "Betim\ \-\ MG",
"55883585", "Iguatu\ \-\ CE",
"55673432", "Ponta\ Porã\ \-\ MS",
"55643663", "Caiapônia\ \-\ GO",
"55193546", "Cordeirópolis\ \-\ SP",
"55513432", "Gravataí\ \-\ RS",
"55114603", "Bragança\ Paulista\ \-\ SP",
"55212647", "Magé\ \-\ RJ",
"55753362", "Boa\ Vista\ Cananéia\ \-\ BA",
"55474108", "Balneário\ Camboriú\ \-\ SC",
"55423026", "Ponta\ Grossa\ \-\ PR",
"55773411", "Ibitira\ \-\ BA",
"55843383", "José\ da\ Penha\ \-\ RN",
"55193795", "Campinas\ \-\ SP",
"55713453", "Salvador\ \-\ BA",
"55114272", "Santana\ de\ Parnaíba\ \-\ SP",
"55383740", "Pirapora\ \-\ MG",
"55613677", "Planaltina\ \-\ GO",
"55114806", "Jundiaí\ \-\ SP",
"55713648", "Dias\ d\'Ávila\ \-\ BA",
"55114731", "Suzano\ \-\ SP",
"55853813", "São\ Paulo\ \-\ SP",
"55513567", "Santa\ Maria\ do\ Herval\ \-\ RS",
"55654052", "Cuiabá\ \-\ MT",
"55693252", "Vila\ Extrema\ \-\ RO",
"55133841", "Iguape\ \-\ SP",
"55114786", "Taboão\ da\ Serra\ \-\ SP",
"55193816", "Indaiatuba\ \-\ SP",
"55623550", "Aragoiânia\ \-\ GO",
"55483538", "Balneário\ Bela\ Torres\ \-\ SC",
"55773445", "Condeúba\ \-\ BA",
"552124", "Rio\ de\ Janeiro\ \-\ RJ",
"55823624", "Pão\ de\ Açúcar\ \-\ AL",
"55493449", "Ipuaçu\ \-\ SC",
"55633488", "Praia\ Norte\ \-\ TO",
"55883633", "Ararendá\ \-\ CE",
"55613391", "Brazlândia\ \-\ DF",
"55333513", "Campanário\ \-\ MG",
"55273255", "Viana\ \-\ ES",
"55913015", "Belém\ \-\ PA",
"55212700", "Itaguaí\ \-\ RJ",
"55732103", "Itabuna\ \-\ BA",
"55222781", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55163821", "Orlândia\ \-\ SP",
"55513691", "Rio\ Grande\ do\ Sul",
"55115631", "São\ Paulo\ \-\ SP",
"55433473", "Lidianópolis\ \-\ PR",
"55643564", "Anicuns\ \-\ GO",
"55623586", "Goiânia\ \-\ GO",
"55322102", "Juiz\ de\ Fora\ \-\ MG",
"55633385", "Talismã\ \-\ TO",
"55453266", "Céu\ Azul\ \-\ PR",
"55443433", "Nova\ Aliança\ do\ Ivaí\ \-\ PR",
"55142108", "Bauru\ \-\ SP",
"5513346", "São\ Vicente\ \-\ SP",
"55963322", "Pedra\ Branca\ do\ Amaparí\ \-\ AP",
"55213485", "Rio\ de\ Janeiro\ \-\ RJ",
"55673681", "Terenos\ \-\ MS",
"55883649", "Meruoca\ \-\ CE",
"5583323", "João\ Pessoa\ \-\ PB",
"55513681", "Cidreira\ \-\ RS",
"5563341", "Araguaína\ \-\ TO",
"55493433", "Xanxerê\ \-\ SC",
"5511501", "São\ Paulo\ \-\ SP",
"55115696", "São\ Paulo\ \-\ SP",
"55753211", "Feira\ de\ Santana\ \-\ BA",
"55222791", "Macaé\ \-\ RJ",
"55533258", "Santana\ da\ Boa\ Vista\ \-\ RS",
"55192108", "Americana\ \-\ SP",
"55873821", "Arcoverde\ \-\ PE",
"55513636", "Rio\ Grande\ do\ Sul",
"55843323", "Mossoró\ \-\ RN",
"55343353", "Conquista\ \-\ MG",
"55183656", "Jatobá\ \-\ SP",
"55153252", "Torre\ de\ Pedra\ \-\ SP",
"55183379", "São\ José\ Laranjeiras\ \-\ SP",
"55883525", "Antonina\ do\ Norte\ \-\ CE",
"55423902", "Guarapuava\ \-\ PR",
"55373344", "Pedra\ do\ Indaiá\ \-\ MG",
"55623596", "Aparecida\ de\ Goiânia\ \-\ GO",
"55343611", "Araxá\ \-\ MG",
"55793261", "São\ Cristóvão\ \-\ SE",
"55993648", "Bernardo\ do\ Mearim\ \-\ MA",
"55873875", "Cabrobó\ \-\ PE",
"55553278", "Pinhal\ Grande\ \-\ RS",
"55273031", "Vila\ Velha\ \-\ ES",
"55123301", "Lorena\ \-\ SP",
"55893462", "Oeiras\ \-\ PI",
"5577", "Bahia",
"55843248", "Senador\ Georgino\ Avelino\ \-\ RN",
"55313719", "Minas\ Gerais",
"55553797", "Novo\ Tiradentes\ \-\ RS",
"55353333", "Soledade\ de\ Minas\ \-\ MG",
"55513038", "Campo\ Bom\ \-\ RS",
"55124408", "Polvilho\ \-\ SP",
"55673038", "Dourados\ \-\ MS",
"55463542", "Santa\ Izabel\ do\ Oeste\ \-\ PR",
"55613381", "Guará\ \-\ DF",
"55133272", "Santos\ \-\ SP",
"55883571", "Juazeiro\ do\ Norte\ \-\ CE",
"55613540", "Brazlândia\ \-\ DF",
"55213434", "Rio\ de\ Janeiro\ \-\ RJ",
"55163956", "Pontal\ \-\ SP",
"55613336", "Taguatinga\ \-\ DF",
"55313767", "Minas\ Gerais",
"55813661", "Palmares\ \-\ PE",
"55115907", "São\ Paulo\ \-\ SP",
"55113171", "São\ Paulo\ \-\ SP",
"55823337", "Maceió\ \-\ AL",
"55433151", "Sabáudia\ \-\ PR",
"55923306", "Manaus\ \-\ AM",
"55493677", "Itapiranga\ \-\ SC",
"55273145", "Vitória\ \-\ ES",
"55893474", "Pimenteiras\ \-\ PI",
"55443540", "Bragantina\ \-\ PR",
"55983313", "São\ Luís\ \-\ MA",
"55933505", "Aveiro\ \-\ PA",
"55173283", "Jaci\ \-\ SP",
"55453541", "Santa\ Terezinha\ de\ Itaipu\ \-\ PR",
"55183283", "Euclides\ da\ Cunha\ Paulista\ \-\ SP",
"55133302", "Praia\ Grande\ \-\ SP",
"55424141", "Ponta\ Grossa\ \-\ PR",
"55333297", "Santa\ Efigênia\ de\ Minas\ \-\ MG",
"55153245", "Votorantim\ \-\ SP",
"55283521", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55863293", "Regeneração\ \-\ PI",
"55823269", "Pólo\ Cloroquímico\ de\ Alagoas\ \-\ AL",
"55553612", "Dilermando\ de\ Aguiar\ \-\ RS",
"55933736", "Munguba\ \-\ PA",
"55833063", "Campina\ Grande\ \-\ PB",
"55893426", "Geminiano\ \-\ PI",
"55813481", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55214117", "Nova\ Iguaçu\ \-\ RJ",
"55654004", "Várzea\ Grande\ \-\ MT",
"55833398", "Itatuba\ \-\ PB",
"55553308", "Ijuí\ \-\ RS",
"55813436", "Paulista\ \-\ PE",
"55843692", "Lagoa\ de\ Pedras\ \-\ RN",
"55653312", "Santo\ Afonso\ \-\ MT",
"55843087", "Natal\ \-\ RN",
"55433566", "Carlópolis\ \-\ PR",
"55463555", "Planalto\ \-\ PR",
"55112533", "São\ Paulo\ \-\ SP",
"55163251", "Guariba\ \-\ SP",
"55173209", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55243373", "Paraty\ \-\ RJ",
"55213665", "Queimados\ \-\ RJ",
"55753331", "Seabra\ \-\ BA",
"55743546", "Itiúba\ \-\ BA",
"55513461", "Esteio\ \-\ RS",
"55673461", "Naviraí\ \-\ MS",
"55873035", "Petrolina\ \-\ PE",
"55423521", "União\ da\ Vitória\ \-\ PR",
"55923012", "Manaus\ \-\ AM",
"55242291", "Petrópolis\ \-\ RJ",
"55913795", "Baião\ \-\ PA",
"55983651", "Araguanã\ \-\ MA",
"55433032", "Londrina\ \-\ PR",
"55433901", "Apucarana\ \-\ PR",
"55144004", "Bauru\ \-\ SP",
"55473492", "Santa\ Cruz\ \-\ SC",
"55693423", "Ji\-Paraná\ \-\ RO",
"55162133", "Ribeirão\ Preto\ \-\ SP",
"55933544", "Oriximiná\ \-\ PA",
"55773452", "Guanambi\ \-\ BA",
"55473626", "São\ Bento\ do\ Sul\ \-\ SC",
"55483626", "Tubarão\ \-\ SC",
"55383221", "Montes\ Claros\ \-\ MG",
"55373221", "Divinópolis\ \-\ MG",
"55613433", "Brasília\ \-\ DF",
"55273242", "Vila\ Velha\ \-\ ES",
"55114016", "Jarinu\ \-\ SP",
"5521323", "Rio\ de\ Janeiro\ \-\ RJ",
"55663479", "Novo\ São\ Joaquim\ \-\ MT",
"55343263", "Capinópolis\ \-\ MG",
"55833485", "Santana\ dos\ Garrotes\ \-\ PB",
"55473674", "São\ Miguel\ da\ Serra\ \-\ SC",
"55332101", "Governador\ Valadares\ \-\ MG",
"55353436", "Toledo\ \-\ MG",
"55733511", "Eunápolis\ \-\ BA",
"55793546", "Umbaúba\ \-\ SE",
"55112625", "São\ Paulo\ \-\ SP",
"55123842", "Ubatuba\ \-\ SP",
"55793351", "Porto\ da\ Folha\ \-\ SE",
"55833434", "Guarabira\ \-\ PB",
"55343456", "União\ de\ Minas\ \-\ MG",
"55153572", "Itaberá\ \-\ SP",
"55843426", "Serra\ Negra\ do\ Norte\ \-\ RN",
"55173293", "Palestina\ \-\ SP",
"55373275", "São\ José\ da\ Varginha\ \-\ MG",
"55343848", "Romaria\ \-\ MG",
"55813758", "Barra\ de\ Guabiraba\ \-\ PE",
"55913734", "Quatro\ Bocas\ \-\ PA",
"55623459", "Alto\ Paraíso\ de\ Goiás\ \-\ GO",
"55773620", "Serra\ do\ Ramalho\ \-\ BA",
"55114264", "Francisco\ Morato\ \-\ SP",
"55313728", "Buarque\ de\ Macedo\ \-\ MG",
"55114618", "Jandira\ \-\ SP",
"55443677", "Tapejara\ \-\ PR",
"55423242", "Ipiranga\ \-\ PR",
"55193312", "Indaiatuba\ \-\ SP",
"55514009", "Porto\ Alegre\ \-\ RS",
"55833388", "Seridó\ \-\ PB",
"55483028", "Florianópolis\ \-\ SC",
"55813491", "Olinda\ \-\ PE",
"55673410", "Dourados\ \-\ MS",
"55493336", "Guatambú\ \-\ SC",
"55112549", "São\ Paulo\ \-\ SP",
"55193608", "São\ José\ do\ Rio\ Pardo\ \-\ SP",
"55113447", "Osasco\ \-\ SP",
"55114302", "São\ Paulo\ \-\ SP",
"55112819", "Mogi\ das\ Cruzes\ \-\ SP",
"55413663", "Colombo\ \-\ PR",
"55893450", "Francisco\ Santos\ \-\ PI",
"55313029", "Belo\ Horizonte\ \-\ MG",
"55623942", "Goiânia\ \-\ GO",
"55212772", "Duque\ de\ Caxias\ \-\ RJ",
"55753326", "Boa\ Vista\ do\ Tupim\ \-\ BA",
"55313430", "Minas\ Gerais",
"55112867", "São\ Paulo\ \-\ SP",
"5511367", "São\ Paulo\ \-\ SP",
"55813475", "Recife\ \-\ PE",
"55623091", "Goiânia\ \-\ GO",
"55993541", "Balsas\ \-\ MA",
"55114044", "Diadema\ \-\ SP",
"55123512", "São\ José\ dos\ Campos\ \-\ SP",
"55532125", "Rio\ Grande\ \-\ RS",
"55333508", "Governador\ Valadares\ \-\ MG",
"55653261", "Araputanga\ \-\ MT",
"55913184", "Belém\ \-\ PA",
"55183223", "Presidente\ Prudente\ \-\ SP",
"55823033", "Maceió\ \-\ AL",
"55943222", "Marabá\ \-\ PA",
"55313277", "Minas\ Gerais",
"55553249", "Santiago\ \-\ RS",
"55843279", "Extremoz\ \-\ RN",
"5586", "Piauí",
"55733629", "São\ João\ do\ Paraíso\ \-\ BA",
"55793194", "Aracaju\ \-\ SE",
"55193407", "Americana\ \-\ SP",
"55633467", "Presidente\ Kennedy\ \-\ TO",
"55283536", "Anchieta\ \-\ ES",
"55473363", "Balneário\ Camboriú\ \-\ SC",
"55513588", "São\ Leopoldo\ \-\ RS",
"55813378", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55114469", "Santo\ André\ \-\ SP",
"55893431", "Padre\ Marcos\ \-\ PI",
"55443565", "Tuneiras\ do\ Oeste\ \-\ PR",
"55473098", "Itapema\ \-\ SC",
"55143261", "Agudos\ \-\ SP",
"55173445", "Américo\ de\ Campos\ \-\ SP",
"55543253", "Jaquirana\ \-\ RS",
"55323441", "Leopoldina\ \-\ MG",
"5598324", "São\ Luís\ \-\ MA",
"55312586", "Contagem\ \-\ MG",
"55843431", "Currais\ Novos\ \-\ RN",
"55163024", "Ribeirão\ Preto\ \-\ SP",
"55112685", "São\ Paulo\ \-\ SP",
"55192113", "Limeira\ \-\ SP",
"55833257", "Mata\ Redonda\ \-\ PB",
"55833471", "Malta\ \-\ PB",
"55893496", "São\ Francisco\ de\ Assis\ do\ Piauí\ \-\ PI",
"55423667", "Inácio\ Martins\ \-\ PR",
"55114762", "Mogi\ das\ Cruzes\ \-\ SP",
"55913771", "Mosqueiro\ \-\ PA",
"55733272", "Ibicuí\ \-\ BA",
"55943356", "Parauapebas\ \-\ PA",
"55512121", "Porto\ Alegre\ \-\ RS",
"55143407", "Garça\ \-\ SP",
"55513598", "Campo\ Bom\ \-\ RS",
"55493321", "Chapecó\ \-\ SC",
"55114005", "São\ Paulo\ \-\ SP",
"55623372", "Goiás\ \-\ GO",
"55453282", "Pato\ Bragado\ \-\ PR",
"5551351", "Rio\ Grande\ do\ Sul",
"55212479", "São\ Gonçalo\ \-\ RJ",
"55373281", "Santo\ Antônio\ do\ Monte\ \-\ MG",
"55473631", "São\ Bento\ do\ Sul\ \-\ SC",
"55483631", "Tubarão\ \-\ SC",
"55383236", "Juramento\ \-\ MG",
"55273111", "Aracruz\ \-\ ES",
"55323273", "Matias\ Barbosa\ \-\ MG",
"55753252", "Ruy\ Barbosa\ \-\ BA",
"55383812", "Espinosa\ \-\ MG",
"55242221", "Petrópolis\ \-\ RJ",
"55913725", "Apeú\ \-\ PA",
"5582335", "Maceió\ \-\ AL",
"55553233", "São\ Sepé\ \-\ RS",
"55443810", "Campo\ Mourão\ \-\ PR",
"55773656", "Brejolândia\ \-\ BA",
"55273744", "Governador\ Lindenberg\ \-\ ES",
"55473422", "Joinville\ \-\ SC",
"55833425", "Quixabá\ \-\ PB",
"55983278", "São\ Luís\ \-\ MA",
"55713125", "Camaçari\ \-\ BA",
"55983349", "Barreirinhas\ \-\ MA",
"55733531", "Ipiaú\ \-\ BA",
"55613054", "Brasília\ \-\ DF",
"55173486", "Álvares\ Florence\ \-\ SP",
"55893445", "Santa\ Cruz\ do\ Piauí\ \-\ PI",
"55983661", "Codó\ \-\ MA",
"5584", "Rio\ Grande\ do\ Norte",
"55153274", "Alambari\ \-\ SP",
"55183622", "Araçatuba\ \-\ SP",
"55993584", "Lajeado\ Novo\ \-\ MA",
"55173622", "Jales\ \-\ SP",
"55513451", "Rio\ Grande\ do\ Sul",
"55114036", "Piracaia\ \-\ SP",
"5543342", "Apucarana\ \-\ PR",
"55673451", "Itaporã\ \-\ MS",
"55193024", "Rio\ Claro\ \-\ SP",
"55433556", "Abatiá\ \-\ PR",
"55463565", "Flor\ da\ Serra\ do\ Sul\ \-\ PR",
"55114081", "São\ Paulo\ \-\ SP",
"55542521", "Bento\ Gonçalves\ \-\ RS",
"55713594", "Simões\ Filho\ \-\ BA",
"55743649", "Uibaí\ \-\ BA",
"55513430", "Gravataí\ \-\ RS",
"55283544", "Muniz\ Freire\ \-\ ES",
"55543057", "Bento\ Gonçalves\ \-\ RS",
"55273355", "Vitória\ \-\ ES",
"55493316", "Chapecó\ \-\ SC",
"55993535", "Pequiá\ \-\ MA",
"55114638", "Poá\ \-\ SP",
"55673029", "Campo\ Grande\ \-\ MS",
"55323229", "Juiz\ de\ Fora\ \-\ MG",
"55714116", "Dias\ d\'Ávila\ \-\ BA",
"55443607", "São\ Tomé\ \-\ PR",
"55633234", "Palmas\ \-\ TO",
"55913821", "Peixe\-Boi\ \-\ PA",
"55222031", "Saquarema\ \-\ RJ",
"55193678", "Canoas\ \-\ SP",
"55214137", "Nilópolis\ \-\ RJ",
"5511587", "São\ Paulo\ \-\ SP",
"55243389", "Barra\ Mansa\ \-\ RJ",
"55633658", "Aurora\ do\ Tocantins\ \-\ TO",
"55753653", "Cairu\ \-\ BA",
"5571210", "Salvador\ \-\ BA",
"55483529", "Praia\ Grande\ \-\ SC",
"55133372", "Cubatão\ \-\ SP",
"5531351", "Minas\ Gerais",
"55323338", "Madre\ de\ Deus\ de\ Minas\ \-\ MG",
"55833642", "Santa\ Cecília\ \-\ PB",
"55542104", "Passo\ Fundo\ \-\ RS",
"5565364", "Cuiabá\ \-\ MT",
"55914104", "Ananindeua\ \-\ PA",
"55663493", "Pedra\ Preta\ \-\ MT",
"55553421", "Alegrete\ \-\ RS",
"55923324", "Presidente\ Figueiredo\ \-\ AM",
"55483645", "Armazém\ \-\ SC",
"55313118", "Belo\ Horizonte\ \-\ MG",
"55793361", "Amparo\ de\ São\ Francisco\ \-\ SE",
"55213288", "Rio\ de\ Janeiro\ \-\ RJ",
"55143332", "Santa\ Cruz\ do\ Rio\ Pardo\ \-\ SP",
"55242433", "Barra\ do\ Piraí\ \-\ RJ",
"55433306", "Londrina\ \-\ PR",
"55183279", "Regente\ Feijó\ \-\ SP",
"55173279", "Olímpia\ \-\ SP",
"55133036", "Santos\ \-\ SP",
"55993623", "Bom\ Lugar\ \-\ MA",
"55663211", "Sinop\ \-\ MT",
"55373244", "Carmo\ do\ Cajuru\ \-\ MG",
"55413554", "Quatro\ Barras\ \-\ PR",
"55753647", "Aratuípe\ \-\ BA",
"55513788", "Progresso\ \-\ RS",
"55733673", "Arataca\ \-\ BA",
"55843223", "Natal\ \-\ RN",
"55933521", "Vila\ Residencial\ Belo\ Monte\ \-\ PA",
"55913633", "Curralinho\ \-\ PA",
"55112646", "São\ Paulo\ \-\ SP",
"55313598", "Minas\ Gerais",
"55114091", "Diadema\ \-\ SP",
"55753311", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"55483879", "Florianópolis\ \-\ SC",
"55273736", "Laranja\ da\ Terra\ \-\ ES",
"55653332", "Nova\ Olímpia\ \-\ MT",
"5589", "Piauí",
"551120", "São\ Paulo\ \-\ SP",
"5583333", "Campina\ Grande\ \-\ PB",
"55773462", "Caetanos\ \-\ BA",
"55743633", "Saúde\ \-\ BA",
"55443555", "Nice\ \-\ PR",
"55443344", "Maringá\ \-\ PR",
"55863087", "Teresina\ \-\ PI",
"55112843", "São\ Paulo\ \-\ SP",
"55473353", "Apiúna\ \-\ SC",
"55433520", "Cornélio\ Procópio\ \-\ PR",
"55313878", "Contagem\ \-\ MG",
"55663423", "Rondonópolis\ \-\ MT",
"55633457", "Colméia\ \-\ TO",
"55163982", "Serra\ Azul\ \-\ SP",
"55623302", "Jussara\ \-\ GO",
"55753345", "Nova\ Redenção\ \-\ BA",
"55614020", "Brasília\ \-\ DF",
"55143477", "Arco\-Íris\ \-\ SP",
"55733202", "Barra\ do\ Rocha\ \-\ BA",
"55423639", "Foz\ do\ Jordão\ \-\ PR",
"55624014", "Anápolis\ \-\ GO",
"55743534", "Pilão\ Arcado\ \-\ BA",
"55733526", "Jequié\ \-\ BA",
"55653251", "São\ José\ dos\ Quatro\ Marcos\ \-\ MT",
"55473347", "Piçarras\ \-\ SC",
"55463540", "Pranchita\ \-\ PR",
"55623016", "Aparecida\ de\ Goiânia\ \-\ GO",
"55993576", "Matões\ \-\ MA",
"55843293", "Serra\ Caiada\ \-\ RN",
"55383832", "São\ João\ do\ Paraíso\ \-\ MG",
"55673003", "Campo\ Grande\ \-\ MS",
"55963282", "Santana\ \-\ AP",
"55173426", "Votuporanga\ \-\ SP",
"55383216", "Montes\ Claros\ \-\ MG",
"55373216", "Divinópolis\ \-\ MG",
"55672105", "Três\ Lagoas\ \-\ MS",
"55313528", "Belo\ Horizonte\ \-\ MG",
"55312191", "Contagem\ \-\ MG",
"55114021", "Salto\ \-\ SP",
"55153286", "Jumirim\ \-\ SP",
"55413653", "Pinhais\ \-\ PR",
"55753448", "Itamira\ \-\ BA",
"5551353", "Rio\ Grande\ do\ Sul",
"55423643", "Nova\ Tebas\ \-\ PR",
"55513728", "Rio\ Grande\ do\ Sul",
"55843283", "Brejinho\ \-\ RN",
"55212882", "Nova\ Iguaçu\ \-\ RJ",
"55443305", "Maringá\ \-\ PR",
"55853461", "Fortaleza\ \-\ CE",
"55413140", "Campo\ Largo\ \-\ PR",
"55613962", "Brasília\ \-\ DF",
"55613275", "Brasília\ \-\ DF",
"55423516", "Rio\ Claro\ do\ Sul\ \-\ PR",
"55122127", "Jacareí\ \-\ SP",
"55753262", "Conceição\ do\ Coité\ \-\ BA",
"55933536", "Juruti\ \-\ PA",
"55433315", "Londrina\ \-\ PR",
"55543456", "Santa\ Tereza\ \-\ RS",
"55312136", "Ipatinga\ \-\ MG",
"55383742", "Buritizeiro\ \-\ MG",
"55313410", "Minas\ Gerais",
"55863474", "Pimenteiras\ \-\ PI",
"55353444", "Jacutinga\ \-\ MG",
"55173692", "Santana\ da\ Ponte\ Pensa\ \-\ SP",
"55242102", "Volta\ Redonda\ \-\ RJ",
"55273721", "Colatina\ \-\ ES",
"55183692", "Braúna\ \-\ SP",
"55314009", "Belo\ Horizonte\ \-\ MG",
"55112839", "São\ Paulo\ \-\ SP",
"55933062", "Santarém\ \-\ PA",
"55623552", "Guapó\ \-\ GO",
"55663572", "Nova\ Bandeirantes\ \-\ MT",
"55943366", "Vila\ Novo\ Paraíso\ \-\ PA",
"55313207", "Belo\ Horizonte\ \-\ MG",
"55373433", "São\ Roque\ de\ Minas\ \-\ MG",
"55913746", "Bujaru\ \-\ PA",
"55113392", "São\ Paulo\ \-\ SP",
"55343662", "Araxá\ \-\ MG",
"55633439", "Itacajá\ \-\ TO",
"55163041", "Sertãozinho\ \-\ SP",
"55193477", "Americana\ \-\ SP",
"55693231", "Itapuã\ do\ Oeste\ \-\ RO",
"55323424", "Laranjal\ \-\ MG",
"55123668", "Campos\ do\ Jordão\ \-\ SP",
"55423657", "Palmital\ \-\ PR",
"55513099", "São\ Leopoldo\ \-\ RS",
"55493555", "Capinzal\ \-\ SC",
"55643479", "Panamá\ \-\ GO",
"55493344", "São\ Lourenço\ do\ Oeste\ \-\ SC",
"55833267", "Juarez\ Távora\ \-\ PB",
"55353558", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"55823013", "Maceió\ \-\ AL",
"55122125", "Taubaté\ \-\ SP",
"55114484", "Mairiporã\ \-\ SP",
"55113431", "Barueri\ \-\ SP",
"55913661", "Oeiras\ do\ Pará\ \-\ PA",
"55863280", "São\ Pedro\ do\ Piauí\ \-\ PI",
"55213846", "Duque\ de\ Caxias\ \-\ RJ",
"55823276", "Jequiá\ da\ Praia\ \-\ AL",
"55453559", "Itaipulândia\ \-\ PR",
"55773623", "São\ Desidério\ \-\ BA",
"55513054", "Viamão\ \-\ RS",
"55713717", "Camaçari\ \-\ BA",
"55323254", "Piau\ \-\ MG",
"55493543", "Anita\ Garibaldi\ \-\ SC",
"55333246", "Mendes\ Pimentel\ \-\ MG",
"55743661", "Xique\-Xique\ \-\ BA",
"55623406", "Buritinópolis\ \-\ GO",
"55133494", "Praia\ Grande\ \-\ SP",
"55123023", "Jacareí\ \-\ SP",
"55753660", "Pé\ de\ Serra\ \-\ BA",
"55413604", "Fazenda\ Rio\ Grande\ \-\ PR",
"55673413", "Panambi\ \-\ MS",
"55983525", "Imperatriz\ \-\ MA",
"55423655", "Altamira\ do\ Paraná\ \-\ PR",
"55353015", "Varginha\ \-\ MG",
"55493018", "Lages\ \-\ SC",
"55943323", "Marabá\ \-\ PA",
"55433579", "Salto\ do\ Itararé\ \-\ PR",
"55183322", "Assis\ \-\ SP",
"55183862", "Pacaembu\ \-\ SP",
"55673291", "Coxim\ \-\ MS",
"55983361", "Axixá\ \-\ MA",
"55112301", "São\ Paulo\ \-\ SP",
"55863256", "Alto\ Longá\ \-\ PI",
"55623928", "Goiânia\ \-\ GO",
"55833265", "Duas\ Estradas\ \-\ PB",
"55493557", "Zortéa\ \-\ SC",
"55412152", "Paranaguá\ \-\ PR",
"55483262", "Governador\ Celso\ Ramos\ \-\ SC",
"55353261", "Campanha\ \-\ MG",
"55863322", "Parnaíba\ \-\ PI",
"55673236", "Nioaque\ \-\ MS",
"55473448", "Balneário\ Barra\ do\ Sul\ \-\ SC",
"55883416", "Tauá\ \-\ CE",
"55513236", "Rio\ Grande\ do\ Sul",
"55373073", "Itaúna\ \-\ MG",
"55112346", "São\ Paulo\ \-\ SP",
"55493539", "Iomerê\ \-\ SC",
"55243370", "Angra\ dos\ Reis\ \-\ RJ",
"55443557", "Terra\ Nova\ do\ Piquirí\ \-\ PR",
"55543352", "São\ José\ do\ Ouro\ \-\ RS",
"55193948", "Louveira\ \-\ SP",
"55433133", "Cornélio\ Procópio\ \-\ PR",
"55173256", "Santa\ Luzia\ \-\ SP",
"5562332", "Anápolis\ \-\ GO",
"55112166", "Barueri\ \-\ SP",
"55273288", "Marechal\ Floriano\ \-\ ES",
"55443018", "Cianorte\ \-\ PR",
"55143475", "Ocauçu\ \-\ SP",
"55653421", "Rondonópolis\ \-\ MT",
"55633455", "Nazaré\ \-\ TO",
"55663466", "Ponte\ Branca\ \-\ MT",
"55642104", "Rio\ Verde\ \-\ GO",
"55214501", "Rio\ de\ Janeiro\ \-\ RJ",
"55443543", "Ubiratã\ \-\ PR",
"55623441", "Catalão\ \-\ GO",
"55813015", "Recife\ \-\ PE",
"55143632", "Dois\ Córregos\ \-\ SP",
"55173463", "Fernandópolis\ \-\ SP",
"55313244", "Minas\ Gerais",
"55483345", "Tijucas\ \-\ SC",
"55114494", "Atibaia\ \-\ SP",
"55173280", "Olímpia\ \-\ SP",
"55833342", "Campina\ Grande\ \-\ PB",
"55793349", "Porto\ da\ Folha\ \-\ SE",
"55713462", "Salvador\ \-\ BA",
"55693043", "Porto\ Velho\ \-\ RO",
"55213781", "Itaguaí\ \-\ RJ",
"55143378", "Salto\ Grande\ \-\ SP",
"55553332", "Ijuí\ \-\ RS",
"55512107", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55633358", "Dueré\ \-\ TO",
"55753353", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"55213736", "Rio\ de\ Janeiro\ \-\ RJ",
"55323372", "São\ João\ Del\ Rei\ \-\ MG",
"55643652", "Cristianópolis\ \-\ GO",
"55152104", "Sorocaba\ \-\ SP",
"55133203", "Santos\ \-\ SP",
"55823235", "Maceió\ \-\ AL",
"55983212", "São\ Luís\ \-\ MA",
"55953543", "Iracema\ \-\ RR",
"55343245", "Indianópolis\ \-\ MG",
"55543231", "Vacaria\ \-\ RS",
"55163308", "Gavião\ Peixoto\ \-\ SP",
"55623988", "Goiânia\ \-\ GO",
"55343423", "Frutal\ \-\ MG",
"55483647", "Laguna\ \-\ SC",
"55543286", "Gramado\ \-\ RS",
"55993559", "Sucupira\ do\ Norte\ \-\ MA",
"55473647", "Mafra\ \-\ SC",
"55122134", "São\ José\ dos\ Campos\ \-\ SP",
"55313064", "Belo\ Horizonte\ \-\ MG",
"55653491", "Itiquira\ \-\ MT",
"55883444", "Quixeramobim\ \-\ CE",
"55773683", "Jaborandi\ \-\ BA",
"55843266", "Pureza\ \-\ RN",
"55613003", "Brasília\ \-\ DF",
"55113426", "Diadema\ \-\ SP",
"55193481", "São\ Pedro\ \-\ SP",
"55313832", "Santa\ Bárbara\ \-\ MG",
"55553251", "Santiago\ \-\ RS",
"55683542", "Xapuri\ \-\ AC",
"55513542", "Taquara\ \-\ RS",
"55114424", "Santo\ André\ \-\ SP",
"55213639", "Itaboraí\ \-\ RJ",
"55993666", "Santo\ Antônio\ dos\ Lopes\ \-\ MA",
"55943309", "Cumaru\ do\ Norte\ \-\ PA",
"55163405", "Franca\ \-\ SP",
"55473653", "Papanduva\ \-\ SC",
"55113158", "São\ Paulo\ \-\ SP",
"55483653", "Rio\ Fortuna\ \-\ SC",
"55313449", "Belo\ Horizonte\ \-\ MG",
"55213131", "Rio\ de\ Janeiro\ \-\ RJ",
"55443644", "São\ Manoel\ do\ Paraná\ \-\ PR",
"55823284", "Cajueiro\ \-\ AL",
"55883558", "Abaiara\ \-\ CE",
"55223311", "Macaé\ \-\ RJ",
"55313216", "Minas\ Gerais",
"55143491", "Tupã\ \-\ SP",
"55133299", "Santos\ \-\ SP",
"55453323", "Cascavel\ \-\ PR",
"55893447", "São\ José\ do\ Piauí\ \-\ PI",
"55243354", "Resende\ \-\ RJ",
"55663538", "Bom\ Jesus\ do\ Araguaia\ \-\ MT",
"55193491", "Capivari\ \-\ SP",
"55493719", "Capinzal\ \-\ SC",
"55773693", "Rio\ do\ Pires\ \-\ BA",
"55493644", "Dionísio\ Cerqueira\ \-\ SC",
"55823294", "União\ dos\ Palmares\ \-\ AL",
"55143481", "Marília\ \-\ SP",
"55213814", "Rio\ de\ Janeiro\ \-\ RJ",
"55953539", "Nova\ Colina\ \-\ RR",
"55473360", "Balneário\ Camboriú\ \-\ SC",
"55384009", "Montes\ Claros\ \-\ MG",
"55153263", "Boituva\ \-\ SP",
"55634003", "Palmas\ \-\ TO",
"55313742", "Ouro\ Branco\ \-\ MG",
"55753604", "Feira\ de\ Santana\ \-\ BA",
"55893453", "Pio\ Ix\ \-\ PI",
"55173392", "Viradouro\ \-\ SP",
"55993537", "Senador\ La\ Roque\ \-\ MA",
"55313433", "Belo\ Horizonte\ \-\ MG",
"55673221", "Três\ Lagoas\ \-\ MS",
"55543055", "Bento\ Gonçalves\ \-\ RS",
"55273357", "Vitória\ \-\ ES",
"55413589", "Piraquara\ \-\ PR",
"55323021", "Ubá\ \-\ MG",
"55743527", "Casa\ Nova\ \-\ BA",
"55213643", "Teresópolis\ \-\ RJ",
"55333532", "Itaipé\ \-\ MG",
"55543296", "Nova\ Pádua\ \-\ RS",
"55453248", "Iguatu\ \-\ PR",
"55643480", "Edealina\ \-\ GO",
"55623998", "Goiânia\ \-\ GO",
"55833255", "João\ Pessoa\ \-\ PB",
"55353251", "Cambuquira\ \-\ MG",
"55483252", "São\ Bonifácio\ \-\ SC",
"55453379", "Toledo\ \-\ PR",
"55493567", "Caçador\ \-\ SC",
"55333225", "Governador\ Valadares\ \-\ MG",
"55313542", "Nova\ Lima\ \-\ MG",
"55112687", "São\ Paulo\ \-\ SP",
"55753422", "Alagoinhas\ \-\ BA",
"55443038", "Umuarama\ \-\ PR",
"55973351", "Beruri\ \-\ AM",
"55983351", "Viana\ \-\ MA",
"55923133", "Manaus\ \-\ AM",
"55843220", "Natal\ \-\ RN",
"55883436", "Itatira\ \-\ CE",
"55673216", "Sidrolândia\ \-\ MS",
"55143405", "Pompéia\ \-\ SP",
"55653308", "Nova\ Mutum\ \-\ MT",
"55683216", "Rio\ Branco\ \-\ AC",
"55114007", "São\ Paulo\ \-\ SP",
"55413883", "Curitiba\ \-\ PR",
"55753631", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"55673449", "Nova\ Andradina\ \-\ MS",
"55513449", "Rio\ Grande\ do\ Sul",
"55743630", "Mirangaba\ \-\ BA",
"55163491", "Sertãozinho\ \-\ SP",
"55193017", "Indaiatuba\ \-\ SP",
"55213716", "São\ Gonçalo\ \-\ RJ",
"55613461", "Ceilândia\ \-\ DF",
"55753650", "Nordestina\ \-\ BA",
"55843392", "Antônio\ Martins\ \-\ RN",
"55323264", "Guarará\ \-\ MG",
"55613878", "Brasília\ \-\ DF",
"55333732", "Comercinho\ \-\ MG",
"55553312", "Santo\ Ângelo\ \-\ RS",
"55743651", "Capim\ Grosso\ \-\ BA",
"55513064", "Sapiranga\ \-\ RS",
"55443636", "Pérola\ \-\ PR",
"55143308", "Fartura\ \-\ SP",
"55493199", "Chapecó\ \-\ SC",
"55833427", "Catingueira\ \-\ PB",
"55314122", "Contagem\ \-\ MG",
"55913727", "Tomé\-Açu\ \-\ PA",
"55242430", "Barra\ do\ Piraí\ \-\ RJ",
"55633368", "Pium\ \-\ TO",
"55493636", "São\ João\ do\ Oeste\ \-\ SC",
"55193308", "Campinas\ \-\ SP",
"55622765", "Goiânia\ \-\ GO",
"55114602", "Salto\ \-\ SP",
"55643662", "Palestina\ de\ Goiás\ \-\ GO",
"55223866", "São\ José\ de\ Ubá\ \-\ RJ",
"55513433", "Rio\ Grande\ do\ Sul",
"55673433", "Ponta\ Porã\ \-\ MS",
"55413626", "Mandirituba\ \-\ PR",
"55713452", "Salvador\ \-\ BA",
"55843382", "Luís\ Gomes\ \-\ RN",
"55923369", "Careiro\ da\ Várzea\ \-\ AM",
"55473564", "Rio\ do\ Campo\ \-\ SC",
"55433337", "Londrina\ \-\ PR",
"55413674", "Tijucas\ do\ Sul\ \-\ PR",
"55113411", "São\ Paulo\ \-\ SP",
"55793651", "Salgado\ \-\ SE",
"55813477", "Recife\ \-\ PE",
"55413482", "Guaraqueçaba\ \-\ PR",
"55173453", "Cardoso\ \-\ SP",
"55623476", "Colinas\ do\ Tocantins\ \-\ TO",
"55923317", "Autazes\ \-\ AM",
"55193405", "Americana\ \-\ SP",
"55633465", "Itapiratins\ \-\ TO",
"55383728", "Angueretá\ \-\ MG",
"55813094", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55173266", "Cedral\ \-\ SP",
"55793313", "Feira\ Nova\ \-\ SE",
"55473374", "Schroeder\ \-\ SC",
"55183266", "Alfredo\ Marcondes\ \-\ SP",
"55753696", "Saubara\ \-\ BA",
"55513742", "Sobradinho\ \-\ RS",
"5511439", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55543362", "Nonoai\ \-\ RS",
"55443567", "Quinta\ do\ Sol\ \-\ PR",
"55823522", "Arapiraca\ \-\ AL",
"55733547", "Aiquara\ \-\ BA",
"55614009", "Brasília\ \-\ DF",
"55414113", "Pinhais\ \-\ PR",
"55953621", "Boa\ Vista\ \-\ RR",
"55143416", "Jaú\ \-\ SP",
"5512395", "Jacareí\ \-\ SP",
"55313291", "Belo\ Horizonte\ \-\ MG",
"55114441", "Caieiras\ \-\ SP",
"55883568", "Jaguaribara\ \-\ CE",
"55413573", "Curitiba\ \-\ PR",
"55963323", "Macapá\ \-\ AP",
"55133406", "São\ Vicente\ \-\ SP",
"55693466", "Nova\ União\ \-\ RO",
"55623494", "Cavalcante\ \-\ GO",
"55413157", "Quatro\ Barras\ \-\ PR",
"55553015", "Santa\ Maria\ \-\ RS",
"55443432", "Nova\ Londrina\ \-\ PR",
"55813678", "Rio\ Formoso\ \-\ PE",
"55553261", "Restinga\ Seca\ \-\ RS",
"55443621", "Umuarama\ \-\ PR",
"55143768", "Jurumirim\ \-\ SP",
"5511356", "São\ Paulo\ \-\ SP",
"55433472", "Ivaiporã\ \-\ PR",
"55843256", "Boa\ Saúde\ \-\ RN",
"55333234", "Engenheiro\ Caldas\ \-\ MG",
"55543260", "Caravaggio\ \-\ RS",
"55463539", "Doutor\ Antônio\ Paranhos\ \-\ PR",
"55993569", "Senador\ Alexandre\ Costa\ \-\ MA",
"55183648", "Juritis\ \-\ SP",
"55173648", "Paranapuã\ \-\ SP",
"55753674", "Cruz\ das\ Almas\ \-\ BA",
"55112751", "São\ Paulo\ \-\ SP",
"55373277", "Leandro\ Ferreira\ \-\ MG",
"55732102", "Itabuna\ \-\ BA",
"55333512", "Frei\ Gaspar\ \-\ MG",
"55883632", "Viçosa\ do\ Ceará\ \-\ CE",
"5579324", "Aracaju\ \-\ SE",
"55883421", "Aracati\ \-\ CE",
"55113445", "Itaquaquecetuba\ \-\ SP",
"55114273", "Caieiras\ \-\ SP",
"55753626", "Feira\ de\ Santana\ \-\ BA",
"55533246", "Aceguá\ \-\ RS",
"55413907", "Curitiba\ \-\ PR",
"55693253", "Vila\ Nova\ Califórnia\ \-\ RO",
"55473396", "Brusque\ \-\ SC",
"55443675", "Cidade\ Gaúcha\ \-\ PR",
"55983194", "São\ Luís\ \-\ MA",
"55153247", "Votorantim\ \-\ SP",
"55133273", "Santos\ \-\ SP",
"55533201", "Rio\ Grande\ \-\ RS",
"55463543", "Realeza\ \-\ PR",
"55112334", "São\ Paulo\ \-\ SP",
"55333295", "Virgolândia\ \-\ MG",
"55683244", "Rio\ Branco\ \-\ AC",
"55493675", "Riqueza\ \-\ SC",
"55543702", "Bento\ Gonçalves\ \-\ RS",
"55823215", "Maceió\ \-\ AL",
"55473386", "Rio\ dos\ Cedros\ \-\ SC",
"55213895", "Rio\ de\ Janeiro\ \-\ RJ",
"55312107", "Sete\ Lagoas\ \-\ MG",
"55843034", "Natal\ \-\ RN",
"55163421", "Ribeirão\ Preto\ \-\ SP",
"55353332", "São\ Lourenço\ \-\ MG",
"55633440", "Fortaleza\ do\ Tabocão\ \-\ TO",
"55493621", "São\ Miguel\ do\ Oeste\ \-\ SC",
"55343352", "Uberaba\ \-\ MG",
"55112840", "Salto\ \-\ SP",
"55623484", "Mambaí\ \-\ GO",
"55213667", "Duque\ de\ Caxias\ \-\ RJ",
"55313236", "Belo\ Horizonte\ \-\ MG",
"55193768", "Campinas\ \-\ SP",
"55943379", "São\ João\ do\ Araguaia\ \-\ PA",
"55873948", "Bom\ Nome\ \-\ PE",
"55433523", "Cornélio\ Procópio\ \-\ PR",
"55473350", "Brusque\ \-\ SC",
"55423903", "União\ da\ Vitória\ \-\ PR",
"55463557", "Bela\ Vista\ da\ Caroba\ \-\ PR",
"55153253", "Quadra\ \-\ SP",
"55623338", "Corumbá\ de\ Goiás\ \-\ GO",
"55733238", "Itajuípe\ \-\ BA",
"55713656", "São\ Sebastião\ do\ Passé\ \-\ BA",
"55653233", "Salto\ do\ Céu\ \-\ MT",
"55163475", "Sertãozinho\ \-\ SP",
"55113404", "Bragança\ Paulista\ \-\ SP",
"55713379", "Lauro\ de\ Freitas\ \-\ BA",
"55493432", "Irani\ \-\ SC",
"55213970", "Rio\ de\ Janeiro\ \-\ RJ",
"55513952", "São\ Leopoldo\ \-\ RS",
"55983324", "Centro\ Novo\ do\ Maranhão\ \-\ MA",
"55673469", "Culturama\ \-\ MS",
"55423645", "Laranjal\ \-\ PR",
"55843285", "Várzea\ \-\ RN",
"55513469", "Cachoeirinha\ \-\ RS",
"55753339", "Souto\ Soares\ \-\ BA",
"5563", "Tocantins",
"55613273", "Brasília\ \-\ DF",
"55163818", "São\ Joaquim\ da\ Barra\ \-\ SP",
"55173201", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"5561332", "Brasília\ \-\ DF",
"55222662", "Arraial\ do\ Cabo\ \-\ RJ",
"55953238", "Rorainópolis\ \-\ RR",
"55213554", "Rio\ de\ Janeiro\ \-\ RJ",
"55112784", "São\ Paulo\ \-\ SP",
"55773498", "Formoso\ A\ \-\ BA",
"55123027", "São\ José\ dos\ Campos\ \-\ SP",
"55383672", "Paracatu\ \-\ MG",
"5511418", "Carapicuíba\ \-\ SP",
"55493547", "Celso\ Ramos\ \-\ SC",
"55313562", "Itabirito\ \-\ MG",
"55283529", "Itapemirim\ \-\ ES",
"55833274", "Araçagi\ \-\ PB",
"55823261", "Rio\ Largo\ \-\ AL",
"55743624", "Jacobina\ \-\ BA",
"55543011", "Farroupilha\ \-\ RS",
"55373435", "Vargem\ Bonita\ \-\ MG",
"55213856", "São\ Gonçalo\ \-\ RJ",
"55313372", "Minas\ Gerais",
"55943327", "Núcleo\ Carajás\ \-\ PA",
"55112506", "São\ Paulo\ \-\ SP",
"55513044", "Alvorada\ \-\ RS",
"55673044", "Campo\ Grande\ \-\ MS",
"55213448", "Rio\ de\ Janeiro\ \-\ RJ",
"55693642", "São\ Miguel\ do\ Guaporé\ \-\ RO",
"55493553", "Piratuba\ \-\ SC",
"55743676", "Quixabeira\ \-\ BA",
"55143108", "Bauru\ \-\ SP",
"55843234", "Natal\ \-\ RN",
"55273773", "São\ Mateus\ \-\ ES",
"55993634", "Lago\ do\ Junco\ \-\ MA",
"55193464", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55793337", "Poço\ Redondo\ \-\ SE",
"55443553", "Janiópolis\ \-\ PR",
"55623451", "Campos\ Belos\ \-\ GO",
"55313254", "Belo\ Horizonte\ \-\ MG",
"55162106", "São\ Carlos\ \-\ SP",
"55473355", "Brusque\ \-\ SC",
"55473544", "Trombudo\ Central\ \-\ SC",
"55213304", "Belford\ Roxo\ \-\ RJ",
"55333322", "Caratinga\ \-\ MG",
"55483544", "Morro\ Grande\ \-\ SC",
"55483355", "Imbituba\ \-\ SC",
"55833352", "São\ João\ do\ Tigre\ \-\ PB",
"55674001", "Campo\ Grande\ \-\ MS",
"55123431", "São\ José\ dos\ Campos\ \-\ SP",
"55753343", "Bonito\ \-\ BA",
"55514001", "Porto\ Alegre\ \-\ RS",
"55713634", "Pólo\ Petroquímico\ Camaçari\ \-\ BA",
"55684001", "Rio\ Branco\ \-\ AC",
"55643642", "Turvelândia\ \-\ GO",
"5522272", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55623277", "Aparecida\ de\ Goiânia\ \-\ GO",
"55853372", "São\ Gonçalo\ do\ Amarante\ \-\ CE",
"55343074", "Uberaba\ \-\ MG",
"55373229", "Divinópolis\ \-\ MG",
"55173467", "Nhandeara\ \-\ SP",
"55513762", "Rio\ Grande\ do\ Sul",
"55473458", "São\ João\ do\ Itaperiú\ \-\ SC",
"55114598", "Vargem\ \-\ SP",
"55843295", "Jaçanã\ \-\ RN",
"55793113", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55543342", "Marau\ \-\ RS",
"55663328", "Planalto\ da\ Serra\ \-\ MT",
"5511419", "Barueri\ \-\ SP",
"55213890", "Rio\ de\ Janeiro\ \-\ RJ",
"55773488", "Correntina\ \-\ BA",
"55663471", "Alto\ Garças\ \-\ MT",
"55923877", "Manaus\ \-\ AM",
"55314", "Minas\ Gerais",
"55323742", "Fervedouro\ \-\ MG",
"55713533", "Salvador\ \-\ BA",
"55733621", "Dário\ Meira\ \-\ BA",
"55843271", "Macaíba\ \-\ RN",
"55743684", "Canarana\ \-\ BA",
"55553241", "Santana\ do\ Livramento\ \-\ RS",
"55113368", "São\ Paulo\ \-\ SP",
"55513552", "Lindolfo\ Collor\ \-\ RS",
"5511354", "São\ Paulo\ \-\ SP",
"55143269", "Lençóis\ Paulista\ \-\ SP",
"55493238", "Palmeira\ \-\ SC",
"55114878", "Barueri\ \-\ SP",
"55693446", "Primavera\ de\ Rondônia\ \-\ RO",
"55473643", "Mafra\ \-\ SC",
"55663495", "Primavera\ do\ Leste\ \-\ MT",
"55483643", "Imaruí\ \-\ SC",
"55313459", "Minas\ Gerais",
"55312557", "Contagem\ \-\ MG",
"55893439", "Marcolândia\ \-\ PI",
"55813030", "Paulista\ \-\ PE",
"55833286", "Caaporã\ \-\ PB",
"55443654", "Brasilândia\ do\ Sul\ \-\ PR",
"55114461", "Santo\ André\ \-\ SP",
"55343427", "Planura\ \-\ MG",
"55883548", "Altaneira\ \-\ CE",
"55823312", "Maceió\ \-\ AL",
"55353284", "Serrania\ \-\ MG",
"55824004", "Maceió\ \-\ AL",
"55983384", "Presidente\ Sarney\ \-\ MA",
"55114528", "Cabreúva\ \-\ SP",
"55843225", "Genipabu\ \-\ RN",
"55953553", "Cantá\ \-\ RR",
"55242484", "Miguel\ Pereira\ \-\ RJ",
"55112811", "Salto\ \-\ SP",
"55773687", "Canápolis\ \-\ BA",
"55113578", "São\ Paulo\ \-\ SP",
"55213820", "Rio\ de\ Janeiro\ \-\ RJ",
"5511412", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55483657", "São\ Ludgero\ \-\ SC",
"55623099", "Anápolis\ \-\ GO",
"55373424", "Córrego\ Danta\ \-\ MG",
"55442102", "Maringá\ \-\ PR",
"55743635", "Tapiramutá\ \-\ BA",
"55353722", "Poços\ de\ Caldas\ \-\ MG",
"55483721", "Florianópolis\ \-\ SC",
"55513618", "Barão\ \-\ RS",
"55212868", "Rio\ de\ Janeiro\ \-\ RJ",
"55713625", "Dias\ d\'Ávila\ \-\ BA",
"55893443", "Santana\ do\ Piauí\ \-\ PI",
"55983394", "Carutapera\ \-\ MA",
"55553522", "Três\ Passos\ \-\ RS",
"55543045", "Passo\ Fundo\ \-\ RS",
"55273347", "Vitória\ \-\ ES",
"55793635", "Lagarto\ \-\ SE",
"55353294", "Alterosa\ \-\ MG",
"55683302", "Rio\ Branco\ \-\ AC",
"55492102", "Lages\ \-\ SC",
"55863214", "Teresina\ \-\ PI",
"55613415", "Brasília\ \-\ DF",
"55623089", "Goiânia\ \-\ GO",
"55453258", "Ramilândia\ \-\ PR",
"55634007", "Palmas\ \-\ TO",
"55153267", "Capela\ do\ Alto\ \-\ SP",
"55463563", "Santo\ Antônio\ do\ Sudoeste\ \-\ PR",
"55483131", "Florianópolis\ \-\ SC",
"55513264", "Rio\ Grande\ do\ Sul",
"55443238", "Doutor\ Camargo\ \-\ PR",
"55313437", "Minas\ Gerais",
"55993533", "Buritirana\ \-\ MA",
"55213311", "Macaé\ \-\ RJ",
"55333025", "Governador\ Valadares\ \-\ MG",
"55483052", "Tubarão\ \-\ SC",
"55713671", "Camaçari\ \-\ BA",
"55893457", "Jaicós\ \-\ PI",
"55473052", "Indaial\ \-\ SC",
"55843439", "Bodó\ \-\ RN",
"55493654", "São\ Bernardino\ \-\ SC",
"55323449", "Leopoldina\ \-\ MG",
"55123682", "Taubaté\ \-\ SP",
"55493329", "Chapecó\ \-\ SC",
"55413973", "Rio\ Branco\ do\ Sul\ \-\ PR",
"5516336", "São\ Carlos\ \-\ SP",
"55913694", "Anapu\ \-\ PA",
"55833296", "Baía\ da\ Traição\ \-\ PB",
"55123426", "Taubaté\ \-\ SP",
"55673016", "Dourados\ \-\ MS",
"55313752", "Catas\ Altas\ da\ Noruega\ \-\ MG",
"55833479", "Cacimba\ de\ Areia\ \-\ PB",
"55433661", "Alvorada\ do\ Sul\ \-\ PR",
"55123411", "Taubaté\ \-\ SP",
"55673021", "Dourados\ \-\ MS",
"55193454", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55112683", "São\ Paulo\ \-\ SP",
"55493563", "Caçador\ \-\ SC",
"55333266", "Quatituba\ \-\ MG",
"55613299", "Brasília\ \-\ DF",
"55743641", "Irecê\ \-\ BA",
"55114138", "Taboão\ da\ Serra\ \-\ SP",
"55633692", "Dianópolis\ \-\ TO",
"55913829", "Tomé\-Açú\ \-\ PA",
"55353473", "Santa\ Rita\ do\ Sapucaí\ \-\ MG",
"55823251", "Matriz\ de\ Camaragibe\ \-\ AL",
"55693434", "Santa\ Luzia\ D\'Oeste\ \-\ RO",
"55484106", "Florianópolis\ \-\ SC",
"55813522", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55863271", "Pedro\ II\ \-\ PI",
"55353241", "São\ Gonçalo\ do\ Sapucaí\ \-\ MG",
"55483242", "Palhoça\ \-\ SC",
"55313552", "Ouro\ Preto\ \-\ MG",
"55853302", "Apuiarés\ \-\ CE",
"55473242", "Pomerode\ \-\ SC",
"55173122", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55893532", "Pajeú\ do\ Piauí\ \-\ PI",
"55513075", "Canoas\ \-\ RS",
"55733539", "Itagi\ \-\ BA",
"55693485", "Espigão\ D\'Oeste\ \-\ RO",
"55423028", "Ponta\ Grossa\ \-\ PR",
"55333014", "Governador\ Valadares\ \-\ MG",
"55514", "Rio\ Grande\ do\ Sul",
"5549322", "Lages\ \-\ SC",
"55323275", "Santana\ do\ Deserto\ \-\ MG",
"55173842", "Indiaporã\ \-\ SP",
"55913723", "Marapanim\ \-\ PA",
"55222652", "Saquarema\ \-\ RJ",
"55183842", "Junqueirópolis\ \-\ SP",
"55643495", "Goiatuba\ \-\ GO",
"55873838", "Afogados\ da\ Ingazeira\ \-\ PE",
"55663401", "Barra\ do\ Garças\ \-\ MT",
"55513459", "Esteio\ \-\ RS",
"55833423", "Patos\ \-\ PB",
"55863122", "Teresina\ \-\ PI",
"55413665", "Pinhais\ \-\ PR",
"5544322", "Maringá\ \-\ PR",
"55533025", "Pelotas\ \-\ RS",
"55673437", "Ponta\ Porã\ \-\ MS",
"55513437", "Rio\ Grande\ do\ Sul",
"55623528", "Caturaí\ \-\ GO",
"55173271", "Neves\ Paulista\ \-\ SP",
"55212642", "Teresópolis\ \-\ RJ",
"55183271", "Presidente\ Venceslau\ \-\ SP",
"55163838", "Ituverava\ \-\ SP",
"55513752", "Jacarezinho\ \-\ RS",
"55813473", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"5521340", "Rio\ de\ Janeiro\ \-\ RJ",
"55153388", "Sorocaba\ \-\ SP",
"55474141", "Itajaí\ \-\ SC",
"55484141", "Florianópolis\ \-\ SC",
"55843532", "Lajes\ \-\ RN",
"55532123", "Pelotas\ \-\ RS",
"55114099", "Diadema\ \-\ SP",
"55213252", "Rio\ de\ Janeiro\ \-\ RJ",
"55112715", "Itu\ \-\ SP",
"55993614", "Itaipava\ do\ Grajaú\ \-\ MA",
"55513270", "Rio\ Grande\ do\ Sul",
"55483521", "Araranguá\ \-\ SC",
"55983012", "São\ Luís\ \-\ MA",
"55823035", "Maceió\ \-\ AL",
"55353522", "Passos\ \-\ MG",
"55473521", "Rio\ do\ Sul\ \-\ SC",
"55913606", "Bagre\ \-\ PA",
"55224141", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55633426", "São\ Sebastião\ do\ Tocantins\ \-\ TO",
"55243381", "Resende\ \-\ RJ",
"55643434", "Cachoeira\ Dourada\ \-\ GO",
"55473365", "Camboriú\ \-\ SC",
"55313264", "Minas\ Gerais",
"55132105", "Santos\ \-\ SP",
"55833362", "Areia\ \-\ PB",
"55623878", "Goiânia\ \-\ GO",
"55733543", "Itaquara\ \-\ BA",
"55143454", "Marília\ \-\ SP",
"55653548", "Lucas\ do\ Rio\ Verde\ \-\ MT",
"55443563", "Farol\ \-\ PR",
"55633474", "Araguatins\ \-\ TO",
"55623461", "Pires\ do\ Rio\ \-\ GO",
"55112524", "São\ Paulo\ \-\ SP",
"55793641", "Riachão\ do\ Dantas\ \-\ SE",
"55543031", "Canela\ \-\ RS",
"55883400", "Limoeiro\ do\ Norte\ \-\ CE",
"55543902", "Passo\ Fundo\ \-\ RS",
"55733616", "Itabuna\ \-\ BA",
"55183658", "Clementina\ \-\ SP",
"5522252", "Nova\ Friburgo\ \-\ RJ",
"55653259", "Vila\ Bela\ da\ Santíssima\ Trindade\ \-\ MT",
"55513372", "Rio\ Grande\ do\ Sul",
"5511471", "São\ Roque\ \-\ SP",
"55613435", "Brasília\ \-\ DF",
"55623598", "Aparecida\ de\ Goiânia\ \-\ GO",
"55213916", "Rio\ de\ Janeiro\ \-\ RJ",
"55913803", "Bonito\ \-\ PA",
"55112896", "Santo\ André\ \-\ SP",
"55273422", "Cariacica\ \-\ ES",
"55833483", "Olho\ d\'Água\ \-\ PB",
"55343265", "Cachoeira\ Dourada\ \-\ MG",
"55343972", "Uberaba\ \-\ MG",
"55793615", "Simão\ Dias\ \-\ SE",
"55713183", "Salvador\ \-\ BA",
"55513638", "Salvador\ do\ Sul\ \-\ RS",
"55533256", "Bojuru\ \-\ RS",
"55192106", "Piracicaba\ \-\ SP",
"55114029", "Salto\ \-\ SP",
"55273139", "Vila\ Velha\ \-\ ES",
"55913783", "Breves\ \-\ PA",
"55123978", "Jambeiro\ \-\ SP",
"55863285", "Elesbão\ Veloso\ \-\ PI",
"55163958", "Taquaral\ \-\ SP",
"5512394", "São\ José\ dos\ Campos\ \-\ SP",
"55112623", "São\ Paulo\ \-\ SP",
"55483591", "Jacinto\ Machado\ \-\ SC",
"55443664", "Alto\ Paraíso\ \-\ PR",
"55373273", "Onça\ de\ Pitangui\ \-\ MG",
"55513036", "Novo\ Hamburgo\ \-\ RS",
"55553224", "Silveira\ Martins\ \-\ RS",
"55173295", "Monte\ Aprazível\ \-\ SP",
"55613338", "Brasília\ \-\ DF",
"55423422", "Irati\ \-\ PR",
"55713601", "Candeias\ \-\ BA",
"55693471", "Presidente\ Médici\ \-\ RO",
"55423631", "Guarapuava\ \-\ PR",
"55673562", "Chapadão\ do\ Sul\ \-\ MS",
"55513562", "Portão\ \-\ RS",
"55553276", "São\ Pedro\ do\ Sul\ \-\ RS",
"55993646", "Lima\ Campos\ \-\ MA",
"55323281", "Lima\ Duarte\ \-\ MG",
"55443218", "Maringá\ \-\ PR",
"55112594", "São\ Paulo\ \-\ SP",
"55843246", "Pipa\ \-\ RN",
"5564392", "Itumbiara\ \-\ GO",
"55844102", "Natal\ \-\ RN",
"55813010", "Paulista\ \-\ PE",
"55693239", "Campo\ Novo\ de\ Rondônia\ \-\ RO",
"55115031", "São\ Paulo\ \-\ SP",
"55313762", "Conselheiro\ Lafaiete\ \-\ MG",
"55243321", "Resende\ \-\ RJ",
"55483536", "Timbé\ do\ Sul\ \-\ SC",
"55823332", "Maceió\ \-\ AL",
"55473536", "Petrolândia\ \-\ SC",
"55173512", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55633431", "Angico\ \-\ TO",
"55183285", "Caiabu\ \-\ SP",
"55473340", "Blumenau\ \-\ SC",
"55463547", "Ampére\ \-\ PR",
"55993601", "Feira\ Nova\ do\ Maranhão\ \-\ MA",
"55863295", "São\ Félix\ do\ Piauí\ \-\ PI",
"55153243", "Votorantim\ \-\ SP",
"55893467", "Lagoa\ do\ Sítio\ \-\ PI",
"55483062", "Florianópolis\ \-\ SC",
"55473062", "Balneário\ Camboriú\ \-\ SC",
"55553792", "Pinheirinho\ do\ Vale\ \-\ RS",
"55114808", "Jundiaí\ \-\ SP",
"55713646", "Lauro\ de\ Freitas\ \-\ BA",
"55833065", "Campina\ Grande\ \-\ PB",
"55493664", "Maravilha\ \-\ SC",
"55193818", "Mogi\-Guaçu\ \-\ SP",
"55323291", "Santa\ Rita\ de\ Jacutinga\ \-\ MG",
"55312103", "Belo\ Horizonte\ \-\ MG",
"55643471", "Pontalina\ \-\ GO",
"55423573", "Porto\ Vitória\ \-\ PR",
"55153257", "Porangaba\ \-\ SP",
"55453268", "Santa\ Helena\ \-\ PR",
"55423907", "Irati\ \-\ PR",
"55463553", "Espigão\ Alto\ do\ Iguaçu\ \-\ PR",
"55112535", "São\ Paulo\ \-\ SP",
"55623588", "Aparecida\ de\ Goiânia\ \-\ GO",
"55673254", "Sonora\ \-\ MS",
"55433527", "Jacarezinho\ \-\ PR",
"55933589", "Santarém\ \-\ PA",
"55142106", "Bauru\ \-\ SP",
"55733605", "Itabatan\ \-\ BA",
"5511310", "São\ Paulo\ \-\ SP",
"55112831", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55273729", "São\ Roque\ do\ Canaã\ \-\ ES",
"55833493", "Boa\ Ventura\ \-\ PB",
"55112886", "São\ Paulo\ \-\ SP",
"55863297", "Agricolândia\ \-\ PI",
"55333293", "São\ José\ da\ Safira\ \-\ MG",
"55463545", "Nova\ Prata\ do\ Iguaçu\ \-\ PR",
"55893578", "Gilbués\ \-\ PI",
"55433571", "Siqueira\ Campos\ \-\ PR",
"55163241", "Monte\ Alto\ \-\ SP",
"55183287", "Campinal\ \-\ SP",
"55513476", "Canoas\ \-\ RS",
"55673476", "Itaquiraí\ \-\ MS",
"5511592", "São\ Paulo\ \-\ SP",
"55773614", "Barreiras\ \-\ BA",
"55174003", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55443531", "Peabiru\ \-\ PR",
"55273326", "Vila\ Velha\ \-\ ES",
"55873872", "Araripina\ \-\ PE",
"55453346", "São\ João\ d\'Oeste\ \-\ PR",
"55543398", "Charrua\ \-\ RS",
"55983369", "Santo\ Amaro\ do\ Maranhão\ \-\ MA",
"55513424", "Rio\ Grande\ do\ Sul",
"55893465", "Valença\ do\ Piauí\ \-\ PI",
"55913556", "Senador\ José\ Porfírio\ \-\ PA",
"55123014", "Jacareí\ \-\ SP",
"55143284", "Pederneiras\ \-\ SP",
"55753062", "Feira\ de\ Santana\ \-\ BA",
"55433141", "Santo\ Antônio\ da\ Platina\ \-\ PR",
"55213626", "Rio\ de\ Janeiro\ \-\ RJ",
"55113122", "São\ Paulo\ \-\ SP",
"55283155", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55243377", "Angra\ dos\ Reis\ \-\ RJ",
"5554331", "Passo\ Fundo\ \-\ RS",
"55433525", "Jacarezinho\ \-\ PR",
"55643698", "Nova\ Aurora\ \-\ GO",
"5553330", "Pelotas\ \-\ RS",
"55943314", "Serra\ Pelada\ \-\ PA",
"55113439", "Santo\ André\ \-\ SP",
"55193030", "Vinhedo\ \-\ SP",
"55153255", "Angatuba\ \-\ SP",
"55883522", "Jaguaribe\ \-\ CE",
"55213674", "Niterói\ \-\ RJ",
"55333411", "Peçanha\ \-\ MG",
"55613459", "Samambaia\ Sul\ \-\ DF",
"55323728", "Muriaé\ \-\ MG",
"55913854", "Maracanã\ \-\ PA",
"55653235", "Figueirópolis\ D\'Oeste\ \-\ MT",
"55743669", "Várzea\ da\ Roça\ \-\ BA",
"55913617", "Cotijuba\ \-\ PA",
"55143722", "Tupã\ \-\ SP",
"55753340", "Marcionílio\ Souza\ \-\ BA",
"55182101", "Presidente\ Prudente\ \-\ SP",
"55793341", "Aquidabã\ \-\ SE",
"55643688", "Jaupaci\ \-\ GO",
"55413575", "Curitiba\ \-\ PR",
"55813217", "Recife\ \-\ PE",
"55963325", "Cutias\ \-\ AP",
"55633025", "Palmas\ \-\ TO",
"55813748", "Sairé\ \-\ PE",
"55623449", "Guarani\ de\ Goiás\ \-\ GO",
"55162137", "Ribeirão\ Preto\ \-\ SP",
"55843368", "Triunfo\ Potiguar\ \-\ RN",
"55693427", "Nova\ Colina\ \-\ RO",
"5565366", "Cuiabá\ \-\ MT",
"55143294", "Iacanga\ \-\ SP",
"55823481", "Arapiraca\ \-\ AL",
"55213809", "Rio\ de\ Janeiro\ \-\ RJ",
"55313318", "Belo\ Horizonte\ \-\ MG",
"55423252", "Palmeira\ \-\ PR",
"55434104", "Apucarana\ \-\ PR",
"55813269", "Recife\ \-\ PE",
"55323003", "Juiz\ de\ Fora\ \-\ MG",
"55213492", "Niterói\ \-\ RJ",
"55343267", "Centralina\ \-\ MG",
"55413468", "Alexandra\ \-\ PR",
"55213789", "Mangaratiba\ \-\ RJ",
"55373016", "Divinópolis\ \-\ MG",
"55273770", "Colatina\ \-\ ES",
"55543434", "Silva\ Jardim\ \-\ RS",
"55833538", "São\ José\ da\ Lagoa\ Tapada\ \-\ PB",
"55493531", "Videira\ \-\ SC",
"55773442", "Buritirama\ \-\ BA",
"55913110", "Belém\ \-\ PA",
"55513289", "Rio\ Grande\ do\ Sul",
"55453301", "Cascavel\ \-\ PR",
"55673289", "Rochedo\ \-\ MS",
"55463272", "Pato\ Branco\ \-\ PR",
"55753667", "Nossa\ Senhora\ da\ Ajuda\ \-\ BA",
"55113443", "São\ Paulo\ \-\ SP",
"55114275", "Mairiporã\ \-\ SP",
"55543388", "Bento\ Gonçalves\ \-\ RS",
"55553548", "Cândido\ Godói\ \-\ RS",
"55643086", "Itumbiara\ \-\ GO",
"55963697", "Chaves\ \-\ PA",
"55443673", "Ivaté\ \-\ PR",
"55943301", "Maracajá\ \-\ PA",
"55513435", "Rio\ Grande\ do\ Sul",
"55673435", "Antônio\ João\ \-\ MS",
"55883582", "Iguatu\ \-\ CE",
"55273350", "Vila\ Velha\ \-\ ES",
"55494101", "Chapecó\ \-\ SC",
"55553259", "Mata\ \-\ RS",
"55143224", "Bauru\ \-\ SP",
"55193792", "Limeira\ \-\ SP",
"55533027", "Pelotas\ \-\ RS",
"55413111", "Curitiba\ \-\ PR",
"55413667", "Pinhais\ \-\ PR",
"55343414", "Contagem\ \-\ MG",
"55923194", "Manaus\ \-\ AM",
"55213139", "Rio\ de\ Janeiro\ \-\ RJ",
"551122", "São\ Paulo\ \-\ SP",
"55313441", "Minas\ Gerais",
"55143276", "Bauru\ \-\ SP",
"55613081", "Brasília\ \-\ DF",
"55693026", "Porto\ Velho\ \-\ RO",
"55633463", "Aragominas\ \-\ TO",
"55893440", "Ipiranga\ do\ Piauí\ \-\ PI",
"5533", "Minas\ Gerais",
"55163010", "Araraquara\ \-\ SP",
"55623952", "Aparecida\ de\ Goiânia\ \-\ GO",
"55653224", "Cáceres\ \-\ MT",
"55754141", "Feira\ de\ Santana\ \-\ BA",
"55434062", "Londrina\ \-\ PR",
"55542991", "Caxias\ do\ Sul\ \-\ RS",
"55115063", "São\ Paulo\ \-\ SP",
"55112717", "São\ Paulo\ \-\ SP",
"55473319", "Navegantes\ \-\ SC",
"55443526", "Formosa\ do\ Oeste\ \-\ PR",
"55673484", "Caarapó\ \-\ MS",
"55513484", "Gravataí\ \-\ RS",
"55273331", "Vitória\ \-\ ES",
"55513672", "Tapes\ \-\ RS",
"55433534", "Santo\ Antônio\ da\ Platina\ \-\ PR",
"55993551", "São\ João\ dos\ Patos\ \-\ MA",
"55673672", "Rio\ Brilhante\ \-\ MS",
"55473903", "Joinville\ \-\ SC",
"55483903", "Araranguá\ \-\ SC",
"55613562", "Taguatinga\ \-\ DF",
"55473367", "Balneário\ Camboriú\ \-\ SC",
"55463560", "Pinhal\ de\ São\ Bento\ \-\ PR",
"55423916", "Tibagi\ \-\ PR",
"55833253", "Bayeux\ \-\ PB",
"55413581", "Curitiba\ \-\ PR",
"55493526", "Jaborá\ \-\ SC",
"55113512", "São\ Paulo\ \-\ SP",
"55513229", "Rio\ Grande\ do\ Sul",
"55192117", "Campinas\ \-\ SP",
"55353464", "Inconfidentes\ \-\ MG",
"55883112", "Sobral\ \-\ CE",
"55222772", "Macaé\ \-\ RJ",
"55493574", "Macieira\ \-\ SC",
"55543471", "Dois\ Lajeados\ \-\ RS",
"55213823", "Rio\ de\ Janeiro\ \-\ RJ",
"55382103", "Montes\ Claros\ \-\ MG",
"55753242", "Amélia\ Rodrigues\ \-\ BA",
"5561202", "Brasília\ \-\ DF",
"55773646", "Ipupiara\ \-\ BA",
"55423663", "Palmeirinha\ \-\ PR",
"55273754", "Montanha\ \-\ ES",
"55513494", "Itapuã\ \-\ RS",
"5598325", "São\ Luís\ \-\ MA",
"55323451", "Astolfo\ Dutra\ \-\ MG",
"55193499", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55113192", "São\ Paulo\ \-\ SP",
"55513077", "Canoas\ \-\ RS",
"5521301", "Rio\ de\ Janeiro\ \-\ RJ",
"55114812", "Campo\ Limpo\ Paulista\ \-\ SP",
"55823421", "Palmeira\ dos\ Índios\ \-\ AL",
"55133291", "Santos\ \-\ SP",
"55633322", "Palmas\ \-\ TO",
"55493364", "Serra\ Alta\ \-\ SC",
"55193802", "Holambra\ \-\ SP",
"55643628", "Ouroana\ \-\ GO",
"55153026", "Sorocaba\ \-\ SP",
"55444101", "Sarandi\ \-\ PR",
"55833466", "Assunção\ \-\ PB",
"55553237", "São\ Gabriel\ \-\ RS",
"55923184", "Manaus\ \-\ AM",
"55493202", "Joaçaba\ \-\ SC",
"55454100", "Cascavel\ \-\ PR",
"55643497", "Santo\ Antônio\ do\ Rio\ Verde\ \-\ GO",
"55823632", "Olivença\ \-\ AL",
"55943346", "Parauapebas\ \-\ PA",
"55813033", "Recife\ \-\ PE",
"55323277", "Chácara\ \-\ MG",
"55143489", "Iacri\ \-\ SP",
"55743659", "Várzea\ Nova\ \-\ BA",
"55283554", "Muqui\ \-\ ES",
"55273345", "Vitória\ \-\ ES",
"5521261", "Niterói\ \-\ RJ",
"5551332", "Rio\ Grande\ do\ Sul",
"55143112", "Botucatu\ \-\ SP",
"55433351", "Londrina\ \-\ PR",
"55313338", "Nova\ Lima\ \-\ MG",
"5553", "Rio\ Grande\ do\ Sul",
"55712223", "Salvador\ \-\ BA",
"55713627", "Camaçari\ \-\ BA",
"55383081", "Montes\ Claros\ \-\ MG",
"55773695", "Tanque\ Novo\ \-\ BA",
"55733540", "Presidente\ Tancredo\ Neves\ \-\ BA",
"55383562", "Brasilândia\ de\ Minas\ \-\ MG",
"55463526", "Itapejara\ D\'Oeste\ \-\ PR",
"55693342", "Cerejeiras\ \-\ RO",
"55553033", "Santa\ Maria\ \-\ RS",
"55833198", "João\ Pessoa\ \-\ PB",
"55433176", "Rolândia\ \-\ PR",
"55983359", "São\ João\ Batista\ \-\ MA",
"55183708", "Primeira\ Aliança\ \-\ SP",
"55613044", "Taguatinga\ \-\ DF",
"55893455", "Caldeirão\ Grande\ do\ Piauí\ \-\ PI",
"55313435", "Belo\ Horizonte\ \-\ MG",
"55114205", "Itapevi\ \-\ SP",
"55873792", "Terezinha\ \-\ PE",
"55913032", "Ananindeua\ \-\ PA",
"55513441", "Cachoeirinha\ \-\ RS",
"55673441", "Nova\ Andradina\ \-\ MS",
"55213773", "Nova\ Iguaçu\ \-\ RJ",
"55753639", "Santa\ Teresinha\ \-\ BA",
"55433546", "Ibaiti\ \-\ PR",
"55193582", "Santa\ Rita\ do\ Passa\ Quatro\ \-\ SP",
"55423554", "Cruz\ Machado\ \-\ PR",
"55153342", "Sorocaba\ \-\ SP",
"55943385", "Vila\ Santa\ Fé\ \-\ PA",
"55383254", "Itacambira\ \-\ MG",
"55123034", "Caraguatatuba\ \-\ SP",
"55343243", "Amanhece\ \-\ MG",
"55853338", "Beberibe\ \-\ CE",
"55513406", "Rio\ Grande\ do\ Sul",
"55214133", "Magé\ \-\ RJ",
"55143582", "Uru\ \-\ SP",
"55983337", "Alcântara\ \-\ MA",
"55193592", "Santa\ Rita\ do\ Passa\ Quatro\ \-\ SP",
"55343425", "Frutal\ \-\ MG",
"55483298", "Florianópolis\ \-\ SC",
"55242437", "Ipiabas\ \-\ RJ",
"55212688", "Itaguaí\ \-\ RJ",
"55614001", "Brasília\ \-\ DF",
"55273262", "Guarapari\ \-\ ES",
"55212152", "Teresópolis\ \-\ RJ",
"55923571", "Urucará\ \-\ AM",
"55663497", "Primavera\ do\ Leste\ \-\ MT",
"55353237", "São\ Thomé\ das\ Letras\ \-\ MG",
"55163489", "Serrana\ \-\ SP",
"55873782", "Saloá\ \-\ PE",
"55923361", "Manacapuru\ \-\ AM",
"55913637", "Melgaço\ \-\ PA",
"55343257", "Uberlândia\ \-\ MG",
"55733677", "Coroa\ Vermelha\ \-\ BA",
"55843227", "São\ Gonçalo\ do\ Amarante\ \-\ RN",
"55753643", "Valença\ \-\ BA",
"55313229", "Minas\ Gerais",
"55352106", "Varginha\ \-\ MG",
"55333431", "Santa\ Maria\ do\ Suaçuí\ \-\ MG",
"55993627", "Bacabal\ \-\ MA",
"55163403", "Franca\ \-\ SP",
"55743637", "Gentio\ do\ Ouro\ \-\ BA",
"55663026", "Rondonópolis\ \-\ MT",
"55343328", "Campo\ Florido\ \-\ MG",
"55843358", "Rafael\ Fernandes\ \-\ RN",
"55193112", "Campinas\ \-\ SP",
"55473655", "Major\ Vieira\ \-\ SC",
"55213604", "Niterói\ \-\ RJ",
"55483655", "Sangão\ \-\ SC",
"55333622", "Nanuque\ \-\ MG",
"55123862", "São\ Sebastião\ \-\ SP",
"55423304", "Guarapuava\ \-\ PR",
"55114000", "Arujá\ \-\ SP",
"55123322", "São\ José\ dos\ Campos\ \-\ SP",
"55324009", "Juiz\ de\ Fora\ \-\ MG",
"55183368", "Lutécia\ \-\ SP",
"55613552", "Núcleo\ Bandeirante\ \-\ DF",
"55892101", "Picos\ \-\ PI",
"55483357", "São\ José\ \-\ SC",
"55653241", "Mirassol\ D\'Oeste\ \-\ MT",
"55213589", "Mesquita\ \-\ RJ",
"55463550", "Renascença\ \-\ PR",
"55473357", "Ibirama\ \-\ SC",
"55633014", "Palmas\ \-\ TO",
"55333087", "Teófilo\ Otoni\ \-\ MG",
"55213660", "Magé\ \-\ RJ",
"55993561", "Governador\ Luiz\ Rocha\ \-\ MA",
"55963314", "Santana\ \-\ AP",
"55813548", "Itapissuma\ \-\ PE",
"55434052", "Londrina\ \-\ PR",
"55983472", "Brejo\ \-\ MA",
"55143473", "Alvinlândia\ \-\ SP",
"55543401", "Farroupilha\ \-\ RS",
"55213977", "Rio\ de\ Janeiro\ \-\ RJ",
"55473228", "Balneário\ Camboriú\ \-\ SC",
"55633453", "Wanderlândia\ \-\ TO",
"55413643", "Araucária\ \-\ PR",
"55663427", "Rondonópolis\ \-\ MT",
"55192137", "Campinas\ \-\ SP",
"55883429", "Alto\ Santo\ \-\ CE",
"55163722", "Franca\ \-\ SP",
"55833490", "Bonito\ de\ Santa\ Fé\ \-\ PB",
"55443545", "Yolanda\ \-\ PR",
"55553748", "Erval\ Seco\ \-\ RS",
"55843297", "Japi\ \-\ RN",
"55173465", "Fernandópolis\ \-\ SP",
"55473343", "Ilhota\ \-\ SC",
"55114449", "Franco\ da\ Rocha\ \-\ SP",
"55483343", "São\ José\ \-\ SC",
"55193872", "Cosmópolis\ \-\ SP",
"55533293", "Rio\ Grande\ \-\ RS",
"55813454", "Recife\ \-\ PE",
"55413721", "Paranaguá\ \-\ PR",
"55313424", "Belo\ Horizonte\ \-\ MG",
"55633447", "São\ Miguel\ do\ Tocantins\ \-\ TO",
"55413657", "Almirante\ Tamandaré\ \-\ PR",
"55753544", "Ubaíra\ \-\ BA",
"55443629", "Cianorte\ \-\ PR",
"55553269", "São\ João\ do\ Polêsine\ \-\ RS",
"55313289", "Minas\ Gerais",
"55533283", "Pelotas\ \-\ RS",
"55613302", "Sobradinho\ \-\ DF",
"55122123", "Taubaté\ \-\ SP",
"55913756", "Moju\ \-\ PA",
"55413639", "Lapa\ \-\ PR",
"55773625", "Santa\ Rita\ de\ Cássia\ \-\ BA",
"55943428", "Rio\ Maria\ \-\ PA",
"55333426", "Dores\ de\ Guanhães\ \-\ MG",
"55833456", "Pedra\ Branca\ \-\ PB",
"55843287", "Lagoa\ D\'Anta\ \-\ RN",
"55443272", "Fênix\ \-\ PR",
"55652137", "Várzea\ Grande\ \-\ MT",
"55213119", "São\ Gonçalo\ \-\ RJ",
"55613618", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55493545", "Abdon\ Batista\ \-\ SC",
"55413131", "Curitiba\ \-\ PR",
"55493354", "Marema\ \-\ SC",
"55613264", "Brasília\ \-\ DF",
"55663902", "Rondonópolis\ \-\ MT",
"55423311", "Ponta\ Grossa\ \-\ PR",
"55534007", "Pelotas\ \-\ RS",
"55133216", "Santos\ \-\ SP",
"55323461", "Angustura\ \-\ MG",
"55123025", "Taubaté\ \-\ SP",
"55433232", "Sertanópolis\ \-\ PR",
"55213611", "São\ Gonçalo\ \-\ RJ",
"55513415", "Canoas\ \-\ RS",
"55213167", "Duque\ de\ Caxias\ \-\ RJ",
"55423653", "Rio\ Bonito\ do\ Iguaçu\ \-\ PR",
"55273764", "Pedro\ Canário\ \-\ ES",
"55353013", "Lavras\ \-\ MG",
"55983523", "Imperatriz\ \-\ MA",
"55773671", "Sítio\ do\ Mato\ \-\ BA",
"55143522", "Lins\ \-\ SP",
"55193473", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55413150", "Fazenda\ Rio\ Grande\ \-\ PR",
"55923534", "Nhamundá\ \-\ AM",
"55823558", "Penedo\ \-\ AL",
"55273311", "Vila\ Velha\ \-\ ES",
"55115642", "São\ Paulo\ \-\ SP",
"55543446", "Cotiporã\ \-\ RS",
"55833480", "Igaracy\ \-\ PB",
"55513602", "Caraá\ \-\ RS",
"55353454", "Espírito\ Santo\ do\ Dourado\ \-\ MG",
"55543267", "Vila\ Seca\ \-\ RS",
"55473339", "Blumenau\ \-\ SC",
"55242254", "Comendador\ Levy\ Gasparian\ \-\ RJ",
"55833263", "Lagoa\ de\ Dentro\ \-\ PB",
"55623542", "Goiânia\ \-\ GO",
"55423250", "Abapã\ \-\ PR",
"55434004", "Londrina\ \-\ PR",
"55163995", "Ribeirão\ Preto\ \-\ SP",
"55653376", "Nobres\ \-\ MT",
"55443016", "Campo\ Mourão\ \-\ PR",
"55173819", "Poloni\ \-\ SP",
"55493552", "Lacerdópolis\ \-\ SC",
"55483267", "Nova\ Trento\ \-\ SC",
"55664141", "Rondonópolis\ \-\ MT",
"55543339", "Erebango\ \-\ RS",
"55173258", "Bady\ Bassitt\ \-\ SP",
"55663468", "Água\ Boa\ \-\ MT",
"55143032", "Jaú\ \-\ SP",
"55273772", "Nova\ Venécia\ \-\ ES",
"5531322", "Belo\ Horizonte\ \-\ MG",
"55793215", "Aracaju\ \-\ SE",
"55113395", "Jundiaí\ \-\ SP",
"5592364", "Manaus\ \-\ AM",
"55313373", "Belo\ Horizonte\ \-\ MG",
"55693516", "Ariquemes\ \-\ RO",
"55663575", "Peixoto\ de\ Azevedo\ \-\ MT",
"55114755", "Itaquaquecetuba\ \-\ SP",
"55613504", "Cristalina\ \-\ GO",
"55693643", "Alto\ Alegre\ dos\ Parecis\ \-\ RO",
"55313939", "Conselheiro\ Lafaiete\ \-\ MG",
"5511256", "São\ Paulo\ \-\ SP",
"55513238", "Rio\ Grande\ do\ Sul",
"55883418", "Jaguaruana\ \-\ CE",
"55473446", "Barra\ Velha\ \-\ SC",
"55673238", "Ribas\ do\ Rio\ Pardo\ \-\ MS",
"55183695", "Planalto\ \-\ SP",
"55443264", "Sarandi\ \-\ PR",
"55383673", "Guarda\-Mor\ \-\ MG",
"55143376", "Sodrélia\ \-\ SP",
"55173695", "Marinópolis\ \-\ SP",
"55383745", "Lagoa\ dos\ Patos\ \-\ MG",
"55753011", "Feira\ de\ Santana\ \-\ BA",
"55313563", "Itabirito\ \-\ MG",
"55623344", "Uruana\ \-\ GO",
"55733244", "Itagibá\ \-\ BA",
"55653901", "Cuiabá\ \-\ MT",
"55633356", "Peixe\ \-\ TO",
"55143324", "Ourinhos\ \-\ SP",
"55443302", "Maringá\ \-\ PR",
"55643639", "Perolândia\ \-\ GO",
"55994102", "Imperatriz\ \-\ MA",
"55423231", "Carambeí\ \-\ PR",
"55773440", "Piripá\ \-\ BA",
"55433312", "Arapongas\ \-\ PR",
"55653566", "Juína\ \-\ MT",
"55533517", "Pelotas\ \-\ RS",
"55212705", "Niterói\ \-\ RJ",
"55753265", "Santaluz\ \-\ BA",
"55663521", "Alta\ Floresta\ \-\ MT",
"55613272", "Brasília\ \-\ DF",
"55553359", "Cerro\ Largo\ \-\ RS",
"55843646", "Natal\ \-\ RN",
"55273250", "Coqueiral\ \-\ ES",
"55682102", "Rio\ Branco\ \-\ AC",
"55123896", "Ilhabela\ \-\ SP",
"5561219", "Brasília\ \-\ DF",
"55193324", "Campinas\ \-\ SP",
"55643657", "Bom\ Jardim\ de\ Goiás\ \-\ GO",
"55873870", "Trindade\ \-\ PE",
"55813709", "Belo\ Jardim\ \-\ PE",
"55383531", "Diamantina\ \-\ MG",
"55613629", "Valparaíso\ de\ Goiás\ \-\ GO",
"55133391", "Guarujá\ \-\ SP",
"55823278", "Tanque\ D\'Arca\ \-\ AL",
"55613354", "Brasília\ \-\ DF",
"55833347", "Gado\ Bravo\ \-\ PB",
"55714102", "Salvador\ \-\ BA",
"55163315", "Ribeirão\ Preto\ \-\ SP",
"55853373", "Acarape\ \-\ CE",
"55543343", "Sananduva\ \-\ RS",
"55163934", "Ribeirão\ Preto\ \-\ SP",
"55323691", "Juiz\ de\ Fora\ \-\ MG",
"55313107", "Sete\ Lagoas\ \-\ MG",
"55513763", "Rio\ Grande\ do\ Sul",
"55513654", "Triunfo\ \-\ RS",
"55733205", "Argolo\ \-\ BA",
"55193566", "Analândia\ \-\ SP",
"55643643", "Porteirão\ \-\ GO",
"55212667", "Nova\ Iguaçu\ \-\ RJ",
"55273296", "Aracruz\ \-\ ES",
"5521387", "Rio\ de\ Janeiro\ \-\ RJ",
"55963234", "Porto\ Grande\ \-\ AP",
"55213263", "Rio\ de\ Janeiro\ \-\ RJ",
"55623305", "São\ Francisco\ de\ Goiás\ \-\ GO",
"55863258", "Monsenhor\ Gil\ \-\ PI",
"55114911", "São\ Paulo\ \-\ SP",
"55753162", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"55113120", "São\ Paulo\ \-\ SP",
"55543357", "Camargo\ \-\ RS",
"55443552", "Boa\ Esperança\ \-\ PR",
"55183634", "Birigui\ \-\ SP",
"55173634", "Urânia\ \-\ SP",
"55833353", "Sumé\ \-\ PB",
"55973464", "Tonantins\ \-\ AM",
"55653637", "Cuiabá\ \-\ MT",
"55333323", "Ubaporanga\ \-\ MG",
"55743061", "Juazeiro\ \-\ BA",
"5533327", "Governador\ Valadares\ \-\ MG",
"55983464", "Miranda\ do\ Norte\ \-\ MA",
"55193032", "Campinas\ \-\ SP",
"55193394", "Indaiatuba\ \-\ SP",
"55183917", "Presidente\ Prudente\ \-\ SP",
"55423274", "Ventania\ \-\ PR",
"55213198", "Rio\ de\ Janeiro\ \-\ RJ",
"55442103", "Maringá\ \-\ PR",
"55773465", "Ibiassucê\ \-\ BA",
"55413060", "Fazenda\ Rio\ Grande\ \-\ PR",
"55653335", "Agrovila\ das\ Palmeiras\ \-\ MT",
"55673547", "Debrasa\ \-\ MS",
"55663581", "Castanheira\ \-\ MT",
"55513547", "Rolante\ \-\ RS",
"55133321", "Santos\ \-\ SP",
"55153544", "Ribeirão\ Grande\ \-\ SP",
"55153355", "Angatuba\ \-\ SP",
"55953552", "Bonfim\ \-\ RR",
"55123146", "Lavrinhas\ \-\ SP",
"55313837", "Barão\ de\ Cocais\ \-\ MG",
"55433015", "Rolândia\ \-\ PR",
"55663536", "Marcelândia\ \-\ MT",
"55623607", "Goiânia\ \-\ GO",
"5554321", "Caxias\ do\ Sul\ \-\ RS",
"55483642", "Gravatal\ \-\ SC",
"55983269", "São\ Luís\ \-\ MA",
"55353641", "Brasópolis\ \-\ MG",
"55473642", "Mafra\ \-\ SC",
"55444001", "Maringá\ \-\ PR",
"55374101", "Itaúna\ \-\ MG",
"55353829", "Lavras\ \-\ MG",
"55923084", "Manaus\ \-\ AM",
"55453246", "Palmitópolis\ \-\ PR",
"55143335", "Ourinhos\ \-\ SP",
"55983217", "São\ Luís\ \-\ MA",
"55323743", "Divino\ \-\ MG",
"55163669", "Cássia\ dos\ Coqueiros\ \-\ SP",
"5531328", "Belo\ Horizonte\ \-\ MG",
"55653384", "Porto\ Estrela\ \-\ MT",
"55793522", "Estância\ \-\ SE",
"55463254", "Coronel\ Domingos\ Soares\ \-\ PR",
"55133375", "Cubatão\ \-\ SP",
"55513399", "Rio\ Grande\ do\ Sul",
"55513553", "Novo\ Hamburgo\ \-\ RS",
"55163341", "Ibitinga\ \-\ SP",
"55873854", "Carnaíba\ \-\ PE",
"55412626", "Curitiba\ \-\ PR",
"55413972", "Pontal\ do\ Paraná\ \-\ PR",
"55383824", "Rio\ Pardo\ de\ Minas\ \-\ MG",
"55693544", "Nova\ Mamoré\ \-\ RO",
"55213039", "Nilópolis\ \-\ RJ",
"55163306", "São\ Carlos\ \-\ SP",
"55613603", "Luziânia\ \-\ GO",
"55313753", "Rio\ Espera\ \-\ MG",
"55883617", "Tamboril\ \-\ CE",
"55813723", "Caruaru\ \-\ PE",
"55543288", "Gramado\ \-\ RS",
"55623931", "Goiânia\ \-\ GO",
"55513389", "Rio\ Grande\ do\ Sul",
"5531329", "Minas\ Gerais",
"55883669", "Vila\ de\ Jericoacoara\ \-\ CE",
"55963271", "Mazagão\ \-\ AP",
"55113180", "São\ Paulo\ \-\ SP",
"55483053", "Tubarão\ \-\ SC",
"55123101", "Cachoeira\ Paulista\ \-\ SP",
"55223053", "Cabo\ Frio\ \-\ RJ",
"55813641", "Vicência\ \-\ PE",
"55513670", "Amaral\ Ferrador\ \-\ RS",
"55183625", "Araçatuba\ \-\ SP",
"55222564", "Trajano\ de\ Morais\ \-\ RJ",
"55613689", "Formosa\ \-\ GO",
"55843614", "Natal\ \-\ RN",
"55883556", "Catarina\ \-\ CE",
"55313859", "João\ Monlevade\ \-\ MG",
"55193384", "Campinas\ \-\ SP",
"55673919", "Três\ Lagoas\ \-\ MS",
"55463562", "Manfrinópolis\ \-\ PR",
"55383526", "Carbonita\ \-\ MG",
"55893442", "Alagoinha\ do\ Piauí\ \-\ PI",
"55483047", "São\ José\ \-\ SC",
"55473047", "Balneário\ Camboriú\ \-\ SC",
"55123609", "Taubaté\ \-\ SP",
"55319", "Minas\ Gerais",
"55843268", "Caiçara\ do\ Rio\ do\ Vento\ \-\ RN",
"55683303", "Rio\ Branco\ \-\ AC",
"55113371", "São\ Paulo\ \-\ SP",
"55993668", "Timbiras\ \-\ MA",
"55553523", "Padre\ Gonzales\ \-\ RS",
"55173843", "Ouroeste\ \-\ SP",
"55913722", "Curuçá\ \-\ PA",
"55733221", "Ilhéus\ \-\ BA",
"55222653", "Saquarema\ \-\ RJ",
"55273260", "Vila\ Velha\ \-\ ES",
"55553369", "São\ Pedro\ do\ Butiá\ \-\ RS",
"55614101", "Brasília\ \-\ DF",
"55833422", "Patos\ \-\ PB",
"55772101", "Vitória\ da\ Conquista\ \-\ BA",
"55313553", "Cachoeira\ do\ Campo\ \-\ MG",
"55623565", "Goiânia\ \-\ GO",
"55483243", "Biguaçu\ \-\ SC",
"55373511", "Divinópolis\ \-\ MG",
"55663544", "Sorriso\ \-\ MT",
"55813523", "Vitória\ de\ Santo\ Antão\ \-\ PE",
"55633366", "Miracema\ do\ Tocantins\ \-\ TO",
"55553317", "Santa\ Maria\ \-\ RS",
"55313399", "Minas\ Gerais",
"55333737", "Berilo\ \-\ MG",
"55193306", "Sumaré\ \-\ SP",
"55453285", "Subsede\ São\ Francisco\ \-\ PR",
"55185871", "Panorama\ \-\ SP",
"55443254", "Atalaia\ \-\ PR",
"55843397", "Umarizal\ \-\ RN",
"55413628", "Campo\ do\ Tenente\ \-\ PR",
"55893533", "Rio\ Grande\ do\ Piauí\ \-\ PI",
"55913284", "Ananindeua\ \-\ PA",
"55833088", "Campina\ Grande\ \-\ PB",
"55453234", "Catanduvas\ \-\ PR",
"55143556", "Cafelândia\ \-\ SP",
"55353472", "Cachoeira\ de\ Minas\ \-\ MG",
"55123185", "Lorena\ \-\ SP",
"55473471", "São\ Francisco\ do\ Sul\ \-\ SC",
"5511255", "São\ Paulo\ \-\ SP",
"55653617", "Cuiabá\ \-\ MT",
"55753698", "Santa\ Brígida\ \-\ BA",
"55623375", "Itaberaí\ \-\ GO",
"55222647", "Cabo\ Frio\ \-\ RJ",
"55813873", "Araripina\ \-\ PE",
"55183857", "São\ João\ do\ Pau\ D\'Alho\ \-\ SP",
"55643581", "Itumbiara\ \-\ GO",
"55753427", "Esplanada\ \-\ BA",
"55383726", "Santo\ Hipólito\ \-\ MG",
"55963214", "Macapá\ \-\ AP",
"55323539", "Ubá\ \-\ MG",
"55212186", "Nilópolis\ \-\ RJ",
"55163384", "Matão\ \-\ SP",
"55483257", "São\ José\ \-\ SC",
"55493562", "Pinheiro\ Preto\ \-\ SC",
"55222764", "Rio\ das\ Ostras\ \-\ RJ",
"55183268", "Nantes\ \-\ SP",
"55633524", "Porto\ Alegre\ do\ Tocantins\ \-\ TO",
"55313547", "Minas\ Gerais",
"55173268", "Onda\ Verde\ \-\ SP",
"55112682", "São\ Paulo\ \-\ SP",
"55653341", "Santo\ Antônio\ do\ Leverger\ \-\ MT",
"55893549", "Alvorada\ do\ Gurguéia\ \-\ PI",
"55713225", "Feira\ de\ Santana\ \-\ BA",
"55823527", "Craíbas\ \-\ AL",
"55833363", "Solânea\ \-\ PB",
"55733542", "Km\ Cem\ \-\ BA",
"55613526", "Brasília\ \-\ DF",
"55693581", "Machadinho\ D\'Oeste\ \-\ RO",
"55513218", "Rio\ Grande\ do\ Sul",
"55653925", "Cuiabá\ \-\ MT",
"55983454", "Anajatuba\ \-\ MA",
"55883438", "Choró\ \-\ CE",
"55353694", "Lavras\ \-\ MG",
"55513747", "Arroio\ do\ Tigre\ \-\ RS",
"55173442", "Fernandópolis\ \-\ SP",
"55753688", "Lamarão\ \-\ BA",
"55693536", "Ariquemes\ \-\ RO",
"55483239", "Florianópolis\ \-\ SC",
"55443562", "Araruna\ \-\ PR",
"55273065", "Serra\ \-\ ES",
"55543367", "Três\ Palmeiras\ \-\ RS",
"55613574", "Brasília\ \-\ DF",
"55212721", "Niterói\ \-\ RJ",
"55983013", "São\ Luís\ \-\ MA",
"55193556", "Cordeirópolis\ \-\ SP",
"55353523", "Alpinópolis\ \-\ MG",
"55313303", "Belo\ Horizonte\ \-\ MG",
"55163394", "Matão\ \-\ SP",
"55813635", "Itambé\ \-\ PE",
"55513664", "Torres\ \-\ RS",
"55519", "Rio\ Grande\ do\ Sul",
"5519342", "Piracicaba\ \-\ SP",
"55173839", "Parisi\ \-\ SP",
"55643591", "Itumbiara\ \-\ GO",
"55183839", "Jamaica\ \-\ SP",
"55924004", "Manaus\ \-\ AM",
"55543319", "Montauri\ \-\ RS",
"55453056", "Toledo\ \-\ PR",
"55813684", "São\ Benedito\ do\ Sul\ \-\ PE",
"55813472", "Recife\ \-\ PE",
"55193669", "Divinolândia\ \-\ SP",
"55923312", "Balbina\ \-\ AM",
"55513753", "Roca\ Sales\ \-\ RS",
"55913429", "Viseu\ \-\ PA",
"55612099", "Brasília\ \-\ DF",
"55613364", "Brasília\ \-\ DF",
"55493254", "Ponte\ Alta\ do\ Norte\ \-\ SC",
"55193341", "Campinas\ \-\ SP",
"55713271", "Salvador\ \-\ BA",
"55843533", "Afonso\ Bezerra\ \-\ RN",
"55112087", "Guarulhos\ \-\ SP",
"55843387", "Riacho\ de\ Santana\ \-\ RN",
"55193617", "Rio\ Claro\ \-\ SP",
"55313389", "Belo\ Horizonte\ \-\ MG",
"5551329", "Rio\ Grande\ do\ Sul",
"55114607", "Jundiaí\ \-\ SP",
"55212643", "Teresópolis\ \-\ RJ",
"55643667", "Arenópolis\ \-\ GO",
"55623945", "Goiânia\ \-\ GO",
"55753031", "Alagoinhas\ \-\ BA",
"55413031", "Araucária\ \-\ PR",
"55413902", "Paranaguá\ \-\ PR",
"55423245", "Socavão\ \-\ PR",
"55513563", "Ivoti\ \-\ RS",
"55473388", "Doutor\ Pedrinho\ \-\ SC",
"55823597", "Maceió\ \-\ AL",
"55193934", "Indaiatuba\ \-\ SP",
"55493021", "Lages\ \-\ SC",
"55183601", "Bento\ de\ Abreu\ \-\ SP",
"55353624", "Delfim\ Moreira\ \-\ MG",
"55163659", "Brodowski\ \-\ SP",
"55373272", "Maravilhas\ \-\ MG",
"55483434", "Morro\ da\ Fumaça\ \-\ SC",
"55163324", "Araraquara\ \-\ SP",
"55453271", "Sede\ Alvorada\ \-\ PR",
"55853329", "Aratuba\ \-\ CE",
"55212791", "Nilópolis\ \-\ RJ",
"55383731", "Várzea\ da\ Palma\ \-\ MG",
"55353593", "Jacuí\ \-\ MG",
"55883637", "Reriutaba\ \-\ CE",
"55112622", "São\ Paulo\ \-\ SP",
"55123845", "Ubatuba\ \-\ SP",
"55643521", "Itumbiara\ \-\ GO",
"55423423", "Irati\ \-\ PR",
"55443270", "Uniflor\ \-\ PR",
"55633535", "Marianópolis\ do\ Tocantins\ \-\ TO",
"55513600", "Rio\ Grande\ do\ Sul",
"55433477", "São\ João\ do\ Ivaí\ \-\ PR",
"55833482", "Imaculada\ \-\ PB",
"55733236", "Una\ \-\ BA",
"55623336", "Alexânia\ \-\ GO",
"55913802", "Mãe\ do\ Rio\ \-\ PA",
"55644141", "Itumbiara\ \-\ GO",
"55114408", "Cajamar\ \-\ SP",
"55733281", "Eunápolis\ \-\ BA",
"55623381", "Estrela\ do\ Norte\ \-\ GO",
"55133851", "Cananéia\ \-\ SP",
"55843634", "Ceará\-Mirim\ \-\ RN",
"55313238", "Belo\ Horizonte\ \-\ MG",
"55773455", "Caculé\ \-\ BA",
"55643575", "Itumbiara\ \-\ GO",
"55493459", "Coronel\ Martins\ \-\ SC",
"55443437", "Amaporã\ \-\ PR",
"55153521", "Itapeva\ \-\ SP",
"55273245", "Serra\ \-\ ES",
"55383504", "Paracatu\ \-\ MG",
"5568322", "Rio\ Branco\ \-\ AC",
"55433251", "Cambé\ \-\ PR",
"55873946", "Salgueiro\ \-\ PE",
"55113301", "São\ Paulo\ \-\ SP",
"55433035", "Cambé\ \-\ PR",
"55623391", "Mundo\ Novo\ \-\ GO",
"55143766", "Arandu\ \-\ SP",
"55313817", "Ponte\ Nova\ \-\ MG",
"55793276", "Pirambu\ \-\ SE",
"55733291", "Teixeira\ de\ Freitas\ \-\ BA",
"55493437", "Passos\ Maia\ \-\ SC",
"55873032", "Petrolina\ \-\ PE",
"55553402", "Uruguaiana\ \-\ RS",
"55343228", "Uberlândia\ \-\ MG",
"55813624", "Surubim\ \-\ PE",
"55833492", "Monte\ Horebe\ \-\ PB",
"55843258", "São\ Tomé\ \-\ RN",
"55613704", "Brasília\ \-\ DF",
"55114555", "Mauá\ \-\ SP",
"55883566", "Juazeiro\ do\ Norte\ \-\ CE",
"55313329", "Minas\ Gerais",
"55114164", "Carapicuíba\ \-\ SP",
"5553327", "Pelotas\ \-\ RS",
"55313869", "Congonhas\ do\ Norte\ \-\ MG",
"55463552", "Capanema\ \-\ PR",
"55163946", "Sertãozinho\ \-\ SP",
"55793224", "Aracaju\ \-\ SE",
"55413698", "Almirante\ Tamandaré\ \-\ PR",
"55813676", "Tamandaré\ \-\ PE",
"55982106", "São\ Luís\ \-\ MA",
"55843327", "Grossos\ \-\ RN",
"55222554", "Macuco\ \-\ RJ",
"55753628", "São\ Felipe\ \-\ BA",
"55533717", "Rio\ Grande\ \-\ RS",
"55643954", "Itumbiara\ \-\ GO",
"55883659", "Croatá\ \-\ CE",
"55553615", "Santa\ Margarida\ do\ Sul\ \-\ RS",
"55112279", "Guarulhos\ \-\ SP",
"55813078", "Recife\ \-\ PE",
"55413096", "São\ José\ dos\ Pinhais\ \-\ PR",
"55713285", "Salvador\ \-\ BA",
"55843695", "Lagoa\ de\ Velhos\ \-\ RN",
"55383841", "Salinas\ \-\ MG",
"55693521", "Jaru\ \-\ RO",
"55273362", "Guarapari\ \-\ ES",
"55312102", "Belo\ Horizonte\ \-\ MG",
"55533248", "Pinheiro\ Machado\ \-\ RS",
"55123961", "Jacareí\ \-\ SP",
"55933502", "Castelo\ dos\ Sonhos\ \-\ PA",
"55313763", "Conselheiro\ Lafaiete\ \-\ MG",
"55183646", "Brejo\ Alegre\ \-\ SP",
"55153242", "Votorantim\ \-\ SP",
"55373354", "Japaraíba\ \-\ MG",
"55373545", "Paineiras\ \-\ MG",
"55133305", "Guarujá\ \-\ SP",
"55173513", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55383545", "Presidente\ Kubitschek\ \-\ MG",
"55213483", "Rio\ de\ Janeiro\ \-\ RJ",
"55163472", "Araraquara\ \-\ SP",
"55873779", "Jupi\ \-\ PE",
"55643999", "Itumbiara\ \-\ GO",
"55114173", "São\ Bernardo\ do\ Campo\ \-\ SP",
"5512320", "São\ José\ dos\ Campos\ \-\ SP",
"55793548", "Santa\ Luzia\ do\ Itanhy\ \-\ SE",
"55493435", "Ponte\ Serrada\ \-\ SC",
"55353438", "Camanducaia\ \-\ MG",
"55773439", "Encruzilhada\ \-\ BA",
"55942101", "Marabá\ \-\ PA",
"55553556", "Redentora\ \-\ RS",
"55643640", "Lagoa\ Santa\ \-\ GO",
"55823534", "Jacaré\ dos\ Homens\ \-\ AL",
"55843325", "Upanema\ \-\ RN",
"55343355", "Pedrinópolis\ \-\ MG",
"55853181", "Fortaleza\ \-\ CE",
"55883523", "Crato\ \-\ CE",
"55114018", "Pinhalzinho\ \-\ SP",
"55313511", "Betim\ \-\ MG",
"55633393", "Chapada\ da\ Natividade\ \-\ TO",
"55373553", "Estrela\ do\ Indaiá\ \-\ MG",
"55833350", "Ouro\ Velho\ \-\ PB",
"55833386", "Gurjão\ \-\ PB",
"55873873", "Araripina\ \-\ PE",
"55143641", "Barra\ Bonita\ \-\ SP",
"55623432", "Goiânia\ \-\ GO",
"55713287", "Lauro\ de\ Freitas\ \-\ BA",
"55843697", "Parazinho\ \-\ RN",
"55553617", "Tiradentes\ do\ Sul\ \-\ RS",
"55493338", "Cunhataí\ \-\ SC",
"55353335", "Conceição\ do\ Rio\ Verde\ \-\ MG",
"55714003", "Salvador\ \-\ BA",
"55383547", "Serra\ Azul\ de\ Minas\ \-\ MG",
"55843428", "São\ Fernando\ \-\ RN",
"55333292", "Marilac\ \-\ MG",
"55543536", "Caxias\ do\ Sul\ \-\ RS",
"55623621", "Goiânia\ \-\ GO",
"55313726", "Santana\ dos\ Montes\ \-\ MG",
"55513760", "Colinas\ \-\ RS",
"55543340", "Vanini\ \-\ RS",
"55843371", "Itaú\ \-\ RN",
"55343846", "Douradoquara\ \-\ MG",
"55543581", "Passo\ Fundo\ \-\ RS",
"55893428", "Santa\ Rosa\ do\ Piauí\ \-\ PI",
"55113442", "São\ Paulo\ \-\ SP",
"55333724", "Divisópolis\ \-\ MG",
"55443672", "Rondon\ \-\ PR",
"55713297", "Salvador\ \-\ BA",
"55183994", "Emilianópolis\ \-\ SP",
"55423247", "Ivaí\ \-\ PR",
"55613218", "Brasília\ \-\ DF",
"55833396", "Aroeiras\ \-\ PB",
"55193641", "Vargem\ Grande\ do\ Sul\ \-\ SP",
"55773443", "Caraíbas\ \-\ BA",
"55943778", "Vila\ Residencial\ de\ Tucuruí\ \-\ PA",
"55193829", "Valinhos\ \-\ SP",
"55273253", "Serra\ \-\ ES",
"55153577", "Barra\ do\ Turvo\ \-\ SP",
"5562400", "Goiânia\ \-\ GO",
"55333515", "Água\ Boa\ \-\ MG",
"55883635", "Irauçuba\ \-\ CE",
"5511260", "São\ Paulo\ \-\ SP",
"55673574", "Inocência\ \-\ MS",
"55823891", "Viçosa\ \-\ MG",
"55732105", "Porto\ Seguro\ \-\ BA",
"55193579", "Campinas\ \-\ SP",
"55753434", "Acajutiba\ \-\ BA",
"55433475", "Jardim\ Alegre\ \-\ PR",
"55883684", "Ipaporanga\ \-\ CE",
"55112392", "São\ Paulo\ \-\ SP",
"55513711", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55114539", "Joanópolis\ \-\ SP",
"55963083", "Macapá\ \-\ AP",
"55673202", "Campo\ Grande\ \-\ MS",
"55313370", "Minas\ Gerais",
"55633383", "Cariri\ do\ Tocantins\ \-\ TO",
"55443435", "Planaltina\ do\ Paraná\ \-\ PR",
"55743548", "Pindobaçu\ \-\ BA",
"55773457", "Riacho\ de\ Santana\ \-\ BA",
"55992101", "Imperatriz\ \-\ MA",
"55543365", "Rondinha\ \-\ RS",
"55673673", "Jateí\ \-\ MS",
"55113601", "Osasco\ \-\ SP",
"55513673", "Mostardas\ \-\ RS",
"55343131", "Uberlândia\ \-\ MG",
"55743259", "Macajuba\ \-\ BA",
"55513745", "Segredo\ \-\ RS",
"55893498", "Lagoa\ do\ Barro\ do\ Piauí\ \-\ PI",
"55483086", "Palhoça\ \-\ SC",
"55323555", "Coimbra\ \-\ MG",
"55673596", "Cassilândia\ \-\ MS",
"55323344", "Bias\ Fortes\ \-\ MG",
"55653927", "Várzea\ Grande\ \-\ MT",
"55613563", "Taguatinga\ \-\ DF",
"55513596", "Novo\ Hamburgo\ \-\ RS",
"55333356", "São\ João\ do\ Oriente\ \-\ MG",
"55843334", "Serra\ do\ Mel\ \-\ RN",
"55473031", "Joinville\ \-\ SC",
"55943358", "Canaã\ dos\ Carajás\ \-\ PA",
"55483902", "Criciúma\ \-\ SC",
"55483031", "Florianópolis\ \-\ SC",
"55473902", "Jaraguá\ do\ Sul\ \-\ SC",
"55493424", "Bom\ Jesus\ \-\ SC",
"55113109", "Jundiaí\ \-\ SP",
"55193402", "Piracicaba\ \-\ SP",
"55833374", "Nova\ Floresta\ \-\ PB",
"55623636", "Goiânia\ \-\ GO",
"55843488", "Cerro\ Corá\ \-\ RN",
"55212655", "São\ João\ de\ Meriti\ \-\ RJ",
"55313731", "Congonhas\ \-\ MG",
"55115062", "São\ Paulo\ \-\ SP",
"55813637", "Aliança\ \-\ PE",
"55434063", "Londrina\ \-\ PR",
"55193899", "Monte\ Alegre\ do\ Sul\ \-\ SP",
"55663507", "Simione\ \-\ MT",
"55112085", "Guarulhos\ \-\ SP",
"55543468", "Pinto\ Bandeira\ \-\ RS",
"55863346", "São\ José\ do\ Divino\ \-\ PI",
"55833564", "Poço\ de\ José\ de\ Moura\ \-\ PB",
"55243064", "Petrópolis\ \-\ RJ",
"55544141", "Caxias\ do\ Sul\ \-\ RS",
"55112862", "São\ Paulo\ \-\ SP",
"55983276", "São\ Luís\ \-\ MA",
"55773658", "Ibitiara\ \-\ BA",
"55313750", "Minas\ Gerais",
"55353864", "Perdões\ \-\ MG",
"55883583", "Mombaça\ \-\ CE",
"55183301", "Araçatuba\ \-\ SP",
"5561322", "Brasília\ \-\ DF",
"55173301", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55643665", "Piranhas\ \-\ GO",
"55114605", "Caieiras\ \-\ SP",
"55313504", "Belo\ Horizonte\ \-\ MG",
"55473152", "Gaspar\ Alto\ \-\ SC",
"55473050", "Camboriú\ \-\ SC",
"55983224", "São\ José\ de\ Ribamar\ \-\ MA",
"55843385", "Marcelino\ Vieira\ \-\ RN",
"55113183", "Itatiba\ \-\ SP",
"55753239", "Anguera\ \-\ BA",
"55373238", "Pará\ de\ Minas\ \-\ MG",
"55383238", "Grão\ Mogol\ \-\ MG",
"55473427", "Joinville\ \-\ SC",
"55513704", "Monte\ Alverne\ \-\ RS",
"55933518", "Itaituba\ \-\ PA",
"55883624", "Granja\ \-\ CE",
"55173346", "Bebedouro\ \-\ SP",
"55813032", "Recife\ \-\ PE",
"55623519", "Goiânia\ \-\ GO",
"55753257", "Bessa\ \-\ BA",
"55454003", "Foz\ do\ Iguaçu\ \-\ PR",
"55115111", "São\ Paulo\ \-\ SP",
"55114813", "Itu\ \-\ SP",
"55753471", "Feira\ de\ Santana\ \-\ BA",
"55843395", "Almino\ Afonso\ \-\ RN",
"55543242", "Nova\ Prata\ \-\ RS",
"5531346", "Minas\ Gerais",
"55193927", "Piracicaba\ \-\ SP",
"55333735", "Coronel\ Murta\ \-\ MG",
"55513550", "Rio\ Grande\ do\ Sul",
"55453287", "Boa\ Vista\ da\ Aparecida\ \-\ PR",
"55863301", "Teresina\ \-\ PI",
"55713508", "Lauro\ de\ Freitas\ \-\ BA",
"55623567", "Goiânia\ \-\ GO",
"55753328", "Ibiquera\ \-\ BA",
"55193803", "Sumaré\ \-\ SP",
"55373329", "Formiga\ \-\ MG",
"55372102", "Divinópolis\ \-\ MG",
"55733277", "Guaratinga\ \-\ BA",
"55433436", "Cambira\ \-\ PR",
"55183855", "Monte\ Castelo\ \-\ SP",
"55753243", "Conceição\ do\ Jacuípe\ \-\ BA",
"55222645", "Cabo\ Frio\ \-\ RJ",
"55382102", "Unaí\ \-\ MG",
"55452101", "Cascavel\ \-\ PR",
"55493289", "Lages\ \-\ SC",
"55413398", "São\ José\ dos\ Pinhais\ \-\ PR",
"55813376", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55313841", "Coronel\ Fabriciano\ \-\ MG",
"55513586", "Rio\ Grande\ do\ Sul",
"55143402", "Marília\ \-\ SP",
"55623377", "Formoso\ \-\ GO",
"55443424", "Paranavaí\ \-\ PR",
"55222773", "Macaé\ \-\ RJ",
"55893488", "Jacobina\ do\ Piauí\ \-\ PI",
"55343814", "Patos\ de\ Minas\ \-\ MG",
"5515323", "Sorocaba\ \-\ SP",
"55413063", "Curitiba\ \-\ PR",
"55423662", "Paz\ \-\ PR",
"55923249", "Manaus\ \-\ AM",
"55473255", "Brusque\ \-\ SC",
"55193889", "Monte\ Mor\ \-\ SP",
"55313545", "Rio\ Acima\ \-\ MG",
"55114644", "Itaquaquecetuba\ \-\ SP",
"55113513", "São\ Paulo\ \-\ SP",
"55483255", "Imbituba\ \-\ SC",
"551130", "São\ Paulo\ \-\ SP",
"55833252", "João\ Pessoa\ \-\ PB",
"55183551", "Lucélia\ \-\ SP",
"55163509", "São\ Carlos\ \-\ SP",
"55793259", "Aracaju\ \-\ SE",
"55173551", "Ibirá\ \-\ SP",
"55313121", "Igarapé\ \-\ MG",
"55283538", "Atilio\ Vivacqua\ \-\ ES",
"55193709", "Campinas\ \-\ SP",
"55753425", "Cachoeira\ \-\ BA",
"55613107", "Brasília\ \-\ DF",
"55213142", "Itaboraí\ \-\ RJ",
"55313116", "Belo\ Horizonte\ \-\ MG",
"55513750", "Vale\ do\ Sol\ \-\ RS",
"55333535", "Pavão\ \-\ MG",
"55323336", "Desterro\ do\ Melo\ \-\ MG",
"55873793", "Calçado\ \-\ PE",
"55314114", "Conselheiro\ Lafaiete\ \-\ MG",
"55193583", "Descalvado\ \-\ SP",
"55313894", "Araponga\ \-\ MG",
"55553376", "Panambi\ \-\ RS",
"55863385", "São\ João\ do\ Arraial\ \-\ PI",
"5511267", "São\ Paulo\ \-\ SP",
"55543052", "Bento\ Gonçalves\ \-\ RS",
"55633379", "Caseara\ \-\ TO",
"55553324", "Cruz\ Alta\ \-\ RS",
"55173395", "Terra\ Roxa\ \-\ SP",
"55373373", "Capitólio\ \-\ MG",
"55553032", "Santa\ Maria\ \-\ RS",
"55693343", "Corumbiara\ \-\ RO",
"55833360", "Borborema\ \-\ PB",
"55773201", "Vitória\ da\ Conquista\ \-\ BA",
"55383563", "São\ Gonçalo\ do\ Abaeté\ \-\ MG",
"55153339", "Sorocaba\ \-\ SP",
"55114519", "Mauá\ \-\ SP",
"55653624", "Cuiabá\ \-\ MT",
"55673272", "Sidrolândia\ \-\ MS",
"55513731", "Rio\ Pardo\ \-\ RS",
"55833042", "João\ Pessoa\ \-\ PB",
"55753414", "Cachoeira\ \-\ BA",
"55473045", "Itajaí\ \-\ SC",
"55513786", "Rio\ Grande\ do\ Sul",
"55483045", "Criciúma\ \-\ SC",
"55114038", "Campo\ Limpo\ Paulista\ \-\ SP",
"55653337", "Diamantino\ \-\ MT",
"55313531", "Betim\ \-\ MG",
"55513629", "Rio\ Grande\ do\ Sul",
"55333623", "Fronteira\ dos\ Vales\ \-\ MG",
"55183334", "Presidente\ Prudente\ \-\ SP",
"55773467", "Jacaraci\ \-\ BA",
"55173334", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55873889", "Cedro\ \-\ PE",
"55114103", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55123863", "Maresias\ \-\ SP",
"55433558", "Santo\ Antônio\ da\ Platina\ \-\ PR",
"55753642", "Jaguaripe\ \-\ BA",
"55323755", "Vieiras\ \-\ MG",
"55623605", "Goiânia\ \-\ GO",
"55313835", "Itabira\ \-\ MG",
"55433017", "Londrina\ \-\ PR",
"55513354", "Rio\ Grande\ do\ Sul",
"55513545", "Igrejinha\ \-\ RS",
"55133519", "Santos\ \-\ SP",
"55212153", "Rio\ de\ Janeiro\ \-\ RJ",
"55313884", "Minas\ Gerais",
"55273263", "Santa\ Maria\ de\ Jetibá\ \-\ ES",
"55193593", "Descalvado\ \-\ SP",
"55873803", "Pesqueira\ \-\ PE",
"55333741", "Jequitinhonha\ \-\ MG",
"55873783", "Caetés\ \-\ PE",
"55433444", "Arapuã\ \-\ PR",
"55624109", "Goiânia\ \-\ GO",
"55913464", "Atalaia\ \-\ PA",
"55133377", "Cubatão\ \-\ SP",
"55313550", "Minas\ Gerais",
"55114681", "Juquitiba\ \-\ SP",
"55153343", "Votorantim\ \-\ SP",
"55143583", "Balbinos\ \-\ SP",
"55843301", "Natal\ \-\ RN",
"55183022", "Assis\ \-\ SP",
"55343242", "Araguari\ \-\ MG",
"55623412", "Goiânia\ \-\ GO",
"55193624", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55823232", "Maceió\ \-\ AL",
"55553335", "Eugênio\ de\ Castro\ \-\ RS",
"55273198", "Vitória\ \-\ ES",
"55513774", "Ilópolis\ \-\ RS",
"55312138", "Belo\ Horizonte\ \-\ MG",
"55513699", "Rio\ Grande\ do\ Sul",
"55163829", "Ituverava\ \-\ SP",
"55353854", "Ilicínea\ \-\ MG",
"55323375", "Conceição\ da\ Barra\ de\ Minas\ \-\ MG",
"55643655", "Paranaiguara\ \-\ GO",
"55222789", "São\ Francisco\ de\ Paula\ \-\ RJ",
"55853364", "Umirim\ \-\ CE",
"55153298", "Pilar\ do\ Sul\ \-\ SP",
"55513191", "Portão\ \-\ RS",
"55623539", "Goiânia\ \-\ GO",
"55513726", "Lajeado\ \-\ RS",
"55313760", "Minas\ Gerais",
"55773668", "Sebastião\ Laranjeiras\ \-\ BA",
"55543458", "Tuiutí\ \-\ RS",
"55833554", "Nazarezinho\ \-\ PB",
"55193873", "Sumaré\ \-\ SP",
"55833345", "Caturité\ \-\ PB",
"55933538", "Terra\ Santa\ \-\ PA",
"55333524", "Ladainha\ \-\ MG",
"55483342", "Palhoça\ \-\ SC",
"55353341", "Caxambu\ \-\ MG",
"55473342", "Navegantes\ \-\ SC",
"55183941", "Espigão\ \-\ SP",
"55283518", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55163987", "Serrana\ \-\ SP",
"55623307", "Ceres\ \-\ GO",
"55353556", "Arceburgo\ \-\ MG",
"55133849", "Iguape\ \-\ SP",
"55143472", "Ubirajara\ \-\ SP",
"55212665", "Queimados\ \-\ RJ",
"55983473", "Coelho\ Neto\ \-\ MA",
"55973473", "São\ Gabriel\ da\ Cachoeira\ \-\ AM",
"55733207", "Nova\ Canaã\ \-\ BA",
"55163723", "Franca\ \-\ SP",
"55114739", "Mogi\ das\ Cruzes\ \-\ SP",
"5585345", "Fortaleza\ \-\ CE",
"55962101", "Macapá\ \-\ AP",
"5535342", "Pouso\ Alegre\ \-\ MG",
"55633452", "Nova\ Olinda\ \-\ TO",
"55413642", "Araucária\ \-\ PR",
"55433249", "Cambé\ \-\ PR",
"5515321", "Sorocaba\ \-\ SP",
"55343834", "Guimarânia\ \-\ MG",
"55613553", "Brasília\ \-\ DF",
"55213274", "Rio\ de\ Janeiro\ \-\ RJ",
"55543355", "Ibiraiaras\ \-\ RS",
"55543544", "Entre\ Rios\ do\ Sul\ \-\ RS",
"55123666", "Santo\ Antônio\ do\ Pinhal\ \-\ SP",
"55833448", "Bom\ Sucesso\ \-\ PB",
"55493441", "Concórdia\ \-\ SC",
"55193779", "Campinas\ \-\ SP",
"55313711", "Prudente\ de\ Morais\ \-\ MG",
"55513603", "Rainha\ do\ Mar\ \-\ RS",
"55713083", "Salvador\ \-\ BA",
"55413414", "Tagaçaba\ \-\ PR",
"55383753", "Felixlândia\ \-\ MG",
"55443441", "Terra\ Rica\ \-\ PR",
"55163133", "Cristais\ Paulista\ \-\ SP",
"55483265", "São\ João\ Batista\ \-\ SC",
"55833262", "João\ Pessoa\ \-\ PB",
"55793269", "Riachuelo\ \-\ SE",
"55173561", "Novais\ \-\ SP",
"55143523", "Lins\ \-\ SP",
"55553756", "Cerro\ Grande\ \-\ RS",
"55423652", "Boa\ Ventura\ de\ São\ Roque\ \-\ PR",
"55353012", "Itajubá\ \-\ MG",
"55193684", "São\ José\ do\ Rio\ Pardo\ \-\ SP",
"55663577", "Canabrava\ do\ Norte\ \-\ MT",
"55813341", "Recife\ \-\ PE",
"55923491", "Carauari\ \-\ AM",
"55313876", "Urucânia\ \-\ MG",
"55513370", "Rio\ Grande\ do\ Sul",
"55883579", "Quixelô\ \-\ CE",
"55183325", "Assis\ \-\ SP",
"55613389", "Planaltina\ \-\ DF",
"55313202", "Belo\ Horizonte\ \-\ MG",
"55115643", "São\ Paulo\ \-\ SP",
"55833304", "São\ Sebastião\ do\ Umbuzeiro\ \-\ PB",
"55793217", "Aracaju\ \-\ SE",
"55513560", "Araricá\ \-\ RS",
"55873829", "Ingazeira\ \-\ PE",
"55933067", "Santarém\ \-\ PA",
"55222674", "Araruama\ \-\ RJ",
"55313526", "Minas\ Gerais",
"55153288", "Cerquilho\ \-\ SP",
"55663903", "Alta\ Floresta\ \-\ MT",
"55623557", "Campestre\ de\ Goiás\ \-\ GO",
"55383218", "Montes\ Claros\ \-\ MG",
"5581342", "Recife\ \-\ PE",
"55923213", "Manaus\ \-\ AM",
"55513689", "Xangri\-Lá\ \-\ RS",
"55883641", "Pacujá\ \-\ CE",
"55653694", "Várzea\ Grande\ \-\ MT",
"55383747", "Paredão\ de\ Minas\ \-\ MG",
"55753446", "Sátiro\ Dias\ \-\ BA",
"55183697", "Rubiácea\ \-\ SP",
"5531345", "Belo\ Horizonte\ \-\ MG",
"55242107", "Volta\ Redonda\ \-\ RJ",
"55313574", "Crucilândia\ \-\ MG",
"55733528", "Jequié\ \-\ BA",
"55753267", "Biritinga\ \-\ BA",
"55115721", "Mauá\ \-\ SP",
"55183371", "Maracaí\ \-\ SP",
"55613303", "Brasília\ \-\ DF",
"55533282", "Pelotas\ \-\ RS",
"55212707", "Niterói\ \-\ RJ",
"55443273", "Ivatuba\ \-\ PR",
"55993578", "São\ Domingos\ do\ Maranhão\ \-\ MA",
"55413047", "Almirante\ Tamandaré\ \-\ PR",
"55222630", "Cabo\ Frio\ \-\ RJ",
"55433662", "Florestópolis\ \-\ PR",
"55883665", "Morrinhos\ \-\ CE",
"55673022", "Campo\ Grande\ \-\ MS",
"55313166", "Belo\ Horizonte\ \-\ MG",
"55212133", "Rio\ de\ Janeiro\ \-\ RJ",
"55143357", "Óleo\ \-\ SP",
"55923198", "Manaus\ \-\ AM",
"55653343", "Arenápolis\ \-\ MT",
"55212008", "Teresópolis\ \-\ RJ",
"55613634", "Padre\ Bernardo\ \-\ GO",
"55633377", "Aliança\ do\ Tocantins\ \-\ TO",
"55423436", "Imbituva\ \-\ PR",
"55623248", "Aparecida\ de\ Goiânia\ \-\ GO",
"55743642", "Irecê\ \-\ BA",
"55124109", "São\ José\ dos\ Campos\ \-\ SP",
"55113654", "Osasco\ \-\ SP",
"55313530", "Betim\ \-\ MG",
"55633691", "Rio\ da\ Conceição\ \-\ TO",
"55473473", "Joinville\ \-\ SC",
"55813468", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55853924", "Fortaleza\ \-\ CE",
"55313346", "Belo\ Horizonte\ \-\ MG",
"55823252", "Joaquim\ Gomes\ \-\ AL",
"55114656", "Santa\ Isabel\ \-\ SP",
"55213035", "Rio\ de\ Janeiro\ \-\ RJ",
"55893550", "Jerumenha\ \-\ PI",
"55462101", "Pato\ Branco\ \-\ PR",
"55323222", "Juiz\ de\ Fora\ \-\ MG",
"55173354", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55813521", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55833633", "Baraúna\ \-\ PB",
"55833310", "Campina\ Grande\ \-\ PB",
"55633519", "Lajeado\ \-\ TO",
"55183354", "Platina\ \-\ SP",
"55373513", "Pompéu\ \-\ MG",
"55353242", "Turvolândia\ \-\ MG",
"55114680", "Santa\ Isabel\ \-\ SP",
"55483241", "São\ José\ \-\ SC",
"55443465", "Cruzeiro\ do\ Sul\ \-\ PR",
"55313551", "Ouro\ Preto\ \-\ MG",
"55853301", "Beberibe\ \-\ CE",
"55473241", "Itajaí\ \-\ SC",
"55143343", "Canitar\ \-\ SP",
"55893531", "Canto\ do\ Buriti\ \-\ PI",
"55173121", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55433538", "Andirá\ \-\ PR",
"55813145", "Vitória\ de\ Santo\ Antão\ \-\ PE",
"55213084", "Rio\ de\ Janeiro\ \-\ RJ",
"55242442", "Barra\ do\ Piraí\ \-\ RJ",
"55513488", "Gravataí\ \-\ RS",
"55673488", "Aral\ Moreira\ \-\ MS",
"55614103", "Brasília\ \-\ DF",
"55193507", "Araras\ \-\ SP",
"55623323", "Ceres\ \-\ GO",
"55313855", "Alvinópolis\ \-\ MG",
"55222727", "São\ Francisco\ de\ Itabapoana\ \-\ RJ",
"55843673", "Natal\ \-\ RN",
"55173841", "Arabá\ \-\ SP",
"55222651", "Saquarema\ \-\ RJ",
"55183841", "Junqueirópolis\ \-\ SP",
"55653228", "Lambari\ D\'Oeste\ \-\ MT",
"55663402", "Barra\ do\ Garças\ \-\ MT",
"556232", "Goiânia\ \-\ GO",
"55163707", "Franca\ \-\ SP",
"55553643", "Boa\ Vista\ do\ Cadeado\ \-\ RS",
"55543324", "Ibirubá\ \-\ RS",
"55183786", "Sud\ Mennucci\ \-\ SP",
"55673498", "Caarapó\ \-\ MS",
"55773417", "Guajeru\ \-\ BA",
"55513498", "Rio\ Grande\ do\ Sul",
"55273758", "Mantenópolis\ \-\ ES",
"55353716", "Poços\ de\ Caldas\ \-\ MG",
"55212641", "Teresópolis\ \-\ RJ",
"55173272", "Tanabi\ \-\ SP",
"55183272", "Presidente\ Venceslau\ \-\ SP",
"55513751", "Encantado\ \-\ RS",
"55153624", "Itapeva\ \-\ SP",
"55543376", "Aratiba\ \-\ RS",
"5573", "Bahia",
"55653339", "Tangará\ da\ Serra\ \-\ MT",
"55513627", "Imbé\ \-\ RS",
"55713273", "Salvador\ \-\ BA",
"55354141", "Poços\ de\ Caldas\ \-\ MG",
"55843531", "Angicos\ \-\ RN",
"55853346", "Itapagé\ \-\ CE",
"55873887", "Orocó\ \-\ PE",
"55323541", "Ubá\ \-\ MG",
"55643676", "Cachoeira\ de\ Goiás\ \-\ GO",
"55323356", "Ritápolis\ \-\ MG",
"55833525", "Sousa\ \-\ PB",
"55513730", "Passo\ do\ Sobrado\ \-\ RS",
"55983011", "São\ Luís\ \-\ MA",
"55483522", "Araranguá\ \-\ SC",
"55333344", "Lajinha\ \-\ MG",
"55273213", "Cariacica\ \-\ ES",
"55353521", "Passos\ \-\ MG",
"55473522", "Rio\ do\ Sul\ \-\ SC",
"55643593", "Itumbiara\ \-\ GO",
"55163665", "Altinópolis\ \-\ SP",
"55424063", "Ponta\ Grossa\ \-\ PR",
"55353825", "Itutinga\ \-\ MG",
"55643624", "Itumbiara\ \-\ GO",
"55353365", "São\ Sebastião\ do\ Rio\ Verde\ \-\ MG",
"55833361", "Esperança\ \-\ PB",
"55693583", "Quinto\ Bec\ \-\ RO",
"55873929", "Serra\ Talhada\ \-\ PE",
"5551341", "Rio\ Grande\ do\ Sul",
"55543032", "Flores\ da\ Cunha\ \-\ RS",
"55793642", "Colônia\ Treze\ \-\ SE",
"55123018", "São\ José\ dos\ Campos\ \-\ SP",
"55813536", "Pombos\ \-\ PE",
"55623537", "Aparecida\ de\ Goiânia\ \-\ GO",
"55513428", "Rio\ Grande\ do\ Sul",
"55543394", "Santo\ Antônio\ do\ Palma\ \-\ RS",
"55433253", "Cambé\ \-\ PR",
"55813581", "Chã\ de\ Alegria\ \-\ PE",
"55113303", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55463227", "Vitorino\ \-\ PR",
"55114620", "Osasco\ \-\ SP",
"55153523", "Caputera\ \-\ SP",
"55813705", "Santa\ Cruz\ do\ Capibaribe\ \-\ PE",
"55773618", "Cristópolis\ \-\ BA",
"55513697", "Brochier\ \-\ RS",
"55313710", "Minas\ Gerais",
"55613625", "Cidade\ Ocidental\ \-\ GO",
"55623383", "Britânia\ \-\ GO",
"55443440", "Inajá\ \-\ PR",
"55893574", "Curimatá\ \-\ PI",
"55733283", "Camacã\ \-\ BA",
"55913446", "São\ Miguel\ do\ Guamá\ \-\ PA",
"55553505", "Alegrete\ \-\ RS",
"55613397", "Taguatinga\ \-\ DF",
"55383733", "Francisco\ Dumont\ \-\ MG",
"55353591", "Monte\ Santo\ de\ Minas\ \-\ MG",
"55113389", "São\ Paulo\ \-\ SP",
"55683325", "Marechal\ Thaumaturgo\ \-\ AC",
"55453273", "Toledo\ \-\ PR",
"55323724", "Eugenópolis\ \-\ MG",
"55423421", "Irati\ \-\ PR",
"55713602", "Candeias\ \-\ BA",
"55423632", "Jordãozinho\ \-\ PR",
"55733209", "Posto\ da\ Mata\ \-\ BA",
"55333316", "Pocrane\ \-\ MG",
"55513561", "Estância\ Velha\ \-\ RS",
"55133847", "Miracatu\ \-\ SP",
"55643694", "Palmelo\ \-\ GO",
"55413033", "Pinhais\ \-\ PR",
"55323282", "Pedro\ Teixeira\ \-\ MG",
"55883640", "Alcântaras\ \-\ CE",
"55553781", "Santo\ Augusto\ \-\ RS",
"55183603", "Luiziânia\ \-\ SP",
"55143288", "Bauru\ \-\ SP",
"55243322", "Barra\ Mansa\ \-\ RJ",
"55353536", "Itaú\ de\ Minas\ \-\ MG",
"55313761", "Conselheiro\ Lafaiete\ \-\ MG",
"55115032", "São\ Paulo\ \-\ SP",
"55113177", "São\ Paulo\ \-\ SP",
"55633432", "Bandeirantes\ do\ Tocantins\ \-\ TO",
"55983004", "São\ Luís\ \-\ MA",
"55343669", "Araxá\ \-\ MG",
"55113399", "São\ Paulo\ \-\ SP",
"55894101", "Picos\ \-\ PI",
"55483215", "Florianópolis\ \-\ SC",
"55613387", "Sobradinho\ \-\ DF",
"55993602", "Nova\ Colinas\ \-\ MA",
"55663579", "Nova\ Ubiratã\ \-\ MT",
"55114759", "Suzano\ \-\ SP",
"55143298", "Macatuba\ \-\ SP",
"55483061", "Criciúma\ \-\ SC",
"55843364", "Olho\-D\'Água\ do\ Borges\ \-\ RN",
"55813619", "Fernando\ de\ Noronha\ \-\ PE",
"55813744", "Agrestina\ \-\ PE",
"55613533", "Brasília\ \-\ DF",
"55553791", "Palmitinho\ \-\ RS",
"55323292", "Bom\ Jardim\ de\ Minas\ \-\ MG",
"55643684", "Aurilândia\ \-\ GO",
"55283037", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55173815", "Guaraci\ \-\ SP",
"55643472", "Santa\ Cruz\ de\ Goiás\ \-\ GO",
"55693523", "Theobroma\ \-\ RO",
"55383843", "Novorizonte\ \-\ MG",
"55513941", "Canoas\ \-\ RS",
"55212709", "Niterói\ \-\ RJ",
"55753269", "Riachão\ do\ Jacuípe\ \-\ BA",
"55933017", "Santarém\ \-\ PA",
"55553355", "Caibaté\ \-\ RS",
"55553544", "Novo\ Machado\ \-\ RS",
"55533321", "Pelotas\ \-\ RS",
"55543384", "Barros\ Cassal\ \-\ RS",
"55643635", "Santa\ Rita\ do\ Araguaia\ \-\ GO",
"55114853", "Suzano\ \-\ SP",
"55353834", "Aguanil\ \-\ MG",
"55733293", "Alcobaça\ \-\ BA",
"55753217", "Santo\ Amaro\ \-\ BA",
"55623393", "Bonópolis\ \-\ GO",
"55963424", "Pracuúba\ \-\ AP",
"55314002", "Belo\ Horizonte\ \-\ MG",
"55183699", "Lourdes\ \-\ SP",
"55242109", "Resende\ \-\ RJ",
"55173699", "Pontalinda\ \-\ SP",
"55843526", "Porto\ do\ Mangue\ \-\ RN",
"55383749", "Pirapora\ \-\ MG",
"55833534", "Uiraúna\ \-\ PB",
"55383614", "Montalvânia\ \-\ MG",
"55933558", "Belterra\ \-\ PA",
"55673687", "Miranda\ \-\ MS",
"55513687", "Arroio\ do\ Sal\ \-\ RS",
"55423233", "Castro\ \-\ PR",
"55133383", "Guarujá\ \-\ SP",
"55313325", "Minas\ Gerais",
"55173202", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55183876", "Paulicéia\ \-\ SP",
"55313865", "Coronel\ Fabriciano\ \-\ MG",
"55663523", "Nova\ Santa\ Helena\ \-\ MT",
"55222661", "Araruama\ \-\ RJ",
"55813544", "Ilha\ de\ Itamaracá\ \-\ PE",
"55653319", "Cuiabá\ \-\ MT",
"55123833", "Ubatuba\ \-\ SP",
"55643997", "Itumbiara\ \-\ GO",
"55383671", "Paracatu\ \-\ MG",
"55483276", "Alfredo\ Wagner\ \-\ SC",
"55913485", "Tracuateua\ \-\ PA",
"55432104", "Londrina\ \-\ PR",
"55773437", "Belo\ Campo\ \-\ BA",
"55923019", "Manaus\ \-\ AM",
"55713203", "Salvador\ \-\ BA",
"55443455", "Santa\ Mônica\ \-\ PR",
"55313561", "Itabirito\ \-\ MG",
"55353736", "Cabo\ Verde\ \-\ MG",
"55823262", "Messias\ \-\ AL",
"55114666", "Itapecerica\ da\ Serra\ \-\ SP",
"55813846", "Santa\ Cruz\ da\ Baixa\ Verde\ \-\ PE",
"55893560", "Francisco\ Ayres\ \-\ PI",
"55313371", "Minas\ Gerais",
"55853092", "Fortaleza\ \-\ CE",
"55313428", "Belo\ Horizonte\ \-\ MG",
"55533931", "Rio\ Grande\ \-\ RS",
"55693641", "Alta\ Floresta\ do\ Oeste\ \-\ RO",
"55913434", "Garrafão\ do\ Norte\ \-\ PA",
"55733682", "Teixeira\ de\ Freitas\ \-\ BA",
"55713289", "Lauro\ de\ Freitas\ \-\ BA",
"55115934", "São\ Paulo\ \-\ SP",
"55383625", "Varzelândia\ \-\ MG",
"55273233", "Vitória\ \-\ ES",
"55553744", "Frederico\ Westphalen\ \-\ RS",
"55313697", "Bairro\ Eldorado\ \-\ Sete\ Lagoas\ MG",
"55513710", "Lajeado\ \-\ RS",
"55883655", "Frecheirinha\ \-\ CE",
"55733692", "Camacan\ \-\ BA",
"55353544", "Ibiraci\ \-\ MG",
"55193903", "Sumaré\ \-\ SP",
"55333321", "Caratinga\ \-\ MG",
"55853325", "Pacoti\ \-\ CE",
"55833351", "Monteiro\ \-\ PB",
"55493358", "Cordilheira\ Alta\ \-\ SC",
"55193827", "Artur\ Nogueira\ \-\ SP",
"55123849", "Ubatuba\ \-\ SP",
"55613614", "Novo\ Gama\ \-\ GO",
"55943424", "Redenção\ \-\ PA",
"55773021", "Barreiras\ \-\ BA",
"55323366", "Oliveira\ Fortes\ \-\ MG",
"55674002", "Campo\ Grande\ \-\ MS",
"55123432", "Taubaté\ \-\ SP",
"55813736", "São\ Caetano\ \-\ PE",
"55643641", "Santa\ Helena\ de\ Goiás\ \-\ GO",
"55853371", "Maracanaú\ \-\ CE",
"55323576", "Dores\ do\ Turvo\ \-\ MG",
"55273249", "Paraju\ \-\ ES",
"55242258", "Bemposta\ \-\ RJ",
"55114537", "Jundiaí\ \-\ SP",
"55412106", "Curitiba\ \-\ PR",
"55513761", "Paverama\ \-\ RS",
"55553536", "Alegria\ \-\ RS",
"55323693", "Barbacena\ \-\ MG",
"55773459", "Tanhaçu\ \-\ BA",
"55493455", "Alto\ Bela\ Vista\ \-\ SC",
"55643579", "Itumbiara\ \-\ GO",
"55543341", "Getúlio\ Vargas\ \-\ RS",
"55973427", "Juruá\ \-\ AM",
"55543617", "Tapejara\ \-\ RS",
"55193577", "Corumbataí\ \-\ SP",
"55184101", "Presidente\ Prudente\ \-\ SP",
"55823554", "Igreja\ Nova\ \-\ AL",
"55383533", "Couto\ de\ Magalhães\ de\ Minas\ \-\ MG",
"55833613", "Campina\ Grande\ \-\ PB",
"55633539", "Lizarda\ \-\ TO",
"55663472", "Serra\ Dourada\ \-\ MT",
"55273768", "Boa\ Esperança\ \-\ ES",
"55343637", "Pratinha\ \-\ MG",
"55313488", "Minas\ Gerais",
"55323741", "Carangola\ \-\ MG",
"55823647", "Pariconha\ \-\ AL",
"55733622", "Mucuri\ \-\ BA",
"55843272", "Parnamirim\ \-\ RN",
"55433456", "Apucarana\ \-\ PR",
"55193897", "Hortolândia\ \-\ SP",
"55553242", "Santana\ do\ Livramento\ \-\ RS",
"55513551", "Estância\ Velha\ \-\ RS",
"55163343", "Ibaté\ \-\ SP",
"55813639", "Macaparana\ \-\ PE",
"55444003", "Maringá\ \-\ PR",
"55173531", "Catanduva\ \-\ SP",
"55833232", "Bayeux\ \-\ PB",
"55353643", "Piranguçu\ \-\ MG",
"55313334", "Minas\ Gerais",
"55813131", "Recife\ \-\ PE",
"55183586", "Mariápolis\ \-\ SP",
"55313915", "Belo\ Horizonte\ \-\ MG",
"55114462", "Santo\ André\ \-\ SP",
"55823311", "Maceió\ \-\ AL",
"55283558", "Jerônimo\ Monteiro\ \-\ ES",
"55133323", "Santos\ \-\ SP",
"55313385", "Minas\ Gerais",
"55663583", "Vera\ \-\ MT",
"55163357", "Araraquara\ \-\ SP",
"55383634", "Chapada\ Gaúcha\ \-\ MG",
"55753237", "Teodoro\ Sampaio\ \-\ BA",
"55843504", "Caicó\ \-\ RN",
"55112812", "Guarulhos\ \-\ SP",
"55913425", "Bragança\ \-\ PA",
"55123519", "São\ José\ dos\ Campos\ \-\ SP",
"55643615", "Quirinópolis\ \-\ GO",
"55313840", "Minas\ Gerais",
"5514323", "Bauru\ \-\ SP",
"55613048", "Taguatinga\ \-\ DF",
"55183704", "Pereira\ Barreto\ \-\ SP",
"55442101", "Maringá\ \-\ PR",
"55353721", "Poços\ de\ Caldas\ \-\ MG",
"55193665", "Mococa\ \-\ SP",
"55333755", "Águas\ Vermelhas\ \-\ MG",
"55115854", "São\ Paulo\ \-\ SP",
"55543520", "Erechim\ \-\ RS",
"55313730", "Minas\ Gerais",
"55943435", "São\ Félix\ do\ Xingu\ \-\ PA",
"55663593", "Apiacás\ \-\ MT",
"55683301", "Rio\ Branco\ \-\ AC",
"55193929", "Valinhos\ \-\ SP",
"55492101", "Lages\ \-\ SC",
"55313395", "Contagem\ \-\ MG",
"5531341", "Belo\ Horizonte\ \-\ MG",
"55853334", "Cascavel\ \-\ CE",
"55813643", "Itaquitinga\ \-\ PE",
"55223051", "Macaé\ \-\ RJ",
"55123103", "Cachoeira\ Paulista\ \-\ SP",
"55983487", "Paulino\ Neves\ \-\ MA",
"55623517", "Goiânia\ \-\ GO",
"55753259", "Euclides\ da\ Cunha\ \-\ BA",
"55373258", "Pitangui\ \-\ MG",
"55213982", "Rio\ de\ Janeiro\ \-\ RJ",
"55163973", "Guatapará\ \-\ SP",
"55483030", "Florianópolis\ \-\ SC",
"55553365", "Roque\ Gonzales\ \-\ RS",
"55793257", "São\ Cristóvão\ \-\ SE",
"55193887", "Hortolândia\ \-\ SP",
"55843354", "Encanto\ \-\ RN",
"55193707", "Campinas\ \-\ SP",
"55333336", "Simonésia\ \-\ MG",
"55343324", "Água\ Comprida\ \-\ MG",
"55123681", "Taubaté\ \-\ SP",
"55853022", "Fortaleza\ \-\ CE",
"55323535", "Divinésia\ \-\ MG",
"55623379", "Minaçu\ \-\ GO",
"55733279", "Teolândia\ \-\ BA",
"55923247", "Manaus\ \-\ AM",
"55623933", "Goiânia\ \-\ GO",
"55183745", "Itapura\ \-\ SP",
"55313627", "Ribeirão\ das\ Neves\ \-\ MG",
"55813721", "Caruaru\ \-\ PE",
"55613601", "Luziânia\ \-\ GO",
"55313751", "Entre\ Rios\ de\ Minas\ \-\ MG",
"55813657", "Ferreiros\ \-\ PE",
"55513733", "Encruzilhada\ do\ Sul\ \-\ RS",
"55883544", "Farias\ Brito\ \-\ CE",
"55652128", "Cuiabá\ \-\ MT",
"55313397", "Contagem\ \-\ MG",
"55333739", "Chapada\ do\ Norte\ \-\ MG",
"55115615", "São\ Paulo\ \-\ SP",
"55143667", "Itaju\ \-\ SP",
"55453036", "Cascavel\ \-\ PR",
"55843553", "Jandaíra\ \-\ RN",
"55383561", "João\ Pinheiro\ \-\ MG",
"55553367", "Santo\ Antônio\ das\ Missões\ \-\ RS",
"55693341", "Colorado\ do\ Oeste\ \-\ RO",
"55623515", "Goiânia\ \-\ GO",
"55973485", "Guajará\ \-\ AM",
"55623282", "Aparecida\ de\ Goiânia\ \-\ GO",
"55993075", "Imperatriz\ \-\ MA",
"55983485", "Água\ Doce\ do\ Maranhão\ \-\ MA",
"55114826", "Rio\ Grande\ da\ Serra\ \-\ SP",
"55193834", "Indaiatuba\ \-\ SP",
"55323537", "Paula\ Cândido\ \-\ MG",
"55193705", "Campinas\ \-\ SP",
"55753429", "Conde\ \-\ BA",
"55173664", "Aspásia\ \-\ SP",
"55114576", "Mauá\ \-\ SP",
"55193885", "Indaiatuba\ \-\ SP",
"55873846", "Triunfo\ \-\ PE",
"55373371", "Piumhi\ \-\ MG",
"55114715", "Alumínio\ \-\ SP",
"55313549", "Minas\ Gerais",
"55483259", "São\ José\ \-\ SC",
"55853387", "Caucaia\ \-\ CE",
"5524", "Rio\ de\ Janeiro",
"55753030", "Feira\ de\ Santana\ \-\ BA",
"55114693", "Guararema\ \-\ SP",
"55793255", "Aracaju\ \-\ SE",
"55873791", "Palmeirina\ \-\ PE",
"55212637", "Maricá\ \-\ RJ",
"55913031", "Ananindeua\ \-\ PA",
"55653619", "Cuiabá\ \-\ MT",
"5511345", "São\ Paulo\ \-\ SP",
"55813655", "São\ Vicente\ Ferrer\ \-\ PE",
"55313625", "Ribeirão\ das\ Neves\ \-\ MG",
"55513442", "Alvorada\ \-\ RS",
"55114524", "Itatiba\ \-\ SP",
"55673442", "Ivinhema\ \-\ MS",
"55983388", "Peri\ Mirim\ \-\ MA",
"55923245", "Manaus\ \-\ AM",
"55193581", "Porto\ Ferreira\ \-\ SP",
"55443056", "Umuarama\ \-\ PR",
"55753294", "Água\ Fria\ \-\ BA",
"55713270", "Salvador\ \-\ BA",
"55114683", "Juquitiba\ \-\ SP",
"55673268", "Bodoquena\ \-\ MS",
"55212659", "Magé\ \-\ RJ",
"55833313", "Boa\ Vista\ \-\ PB",
"55193895", "Socorro\ \-\ SP",
"55453254", "Marechal\ Cândido\ Rondon\ \-\ PR",
"5574361", "Juazeiro\ \-\ BA",
"55273015", "Vitória\ \-\ ES",
"55173837", "Sebastianópolis\ do\ Sul\ \-\ SP",
"55823645", "Inhapi\ \-\ AL",
"55143581", "Pongaí\ \-\ SP",
"55323559", "Visconde\ do\ Rio\ Branco\ \-\ MG",
"55133576", "São\ Vicente\ \-\ SP",
"55463246", "Saudade\ do\ Iguaçu\ \-\ PR",
"55353298", "Machado\ \-\ MG",
"55753284", "Macururé\ \-\ BA",
"55663438", "Nova\ Xavantina\ \-\ MT",
"55222106", "Macaé\ \-\ RJ",
"55273261", "Guarapari\ \-\ ES",
"55893547", "São\ Miguel\ do\ Fidalgo\ \-\ PI",
"55323393", "Senhora\ das\ Dores\ \-\ MG",
"55823529", "Arapiraca\ \-\ AL",
"55543369", "Barra\ Funda\ \-\ RS",
"55983398", "Cedral\ \-\ MA",
"55773476", "Abaíra\ \-\ BA",
"55143885", "Pirambóia\ \-\ SP",
"55923572", "São\ Sebastião\ do\ Uatumã\ \-\ AM",
"55333743", "Felisburgo\ \-\ MG",
"55643556", "Paraúna\ \-\ GO",
"55513614", "Maratá\ \-\ RS",
"55513749", "Palanque\ \-\ RS",
"55873781", "Canhotinho\ \-\ PE",
"55923362", "Careiro\ \-\ AM",
"55193744", "Campinas\ \-\ SP",
"55513123", "Porto\ Alegre\ \-\ RS",
"55753235", "Candeal\ \-\ BA",
"55222633", "Armação\ dos\ Búzios\ \-\ RJ",
"55512", "Rio\ Grande\ do\ Sul",
"55482106", "Florianópolis\ \-\ SC",
"55433274", "Arapongas\ \-\ PR",
"55333432", "São\ Sebastião\ do\ Maranhão\ \-\ MG",
"55472106", "Jaraguá\ do\ Sul\ \-\ SC",
"55114609", "Francisco\ Morato\ \-\ SP",
"55313387", "Minas\ Gerais",
"55873964", "Serrolândia\ \-\ PE",
"55193667", "Mococa\ \-\ SP",
"55493658", "Tigrinhos\ \-\ SC",
"55353655", "Sapucaí\-Mirim\ \-\ MG",
"55313533", "Ibirité\ \-\ MG",
"55333621", "Nanuque\ \-\ MG",
"55893553", "Júlio\ Borges\ \-\ PI",
"55123861", "São\ Sebastião\ \-\ SP",
"55123321", "São\ José\ dos\ Campos\ \-\ SP",
"55153556", "Iporanga\ \-\ SP",
"55443234", "Astorga\ \-\ PR",
"55193825", "Indaiatuba\ \-\ SP",
"555130", "Rio\ Grande\ do\ Sul",
"55883639", "Varjota\ \-\ CE",
"5583324", "João\ Pessoa\ \-\ PB",
"55613551", "Brasília\ \-\ DF",
"55623506", "Trindade\ \-\ GO",
"55133594", "Praia\ Grande\ \-\ SP",
"5521315", "Rio\ de\ Janeiro\ \-\ RJ",
"55114850", "Itu\ \-\ SP",
"55773494", "Tremedal\ \-\ BA",
"55493443", "São\ Domingos\ \-\ SC",
"55993562", "Gonçalves\ Dias\ \-\ MA",
"55323323", "São\ João\ Del\ Rei\ \-\ MG",
"55973471", "São\ Gabriel\ da\ Cachoeira\ \-\ AM",
"55983471", "Chapadinha\ \-\ MA",
"55193521", "Campinas\ \-\ SP",
"55773229", "Brumado\ \-\ BA",
"55212756", "São\ João\ de\ Meriti\ \-\ RJ",
"55733290", "Ibirapuã\ \-\ BA",
"55212394", "Rio\ de\ Janeiro\ \-\ RJ",
"55373334", "Piracema\ \-\ MG",
"55313685", "Nova\ União\ \-\ MG",
"55163721", "Franca\ \-\ SP",
"55493457", "Presidente\ Castelo\ Branco\ \-\ SC",
"55993638", "Alto\ Alegre\ do\ Maranhão\ \-\ MA",
"55433055", "Arapongas\ \-\ PR",
"55123677", "Natividade\ da\ Serra\ \-\ SP",
"5586322", "Teresina\ \-\ PI",
"55443122", "Maringá\ \-\ PR",
"55333377", "São\ João\ do\ Manhuaçu\ \-\ MG",
"55212780", "Mangaratiba\ \-\ RJ",
"55843238", "Parnamirim\ \-\ RN",
"55313634", "Santa\ Luzia\ \-\ MG",
"55114535", "Jundiaí\ \-\ SP",
"55353343", "Baependi\ \-\ MG",
"55143104", "Bauru\ \-\ SP",
"55193871", "Valinhos\ \-\ SP",
"55813339", "Recife\ \-\ PE",
"55463532", "Quedas\ do\ Iguaçu\ \-\ PR",
"55513048", "Osório\ \-\ RS",
"55114886", "Itu\ \-\ SP",
"55193716", "Campinas\ \-\ SP",
"55193575", "Itirapina\ \-\ SP",
"55222534", "Duas\ Barras\ \-\ RJ",
"55114706", "Barueri\ \-\ SP",
"55973425", "Jutaí\ \-\ AM",
"55743628", "Piritiba\ \-\ BA",
"55833278", "Alagoinha\ \-\ PB",
"55613301", "Brasília\ \-\ DF",
"55183373", "Tarumã\ \-\ SP",
"55453270", "Iguiporã\ \-\ PR",
"5517322", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55623356", "Nova\ Veneza\ \-\ GO",
"55663566", "Juína\ \-\ MT",
"55313867", "São\ Sebastião\ do\ Rio\ Preto\ \-\ MG",
"55733256", "Ituberá\ \-\ BA",
"55633344", "Carrasco\ Bonito\ \-\ TO",
"55313327", "Belo\ Horizonte\ \-\ MG",
"55643520", "Itumbiara\ \-\ GO",
"55843329", "Felipe\ Guerra\ \-\ RN",
"55343359", "Uberaba\ \-\ MG",
"55513959", "Sapiranga\ \-\ RS",
"55653365", "Cuiabá\ \-\ MT",
"55413132", "Pinhais\ \-\ PR",
"55493439", "Linha\ Planalto\ \-\ SC",
"55483548", "Passo\ de\ Torres\ \-\ SC",
"55773435", "Anagé\ \-\ BA",
"55313819", "Ponte\ Nova\ \-\ MG",
"55883516", "Piquet\ Carneiro\ \-\ CE",
"55843654", "Natal\ \-\ RN",
"55323462", "Além\ Paraíba\ \-\ MG",
"55873775", "Águas\ Belas\ \-\ PE",
"55693418", "Nova\ Brasilândia\ D\'Oeste\ \-\ RO",
"55223013", "Campos\ dos\ Goitacazes\ \-\ RJ",
"55883643", "Massapê\ \-\ CE",
"55773484", "Santana\ \-\ BA",
"55753276", "Ribeira\ do\ Pombal\ \-\ BA",
"55273312", "São\ Mateus\ \-\ ES",
"55115641", "São\ Paulo\ \-\ SP",
"5522382", "Itaperuna\ \-\ RJ",
"55813343", "Recife\ \-\ PE",
"55112277", "Bragança\ Paulista\ \-\ SP",
"55513601", "Osório\ \-\ RS",
"55383751", "Corinto\ \-\ MG",
"55114594", "Itatiba\ \-\ SP",
"55883657", "Quiterianópolis\ \-\ CE",
"55353339", "São\ Lourenço\ \-\ MG",
"55313713", "Capim\ Branco\ \-\ MG",
"55173563", "Cajobi\ \-\ SP",
"55654141", "Cuiabá\ \-\ MT",
"55113596", "São\ Paulo\ \-\ SP",
"55623541", "Goiânia\ \-\ GO",
"55443443", "Santo\ Antônio\ do\ Caiuá\ \-\ PR",
"55623380", "Araguapaz\ \-\ GO",
"55173329", "Alberto\ Moreira\ \-\ SP",
"55123974", "Paraibuna\ \-\ SP",
"55883575", "Jati\ \-\ CE",
"55183329", "Tarumã\ \-\ SP",
"55112118", "Itu\ \-\ SP",
"55433572", "Londrina\ \-\ PR",
"55163242", "Monte\ Alto\ \-\ SP",
"55553343", "Cruz\ Alta\ \-\ RS",
"55513634", "Bom\ Princípio\ \-\ RS",
"55843373", "Rodolfo\ Fernandes\ \-\ RN",
"55733046", "Jequié\ \-\ BA",
"55113175", "São\ Paulo\ \-\ SP",
"5511346", "São\ Paulo\ \-\ SP",
"55663418", "São\ Pedro\ da\ Cipa\ \-\ MT",
"55643946", "Itumbiara\ \-\ GO",
"55543337", "Estação\ \-\ RS",
"55443532", "Moreira\ Sales\ \-\ PR",
"55884141", "Juazeiro\ do\ Norte\ \-\ CE",
"55173817", "Severínia\ \-\ SP",
"55483269", "Florianópolis\ \-\ SC",
"55873871", "Salgueiro\ \-\ PE",
"55133506", "Mongaguá\ \-\ SP",
"55623594", "Aparecida\ de\ Goiânia\ \-\ GO",
"55793265", "Nossa\ Senhora\ das\ Dores\ \-\ SE",
"55413473", "Caiobá\ \-\ PR",
"55313048", "Belo\ Horizonte\ \-\ MG",
"55183654", "Penápolis\ \-\ SP",
"55643637", "Aparecida\ do\ Rio\ Doce\ \-\ GO",
"55613488", "Brasília\ \-\ DF",
"55193186", "Charqueada\ \-\ SP",
"55273084", "Vitória\ \-\ ES",
"55373551", "Dores\ do\ Indaiá\ \-\ MG",
"55743162", "Juazeiro\ \-\ BA",
"55113354", "São\ Paulo\ \-\ SP",
"55883521", "Crato\ \-\ CE",
"553130", "Minas\ Gerais",
"55423035", "Guarapuava\ \-\ PR",
"55513685", "Capivari\ do\ Sul\ \-\ RS",
"55333412", "São\ João\ Evangelista\ \-\ MG",
"55613334", "Recanto\ das\ Emas\ \-\ DF",
"5535323", "Três\ Corações\ \-\ MG",
"55143814", "Botucatu\ \-\ SP",
"55213481", "Rio\ de\ Janeiro\ \-\ RJ",
"55942103", "Marabá\ \-\ PA",
"55553228", "Boca\ do\ Monte\ \-\ RS",
"55443668", "Serra\ dos\ Dourados\ \-\ PR",
"55182102", "Araçatuba\ \-\ SP",
"55163954", "Santa\ Rosa\ de\ Viterbo\ \-\ SP",
"55893563", "Cristino\ Castro\ \-\ PI",
"55793342", "Muribeca\ \-\ SE",
"55633381", "Conceição\ do\ Tocantins\ \-\ TO",
"55633540", "Monte\ do\ Carmo\ \-\ TO",
"55463225", "Pato\ Branco\ \-\ PR",
"55963081", "Macapá\ \-\ AP",
"55163521", "Sertãozinho\ \-\ SP",
"55153566", "Bairro\ Palmitalzinho\ \-\ SP",
"55114784", "São\ Roque\ \-\ SP",
"55193814", "Mogi\ Mirim\ \-\ SP",
"55493668", "Flor\ do\ Sertão\ \-\ SC",
"55193657", "Tapiratiba\ \-\ SP",
"55653052", "Cuiabá\ \-\ MT",
"55163145", "Patrocínio\ Paulista\ \-\ SP",
"55623535", "Santo\ Antônio\ de\ Goiás\ \-\ GO",
"55823482", "Arapiraca\ \-\ AL",
"55713417", "Salvador\ \-\ BA",
"55643659", "Itarumã\ \-\ GO",
"55813887", "Orocó\ \-\ PE",
"55323379", "São\ João\ Del\ Rei\ \-\ MG",
"55423251", "Papagaios\ Novos\ \-\ PR",
"55222785", "Cardoso\ Moreira\ \-\ RJ",
"55513713", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55613627", "Valparaíso\ de\ Goiás\ \-\ GO",
"55115635", "São\ Paulo\ \-\ SP",
"55823626", "Poço\ das\ Trincheiras\ \-\ AL",
"55813707", "Frei\ Miguelinho\ \-\ PE",
"55853048", "Fortaleza\ \-\ CE",
"55513695", "Harmonia\ \-\ RS",
"55543359", "Vila\ Maria\ \-\ RS",
"55493532", "Tangará\ \-\ SC",
"55222734", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55193775", "Campinas\ \-\ SP",
"55823028", "Maceió\ \-\ AL",
"55773441", "Brumado\ \-\ BA",
"55193643", "Vargem\ Grande\ do\ Sul\ \-\ SP",
"55213213", "Rio\ de\ Janeiro\ \-\ RJ",
"55913011", "Paragominas\ \-\ PA",
"55683327", "Assis\ Brasil\ \(Vila\)\ \-\ AC",
"55193516", "Campinas\ \-\ SP",
"55273251", "Serra\ \-\ ES",
"55613395", "Santa\ Maria\ \-\ DF",
"55373301", "Divinópolis\ \-\ MG",
"55153324", "Tatuí\ \-\ SP",
"55114735", "Mogi\ das\ Cruzes\ \-\ SP",
"55643901", "Itumbiara\ \-\ GO",
"55114961", "Itupeva\ \-\ SP",
"55913265", "Ananindeua\ \-\ PA",
"55673258", "Taunay\ \-\ MS",
"55623584", "Aparecida\ de\ Goiânia\ \-\ GO",
"55212669", "Nova\ Iguaçu\ \-\ RJ",
"55153376", "Itapetininga\ \-\ SP",
"55453264", "Medianeira\ \-\ PR",
"55713264", "Salvador\ \-\ BA",
"55493246", "Fraiburgo\ \-\ SC",
"55213632", "Magé\ \-\ RJ",
"55513549", "Igrejinha\ \-\ RS",
"55883581", "Iguatu\ \-\ CE",
"55443201", "Campo\ Mourão\ \-\ PR",
"55413112", "Curitiba\ \-\ PR",
"55853123", "Caucaia\ \-\ CE",
"55623609", "Goiânia\ \-\ GO",
"55313839", "Itabira\ \-\ MG",
"55773415", "Ituaçu\ \-\ BA",
"55114134", "Barueri\ \-\ SP",
"55883536", "Lavras\ da\ Mangabeira\ \-\ CE",
"55873885", "Mirandiba\ \-\ PE",
"55193846", "Vinhedo\ \-\ SP",
"55753522", "Castro\ Alves\ \-\ BA",
"55464054", "Francisco\ Beltrão\ \-\ PR",
"5511273", "São\ Paulo\ \-\ SP",
"55313442", "Minas\ Gerais",
"55513625", "Capão\ da\ Canoa\ \-\ RS",
"55193458", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55273076", "Cariacica\ \-\ ES",
"55114292", "Suzano\ \-\ SP",
"55613697", "Taboquinha\ \-\ GO",
"55513179", "Taquara\ \-\ RS",
"55163667", "Cajuru\ \-\ SP",
"55543523", "Barão\ de\ Cotegipe\ \-\ RS",
"55163111", "Franca\ \-\ SP",
"55623683", "Santa\ Bárbara\ de\ Goiás\ \-\ GO",
"55873834", "Poção\ \-\ PE",
"55213568", "Niterói\ \-\ RJ",
"55624105", "Senador\ Canedo\ \-\ GO",
"55153394", "Ibiúna\ \-\ SP",
"55613906", "Luziânia\ \-\ GO",
"55542992", "Caxias\ do\ Sul\ \-\ RS",
"55313733", "Joaquim\ Murtinho\ \-\ MG",
"55273332", "Vitória\ \-\ ES",
"55513671", "Camaquã\ \-\ RS",
"55113603", "Osasco\ \-\ SP",
"55993552", "Colinas\ \-\ MA",
"55673671", "Dourados\ \-\ MS",
"55483033", "Palhoça\ \-\ SC",
"55193544", "Araras\ \-\ SP",
"55613561", "Taguatinga\ \-\ DF",
"5555321", "Santa\ Maria\ \-\ RS",
"55173553", "São\ João\ de\ Itaguaçu\ \-\ SP",
"55813577", "Sirinhaém\ \-\ PE",
"55413582", "Curitiba\ \-\ PR",
"55513387", "Rio\ Grande\ do\ Sul",
"55633375", "Pindorama\ do\ Tocantins\ \-\ TO",
"55153384", "Cerquilho\ \-\ SP",
"55143355", "Manduri\ \-\ SP",
"55883667", "Itarema\ \-\ CE",
"55312", "Minas\ Gerais",
"55483464", "Lauro\ Muller\ \-\ SC",
"55313123", "Belo\ Horizonte\ \-\ MG",
"55473464", "Joinville\ \-\ SC",
"55883111", "Sobral\ \-\ CE",
"55613190", "Brasília\ \-\ DF",
"55914006", "Belém\ \-\ PA",
"55222771", "Rio\ das\ Ostras\ \-\ RJ",
"55213037", "Nova\ Iguaçu\ \-\ RJ",
"55543472", "São\ Valentim\ do\ Sul\ \-\ RS",
"55313843", "Antônio\ Dias\ \-\ MG",
"55623524", "Goiânia\ \-\ GO",
"55753241", "Santo\ Amaro\ \-\ BA",
"55433260", "Guaraci\ \-\ PR",
"55452103", "Toledo\ \-\ PR",
"55883619", "Forquilha\ \-\ CE",
"55463234", "Bom\ Sucesso\ do\ Sul\ \-\ PR",
"55413061", "Curitiba\ \-\ PR",
"55323452", "Itamarati\ de\ Minas\ \-\ MG",
"55793045", "Aracaju\ \-\ SE",
"55123607", "Tremembé\ \-\ SP",
"55143846", "Areiópolis\ \-\ SP",
"55112528", "São\ Paulo\ \-\ SP",
"55113191", "São\ Paulo\ \-\ SP",
"55633478", "Filadélfia\ \-\ TO",
"55114811", "Franco\ da\ Rocha\ \-\ SP",
"55483049", "São\ José\ \-\ SC",
"55823422", "Cacimbinhas\ \-\ AL",
"55813319", "São\ Lourenço\ da\ Mata\ \-\ PE",
"55143458", "Queiroz\ \-\ SP",
"55633321", "Araguaína\ \-\ TO",
"55193801", "Indaiatuba\ \-\ SP",
"55863303", "Teresina\ \-\ PI",
"55173547", "Itajobi\ \-\ SP",
"55313268", "Minas\ Gerais",
"55843664", "Natal\ \-\ RN",
"55643438", "Domiciano\ Ribeiro\ \-\ GO",
"55443246", "Maringá\ \-\ PR",
"55153335", "Sorocaba\ \-\ SP",
"55313749", "Ouro\ Branco\ \-\ MG",
"55114282", "São\ Paulo\ \-\ SP",
"55823686", "Xingó\ \-\ AL",
"55454001", "Cascavel\ \-\ PR",
"55833208", "João\ Pessoa\ \-\ PB",
"55623366", "Mara\ Rosa\ \-\ GO",
"55953532", "Caracaraí\ \-\ RR",
"55733266", "Itarantim\ \-\ BA",
"55313857", "Dom\ Silvério\ \-\ MG",
"55663556", "Juara\ \-\ MT",
"55733222", "Ilhéus\ \-\ BA",
"55913721", "Castanhal\ \-\ PA",
"55843672", "Natal\ \-\ RN",
"55242225", "Petrópolis\ \-\ RJ",
"55443687", "Maripá\ \-\ PR",
"55833378", "Campo\ de\ Santana\ \-\ PB",
"55614102", "Brasília\ \-\ DF",
"55713121", "Camaçari\ \-\ BA",
"55833421", "Patos\ \-\ PB",
"55163026", "Franca\ \-\ SP",
"55623085", "Aparecida\ de\ Goiânia\ \-\ GO",
"55772102", "Vitória\ da\ Conquista\ \-\ BA",
"55183928", "Presidente\ Prudente\ \-\ SP",
"55863273", "Curralinhos\ \-\ PI",
"55843338", "Carnaubais\ \-\ RN",
"55473635", "São\ Bento\ do\ Sul\ \-\ SC",
"55413384", "São\ José\ dos\ Pinhais\ \-\ PR",
"55373512", "Divinópolis\ \-\ MG",
"55323348", "Cipotânea\ \-\ MG",
"55743657", "Lapão\ \-\ BA",
"55893494", "Paes\ Landim\ \-\ PI",
"55973343", "Tefé\ \-\ AM",
"55273115", "Linhares\ \-\ ES",
"55613467", "Brasília\ \-\ DF",
"55242443", "Barra\ do\ Piraí\ \-\ RJ",
"55143342", "Chavantes\ \-\ SP",
"55383234", "São\ João\ da\ Ponte\ \-\ MG",
"55353471", "Santa\ Rita\ do\ Sapucaí\ \-\ MG",
"55473472", "Joinville\ \-\ SC",
"55663489", "Ribeirão\ Cascalheira\ \-\ MT",
"55373234", "São\ Gonçalo\ do\ Pará\ \-\ MG",
"55313508", "Belo\ Horizonte\ \-\ MG",
"55493325", "São\ Carlos\ \-\ SC",
"55853358", "Tururu\ \-\ CE",
"55512125", "Porto\ Alegre\ \-\ RS",
"55913775", "Santo\ Antônio\ do\ Tauá\ \-\ PA",
"55242271", "Sapucaia\ \-\ RJ",
"55823253", "Novo\ Lino\ \-\ AL",
"55183406", "Guararapes\ \-\ SP",
"55212132", "Rio\ de\ Janeiro\ \-\ RJ",
"55273746", "Alto\ Rio\ Novo\ \-\ ES",
"55242457", "Santa\ Isabel\ do\ Rio\ Preto\ \-\ RJ",
"55843435", "Florânia\ \-\ RN",
"55123413", "Taubaté\ \-\ SP",
"55323445", "Argirita\ \-\ MG",
"55983357", "Matinha\ \-\ MA",
"55342106", "Patos\ de\ Minas\ \-\ MG",
"55743643", "Mulungu\ do\ Morro\ \-\ BA",
"55493561", "Caçador\ \-\ SC",
"55543464", "Garibaldi\ \-\ RS",
"55312535", "Belo\ Horizonte\ \-\ MG",
"55653342", "Denise\ \-\ MT",
"55513898", "Porto\ Alegre\ \-\ RS",
"55963116", "Santana\ \-\ AP",
"55893435", "Francisco\ Macedo\ \-\ PI",
"5519363", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55693582", "Cujubim\ \-\ RO",
"55713504", "Lauro\ de\ Freitas\ \-\ BA",
"55623280", "Aparecida\ de\ Goiânia\ \-\ GO",
"55424062", "Ponta\ Grossa\ \-\ PR",
"5532", "Minas\ Gerais",
"55173441", "General\ Salgado\ \-\ SP",
"5511362", "São\ Paulo\ \-\ SP",
"55143265", "Piratininga\ \-\ SP",
"55183441", "Araçatuba\ \-\ SP",
"55543033", "Nova\ Petrópolis\ \-\ RS",
"55793643", "Riachão\ do\ Dantas\ \-\ SE",
"55623463", "Mimoso\ de\ Goiás\ \-\ GO",
"55663499", "Araguaiana\ \-\ MT",
"55473523", "Lontras\ \-\ SC",
"55483523", "Maracajá\ \-\ SC",
"55212722", "Niterói\ \-\ RJ",
"5511467", "Ferraz\ de\ Vasconcelos\ \-\ SP",
"55443906", "Umuarama\ \-\ PR",
"55883628", "Santa\ Quitéria\ \-\ CE",
"55933514", "Brasil\ Novo\ \-\ PA",
"55513708", "Sinimbu\ \-\ RS",
"55753659", "Salinas\ da\ Margarida\ \-\ BA",
"55993545", "São\ Domingos\ do\ Azeitão\ \-\ MA",
"55623095", "Goiânia\ \-\ GO",
"55913131", "Belém\ \-\ PA",
"55673440", "Amandina\ \-\ MS",
"55813471", "Recife\ \-\ PE",
"55923311", "Cacau\ Pirêra\ \-\ AM",
"55743639", "Várzea\ do\ Poço\ \-\ BA",
"55513440", "Rio\ Grande\ do\ Sul",
"55553414", "Uruguaiana\ \-\ RS",
"55283534", "Anchieta\ \-\ ES",
"55653265", "Conquista\ D\'Oeste\ \-\ MT",
"55213208", "Rio\ de\ Janeiro\ \-\ RJ",
"55713272", "Salvador\ \-\ BA",
"55313358", "Contagem\ \-\ MG",
"55943786", "Breu\ Branco\ \-\ PA",
"55843229", "São\ Gonçalo\ do\ Amarante\ \-\ RN",
"55733679", "Porto\ Seguro\ \-\ BA",
"55343259", "Uberlândia\ \-\ MG",
"55893484", "Campinas\ do\ Piauí\ \-\ PI",
"55343818", "Patos\ de\ Minas\ \-\ MG",
"55443428", "Graciosa\ \-\ PR",
"5517332", "Barretos\ \-\ SP",
"55183273", "Álvares\ Machado\ \-\ SP",
"55413032", "Campo\ Largo\ \-\ PR",
"55274104", "Cariacica\ \-\ ES",
"55323283", "Rio\ Preto\ \-\ MG",
"55854003", "Fortaleza\ \-\ CE",
"55423633", "Mato\ Rico\ \-\ PR",
"55114014", "Morungaba\ \-\ SP",
"55883427", "Boa\ Viagem\ \-\ CE",
"55213610", "Niterói\ \-\ RJ",
"5531374", "Minas\ Gerais",
"55473624", "Canoinhas\ \-\ SC",
"55183602", "Gabriel\ Monteiro\ \-\ SP",
"5511369", "Osasco\ \-\ SP",
"55813495", "Olinda\ \-\ PE",
"55483624", "Jaguaruna\ \-\ SC",
"55373271", "Pitangui\ \-\ MG",
"55473359", "Botuverá\ \-\ SC",
"55353434", "Itapeva\ \-\ MG",
"55453272", "Diamante\ D\'Oeste\ \-\ PR",
"55212792", "Nilópolis\ \-\ RJ",
"55793544", "Itabaianinha\ \-\ SE",
"55312146", "Sete\ Lagoas\ \-\ MG",
"55112621", "São\ Paulo\ \-\ SP",
"55333089", "Governador\ Valadares\ \-\ MG",
"55643522", "Itumbiara\ \-\ GO",
"55112849", "São\ Paulo\ \-\ SP",
"55312524", "Contagem\ \-\ MG",
"55633449", "Tupiratins\ \-\ TO",
"55413659", "Tunas\ \-\ PR",
"55833481", "Água\ Branca\ \-\ PB",
"55553267", "Ivorá\ \-\ RS",
"55443627", "São\ Lourenço\ \-\ PR",
"55733282", "Santa\ Cruz\ Cabrália\ \-\ BA",
"55913781", "Cametá\ \-\ PA",
"55343454", "Carneirinho\ \-\ MG",
"55833436", "Vista\ Serrana\ \-\ PB",
"55163902", "Ribeirão\ Preto\ \-\ SP",
"55623382", "Fazenda\ Nova\ \-\ GO",
"55113264", "Salvador\ \-\ BA",
"55133852", "Ariri\ \-\ SP",
"55115049", "São\ Paulo\ \-\ SP",
"55843424", "Ipueira\ \-\ RN",
"55493334", "Saudades\ \-\ SC",
"55843299", "Coronel\ Ezequiel\ \-\ RN",
"55153522", "Itapeva\ \-\ SP",
"55283310", "Castelo\ \-\ ES",
"55373225", "Nova\ Serrana\ \-\ MG",
"55843476", "Santana\ do\ Seridó\ \-\ RN",
"55433252", "Arapongas\ \-\ PR",
"55314003", "Belo\ Horizonte\ \-\ MG",
"55123221", "Caçapava\ \-\ SP",
"55983655", "Zé\ Doca\ \-\ MA",
"55733292", "Teixeira\ de\ Freitas\ \-\ BA",
"55873031", "Petrolina\ \-\ PE",
"5516361", "Ribeirão\ Preto\ \-\ SP",
"55553401", "Uruguaiana\ \-\ RS",
"55314138", "Vespasiano\ \-\ MG",
"555131", "Rio\ Grande\ do\ Sul",
"55413637", "Bugre\ \-\ PR",
"55613214", "Brasília\ \-\ DF",
"55813434", "Paulista\ \-\ PE",
"55183998", "João\ Ramalho\ \-\ SP",
"55493627", "Paraíso\ \-\ SC",
"55333728", "Bandeira\ \-\ MG",
"55114852", "Santo\ André\ \-\ SP",
"55673465", "Jateí\ \-\ MS",
"55423649", "Guará\ \-\ PR",
"55513465", "Canoas\ \-\ RS",
"55713699", "Saubara\ \-\ BA",
"55843289", "Serra\ de\ São\ Bento\ \-\ RN",
"55753335", "Andaraí\ \-\ BA",
"55893424", "Paquetá\ \-\ PI",
"5511368", "Osasco\ \-\ SP",
"55473337", "Blumenau\ \-\ SC",
"55613532", "Brasília\ \-\ DF",
"55433564", "Quatiguá\ \-\ PR",
"55383842", "Salinas\ \-\ MG",
"55312101", "Belo\ Horizonte\ \-\ MG",
"55273361", "Guarapari\ \-\ ES",
"55323293", "Liberdade\ \-\ MG",
"55123962", "Jacareí\ \-\ SP",
"55243323", "Barra\ Mansa\ \-\ RJ",
"55913544", "Oriximiná\ \-\ PA",
"55283525", "Jaciguá\ \-\ ES",
"55143004", "Bauru\ \-\ SP",
"55153241", "Ibiúna\ \-\ SP",
"55483583", "Balneário\ Gaivota\ \-\ SC",
"55113552", "São\ Paulo\ \-\ SP",
"55513368", "Rio\ Grande\ do\ Sul",
"55753438", "São\ Félix\ \-\ BA",
"55833213", "João\ Pessoa\ \-\ PB",
"55633433", "Palmeiras\ do\ Tocantins\ \-\ TO",
"55453545", "Foz\ do\ Iguaçu\ \-\ PR",
"55333528", "Teófilo\ Otoni\ \-\ MG",
"55963689", "Afuá\ \-\ PA",
"55353267", "Paraguaçu\ \-\ MG",
"55833558", "Cachoeira\ dos\ Índios\ \-\ PB",
"55493551", "Joaçaba\ \-\ SC",
"55933534", "Prainha\ \-\ PA",
"55773664", "Paratinga\ \-\ BA",
"55273232", "Vitória\ \-\ ES",
"55273771", "São\ Mateus\ \-\ ES",
"55983367", "Humberto\ de\ Campos\ \-\ MA",
"55153294", "Ibiúna\ \-\ SP",
"55633542", "Silvanópolis\ \-\ TO",
"55183289", "Tarabai\ \-\ SP",
"55643051", "Rio\ Verde\ \-\ GO",
"55863299", "Hugo\ Napoleão\ \-\ PI",
"55823263", "Marechal\ Deodoro\ \-\ AL",
"55673297", "Chapadão\ do\ Baús\ \-\ MS",
"55353858", "Santana\ da\ Vargem\ \-\ MG",
"55893415", "Picos\ \-\ PI",
"55733683", "Guarani\ \-\ BA",
"55273194", "Vitória\ \-\ ES",
"55513778", "Rio\ Grande\ do\ Sul",
"55693235", "Porto\ Velho\ \-\ RO",
"55353446", "Albertina\ \-\ MG",
"55273725", "Itaguaçu\ \-\ ES",
"55833444", "São\ Bento\ \-\ PB",
"55323426", "Miraí\ \-\ MG",
"55123832", "Ubatuba\ \-\ SP",
"55943364", "Vila\ Mandii\ \-\ PA",
"55913744", "Santa\ Isabel\ do\ Pará\ \-\ PA",
"55743667", "Piritiba\ \-\ BA",
"55243379", "Angra\ dos\ Reis\ \-\ RJ",
"55423232", "Castro\ \-\ PR",
"55433311", "Rolândia\ \-\ PR",
"55663522", "São\ Félix\ do\ Araguaia\ \-\ MT",
"55493346", "Quilombo\ \-\ SC",
"55113437", "Guarulhos\ \-\ SP",
"55173203", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55133382", "Guarujá\ \-\ SP",
"55613271", "Belo\ Horizonte\ \-\ MG",
"55743619", "Jaguarari\ \-\ BA",
"55512101", "Porto\ Alegre\ \-\ RS",
"55682101", "Rio\ Branco\ \-\ AC",
"55114025", "Itu\ \-\ SP",
"55833308", "Santo\ André\ \-\ PB",
"55493301", "Concórdia\ \-\ SC",
"55213923", "Rio\ de\ Janeiro\ \-\ RJ",
"55213787", "Seropédica\ \-\ RJ",
"55343269", "Ituiutaba\ \-\ MG",
"55833612", "João\ Pessoa\ \-\ PB",
"55383532", "Diamantina\ \-\ MG",
"55133392", "Guarujá\ \-\ SP",
"55714101", "Salvador\ \-\ BA",
"55313828", "Minas\ Gerais",
"55813446", "Recife\ \-\ PE",
"5511589", "São\ Paulo\ \-\ SP",
"55115818", "São\ Paulo\ \-\ SP",
"55993574", "Fortuna\ \-\ MA",
"55713105", "Salvador\ \-\ BA",
"55473402", "Joinville\ \-\ SC",
"55753669", "Ponte\ 2\ de\ Julho\ \-\ BA",
"55743536", "Casa\ Nova\ \-\ BA",
"55923663", "Manaus\ \-\ AM",
"55684003", "Rio\ Branco\ \-\ AC",
"55514003", "Porto\ Alegre\ \-\ RS",
"55753341", "João\ Amaro\ \-\ BA",
"55313578", "Piedade\ dos\ Gerais\ \-\ MG",
"55674003", "Campo\ Grande\ \-\ MS",
"55114912", "São\ Paulo\ \-\ SP",
"55753161", "Feira\ de\ Santana\ \-\ BA",
"55443551", "Iracema\ do\ Oeste\ \-\ PR",
"55863289", "São\ Gonçalo\ do\ Piauí\ \-\ PI",
"55673287", "Porto\ Murtinho\ \-\ MS",
"55383214", "Montes\ Claros\ \-\ MG",
"55453550", "São\ Jorge\ \-\ PR",
"55373214", "Divinópolis\ \-\ MG",
"553131", "Minas\ Gerais",
"55193902", "Holambra\ \-\ SP",
"55193031", "Campinas\ \-\ SP",
"55153284", "Cerquilho\ \-\ SP",
"55424052", "Guarapuava\ \-\ PR",
"55213137", "Rio\ de\ Janeiro\ \-\ RJ",
"55553328", "Fortaleza\ dos\ Valos\ \-\ RS",
"55643489", "Água\ Limpa\ \-\ GO",
"55433262", "Assaí\ \-\ PR",
"5598323", "São\ Luís\ \-\ MA",
"55653026", "Várzea\ Grande\ \-\ MT",
"55613234", "Guará\ \-\ DF",
"5516363", "Ribeirão\ Preto\ \-\ SP",
"55553257", "São\ Vicente\ do\ Sul\ \-\ RS",
"55663582", "Gaúcha\ do\ Norte\ \-\ MT",
"55313898", "Cajuri\ \-\ MG",
"55433304", "Londrina\ \-\ PR",
"55133862", "Colonização\ \-\ SP",
"55223829", "Laje\ do\ Muriaé\ \-\ RJ",
"55413669", "Pinhais\ \-\ PR",
"55112813", "São\ Paulo\ \-\ SP",
"55542106", "Erechim\ \-\ RS",
"55193487", "Santa\ Maria\ da\ Serra\ \-\ SP",
"55533029", "Pelotas\ \-\ RS",
"55114256", "Suzano\ \-\ SP",
"55114280", "Cotia\ \-\ SP",
"55483641", "Tijucas\ \-\ SC",
"55473641", "Mafra\ \-\ SC",
"5541342", "Paranaguá\ \-\ PR",
"55753418", "Alagoinhas\ \-\ BA",
"55543237", "Bom\ Jesus\ \-\ RS",
"55114463", "Santo\ André\ \-\ SP",
"551155", "São\ Paulo\ \-\ SP",
"55483369", "Florianópolis\ \-\ SC",
"55454101", "Cascavel\ \-\ PR",
"55133034", "Praia\ Grande\ \-\ SP",
"55373246", "Igaratinga\ \-\ MG",
"55413556", "São\ José\ dos\ Pinhais\ \-\ PR",
"5531381", "Minas\ Gerais",
"55143026", "Ourinhos\ \-\ SP",
"55793365", "Malhada\ dos\ Bois\ \-\ SE",
"55843273", "São\ José\ de\ Mipibu\ \-\ RN",
"55733623", "Firmino\ Alves\ \-\ BA",
"55223723", "Macaé\ \-\ RJ",
"55823420", "Palmeira\ dos\ Índios\ \-\ AL",
"55112719", "São\ Paulo\ \-\ SP",
"55473317", "Indaial\ \-\ SC",
"55183229", "Presidente\ Prudente\ \-\ SP",
"55163342", "Ibitinga\ \-\ SP",
"55553243", "Santana\ do\ Livramento\ \-\ RS",
"55413971", "Matinhos\ \-\ PR",
"55153276", "Sarapuí\ \-\ SP",
"55313440", "Minas\ Gerais",
"55173484", "Monções\ \-\ SP",
"55623932", "Goiânia\ \-\ GO",
"55433345", "Londrina\ \-\ PR",
"55673227", "Anhanduí\ \-\ MS",
"55993531", "Estreito\ \-\ MA",
"55433554", "Congonhinhas\ \-\ PR",
"55213630", "Magé\ \-\ RJ",
"55192119", "Hortolândia\ \-\ SP",
"55383201", "Montes\ Claros\ \-\ MG",
"55373201", "Itaúna\ \-\ MG",
"55543259", "Nova\ Sardenha\ \-\ RS",
"55993586", "Ribamar\ Fiquene\ \-\ MA",
"55913521", "Paragominas\ \-\ PA",
"55413012", "Curitiba\ \-\ PR",
"55114034", "Bragança\ Paulista\ \-\ SP",
"55193026", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55673455", "Rio\ Brilhante\ \-\ MS",
"55193628", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55123102", "Silveiras\ \-\ SP",
"55612323", "Brasília\ \-\ DF",
"55513455", "Rio\ Grande\ do\ Sul",
"55813642", "Condado\ \-\ PE",
"55143487", "Júlio\ Mesquita\ \-\ SP",
"55283546", "Venda\ Nova\ do\ Imigrante\ \-\ ES",
"55113638", "São\ Paulo\ \-\ SP",
"55163265", "Tapinas\ \-\ SP",
"55163972", "Bonfim\ Paulista\ \-\ SP",
"55913468", "Capitão\ Poço\ \-\ PA",
"55733535", "Jitaúna\ \-\ BA",
"55193497", "Limeira\ \-\ SP",
"5575348", "Feira\ de\ Santana\ \-\ BA",
"55663592", "Brasnorte\ \-\ MT",
"55313888", "Minas\ Gerais",
"55413590", "Piraquara\ \-\ PR",
"55673443", "Batayporã\ \-\ MS",
"55243356", "Pinheiral\ \-\ RJ",
"55513443", "Alvorada\ \-\ RS",
"55323025", "Juiz\ de\ Fora\ \-\ MG",
"55493646", "Cunha\ Porã\ \-\ SC",
"55153548", "Itapirapuã\ Paulista\ \-\ SP",
"55484042", "Balneário\ Camboriú\ \-\ SC",
"55643454", "Caldas\ Novas\ \-\ GO",
"55123878", "São\ José\ dos\ Campos\ \-\ SP",
"55213194", "Rio\ de\ Janeiro\ \-\ RJ",
"55823296", "Maragogi\ \-\ AL",
"55423278", "Imbaú\ \-\ PR",
"55114692", "Biritiba\-Mirim\ \-\ SP",
"55213816", "Rio\ de\ Janeiro\ \-\ RJ",
"55613297", "Brasília\ \-\ DF",
"55673225", "Coxim\ \-\ MS",
"5545322", "Cascavel\ \-\ PR",
"55623283", "Aparecida\ de\ Goiânia\ \-\ GO",
"55773202", "Vitória\ da\ Conquista\ \-\ BA",
"55653388", "Várzea\ Grande\ \-\ MT",
"55273278", "Acioli\ \-\ ES",
"55643548", "Itumbiara\ \-\ GO",
"5512312", "Guaratinguetá\ \-\ SP",
"55513457", "Rio\ Grande\ do\ Sul",
"55883401", "Limoeiro\ do\ Norte\ \-\ CE",
"55673457", "Itaporã\ \-\ MS",
"55513271", "Novo\ Hamburgo\ \-\ RS",
"55473520", "Rio\ do\ Sul\ \-\ SC",
"55513732", "Rio\ Grande\ do\ Sul",
"55193495", "Limeira\ \-\ SP",
"55383083", "Montes\ Claros\ \-\ MG",
"55733537", "Ibirataia\ \-\ BA",
"55843552", "Galinhos\ \-\ RN",
"55543294", "Nova\ Roma\ do\ Sul\ \-\ RS",
"55313532", "Betim\ \-\ MG",
"55143495", "Tupã\ \-\ SP",
"55443048", "Sarandi\ \-\ PR",
"55893552", "Guadalupe\ \-\ PI",
"55543284", "Caxias\ do\ Sul\ \-\ RS",
"55753641", "Valença\ \-\ BA",
"55433660", "Lupionópolis\ \-\ PR",
"55122136", "São\ José\ dos\ Campos\ \-\ SP",
"55933527", "Santarém\ \-\ PA",
"55923363", "Manaquiri\ \-\ AM",
"55883446", "Aracati\ \-\ CE",
"55473418", "Joinville\ \-\ SC",
"55212108", "Rio\ de\ Janeiro\ \-\ RJ",
"55513439", "Cachoeirinha\ \-\ RS",
"55743640", "Presidente\ Dutra\ \-\ BA",
"55333433", "São\ José\ do\ Jacuri\ \-\ MG",
"55673439", "Bela\ Vista\ \-\ MS",
"55873858", "Pedra\ \-\ PE",
"55553255", "Jaguari\ \-\ RS",
"55614003", "Brasília\ \-\ DF",
"55543235", "Campestre\ da\ Serra\ \-\ RS",
"55843264", "Taipu\ \-\ RN",
"55113424", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55114474", "Santo\ André\ \-\ SP",
"55793319", "Gracho\ Cardoso\ \-\ SE",
"55533275", "Capão\ do\ Leão\ \-\ RS",
"55193388", "Campinas\ \-\ SP",
"55443646", "Pérola\ Independente\ \-\ PR",
"55114158", "Vargem\ Grande\ Paulista\ \-\ SP",
"55114682", "Juquitiba\ \-\ SP",
"55823286", "Murici\ \-\ AL",
"55843618", "Natal\ \-\ RN",
"55183021", "Birigui\ \-\ SP",
"55343241", "Araguari\ \-\ MG",
"55823231", "Maceió\ \-\ AL",
"55673234", "Corumbá\ \-\ MS",
"55883414", "Quixadá\ \-\ CE",
"55553026", "Santa\ Maria\ \-\ RS",
"55683234", "Capixaba\ \-\ AC",
"55513234", "Rio\ Grande\ do\ Sul",
"55463533", "São\ João\ \-\ PR",
"55812626", "Recife\ \-\ PE",
"55273137", "Vitória\ \-\ ES",
"55143425", "Marília\ \-\ SP",
"55343061", "Patos\ de\ Minas\ \-\ MG",
"55813972", "Recife\ \-\ PE",
"55114027", "Salto\ \-\ SP",
"55813265", "Recife\ \-\ PE",
"55343215", "Uberlândia\ \-\ MG",
"55513192", "Novo\ Hamburgo\ \-\ RS",
"55933597", "Tabocal\ \-\ PA",
"55623445", "Damianópolis\ \-\ GO",
"55753402", "Entre\ Rios\ \-\ BA",
"55243320", "Volta\ Redonda\ \-\ RJ",
"55173254", "Mirassol\ \-\ SP",
"55222758", "São\ Fidélis\ \-\ RJ",
"55633430", "Carmolândia\ \-\ TO",
"55483341", "Palhoça\ \-\ SC",
"55923028", "Manaus\ \-\ AM",
"55413579", "Curitiba\ \-\ PR",
"55473341", "Itajaí\ \-\ SC",
"55443123", "Maringá\ \-\ PR",
"55653257", "Rio\ Branco\ \-\ MT",
"55313246", "Minas\ Gerais",
"55183942", "Gardênia\ \-\ SP",
"55473556", "Santa\ Terezinha\ \-\ SC",
"55143471", "Garça\ \-\ SP",
"5511566", "São\ Paulo\ \-\ SP",
"55843417", "Caicó\ \-\ RN",
"55114496", "Itupeva\ \-\ SP",
"55323322", "Nazareno\ \-\ MG",
"55313419", "Minas\ Gerais",
"5516333", "Araraquara\ \-\ SP",
"55633451", "Rio\ Sono\ \-\ TO",
"55733248", "Itapé\ \-\ BA",
"55623348", "Mozarlândia\ \-\ GO",
"55513285", "Rio\ Grande\ do\ Sul",
"55223854", "Santo\ Antônio\ de\ Pádua\ \-\ RJ",
"55673285", "Jaraguari\ \-\ MS",
"55993563", "Aldeias\ Altas\ \-\ MA",
"55863081", "Teresina\ \-\ PI",
"55493442", "Concórdia\ \-\ SC",
"55513056", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55313712", "Matozinhos\ \-\ MG",
"55114431", "Jundiaí\ \-\ SP",
"55242465", "Mendes\ \-\ RJ",
"55443442", "Guairaçá\ \-\ PR",
"55114486", "Terra\ Preta\ \-\ SP",
"55353265", "Três\ Pontas\ \-\ MG",
"55613358", "Samambaia\ Sul\ \-\ DF",
"55213844", "Nova\ Iguaçu\ \-\ RJ",
"55833261", "Belém\ \-\ PB",
"55823274", "Colônia\ Pindorama\ \-\ AL",
"55173562", "Tabapuã\ \-\ SP",
"55623404", "Assunção\ de\ Goiás\ \-\ GO",
"55833015", "João\ Pessoa\ \-\ PB",
"55773673", "Oliveira\ dos\ Brejinhos\ \-\ BA",
"55413606", "Colombo\ \-\ PR",
"55693237", "Porto\ Velho\ \-\ RO",
"55353011", "Alfenas\ \-\ MG",
"55423651", "Reserva\ do\ Iguaçu\ \-\ PR",
"55983521", "Caxias\ \-\ MA",
"55813342", "Recife\ \-\ PE",
"55673295", "São\ Gabriel\ do\ Oeste\ \-\ MS",
"55323256", "Aracitaba\ \-\ MG",
"55313201", "Belo\ Horizonte\ \-\ MG",
"55463549", "Realeza\ \-\ PR",
"55133279", "Santos\ \-\ SP",
"55193328", "Indaiatuba\ \-\ SP",
"55273313", "São\ Mateus\ \-\ ES",
"55333244", "Galiléia\ \-\ MG",
"55193868", "Estiva\ Gerbi\ \-\ SP",
"55114622", "Santana\ de\ Parnaíba\ \-\ SP",
"55854102", "Fortaleza\ \-\ CE",
"55743665", "Jacobina\ \-\ BA",
"55983468", "São\ Benedito\ do\ Rio\ Preto\ \-\ MA",
"55623978", "Anápolis\ \-\ GO",
"55423630", "Guarapuava\ \-\ PR",
"55173638", "Mesópolis\ \-\ SP",
"55483306", "Florianópolis\ \-\ SC",
"55453218", "Cascavel\ \-\ PR",
"55183638", "Birigui\ \-\ SP",
"55984141", "São\ Luís\ \-\ MA",
"55543276", "Protásio\ Alves\ \-\ RS",
"55223012", "Campos\ dos\ Goytacazes\ \-\ RJ",
"5562", "Goiás",
"55883642", "Moraújo\ \-\ CE",
"55323463", "Volta\ Grande\ \-\ MG",
"55273727", "São\ Gabriel\ da\ Palha\ \-\ ES",
"55433529", "Jacarezinho\ \-\ PR",
"55863254", "Assunção\ do\ Piauí\ \-\ PI",
"55913665", "Benevides\ \-\ PA",
"55423909", "Palmeira\ \-\ PR",
"55113435", "Guarulhos\ \-\ SP",
"55533281", "Pelotas\ \-\ RS",
"55153259", "Tatuí\ \-\ SP",
"55513658", "Charqueadas\ \-\ RS",
"55114978", "Santo\ André\ \-\ SP",
"55333413", "Paulistas\ \-\ MG",
"55133445", "Mongaguá\ \-\ SP",
"55673419", "Angélica\ \-\ MS",
"55182103", "Araçatuba\ \-\ SP",
"55112336", "São\ Paulo\ \-\ SP",
"55493549", "Vargem\ \-\ SC",
"55483438", "Criciúma\ \-\ SC",
"552125", "Rio\ de\ Janeiro\ \-\ RJ",
"55673246", "Terenos\ \-\ MS",
"55773629", "Recife\ \-\ PE",
"55753337", "Utinga\ \-\ BA",
"55513467", "Canoas\ \-\ RS",
"55853182", "Fortaleza\ \-\ CE",
"55493625", "Belmonte\ \-\ SC",
"55673467", "Fátima\ do\ Sul\ \-\ MS",
"55193938", "Indaiatuba\ \-\ SP",
"55313512", "Betim\ \-\ MG",
"55473384", "Rodeio\ \-\ SC",
"55163257", "Cândido\ Rodrigues\ \-\ SP",
"55413635", "São\ José\ dos\ Pinhais\ \-\ PR",
"5513356", "São\ Vicente\ \-\ SP",
"55143642", "Barra\ Bonita\ \-\ SP",
"55213891", "Rio\ de\ Janeiro\ \-\ RJ",
"55133348", "Guarujá\ \-\ SP",
"55793339", "Santana\ do\ São\ Francisco\ \-\ SE",
"55623486", "Colinas\ do\ Sul\ \-\ GO",
"55313234", "Minas\ Gerais",
"55193053", "Leme\ \-\ SP",
"55413472", "Guaratuba\ \-\ PR",
"55843638", "Rio\ do\ Fogo\ \-\ RN",
"55433573", "Guapirama\ \-\ PR",
"55163243", "Monte\ Alto\ \-\ SP",
"55333291", "Coroaci\ \-\ MG",
"55623622", "Goiânia\ \-\ GO",
"55213746", "Mesquita\ \-\ RJ",
"55843372", "Severiano\ Melo\ \-\ RN",
"55313090", "Belo\ Horizonte\ \-\ MG",
"55733656", "Ilhéus\ \-\ BA",
"55312323", "Betim\ \-\ MG",
"55813497", "Recife\ \-\ PE",
"55693464", "Vale\ do\ Paraíso\ \-\ RO",
"55113441", "São\ Paulo\ \-\ SP",
"55883425", "Ibicuitinga\ \-\ CE",
"55143414", "Marília\ \-\ SP",
"55114168", "Barueri\ \-\ SP",
"55193642", "Águas\ da\ Prata\ \-\ SP",
"55313080", "Belo\ Horizonte\ \-\ MG",
"5596322", "Macapá\ \-\ AP",
"55843254", "São\ Pedro\ \-\ RN",
"55333236", "Alpercata\ \-\ MG",
"55173044", "Bebedouro\ \-\ SP",
"55813628", "Limoeiro\ \-\ PE",
"55493533", "Videira\ \-\ SC",
"55413523", "Curitiba\ \-\ PR",
"55213212", "Rio\ de\ Janeiro\ \-\ RJ",
"55443625", "Perobal\ \-\ PR",
"55413873", "Campina\ Grande\ do\ Sul\ \-\ PR",
"55753593", "Heliópolis\ \-\ BA",
"55553265", "Agudo\ \-\ RS",
"55873868", "Afrânio\ \-\ PE",
"55812119", "Recife\ \-\ PE",
"55213534", "Rio\ de\ Janeiro\ \-\ RJ",
"55753676", "São\ Miguel\ das\ Matas\ \-\ BA",
"55513712", "Estrêla\ \-\ RS",
"55383227", "Brasília\ de\ Minas\ \-\ MG",
"55114445", "Caieiras\ \-\ SP",
"55373227", "Nova\ Serrana\ \-\ MG",
"55823260", "Marechal\ Deodoro\ \-\ AL",
"5511332", "São\ Paulo\ \-\ SP",
"55214062", "Rio\ de\ Janeiro\ \-\ RJ",
"55893562", "Bom\ Jesus\ \-\ PI",
"55313295", "Belo\ Horizonte\ \-\ MG",
"55793343", "Pacatuba\ \-\ SE",
"55473394", "Indaial\ \-\ SC",
"55733680", "Ilhéus\ \-\ BA",
"55653053", "Várzea\ Grande\ \-\ MT",
"55753624", "Feira\ de\ Santana\ \-\ BA",
"55993553", "Sucupira\ do\ Riachão\ \-\ MA",
"55413624", "Agudos\ do\ Sul\ \-\ PR",
"55312559", "Contagem\ \-\ MG",
"55173016", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55113602", "Osasco\ \-\ SP",
"55123003", "São\ José\ dos\ Campos\ \-\ SP",
"55273333", "Vitória\ \-\ ES",
"55443258", "Munhoz\ de\ Melo\ \-\ PR",
"55143267", "Borebi\ \-\ SP",
"55493634", "Iporã\ do\ Oeste\ \-\ SC",
"55833035", "João\ Pessoa\ \-\ PB",
"55953625", "Boa\ Vista\ \-\ RR",
"55823204", "Chã\ Preta\ \-\ AL",
"55343429", "Frutal\ \-\ MG",
"55223864", "Aperibé\ \-\ RJ",
"55473130", "Joinville\ \-\ SC",
"55473901", "Blumenau\ \-\ SC",
"55213980", "Rio\ de\ Janeiro\ \-\ RJ",
"55413676", "Campina\ Grande\ do\ Sul\ \-\ PR",
"55633461", "Brasilândia\ do\ Tocantins\ \-\ TO",
"55193401", "Piracicaba\ \-\ SP",
"55543522", "Erechim\ \-\ RS",
"55313732", "Congonhas\ \-\ MG",
"55115061", "São\ Paulo\ \-\ SP",
"55133209", "Santos\ \-\ SP",
"55173264", "Bálsamo\ \-\ SP",
"55473376", "Jaraguá\ do\ Sul\ \-\ SC",
"55183264", "Iepê\ \-\ SP",
"55222768", "Quissamã\ \-\ RJ",
"55112861", "São\ Paulo\ \-\ SP",
"55112321", "São\ Paulo\ \-\ SP",
"55313443", "Minas\ Gerais",
"55993547", "São\ Raimundo\ das\ Mangabeiras\ \-\ MA",
"55623097", "Aparecida\ de\ Goiânia\ \-\ GO",
"55483659", "Pedras\ Grandes\ \-\ SC",
"55183302", "Assis\ \-\ SP",
"55163434", "Ribeirão\ Preto\ \-\ SP",
"55483324", "Florianópolis\ \-\ SC",
"55173302", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55213633", "Guapimirim\ \-\ RJ",
"55113988", "Guarulhos\ \-\ SP",
"55813255", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55753694", "Santanópolis\ \-\ BA",
"55773689", "Rosário\ \-\ BA",
"55413113", "Campo\ Largo\ \-\ PR",
"55453238", "Ibema\ \-\ PR",
"55623087", "Goiânia\ \-\ GO",
"55813086", "Recife\ \-\ PE",
"55673668", "Paranaíba\ \-\ MS",
"55513668", "Palmares\ do\ Sul\ \-\ RS",
"55863264", "José\ de\ Freitas\ \-\ PI",
"55813031", "Recife\ \-\ PE",
"55343235", "Uberlândia\ \-\ MG",
"55163398", "Fazenda\ Babilônia\ \-\ SP",
"55443685", "Nova\ Olímpia\ \-\ PR",
"55634009", "Palmas\ \-\ TO",
"55115112", "São\ Paulo\ \-\ SP",
"55613578", "Brasília\ \-\ DF",
"55823423", "Igaci\ \-\ AL",
"55613465", "Brasília\ \-\ DF",
"55753684", "Ichu\ \-\ BA",
"55353698", "Alfenas\ \-\ MG",
"55323453", "Dona\ Eusébia\ \-\ MG",
"55883434", "Ererê\ \-\ CE",
"55743655", "Central\ \-\ BA",
"55373287", "Perdigão\ \-\ MG",
"55973458", "Pauini\ \-\ AM",
"55863302", "Teresina\ \-\ PI",
"55683214", "Rio\ Branco\ \-\ AC",
"55913777", "Ponta\ de\ Pedras\ \-\ PA",
"55793288", "Areia\ Branca\ \-\ SE",
"55753635", "Mutuípe\ \-\ BA",
"55372101", "Divinópolis\ \-\ MG",
"55382101", "Montes\ Claros\ \-\ MG",
"55452102", "Foz\ do\ Iguaçu\ \-\ PR",
"55493327", "Nova\ Itaberaba\ \-\ SC",
"55313842", "Coronel\ Fabriciano\ \-\ MG",
"55193858", "Engenheiro\ Coelho\ \-\ SP",
"55833477", "Livramento\ \-\ PB",
"55114209", "Barueri\ \-\ SP",
"55713177", "Salvador\ \-\ BA",
"55423661", "Porto\ Barreiro\ \-\ PR",
"55313439", "Minas\ Gerais",
"55333221", "Governador\ Valadares\ \-\ MG",
"5561354", "Brasília\ \-\ DF",
"55493258", "Cerro\ Negro\ \-\ SC",
"55833251", "João\ Pessoa\ \-\ PB",
"55183552", "Pracinha\ \-\ SP",
"55613368", "Brasília\ \-\ DF",
"55213525", "Rio\ de\ Janeiro\ \-\ RJ",
"55173552", "Urupês\ \-\ SP",
"55323447", "Leopoldina\ \-\ MG",
"55513066", "Novo\ Hamburgo\ \-\ RS",
"55983355", "Cajapió\ \-\ MA",
"55443634", "São\ Jorge\ do\ Patrocínio\ \-\ PR",
"55813688", "São\ José\ da\ Coroa\ Grande\ \-\ PE",
"55433626", "Jundiaí\ do\ Sul\ \-\ PR",
"55343284", "Araporã\ \-\ MG",
"55843437", "Lagoa\ Nova\ \-\ RN",
"55893459", "Patos\ do\ Piauí\ \-\ PI",
"55663436", "Poxoréo\ \-\ MT",
"55353296", "Fama\ \-\ MG",
"55114009", "São\ Paulo\ \-\ SP",
"55863216", "Teresina\ \-\ PI",
"55193019", "Mogi\-Guaçu\ \-\ SP",
"55643558", "Itumbiara\ \-\ GO",
"55212632", "Guapimirim\ \-\ RJ",
"55112136", "Jundiaí\ \-\ SP",
"55513447", "Alvorada\ \-\ RS",
"55913823", "Americano\ \-\ PA",
"55663481", "Alto\ Araguaia\ \-\ MT",
"55673447", "Novo\ Horizonte\ do\ Sul\ \-\ MS",
"55983396", "Cândido\ Mendes\ \-\ MA",
"55183742", "Ilha\ Solteira\ \-\ SP",
"55773478", "Ribeirão\ do\ Largo\ \-\ BA",
"55433343", "Londrina\ \-\ PR",
"55453377", "Foz\ do\ Iguaçu\ \-\ PR",
"55853382", "Maracanaú\ \-\ CE",
"55313220", "Minas\ Gerais",
"55513266", "Rio\ Grande\ do\ Sul",
"5519372", "Campinas\ \-\ SP",
"55323532", "Ubá\ \-\ MG",
"55833051", "Campina\ Grande\ \-\ PB",
"55163456", "Ribeirão\ Preto\ \-\ SP",
"55333021", "Governador\ Valadares\ \-\ MG",
"55673453", "Caarapó\ \-\ MS",
"55513453", "Rio\ Grande\ do\ Sul",
"55613411", "Brasília\ \-\ DF",
"55213766", "Nova\ Iguaçu\ \-\ RJ",
"55833429", "São\ Bentinho\ \-\ PB",
"55493656", "Saltinho\ \-\ SC",
"55813231", "Recife\ \-\ PE",
"55153558", "Apiaí\ \-\ SP",
"55114083", "São\ Paulo\ \-\ SP",
"55553362", "Dezesseis\ de\ Novembro\ \-\ RS",
"55643444", "Buriti\ Alegre\ \-\ GO",
"55473135", "Rio\ da\ Anta\ \-\ SC",
"55163263", "Itápolis\ \-\ SP",
"55474052", "Blumenau\ \-\ SC",
"55162111", "Ribeirão\ Preto\ \-\ SP",
"55124158", "Vargem\ Grande\ Paulista\ \-\ SP",
"55913729", "Paragominas\ \-\ PA",
"55472033", "Balneário\ Camboriú\ \-\ SC",
"55713621", "Camaçari\ \-\ BA",
"55123424", "Taubaté\ \-\ SP",
"55733533", "Maracas\ \-\ BA",
"55313392", "Contagem\ \-\ MG",
"55793631", "Lagarto\ \-\ SE",
"55143662", "Bariri\ \-\ SP",
"55943432", "Floresta\ do\ Araguaia\ \-\ PA",
"55833294", "Itapororoca\ \-\ PB",
"55133828", "Registro\ \-\ SP",
"55482108", "Florianópolis\ \-\ SC",
"55743686", "Ibipeba\ \-\ BA",
"55643612", "Rio\ Verde\ \-\ GO",
"55114093", "Diadema\ \-\ SP",
"55743631", "Serrolândia\ \-\ BA",
"55193662", "Caconde\ \-\ SP",
"55633602", "Paraíso\ do\ Tocantins\ \-\ TO",
"5511454", "Mauá\ \-\ SP",
"55433339", "Londrina\ \-\ PR",
"55213520", "Rio\ de\ Janeiro\ \-\ RJ",
"55993621", "Bacabal\ \-\ MA",
"55453038", "Cascavel\ \-\ PR",
"55833284", "Caldas\ Brandão\ \-\ PB",
"55443656", "Alto\ Piquiri\ \-\ PR",
"55114148", "Cotia\ \-\ SP",
"55313382", "Minas\ Gerais",
"55923367", "Iranduba\ \-\ AM",
"55933523", "Santarém\ \-\ PA",
"55343251", "Santa\ Vitória\ \-\ MG",
"55843221", "Natal\ \-\ RN",
"55733671", "Santa\ Cruz\ Cabrália\ \-\ BA",
"55983386", "Guimarães\ \-\ MA",
"55553423", "Quaraí\ \-\ RS",
"55443569", "Juranda\ \-\ PR",
"55193538", "Ajapi\ \-\ SP",
"55483232", "Florianópolis\ \-\ SC",
"55533264", "Praia\ do\ Hermenegildo\ \-\ RS",
"55973331", "Lábrea\ \-\ AM",
"55353286", "Divisa\ Nova\ \-\ MG",
"55614007", "Brasília\ \-\ DF",
"55313912", "Contagem\ \-\ MG",
"55733549", "Manoel\ Vitorino\ \-\ BA",
"55242431", "Piraí\ \-\ RJ",
"55913088", "Belém\ \-\ PA",
"55643405", "Piracanjuba\ \-\ GO",
"55793363", "Canhoba\ \-\ SE",
"55893542", "Landri\ Sales\ \-\ PI",
"55843275", "Vera\ Cruz\ \-\ RN",
"55733625", "Mascote\ \-\ BA",
"55114578", "Mauá\ \-\ SP",
"55753651", "Jiquiriçá\ \-\ BA",
"55313071", "Belo\ Horizonte\ \-\ MG",
"55173832", "General\ Salgado\ \-\ SP",
"55373426", "Campos\ Altos\ \-\ MG",
"55873848", "Custódia\ \-\ PE",
"55114023", "Itu\ \-\ SP",
"55823342", "Maceió\ \-\ AL",
"55883518", "Solonópole\ \-\ CE",
"55473546", "Laurentino\ \-\ SC",
"55115041", "São\ Paulo\ \-\ SP",
"55323201", "Cataguases\ \-\ MG",
"55483546", "Ermo\ \-\ SC",
"55343332", "Uberaba\ \-\ MG",
"55913809", "Inhangapi\ \-\ PA",
"55483330", "Florianópolis\ \-\ SC",
"55463537", "Boa\ Esperança\ do\ Iguaçu\ \-\ PR",
"55473330", "Blumenau\ \-\ SC",
"55693416", "Ji\-Paraná\ \-\ RO",
"55833489", "São\ José\ de\ Caiana\ \-\ PB",
"55413651", "São\ Luiz\ do\ Purunã\ \-\ PR",
"55733258", "Maraú\ \-\ BA",
"55663568", "São\ José\ do\ Xingu\ \-\ MT",
"55713636", "Vera\ Cruz\ \-\ BA",
"55623358", "Santa\ Isabel\ \-\ GO",
"55813274", "Recife\ \-\ PE",
"55223844", "Porciúncula\ \-\ RJ",
"55493452", "Seara\ \-\ SC",
"55843291", "Santa\ Cruz\ \-\ RN",
"55713681", "Vera\ Cruz\ \-\ BA",
"55543210", "Passo\ Fundo\ \-\ RS",
"55933593", "Altamira\ \-\ PA",
"55123672", "Tremembé\ \-\ SP",
"55112354", "São\ Paulo\ \-\ SP",
"55663421", "Rondonópolis\ \-\ MT",
"55713038", "Salvador\ \-\ BA",
"55112841", "São\ Paulo\ \-\ SP",
"5519378", "Campinas\ \-\ SP",
"5561", "Federal\ District",
"55623455", "Povoado\ de\ São\ Jorge\ \-\ GO",
"55993567", "São\ João\ do\ Soter\ \-\ MA",
"55222748", "Travessão\ \-\ RJ",
"55853322", "Ocara\ \-\ CE",
"55473351", "Brusque\ \-\ SC",
"55753278", "Cícero\ Dantas\ \-\ BA",
"55653247", "Reserva\ do\ Cabaçal\ \-\ MT",
"55312109", "Ipatinga\ \-\ MG",
"55353226", "Luminárias\ \-\ MG",
"55313034", "Contagem\ \-\ MG",
"55273369", "Vila\ Velha\ \-\ ES",
"55983326", "Presidente\ Médici\ \-\ MA",
"5521342", "Rio\ de\ Janeiro\ \-\ RJ",
"55883652", "Guaraciaba\ do\ Norte\ \-\ CE",
"55112806", "Diadema\ \-\ SP",
"55383622", "Pedras\ de\ Maria\ da\ Cruz\ \-\ MG",
"55543261", "Farroupilha\ \-\ RS",
"5561337", "Ceilândia\ \-\ DF",
"55863244", "Miguel\ Alves\ \-\ PI",
"55353274", "Olímpio\ Noronha\ \-\ MG",
"5592323", "Manaus\ \-\ AM",
"55373431", "Bambuí\ \-\ MG",
"55543015", "Erechim\ \-\ RS",
"55273317", "Vitória\ \-\ ES",
"55153249", "Ibiúna\ \-\ SP",
"55823265", "Pilar\ \-\ AL",
"55693233", "Triunfo\ \-\ RO",
"55983374", "Santa\ Luzia\ do\ Paruá\ \-\ MA",
"55773677", "Érico\ Cardoso\ \-\ BA",
"55153416", "Votorantim\ \-\ SP",
"55112504", "São\ Paulo\ \-\ SP",
"55273723", "Colatina\ \-\ ES",
"55114888", "Joanópolis\ \-\ SP",
"55883420", "São\ João\ do\ Jaguaribe\ \-\ CE",
"55833499", "Aguiar\ \-\ PB",
"55192516", "Indaiatuba\ \-\ SP",
"5512393", "São\ José\ dos\ Campos\ \-\ SP",
"55443452", "Santa\ Cruz\ de\ Monte\ Castelo\ \-\ PR",
"55743626", "Mundo\ Novo\ \-\ BA",
"55833276", "Pilões\ \-\ PB",
"55163518", "Cravinhos\ \-\ SP",
"55114708", "Mairinque\ \-\ SP",
"55534001", "Pelotas\ \-\ RS",
"55733634", "Ilhéus\ \-\ BA",
"55913482", "Augusto\ Corrêa\ \-\ PA",
"55853463", "Fortaleza\ \-\ CE",
"55993636", "Poção\ de\ Pedras\ \-\ MA",
"55843281", "Nova\ Cruz\ \-\ RN",
"55193466", "Nova\ Odessa\ \-\ SP",
"55473501", "Jaraguá\ do\ Sul\ \-\ SC",
"55743674", "Lajes\ do\ Batata\ \-\ BA",
"55463559", "Quedas\ do\ Iguaçu\ \-\ PR",
"55313862", "Alvorada\ de\ Minas\ \-\ MG",
"55843236", "Natal\ \-\ RN",
"55333254", "Perpétuo\ Socorro\ \-\ MG",
"55313322", "Minas\ Gerais",
"55643416", "Morrinhos\ \-\ GO",
"55814112", "São\ Lourenço\ da\ Mata\ \-\ PE",
"55112835", "São\ Caetano\ do\ Sul\ \-\ SP",
"55143652", "Dois\ Córregos\ \-\ SP",
"55423523", "União\ da\ Vitória\ \-\ PR",
"55983653", "Santa\ Inês\ \-\ MA",
"55433367", "Londrina\ \-\ PR",
"55633484", "Campos\ Lindos\ \-\ TO",
"55823628", "Monteirópolis\ \-\ AL",
"55483534", "Santa\ Rosa\ do\ Sul\ \-\ SC",
"55473534", "Agrolândia\ \-\ SC",
"55484062", "Florianópolis\ \-\ SC",
"55553352", "São\ Luiz\ Gonzaga\ \-\ RS",
"55163253", "Taquaritinga\ \-\ SP",
"55474062", "Joinville\ \-\ SC",
"55133227", "Santos\ \-\ SP",
"55913119", "Belém\ \-\ PA",
"55673463", "Juti\ \-\ MS",
"55513463", "Rio\ Grande\ do\ Sul",
"55683463", "Feijó\ \-\ AC",
"55643632", "Jataí\ \-\ GO",
"5537", "Minas\ Gerais",
"55713644", "Camaçari\ \-\ BA",
"5538", "Minas\ Gerais",
"55243371", "Paraty\ \-\ RJ",
"55813483", "Olinda\ \-\ PE",
"55213780", "Duque\ de\ Caxias\ \-\ RJ",
"55142104", "Jaú\ \-\ SP",
"55443537", "Engenheiro\ Beltrão\ \-\ PR",
"55543332", "Não\-Me\-Toque\ \-\ RS",
"55643475", "Três\ Ranchos\ \-\ GO",
"55153378", "Pilar\ do\ Sul\ \-\ SP",
"55173812", "Icém\ \-\ SP",
"55513256", "Rio\ Grande\ do\ Sul",
"55323295", "Passa\-Vinte\ \-\ MG",
"55983311", "São\ Luís\ \-\ MA",
"55613027", "Taguatinga\ \-\ DF",
"55243325", "Barra\ Mansa\ \-\ RJ",
"55242411", "Barra\ do\ Piraí\ \-\ RJ",
"55112884", "Mogi\ das\ Cruzes\ \-\ SP",
"55473212", "Brusque\ \-\ SC",
"55863291", "Jardim\ do\ Mulato\ \-\ PI",
"55283523", "Gironda\ \-\ ES",
"55483212", "Florianópolis\ \-\ SC",
"55112704", "São\ Paulo\ \-\ SP",
"55353211", "Passos\ \-\ MG",
"55833215", "João\ Pessoa\ \-\ PB",
"55183281", "Presidente\ Epitácio\ \-\ SP",
"55173281", "Olímpia\ \-\ SP",
"55633435", "Arapoema\ \-\ TO",
"55453543", "Vila\ Ipiranga\ \-\ PR",
"55323285", "Chiador\ \-\ MG",
"55323512", "Juiz\ de\ Fora\ \-\ MG",
"553136", "Minas\ Gerais",
"55933793", "Porto\ de\ Moz\ \-\ PA",
"55423635", "Laranjeiras\ do\ Sul\ \-\ PR",
"55353409", "Lavras\ \-\ MG",
"5531367", "Sabará\ \-\ MG",
"55173291", "Riolândia\ \-\ SP",
"55533254", "Cerrito\ \-\ RS",
"55192104", "Campinas\ \-\ SP",
"55443068", "Campo\ Mourão\ \-\ PR",
"55683322", "Cruzeiro\ do\ Sul\ \-\ AC",
"55492020", "Chapecó\ \-\ SC",
"55115477", "Mogi\ das\ Cruzes\ \-\ SP",
"55863281", "Milton\ Brandão\ \-\ PI",
"55713605", "Candeias\ \-\ BA",
"55112894", "São\ Paulo\ \-\ SP",
"55493537", "Treze\ Tílias\ \-\ SC",
"55663416", "General\ Carneiro\ \-\ MT",
"55613622", "Luziânia\ \-\ GO",
"55793611", "Simão\ Dias\ \-\ SE",
"55343261", "Ituiutaba\ \-\ MG",
"55633494", "Barra\ do\ Ouro\ \-\ TO",
"55115094", "São\ Paulo\ \-\ SP",
"55862107", "Teresina\ \-\ PI",
"55443666", "Herculândia\ \-\ PR",
"55513034", "Sapucaia\ do\ Sul\ \-\ RS",
"55512109", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55193652", "Aguaí\ \-\ SP",
"55923228", "Manaus\ \-\ AM",
"55653057", "Cuiabá\ \-\ MT",
"55843244", "Baía\ Formosa\ \-\ RN",
"55693421", "Ji\-Paraná\ \-\ RO",
"55613486", "Brasília\ \-\ DF",
"55713412", "Salvador\ \-\ BA",
"55793347", "Cedro\ de\ São\ João\ \-\ SE",
"55714109", "Salvador\ \-\ BA",
"55993644", "Lago\ da\ Pedra\ \-\ MA",
"55383223", "Montes\ Claros\ \-\ MG",
"55864020", "Teresina\ \-\ PI",
"55893433", "Monsenhor\ Hipólito\ \-\ PI",
"55963621", "Laranjal\ do\ Jari\ \-\ AP",
"55132101", "Santos\ \-\ SP",
"55353822", "Lavras\ \-\ MG",
"55473361", "Balneário\ Camboriú\ \-\ SC",
"55483821", "Florianópolis\ \-\ SC",
"55143263", "Lençóis\ Paulista\ \-\ SP",
"55543035", "Farroupilha\ \-\ RS",
"55793645", "Boquim\ \-\ SE",
"55273337", "Vitória\ \-\ ES",
"55112876", "Carapicuíba\ \-\ SP",
"55993557", "Nova\ Iorque\ \-\ MA",
"55983262", "São\ Luís\ \-\ MA",
"55473525", "Rio\ do\ Sul\ \-\ SC",
"55483525", "Turvo\ \-\ SC",
"55183221", "Presidente\ Prudente\ \-\ SP",
"55833522", "Sousa\ \-\ PB",
"5511474", "Suzano\ \-\ SP",
"55623578", "Aparecida\ de\ Goiânia\ \-\ GO",
"55242404", "Angra\ dos\ Reis\ \-\ RJ",
"55163662", "Batatais\ \-\ SP",
"55443323", "Colorado\ \-\ PR",
"55313014", "Belo\ Horizonte\ \-\ MG",
"55983304", "São\ Luís\ \-\ MA",
"55313447", "Belo\ Horizonte\ \-\ MG",
"55993543", "Tasso\ Fragoso\ \-\ MA",
"55623093", "Goiânia\ \-\ GO",
"55633424", "Goianorte\ \-\ TO",
"55443248", "Iguaraçu\ \-\ PR",
"55134003", "Praia\ Grande\ \-\ SP",
"55663558", "Santa\ Terezinha\ \-\ MT",
"55733268", "Porto\ Seguro\ \-\ BA",
"55243334", "Rio\ Claro\ \-\ RJ",
"55633476", "Colinas\ do\ Tocantins\ \-\ TO",
"55143848", "Itatinga\ \-\ SP",
"55183275", "Martinópolis\ \-\ SP",
"55313266", "Minas\ Gerais",
"55173275", "Monte\ Aprazível\ \-\ SP",
"55143456", "Oriente\ \-\ SP",
"5512391", "São\ José\ dos\ Campos\ \-\ SP",
"55643491", "Ipameri\ \-\ GO",
"55813362", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"5519352", "Rio\ Claro\ \-\ SP",
"55242223", "Petrópolis\ \-\ RJ",
"55323271", "Bicas\ \-\ MG",
"55953537", "São\ Luiz\ \-\ RR",
"55313852", "João\ Monlevade\ \-\ MG",
"55553286", "Santa\ Maria\ \-\ RS",
"55193848", "Louveira\ \-\ SP",
"5511353", "São\ Paulo\ \-\ SP",
"55713616", "Salvador\ \-\ BA",
"55423676", "Faxinal\ da\ Boa\ Vista\ \-\ PR",
"55193456", "Iracemápolis\ \-\ SP",
"55663405", "Barra\ do\ Garças\ \-\ MT",
"55553231", "Rosário\ do\ Sul\ \-\ RS",
"55443462", "Querência\ do\ Norte\ \-\ PR",
"55813204", "Recife\ \-\ PE",
"55473633", "São\ Bento\ do\ Sul\ \-\ SC",
"55113138", "São\ Paulo\ \-\ SP",
"55493248", "Ponte\ Alta\ \-\ SC",
"55224104", "Macaé\ \-\ RJ",
"55173542", "Novo\ Horizonte\ \-\ SP",
"55983345", "Rosário\ \-\ MA",
"55883538", "Potengi\ \-\ CE",
"55973345", "Alvarães\ \-\ AM",
"55123602", "Taubaté\ \-\ SP",
"55242445", "Barra\ do\ Piraí\ \-\ RJ",
"55693481", "Espigão\ do\ Oeste\ \-\ RO",
"55823427", "Minador\ do\ Negrão\ \-\ AL",
"55893449", "Santo\ Antônio\ de\ Lisboa\ \-\ PI",
"55853014", "Maracanaú\ \-\ CE",
"55153491", "Salto\ de\ Pirapora\ \-\ SP",
"55743529", "Andorinha\ \-\ BA",
"55344004", "Uberlândia\ \-\ MG",
"55833473", "Desterro\ \-\ PB",
"55543477", "Paraí\ \-\ RS",
"55474104", "São\ Bento\ do\ Sul\ \-\ SC",
"55213032", "Rio\ de\ Janeiro\ \-\ RJ",
"55493323", "Chapecó\ \-\ SC",
"55823255", "Colônia\ Leopoldina\ \-\ AL",
"55683025", "Rio\ Branco\ \-\ AC",
"55843433", "Acari\ \-\ RN",
"55673025", "Campo\ Grande\ \-\ MS",
"55543251", "Cambará\ do\ Sul\ \-\ RS",
"55753208", "Campinhos\ \-\ BA",
"55743645", "Campo\ Formoso\ \-\ BA",
"55513382", "Rio\ Grande\ do\ Sul",
"55212768", "Nova\ Iguaçu\ \-\ RJ",
"55553250", "Nova\ Esperança\ do\ Sul\ \-\ RS",
"55413587", "São\ José\ dos\ Pinhais\ \-\ PR",
"55192111", "Rio\ Claro\ \-\ SP",
"55993539", "Vila\ Nova\ dos\ Martírios\ \-\ MA",
"55663407", "Barra\ do\ Garças\ \-\ MT",
"55883409", "Russas\ \-\ CE",
"55413534", "São\ José\ dos\ Pinhais\ \-\ PR",
"55543378", "Ernestina\ \-\ RS",
"55353466", "Munhoz\ \-\ MG",
"55543421", "Gramado\ \-\ RS",
"55193502", "Rio\ Claro\ \-\ SP",
"55873892", "Terra\ Nova\ \-\ PE",
"55483208", "Florianópolis\ \-\ SC",
"55493524", "Água\ Doce\ \-\ SC",
"55853348", "Pacajus\ \-\ CE",
"55242266", "Werneck\ \-\ RJ",
"55443683", "Doutor\ Oliveira\ Castro\ \-\ PR",
"55823425", "Taquarana\ \-\ AL",
"5512362", "Taubaté\ \-\ SP",
"55773644", "Brotas\ de\ Macaúbas\ \-\ BA",
"55273756", "Barra\ de\ São\ Francisco\ \-\ ES",
"55242447", "Barra\ do\ Piraí\ \-\ RJ",
"55513496", "Gravataí\ \-\ RS",
"55543632", "Passo\ Fundo\ \-\ RS",
"55673496", "Ponta\ Porã\ \-\ MS",
"55183788", "Murutinga\ do\ Sul\ \-\ SP",
"55173808", "Engenheiro\ Schimidt\ \-\ SP",
"55743653", "Morro\ do\ Chapéu\ \-\ BA",
"55863277", "Capitão\ de\ Campos\ \-\ PI",
"55133295", "Santos\ \-\ SP",
"55414062", "Curitiba\ \-\ PR",
"55653352", "Nova\ Marilândia\ \-\ MT",
"55513279", "Rio\ Grande\ do\ Sul",
"55823257", "Campestre\ \-\ AL",
"55713555", "Salvador\ \-\ BA",
"55493366", "Pinhalzinho\ \-\ SC",
"55733301", "Itabuna\ \-\ BA",
"55433619", "Ibaiti\ \-\ PR",
"55213694", "Maricá\ \-\ RJ",
"55213779", "Nova\ Iguaçu\ \-\ RJ",
"55633372", "Natividade\ \-\ TO",
"55114234", "São\ Caetano\ do\ Sul\ \-\ SP",
"55943344", "Nova\ Ipixuna\ \-\ PA",
"55913764", "São\ Sebastião\ da\ Boa\ Vista\ \-\ PA",
"55413585", "Curitiba\ \-\ PR",
"55643678", "Israelândia\ \-\ GO",
"55743647", "Jussara\ \-\ BA",
"55983353", "Apicum\-Açu\ \-\ MA",
"55923131", "Manaus\ \-\ AM",
"55973353", "Codajás\ \-\ AM",
"55317", "Minas\ Gerais",
"55833464", "Junco\ do\ Seridó\ \-\ PB",
"55673027", "Campo\ Grande\ \-\ MS",
"55242453", "Valença\ \-\ RJ",
"55713164", "Salvador\ \-\ BA",
"55913311", "Castanhal\ \-\ PA",
"55543568", "Ponte\ Preta\ \-\ RS",
"55143352", "Piraju\ \-\ SP",
"55143226", "Bauru\ \-\ SP",
"55993555", "Pastos\ Bons\ \-\ MA",
"55623467", "Teresina\ de\ Goiás\ \-\ GO",
"55733166", "Eunápolis\ \-\ BA",
"55543037", "Carlos\ Barbosa\ \-\ RS",
"55273335", "Vitória\ \-\ ES",
"55115213", "São\ Paulo\ \-\ SP",
"55513450", "Rio\ Grande\ do\ Sul",
"5531356", "Minas\ Gerais",
"55953623", "Boa\ Vista\ \-\ RR",
"55833033", "Santa\ Rita\ \-\ PB",
"55193352", "Araras\ \-\ SP",
"55114658", "Igaratá\ \-\ SP",
"55443366", "Maringá\ \-\ PR",
"55143274", "Gália\ \-\ SP",
"5585", "Ceará",
"55243387", "Visconde\ de\ Mauá\ \-\ RJ",
"55343249", "Araguari\ \-\ MG",
"55733530", "Entroncamento\ de\ Jaguaquara\ \-\ BA",
"55214139", "Maricá\ \-\ RJ",
"55423438", "Guamiranga\ \-\ PR",
"55483527", "Araranguá\ \-\ SC",
"55212608", "Niterói\ \-\ RJ",
"55733551", "Aurelino\ Leal\ \-\ BA",
"55483877", "Florianópolis\ \-\ SC",
"55873882", "Serrita\ \-\ PE",
"55222030", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55163409", "Franca\ \-\ SP",
"55433062", "Cambé\ \-\ PR",
"55114295", "Suzano\ \-\ SP",
"55443576", "Águas\ de\ Jurema\ \-\ PR",
"55113413", "Itu\ \-\ SP",
"55313445", "Belo\ Horizonte\ \-\ MG",
"55513622", "Arroio\ Teixeira\ \-\ RS",
"55853404", "Fortaleza\ \-\ CE",
"55673431", "Ponta\ Porã\ \-\ MS",
"55513431", "Gravataí\ \-\ RS",
"55173277", "Nipoã\ \-\ SP",
"55183277", "Sandovalina\ \-\ SP",
"55943305", "Bannach\ \-\ PA",
"55893588", "Anísio\ de\ Abreu\ \-\ PI",
"55813253", "Recife\ \-\ PE",
"55443524", "Campo\ Mourão\ \-\ PR",
"55513486", "Morungava\ \-\ RS",
"55773412", "Iramaia\ \-\ BA",
"55663015", "Sinop\ \-\ MT",
"55753649", "Elísio\ Medrado\ \-\ BA",
"55433536", "Ribeirão\ Claro\ \-\ PR",
"55413649", "Campo\ Largo\ \-\ PR",
"55633459", "Buriti\ do\ Tocantins\ \-\ TO",
"55273720", "Itarana\ \-\ ES",
"55143296", "Arealva\ \-\ SP",
"55313411", "Minas\ Gerais",
"55883423", "Limoeiro\ do\ Norte\ \-\ CE",
"55423637", "Nova\ Laranjeiras\ \-\ PR",
"55693251", "Vista\ Alegre\ do\ Abunã\ \-\ RO",
"55854007", "Maracanaú\ \-\ CE",
"55143479", "Avencas\ \-\ SP",
"55133842", "Ilha\ Comprida\ \-\ SP",
"55323287", "Senador\ Cortes\ \-\ MG",
"55493535", "Arroio\ Trinta\ \-\ SC",
"55193772", "Campinas\ \-\ SP",
"55383014", "Montes\ Claros\ \-\ MG",
"55863089", "Teresina\ \-\ PI",
"55712203", "Salvador\ \-\ BA",
"5551330", "Rio\ Grande\ do\ Sul",
"55613392", "Santa\ Maria\ \-\ DF",
"55453305", "Cascavel\ \-\ PR",
"55433242", "Bela\ Vista\ do\ Paraíso\ \-\ PR",
"55112753", "São\ Paulo\ \-\ SP",
"55112664", "Barueri\ \-\ SP",
"55443623", "Umuarama\ \-\ PR",
"55553263", "Faxinal\ do\ Soturno\ \-\ RS",
"55513692", "Camaquã\ \-\ RS",
"5577308", "Vitória\ da\ Conquista\ \-\ BA",
"55115632", "São\ Paulo\ \-\ SP",
"55812126", "Recife\ \-\ PE",
"55473349", "Itajaí\ \-\ SC",
"55114443", "Franco\ da\ Rocha\ \-\ SP",
"55322101", "Juiz\ de\ Fora\ \-\ MG",
"55163204", "Jaboticabal\ \-\ SP",
"55353662", "Maria\ da\ Fé\ \-\ MG",
"55623532", "Senador\ Canedo\ \-\ GO",
"55163142", "São\ José\ da\ Bela\ Vista\ \-\ SP",
"55653055", "Cuiabá\ \-\ MT",
"55963321", "Serra\ do\ Navio\ \-\ AP",
"55693230", "Candeias\ do\ Jamari\ \-\ RO",
"55513474", "Sapucaia\ do\ Sul\ \-\ RS",
"55673474", "Mundo\ Novo\ \-\ MS",
"55333415", "Gonzaga\ \-\ MG",
"55673682", "Camapuã\ \-\ MS",
"55773616", "Formosa\ do\ Rio\ Preto\ \-\ BA",
"55513682", "Balneário\ Pinhal\ \-\ RS",
"55213078", "Rio\ de\ Janeiro\ \-\ RJ",
"55314007", "Belo\ Horizonte\ \-\ MG",
"55112837", "São\ Paulo\ \-\ SP",
"55873822", "Arcoverde\ \-\ PE",
"55443584", "Icaraíma\ \-\ PR",
"55513426", "Canoas\ \-\ RS",
"55273151", "Linhares\ \-\ ES",
"55213113", "Rio\ de\ Janeiro\ \-\ RJ",
"55433145", "Bandeirantes\ \-\ PR",
"55493623", "Descanso\ \-\ SC",
"5511597", "São\ Paulo\ \-\ SP",
"55153251", "Tatuí\ \-\ SP",
"55273324", "Vitória\ \-\ ES",
"55423901", "Ponta\ Grossa\ \-\ PR",
"55433521", "Londrina\ \-\ PR",
"55343612", "Araxá\ \-\ MG",
"55434141", "Londrina\ \-\ PR",
"55793262", "Barra\ dos\ Coqueiros\ \-\ SE",
"55333318", "Caratinga\ \-\ MG",
"55553738", "Caiçara\ \-\ RS",
"55443535", "Jesuítas\ \-\ PR",
"55123302", "São\ José\ dos\ Campos\ \-\ SP",
"55273032", "Vila\ Velha\ \-\ ES",
"55143286", "Lucianópolis\ \-\ SP",
"55433468", "Rio\ Bom\ \-\ PR",
"55353067", "Varginha\ \-\ MG",
"55893461", "Colônia\ do\ Piauí\ \-\ PI",
"55483333", "Florianópolis\ \-\ SC",
"55473333", "Indaial\ \-\ SC",
"55193055", "Pirassununga\ \-\ SP",
"55633437", "Cachoeirinha\ \-\ TO",
"55833217", "Santa\ Rita\ \-\ PB",
"55793304", "Aracaju\ \-\ SE",
"55433575", "Londrina\ \-\ PR",
"55613382", "Guará\ \-\ DF",
"55133271", "Santos\ \-\ SP",
"55913448", "Maracanã\ \-\ PA",
"55513097", "Novo\ Hamburgo\ \-\ RS",
"55423659", "Samambaia\ \-\ PR",
"55813662", "Palmares\ \-\ PE",
"55983363", "Morros\ \-\ MA",
"55172136", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55112303", "Guarulhos\ \-\ SP",
"55333424", "Senhora\ do\ Porto\ \-\ MG",
"55242463", "Engenheiro\ Paulo\ de\ Frontin\ \-\ RJ",
"55833454", "Ibiara\ \-\ PB",
"55753501", "Paulo\ Afonso\ \-\ BA",
"55174009", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55213899", "Rio\ de\ Janeiro\ \-\ RJ",
"55353263", "Monsenhor\ Paulo\ \-\ MG",
"55813738", "Cupira\ \-\ PE",
"55913754", "Barcarena\ \-\ PA",
"55242280", "Petrópolis\ \-\ RJ",
"55733687", "Caravelas\ \-\ BA",
"55823267", "Coqueiro\ Seco\ \-\ AL",
"55493356", "Arvoredo\ \-\ SC",
"55333299", "Açucena\ \-\ MG",
"55843003", "Natal\ \-\ RN",
"55943321", "Marabá\ \-\ PA",
"55543017", "Veranópolis\ \-\ RS",
"55273315", "Vitória\ \-\ ES",
"55773432", "Itambé\ \-\ BA",
"55493541", "Campos\ Novos\ \-\ SC",
"55653362", "Várzea\ Grande\ \-\ MT",
"55543444", "Serafina\ Corrêa\ \-\ RS",
"55673411", "Dourados\ \-\ MS",
"55923581", "Manaus\ \-\ AM",
"55513411", "Alvorada\ \-\ RS",
"55873772", "Correntes\ \-\ PE",
"55613453", "Sobradinho\ \-\ DF",
"55123021", "São\ José\ dos\ Campos\ \-\ SP",
"55323465", "Pirapetinga\ \-\ MG",
"55412108", "Curitiba\ \-\ PR",
"55113433", "Embu\ das\ Artes\ \-\ SP",
"5531330", "Minas\ Gerais",
"55323578", "Guidoval\ \-\ MG",
"55353456", "Natércia\ \-\ MG",
"55143572", "Pirajuí\ \-\ SP",
"55773621", "Cotegipe\ \-\ BA",
"55553538", "Boa\ Vista\ do\ Buricá\ \-\ RS",
"55163231", "Guariba\ \-\ SP",
"55463535", "Verê\ \-\ PR",
"55114066", "Diadema\ \-\ SP",
"55213803", "Niterói\ \-\ RJ",
"55163286", "Ribeirão\ Preto\ \-\ SP",
"55543612", "Muitos\ Capões\ \-\ RS",
"55483278", "São\ José\ \-\ SC",
"55493735", "Fazenda\ Zandavalli\ \-\ SC",
"55193572", "Leme\ \-\ SP",
"55453336", "Luz\ Marina\ \-\ PR",
"55173461", "General\ Salgado\ \-\ SP",
"55343213", "Uberlândia\ \-\ MG",
"55443541", "Moreira\ Sales\ \-\ PR",
"55333203", "Governador\ Valadares\ \-\ MG",
"55733561", "Ubaitaba\ \-\ BA",
"55453540", "São\ Miguel\ do\ Iguaçu\ \-\ PR",
"55283520", "Piúma\ \-\ ES",
"55114532", "Jundiaí\ \-\ SP",
"55443125", "Marialva\ \-\ PR",
"55674007", "Campo\ Grande\ \-\ MS",
"55864009", "Teresina\ \-\ PI",
"55423520", "São\ Mateus\ do\ Sul\ \-\ PR",
"55514007", "Porto\ Alegre\ \-\ RS",
"55684007", "Rio\ Branco\ \-\ AC",
"55183528", "Osvaldo\ Cruz\ \-\ SP",
"55923667", "Manaus\ \-\ AM",
"55443679", "Tapira\ \-\ PR",
"55112547", "São\ Paulo\ \-\ SP",
"55214503", "Rio\ de\ Janeiro\ \-\ RJ",
"55113449", "Osasco\ \-\ SP",
"55323083", "Juiz\ de\ Fora\ \-\ MG",
"55993321", "Imperatriz\ \-\ MA",
"55643608", "Bom\ Jesus\ de\ Goiás\ \-\ GO",
"55513283", "Novo\ Hamburgo\ \-\ RS",
"55493804", "Lages\ \-\ SC",
"55193362", "Mogi\-Guaçu\ \-\ SP",
"55114668", "Itapecerica\ da\ Serra\ \-\ SP",
"55193822", "Sumaré\ \-\ SP",
"55753330", "Boninal\ \-\ BA",
"55733697", "Travessão\ \-\ BA",
"55993565", "Formosa\ da\ Serra\ Negra\ \-\ MA",
"55623457", "Monte\ Alegre\ de\ Goiás\ \-\ GO",
"55373071", "Divinópolis\ \-\ MG",
"55313426", "Belo\ Horizonte\ \-\ MG",
"55513460", "Esteio\ \-\ RS",
"55923521", "Itacoatiara\ \-\ AM",
"55513404", "Rio\ Grande\ do\ Sul",
"55143493", "Varpa\ \-\ SP",
"55213133", "Rio\ de\ Janeiro\ \-\ RJ",
"55813518", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55517", "Rio\ Grande\ do\ Sul",
"55193483", "São\ Pedro\ \-\ SP",
"55923365", "Novo\ Airão\ \-\ AM",
"55112654", "São\ Paulo\ \-\ SP",
"55832106", "João\ Pessoa\ \-\ PB",
"55653211", "Cáceres\ \-\ MT",
"55163352", "Ibitinga\ \-\ SP",
"55333435", "Coluna\ \-\ MG",
"55343421", "Frutal\ \-\ MG",
"55242220", "Petrópolis\ \-\ RJ",
"55543233", "Ipê\ \-\ RS",
"55813198", "Recife\ \-\ PE",
"55143882", "Botucatu\ \-\ SP",
"55923575", "Itapiranga\ \-\ AM",
"55193892", "Serra\ Negra\ \-\ SP",
"55133201", "Santos\ \-\ SP",
"55114419", "Mairiporã\ \-\ SP",
"55633469", "Goiatins\ \-\ TO",
"55114246", "Mairinque\ \-\ SP",
"55823642", "Mata\ Grande\ \-\ AL",
"5568", "Acre",
"55843277", "Nísia\ Floresta\ \-\ RN",
"55733627", "Santa\ Cruz\ da\ Vitória\ \-\ BA",
"5567", "Mato\ Grosso\ do\ Sul",
"55673445", "Anaurilândia\ \-\ MS",
"55133419", "Pedro\ de\ Toledo\ \-\ SP",
"55313622", "Vespasiano\ \-\ MG",
"55513445", "Presidente\ Lucena\ \-\ RS",
"55813652", "Camutanga\ \-\ PE",
"55114201", "Barueri\ \-\ SP",
"55283556", "São\ José\ do\ Calçado\ \-\ ES",
"55134102", "Guarujá\ \-\ SP",
"55893451", "Santo\ Inácio\ do\ Piauí\ \-\ PI",
"55713677", "Mata\ de\ São\ João\ \-\ BA",
"55423617", "Santa\ Maria\ do\ Oeste\ \-\ PR",
"55193702", "Limeira\ \-\ SP",
"556733", "Campo\ Grande\ \-\ MS",
"55433174", "Cambé\ \-\ PR",
"555133", "Porto\ Alegre\ \-\ RS",
"55793252", "Aracaju\ \-\ SE",
"55463524", "Francisco\ Beltrão\ \-\ PR",
"55833259", "Pitimbu\ \-\ PB",
"55453375", "Esquina\ Ipiranga\ \-\ PR",
"55193882", "Cosmópolis\ \-\ SP",
"55313431", "Belo\ Horizonte\ \-\ MG",
"55634001", "Palmas\ \-\ TO",
"55153261", "Porto\ Feliz\ \-\ SP",
"55983482", "Buriti\ \-\ MA",
"55993072", "Imperatriz\ \-\ MA",
"55513348", "Rio\ Grande\ do\ Sul",
"55973482", "Ipixuna\ \-\ AM",
"55623512", "Senador\ Canedo\ \-\ GO",
"55213987", "Rio\ de\ Janeiro\ \-\ RJ",
"55453565", "São\ Miguel\ do\ Iguaçu\ \-\ PR",
"55212251", "São\ Gonçalo\ \-\ RJ",
"55273161", "Guarapari\ \-\ ES",
"55433355", "Londrina\ \-\ PR",
"55433544", "Santa\ Amélia\ \-\ PR",
"55453321", "Cascavel\ \-\ PR",
"55373322", "Formiga\ \-\ MG",
"55273341", "Serra\ \-\ ES",
"55115612", "São\ Paulo\ \-\ SP",
"55773691", "Malhada\ \-\ BA",
"55193493", "Rio\ das\ Pedras\ \-\ SP",
"55473416", "Joinville\ \-\ SC",
"55883448", "Parambu\ \-\ CE",
"55112318", "São\ Paulo\ \-\ SP",
"55733532", "Itamari\ \-\ BA",
"55893539", "Porto\ Alegre\ do\ Piauí\ \-\ PI",
"55473249", "Itajaí\ \-\ SC",
"55873856", "Tupanatinga\ \-\ PE",
"55313559", "Ouro\ Preto\ \-\ MG",
"55943433", "Tucumã\ \-\ PA",
"55663595", "Matupá\ \-\ MT",
"55693546", "Nova\ Dimensão\ \-\ RO",
"5592361", "Manaus\ \-\ AM",
"55513737", "Rio\ Grande\ do\ Sul",
"55163304", "Araraquara\ \-\ SP",
"55313393", "Minas\ Gerais",
"55113375", "São\ Paulo\ \-\ SP",
"55183621", "Araçatuba\ \-\ SP",
"55173621", "Jales\ \-\ SP",
"55813645", "Feira\ Nova\ \-\ PE",
"55513452", "Sapucaia\ do\ Sul\ \-\ RS",
"55123105", "Aparecida\ \-\ SP",
"55673452", "Rio\ Brilhante\ \-\ MS",
"55713433", "Salvador\ \-\ BA",
"55833133", "João\ Pessoa\ \-\ PB",
"55173849", "Macedônia\ \-\ SP",
"55163975", "Ribeirão\ Preto\ \-\ SP",
"5521388", "Rio\ de\ Janeiro\ \-\ RJ",
"55163262", "Itápolis\ \-\ SP",
"55474053", "Blumenau\ \-\ SC",
"55653396", "Alto\ Paraguai\ \-\ MT",
"55114082", "São\ Paulo\ \-\ SP",
"55553363", "São\ Nicolau\ \-\ RS",
"55484053", "Criciúma\ \-\ SC",
"5551320", "Rio\ Grande\ do\ Sul",
"55983538", "Açailândia\ \-\ MA",
"55823288", "Quebrangulo\ \-\ AL",
"55883554", "Barro\ \-\ CE",
"55843616", "Natal\ \-\ RN",
"55193386", "Campinas\ \-\ SP",
"55443648", "Santa\ Rita\ do\ Oeste\ \-\ PR",
"55774009", "Vitória\ da\ Conquista\ \-\ BA",
"55373524", "Martinho\ Campos\ \-\ MG",
"55853383", "Maracanaú\ \-\ CE",
"55923427", "Juruá\ \-\ AM",
"55433342", "Londrina\ \-\ PR",
"55323533", "Colônia\ Padre\ Damião\ \-\ MG",
"55733668", "Trancoso\ \-\ BA",
"55222566", "Bom\ Jardim\ \-\ RJ",
"55733214", "Itabuna\ \-\ BA",
"55873880", "Granito\ \-\ PE",
"55114428", "Santo\ André\ \-\ SP",
"55113565", "São\ Caetano\ do\ Sul\ \-\ SP",
"55813879", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55433162", "Apucarana\ \-\ PR",
"55183743", "Ilha\ Solteira\ \-\ SP",
"55913822", "Quatipuru\ \-\ PA",
"55212633", "Magé\ \-\ RJ",
"55513620", "Rio\ Grande\ do\ Sul",
"55173833", "Estrela\ D\'Oeste\ \-\ SP",
"55163345", "Dourado\ \-\ SP",
"55353529", "Passos\ \-\ MG",
"55833317", "Galante\ \-\ PB",
"55213818", "Rio\ de\ Janeiro\ \-\ RJ",
"55313309", "Belo\ Horizonte\ \-\ MG",
"55193396", "Sumaré\ \-\ SP",
"55114687", "São\ Lourenço\ da\ Serra\ \-\ SP",
"55823298", "Porto\ de\ Pedras\ \-\ AL",
"55713216", "Simões\ Filho\ \-\ BA",
"55423276", "Reserva\ \-\ PR",
"55143386", "Taguaí\ \-\ SP",
"55493648", "Caibi\ \-\ SC",
"55333747", "Santo\ Antônio\ do\ Jacinto\ \-\ MG",
"55833641", "Riacho\ de\ Santo\ Antônio\ \-\ PB",
"55123144", "Cruzeiro\ \-\ SP",
"55663534", "Terra\ Nova\ do\ Norte\ \-\ MT",
"55243358", "Resende\ \-\ RJ",
"55153330", "Sorocaba\ \-\ SP",
"55353645", "São\ José\ do\ Alegre\ \-\ MG",
"55553422", "Alegrete\ \-\ RS",
"55813604", "Surubim\ \-\ PE",
"55473233", "São\ Francisco\ do\ Sul\ \-\ SC",
"55793362", "Cumbe\ \-\ SE",
"55893543", "Antônio\ Almeida\ \-\ PI",
"55313913", "Contagem\ \-\ MG",
"55833369", "Arara\ \-\ PB",
"55123876", "São\ José\ dos\ Campos\ \-\ SP",
"55153546", "Buri\ \-\ SP",
"55313383", "Belo\ Horizonte\ \-\ MG",
"55212649", "Cachoeiras\ de\ Macacu\ \-\ RJ",
"55273224", "Vitória\ \-\ ES",
"55115787", "São\ Paulo\ \-\ SP",
"55663212", "Sorriso\ \-\ MT",
"55663585", "Feliz\ Natal\ \-\ MT",
"55453244", "Missal\ \-\ PR",
"55433011", "Arapongas\ \-\ PR",
"55933522", "Santarém\ \-\ PA",
"55513127", "Gravataí\ \-\ RS",
"55913423", "Salinópolis\ \-\ PA",
"55312122", "Belo\ Horizonte\ \-\ MG",
"55433265", "São\ Sebastião\ da\ Amoreira\ \-\ PR",
"55114092", "Diadema\ \-\ SP",
"55653386", "São\ José\ do\ Rio\ Claro\ \-\ MT",
"55273276", "Guaraná\ \-\ ES",
"55124715", "Alumínio\ \-\ SP",
"55753312", "Cruz\ das\ Almas\ \-\ BA",
"55643613", "Rio\ Verde\ \-\ GO",
"55893557", "Nazaré\ do\ Piauí\ \-\ PI",
"55313537", "Serra\ Azul\ \-\ MG",
"55653331", "Barão\ de\ Melgaço\ \-\ MT",
"55773461", "Bom\ Jesus\ da\ Serra\ \-\ BA",
"55753608", "Barrocas\ \-\ BA",
"55333753", "Medina\ \-\ MG",
"55513759", "Travesseiro\ \-\ RS",
"55643546", "Itumbiara\ \-\ GO",
"55193663", "Divinolândia\ \-\ SP",
"55313462", "Belo\ Horizonte\ \-\ MG",
"55273051", "Serra\ \-\ ES",
"55413608", "Fazenda\ Rio\ Grande\ \-\ PR",
"55493447", "Ouro\ Verde\ \-\ SC",
"55123116", "Bananal\ \-\ SP",
"558532", "Fortaleza\ \-\ CE",
"55143252", "Pederneiras\ \-\ SP",
"55193866", "Conchal\ \-\ SP",
"55743065", "Juazeiro\ \-\ BA",
"55123894", "Ilhabela\ \-\ SP",
"55423132", "Irati\ \-\ PR",
"55193326", "Campinas\ \-\ SP",
"55853323", "Tejuçuoca\ \-\ CE",
"55223308", "São\ Pedro\ da\ Aldeia\ \-\ RJ",
"55323258", "Coronel\ Pacheco\ \-\ MG",
"55844109", "Mossoró\ \-\ RN",
"55473405", "Itajaí\ \-\ SC",
"55613679", "São\ Gabriel\ de\ Goiás\ \-\ GO",
"55513680", "Quintão\ \-\ RS",
"55193374", "Piracicaba\ \-\ SP",
"55623301", "Leopoldo\ de\ Bulhões\ \-\ GO",
"55163981", "Pradópolis\ \-\ SP",
"55613356", "Taguatinga\ \-\ DF",
"55513569", "Morro\ Reuter\ \-\ RS",
"55114488", "Francisco\ Morato\ \-\ SP",
"55843412", "Currais\ Novos\ \-\ RN",
"55873991", "Vermelho\ \-\ PE",
"55163311", "Araraquara\ \-\ SP",
"55513379", "Rio\ Grande\ do\ Sul",
"55333373", "Santana\ do\ Manhuaçu\ \-\ MG",
"55613380", "Núcleo\ Bandeirante\ \-\ DF",
"55533238", "São\ José\ do\ Norte\ \-\ RS",
"55513656", "Arroio\ dos\ Ratos\ \-\ RS",
"55493453", "Peritiba\ \-\ SC",
"55383831", "Porteirinha\ \-\ MG",
"55113170", "São\ Paulo\ \-\ SP",
"55963281", "Santana\ \-\ AP",
"55513933", "Gravataí\ \-\ RS",
"55463025", "Pato\ Branco\ \-\ PR",
"55183636", "Araçatuba\ \-\ SP",
"55843605", "Natal\ \-\ RN",
"55793260", "Barra\ dos\ Coqueiros\ \-\ SE",
"55173636", "Dolcinópolis\ \-\ SP",
"55343333", "Uberaba\ \-\ MG",
"55273132", "Vitória\ \-\ ES",
"55823343", "Maceió\ \-\ AL",
"55114022", "Itu\ \-\ SP",
"55983466", "Pirapemas\ \-\ MA",
"55793483", "Nossa\ Senhora\ Aparecida\ \-\ SE",
"55383535", "Datas\ \-\ MG",
"55173681", "Nova\ Canaã\ Paulista\ \-\ SP",
"55543278", "Canela\ \-\ RS",
"55873764", "Garanhuns\ \-\ PE",
"55423235", "Ponta\ Grossa\ \-\ PR",
"55933582", "Santa\ Maria\ do\ Uruará\ \-\ PA",
"55853462", "Fortaleza\ \-\ CE",
"55413041", "Curitiba\ \-\ PR",
"55613961", "Brasília\ \-\ DF",
"55313323", "Belo\ Horizonte\ \-\ MG",
"55313863", "Ferros\ \-\ MG",
"5531327", "Belo\ Horizonte\ \-\ MG",
"55443014", "Marialva\ \-\ PR",
"55653374", "Cangas\ \-\ MT",
"5511441", "Atibaia\ \-\ SP",
"55433240", "São\ Martinho\ \-\ PR",
"55753261", "Serrinha\ \-\ BA",
"55663525", "Carlinda\ \-\ MT",
"55183377", "Florínia\ \-\ SP",
"55753015", "Feira\ de\ Santana\ \-\ BA",
"55123835", "Ubatuba\ \-\ SP",
"55383741", "Pirapora\ \-\ MG",
"55883647", "Groaíras\ \-\ CE",
"55644052", "Itumbiara\ \-\ GO",
"55553028", "Santa\ Maria\ \-\ RS",
"55173691", "Três\ Fronteiras\ \-\ SP",
"55473444", "São\ Francisco\ do\ Sul\ \-\ SC",
"55273722", "Colatina\ \-\ ES",
"55183691", "Buritama\ \-\ SP",
"55653326", "Tangará\ da\ Serra\ \-\ MT",
"55913483", "São\ Domingos\ do\ Capim\ \-\ PA",
"55623551", "Bela\ Vista\ de\ Goiás\ \-\ GO",
"55713205", "Salvador\ \-\ BA",
"55443453", "Santa\ Isabel\ do\ Ivaí\ \-\ PR",
"55613506", "Brasília\ \-\ DF",
"55734102", "Ilhéus\ \-\ BA",
"55114751", "Suzano\ \-\ SP",
"55663571", "Colniza\ \-\ MT",
"55152108", "Tietê\ \-\ SP",
"55733246", "Itapitanga\ \-\ BA",
"55463220", "Pato\ Branco\ \-\ PR",
"55343661", "Araxá\ \-\ MG",
"55633354", "Cristalândia\ \-\ TO",
"55793211", "Aracaju\ \-\ SE",
"55163042", "Sertãozinho\ \-\ SP",
"55143374", "Caporanga\ \-\ SP",
"55313769", "Conselheiro\ Lafaiete\ \-\ MG",
"55443447", "Alto\ Paraná\ \-\ PR",
"55163820", "Orlândia\ \-\ SP",
"55843644", "Parnamirim\ \-\ RN",
"55313248", "Belo\ Horizonte\ \-\ MG",
"55173567", "Paraíso\ \-\ SP",
"55143326", "Ourinhos\ \-\ SP",
"55383623", "Januária\ \-\ MG",
"55313717", "Santana\ de\ Pirapama\ \-\ MG",
"55513690", "Rio\ Grande\ do\ Sul",
"55883653", "Ibiapina\ \-\ CE",
"55273235", "Vitória\ \-\ ES",
"55143311", "Marília\ \-\ SP",
"55433152", "Arapongas\ \-\ PR",
"55813626", "Goiana\ \-\ PE",
"55333238", "São\ Geraldo\ da\ Piedade\ \-\ MG",
"55843377", "Portalegre\ \-\ RN",
"55553347", "Santa\ Maria\ \-\ RS",
"55383541", "Serro\ \-\ MG",
"5553322", "Pelotas\ \-\ RS",
"55373541", "Abaeté\ \-\ MG",
"55313379", "Minas\ Gerais",
"55143764", "Iaras\ \-\ SP",
"55793274", "Rosário\ do\ Catete\ \-\ SE",
"55113555", "São\ Paulo\ \-\ SP",
"55283522", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55553611", "Unistalda\ \-\ RS",
"55613535", "Brasília\ \-\ DF",
"55753024", "Feira\ de\ Santana\ \-\ BA",
"55222556", "São\ Sebastião\ do\ Alto\ \-\ RJ",
"55813482", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55883564", "Cedro\ \-\ CE",
"55123965", "Jacareí\ \-\ SP",
"5561210", "Brasília\ \-\ DF",
"55114166", "Barueri\ \-\ SP",
"55693525", "Vale\ do\ Anari\ \-\ RO",
"55383845", "Taiobeiras\ \-\ MG",
"55173813", "Jaci\ \-\ SP",
"55843691", "Lajes\ Pintadas\ \-\ RN",
"55543333", "Chapada\ \-\ RS",
"55163944", "Dumont\ \-\ SP",
"55653311", "Tangará\ da\ Serra\ \-\ MT",
"55163252", "Taquaritinga\ \-\ SP",
"55474063", "Joinville\ \-\ SC",
"55553353", "Guarani\ das\ Missões\ \-\ RS",
"55963244", "Macapá\ \-\ AP",
"55222580", "Nova\ Friburgo\ \-\ RJ",
"55753332", "Palmeiras\ \-\ BA",
"55643956", "Itumbiara\ \-\ GO",
"55513462", "Canoas\ \-\ RS",
"55683462", "Tarauacá\ \-\ AC",
"55643633", "Lagoa\ do\ Bauzinho\ \-\ GO",
"55423522", "União\ da\ Vitória\ \-\ PR",
"55733295", "Itanhém\ \-\ BA",
"55983652", "Bom\ Jesus\ das\ Selvas\ \-\ MA",
"55242292", "Petrópolis\ \-\ RJ",
"55143653", "Brotas\ \-\ SP",
"55433031", "Londrina\ \-\ PR",
"55383679", "Paracatu\ \-\ MG",
"55193042", "Piracicaba\ \-\ SP",
"55212734", "Rio\ Bonito\ \-\ RJ",
"55112229", "Guarulhos\ \-\ SP",
"55483491", "Orleans\ \-\ SC",
"55183644", "Birigui\ \-\ SP",
"55543349", "São\ Domingos\ do\ Sul\ \-\ RS",
"55193936", "Indaiatuba\ \-\ SP",
"55643571", "Palmeiras\ de\ Goiás\ \-\ GO",
"55773451", "Guanambi\ \-\ BA",
"55353626", "Wenceslau\ Braz\ \-\ MG",
"55193653", "Aguaí\ \-\ SP",
"55153141", "Sorocaba\ \-\ SP",
"55513769", "Rio\ Grande\ do\ Sul",
"55113305", "São\ Paulo\ \-\ SP",
"55383222", "Montes\ Claros\ \-\ MG",
"55433255", "Rolândia\ \-\ PR",
"55373222", "Divinópolis\ \-\ MG",
"55893567", "Ribeiro\ Gonçalves\ \-\ PI",
"55114976", "Santo\ André\ \-\ SP",
"5592363", "Manaus\ \-\ AM",
"55713054", "Camaçari\ \-\ BA",
"55613623", "Luziânia\ \-\ GO",
"55353799", "Caldas\ \-\ MG",
"55513717", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55633531", "Divinópolis\ do\ Tocantins\ \-\ TO",
"55212124", "Duque\ de\ Caxias\ \-\ RJ",
"55673248", "Costa\ Rica\ \-\ MS",
"55332102", "Governador\ Valadares\ \-\ MG",
"55133855", "Tatuí\ \-\ SP",
"55483436", "Nova\ Veneza\ \-\ SC",
"55163326", "Boa\ Esperança\ do\ Sul\ \-\ SP",
"55683248", "Rio\ Branco\ \-\ AC",
"55623385", "Nova\ Crixás\ \-\ GO",
"55733512", "Eunápolis\ \-\ BA",
"55733285", "Potiraguá\ \-\ BA",
"55983198", "São\ Luís\ \-\ MA",
"55793352", "Neópolis\ \-\ SE",
"55833359", "Congo\ \-\ PB",
"55153571", "Riversul\ \-\ SP",
"55333329", "Caratinga\ \-\ MG",
"55453275", "São\ Clemente\ \-\ PR",
"55113408", "Itatiba\ \-\ SP",
"55193647", "Itobi\ \-\ SP",
"55213748", "Belford\ Roxo\ \-\ RJ",
"55613114", "Brasília\ \-\ DF",
"55733234", "Ilhéus\ \-\ BA",
"55623334", "Petrolina\ de\ Goiás\ \-\ GO",
"555132", "Porto\ Alegre\ \-\ RS",
"55773430", "Caatiba\ \-\ BA",
"55713291", "Salvador\ \-\ BA",
"55643649", "Castelândia\ \-\ GO",
"55193311", "Jaguariúna\ \-\ SP",
"55383506", "Buritis\ \-\ MG",
"55123354", "Jacareí\ \-\ SP",
"55493382", "Xanxerê\ \-\ SC",
"55413035", "São\ José\ dos\ Pinhais\ \-\ PR",
"55843636", "Ruy\ Barbosa\ \-\ RN",
"55813492", "Olinda\ \-\ PE",
"55183605", "Santópolis\ do\ Aguapeí\ \-\ SP",
"55623488", "Simolândia\ \-\ GO",
"55833624", "João\ Pessoa\ \-\ PB",
"55493025", "Chapecó\ \-\ SC",
"55353696", "Guaxupé\ \-\ MG",
"55693534", "Alto\ Paraíso\ \-\ RO",
"55353573", "Monte\ Belo\ \-\ MG",
"55212771", "Duque\ de\ Caxias\ \-\ RJ",
"55623941", "Goiânia\ \-\ GO",
"5531320", "Minas\ Gerais",
"55513666", "Terra\ de\ Areia\ \-\ RS",
"55353729", "Poços\ de\ Caldas\ \-\ MG",
"55673666", "Chapadão\ do\ Sul\ \-\ MS",
"5511443", "Santo\ André\ \-\ SP",
"55993542", "Balsas\ \-\ MA",
"55623092", "Goiânia\ \-\ GO",
"55193554", "Leme\ \-\ SP",
"55193345", "Campinas\ \-\ SP",
"55163396", "Santa\ Lúcia\ \-\ SP",
"55134002", "Santos\ \-\ SP",
"55694062", "Porto\ Velho\ \-\ RO",
"55813631", "Timbaúba\ \-\ PE",
"55613366", "Brasília\ \-\ DF",
"55313737", "Minas\ Gerais",
"55493256", "Fraiburgo\ \-\ SC",
"55273215", "Vitória\ \-\ ES",
"55513559", "Sapiranga\ \-\ RS",
"55663501", "Alta\ Floresta\ \-\ MT",
"55673559", "Paranaíba\ \-\ MS",
"55643595", "Itumbiara\ \-\ GO",
"55323749", "Faria\ Lemos\ \-\ MG",
"55453054", "Toledo\ \-\ PR",
"55813686", "Belém\ de\ Maria\ \-\ PE",
"55153115", "Boituva\ \-\ SP",
"55163663", "Jardinópolis\ \-\ SP",
"55543527", "Áurea\ \-\ RS",
"55353823", "Itumirim\ \-\ MG",
"55193856", "Vinhedo\ \-\ SP",
"55353363", "Itamonte\ \-\ MG",
"55634101", "Palmas\ \-\ TO",
"55893432", "Cajazeiras\ do\ Piauí\ \-\ PI",
"55713221", "Salvador\ \-\ BA",
"55483037", "Florianópolis\ \-\ SC",
"55113607", "Osasco\ \-\ SP",
"55193448", "Ibitiruna\ \-\ SP",
"55143262", "Agudos\ \-\ SP",
"55323442", "Leopoldina\ \-\ MG",
"55753230", "Antônio\ Cardoso\ \-\ BA",
"55185821", "Dracena\ \-\ SP",
"55843432", "Campo\ Redondo\ \-\ RN",
"55883663", "Bela\ Cruz\ \-\ CE",
"55473059", "São\ Bento\ do\ Sul\ \-\ SC",
"55413678", "Adrianópolis\ \-\ PR",
"55613101", "Brasília\ \-\ DF",
"5511285", "São\ Paulo\ \-\ SP",
"55653345", "Poconé\ \-\ MT",
"55183557", "Salmourão\ \-\ SP",
"55173557", "Sales\ \-\ SP",
"55443256", "Ângulo\ \-\ PR",
"55153534", "Taquarivaí\ \-\ SP",
"55833472", "Teixeira\ \-\ PB",
"55313759", "Minas\ Gerais",
"55513537", "Porto\ Alegre\ \-\ RS",
"55833684", "Serra\ da\ Raiz\ \-\ PB",
"55913286", "Ananindeua\ \-\ PA",
"55993221", "Imperatriz\ \-\ MA",
"55114761", "Mogi\ das\ Cruzes\ \-\ SP",
"55733271", "Iguaí\ \-\ BA",
"55913772", "Mosqueiro\ \-\ PA",
"55313847", "Minas\ Gerais",
"55663546", "Cláudia\ \-\ MT",
"55493322", "Chapecó\ \-\ SC",
"55633364", "Lagoa\ da\ Confusão\ \-\ TO",
"55193304", "Campinas\ \-\ SP",
"55623371", "Goiás\ \-\ GO",
"55453281", "Marechal\ Cândido\ Rondon\ \-\ PR",
"55833635", "Damião\ \-\ PB",
"55173543", "Novo\ Horizonte\ \-\ SP",
"55473632", "Campo\ Alegre\ \-\ SC",
"55623561", "Caldazinha\ \-\ GO",
"55483632", "Tubarão\ \-\ SC",
"55443463", "Paranacity\ \-\ PR",
"55753477", "Chorrochó\ \-\ BA",
"55143554", "Cafelândia\ \-\ SP",
"55453236", "Serranópolis\ do\ Iguaçu\ \-\ PR",
"55643534", "Itumbiara\ \-\ GO",
"55163386", "Dobrada\ \-\ SP",
"55623325", "Rubiataba\ \-\ GO",
"55313853", "Bela\ Vista\ de\ Minas\ \-\ MG",
"55753251", "Itaberaba\ \-\ BA",
"55383811", "Monte\ Azul\ \-\ MG",
"5511505", "São\ Paulo\ \-\ SP",
"55733225", "Igrapiúna\ \-\ BA",
"55242222", "Petrópolis\ \-\ RJ",
"55483378", "Santa\ Tereza\ \-\ SC",
"55813363", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55383724", "Presidente\ Juscelino\ \-\ MG",
"55143880", "Botucatu\ \-\ SP",
"55173344", "Bebedouro\ \-\ SP",
"55183344", "Presidente\ Prudente\ \-\ SP",
"55193977", "Artur\ Nogueira\ \-\ SP",
"55633373", "Almas\ \-\ TO",
"55313380", "Minas\ Gerais",
"55483251", "Florianópolis\ \-\ SC",
"55114048", "Diadema\ \-\ SP",
"55653347", "Assari\ \-\ MT",
"55313541", "Nova\ Lima\ \-\ MG",
"55473251", "Brusque\ \-\ SC",
"5563322", "Palmas\ \-\ TO",
"55813155", "Gravatá\ \-\ PE",
"55753421", "Alagoinhas\ \-\ BA",
"55513706", "Rio\ Grande\ do\ Sul",
"55343514", "Cachoeira\ Dourada\ \-\ MG",
"55242452", "Valença\ \-\ RJ",
"55973352", "Anori\ \-\ AM",
"55883626", "São\ Benedito\ \-\ CE",
"55983352", "Vitória\ do\ Mearim\ \-\ MA",
"55643610", "Mineiros\ \-\ GO",
"55313845", "Jaguaraçu\ \-\ MG",
"55193589", "Porto\ Ferreira\ \-\ SP",
"55452105", "Foz\ do\ Iguaçu\ \-\ PR",
"55963118", "Macapá\ \-\ AP",
"55183851", "Tupi\ Paulista\ \-\ SP",
"55753632", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"55223094", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55653611", "Cuiabá\ \-\ MT",
"55883674", "Acaraú\ \-\ CE",
"55343816", "Lagoa\ Grande\ \-\ MG",
"55843391", "Martins\ \-\ RN",
"55753475", "Porto\ de\ Sauipe\ \-\ BA",
"55653353", "Acorizal\ \-\ MT",
"55513584", "Novo\ Hamburgo\ \-\ RS",
"55333731", "Araçuaí\ \-\ MG",
"55553311", "Santa\ Maria\ \-\ RS",
"55743652", "Ibititá\ \-\ BA",
"55793198", "Aracaju\ \-\ SE",
"55114513", "Mauá\ \-\ SP",
"55114646", "Itaquaquecetuba\ \-\ SP",
"55313356", "Contagem\ \-\ MG",
"5511407", "Diadema\ \-\ SP",
"55343232", "Uberlândia\ \-\ MG",
"55464007", "Francisco\ Beltrão\ \-\ PR",
"55193503", "Hortolândia\ \-\ SP",
"55873893", "Itacuruba\ \-\ PE",
"55813252", "Recife\ \-\ PE",
"55323346", "Antônio\ Carlos\ \-\ MG",
"55114601", "Jundiaí\ \-\ SP",
"55513594", "Novo\ Hamburgo\ \-\ RS",
"55843336", "São\ Rafael\ \-\ RN",
"55333354", "Bom\ Jesus\ do\ Galho\ \-\ MG",
"55643661", "Mineiros\ \-\ GO",
"55133513", "Santos\ \-\ SP",
"55123654", "Caçapava\ \-\ SP",
"55713451", "Salvador\ \-\ BA",
"55773413", "Cascavel\ \-\ BA",
"55843381", "Alexandria\ \-\ RN",
"55473084", "Jaraguá\ do\ Sul\ \-\ SC",
"55483084", "Florianópolis\ \-\ SC",
"55833376", "Barra\ de\ Santa\ Rosa\ \-\ PB",
"55873883", "Parnamirim\ \-\ PE",
"55433398", "Tamarana\ \-\ PR",
"55353564", "Conceição\ da\ Aparecida\ \-\ MG",
"55114109", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55212630", "Magé\ \-\ RJ",
"55513623", "Rio\ Grande\ do\ Sul",
"55383690", "Montes\ Claros\ \-\ MG",
"55613717", "Brasília\ \-\ DF",
"55113412", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55373690", "Divinópolis\ \-\ MG",
"55543525", "Severiano\ de\ Almeida\ \-\ RS",
"55143589", "Reginópolis\ \-\ SP",
"55342108", "Araguari\ \-\ MG",
"55983274", "Paço\ do\ Lumiar\ \-\ MA",
"55513114", "Guaíba\ \-\ RS",
"55643597", "Itumbiara\ \-\ GO",
"55624103", "Aparecida\ de\ Goiânia\ \-\ GO",
"55313390", "Minas\ Gerais",
"55313735", "Jeceaba\ \-\ MG",
"55514116", "Porto\ Alegre\ \-\ RS",
"55212651", "São\ João\ de\ Meriti\ \-\ RJ",
"55153349", "Ibiúna\ \-\ SP",
"55115212", "São\ Paulo\ \-\ SP",
"55873789", "Brejão\ \-\ PE",
"55513741", "Venâncio\ Aires\ \-\ RS",
"55133048", "São\ Vicente\ \-\ SP",
"55163482", "Cravinhos\ \-\ SP",
"55223084", "Macaé\ \-\ RJ",
"55713029", "Lauro\ de\ Freitas\ \-\ BA",
"55543361", "Sarandi\ \-\ RS",
"55823521", "Arapiraca\ \-\ AL",
"55353866", "Santana\ do\ Jacaré\ \-\ MG",
"55483035", "São\ José\ \-\ SC",
"55273269", "Alfredo\ Chaves\ \-\ ES",
"55353326", "Minduri\ \-\ MG",
"55193353", "Araras\ \-\ SP",
"55473035", "Blumenau\ \-\ SC",
"55493908", "Fraiburgo\ \-\ SC",
"55853356", "Apuiarés\ \-\ CE",
"55873809", "Iguaraci\ \-\ PE",
"55323551", "Visconde\ do\ Rio\ Branco\ \-\ MG",
"55833032", "Santa\ Rita\ \-\ PB",
"55913456", "Benfica\ \-\ PA",
"55313292", "Belo\ Horizonte\ \-\ MG",
"55893565", "Santa\ Luz\ \-\ PI",
"55153527", "Itapetininga\ \-\ SP",
"55183996", "Marabá\ Paulista\ \-\ SP",
"55553304", "Santa\ Maria\ \-\ RS",
"55463223", "Pato\ Branco\ \-\ PR",
"55193879", "Monte\ Mor\ \-\ SP",
"55833394", "Ingá\ \-\ PB",
"55513524", "Novo\ Hamburgo\ \-\ RS",
"55114442", "Caieiras\ \-\ SP",
"55113307", "São\ Paulo\ \-\ SP",
"55133268", "Bertioga\ \-\ SP",
"55673524", "Três\ Lagoas\ \-\ MS",
"55433257", "Pitangueiras\ \-\ PR",
"55453029", "Foz\ do\ Iguaçu\ \-\ PR",
"55623533", "Goiânia\ \-\ GO",
"55163143", "Restinga\ \-\ SP",
"55273049", "Colatina\ \-\ ES",
"55353663", "Pedralva\ \-\ MG",
"55443431", "Paraíso\ do\ Norte\ \-\ PR",
"55333726", "Jordânia\ \-\ MG",
"55493279", "Rio\ Rufino\ \-\ SC",
"55553262", "Paraíso\ do\ Sul\ \-\ RS",
"55143604", "Barra\ Bonita\ \-\ SP",
"55443622", "Umuarama\ \-\ PR",
"55733287", "Belmonte\ \-\ BA",
"55222783", "Italva\ \-\ RJ",
"55623387", "Anápolis\ \-\ GO",
"55323314", "Juiz\ de\ Fora\ \-\ MG",
"55773275", "Maiquinique\ \-\ BA",
"55314136", "Belo\ Horizonte\ \-\ MG",
"55513715", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55964009", "Macapá\ \-\ AP",
"55883650", "Carnaubal\ \-\ CE",
"55433471", "Jacutinga\ \-\ PR",
"55513693", "Rio\ Grande\ do\ Sul",
"55193773", "Campinas\ \-\ SP",
"55883686", "Catunda\ \-\ CE",
"55112752", "São\ Paulo\ \-\ SP",
"55732101", "Ilhéus\ \-\ BA",
"55453277", "Toledo\ \-\ PR",
"55613559", "Samambaia\ Sul\ \-\ DF",
"55753436", "Olindina\ \-\ BA",
"55333511", "Itambacuri\ \-\ MG",
"55883631", "Itapipoca\ \-\ CE",
"55613393", "Santa\ Maria\ \-\ DF",
"55313320", "Ipaba\ \-\ MG",
"55313860", "Minas\ Gerais",
"55163729", "Ituverava\ \-\ SP",
"55883422", "Morada\ Nova\ \-\ CE",
"55183607", "Araçatuba\ \-\ SP",
"55133843", "Ilha\ Comprida\ \-\ SP",
"55773221", "Itapetinga\ \-\ BA",
"55983479", "Tutóia\ \-\ MA",
"55553921", "Santa\ Maria\ \-\ RS",
"55613383", "Brasília\ \-\ DF",
"55212787", "Duque\ de\ Caxias\ \-\ RJ",
"55553554", "Miraguaí\ \-\ RS",
"55513101", "Alvorada\ \-\ RS",
"55413059", "Pinhais\ \-\ PR",
"55843375", "Taboleiro\ Grande\ \-\ RN",
"55143529", "Lins\ \-\ SP",
"55513930", "Porto\ Alegre\ \-\ RS",
"55883696", "Monsenhor\ Tabosa\ \-\ CE",
"55753491", "Feira\ de\ Santana\ \-\ BA",
"55623625", "Aparecida\ de\ Goiânia\ \-\ GO",
"55543701", "Bento\ Gonçalves\ \-\ RS",
"55273033", "Vila\ Velha\ \-\ ES",
"55623549", "Aparecida\ de\ Goiânia\ \-\ GO",
"55793263", "Capela\ \-\ SE",
"55473332", "Gaspar\ \-\ SC",
"55823536", "Traipu\ \-\ AL",
"55483332", "Florianópolis\ \-\ SC",
"55353331", "São\ Lourenço\ \-\ MG",
"55383759", "Lassance\ \-\ MG",
"55513609", "Rio\ Grande\ do\ Sul",
"55493622", "São\ Miguel\ do\ Oeste\ \-\ SC",
"5546", "Paraná",
"55343351", "Sacramento\ \-\ MG",
"55544062", "Caxias\ do\ Sul\ \-\ RS",
"55843321", "Mossoró\ \-\ RN",
"55483024", "Florianópolis\ \-\ SC",
"55653529", "Santa\ Rita\ do\ Trivelato\ \-\ MT",
"55853320", "Paramoti\ \-\ CE",
"55413632", "Piên\ \-\ PR",
"55843478", "São\ José\ do\ Seridó\ \-\ RN",
"55833384", "Pocinhos\ \-\ PB",
"55313515", "Belo\ Horizonte\ \-\ MG",
"55513683", "Rio\ Grande\ do\ Sul",
"55713003", "Salvador\ \-\ BA",
"55143879", "Bauru\ \-\ SP",
"55673683", "Rio\ Verde\ de\ Mato\ Grosso\ \-\ MS",
"55313724", "Cristiano\ Otoni\ \-\ MG",
"55913738", "Km\ 12\ \-\ PA",
"55343844", "Grupiara\ \-\ MG",
"55222793", "Macaé\ \-\ RJ",
"55623397", "Rialma\ \-\ GO",
"55833438", "Condado\ \-\ PB",
"55493431", "Xanxerê\ \-\ SC",
"55733297", "Caravelas\ \-\ BA",
"55753213", "Banzaê\ \-\ BA",
"55543534", "Caxias\ do\ Sul\ \-\ RS",
"55513951", "Novo\ Hamburgo\ \-\ RS",
"55633399", "Sucupira\ \-\ TO",
"55883529", "Milhã\ \-\ CE",
"55183375", "Pedrinhas\ Paulista\ \-\ SP",
"55113432", "Carapicuíba\ \-\ SP",
"55313826", "Minas\ Gerais",
"55663527", "Nova\ União\ \-\ MT",
"55913662", "Terra\ Alta\ \-\ PA",
"5511269", "São\ Paulo\ \-\ SP",
"55133387", "Guarujá\ \-\ SP",
"55113129", "São\ Paulo\ \-\ SP",
"55423237", "Piraí\ do\ Sul\ \-\ PR",
"55693651", "Costa\ Marques\ \-\ RO",
"55813448", "Recife\ \-\ PE",
"55653363", "Cuiabá\ \-\ MT",
"55313874", "Minas\ Gerais",
"55773433", "Boa\ Nova\ \-\ BA",
"55833306", "Coxixola\ \-\ PB",
"55743662", "Barra\ \-\ BA",
"55873773", "Lajedo\ \-\ PE",
"55213792", "Duque\ de\ Caxias\ \-\ RJ",
"55553754", "Pinhal\ \-\ RS",
"55883645", "Coreaú\ \-\ CE",
"551", "São\ Paulo",
"55712136", "Salvador\ \-\ BA",
"55633547", "Porto\ Nacional\ \-\ TO",
"55714009", "Salvador\ \-\ BA",
"55313524", "Belo\ Horizonte\ \-\ MG",
"55183321", "Assis\ \-\ SP",
"5561320", "Brasília\ \-\ DF",
"55673292", "Rio\ Verde\ de\ Mato\ Grosso\ \-\ MS",
"55183861", "Irapuru\ \-\ SP",
"55163604", "Ribeirão\ Preto\ \-\ SP",
"5549", "Santa\ Catarina",
"55273237", "Vitória\ \-\ ES",
"55613620", "Luziânia\ \-\ GO",
"55813700", "Caruaru\ \-\ PE",
"55313715", "Cordisburgo\ \-\ MG",
"55115816", "São\ Paulo\ \-\ SP",
"55983362", "Icatu\ \-\ MA",
"55112618", "São\ Paulo\ \-\ SP",
"55222624", "Iguaba\ Grande\ \-\ RJ",
"55313576", "Bonfim\ \-\ MG",
"55873879", "Exu\ \-\ PE",
"55513134", "São\ Leopoldo\ \-\ RS",
"55743538", "Sobradinho\ \-\ BA",
"55473261", "Balneário\ Camboriú\ \-\ SC",
"55443445", "São\ João\ do\ Caiuá\ \-\ PR",
"5544", "Paraná",
"55353856", "Guapé\ \-\ MG",
"55513515", "Porto\ Alegre\ \-\ RS",
"55193363", "Paulínia\ \-\ SP",
"55273259", "Santa\ Teresa\ \-\ ES",
"55193907", "Amparo\ \-\ SP",
"55653631", "Cuiabá\ \-\ MT",
"55853366", "Fortaleza\ \-\ CE",
"55863321", "Parnaíba\ \-\ PI",
"55433047", "Apucarana\ \-\ PR",
"55773449", "Malhada\ de\ Pedras\ \-\ BA",
"55493445", "Abelardo\ Luz\ \-\ SC",
"55513776", "Relvado\ \-\ RS",
"55753612", "Feira\ de\ Santana\ \-\ BA",
"55543351", "David\ Canabarro\ \-\ RS",
"55833556", "São\ Gonçalo\ \-\ PB",
"55333526", "Ataléia\ \-\ MG",
"55744400", "Pilão\ Arcado\ \-\ BA",
"55313683", "Jaboticatubas\ \-\ MG",
"55513724", "Cachoeira\ do\ Sul\ \-\ RS",
"55343212", "Uberlândia\ \-\ MG",
"55153313", "Sorocaba\ \-\ SP",
"55353554", "São\ Pedro\ da\ União\ \-\ MG",
"55353345", "Carvalhos\ \-\ MG",
"55114533", "Jundiaí\ \-\ SP",
"55373383", "Carmo\ da\ Mata\ \-\ MG",
"55833341", "Campina\ Grande\ \-\ PB",
"55493348", "União\ do\ Oeste\ \-\ SC",
"55333202", "Governador\ Valadares\ \-\ MG",
"55633389", "Abreulândia\ \-\ TO",
"55213224", "Rio\ de\ Janeiro\ \-\ RJ",
"55543546", "Faxinalzinho\ \-\ RS",
"55713461", "Salvador\ \-\ BA",
"55123664", "Campos\ do\ Jordão\ \-\ SP",
"55643983", "Itumbiara\ \-\ GO",
"55553331", "Ijuí\ \-\ RS",
"55343836", "São\ João\ da\ Serra\ Negra\ \-\ MG",
"55193573", "Leme\ \-\ SP",
"55543330", "Carazinho\ \-\ RS",
"55423259", "Ventania\ \-\ PR",
"55973423", "Fonte\ Boa\ \-\ AM",
"55643651", "Quirinópolis\ \-\ GO",
"55323371", "São\ João\ Del\ Rei\ \-\ MG",
"55473312", "Timbó\ \-\ SC",
"55194113", "Sumaré\ \-\ SP",
"55613517", "Brasília\ \-\ DF",
"55443460", "Tamboara\ \-\ PR",
"55163347", "Cambaratiba\ \-\ SP",
"55833315", "Campina\ Grande\ \-\ PB",
"55623959", "Niquelândia\ \-\ GO",
"55193893", "Pedreira\ \-\ SP",
"55443283", "Barbosa\ Ferraz\ \-\ PR",
"55123600", "São\ José\ dos\ Campos\ \-\ SP",
"55823643", "Olho\ d\'Água\ do\ Casado\ \-\ AL",
"55343633", "Tapira\ \-\ MG",
"55543232", "Vacaria\ \-\ RS",
"55153278", "Pilar\ do\ Sul\ \-\ SP",
"55313850", "Minas\ Gerais",
"55513679", "Sentinela\ do\ Sul\ \-\ RS",
"55143883", "Bofete\ \-\ SP",
"55653492", "Ouro\ Branco\ \(Antiga\ Raposolândia\)\ \-\ MT",
"55413405", "São\ José\ dos\ Pinhais\ \-\ PR",
"55333745", "Joaíma\ \-\ MG",
"55444007", "Maringá\ \-\ PR",
"55883660", "Cruz\ \-\ CE",
"55313831", "Itabira\ \-\ MG",
"55193482", "Águas\ de\ São\ Pedro\ \-\ SP",
"55193674", "Casa\ Branca\ \-\ SP",
"55443209", "Nova\ Esperança\ \-\ PR",
"55323751", "Tombos\ \-\ MG",
"55713118", "Salvador\ \-\ BA",
"55673541", "Bataguassu\ \-\ MS",
"55553252", "São\ Francisco\ de\ Assis\ \-\ RS",
"55513380", "Rio\ Grande\ do\ Sul",
"55313886", "Diogo\ de\ Vasconcelos\ \-\ MG",
"55513541", "Taquara\ \-\ RS",
"55163353", "Ibaté\ \-\ SP",
"5595", "Roraima",
"55353653", "Conceição\ dos\ Ouros\ \-\ MG",
"55313535", "Mateus\ Leme\ \-\ MG",
"55193626", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55114634", "Poá\ \-\ SP",
"55213030", "Rio\ de\ Janeiro\ \-\ RJ",
"55893555", "Arraial\ \-\ PI",
"55913466", "Marudá\ \-\ PA",
"55484004", "Florianópolis\ \-\ SC",
"55113636", "São\ Paulo\ \-\ SP",
"55433267", "São\ Jerônimo\ da\ Serra\ \-\ PR",
"55143492", "Vera\ Cruz\ \-\ SP",
"55183911", "Eneida\ \-\ SP",
"55133258", "Santos\ \-\ SP",
"55283548", "Irupi\ \-\ ES",
"55823131", "Maceió\ \-\ AL",
"55513735", "Várzea\ do\ Capivarita\ \-\ RS",
"55113377", "São\ Paulo\ \-\ SP",
"55373323", "Pains\ \-\ MG",
"55313896", "Pedra\ do\ Anta\ \-\ MG",
"55193809", "Hortolândia\ \-\ SP",
"55663597", "Nova\ Monte\ Verde\ \-\ MT",
"55993118", "Timon\ \-\ MA",
"55813311", "Ipojuca\ \-\ PE",
"55114819", "Franco\ da\ Rocha\ \-\ SP",
"55923328", "Rio\ Preto\ da\ Eva\ \-\ AM",
"55473041", "Blumenau\ \-\ SC",
"55843555", "Pedra\ Grande\ \-\ RN",
"55163660", "Batatais\ \-\ SP",
"55542108", "Caxias\ do\ Sul\ \-\ RS",
"55193492", "Capivari\ \-\ SP",
"55323334", "Santana\ do\ Garambéu\ \-\ MG",
"55163977", "Ribeirão\ Preto\ \-\ SP",
"55973483", "Envira\ \-\ AM",
"55623513", "Nerópolis\ \-\ GO",
"55553326", "Cruz\ Alta\ \-\ RS",
"55983483", "Magalhães\ de\ Almeida\ \-\ MA",
"55993073", "Imperatriz\ \-\ MA",
"55454009", "Cascavel\ \-\ PR",
"55343821", "Patos\ de\ Minas\ \-\ MG",
"55123107", "Areias\ \-\ SP",
"55633654", "Taguatinga\ \-\ TO",
"55544052", "Passo\ Fundo\ \-\ RS",
"55653028", "Cuiabá\ \-\ MT",
"55433401", "Cornélio\ Procópio\ \-\ PR",
"55313741", "Ouro\ Branco\ \-\ MG",
"55813647", "Buenos\ Aires\ \-\ PE",
"55653626", "Cuiabá\ \-\ MT",
"55193883", "Sumaré\ \-\ SP",
"55114695", "Guararema\ \-\ SP",
"55123957", "São\ Silvestre\ \-\ SP",
"55813653", "Lagoa\ do\ Itaenga\ \-\ PE",
"55313623", "São\ José\ da\ Lapa\ \-\ MG",
"55333531", "Caraí\ \-\ MG",
"55883611", "Sobral\ \-\ CE",
"55623937", "Anápolis\ \-\ GO",
"55513784", "Mato\ Leitão\ \-\ RS",
"55753249", "Tanquinho\ \-\ BA",
"55222779", "Conceição\ de\ Macabu\ \-\ RJ",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+55|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      my $prefix = qr/^(?:(?:0|90)(?:(1[245]|2[1-35]|31|4[13]|[56]5|99)(\d{10,11}))?)/;
      my @matches = $number =~ /$prefix/;
      if (defined $matches[-1]) {
        no warnings 'uninitialized';
        $number =~ s/$prefix/$2/;
      }
      else {
        $number =~ s/$prefix//;
      }
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;