/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.vcs.log.CommitId;
import org.jetbrains.annotations.NotNull;

public class CommitIdByStringCondition implements Condition<CommitId> {
  @NotNull private final String myHashString;

  public CommitIdByStringCondition(@NotNull String hashString) {
    myHashString = hashString;
  }

  @Override
  public boolean value(CommitId commitId) {
    return StringUtil.startsWithIgnoreCase(commitId.getHash().asString(), myHashString);
  }
}
