/*************************************************************************
 * config.c configuration and CMD line reading [part of AVInfo 1.x]
 *
 * Copyright (c) 2003 George Shuklin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *   
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *   
 * You should have received a copy of the GNU General Public License along
 * with this program (see the file COPYING); if not, write to the Free 
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307  USA  or visit http://www.gnu.org/copyleft/gpl.html
 *
 *************************************************************************/
 
#include "avinfo.h"

typedef struct{
	char* tpl_name;
	int maxlength;
	int moduleoption;
	char* head;
	char* template;
	char* foot;
}template_list_t;



template_list_t template_list[]=
#include "tpls"
/*include preprocessed templates from tpls/tpls.ass */

const char* version_message =
AVINFO_SIGNATURE " " AVINFO_VERSION " " AVINFO_SUBNAME "\n\n"
"(c) George Shuklin, 2001-2004, http://shounen.ru/soft/avinfo/\n\
This is free software. You are welcome to redistribute it under\n\
the terms and conditions of GNU General Public License.";

const char* help_message="\
Usage:\t avinfo [FILENAME] [OPTIONS] [TEMPLATE] [OUTPUT]\n\
 or:  \t avinfo [-l=FILELIST] [OPTIONS] [TEMPLATE] [OUTPUT]\n\
 or:  \t avinfo -l- [OPTIONS] [TEMPLATE] [OUTPUT]\n\
 or:  \t avinfo [--help | --version]\n\
Extracts information from FILENAME or files in FILELIST and generates a report.\n\
\n\
OPTIONS:\n\
\t-f=extension   forces the use of module associated with extension\n\
\t-l=list        use filelist (use -l- for stdin)\n\
\t-i=ms          delay between files in filelist (in ms) (/*TODO*/)\n\
\t-e=ext         exclude an extension (do not apply associated module)\n\
\t-m=number      max line length (0 - no restriction)\n\
\t-s=value       for advanced tuning of modules (/*TODO*/)\n\
\t-v=name=value  set int. variable 'name' to 'value' (text or number)\n\
\n\
External TEMPLATEs:\n\
\t-th=template   header template (string, use without value to disable)\n\
\t-thf=filename  get header template from a file\n\
\t-tb=template   body template (string, use without value to disable)\n\
\t-tbf=filename  get body template from a file\n\
\t-tf=template   footer template (string, use without value to disable)\n\
\t-tff=filename  get footer template from a file\n\
\n\
Built-in TEMPLATEs:\n\
\t--default      used by default\n\
\t--description  for creating (updating) descrpipt.ion files\n\
\t--list         for filelist (plain text) generation\n\
\t--html-list    for filelist (html) generation\n\
\t--csv-list     for filelist (CSV, e.g. for Excel)\n\
\t--short        alt. version of --default template\n\
\t--far          \"nice\" formated report (for FAR Manager)\n\
\t               (contains MS-DOS pseudographic characters)\n\
\n\
OUTPUT:\n\
\t-o=file        file to write the report to (default is stdout)\n\
\n\
Other OPTIONS:\n\
\t--help         prints this help page\n\
\t--version      prints avinfo version and copyright\n\
\n\
You can use ':' instead of '=' in all OPTIONS or just omit it.\n\
TEMPLATEs use AVInfo Simple Script (A.S.S.) syntax.\n\
\n\
Examples of commands:\n\
avinfo file.ogm --raw\n\
find . -name '*.avi' -print | avinfo -l- --html-list -o=avilist.html\n\
avinfo -l:list -thf:header -tbf=body -tff=footer >report\n\
";

typedef struct{
	char* name;
	int value;
}constants_t;

void ImportConstants(){
	const constants_t consts[]={
		{"AVInfo",10006},
		{"m1000",PRINT_MODE_M1000},
		{"m1024",PRINT_MODE_M1024},
		{"hex",PRINT_MODE_HEX},
		{"fcc",PRINT_MODE_FCC},
		{"ct",PRINT_MODE_COMPACT_TIME},
		{"sn",PRINT_MODE_SHORT_NAME},
		{"time",PRINT_MODE_TIME},
		{"cn", PRINT_MODE_CODEC_NAME},
		{"maxlist",77},
		{"sotona",0x29A},
		{"DIV3",FOURCC_DIV3},
		{"XVID",FOURCC_XVID},
		{"DIVX",FOURCC_DIVX},
		{"DX50",FOURCC_DX50}
	};
	int c;
	for (c=0;c<sizeof(consts)/sizeof(constants_t);c++)
		SetNumericVar(consts[c].name,consts[c].value);
}

int NamePrepare(const char* in){
	int c=strlen(in);
	int ext_found=0;
	int name=1;
	while(c&&name){
		if(in[c]=='.'&&!ext_found&&name){ /*extenshion found*/
			SetStringVar("ext",dup(in+c+1));
			ext_found=1;	
		}
		if((in[c]=='/'||in[c]==':'||in[c]=='\\')&&name){
			name=0;
			SetStringVar("name",dup(in+c+1));
			break;
		}
		c--;
	}
	if(name)SetStringVar("name",dup(in));
	if(!ext_found) SetStringVar("ext",dup("")); 
	return 0;
}


#define MAX_CONF_FILE_SIZE 65536

char* GetOptFromFile(char* filename){
    FILE* OptFile;
    int size=0;
    char* buffer=NULL;
    int readed=0;
	if (!filename)return NULL;
	OptFile=fopen(filename,"r");
	if(!OptFile){
		fprintf(stderr,"Erorr opening template file %s, default will be used.\n",filename);
		return NULL;
	}
	fseek(OptFile,0,SEEK_END);
	size=ftell(OptFile);
	fseek(OptFile,0,SEEK_SET);
	if(!size) { /*zero lenght file is not a bug, but a feature*/
		fclose(OptFile);
		buffer=malloc(1);
		*buffer=0;
		return buffer;
	}
	if(size>MAX_CONF_FILE_SIZE){
		fprintf(stderr,"Template file %s too large (>64k). Loaded parially.\n",filename);
		size=65536;
	}
	buffer=malloc(size+1);
	readed=fread(buffer,1,size,OptFile);
	if(!readed){
		fprintf(stderr,"Error loading %s template, %d readed\n",filename,readed);
		fclose(OptFile);
		FREE(buffer);
		return NULL;
	}
	fclose(OptFile);
	buffer[size]=0;
	return buffer;
}

int SetConfig(int argc, char* argv[]){
/* reading command line parameters*/
	char* tpl_name="default";
	char* tmp_buff=NULL;
	char* filelist=NULL;
	int t_h_flag=0;
	int t_f_flag=0;
	int t_b_flag=0;
	int flag=0;
	int c;/*just a counter*/
	int c2;
	int maxlength=-1;
	int moduleoption=0;
	int temp=0;
	char* templine;
/**************** patched here ******************/
	/* does anybody really need that "error in command line" message
	   in the situation below? I think nobody needs that... */	
	/* if(argc<2) return puts(help_message); */
	if(argc<2 || strcmp("--help", argv[1]) == 0)
	    {
		puts(help_message);
		return 0;
	    }
	/* every good program must respond to --help and --version
	   A dirty hack could be to implement them as templates :) but 
	   that will probably insult Gosha Shuklin to death ;) */
	if(argc==2 && strcmp("--version", argv[1]) == 0)
	    {
		puts(version_message);
		return 0;
	    }
/*************************************************/
	ImportConstants();
	for(c=1;c<argc;c++){
		if(argv[c][0]=='-'){ /*param*/
			switch(argv[c][1]){
				case 'e':
					if(argv[c][2]==':' || argv[c][2]=='=') temp=3; else temp=2;
					SetStringVar("ignore",dup(argv[c]+temp));
					break;
				case 'f':
					if(argv[c][2]==':'||argv[c][2]=='=')temp=3; else temp=2;
					SetStringVar("force_ext",dup(argv[c]+temp));
					break;
				case 'l':
					if(argv[c][2]==':'||argv[c][2]=='=')
						filelist=argv[c]+3;
					else filelist=argv[c]+2;
					break;
				case 'm':
					if(argv[c][2]=='='||argv[c][2]==':') temp=3;
					if(isdigit(argv[c][2])) temp=2;
					if(temp==3||temp==2) maxlength=atoi(argv[c]+temp);
					break;
				case 'i':
					if(argv[c][2]=='='||argv[c][2]==':') temp=3;
					if(isdigit(argv[c][2])) temp=2;
					if(temp==3||temp==2) SetNumericVar("wait",atoi(argv[c]+temp));
					break;
				case 's':
					if(argv[c][2]=='='||argv[c][2]==':') temp=3;
					if(isdigit(argv[c][2])) temp=2;
					if(temp==2||temp==3) moduleoption=atoi(argv[c]+temp);
					break;
				case 'v':
					if(argv[c][2]=='='||argv[c][2]==':') temp=3; else temp=2;
					c2=temp;
					while(argv[c][c2]!='='&&argv[c][c2]) c2++;
					tmp_buff=malloc(c2-temp+1);
					if(!tmp_buff) return 0;
					memcpy(tmp_buff, argv[c]+temp,c2-temp);
					tmp_buff[c2-temp]=0;
					if(isdigit(argv[c][c2+1])) SetNumericVar(tmp_buff,atoi(argv[c]+c2+1));
						else SetStringVar(tmp_buff,dup(argv[c]+c2+1));
					free(tmp_buff);
					break;
				case 'o':
					if(argv[c][2]=='='||argv[c][2]==':') temp=3; else temp=2;
					SetStringVar("output",argv[c]+temp);
					break;
				case '-':tpl_name=argv[c]+2;
					break;
				case 't':
				    templine=0;
				    temp=3;
					if(argv[c][2]=='b'||argv[c][2]=='h'||argv[c][2]=='f'){
						if(argv[c][3]=='f'){
							if(argv[c][4]==':'||argv[c][4]=='=') temp=5;else temp=4;
                           	templine=GetOptFromFile(argv[c]+temp);
                           	if(!templine) break;
						}
					}
					if(argv[c][3]=='='||argv[c][3]==':') temp=4;
					switch(argv[c][2]){
						case 'b':
							t_b_flag=1;
							SetStringVar("template",templine?templine:dup(argv[c]+temp));
							break;
						case 'h':t_h_flag=1;
							SetStringVar("tplhead",templine?templine:dup(argv[c]+temp));
							break;
						case 'f':t_f_flag=1;
							SetStringVar("tplfoot",templine?templine:dup(argv[c]+temp));
							break;
					}
				break;
			}
		}else{
			SetStringVar("in",dup(argv[c]));
		}
	}
	for(c=0;c<sizeof(template_list)/sizeof(template_list_t);c++){
		if(!STRCMP(template_list[c].tpl_name,tpl_name)){
			if(!t_b_flag) SetStringVar("template", dup(template_list[c].template));
			SetNumericVar("linelength",(maxlength==-1)?template_list[c].maxlength:maxlength);
			if(!t_h_flag) SetStringVar("tplhead",dup(template_list[c].head));
			if(!t_f_flag) SetStringVar("tplfoot",dup(template_list[c].foot));
			if(!moduleoption) moduleoption=template_list[c].moduleoption;
			SetNumericVar("moduleoption",moduleoption);
		    flag=1;
		}
	}
	if(!flag) {
		SetStringVar("template",dup(template_list[0].template)); /*use default template*/
	}
	if(filelist) SetStringVar("filelist",dup(filelist));
	return 0;
}
