//
// This file is part of the aMule AdunanzA Project (mod of official aMule)
//
// Copyright (c) 2003-2012 aMule AdunanzA Team ( http://www.adunanza.net )
//
// Any parts of this program derived from the xMule, lMule, eMule or aMule project,
// or contributed by third-party developers are copyrighted by their
// respective authors.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA
//

#if !defined(_ADUNANZA_STREAMING_H_)
#define _ADUNANZA_STREAMING_H_


#if !defined(CLIENT_GUI)
#include <list>
#include "Types.h" // needed for uint16

class CPartFile;


class CAdunanzAStreaming
{
public:
	enum statuses
	{
		None,        /*!< None / unknown status / stopped */
		Requesting,  /*!< a request has been issued but not all steps has been fully executed, so it it not yet "requested" */
		Requested,   /*!< a streaming request has been issued */
		Ready,       /*!< a file is ready for streaming play */
		Started,     /*!< streaming running */
	};


public:
	statuses                m_status;                  /*!< current status */
	std::list<CPartFile*>   m_suspendedDownloads;      /*!< list of PartFile suspended and to resume after a stop */
	CPartFile*              m_pTargetFile;             /*!< file target of streaming playing */
	int                     m_originalTargetPriority;  /*!< priority of target before streaming request, to restore at end of streaming */
	uint16                  m_lastConsecutiveCompletePart; /*!< index of last complete chunk in a series of consecutive complete chunks */
	uint16                  m_requiredParts;              /*!< minimum number of consecutive chunks needed for preview (corresponds to percentage in preferences) */
public:
	void updateLastConsecutiveCompletePart();

	inline uint16 getLastConsecutiveCompletePart() const {return m_lastConsecutiveCompletePart;}

	inline uint16 updateAndGetLastConsecutiveCompletePart() { updateLastConsecutiveCompletePart(); return getLastConsecutiveCompletePart();}

	CAdunanzAStreaming()
	{
		m_status = CAdunanzAStreaming::None;
		m_pTargetFile = 0;
		m_originalTargetPriority = -1;
		m_lastConsecutiveCompletePart = 0;
	}

	void resumeAllSuspended();

	void stop();

	virtual ~CAdunanzAStreaming()
	{
		stop();
	}

	inline bool canStart() const
	{
		return (m_status == CAdunanzAStreaming::Ready);
	}

	bool start();

	bool canRequest(const CPartFile* pCandidateTarget) const;

	bool request(CPartFile* pTarget, std::list<CPartFile*>& downloadingList);
	bool request(CPartFile* pTarget);

	void checkForReady();


	void checkForStop();

	// helper function for CPartFile
	inline bool isPreviewEnable(const CPartFile* p) const
	{
		return (p && (m_status != CAdunanzAStreaming::None) && p == (const CPartFile*) m_pTargetFile);

	}

protected:
	// abilita/disabilita capo e bottone per immissione rapida link Ed2k
	static void enableFastEd2kLinks(bool bEnable);
  

};

#endif


#endif

