/*
 * Copyright (C) 2009 Andreas Steffen
 * Hochschule fuer Technik Rapperswil
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the Licenseor (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 *
 * This program is distributed in the hope that it will be usefulbut
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 */

#include <crypto/crypto_tester.h>

/**
 * All testvectors from https://www.cosic.esat.kuleuven.be/nessie/testvectors/
 */

/**
 * Camellia 128 bit: set 8, vector #0
 */
crypter_test_vector_t camellia_cbc1 = {
	.alg = ENCR_CAMELLIA_CBC, .key_size = 16, .len = 16,
	.key	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0A\x0B\x0C\x0D\x0E\x0F",
	.iv		= "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
	.plain	= "\x41\x0E\x33\xF3\x16\xDF\x4A\x72\xAA\x2B\xCD\x41\x14\xE2\x31\x4D",
	.cipher	= "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xAA\xBB\xCC\xDD\xEE\xFF"
};

/**
 * Camellia 128 bit: set 8, vector #1
 */
crypter_test_vector_t camellia_cbc2 = {
	.alg = ENCR_CAMELLIA_CBC, .key_size = 16, .len = 16,
	.key	= "\x2B\xD6\x45\x9F\x82\xC5\xB3\x00\x95\x2C\x49\x10\x48\x81\xFF\x48",
	.iv		= "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
	.plain	= "\x78\x35\x78\x66\xFD\x8B\x2C\xAE\xD4\xD1\xBB\xA3\xCF\xD5\x34\x0A",
	.cipher	= "\xEA\x02\x47\x14\xAD\x5C\x4D\x84\xEA\x02\x47\x14\xAD\x5C\x4D\x84"
};

/**
 * Camellia 192 bit: set 8, vector #0
 */
crypter_test_vector_t camellia_cbc3 = {
	.alg = ENCR_CAMELLIA_CBC, .key_size = 24, .len = 16,
	.key	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0A\x0B\x0C\x0D\x0E\x0F"
			  "\x10\x11\x12\x13\x14\x15\x16\x17",
	.iv		= "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
	.plain	= "\x94\x1A\xC6\x45\x3C\x3F\x48\xA1\x69\xC2\xF4\xFE\x2B\xBE\x55\x32",
	.cipher	= "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xAA\xBB\xCC\xDD\xEE\xFF"
};

/**
 * Camellia 192 bit: set 8, vector #1
 */
crypter_test_vector_t camellia_cbc4 = {
	.alg = ENCR_CAMELLIA_CBC, .key_size = 24, .len = 16,
	.key	= "\x2B\xD6\x45\x9F\x82\xC5\xB3\x00\x95\x2C\x49\x10\x48\x81\xFF\x48"
			  "\x2B\xD6\x45\x9F\x82\xC5\xB3\x00",
	.iv		= "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
	.plain	= "\x29\x2C\x5B\xBF\xD7\x72\xAD\x27\x95\x09\x12\x0F\x3F\x0A\xCD\x48",
	.cipher	= "\xEA\x02\x47\x14\xAD\x5C\x4D\x84\xEA\x02\x47\x14\xAD\x5C\x4D\x84"
};

/**
 * Camellia 256 bit: set 8, vector #0
 */
crypter_test_vector_t camellia_cbc5 = {
	.alg = ENCR_CAMELLIA_CBC, .key_size = 32, .len = 16,
	.key	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0A\x0B\x0C\x0D\x0E\x0F"
			  "\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1A\x1B\x1C\x1D\x1E\x1F",
	.iv		= "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
	.plain	= "\x06\x36\x9B\x36\x08\xAE\x43\xCA\x79\xC8\x8B\xCF\x49\x7F\x67\x71",
	.cipher	= "\x00\x11\x22\x33\x44\x55\x66\x77\x88\x99\xAA\xBB\xCC\xDD\xEE\xFF"
};

/**
 * Camellia 256 bit: set 8, vector #1
 */
crypter_test_vector_t camellia_cbc6 = {
	.alg = ENCR_CAMELLIA_CBC, .key_size = 32, .len = 16,
	.key	= "\x2B\xD6\x45\x9F\x82\xC5\xB3\x00\x95\x2C\x49\x10\x48\x81\xFF\x48"
			  "\x2B\xD6\x45\x9F\x82\xC5\xB3\x00\x95\x2C\x49\x10\x48\x81\xFF\x48",
	.iv		= "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
	.plain	= "\xE6\x84\x42\x17\x16\xFC\x0B\x01\xAE\xB5\xC6\x76\x51\x20\xF9\x5F",
	.cipher	= "\xEA\x02\x47\x14\xAD\x5C\x4D\x84\xEA\x02\x47\x14\xAD\x5C\x4D\x84"
};

