/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.tree.ElementImpl;

public class Stripper
extends ProxyReceiver {
    private boolean preserveAll;
    private boolean stripAll;
    private byte[] stripStack = new byte[100];
    private int top = 0;
    private Mode stripperMode;
    private ElementImpl element = new ElementImpl();
    private Controller controller;
    private NamePool namePool;
    private int xmlSpaceCode;
    public static final byte ALWAYS_PRESERVE = 1;
    public static final byte ALWAYS_STRIP = 2;
    public static final byte STRIP_DEFAULT = 0;
    public static final byte PRESERVE_PARENT = 4;

    protected Stripper() {
    }

    public Stripper(Mode mode) {
        this.stripperMode = mode;
        this.preserveAll = mode == null;
        this.stripAll = false;
    }

    public Stripper getAnother() {
        Stripper stripper = new Stripper(this.stripperMode);
        stripper.setController(this.controller);
        stripper.stripAll = this.stripAll;
        stripper.preserveAll = this.preserveAll;
        return stripper;
    }

    public void setStripAll() {
        this.preserveAll = false;
        this.stripAll = true;
    }

    public boolean getStripAll() {
        return this.stripAll;
    }

    public void setController(Controller controller) {
        this.controller = controller;
        this.namePool = controller.getNamePool();
        this.xmlSpaceCode = this.namePool.allocate("xml", "http://www.w3.org/XML/1998/namespace", "space");
    }

    public byte isSpacePreserving(int n) {
        try {
            if (this.preserveAll) {
                return 1;
            }
            if (this.stripAll) {
                return 0;
            }
            this.element.setNameCode(n);
            Object object = this.stripperMode.getRule(this.element, this.controller);
            if (object == null) {
                return 1;
            }
            return (Boolean)object != false ? (byte)1 : 0;
        }
        catch (TransformerException transformerException) {
            return 1;
        }
    }

    public byte isSpacePreserving(NodeInfo nodeInfo) {
        try {
            if (this.preserveAll) {
                return 1;
            }
            if (this.stripAll) {
                return 0;
            }
            Object object = this.stripperMode.getRule(nodeInfo, this.controller);
            if (object == null) {
                return 1;
            }
            return (Boolean)object != false ? (byte)1 : 0;
        }
        catch (TransformerException transformerException) {
            return 1;
        }
    }

    public void startDocument() throws TransformerException {
        this.top = 0;
        this.stripStack[this.top] = 1;
        super.startDocument();
    }

    public void startElement(int n, int n2, int n3) throws TransformerException {
        super.startElement(n, n2, n3);
        byte by = this.stripStack[this.top];
        byte by2 = (byte)(by & 4);
        if (this.isSpacePreserving(n) == 1) {
            by2 = (byte)(by2 | 1);
        }
        ++this.top;
        if (this.top >= this.stripStack.length) {
            byte[] byArray = new byte[this.top * 2];
            System.arraycopy(this.stripStack, 0, byArray, 0, this.top);
            this.stripStack = byArray;
        }
        this.stripStack[this.top] = by2;
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3) throws TransformerException {
        if (n == this.xmlSpaceCode && charSequence.equals("preserve")) {
            int n4 = this.top;
            this.stripStack[n4] = (byte)(this.stripStack[n4] | 4);
        }
        super.attribute(n, n2, charSequence, n3);
    }

    public void endElement() throws TransformerException {
        super.endElement();
        --this.top;
    }

    public void characters(CharSequence charSequence, int n) throws TransformerException {
        if (!(charSequence.length() <= 0 || this.stripStack[this.top] == 0 && Navigator.isWhite(charSequence) || (this.stripStack[this.top] & 2) != 0)) {
            super.characters(charSequence, n);
        }
    }
}

