-- C23006E.ADA

--                             Grant of Unlimited Rights
--
--     Under contracts F33600-87-D-0337, F33600-84-D-0280, MDA903-79-C-0687,
--     F08630-91-C-0015, and DCA100-97-D-0025, the U.S. Government obtained 
--     unlimited rights in the software and documentation contained herein.
--     Unlimited rights are defined in DFAR 252.227-7013(a)(19).  By making 
--     this public release, the Government intends to confer upon all 
--     recipients unlimited rights  equal to those held by the Government.  
--     These rights include rights to use, duplicate, release or disclose the 
--     released technical data and computer software in whole or in part, in 
--     any manner and for any purpose whatsoever, and to have or permit others 
--     to do so.
--
--                                    DISCLAIMER
--
--     ALL MATERIALS OR INFORMATION HEREIN RELEASED, MADE AVAILABLE OR
--     DISCLOSED ARE AS IS.  THE GOVERNMENT MAKES NO EXPRESS OR IMPLIED 
--     WARRANTY AS TO ANY MATTER WHATSOEVER, INCLUDING THE CONDITIONS OF THE
--     SOFTWARE, DOCUMENTATION OR OTHER INFORMATION RELEASED, MADE AVAILABLE 
--     OR DISCLOSED, OR THE OWNERSHIP, MERCHANTABILITY, OR FITNESS FOR A
--     PARTICULAR PURPOSE OF SAID MATERIAL.
--*
-- CHECK THAT UNDERSCORES ARE SIGNIFICANT IN THE NAMES OF GENERIC
-- LIBRARY UNIT SUBPROGRAMS.

-- JBG 5/26/85

GENERIC
PROCEDURE C23006E_PROC (X : OUT INTEGER);

PROCEDURE C23006E_PROC (X : OUT INTEGER) IS
BEGIN
     X := 1;
END C23006E_PROC;

GENERIC
PROCEDURE C230063PROC (X : OUT INTEGER);

PROCEDURE C230063PROC (X : OUT INTEGER) IS
BEGIN
     X := 2;
END C230063PROC;

GENERIC
FUNCTION C23006E_GFUNC RETURN INTEGER;

FUNCTION C23006E_GFUNC RETURN INTEGER IS
BEGIN
     RETURN 3;
END C23006E_GFUNC;

GENERIC
FUNCTION C23006EGFUNC RETURN INTEGER;

WITH REPORT; USE REPORT;
PRAGMA ELABORATE (REPORT);
FUNCTION C23006EGFUNC RETURN INTEGER IS
BEGIN
     RETURN IDENT_INT(4);
END C23006EGFUNC;

WITH C23006E_PROC;
PRAGMA ELABORATE (C23006E_PROC);
PROCEDURE P1 IS NEW C23006E_PROC;

WITH C23006E_GFUNC;
PRAGMA ELABORATE (C23006E_GFUNC);
FUNCTION F1 IS NEW C23006E_GFUNC;

WITH P1, F1, C230063PROC, C23006EGFUNC;
WITH REPORT; USE REPORT;
PROCEDURE C23006E IS

     X1, X2 : INTEGER;
     PROCEDURE P2 IS NEW C230063PROC;
     FUNCTION F2 IS NEW C23006EGFUNC;

BEGIN
     TEST ("C23006E", "CHECK UNDERSCORES ARE SIGNIFICANT " &
                      "FOR GENERIC LIBRARY SUBPROGRAM IDENTIFIERS");

     P1 (X1);
     P2 (X2);
     IF X1 + IDENT_INT(1) /= X2 THEN
          FAILED ("INCORRECT PROCEDURE IDENTIFICATION");
     END IF;

     IF F1 + IDENT_INT(1) /= F2 THEN
          FAILED ("INCORRECT FUNCTION IDENTIFICATION");
     END IF;

     RESULT;
END C23006E; 
